Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列定义
	this.columns = [
		{
			title: t('ns_domains_groups_indexJs@分组名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('ns_domains_groups_indexJs@状态'),
			dataIndex: 'isOn',
			key: 'isOn',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('ns_domains_groups_indexJs@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '120px',
			align: 'center'
		}
	];

	this.createGroup = function () {
		teaweb.popup("/ns/domains/groups/createPopup", {
			title: t('ns_domains_groups_indexJs@创建分组PopupTitle'),
			callback: function () {
				teaweb.successRefresh(t("ns_domains_groups_indexJs@保存成功"))
			}
		})
	}

	this.updateGroup = function (groupId) {
		teaweb.popup("/ns/domains/groups/group/updatePopup?groupId=" + groupId, {
			title: t('ns_domains_groups_indexJs@修改分组PopupTitle'),
			callback: function () {
				teaweb.successRefresh(t("ns_domains_groups_indexJs@保存成功"))
			}
		})
	}

	this.deleteGroup = function (groupId) {
		let that = this
		teaweb.confirm(t("ns_domains_groups_indexJs@确定删除分组"), function () {
			that.$post("/ns/domains/groups/group/delete")
				.params({
					groupId: groupId
				})
				.success(function () {
					teaweb.successRefresh(t("ns_domains_groups_indexJs@删除成功"))
				})
		})
	}
})