Tea.context(function () {
	const t = this.t.bind(this);
	this.isStarting = false
	this.startNode = function () {
		this.isStarting = true
		this.$post("/ns/clusters/cluster/node/start")
			.params({
				nodeId: this.node.id
			})
			.success(function () {
				teaweb.success(t('node_indexJS@启动成功'), function () {
					teaweb.reload()
				})
			})
			.done(function () {
				this.isStarting = false
			})
	}

	this.isStopping = false
	this.stopNode = function () {
		this.isStopping = true
		this.$post("/ns/clusters/cluster/node/stop")
			.params({
				nodeId: this.node.id
			})
			.success(function () {
				teaweb.success(t('node_indexJS@执行成功'), function () {
					teaweb.reload()
				})
			})
			.done(function () {
				this.isStopping = false
			})
	}

	this.round = function (f) {
		return Math.round(f * 100) / 100
	}
})