Tea.context(function () {
	const t = this.t.bind(this);

	// 显示的统计项
	this.windowWidth = window.innerWidth
	this.miniWidth = 760
	this.columnWidth1 = 750
	this.columnWidth2 = 850
	this.columnWidth3 = 950
	this.columnWidth4 = 1050
	this.columnWidth5 = 1100

	let that = this
	window.addEventListener("resize", function () {
		that.windowWidth = window.innerWidth
	})

	// 表格列定义
	this.columns = [
		{
			title: t('cluster_indexJS@节点名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('cluster_indexJS@IP'),
			key: 'ip',
			scopedSlots: { customRender: 'ipSlot' },
			width: '25%' // 根据原表格 four wide 估算
		},
		{
			title: t('cluster_indexJS@CPU'),
			key: 'cpu',
			scopedSlots: { customRender: 'cpuSlot' },
			width: '8em', // 估算宽度
			align: 'center'
		},
		{
			title: t('cluster_indexJS@内存'),
			key: 'memory',
			scopedSlots: { customRender: 'memorySlot' },
			width: '8em', // 估算宽度
			align: 'center'
		},
		{
			title: t('cluster_indexJS@负载'),
			key: 'load',
			scopedSlots: { customRender: 'loadSlot' },
			width: '8em', // 估算宽度
			align: 'center'
		},
		{
			title: t('cluster_indexJS@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '10em', // 根据原表格 two wide 估算
			align: 'center'
		},
		{
			title: t('cluster_indexJS@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '8em', // 根据原表格 two op 估算
			align: 'center'
		}
	];

	this.$delay(function () {
		this.checkPorts()
	})

	this.deleteNode = function (nodeId) {
		teaweb.confirm(t('cluster_indexJS@确定要删除这个节点吗'), function () {
			this.$post("/ns/clusters/cluster/deleteNode")
				.params({
					nodeId: nodeId
				})
				.refresh();
		})
	}

	this.upNode = function (nodeId) {
		teaweb.confirm(t('cluster_indexJS@确定要手动上线此节点吗'), function () {
			this.$post("/ns/clusters/cluster/node/up")
				.params({
					nodeId: nodeId
				})
				.refresh()
		})
	}

	let checkingPort = ""
	this.checkPorts = function () {
		let ipList = []
		this.nodes.forEach(function (node) {
			if (node.isOn) {
				if (node.ipAddresses != null && node.ipAddresses.length > 0) {
					node.ipAddresses.forEach(function (addr) {
						if (addr.isOn && addr.canAccess && addr.isUp && addr.ip.length > 0 && !ipList.$contains(addr.ip)) {
							ipList.push(addr.ip)
						}
					})
				}
			}
		})
		if (ipList.length > 0) {
			this.$post(".checkPorts")
				.params({
					clusterId: this.clusterId,
					ip: ipList
				})
				.success(function (resp) {
					let results = resp.data.results
					if (results.length > 0) {
						checkingPort = resp.data.port
						let errorMap = {}
						let hasErrors = false
						results.forEach(function (result) {
							if (!result.isOk) {
								errorMap[result.ip] = result
								hasErrors = true
							}
						})

						if (hasErrors) {
							this.nodes.forEach(function (node) {
								if (node.isOn) {
									if (node.ipAddresses != null && node.ipAddresses.length > 0) {
										node.ipAddresses.forEach(function (addr, index) {
											if (addr.isOn && addr.canAccess && addr.isUp && addr.ip.length > 0) {
												if (typeof errorMap[addr.ip] == "object") {
													addr.hasError = true
													addr.err = errorMap[addr.ip].err
													Vue.set(node.ipAddresses, index, addr)
												}
											}
										})
									}
								}
							})
						}
					}
				})
		}
	}

	this.showPortError = function (addr) {
		teaweb.popupTip(t('cluster_indexJS@端口连接错误提示', [addr.ip, checkingPort, addr.err]));
	}
})