Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列定义
	this.columns = [
		{
			title: t('ns_clusters_accessLogs_index@集群Col'),
			key: 'cluster',
			scopedSlots: { customRender: 'clusterSlot' },
			width: '150px' // 大约 two wide
		},
		{
			title: t('ns_clusters_accessLogs_index@节点Col'),
			key: 'node',
			scopedSlots: { customRender: 'nodeSlot' },
			width: '150px' // 大约 two wide
		},
		{
			title: t('ns_clusters_accessLogs_index@域名Col'),
			key: 'domain',
			scopedSlots: { customRender: 'domainSlot' },
			width: '150px' // 大约 two wide
		},
		{
			title: t('ns_clusters_accessLogs_index@类型Col'),
			key: 'questionType',
			scopedSlots: { customRender: 'questionTypeSlot' },
			width: '100px' // 大约 6em
		},
		{
			title: t('ns_clusters_accessLogs_index@概要Col'),
			key: 'summary',
			scopedSlots: { customRender: 'summarySlot' },
			// 剩余宽度，自适应
		}
	];

	let that = this
	this.accessLogs.forEach(function (accessLog) {
		// 区域
		if (typeof (that.regions[accessLog.remoteAddr]) == "string") {
			accessLog.region = that.regions[accessLog.remoteAddr]
		} else {
			accessLog.region = ""
		}

		// 节点
		if (typeof (that.nodes[accessLog.nsNodeId]) != "undefined") {
			accessLog["node"] = that.nodes[accessLog.nsNodeId]
		} else {
			accessLog["node"] = null
		}

		// 域名
		if (typeof (that.domains[accessLog.nsDomainId]) != "undefined") {
			accessLog["domain"] = that.domains[accessLog.nsDomainId]
		} else {
			accessLog["domain"] = null
		}
	})

	this.$delay(function () {
		let that = this
		teaweb.datepicker("day-input", function (v) {
			that.day = v
		})
	})
})