Tea.context(function () {
	const t = this.t.bind(this)
	this.createPeriod = function () {
		teaweb.popup("/finance/packages/periods/createPopup", {
			title: t('finance_packages_periods_index@添加有效期选项'),
			callback: function () {
				teaweb.successRefresh(t('finance_packages_periods_index@保存成功'))
			}
		})
	}

	this.updatePeriod = function (periodId) {
		teaweb.popup("/finance/packages/periods/period/updatePopup?periodId=" + periodId, {
			title: t('finance_packages_periods_index@修改有效期选项'),
			callback: function () {
				teaweb.successRefresh(t('finance_packages_periods_index@保存成功'))
			}
		})
	}

	this.deletePeriod = function (periodId) {
		let that = this
		teaweb.confirm(t('finance_packages_periods_index@确定要删除此有效期选项吗'), function () {
			that.$post("/finance/packages/periods/period/delete")
				.params({
					periodId: periodId
				})
				.success(function () {
					teaweb.successRefresh(t('finance_packages_periods_index@删除成功'))
				})
		})
	}
})