Tea.context(function () {
	const t = this.t.bind(this)
	this.createPackage = function () {
		teaweb.popup("/finance/packages/createPopup", {
			title: t('finance_packages_index@添加流量包'),
			callback: function () {
				teaweb.success(t('finance_packages_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updatePackage = function (packageId) {
		teaweb.popup("/finance/packages/updatePopup?packageId=" + packageId, {
			title: t('finance_packages_index@修改流量包'),
			callback: function () {
				teaweb.success(t('finance_packages_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deletePackage = function (packageId) {
		let that = this
		teaweb.confirm(t('finance_packages_index@确定要删除此流量包吗'), function () {
			that.$post("/finance/packages/delete")
				.params({packageId: packageId})
				.success(function () {
					teaweb.success(t('finance_packages_index@删除成功'), function () {
						teaweb.reload()
					})
				})
		})
	}

	this.updatePrices = function (packageId) {
		teaweb.popup("/finance/packages/updatePricesPopup?packageId=" + packageId, {
			title: t('finance_packages_index@流量包价格'),
			width: "54em",
			height: "30em",
			onClose: function () {
				teaweb.reload()
			}
		})
	}
})