Tea.context(function () {
	const t = this.t.bind(this)
	this.createItem = function () {
		teaweb.popup(Tea.url(".items.createTrafficPopup"), {
			title: t("finance_fee_traffic@添加流量区间"),
			callback: function () {
				teaweb.success(t("finance_fee_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateItem = function (itemId) {
		teaweb.popup(Tea.url(".items.updateTrafficPopup", {itemId: itemId}), {
			title: t("finance_fee_traffic@修改流量区间"),
			callback: function () {
				teaweb.success(t("finance_fee_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteItem = function (itemId) {
		let that = this
		teaweb.confirm(t("finance_fee_traffic@确定要删除此流量区间吗？"), function () {
			that.$post(".items.delete")
				.params({
					itemId: itemId
				})
				.refresh()
		})
	}

	this.updatePrice = function (regionId, itemId) {
		teaweb.popup(Tea.url(".updatePricePopup", {regionId: regionId, itemId: itemId}), {
			title: t("finance_fee_traffic@修改流量价格"),
			callback: function () {
				teaweb.success(t("finance_fee_index@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}
})