Tea.context(function () {
	const t = this.t.bind(this);
	this.columns = [
		{
			title: t('finance_bills_index@账单编号'),
			dataIndex: 'code',
			key: 'code',
			scopedSlots: { customRender: 'codeSlot' },
			width: '15%'
		},
		{
			title: t('finance_bills_index@用户'),
			dataIndex: 'user',
			key: 'user',
			scopedSlots: { customRender: 'userSlot' }
		},
		{
			title: t('finance_bills_index@结算周期'),
			dataIndex: 'pricePeriodName',
			key: 'period',
			scopedSlots: { customRender: 'periodSlot' },
			width: '8%'
		},
		{
			title: t('finance_bills_index@月份'),
			dataIndex: 'month',
			key: 'month',
			scopedSlots: { customRender: 'monthSlot' },
			width: '8%'
		},
		{
			title: t('finance_bills_index@日期'),
			dataIndex: 'dayFrom',
			key: 'day',
			scopedSlots: { customRender: 'daySlot' },
			width: '8%'
		},
		{
			title: t('finance_bills_index@项目'),
			dataIndex: 'typeName',
			key: 'type',
			scopedSlots: { customRender: 'typeSlot' },
			width: '8%'
		},
		{
			title: t('finance_bills_index@金额'),
			dataIndex: 'amount',
			key: 'amount',
			scopedSlots: { customRender: 'amountSlot' },
			width: '10%'
		},
		{
			title: t('finance_bills_index@已支付'),
			dataIndex: 'isPaid',
			key: 'paid',
			scopedSlots: { customRender: 'paidSlot' },
			width: '8%',
			align: 'center'
		},
		{
			title: t('finance_bills_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '8%',
			align: 'center'
		}
	]
	this.payBill = function (billId) {
		teaweb.confirm(t('finance_bills_index@确定要使用用户账户支付此账单吗'), function () {
			this.$post(".pay")
				.params({
					billId: billId
				})
				.success(function () {
					teaweb.success(t('finance_bills_index@支付成功'), function () {
						teaweb.reload()
					})
				})
		})
	}
})