Tea.context(function () {
	const t = this.t.bind(this);
	// 网站/套餐子账单列定义
	this.serverBillsColumns = [
		{ title: t('finance_bills_bill_serverBillsColumns@网站'), key: 'server', scopedSlots: { customRender: 'serverSlot' } },
		{ title: t('finance_bills_bill_serverBillsColumns@套餐'), key: 'plan', scopedSlots: { customRender: 'planSlot' } },
		{ title: t('finance_bills_bill_serverBillsColumns@流量'), key: 'traffic', scopedSlots: { customRender: 'trafficSlot' } },
		{ title: t('finance_bills_bill_serverBillsColumns@带宽'), key: 'bandwidth', scopedSlots: { customRender: 'bandwidthSlot' } },
		{ title: t('finance_bills_bill_serverBillsColumns@费用'), key: 'amount', scopedSlots: { customRender: 'amountSlot' } },
		{ title: t('finance_bills_bill_serverBillsColumns@更新时间'), key: 'createdTime', scopedSlots: { customRender: 'createdTimeSlot' } }
	];

	// 流量子账单列定义
	this.trafficBillsColumns = [
		{ title: t('finance_bills_bill_trafficBillsColumns@区域'), key: 'region', scopedSlots: { customRender: 'regionSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@计费方式'), key: 'priceType', scopedSlots: { customRender: 'priceTypeSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@计费带宽'), key: 'bandwidthMB', scopedSlots: { customRender: 'bandwidthMBSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@带宽百分位'), key: 'bandwidthPercentile', scopedSlots: { customRender: 'bandwidthPercentileSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@计费流量'), key: 'trafficGB', scopedSlots: { customRender: 'trafficGBSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@流量包使用'), key: 'trafficPackageGB', scopedSlots: { customRender: 'trafficPackageGBSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@单位价格'), key: 'pricePerUnit', scopedSlots: { customRender: 'pricePerUnitSlot' } },
		{ title: t('finance_bills_bill_trafficBillsColumns@总价格'), key: 'amount', scopedSlots: { customRender: 'amountSlot' } }
	];
	this.payBill = function (billId) {
		teaweb.confirm(t('finance_bills_index@确定要使用用户账户支付此账单吗'), function () {
			this.$post(".pay")
				.params({
					billId: billId
				})
				.success(function () {
					teaweb.success(t('finance_bills_index@支付成功'), function () {
						teaweb.reload()
					})
				})
		})
	}
})