Tea.context(function () {
	const t = this.t.bind(this);
	this.isUpdatingDomains = false
	this.hasDeletedDomains = this.domains.$find(function (k, v) {
		return v.isDeleted
	}) != null

	this.$delay(function () {
		if (this.pageNo <= 1 && this.filter.length == 0) {
			this.syncDomains()
		}
	})

	this.syncDomains = function () {
		this.isUpdatingDomains = true
		this.$post(".syncDomains")
			.params({
				providerId: this.provider.id
			})
			.success(function (resp) {
				if (resp.data.hasChanges) {
					teaweb.reload()
				}
			})
			.done(function () {
				this.$delay(function () {
					this.isUpdatingDomains = false
				}, 1000)
			})
	}

	this.updateProvider = function (providerId) {
		teaweb.popup(Tea.url(".updatePopup?providerId=" + providerId), {
			title: t('dns_providers@jsUpdateAccountInfoTitle'),
			height: "28em",
			callback: function () {
				teaweb.success(t('dns_providers@jsSaveSuccess'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.createDomain = function () {
		teaweb.popup("/dns/domains/createPopup?providerId=" + this.provider.id, {
			title: t('dns_providers@jsAddManagedDomainTitle'),
			callback: function () {
				teaweb.success(t('dns_providers@jsSaveSuccess'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateDomain = function (domainId) {
		teaweb.popup("/dns/domains/updatePopup?domainId=" + domainId, {
			title: t('dns_providers@jsUpdateManagedDomainTitle'),
			callback: function () {
				teaweb.success(t('dns_providers@jsSaveSuccess'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteDomain = function (domain) {
		let that = this
		teaweb.confirm(t('dns_providers@jsConfirmDeleteDomain', [domain.name]), function () {
			that.$post("/dns/domains/delete")
				.params({
					domainId: domain.id
				})
				.post()
				.refresh()
		})
	}

	this.recoverDomain = function (domain) {
		let that = this
		teaweb.confirm(t('dns_providers@jsConfirmRecoverDomain', [domain.name]), function () {
			that.$post("/dns/domains/recover")
				.params({
					domainId: domain.id
				})
				.post()
				.refresh()
		})
	}

	this.syncDomain = function (index, domain) {
		let that = this
		teaweb.confirm(t('dns_providers@jsConfirmSyncRecords'), function () {
			domain.isSyncing = true
			Vue.set(that.domains, index, domain)

			this.$post("/dns/domains/sync")
				.params({
					domainId: domain.id
				})
				.success(function () {
					teaweb.success(t('dns_providers@jsSyncSuccess'), function () {
						teaweb.reload()
					})
				})
				.fail(function (resp) {
					teaweb.warn(resp.message, function () {
						if (resp.data.shouldFix) {
							window.location = "/dns/issues"
						}
					})
				})
				.done(function () {
					Vue.set(that.domains, index, domain)
				})
		})
	}

	this.showRoutes = function (domainId) {
		teaweb.popup("/dns/domains/routesPopup?domainId=" + domainId, {
			title: t('dns_providers@jsDomainRoutesTitle'),
		})
	}

	this.viewClusters = function (domainId) {
		teaweb.popup("/dns/domains/clustersPopup?domainId=" + domainId, {
			title: t('dns_providers@jsDomainClustersTitle'),
		})
	}

	this.viewNodes = function (domainId) {
		teaweb.popup("/dns/domains/nodesPopup?domainId=" + domainId, {
			title: t('dns_providers@jsDomainNodesTitle'),
			width: "50em",
			height: "30em"
		})
	}

	this.viewServers = function (domainId) {
		teaweb.popup("/dns/domains/serversPopup?domainId=" + domainId, {
			title: t('dns_providers@jsDomainServersTitle'),
			width: "50em",
			height: "30em"
		})
	}

	this.alertDown = function () {
		teaweb.popupTip(t('dns_providers@jsDomainOfflineTip'))
	}
})