Tea.context(function () {
	const t = this.t.bind(this);
	// 表格列配置
	this.columns = [
		{
			title: t('dns@集群'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('dns@子域名'),
			dataIndex: 'dnsName',
			key: 'dnsName',
			scopedSlots: { customRender: 'dnsNameSlot' }
		},
		{
			title: t('dns@DNS服务商'),
			dataIndex: 'providerTypeName',
			key: 'providerTypeName',
			scopedSlots: { customRender: 'providerTypeNameSlot' }
		},
		{
			title: t('dns@DNS服务商账号'),
			dataIndex: 'providerName',
			key: 'providerName',
			scopedSlots: { customRender: 'providerNameSlot' }
		},
		{
			title: t('dns@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];

	this.updateCluster = function (clusterId) {
		teaweb.popup("/dns/updateClusterPopup?clusterId=" + clusterId, {
			title: t('dns@修改集群DNS设置'),
			height: "25em",
			callback: function () {
				teaweb.success(t('dns@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}
})