Tea.context(function () {
	this.isLoading = true
	this.trafficTab = "hourly"
	this.metricCharts = []
	this.dashboard = {}
	this.localLowerVersionAPINode = null
	this.countWeakAdmins = 0
	this.todayCountIPsFormat = "0"
	this.hasTrafficData = false
	this.hasDomainsData = false

	this.$delay(function () {
		this.$post("$")
			.success(function (resp) {
				for (let k in resp.data) {
					this[k] = resp.data[k]
				}

				this.todayCountIPsFormat = teaweb.formatNumber(this.todayCountIPs)
				
				// 检查是否有流量数据
				this.hasTrafficData = this.checkHasTrafficData()
				
				// 检查是否有域名访问数据
				this.hasDomainsData = this.checkHasDomainsData()
				
				// 检查每个指标图表是否有数据
				if (this.metricCharts && this.metricCharts.length > 0) {
					this.metricCharts.forEach(chart => {
						this.$set(chart, "hasData", this.checkMetricChartHasData(chart))
						console.log("chart", chart)
					})
				}

				this.isLoading = false

				this.$delay(function () {
					if (this.trafficTab == "hourly") {
						this.reloadHourlyTrafficChart()
					} else if (this.trafficTab == "daily") {
						this.reloadDailyTrafficChart()
					}
					this.reloadTopDomainsChart()
				})
			})
	})

	// 检查是否有流量数据
	this.checkHasTrafficData = function() {
		if (!this.hourlyTrafficStats || !this.dailyTrafficStats) {
			return false
		}
		
		// 检查时数据是否为空
		if (this.hourlyTrafficStats.length === 0 && this.dailyTrafficStats.length === 0) {
			return false
		}
		
		// 检查是否所有数据都为0
		let hasHourlyData = this.hourlyTrafficStats.some(stat => stat.bytes > 0)
		let hasDailyData = this.dailyTrafficStats.some(stat => stat.bytes > 0)
		
		return hasHourlyData || hasDailyData
	}
	
	// 检查是否有域名访问数据
	this.checkHasDomainsData = function() {
		if (!this.topDomainStats) {
			return false
		}
		
		// 检查域名数据是否为空
		if (this.topDomainStats.length === 0) {
			return false
		}
		
		// 检查是否所有域名请求数都为0
		return this.topDomainStats.some(stat => stat.countRequests > 0)
	}

	// 检查指标图表是否有数据
	this.checkMetricChartHasData = function(chart) {
		if (!chart || !chart.stats) {
			return false
		}
		
		// 检查图表数据是否为空
		if (chart.stats.length === 0) {
			return false
		}
		
		// 检查是否所有值都为0
		return chart.stats.some(stat => {
			// 检查统计对象中任意一个数字属性是否大于0
			for (let key in stat) {
				if (typeof stat[key] === 'number' && stat[key] > 0) {
					return true
				}
			}
			return false
		})
	}

	this.selectTrafficTab = function (tab) {
		this.trafficTab = tab
		if (tab == "hourly") {
			this.$delay(function () {
				this.reloadHourlyTrafficChart()
			})
		} else if (tab == "daily") {
			this.$delay(function () {
				this.reloadDailyTrafficChart()
			})
		}
	}

	this.reloadHourlyTrafficChart = function () {
		let stats = this.hourlyTrafficStats
		this.reloadTrafficChart("hourly-traffic-chart-box", stats, function (args) {
			let index = args.dataIndex
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].bytes > 0) {
				cachedRatio = Math.round(stats[index].cachedBytes * 10000 / stats[index].bytes) / 100
				attackRatio = Math.round(stats[index].attackBytes * 10000 / stats[index].bytes) / 100
			}

			return stats[index].day + " " + stats[index].hour + this.t('dash_时_8c81') + "<br/>" + this.t('dash_总流量_e3c0') + "：" + teaweb.formatBytes(stats[index].bytes) + "<br/>" + this.t('dash_缓存流量_1821') + "：" + teaweb.formatBytes(stats[index].cachedBytes) + "<br/>" + this.t('dash_缓存命中率_15b2') + "：" + cachedRatio + "%<br/>" + this.t('dash_拦截攻击流量_233f') + "：" + teaweb.formatBytes(stats[index].attackBytes) + "<br/>" + this.t('dash_拦截比例_d565') + "：" + attackRatio + "%"
		})
	}

	this.reloadDailyTrafficChart = function () {
		let stats = this.dailyTrafficStats
		this.reloadTrafficChart("daily-traffic-chart-box", stats, function (args) {
			let index = args.dataIndex
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].bytes > 0) {
				cachedRatio = Math.round(stats[index].cachedBytes * 10000 / stats[index].bytes) / 100
				attackRatio = Math.round(stats[index].attackBytes * 10000 / stats[index].bytes) / 100
			}

			return stats[index].day + "<br/>" + this.t('dash_总流量_e3c0') + "：" + teaweb.formatBytes(stats[index].bytes) + "<br/>" + this.t('dash_缓存流量_1821') + "：" + teaweb.formatBytes(stats[index].cachedBytes) + "<br/>" + this.t('dash_缓存命中率_15b2') + "：" + cachedRatio + "%<br/>" + this.t('dash_拦截攻击流量_233f') + "：" + teaweb.formatBytes(stats[index].attackBytes) + "<br/>" + this.t('dash_拦截比例_d565') + "：" + attackRatio + "%"
		})
	}

	this.reloadTrafficChart = function (chartId, stats, tooltipFunc) {
		let axis = teaweb.bytesAxis(stats, function (v) {
			return v.bytes
		})
		let chartBox = document.getElementById(chartId)
		let chart = teaweb.initChart(chartBox)
		let option = {
			xAxis: {
				data: stats.map(function (v) {
					if (v.hour != null) {
						return v.hour
					}
					return v.day
				}),
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				},
				splitLine: {
					show: false
				}
			},
			yAxis: {
				axisLabel: {
					formatter: function (v) {
						return v + axis.unit
					}
				},
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				show: true,
				trigger: "item",
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);',
				formatter: tooltipFunc,
			},
			grid: {
				left: 50,
				top: 40,
				right: 20,
				bottom: 20
			},
			series: [
				{
					name: this.t('dash_总流量_e3c0'),
					type: "line",
					data: stats.map(function (v) {
						return v.bytes / axis.divider;
					}),
					itemStyle: {
						color: getCssVariable('--color-text-active', '#app'),
					},
					lineStyle: {
						width: 3,
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: getCssVariable('--color-text-active', '#app')
							}, {
								offset: 1, color: getCssVariable('--color-text-active', '#app')
							}]
						},
						shadowColor: 'rgba(242, 138, 0, 0.3)',
						shadowBlur: 10,
					},
					areaStyle: {
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: 'rgba(242, 138, 0, 0.3)'
							}, {
								offset: 1, color: 'rgba(242, 138, 0, 0.05)'
							}]
						}
					},
					smooth: true,
					symbolSize: 6,
					showSymbol: false,
				},
				{
					name: this.t('dash_缓存流量_1821'),
					type: "line",
					data: stats.map(function (v) {
						return v.cachedBytes / axis.divider;
					}),
					itemStyle: {
						color: "#61A0A8"
					},
					lineStyle: {
						width: 3,
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: '#61A0A8'
							}, {
								offset: 1, color: '#8ECAD0'
							}]
						},
						shadowColor: 'rgba(97, 160, 168, 0.3)',
						shadowBlur: 10,
					},
					areaStyle: {
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: 'rgba(97, 160, 168, 0.3)'
							}, {
								offset: 1, color: 'rgba(97, 160, 168, 0.05)'
							}]
						}
					},
					smooth: true,
					symbolSize: 6,
					showSymbol: false,
				},
				{
					name: this.t('dash_攻击流量_5c59'),
					type: "line",
					data: stats.map(function (v) {
						return v.attackBytes / axis.divider;
					}),
					itemStyle: {
						color: "#F39494"
					},
					lineStyle: {
						width: 3,
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: '#F39494'
							}, {
								offset: 1, color: '#F7B5B5'
							}]
						},
						shadowColor: 'rgba(243, 148, 148, 0.3)',
						shadowBlur: 10,
					},
					areaStyle: {
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: 'rgba(243, 148, 148, 0.3)'
							}, {
								offset: 1, color: 'rgba(243, 148, 148, 0.05)'
							}]
						}
					},
					smooth: true,
					symbolSize: 6,
					showSymbol: false,
				}
			],
			legend: {
				data: [this.t('dash_总流量_e3c0'), this.t('dash_缓存流量_1821'), this.t('dash_攻击流量_5c59')],
				textStyle: {
					color: 'rgba(0, 0, 0, 0.6)',
				},
			},
			animation: false
		}
		chart.setOption(option)
		chart.resize()
	}


	// 域名排行
	this.reloadTopDomainsChart = function () {
		let axis = teaweb.countAxis(this.topDomainStats, function (v) {
			return v.countRequests
		})
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				barWidth: "60%",
				itemStyle: {
					borderRadius: [4, 4, 0, 0],
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					}
				}
			}],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderBarChart({
			id: "top-domains-chart",
			name: this.t('dash_域名_06ac'),
			values: this.topDomainStats,
			x: function (v) {
				return v.domain
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].domain + "<br/>" + this.t('dash_请求数_9e24') + "：" + " " + teaweb.formatNumber(stats[args.dataIndex].countRequests) + "<br/>" + this.t('dash_流量_c2c7') + "：" + teaweb.formatBytes(stats[args.dataIndex].bytes)
			},
			value: function (v) {
				return v.countRequests / axis.divider;
			},
			axis: axis,
			customOptions: customOptions,
			click: function (args, stats) {
				let index = args.dataIndex
				window.location = "/servers/server?serverId=" + stats[index].serverId
			}
		})
	}

	/**
	 * 升级提醒
	 */
	this.closeMessage = function (e) {
		let target = e.target
		while (target && target.tagName) {
			if (target.classList.contains('alert-card')) {
				target.style.display = "none"
				break
			}
			target = target.parentNode
		}
	}

	// 重启本地API节点
	this.isRestartingLocalAPINode = false
	this.restartAPINode = function () {
		if (this.isRestartingLocalAPINode) {
			return
		}
		if (this.localLowerVersionAPINode == null) {
			return
		}
		this.isRestartingLocalAPINode = true
		this.localLowerVersionAPINode.isRestarting = true
		this.$post("/dashboard/restartLocalAPINode")
			.params({
				"exePath": this.localLowerVersionAPINode.exePath
			})
			.timeout(300)
			.success(function () {
				teaweb.success(this.t('dash_重启成功_53f1'), function () {
					window.location.reload()
				})
			})
			.fail(function (resp) {
				teaweb.warn(this.t('dash_重启失败_3a04') + "：" + resp.message)
				this.isRestartingLocalAPINode = false
				this.localLowerVersionAPINode.isRestarting = false
			})
	}

	// 关闭XFF提示
	this.dismissXFFPrompt = function () {
		this.teaXFFPrompt = false
		this.$post(".settingOff")
	}

	// 点击卡片跳转
	this.goToURL = function(url) {
		if (url && url.length > 0) {
			window.location.href = url
		}
	}
})
