Tea.context(function () {
	this.isLoading = false
	
	this.$delay(function () {
		this.reloadDailyStats()
		this.reloadCPUChart()
		this.reloadMemoryChart()
		this.reloadLoadChart()
		this.reloadTopTrafficChart()
	})

	this.reloadDailyStats = function () {
		let axis = teaweb.countAxis(this.dailyStats, function (v) {
			return v.count
		})
		let max = axis.max
		if (max < 10) {
			max = 10
		} else if (max < 100) {
			max = 100
		}

		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					},
					shadowColor: 'rgba(255, 90, 0, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(255, 90, 0, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(255, 90, 0, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false,
				smooth: true
			}],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				},
				splitLine: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "daily-stat-chart",
			name: "用户",
			values: this.dailyStats,
			x: function (v) {
				return v.day.substring(4, 6) + "-" + v.day.substring(6)
			},
			tooltip: function (args, stats) {
				let index = args.dataIndex
				return stats[index].day.substring(4, 6) + "-" + stats[index].day.substring(6) + "：" + stats[index].count
			},
			value: function (v) {
				return v.count;
			},
			axis: axis,
			max: max,
			customOptions: customOptions
		})
	}

	/**
	 * 系统信息
	 */
	this.nodeStatusTab = "cpu"

	this.selectNodeStatusTab = function (tab) {
		this.nodeStatusTab = tab
		this.$delay(function () {
			switch (tab) {
				case "cpu":
					this.reloadCPUChart()
					break
				case "memory":
					this.reloadMemoryChart()
					break
				case "load":
					this.reloadLoadChart()
					break
			}
		})
	}

	this.reloadCPUChart = function () {
		let axis = {unit: "%", divider: 1}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: '#61A0A8' // 开始颜色
						}, {
							offset: 1, color: '#8ECAD0' // 结束颜色
						}]
					},
					shadowColor: 'rgba(97, 160, 168, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(97, 160, 168, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(97, 160, 168, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false,
				smooth: true
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "cpu-chart",
			name: "CPU",
			values: this.cpuValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			customOptions: customOptions
		})
	}

	this.reloadMemoryChart = function () {
		let axis = {unit: "%", divider: 1}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: '#F39494' // 开始颜色
						}, {
							offset: 1, color: '#F7B5B5' // 结束颜色
						}]
					},
					shadowColor: 'rgba(243, 148, 148, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(243, 148, 148, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(243, 148, 148, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false,
				smooth: true
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "memory-chart",
			name: "内存",
			values: this.memoryValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			customOptions: customOptions
		})
	}

	this.reloadLoadChart = function () {
		let axis = {unit: "", divider: 1}
		let max = this.loadValues.$map(function (k, v) {
			return v.value
		}).$max()
		if (max < 10) {
			max = 10
		} else if (max < 20) {
			max = 20
		} else if (max < 100) {
			max = 100
		} else {
			max = null
		}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					},
					shadowColor: 'rgba(255, 90, 0, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(255, 90, 0, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(255, 90, 0, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false,
				smooth: true
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "load-chart",
			name: "负载",
			values: this.loadValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + stats[args.dataIndex].value
			},
			value: function (v) {
				return v.value;
			},
			axis: axis,
			max: max,
			customOptions: customOptions
		})
	}

	// 流量排行
	this.reloadTopTrafficChart = function () {
		let that = this
		let axis = teaweb.bytesAxis(this.topTrafficStats, function (v) {
			return v.bytes
		})
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				barWidth: "60%",
				itemStyle: {
					borderRadius: [4, 4, 0, 0],
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					}
				}
			}],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderBarChart({
			id: "top-traffic-chart",
			name: "流量",
			values: this.topTrafficStats,
			x: function (v) {
				return v.userName
			},
			tooltip: function (args, stats) {
				let index = args.dataIndex
				return stats[index].userName + "<br/>请求数：" + " " + teaweb.formatNumber(stats[index].countRequests) + "<br/>流量：" + teaweb.formatBytes(stats[index].bytes)
			},
			value: function (v) {
				return v.bytes / axis.divider;
			},
			axis: axis,
			customOptions: customOptions
		})
	}

	// 点击卡片跳转
	this.goToURL = function(url) {
		window.location.href = url
	}
})