Tea.context(function () {
	const t = this.t.bind(this)
	this.isLoading = true
	this.trafficTab = "hourly"
	this.plusExpireDay = ""
	this.topCountryStats = []
	this.yesterdayPercentFormat = ""
	this.localLowerVersionAPINode = null
	this.countWeakAdmins = 0
	this.todayCountIPsFormat = "0"

	this.nodeValuesStat = null
	
	// G2Plot图表实例存储
	this.g2plots = {}

	// 点击卡片跳转
	this.goToURL = function(url) {
		window.location.href = url
	}
	
	this.$delay(function () {
		// 整体图表
		this.$post("$")
			.success(function (resp) {
				for (let k in resp.data) {
					if(Array.isArray(this[k])&& !resp.data[k]) {
						this[k] = []
					} else {
						this[k] = resp.data[k]
					}
				}

				this.todayCountIPsFormat = teaweb.formatNumber(this.todayCountIPs)


				this.isLoading = false

				this.$delay(function () {
					this.reloadHourlyTrafficChart()
					this.reloadHourlyRequestsChart()
					this.reloadTopDomainsChart()
					this.reloadTopNodesChart()
				})

				// 节点数据
				this.$delay(function () {
					this.reloadNodeValues()
				}, 200)
			})
	})

	this.selectTrafficTab = function (tab) {
		this.trafficTab = tab
		if (tab == "hourly") {
			this.$delay(function () {
				this.reloadHourlyTrafficChart()
			})
		} else if (tab == "daily") {
			this.$delay(function () {
				this.reloadDailyTrafficChart()
			})
		}
	}

	// 初始化G2Plot图表
	this.initG2Plot = function(chartId, type, options) {
		// 销毁旧图表
		if (this.g2plots[chartId]) {
			this.g2plots[chartId].destroy()
		}
		
		const chartBox = document.getElementById(chartId)
		if (!chartBox) {
			return null
		}
		
		const G2Plot = window['G2Plot']
		if (!G2Plot || !G2Plot[type]) {
			console.error('G2Plot not found or type not supported: ' + type)
			return null
		}
		
		// 创建新图表实例
		const chart = new G2Plot[type](chartId, options)
		chart.render()
		this.g2plots[chartId] = chart
		return chart
	}

	this.reloadHourlyTrafficChart = function () {
		let stats = this.hourlyTrafficStats
		this.reloadTrafficChart("hourly-traffic-chart-box", stats, function (args) {
			let index = args.data.index || 0
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].bytes > 0) {
				cachedRatio = Math.round(stats[index].cachedBytes * 10000 / stats[index].bytes) / 100
				attackRatio = Math.round(stats[index].attackBytes * 10000 / stats[index].bytes) / 100
			}

			return `
			<div style="padding: 10px; display: flex; flex-direction: column; gap: 5px;">
				${stats[index].day} ${stats[index].hour}时
				<div>
					<span>${t('dash_总流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].bytes)}</span>
				</div>
				<div>
					<span>${t('dash_缓存流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].cachedBytes)}</span>
				</div>
				<div>
					<span>${t('dash_缓存命中率_5c59')}</span>
					<span>${cachedRatio}%</span>
				</div>
				<div>
					<span>${t('dash_拦截攻击流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].attackBytes)}</span>
				</div>
				<div>
					<span>${t('dash_拦截比例_5c59')}</span>
					<span>${attackRatio}%</span>
				</div>
			</div>
			`
		})
	}

	this.reloadDailyTrafficChart = function () {
		let stats = this.dailyTrafficStats
		this.reloadTrafficChart("daily-traffic-chart-box", stats, function (args) {
			let index = args.data.index || 0
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].bytes > 0) {
				cachedRatio = Math.round(stats[index].cachedBytes * 10000 / stats[index].bytes) / 100
				attackRatio = Math.round(stats[index].attackBytes * 10000 / stats[index].bytes) / 100
			}

			return `
			<div style="padding: 10px; display: flex; flex-direction: column; gap: 5px;">
				${stats[index].day}
				<div>
					<span>${t('dash_总流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].bytes)}</span>
				</div>
				<div>
					<span>${t('dash_缓存流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].cachedBytes)}</span>
				</div>
				<div>
					<span>${t('dash_缓存命中率_5c59')}</span>
					<span>${cachedRatio}%</span>
				</div>
				<div>
					<span>${t('dash_拦截攻击流量_5c59')}</span>
					<span>${teaweb.formatBytes(stats[index].attackBytes)}</span>
				</div>
				<div>
					<span>${t('dash_拦截比例_5c59')}</span>
					<span>${attackRatio}%</span>
				</div>
			</div>
			`
		})
	}

	this.reloadTrafficChart = function (chartId, stats, tooltipFunc) {
		let axis = teaweb.bytesAxis(stats, function (v) {
			return v.bytes
		})
		
		const xField = 'time'
		const yField = 'value'
		const seriesField = 'type'
		
		// 准备数据
		let data = []
		stats.forEach(function(v, index) {
			let time = v.hour != null ? v.hour : v.day
			
			data.push({
				time: time,
				value: v.bytes / axis.divider,
				type: t('dash_总流量_5c59'),
				index: index
			})
			
			data.push({
				time: time,
				value: v.cachedBytes / axis.divider,
				type: t('dash_缓存流量_5c59'),
				index: index
			})
			
			data.push({
				time: time,
				value: v.attackBytes / axis.divider,
				type: t('dash_攻击流量_5c59'),
				index: index
			})
		})
		
		// 配置G2Plot折线图
		const options = {
			data: data,
			xField: xField,
			yField: yField,
			seriesField: seriesField,
			smooth: true,
			animation: true,
			padding: [40, 20, 20, 50],
			xAxis: {
				tickCount: stats.length,
			},
			yAxis: {
				label: {
					formatter: function(v) {
						return v + axis.unit
					}
				}
			},
			tooltip: {
				customContent: function(title, items) {
					if (items.length === 0) return ''
					let args = {data: items[0].data}
					return tooltipFunc(args)
				}
			},
			color: ['#5470c6', '#61A0A8', '#F39494'],
			legend: {
				position: 'top'
			},
			areaStyle: function(item) {
				// 针对不同的数据类型设置不同的填充样式
				if (item.type === t('dash_总流量_5c59')) {
					return { fill: 'l(270) 0:#5470c620 1:#5470c6' }
				} else if (item.type === t('dash_缓存流量_5c59')) {
					return { fill: 'l(270) 0:#61A0A820 1:#61A0A8' }
				} else if (item.type === t('dash_攻击流量_5c59')) {
					return { fill: 'l(270) 0:#F3949420 1:#F39494' }
				}
				return {}
			}
		}
		
		this.initG2Plot(chartId, 'Line', options)
	}

	/**
	 * 请求数统计
	 */
	this.requestsTab = "hourly"

	this.selectRequestsTab = function (tab) {
		this.requestsTab = tab
		if (tab == "hourly") {
			this.$delay(function () {
				this.reloadHourlyRequestsChart()
			})
		} else if (tab == "daily") {
			this.$delay(function () {
				this.reloadDailyRequestsChart()
			})
		}
	}

	this.reloadHourlyRequestsChart = function () {
		let stats = this.hourlyTrafficStats
		this.reloadRequestsChart("hourly-requests-chart", t('dash_请求数统计_5c59'), stats, function (args) {
			let index = args.data.index || 0
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].countRequests > 0) {
				cachedRatio = Math.round(stats[index].countCachedRequests * 10000 / stats[index].countRequests) / 100
				attackRatio = Math.round(stats[index].countAttackRequests * 10000 / stats[index].countRequests) / 100
			}

			return `
			<div style="padding: 10px; display: flex; flex-direction: column; gap: 5px;">
				${stats[index].day} ${stats[index].hour}时
				<div>
					<span>${t('dash_总请求数_5c59')}</span>
					<span>${teaweb.formatNumber(stats[index].countRequests)}</span>
				</div>
				<div>
					<span>${t('dash_缓存请求数_5c59')}</span>
					<span>${teaweb.formatNumber(stats[index].countCachedRequests)}</span>
				</div>
				<div>
					<span>${t('dash_缓存命中率_5c59')}</span>
					<span>${cachedRatio}%</span>
				</div>
				<div>
					<span>${t('dash_拦截攻击数_5c59')}</span>
					<span>${teaweb.formatNumber(stats[index].countAttackRequests)}</span>
				</div>
				<div>
					<span>${t('dash_拦截比例_5c59')}</span>
					<span>${attackRatio}%</span>
				</div>
			</div>
			`
		})
	}

	this.reloadDailyRequestsChart = function () {
		let stats = this.dailyTrafficStats
		this.reloadRequestsChart("daily-requests-chart", t('dash_请求数统计_5c59'), stats, function (args) {
			let index = args.data.index || 0
			let cachedRatio = 0
			let attackRatio = 0
			if (stats[index].countRequests > 0) {
				cachedRatio = Math.round(stats[index].countCachedRequests * 10000 / stats[index].countRequests) / 100
				attackRatio = Math.round(stats[index].countAttackRequests * 10000 / stats[index].countRequests) / 100
			}

			return `
				<div style="padding: 10px; display: flex; flex-direction: column; gap: 5px;">
					${stats[index].day}
					<div>
						<span>${t('dash_总请求数_5c59')}</span>
						<span>${teaweb.formatNumber(stats[index].countRequests)}</span>
					</div>
					<div>
						<span>${t('dash_缓存请求数_5c59')}</span>
						<span>${teaweb.formatNumber(stats[index].countCachedRequests)}</span>
					</div>
					<div>
						<span>${t('dash_缓存命中率_5c59')}</span>
						<span>${cachedRatio}%</span>
					</div>
					<div>
						<span>${t('dash_拦截攻击数_5c59')}</span>
						<span>${teaweb.formatNumber(stats[index].countAttackRequests)}</span>
					</div>
					<div>
						<span>${t('dash_拦截比例_5c59')}</span>
						<span>${attackRatio}%</span>
					</div>
				</div>
			`
		})
	}

	this.reloadRequestsChart = function (chartId, name, stats, tooltipFunc) {
		let chartBox = document.getElementById(chartId)
		if (chartBox == null) {
			return
		}

		let axis = teaweb.countAxis(stats, function (v) {
			return Math.max(v.countRequests, v.countCachedRequests)
		})

		const xField = 'time'
		const yField = 'value'
		const seriesField = 'type'
		
		// 准备数据
		let data = []
		stats.forEach(function(v, index) {
			let time = v.hour != null ? v.hour : (v.day != null ? v.day : "")
			
			data.push({
				time: time,
				value: v.countRequests / axis.divider,
				type: t('dash_请求数_5c59'),
				index: index
			})
			
			data.push({
				time: time,
				value: v.countCachedRequests / axis.divider,
				type: t('dash_缓存请求数_5c59'),
				index: index
			})
			
			data.push({
				time: time,
				value: v.countAttackRequests / axis.divider,
				type: t('dash_攻击请求数_5c59'),
				index: index
			})
		})
		
		// 配置G2Plot折线图
		const options = {
			title: {
				content: name,
				style: {
					fontSize: 12,
					color: '#000000',
				}
			},
			data: data,
			xField: xField,
			yField: yField,
			seriesField: seriesField,
			smooth: true,
			animation: true,
			padding: [40, 20, 20, 50],
			xAxis: {
				tickCount: stats.length,
			},
			yAxis: {
				label: {
					formatter: function(v) {
						return v + axis.unit
					}
				}
			},
			tooltip: {
				customContent: function(title, items) {
					if (items.length === 0) return ''
					let args = {data: items[0].data}
					return tooltipFunc(args)
				}
			},
			color: ['#5470c6', '#61A0A8', '#F39494'],
			legend: {
				position: 'top'
			},
			areaStyle: function(item) {
				// 针对不同的数据类型设置不同的填充样式
				if (item.type === t('dash_请求数_5c59')) {
					return { fill: 'l(270) 0:#5470c620 1:#5470c6' }
				} else if (item.type === t('dash_缓存请求数_5c59')) {
					return { fill: 'l(270) 0:#61A0A820 1:#61A0A8' }
				} else if (item.type === t('dash_攻击请求数_5c59')) {
					return { fill: 'l(270) 0:#F3949420 1:#F39494' }
				}
				return {}
			}
		}
		
		this.initG2Plot(chartId, 'Line', options)
	}

	// 节点排行
	this.reloadTopNodesChart = function () {
		let that = this
		let axis = teaweb.countAxis(this.topNodeStats, function (v) {
			return v.countRequests
		})
		
		// 准备数据
		let data = this.topNodeStats.map(function(v, index) {
			return {
				x: v.nodeName,
				y: v.countRequests / axis.divider,
				index: index,
				...v // 保留原始数据以便tooltip使用
			}
		})
		
		// 配置G2Plot条形图
		const options = {
			data: data,
			xField: 'y',
			yField: 'x',
			seriesField: 'x',
			animation: true,
			legend: false,
			padding: [20, 20, 20, 80], // 左侧标签需要更多空间
			label: {
				position: 'left'
			},
			tooltip: {
				customContent: function(title, items) {
					if (items.length === 0) return ''
					const item = items[0].data
					return `
					<div style="padding: 10px; display: flex; flex-directiosn: column; gap: 5px;">
						${item.nodeName}
						<div>
							<span>${t('dash_请求数_5c59')}</span>
							<span>${teaweb.formatNumber(item.countRequests)}</span>
						</div>
						<div>
							<span>${t('dash_流量_5c59')}</span>
							<span>${teaweb.formatBytes(item.bytes)}</span>
						</div>
					</div>
					`
				}
			},
			interactions: [
				{
					type: 'element-active',
				},
			],
			meta: {
				y: {
					formatter: function(v) {
						return v + axis.unit
					}
				}
			}
		}
		
		// 创建图表
		const chart = this.initG2Plot("top-nodes-chart", 'Bar', options)
		
		// 添加点击事件
		if (chart) {
			chart.on('element:click', function(ev) {
				const {data} = ev.data
				if (data) {
					window.location = "/clusters/cluster/node?nodeId=" + data.nodeId + "&clusterId=" + that.clusterId
				}
			})
		}
	}

	// 域名排行
	this.reloadTopDomainsChart = function () {
		let axis = teaweb.countAxis(this.topDomainStats, function (v) {
			return v.countRequests
		})
		
		// 准备数据
		let data = this.topDomainStats.map(function(v, index) {
			return {
				x: v.domain,
				y: v.countRequests / axis.divider,
				index: index,
				...v // 保留原始数据以便tooltip使用
			}
		})
		
		// 配置G2Plot条形图
		const options = {
			data: data,
			xField: 'y',
			yField: 'x',
			seriesField: 'x',
			animation: true,
			legend: false,
			padding: [20, 20, 20, 80], // 左侧标签需要更多空间
			label: {
				position: 'left'
			},
			tooltip: {
				customContent: function(title, items) {
					if (items.length === 0) return ''
					const item = items[0].data
					return item.domain + "<br/>" + t('dash_请求数_5c59') + "：" + " " + teaweb.formatNumber(item.countRequests) + "<br/>" + t('dash_流量_5c59') + "：" + teaweb.formatBytes(item.bytes)
				}
			},
			interactions: [
				{
					type: 'element-active',
				},
			],
			meta: {
				y: {
					formatter: function(v) {
						return v + axis.unit
					}
				}
			}
		}
		
		// 创建图表
		const chart = this.initG2Plot("top-domains-chart", 'Bar', options)
		
		// 添加点击事件
		if (chart) {
			chart.on('element:click', function(ev) {
				const {data} = ev.data
				if (data) {
					window.location = "/servers/server?serverId=" + data.serverId
				}
			})
		}
	}

	// 绘制节点总体信息
	this.reloadNodeValues = function () {
		let reloadInterval = 20000
		this.$post(".values")
			.success(function (resp) {
				this.nodeValuesStat = resp.data.stat
				this.renderBandwidthGauge()
				this.renderCPUGauge()
				this.renderMemoryGauge()
				this.renderLoadGauge()

				if (resp.data.stat.todayTrafficFormat.length > 0) {
					let pieces = teaweb.splitFormat(resp.data.stat.todayTrafficFormat)
					this.todayTraffic = pieces[0]
					this.todayTrafficUnit = pieces[1]
				}

				this.yesterdayPercentFormat = resp.data.stat.yesterdayPercentFormat
			})
			.done(function () {
				this.$delay(function () {
					this.reloadNodeValues()
				}, reloadInterval)
			})
	}

	// 绘制gauge
	let lastBandwidthBytes = 0
	this.renderBandwidthGauge = function () {
		// 清理G2Plot实例
		if (this.g2plots["total-bandwidth-chart-box"]) {
			delete this.g2plots["total-bandwidth-chart-box"]
		}
		
		let bandwidthFormat = this.nodeValuesStat.totalTrafficPerSecondFormat
		let matchResult = bandwidthFormat.match(/^([0-9.]+)([a-zA-Z]+)$/)
		let size = parseFloat(matchResult[1])
		let unit = matchResult[2]
		this.nodeValuesStat.totalTrafficPerSecondSizeFormat = matchResult[1]
		this.nodeValuesStat.totalTrafficPerSecondUnitFormat = unit

		let max = size
		if (size < 10) {
			max = 10
		} else if (size < 100) {
			max = 100
		} else if (size < 1000) {
			max = 1000
		} else if (size < 1200) {
			max = 1200
		}

		let color = ""
		if (lastBandwidthBytes == 0) {
			lastBandwidthBytes = this.nodeValuesStat.totalTrafficBytesPerSecond
		}
		if (lastBandwidthBytes > 0 && lastBandwidthBytes != this.nodeValuesStat.totalTrafficBytesPerSecond) {
			let delta = Math.abs(lastBandwidthBytes - this.nodeValuesStat.totalTrafficBytesPerSecond) * 100 / lastBandwidthBytes
			if (delta > 20) {
				color = "red"
			} else if (delta > 10) {
				color = "yellow"
			}
			lastBandwidthBytes = this.nodeValuesStat.totalTrafficBytesPerSecond
		}

		teaweb.renderGaugeChart({
			id: "total-bandwidth-chart-box",
			name: "",
			min: 0,
			max: max,
			value: size,
			startAngle: 240,
			endAngle: -60,
			color: color,
			unit: "",
			detail: ""
		})
	}

	this.renderCPUGauge = function () {
		// 清理G2Plot实例
		if (this.g2plots["all-cpu-chart-box"]) {
			delete this.g2plots["all-cpu-chart-box"]
		}
		
		let avgCPUUsage = Math.round(this.nodeValuesStat.avgCPUUsage * 100) / 100
		let color = ""
		if (avgCPUUsage > 50) {
			color = "red"
		} else if (avgCPUUsage > 20) {
			color = "yellow"
		} else if (avgCPUUsage < 10) {
			color = "green"
		}

		let maxCPUUsage = Math.round(this.nodeValuesStat.maxCPUUsage * 100) / 100
		let maxColor = ""
		if (maxCPUUsage > 50) {
			maxColor = "red"
		} else if (maxCPUUsage > 20) {
			maxColor = "yellow"
		} else if (maxCPUUsage < 10) {
			maxColor = "green"
		}
		
		teaweb.renderPercentChart({
			id: "all-cpu-chart-box",
			name: t('dash_平均CPU用量_5c59'),
			unit: "%",
			total: 100,
			value: avgCPUUsage,
			color: color,
			max: maxCPUUsage,
			maxColor: maxColor,
			maxName: t('dash_最大CPU用量_5c59')
		})
	}

	this.renderMemoryGauge = function () {
		// 清理G2Plot实例
		if (this.g2plots["all-memory-chart-box"]) {
			delete this.g2plots["all-memory-chart-box"]
		}
		
		let avgMemoryUsage = Math.round(this.nodeValuesStat.avgMemoryUsage * 100) / 100
		let color = ""
		if (avgMemoryUsage > 80) {
			color = "red"
		} else if (avgMemoryUsage > 60) {
			color = "yellow"
		} else if (avgMemoryUsage < 20) {
			color = "green"
		}

		let maxMemoryUsage = Math.round(this.nodeValuesStat.maxMemoryUsage * 100) / 100
		let maxColor = ""
		if (maxMemoryUsage > 80) {
			maxColor = "red"
		} else if (maxMemoryUsage > 60) {
			maxColor = "yellow"
		} else if (maxMemoryUsage < 20) {
			maxColor = "green"
		}
		
		teaweb.renderPercentChart({
			id: "all-memory-chart-box",
			name: t('dash_平均内存用量_5c59'),
			total: 100,
			unit: "%",
			value: avgMemoryUsage,
			color: color,
			max: maxMemoryUsage,
			maxColor: maxColor,
			maxName: t('dash_最大内存用量_5c59')
		})
	}

	this.renderLoadGauge = function () {
		// 清理G2Plot实例
		if (this.g2plots["all-load-chart-box"]) {
			delete this.g2plots["all-load-chart-box"]
		}
		
		let avgLoad1min = Math.round(this.nodeValuesStat.avgLoad1min * 100) / 100
		let color = ""
		if (avgLoad1min > 20) {
			color = "red"
		} else if (avgLoad1min > 5) {
			color = "yellow"
		} else {
			color = "green"
		}
		if (avgLoad1min > 10) {
			avgLoad1min = 10
		}

		let maxLoad1min = Math.round(this.nodeValuesStat.maxLoad1min * 100) / 100
		let maxColor = ""
		if (maxLoad1min > 20) {
			maxColor = "red"
		} else if (maxLoad1min > 5) {
			maxColor = "yellow"
		} else {
			maxColor = "green"
		}
		if (maxLoad1min > 20) {
			maxLoad1min = 20
		}
		
		teaweb.renderPercentChart({
			id: "all-load-chart-box",
			name: t('dash_平均负载_5c59'),
			unit: "",
			value: avgLoad1min,
			total: 20,
			color: color,
			max: maxLoad1min,
			maxColor: maxColor,
			maxName: t('dash_最大负载_5c59')
		})
	}

	/**
	 * 升级提醒
	 */
	this.closeMessage = function (e) {
		let target = e.target
		while (true) {
			target = target.parentNode
			if (target.tagName.toUpperCase() == "DIV") {
				target.style.cssText = "display: none"
				break
			}
		}
	}

	// 重启本地API节点
	this.isRestartingLocalAPINode = false
	this.restartAPINode = function () {
		if (this.isRestartingLocalAPINode) {
			return
		}
		if (this.localLowerVersionAPINode == null) {
			return
		}
		this.isRestartingLocalAPINode = true
		this.localLowerVersionAPINode.isRestarting = true
		this.$post("/dashboard/restartLocalAPINode")
			.params({
				"exePath": this.localLowerVersionAPINode.exePath
			})
			.timeout(300)
			.success(function () {
				teaweb.reload()
			})
			.done(function () {
				this.isRestartingLocalAPINode = false
				this.localLowerVersionAPINode.isRestarting = false
			})
	}

	// 关闭XFF提示
	this.dismissXFFPrompt = function () {
		this.$post("/settings/security/dismissXFFPrompt")
			.success(function () {
				teaweb.reload()
			})
	}
})
