Tea.context(function () {
	this.isLoading = true
	this.domains = {count: 0}
	this.records = {count: 0}
	this.clusters = {count: 0}
	this.nodes = {count: 0}

	this.trafficTab = "hourly"

	this.hourlyTrafficValues = []
	this.dailyTrafficValues = []
	this.topDomains = []
	this.topNodes = []
	this.cpuValues = []
	this.memoryValues = []
	this.loadValues = []

	this.$delay(function () {
		this.$post("$")
			.success(function (resp) {
				for (let k in resp.data) {
					this[k] = resp.data[k]
				}

				this.$delay(function () {
					this.reloadHourlyTrafficChart()
					this.reloadTopDomainsChart()
					this.reloadTopNodesChart()
					this.reloadCPUChart()
				})

				this.isLoading = false
			})
	})

	/**
	 * 流量统计
	 */
	this.selectTrafficTab = function (tab) {
		this.trafficTab = tab
		if (tab == "hourly") {
			this.$delay(function () {
				this.reloadHourlyTrafficChart()
			})
		} else if (tab == "daily") {
			this.$delay(function () {
				this.reloadDailyTrafficChart()
			})
		}
	}

	this.reloadHourlyTrafficChart = function () {
		let stats = this.hourlyStats
		this.reloadTrafficChart("hourly-traffic-chart", this.t("dns_流量统计_1909"), stats, function (args) {
			return stats[args.dataIndex].day + " " + stats[args.dataIndex].hour + "时<br/>流量: " + teaweb.formatBytes(stats[args.dataIndex].bytes) + "<br/>请求数：" + teaweb.formatNumber(stats[args.dataIndex].countRequests)
		})
	}

	this.reloadDailyTrafficChart = function () {
		let stats = this.dailyStats
		this.reloadTrafficChart("daily-traffic-chart",this.t("dns_流量统计_1909"), stats, function (args) {
			return stats[args.dataIndex].day + "<br/>流量: " + teaweb.formatBytes(stats[args.dataIndex].bytes) + "<br/>请求数：" + teaweb.formatNumber(stats[args.dataIndex].countRequests)
		})
	}

	this.reloadTrafficChart = function (chartId, name, stats, tooltipFunc) {
		let chartBox = document.getElementById(chartId)
		if (chartBox == null) {
			return
		}

		let axis = teaweb.bytesAxis(stats, function (v) {
			return v.bytes
		})

		let chart = teaweb.initChart(chartBox)
		
		// 添加现代化样式选项
		let customOptions = {
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				},
				splitLine: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			},
			series: [
				{
					lineStyle: {
						width: 3,
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
							}, {
								offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
							}]
						}
					},
					areaStyle: {
						color: {
							type: 'linear',
							x: 0,
							y: 0,
							x2: 0,
							y2: 1,
							colorStops: [{
								offset: 0, color: 'rgba(255, 90, 0, 0.3)' // 开始颜色
							}, {
								offset: 1, color: 'rgba(255, 90, 0, 0.05)' // 结束颜色
							}]
						}
					},
					symbolSize: 6,
					showSymbol: false,
					smooth: true
				}
			],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			}
		}
		
		let option = {
			xAxis: {
				data: stats.map(function (v) {
					if (v.hour != null) {
						return v.hour
					}
					return v.day
				})
			},
			yAxis: {
				axisLabel: {
					formatter: function (value) {
						return value + axis.unit
					}
				}
			},
			tooltip: {
				show: true,
				trigger: "item",
				backgroundColor: getCssVariable('--color-bg', '#app'),
				borderColor: getCssVariable('--color-border', '#app'),
				textStyle: {
					color: getCssVariable('--color-text-active', '#app'),
				},
				formatter: tooltipFunc,
			},
			grid: {
				left: 50,
				top: 10,
				right: 20,
				bottom: 20
			},
			series: [
				{
					name: "流量",
					type: "line",
					data: stats.map(function (v) {
						return v.bytes / axis.divider
					}),
					itemStyle: {
						color: getCssVariable('--color-text-active', '#app'),
					},
					areaStyle: {
						color: getCssVariable('--color-text-active', '#app'),
					},
					smooth: true
				}
			],
			animation: true
		}
		
		// 应用自定义样式
		// 合并系列样式
		if (customOptions.series && customOptions.series[0] && option.series && option.series[0]) {
			Object.assign(option.series[0], customOptions.series[0]);
		}
		
		// 合并网格设置
		if (customOptions.grid) {
			Object.assign(option.grid, customOptions.grid);
		}
		
		// 合并X轴设置
		if (customOptions.xAxis) {
			Object.assign(option.xAxis, customOptions.xAxis);
		}
		
		// 合并Y轴设置
		if (customOptions.yAxis) {
			Object.assign(option.yAxis, customOptions.yAxis);
		}
		
		// 合并提示框设置
		if (customOptions.tooltip) {
			Object.assign(option.tooltip, customOptions.tooltip);
		}
		
		chart.setOption(option)
		chart.resize()
	}

	// 域名排行
	this.reloadTopDomainsChart = function () {
		let that = this
		let axis = teaweb.countAxis(this.topDomainStats, function (v) {
			return v.countRequests
		})
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				barWidth: "60%",
				itemStyle: {
					borderRadius: [4, 4, 0, 0],
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					}
				}
			}],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderBarChart({
			id: "top-domains-chart",
			name: "域名",
			values: this.topDomainStats,
			x: function (v) {
				return v.domainName
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].domainName + "<br/>请求数：" + " " + teaweb.formatNumber(stats[args.dataIndex].countRequests) + "<br/>流量：" + teaweb.formatBytes(stats[args.dataIndex].bytes)
			},
			value: function (v) {
				return v.countRequests / axis.divider;
			},
			axis: axis,
			customOptions: customOptions,
			click: function (args, stats) {
				window.location = "/ns/domains/domain?domainId=" + stats[args.dataIndex].domainId
			}
		})
	}

	// 节点排行
	this.reloadTopNodesChart = function () {
		let that = this
		let axis = teaweb.countAxis(this.topNodeStats, function (v) {
			return v.countRequests
		})
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				barWidth: "60%",
				itemStyle: {
					borderRadius: [4, 4, 0, 0],
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					}
				}
			}],
			grid: {
				left: 50,
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderBarChart({
			id: "top-nodes-chart",
			name: "节点",
			values: this.topNodeStats,
			x: function (v) {
				return v.nodeName
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].nodeName + "<br/>请求数：" + " " + teaweb.formatNumber(stats[args.dataIndex].countRequests) + "<br/>流量：" + teaweb.formatBytes(stats[args.dataIndex].bytes)
			},
			value: function (v) {
				return v.countRequests / axis.divider;
			},
			axis: axis,
			customOptions: customOptions,
			click: function (args, stats) {
				window.location = "/ns/clusters/cluster/node?nodeId=" + stats[args.dataIndex].nodeId + "&clusterId=" + stats[args.dataIndex].clusterId
			}
		})
	}

	/**
	 * 系统信息
	 */
	this.reloadCPUChart = function () {
		let axis = {unit: "%", divider: 1}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: '#61A0A8' // 开始颜色
						}, {
							offset: 1, color: '#8ECAD0' // 结束颜色
						}]
					},
					shadowColor: 'rgba(97, 160, 168, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(97, 160, 168, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(97, 160, 168, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "cpu-chart",
			name: "CPU",
			values: this.cpuValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			customOptions: customOptions
		})
	}

	this.reloadMemoryChart = function () {
		let axis = {unit: "%", divider: 1}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: '#F39494' // 开始颜色
						}, {
							offset: 1, color: '#F7B5B5' // 结束颜色
						}]
					},
					shadowColor: 'rgba(243, 148, 148, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(243, 148, 148, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(243, 148, 148, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "memory-chart",
			name: "内存",
			values: this.memoryValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + (Math.ceil(stats[args.dataIndex].value * 100 * 100) / 100) + "%"
			},
			value: function (v) {
				return v.value * 100;
			},
			axis: axis,
			max: 100,
			customOptions: customOptions
		})
	}

	this.reloadLoadChart = function () {
		let axis = {unit: "", divider: 1}
		let max = this.loadValues.$map(function (k, v) {
			return v.value
		}).$max()
		if (max < 10) {
			max = 10
		} else if (max < 20) {
			max = 20
		} else if (max < 100) {
			max = 100
		} else {
			max = null
		}
		
		// 添加现代化样式选项
		let customOptions = {
			series: [{
				lineStyle: {
					width: 3,
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: getCssVariable('--color-text-active', '#app') // 开始颜色
						}, {
							offset: 1, color: getCssVariable('--color-text-active', '#app') // 结束颜色
						}]
					},
					shadowColor: 'rgba(255, 90, 0, 0.3)',
					shadowBlur: 10,
				},
				areaStyle: {
					color: {
						type: 'linear',
						x: 0,
						y: 0,
						x2: 0,
						y2: 1,
						colorStops: [{
							offset: 0, color: 'rgba(255, 90, 0, 0.3)' // 开始颜色
						}, {
							offset: 1, color: 'rgba(255, 90, 0, 0.05)' // 结束颜色
						}]
					}
				},
				symbolSize: 6,
				showSymbol: false
			}],
			grid: {
				top: 20,
				right: 30,
				bottom: 30
			},
			xAxis: {
				axisLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.1)'
					}
				},
				axisTick: {
					show: false
				}
			},
			yAxis: {
				axisLine: {
					show: false
				},
				axisTick: {
					show: false
				},
				splitLine: {
					lineStyle: {
						color: 'rgba(0, 0, 0, 0.05)',
						type: 'dashed'
					}
				}
			},
			tooltip: {
				backgroundColor: 'rgba(255, 255, 255, 0.9)',
				borderColor: 'rgba(0, 0, 0, 0.1)',
				textStyle: {
					color: '#333',
				},
				padding: [8, 12],
				extraCssText: 'box-shadow: 0 2px 8px rgba(0, 0, 0, 0.1);'
			}
		}
		
		teaweb.renderLineChart({
			id: "load-chart",
			name: "负载",
			values: this.loadValues,
			x: function (v) {
				return v.time
			},
			tooltip: function (args, stats) {
				return stats[args.dataIndex].time + "：" + stats[args.dataIndex].value
			},
			value: function (v) {
				return v.value;
			},
			axis: axis,
			max: max,
			customOptions: customOptions
		})
	}

	// 点击卡片跳转
	this.goToURL = function(url) {
		window.location.href = url
	}
})