Tea.context(function () {
    const t = this.t.bind(this)
    this.checkedAll = false
    this.checkedTaskIds = []
    this.tableData = []
    let that = this

    this.$delay(function () {
        this.reload()
    })

    this.getTableData = function() {
        let tableData = [];
        that.clusters.forEach(function(cluster) {
            cluster.tasks.forEach(function(task) {
                tableData.push({
                    id: task.id,
                    isChecked: that.checkedTaskIds.includes(task.id),
                    clusterId: cluster.id,
                    clusterName: cluster.name,
                    nodeId: task.node.id,
                    nodeName: task.node.name,
                    type: task.type,
                    isDone: task.isDone,
                    error: task.error,
                    updatedTime: task.updatedTime,
                    ...task
                });
            });
        });
        that.tableData = tableData
    }

    this.checkAll = function (b) {
        that.checkedAll = b
        that.tableData.forEach(function (item, index) {
            Vue.set(that.tableData[index], 'isChecked', b)
        })
    }

    this.checkTask = function (b) {
        that.checkedTaskIds = b
        let findIndex = that.tableData.findIndex(item => item.id == b)
        if (findIndex != -1) {
            that.tableData[findIndex].isChecked = b
        }
    }

    this.countCheckedTasks = function () {
        let count = 0
        that.tableData.forEach(function (item) {
            if (item.isChecked) {
                count++
            }
        })
        return count
    }

    this.reload = function () {
        this.$post("$")
            .success(function (resp) {
                that.countTasks = resp.data.countTasks
                that.clusters = resp.data.clusters
                that.checkedTaskIds = []
                that.checkedAll = false
                that.getTableData()
            })
            // .done(function () {
            //     this.$delay(function () {
            //         // 没有选中任务的时候才重新刷新
            //         if (this.countCheckedTasks() == 0) {
            //             this.reload()
            //         }
            //     }, 3000)
            // })
    }

    this.deleteTask = function (taskId) {
        teaweb.confirm(t('clusters@确定要删除这个任务吗'), function () {
            that.$post(".delete")
                .params({
                    taskId: taskId
                })
                .success(function () {
                    teaweb.reload()
                })
        })
    }

    this.deleteBatch = function () {
        let taskIds = []
        that.tableData.forEach(function (item) {
            if (item.isChecked) {
                taskIds.push(item.id)
            }
        })
        teaweb.confirm(t('clusters@确定要批量删除选中的任务吗'), function () {
            that.$post(".deleteBatch")
                .params({
                    taskIds: taskIds
                })
                .success(function () {
                    teaweb.reload()
                })
        })
    }

	this.deleteAllTasks = function () {
		teaweb.confirm(t('clusters@确定要清空所有的任务吗'), function () {
			that.$post(".deleteAll")
				.success(function () {
					teaweb.reload()
				})
		})
	}
})