Tea.context(function () {
	const t = this.t.bind(this)
	// 表格列配置
	this.columns = [
		{
			title: t('节点'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('集群'),
			dataIndex: 'cluster',
			key: 'cluster',
			scopedSlots: { customRender: 'clusterSlot' },
			width: '30%'
		},
		{
			title: t('区域'),
			dataIndex: 'region',
			key: 'region',
			scopedSlots: { customRender: 'regionSlot' },
			width: '30%'
		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '100px',
			align: 'center'
		}
	];

	this.updateNodeRegion = function (node) {
		let nodeId = node.id
		let regionId = (node.region ? node.region.id : 0)

		teaweb.popup(Tea.url(".updateNodeRegionPopup", {
			title: t("修改节点区域"),
			nodeId: nodeId,
			regionId: regionId,
		}), {
			title: t("修改节点区域"),
			callback: function () {
				teaweb.successRefresh(t("保存成功"))
			}
		})
	}
})