Tea.context(function () {
	// 表格列配置
	const t = this.t.bind(this)
	this.columns = [
		{
			title: '',
			dataIndex: 'handle',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '60px',
			align: 'center'
		},
		{
			title: t('clusters_regions@区域名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' },
			width: '150px'
		},
		{
			title: t('clusters_regions@区域说明'),
			dataIndex: 'description',
			key: 'description',
			scopedSlots: { customRender: 'descriptionSlot' }
		},
		{
			title: t('clusters_regions@节点数'),
			dataIndex: 'countNodes',
			key: 'countNodes',
			scopedSlots: { customRender: 'countNodesSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: t('clusters_regions@区域状态'),
			dataIndex: 'isOn',
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '150px'
		},
		{
			title: t('clusters_regions@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];
	
	// 排序函数
	this.onSort = function (items) {
		
		this.$post(".sort")
			.params({
				regionIds: items
			})
			.success(function () {
				teaweb.successToast(t('clusters_regions@排序保存成功'))
			});
	};

	this.createRegion = function () {
		teaweb.popup(Tea.url(".createPopup"), {
			title: t('clusters_regions@创建区域'),
			callback: function () {
				teaweb.success(t('clusters_regions@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateRegion = function (regionId) {
		teaweb.popup(Tea.url(".updatePopup?regionId=" + regionId), {
			title: t('clusters_regions@编辑区域'),
			callback: function () {
				teaweb.success(t('clusters_regions@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteRegion = function (regionId) {
		let that = this
		teaweb.confirm(t('clusters_regions@确定要删除这个区域吗'), function () {
			that.$post(".delete")
				.params({
					regionId: regionId
				})
				.refresh()
		})
	}
})