Tea.context(function () {
	const t = this.t.bind(this)
	this.$delay(function () {
		teaweb.datepicker("day-from-picker")
		teaweb.datepicker("day-to-picker")
	})

	this.updateRead = function (logId) {
		this.$post(".readLogs")
			.params({
				logIds: [logId]
			})
			.success(function () {
				teaweb.reload()
			})
	}

	this.updatePageRead = function () {
		let logIds = this.logs.map(function (v) {
			return v.id
		})
		this.$post(".readLogs")
			.params({
				logIds: logIds
			})
			.success(function () {
				teaweb.reload()
			})
	}

	this.updateNodeRead = function (nodeId) {
		this.$post(".readLogs")
			.params({
				nodeId: nodeId
			})
			.success(function () {
				teaweb.reload()
			})
	}

	this.updateAllRead = function () {
		this.$post(".readAllLogs")
			.params({})
			.success(function () {
				teaweb.reload()
			})
	}

	this.changeCluster = function (clusterId) {
		this.clusterId = clusterId
	}

	this.fixLog = function (logId) {
		this.$post(".fix")
			.params({
				logIds: [logId]
			})
			.success(function () {
				teaweb.reload()
			})
	}

	this.fixPageLogs = function () {
		let logIds = this.logs.map(function (v) {
			return v.id
		})
		const that = this
		teaweb.confirm(t('clusters_logs@确定已修复并消除当前页的问题'), function () {
			that.$post(".fix")
				.params({
					logIds: logIds
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.fixAllLogs = function () {
		const that = this
		teaweb.confirm(t('clusters_logs@确定已修复并消除所有的问题'), function () {
			that.$post(".fixAll")
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.deleteLogs = function () {
		const that = this
		const message = t('clusters_logs@确定要删除当前关键词x匹配的y个运行日志',[this.searchedKeyword, this.countLogs])
		teaweb.confirm(message, function () {
			that.$post(".deleteAll")
				.params({
					dayFrom: this.dayFrom,
					dayTo: this.dayTo,
					keyword: this.keyword,
					level: this.level,
					type: this.type,
					tag: this.tag,
					clusterId: this.clusterId,
					nodeId: this.nodeId
				})
				.success(function () {
					teaweb.reload()
				})
		})
	}

	this.columns = [
		{
			title: t('clusters_logs@集群Col'),
			dataIndex: 'cluster',
			key: 'cluster',
			scopedSlots: { customRender: 'clusterSlot' },
			width: '20%'
		},
		{
			title: t('clusters_logs@节点Col'),
			dataIndex: 'node',
			key: 'node',
			scopedSlots: { customRender: 'nodeSlot' },
			width: '20%'
		},
		{
			title: t('clusters_logs@信息Col'),
			dataIndex: 'info',
			key: 'info',
			scopedSlots: { customRender: 'infoSlot' }
		},
		{
			title: t('clusters_logs@操作Col'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '5em',
			align: 'center'
		}
	];
})