Tea.context(function () {
	const t = this.t.bind(this)
	this.createScript = function () {
		teaweb.popup(".createPopup", {
			title: t('grants_scripts_index@创建脚本'),
			height: "28em",
			callback: function () {
				teaweb.successRefresh(t('grants_scripts_index@保存成功'))
			}
		})
	}

	this.updateScript = function () {
		teaweb.popup(".updatePopup", {
			height: "28em",
			callback: function () {
				teaweb.successRefresh(t('grants_scripts_index@保存成功'))
			}
		})
	}

	this.deleteScript = function (scriptId) {
		let that = this
		teaweb.confirm(t('grants_scripts_index@确定要删除此脚本吗'), function () {
			that.$post(".delete")
				.params({
					scriptId: scriptId
				})
				.refresh()
				.success()
		})
	}

	this.columns = [
		{
			title: t('grants_scripts_index@脚本名'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('grants_scripts_index@修改时间'),
			dataIndex: 'updatedTime',
			key: 'updatedTime',
			scopedSlots: { customRender: 'updatedTimeSlot' }
		},
		{
			title: t('grants_scripts_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '15%'
		}
	];
})