Tea.context(function () {
	const t = this.t.bind(this)
	this.deleteGrant = function (grantId) {
		teaweb.confirm(t('grants_index@确定要删除此认证吗'), function () {
			this.$post(".delete")
				.params({
					"grantId": grantId
				})
				.refresh();
		});
	};

	this.columns = [
		{
			title: t('grants_index@名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('grants_index@类型'),
			dataIndex: 'method',
			key: 'method',
			scopedSlots: { customRender: 'methodSlot' }
		},
		{
			title: t('grants_index@用户名'),
			dataIndex: 'username',
			key: 'username',
			scopedSlots: { customRender: 'usernameSlot' }
		},
		{
			title: t('grants_index@集群数'),
			dataIndex: 'countClusters',
			key: 'countClusters',
			scopedSlots: { customRender: 'clustersSlot' },
			width: '10%',
			align: 'center'
		},
		{
			title: t('grants_index@节点数'),
			dataIndex: 'countNodes',
			key: 'countNodes',
			scopedSlots: { customRender: 'nodesSlot' },
			width: '10%',
			align: 'center'
		},
		{
			title: t('grants_index@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '15%'
		}
	];
});