Tea.context(function () {
    const t = this.t.bind(this);
    this.isInstalling = false
    this.isBatch = false
    let installingNode = null
    // 选中行的 ID 列表
    this.selectedNodeIds = [];
    this.$delay(function () {
        this.reload()
    })

    let that = this


    this.installNode = function (node) {
        let that = this
        if (this.isBatch) {
            installingNode = node
            that.isInstalling = true
            node.isInstalling = true // 标记单个节点正在安装

            that.$post("$")
                .params({
                    nodeId: node.id
                })
        } else {
            teaweb.confirm(t("clusters_cluster_upgradeRemote_js@确定要开始升级此节点吗"), function () {
                installingNode = node
                that.isInstalling = true
                node.isInstalling = true // 标记单个节点正在安装

                that.$post("$")
                    .params({
                        nodeId: node.id
                    })
            })
        }
    }

    // 更新批量安装方法
    this.installBatch = function () {
        let nodeIds = this.selectedNodeIds;
        if (nodeIds.length == 0) {
            teaweb.warn(t("clusters_cluster_upgradeRemote_js@请至少选择一个要升级的节点"))
            return;
        }
        let that = this
        this.isBatch = true
        teaweb.confirm(t("clusters_cluster_upgradeRemote_js@确定要批量升级选中的N个节点吗", {count: nodeIds.length}), function () {
            that.isInstalling = true; // 开始批量安装时设置总状态
            that.installNext()
        })
    }

    /**
     * 安装下一个
     */
    this.installNext = function () {
        let that = this
        // 从 selectedNodeIds 中找到第一个符合条件的 node
        let nextNode = that.nodes.$find(function (k, v) {
             // 确保节点存在于 selectedNodeIds 且尚未标记为 isInstalling（或者根据需要调整逻辑）
            return that.selectedNodeIds.includes(v.id) && !v.isInstalling;
        })


        if (nextNode == null) {
            teaweb.success(t("clusters_cluster_upgradeRemote_js@全部升级成功"), function () {
                teaweb.reload()
            })
        } else {
            this.installNode(nextNode)
        }
        return
    }


    /**
     * 重新加载状态
     */
    this.reload = function () {
        let that = this
        if (installingNode != null) {
            this.$post("/clusters/cluster/upgradeStatus")
                .params({
                    nodeId: installingNode.id // 检查当前关注的节点
                })
                .success(function (resp) {
                    if (resp.data.status != null) {
                        installingNode.installStatus = resp.data.status
                        if (installingNode.installStatus.isFinished) {
                            if (installingNode.installStatus.isOk) {
                                installingNode.isChecked = false // 取消选中
                                installingNode = null
                                if (that.isBatch) {
                                    that.installNext()
                                } else {
                                    teaweb.success(t("clusters_cluster_upgradeRemote_js@升级成功"), function () {
                                        teaweb.reload()
                                    })
                                }
                            } else {
                                let nodeId = installingNode.id
                                let errMsg = installingNode.installStatus.error
                                that.isInstalling = false
                                installingNode.isInstalling = false
                                installingNode = null

                                switch (resp.data.status.errorCode) {
                                    case "EMPTY_LOGIN":
                                    case "EMPTY_SSH_HOST":
                                    case "EMPTY_SSH_PORT":
                                    case "EMPTY_GRANT":
                                        teaweb.warn(t("clusters_cluster_upgradeRemote_js@需要填写SSH登录信息"), function () {
                                            teaweb.popup("/clusters/cluster/updateNodeSSH?nodeId=" + nodeId, {
                                                title: t("clusters_cluster_upgradeRemote_js@修改节点SSH登录信息"),
												height: "30em",
                                                callback: function () {
                                                    teaweb.reload()
                                                }
                                            })
                                        })
                                        return
                                    case "CREATE_ROOT_DIRECTORY_FAILED":
                                        teaweb.warn(t("clusters_cluster_upgradeRemote_js@创建根目录失败请检查目录权限或者手工创建", [errMsg]))
                                        return
                                    case "INSTALL_HELPER_FAILED":
                                        teaweb.warn(t("clusters_cluster_upgradeRemote_js@安装助手失败", [errMsg]))
                                        return
                                    case "TEST_FAILED":
                                        teaweb.warn(t("clusters_cluster_upgradeRemote_js@环境测试失败", [errMsg]))
                                        return
                                    case "RPC_TEST_FAILED":
                                        teaweb.confirm(t("clusters_cluster_upgradeRemote_js@RPC通讯测试失败具体错误", [errMsg]), function () {
                                            window.location = "/settings/api"
                                        })
                                        return
                                    default:
                                        teaweb.warn(t("clusters_cluster_upgradeRemote_js@升级失败", [errMsg]))
                                }
                            }
                        }
                    }
                })
                .done(function () {
                    // 稍微增加轮询间隔，避免过于频繁的请求
                    setTimeout(this.reload, 3000);
                })
        } else {
            setTimeout(this.reload, 3000)
        }
    }


    // 表格列定义
    this.columns = [
        // { // 复选框列由 b-table 的 row-selection 自动处理，不需要在这里定义
        //     title: '',
        //     key: 'checkbox',
        //     width: '3em'
        // },
        {
            title: t('clusters_cluster_upgradeRemote_js@节点名'),
            key: 'name',
            scopedSlots: { customRender: 'nameSlot' }
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@访问IP'),
            key: 'ip',
            scopedSlots: { customRender: 'ipSlot' },
            width: '200px' // 给点宽度
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@SSH地址'),
            key: 'ssh',
            scopedSlots: { customRender: 'sshSlot' },
             width: '200px' // 给点宽度
        },
         {
            title: t('clusters_cluster_upgradeRemote_js@版本变化'),
            key: 'version',
            scopedSlots: { customRender: 'versionSlot' },
            width: '150px'
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@节点状态'),
            key: 'status',
            scopedSlots: { customRender: 'statusSlot' },
            width: '250px', // 调整宽度以适应更详细的状态
            align: 'center'
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@操作'),
            key: 'action',
            scopedSlots: { customRender: 'actionSlot' },
            width: '120px', // 调整宽度
            align: 'center'
        }
    ];
})