Tea.context(function () {
	const t = this.t.bind(this)
	this.success = NotifyReloadSuccess(t("acme_users_index_js@保存成功"))
	this.createThreshold = function () {
		teaweb.popup(Tea.url(".createPopup", {
			title: t("clusters_cluster_settings_thresholds_index_js@创建阈值"),
			clusterId: this.clusterId
		}), {
			height: "30em",
			width: "40em",
			title: t("clusters_cluster_settings_thresholds_index_js@创建阈值"),
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateThreshold = function (thresholdId) {
		teaweb.popup(Tea.url(".updatePopup", {
			thresholdId: thresholdId
		}), {
			height: "30em",
			width: "40em",
			title: t("clusters_cluster_settings_thresholds_index_js@修改阈值"),
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteThreshold = function (thresholdId) {
		let that = this
		teaweb.confirm(t("clusters_cluster_settings_thresholds_index_js@确定要删除这个阈值吗"), function () {
			that.$post(".delete")
				.params({
					thresholdId: thresholdId
				})
				.success(function () {
					teaweb.success(t("clusters_cluster_settings_thresholds_index_js@删除成功"), function () {
						teaweb.reload()
					})
				})
		})
	}
})