Tea.context(function () {
	const t = this.t.bind(this)
	this.columns = [
		{
			title: t('clusters_cluster_settings_metrics_index_js@指标名称'),
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('clusters_cluster_settings_metrics_index_js@统计对象'),
			key: 'keys',
			scopedSlots: { customRender: 'keysSlot' }
		},
		{
			title: t('clusters_cluster_settings_metrics_index_js@统计周期'),
			key: 'period',
			scopedSlots: { customRender: 'periodSlot' },
			width: '120px'
		},
		{
			title: t('clusters_cluster_settings_metrics_index_js@统计数值'),
			key: 'value',
			scopedSlots: { customRender: 'valueSlot' },
			width: '150px'
		},
		{
			title: t('clusters_cluster_settings_metrics_index_js@状态'),
			key: 'status',
			scopedSlots: { customRender: 'statusSlot' },
			width: '100px',
			align: 'center'
		},
		{
			title: t('clusters_cluster_settings_metrics_index_js@操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '100px',
			align: 'center'
		}
	];

	this.success = NotifyReloadSuccess(t("acme_users_index_js@保存成功"));
	this.createItem = function () {
		teaweb.popup(Tea.url(".createPopup", {
			title: t("clusters_cluster_settings_metrics_index_js@创建指标"),
			clusterId: this.clusterId,
			category: this.category
		}), {
			callback: function () {
				teaweb.success(t("acme_users_index_js@保存成功"), function () {
					teaweb.reload()
				})
			},
			onClose: function () {
				teaweb.reload()
			},
			title: t("clusters_cluster_settings_metrics_index_js@创建指标"),
			width: "50em",
			height: "25em"
		})
	}

	this.deleteItem = function (itemId) {
		let that = this
		teaweb.confirm(t("clusters_cluster_settings_metrics_index_js@确定要删除这个指标吗"), function () {
			that.$post(".delete")
				.params({
					clusterId: that.clusterId,
					itemId: itemId
				})
				.success(function () {
					teaweb.success(t("clusters_cluster_settings_metrics_index_js@删除成功"), function () {
						teaweb.reload()
					})
				})
		})
	}
})