Tea.context(function () {
    const t = this.t.bind(this)
    this.success = NotifyReloadSuccess(t("acme_users_index_js@保存成功"));
    this.createAction = function () {
        teaweb.popup(Tea.url(".createPopup", {
            clusterId: this.clusterId
        }), {
            title: t("firewall_actions_index_js@创建动作"),
            callback: function () {
                teaweb.success(t("acme_users_index_js@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.updateAction = function (actionId) {
        teaweb.popup(Tea.url(".updatePopup", {actionId: actionId}), {
            title: t("firewall_actions_index_js@修改动作"),
            callback: function () {
                teaweb.success(t("acme_users_index_js@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.deleteAction = function (actionId) {
        let that = this
        teaweb.confirm(t("firewall_actions_index_js@确定要删除此动作吗"), function () {
            that.$post(".delete")
                .params({
                    actionId: actionId
                })
                .success(function () {
                   teaweb.success(t("firewall_actions_index_js@删除成功"), function () {
                       teaweb.reload()
                   })
                })
        })
    }

    this.columns = [
        {
            title: t("firewall_actions_index_js@名称"),
            key: 'name',
            scopedSlots: { customRender: 'nameSlot' }
        },
        {
            title: t("firewall_actions_index_js@类型"),
            dataIndex: 'typeName',
            key: 'type',
            scopedSlots: { customRender: 'typeSlot' },
            width: '200px'
        },
        {
            title: t("firewall_actions_index_js@操作"),
            key: 'action',
            scopedSlots: { customRender: 'actionSlot' },
            width: '150px',
            align: 'center'
        }
    ];
})