Tea.context(function () {
	const t = this.t.bind(this);
	this.createThreshold = function () {
		teaweb.popup(Tea.url("/clusters/cluster/settings/thresholds/createPopup", {
			title: t('node_thresholds_index_js@添加阈值'),
			clusterId: this.clusterId,
			nodeId: this.nodeId
		}), {
			height: "30em",
			title: t('node_thresholds_index_js@添加阈值'),
			callback: function () {
				teaweb.success(t('acme_users_index_js@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateThreshold = function (thresholdId) {
		teaweb.popup(Tea.url("/clusters/cluster/settings/thresholds/updatePopup", {
			title: t('node_thresholds_index_js@修改阈值'),
			thresholdId: thresholdId
		}), {
			height: "30em",
			title: t('node_thresholds_index_js@修改阈值'),
			callback: function () {
				teaweb.success(t('acme_users_index_js@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteThreshold = function (thresholdId) {
		let that = this
		teaweb.confirm(t('node_thresholds_index_js@确定要删除这个阈值吗'), function () {
			that.$post("/clusters/cluster/settings/thresholds/delete")
				.params({
					thresholdId: thresholdId
				})
				.success(function () {
					teaweb.success(t('node_thresholds_index_js@删除成功'), function () {
						teaweb.reload()
					})
				})
		})
	}
})