Tea.context(function () {
    const t = this.t.bind(this)
    this.isInstalling = false
    this.isBatch = false
    let installingNode = null
    // 选中行的 ID 列表
    this.selected = [];

    this.nodes.forEach(function (v) {
        v.isChecked = false
    })

    this.$delay(function () {
        this.reload()
    })

    let that = this

    this.checkNodes = function (isChecked) {
        this.nodes.forEach(function (v) {
            v.isChecked = isChecked
        })
    }

    this.countCheckedNodes = function () {
        return that.nodes.$count(function (k, v) {
            return v.isChecked
        })
    }

    this.installNode = function (node) {
        let that = this
        if (this.isBatch) {
            installingNode = node
            that.isInstalling = true
            node.isInstalling = true

            that.$post("$")
                .params({
                    nodeId: node.id
                })
        } else {
            teaweb.confirm(t('clusters_cluster_installRemote@确定要开始安装此节点吗'), function () {
                installingNode = node
                that.isInstalling = true
                node.isInstalling = true

                that.$post("$")
                    .params({
                        nodeId: node.id
                    }).success(function () {
                        that.isInstalling = false
                        node.isInstalling = false
                    })
            })
        }
    }

    /**
     * 安装下一个
     */
    this.installNext = function () {
        let that = this
        let nextNode = that.nodes.$find(function (k, v) {
            return that.selected.includes(v.id)
        })

        if (nextNode == null) {
            teaweb.success(t('clusters_cluster_installRemote@全部安装成功'), function () {
                teaweb.reload()
            })
        } else {
            this.installNode(nextNode)
        }
        return
    }

    /**
     * 重新加载状态
     */
    this.reload = function () {
        let that = this
        if (installingNode != null) {
            this.$post("/clusters/cluster/installStatus")
                .params({
                    nodeId: installingNode.id
                })
                .success(function (resp) {
                    if (resp.data.status != null) {
                        installingNode.installStatus = resp.data.status
                        if (installingNode.installStatus.isFinished) {
                            if (installingNode.installStatus.isOk) {
                                installingNode.isChecked = false // 取消选中
                                this.selected = this.selected.filter(id => id !== installingNode.id)
                                installingNode = null
                                if (that.isBatch) {
                                    that.installNext()
                                } else {
                                    teaweb.success(t('clusters_cluster_installRemote@安装成功'), function () {
                                        teaweb.reload()
                                    })
                                }
                            } else {
                                let nodeId = installingNode.id
                                let errMsg = installingNode.installStatus.error
                                that.isInstalling = false
                                installingNode.isInstalling = false
                                installingNode = null

                                switch (resp.data.status.errorCode) {
                                    case "EMPTY_LOGIN":
                                    case "EMPTY_SSH_HOST":
                                    case "EMPTY_SSH_PORT":
                                    case "EMPTY_GRANT":
                                        teaweb.warn(t('node_installJS@需要填写SSH登录信息'), function () {
                                            teaweb.popup("/clusters/cluster/updateNodeSSH?nodeId=" + nodeId, {
                                                title: t('node_installJS@修改节点的SSH登录信息'),
												height: "30em",
                                                callback: function () {
                                                    teaweb.reload()
                                                }
                                            })
                                        })
                                        return
                                    case "SSH登录失败，请检查设置":
                                        teaweb.warn(t('node_installJS@需要填写SSH登录信息'), function () {
                                            teaweb.popup("/clusters/cluster/updateNodeSSH?nodeId=" + nodeId, {
                                                title: t('node_installJS@修改节点的SSH登录信息'),
												height: "30em",
                                                callback: function () {
                                                    teaweb.reload()
                                                }
                                            })
                                        })
                                        return
                                    case "CREATE_ROOT_DIRECTORY_FAILED":
                                        teaweb.warn(t("node_installJS@创建根目录失败请检查目录权限或者手工创建Value", [errMsg]))
                                        return
                                    case "INSTALL_HELPER_FAILED":
                                        teaweb.warn(t("node_installJS@安装助手失败Value", [errMsg]))
                                        return
                                    case "TEST_FAILED":
                                        teaweb.warn(t("node_installJS@环境测试失败Value", [errMsg]))
                                        return
                                    case "RPC_TEST_FAILED":
                                        teaweb.confirm(t("node_installJS@html要安装的节点到API服务之间的RPC通讯测试失败具体错误Valuebr现在修改API信息", [errMsg]), function () {
                                            window.location = "/settings/api"
                                        })
                                        return
                                    default:
                                        teaweb.warn(t("node_installJS@安装失败Value", [errMsg]))
                                }
                            }
                        }
                    }
                })
                .done(function () {
                    setTimeout(this.reload, 3000)
                })
        } else {
            setTimeout(this.reload, 3000)
        }
    }

    // === 新增/修改部分 开始 ===


    // 表格列定义
    this.columns = [
        {
            title: t('clusters_cluster_upgradeRemote_js@节点名'),
            key: 'name',
            scopedSlots: { customRender: 'nameSlot' }
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@访问IP'),
            key: 'ip',
            scopedSlots: { customRender: 'ipSlot' }
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@SSH地址'),
            key: 'ssh',
            scopedSlots: { customRender: 'sshSlot' }
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@节点状态'),
            key: 'status',
            scopedSlots: { customRender: 'statusSlot' },
            width: '250px',
            align: 'center'
        },
        {
            title: t('clusters_cluster_upgradeRemote_js@操作'),
            key: 'action',
            scopedSlots: { customRender: 'actionSlot' },
            width: '150px',
            align: 'center'
        }
    ];

    // 修改批量安装方法
    this.installBatch = function () {
        let nodeIds = this.selected;
        if (nodeIds.length == 0) {
            teaweb.warn(t('clusters_cluster_installRemote@请至少选择一个要安装的节点'))
            return;
        }
        let that = this
        this.isBatch = true
        teaweb.confirm(t('clusters_cluster_installRemote@确定要批量安装选中的节点吗'), function () {
            that.installNext()
        })
        // this.selectedRowKeys = []; // 临时清空选择
    };
})