Tea.context(function () {
	const t = this.t.bind(this)
	this.$delay(function () {
		let that = this
		sortTable(function () {
			let groupIds = []
			document.querySelectorAll("*[data-group-id]").forEach(function (element) {
				groupIds.push(element.getAttribute("data-group-id"))
			})
			that.$post("/clusters/cluster/groups/sort")
				.params({
					groupIds: groupIds
				})
				.success(function () {
					teaweb.successToast(t("保存成功"))
				})
		})
	})

	this.createGroup = function () {
		teaweb.popup("/clusters/cluster/groups/createPopup?clusterId=" + this.clusterId, {
			title: t('创建分组'),
			callback: function () {
				teaweb.success(t("保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateGroup = function (groupId) {
		teaweb.popup("/clusters/cluster/groups/updatePopup?groupId=" + groupId, {
			title: t('修改分组'),
			callback: function () {
				teaweb.success(t("保存成功"), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.deleteGroup = function (groupId) {
		let that = this
		teaweb.confirm(t("确定要删除这个分组吗？"), function () {
			that.$post("/clusters/cluster/groups/delete")
				.params({
					groupId: groupId
				})
				.success(function () {
					teaweb.success(t("删除成功"), function () {
						teaweb.reload()
					})
				})
		})
	}

	// 表格列定义
	this.columns = [
		{
			title: '',
			key: 'handle',
			scopedSlots: { customRender: 'handleSlot' },
			width: '50px',
			align: 'center'
		},
		{
			title: t('分组名称'),
			dataIndex: 'name',
			key: 'name',
			scopedSlots: { customRender: 'nameSlot' }
		},
		{
			title: t('节点数'),
			dataIndex: 'countNodes',
			key: 'count',
			scopedSlots: { customRender: 'countSlot' },
			width: '150px',
			align: 'center'
		},
		{
			title: t('操作'),
			key: 'action',
			scopedSlots: { customRender: 'actionSlot' },
			width: '150px',
			align: 'center'
		}
	];

	// 处理拖拽排序的方法
	this.handleSort = function (newDataSource) {

		// 在这里添加调用后端 API 保存排序的逻辑
		// 例如:
		this.$post("/clusters/cluster/groups/sort")
			.params({
				groupIds: newDataSource
			})
			.success(function () {
				teaweb.successToast(t("保存成功"))
				teaweb.reload()
			})

	};
})