Tea.context(function () {
	const t = this.t.bind(this);
	this.createUserInstance = function () {
		teaweb.popup(".createPopup", {
			title: t("anti-ddos_user_instances_index@创建用户实例"),
			height: "32em",
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_user_instances_index@保存成功"))
			}
		})
	}

	this.renewUserInstance = function (userInstanceId) {
		teaweb.popup(".renewPopup?userInstanceId=" + userInstanceId, {
			height: "26em",
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_user_instances_index@续期成功"))
			}
		})
	}

	this.updateObjectsPopup = function (userInstanceId) {
		teaweb.popup(".updateObjectsPopup?userInstanceId=" + userInstanceId, {
			width: "60em",
			height: "40em",
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_user_instances_index@保存成功"))
			}
		})
	}

	this.deleteUserInstance = function (userInstanceId) {
		let that = this
		teaweb.confirm(t("anti-ddos_user_instances_index@确定要删除此用户实例吗"), function () {
			that.$post(".delete")
				.params({
					userInstanceId: userInstanceId
				})
				.success(function () {
					teaweb.successRefresh(t("anti-ddos_user_instances_index@删除成功"))
				})
		})
	}
})