Tea.context(function () {
	const t = this.t.bind(this);
	this.createPeriod = function () {
		teaweb.popup("/clusters/anti-ddos/periods/createPopup", {
			title: t("anti-ddos_periods_index@添加有效期选项"),
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_periods_index@保存成功"))
			}
		})
	}

	this.updatePeriod = function (periodId) {
		teaweb.popup("/clusters/anti-ddos/periods/period/updatePopup?periodId=" + periodId, {
			title: t("anti-ddos_periods_index@修改有效期选项"),
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_periods_index@保存成功"))
			}
		})
	}

	this.deletePeriod = function (periodId) {
		let that = this
		teaweb.confirm(t("anti-ddos_periods_index@确定要删除此有效期选项吗"), function () {
			that.$post("/clusters/anti-ddos/periods/period/delete")
				.params({
					periodId: periodId
				})
				.success(function () {
					teaweb.success(t("anti-ddos_periods_index@删除成功"), function () {
						teaweb.reload()
					})
				})
		})
	}
})