Tea.context(function () {
	const t = this.t.bind(this);
	this.createNetwork = function () {
		teaweb.popup(".createPopup", {
			title: t("anti-ddos_networks_index@创建线路"),
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_networks_index@保存成功"))
			}
		})
	}

	this.updateNetwork = function (networkId) {
		teaweb.popup(".network.updatePopup?networkId=" + networkId, {
			title: t("anti-ddos_networks_index@修改线路"),
			callback: function () {
				teaweb.successRefresh(t("anti-ddos_networks_index@保存成功"))
			}
		})
	}

	this.deleteNetwork = function (networkId) {
		let that = this
		teaweb.confirm(t("anti-ddos_networks_index@确定要删除此线路吗"), function () {
			that.$post(".network.delete")
				.params({
					networkId: networkId
				})
				.success(function () {
					teaweb.successRefresh(t("anti-ddos_networks_index@删除成功"))
				})
		})
	}
})