Tea.context(function () {
	const t = this.t.bind(this);
	this.createPackage = function () {
		teaweb.popup("/clusters/anti-ddos/createPopup", {
			title: t('anti-ddos@添加高防产品'),
			height: "26em",
			callback: function () {
				teaweb.successRefresh(t("anti-ddos@保存成功"))
			}
		})
	}

	this.updatePackage = function (packageId) {
		teaweb.popup("/clusters/anti-ddos/updatePopup?packageId=" + packageId, {
			title: t('anti-ddos@修改高防产品'),
			height: "26em",
			callback: function () {
				teaweb.successRefresh(t("anti-ddos@保存成功"))
			}
		})
	}

	this.deletePackage = function (packageId) {
		let that = this
		teaweb.confirm(t("anti-ddos@确定要删除此高防产品吗"), function () {
			that.$post(".delete")
				.params({
					packageId: packageId
				})
				.success(function () {
					teaweb.successRefresh(t("anti-ddos@删除成功"))
				})
		})
	}

	this.updatePrices = function (packageId) {
		teaweb.popup("/clusters/anti-ddos/updatePricesPopup?packageId=" + packageId, {
			title: t('anti-ddos@高防产品'),
			height: "30em",
			onClose: function () {
				teaweb.reload()
			}
		})
	}
})

String.prototype.toBitUpper = function () {
	let unit = this
	return unit.replace(/bps$/, "").replace(/b$/, "").toUpperCase() + "bps"
}