Tea.context(function () {
    const t = this.t.bind(this)
    
    this.createInstance = function () {
        teaweb.popup(Tea.url(".createPopup"), {
            title: t("admins_recipients_instances_index@创建接收媒介"),
            height: "30em",
            callback: function () {
                teaweb.success(t("admins_recipients_instances_index@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.deleteInstance = function (instanceId) {
        teaweb.confirm(t("admins_recipients_instances_index@确定要删除此接收媒介吗？"), function () {
            this.$post(".delete")
                .params({instanceId: instanceId})
                .success(function () {
                    teaweb.success(t("admins_recipients_instances_index@删除成功"), function () {
                        teaweb.reload()
                    })
                })
        })
    }

    this.tableColumns = [
        {
            title: t("admins_recipients_instances_index@媒介名称"),
            dataIndex: "name",
            key: "name",
            scopedSlots: { customRender: "nameSlot" },
            minWidth: 200
        },
        {
            title: t("admins_recipients_instances_index@媒介类型"),
            dataIndex: "media",
            key: "media",
            scopedSlots: { customRender: "mediaSlot" },
            width: 150
        },
        {
            title: t("admins_recipients_instances_index@备注"),
            dataIndex: "description",
            key: "description",
            scopedSlots: { customRender: "descriptionSlot" }
        },
        {
            title: t("admins_recipients_instances_index@状态"),
            dataIndex: "isOn",
            key: "status",
            width: 100,
            align: "center",
            scopedSlots: { customRender: "statusSlot" }
        },
        {
            title: t("admins_recipients_instances_index@操作"),
            key: "action",
            width: 150,
            align: "center",
            scopedSlots: { customRender: "actionSlot" }
        }
    ];
})