Tea.context(function () {
    const t = this.t.bind(this)
    
    this.createRecipient = function () {
        teaweb.popup(Tea.url(".createPopup"), {
            title: t("admins_recipients_index@创建接收媒介"),
            height: "27em",
            callback: function () {
                teaweb.success(t("admins_recipients_index@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.deleteRecipient = function (recipientId) {
        teaweb.confirm(t("admins_recipients_index@确定要删除此接收媒介吗？"), function () {
            this.$post(".delete")
                .params({recipientId: recipientId})
                .success(function () {
                    teaweb.success(t("admins_recipients_index@删除成功"), function () {
                        teaweb.reload()
                    })
                })
        })
    }

    this.tableColumns = [
        {
            title: t("admins_recipients_index@系统用户"),
            dataIndex: "admin",
            key: "admin",
            scopedSlots: { customRender: "adminSlot" },
            minWidth: 200
        },
        {
            title: t("admins_recipients_index@媒介类型"),
            dataIndex: "instance",
            key: "instance",
            scopedSlots: { customRender: "instanceSlot" },
            width: 150
        },
        {
            title: t("admins_recipients_index@接收人标识"),
            dataIndex: "user",
            key: "user",
            scopedSlots: { customRender: "userSlot" },
            width: 150
        },
        {
            title: t("admins_recipients_index@所属分组"),
            dataIndex: "groups",
            key: "groups",
            scopedSlots: { customRender: "groupsSlot" }
        },
        {
            title: t("admins_recipients_index@备注"),
            dataIndex: "description",
            key: "description",
            scopedSlots: { customRender: "descriptionSlot" }
        },
        {
            title: t("admins_recipients_index@状态"),
            dataIndex: "isOn",
            key: "status",
            width: 100,
            align: "center",
            scopedSlots: { customRender: "statusSlot" }
        },
        {
            title: t("admins_recipients_index@操作"),
            key: "action",
            width: 150,
            align: "center",
            scopedSlots: { customRender: "actionSlot" }
        }
    ];
})