Tea.context(function () {
    const t = this.t.bind(this)
    
    this.createGroup = function () {
        teaweb.popup(Tea.url(".createPopup"), {
            title: t("admins_recipients_groups_index@创建分组"),
            callback: function () {
                teaweb.success(t("admins_recipients_groups_index@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.updateGroup = function (groupId) {
        teaweb.popup(Tea.url(".updatePopup", {groupId: groupId}), {
            callback: function () {
                teaweb.success(t("admins_recipients_groups_index@保存成功"), function () {
                    teaweb.reload()
                })
            }
        })
    }

    this.deleteGroup = function (groupId) {
        teaweb.confirm(t("admins_recipients_groups_index@确定要删除此分组吗？"), function () {
            this.$post(".delete")
                .params({groupId: groupId})
                .success(function () {
                    teaweb.success(t("admins_recipients_groups_index@删除成功"), function () {
                        teaweb.reload()
                    })
                })
        })
    }

    this.tableColumns = [
        {
            title: t("admins_recipients_groups_index@分组名称"),
            dataIndex: "name",
            key: "name",
            scopedSlots: { customRender: "nameSlot" }
        },
        {
            title: t("admins_recipients_groups_index@状态"),
            dataIndex: "isOn",
            key: "status",
            width: 100,
            align: "center",
            scopedSlots: { customRender: "statusSlot" }
        },
        {
            title: t("admins_recipients_groups_index@操作"),
            key: "action",
            width: 150,
            align: "center",
            scopedSlots: { customRender: "actionSlot" }
        }
    ];
})