Tea.context(function () {
	const t = this.t.bind(this)
	
	this.createAccessKey = function () {
		teaweb.popup("/admins/accesskeys/createPopup?adminId=" + this.admin.id, {
			title: t('admins_accesskeys_index@创建新AccessKey'),
			callback: function () {
				teaweb.success(t('admins_accesskeys_index@保存成功'), function () {
					teaweb.reload()
				})
			}
		})
	}

	this.updateAccessKeyIsOn = function (accessKeyId, isOn) {
		let that = this

		let message = ""
		if (isOn) {
			message = t('admins_accesskeys_index@确定要启用此AccessKey吗？')
		} else {
			message = t('admins_accesskeys_index@确定要禁用此AccessKey吗？')
		}
		teaweb.confirm(message, function () {
			that.$post(".updateIsOn")
				.params({
					accessKeyId: accessKeyId,
					isOn: isOn ? 1 : 0
				})
				.refresh()
		})
	}

	this.deleteAccessKey = function (accessKeyId) {
		let that = this
		teaweb.confirm(t('admins_accesskeys_index@确定要删除此AccessKey吗？'), function () {
			that.$post(".delete")
				.params({
					accessKeyId: accessKeyId
				})
				.refresh()
		})
	}
})