Vue.component("pages-local-config-box", {
	props: ["v-local-config", "v-api-nodes"],
	data: function () {
		let config = this.vLocalConfig
		if (config == null) {
			config = {
				apinodeId: 1,
				storagePath: "",
			}
		}
		return {
			config: config,
			apiNodes: this.vApiNodes,
		}
	},
	watch: {
	},
	methods: {
		// add: function(){
		// 	this.isAdding=true
		// },
		// save: function () {
		// 	this.config.records.push(this.addRecord)
		// 	this.cancel()
		// },
		// remove: function (index) {
		// 	let that = this
		// 	teaweb.confirm("确定要删除此条规则吗？", function () {
		// 		that.config.records.$remove(index)
		// 	})
		// },
		// cancel: function () {
		// 	this.isAdding = false
		// 	this.riskTags.forEach(function (v) {
		// 		v.isChecked = false
		// 	})
		// 	this.addRecord = {
		// 		enable: true,
		// 		riskLevel: 0,
		// 		riskTags: [],
		// 		recordOnly: false,
		// 		action: 1,
		// 	}
		// },
		// changeRiskTag: function () {
		// 	this.addRecord.riskTags = this.riskTags.filter(function (v) {
		// 		return v.isChecked
		// 	}).map(function (v) {
		// 		return v.id
		// 	})
		// },
		
		// //即使设置了input type=number，JSON.stringify 还是会将number转为字符串，这里做下特殊处理
		// changeRiskScore: function(event) {
		// 	const value = parseInt(event.target.value, 10);

		// 	if (value >= 0 && value <= 100) {
		// 	  this.addRecord.riskScore = value;
		// 	} else {
		// 	  event.target.value = this.addRecord.riskScore;
		// 	}
		// }
	},
	template: `<div><input type="hidden" name="settingJSON" :value="JSON.stringify(config)"/>
				  <tr>
            <td>{{$t("pages-local-config-box@选择API节点")}}</td>
            <td>
                <b-select
                name="apinode_id"
                v-model="apinode_id"
                :options="[
                    ...apiNodes.map(node => ({
                        label: node.name??'',
                        value: node.id??'',
                    }))
                ]"
            ></b-select>
            </td>
        </tr>
</div>`
})

// 节点IP阈值
Vue.component("node-ip-address-thresholds-box", {
	props: ["v-thresholds"],
	data: function () {
		let thresholds = this.vThresholds
		if (thresholds == null) {
			thresholds = []
		} else {
			thresholds.forEach(function (v) {
				if (v.items == null) {
					v.items = []
				}
				if (v.actions == null) {
					v.actions = []
				}
			})
		}

		return {
			editingIndex: -1,
			thresholds: thresholds,
			addingThreshold: {
				items: [],
				actions: []
			},
			isAdding: false,
			isAddingItem: false,
			isAddingAction: false,

			itemCode: "nodeAvgRequests",
			itemReportGroups: [],
			itemOperator: "lte",
			itemValue: "",
			itemDuration: "5",
			allItems: window.IP_ADDR_THRESHOLD_ITEMS,
			allOperators: [
				{
					"name": this.$t('node-ip-address-thresholds-box@小于等于'),
					"code": "lte"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@大于'),
					"code": "gt"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@不等于'),
					"code": "neq"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@小于'),
					"code": "lt"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@大于等于'),
					"code": "gte"
				}
			],
			allActions: window.IP_ADDR_THRESHOLD_ACTIONS,

			actionCode: "up",
			actionBackupIPs: "",
			actionWebHookURL: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = !this.isAdding
		},
		cancel: function () {
			this.isAdding = false
			this.editingIndex = -1
			this.addingThreshold = {
				items: [],
				actions: []
			}
		},
		confirm: function () {
			if (this.addingThreshold.items.length == 0) {
				teaweb.warn(this.t("node-ip-address-thresholds-box@需要至少添加一个阈值"))
				return
			}
			if (this.addingThreshold.actions.length == 0) {
				teaweb.warn(this.t("node-ip-address-thresholds-box@需要至少添加一个动作"))
				return
			}

			if (this.editingIndex >= 0) {
				this.thresholds[this.editingIndex].items = this.addingThreshold.items
				this.thresholds[this.editingIndex].actions = this.addingThreshold.actions
			} else {
				this.thresholds.push({
					items: this.addingThreshold.items,
					actions: this.addingThreshold.actions
				})
			}

			// 还原
			this.cancel()
		},
		remove: function (index) {
			this.cancel()
			this.thresholds.$remove(index)
		},
		update: function (index) {
			this.editingIndex = index
			this.addingThreshold = {
				items: this.thresholds[index].items.$copy(),
				actions: this.thresholds[index].actions.$copy()
			}
			this.isAdding = true
		},

		addItem: function () {
			this.isAddingItem = !this.isAddingItem
			let that = this
			setTimeout(function () {
				that.$refs.itemValue.focus()
			}, 100)
		},
		cancelItem: function () {
			this.isAddingItem = false

			this.itemCode = "nodeAvgRequests"
			this.itmeOperator = "lte"
			this.itemValue = ""
			this.itemDuration = "5"
			this.itemReportGroups = []
		},
		confirmItem: function () {
			// 特殊阈值快速添加
			if (["nodeHealthCheck"].$contains(this.itemCode)) {
				if (this.itemValue.toString().length == 0) {
					teaweb.warn(this.$t("node-ip-address-thresholds-box@请选择检查结果"))
					return
				}

				let value = parseInt(this.itemValue)
				if (isNaN(value)) {
					value = 0
				} else if (value < 0) {
					value = 0
				} else if (value > 1) {
					value = 1
				}

				// 添加
				this.addingThreshold.items.push({
					item: this.itemCode,
					operator: this.itemOperator,
					value: value,
					duration: 0,
					durationUnit: "minute",
					options: {}
				})
				this.cancelItem()
				return
			}

			if (this.itemDuration.length == 0) {
				let that = this
				teaweb.warn(this.$t("node-ip-address-thresholds-box@请输入统计周期"), function () {
					that.$refs.itemDuration.focus()
				})
				return
			}
			let itemDuration = parseInt(this.itemDuration)
			if (isNaN(itemDuration) || itemDuration <= 0) {
				teaweb.warn(this.$t("node-ip-address-thresholds-box@请输入正确的统计周期"), function () {
					that.$refs.itemDuration.focus()
				})
				return
			}

			if (this.itemValue.length == 0) {
				let that = this
				teaweb.warn(this.$t("node-ip-address-thresholds-box@请输入对比值"), function () {
					that.$refs.itemValue.focus()
				})
				return
			}
			let itemValue = parseFloat(this.itemValue)
			if (isNaN(itemValue)) {
				teaweb.warn(this.$t("node-ip-address-thresholds-box@请输入正确的对比值"), function () {
					that.$refs.itemValue.focus()
				})
				return
			}


			let options = {}

			switch (this.itemCode) {
				case "connectivity": // 连通性校验
					if (itemValue > 100) {
						let that = this
						teaweb.warn(this.$t("node-ip-address-thresholds-box@连通性对比值不能超过100"), function () {
							that.$refs.itemValue.focus()
						})
						return
					}

					options["groups"] = this.itemReportGroups
					break
			}

			// 添加
			this.addingThreshold.items.push({
				item: this.itemCode,
				operator: this.itemOperator,
				value: itemValue,
				duration: itemDuration,
				durationUnit: "minute",
				options: options
			})

			// 还原
			this.cancelItem()
		},
		removeItem: function (index) {
			this.cancelItem()
			this.addingThreshold.items.$remove(index)
		},
		changeReportGroups: function (groups) {
			this.itemReportGroups = groups
		},
		itemName: function (item) {
			let result = ""
			this.allItems.forEach(function (v) {
				if (v.code == item) {
					result = v.name
				}
			})
			return result
		},
		itemUnitName: function (itemCode) {
			let result = ""
			this.allItems.forEach(function (v) {
				if (v.code == itemCode) {
					result = v.unit
				}
			})
			return result
		},
		itemDurationUnitName: function (unit) {
			switch (unit) {
				case "minute":
					return this.$t("node-ip-address-thresholds-box@分钟")
				case "second":
					return this.$t("node-ip-address-thresholds-box@秒")
				case "hour":
					return this.$t("node-ip-address-thresholds-box@小时")
				case "day":
					return this.$t("node-ip-address-thresholds-box@天")
			}
			return unit
		},
		itemOperatorName: function (operator) {
			let result = ""
			this.allOperators.forEach(function (v) {
				if (v.code == operator) {
					result = v.name
				}
			})
			return result
		},

		addAction: function () {
			this.isAddingAction = !this.isAddingAction
		},
		cancelAction: function () {
			this.isAddingAction = false
			this.actionCode = "up"
			this.actionBackupIPs = ""
			this.actionWebHookURL = ""
		},
		confirmAction: function () {
			this.doConfirmAction(false)
		},
		doConfirmAction: function (validated, options) {
			// 是否已存在
			let exists = false
			let that = this
			this.addingThreshold.actions.forEach(function (v) {
				if (v.action == that.actionCode) {
					exists = true
				}
			})
			if (exists) {
				teaweb.warn(this.$t("node-ip-address-thresholds-box@此动作已添加无需重复"))
				return
			}

			if (options == null) {
				options = {}
			}

			switch (this.actionCode) {
				case "switch":
					if (!validated) {
						Tea.action("/ui/validateIPs")
							.params({
								"ips": this.actionBackupIPs
							})
							.success(function (resp) {
								if (resp.data.ips.length == 0) {
									teaweb.warn(that.$t("node-ip-address-thresholds-box@请输入备用IP"), function () {
										that.$refs.actionBackupIPs.focus()
									})
									return
								}
								options["ips"] = resp.data.ips
								that.doConfirmAction(true, options)
							})
							.fail(function (resp) {
								teaweb.warn(that.$t("node-ip-address-thresholds-box@输入的IP格式不正确", [resp.data.failIP]), function () {
									that.$refs.actionBackupIPs.focus()
								})
							})
							.post()
						return
					}
					break
				case "webHook":
					if (this.actionWebHookURL.length == 0) {
						teaweb.warn(this.$t("node-ip-address-thresholds-box@请输入WebHookURL"), function () {
							that.$refs.webHookURL.focus()
						})
						return
					}
					if (!this.actionWebHookURL.match(/^(http|https):\/\//i)) {
						teaweb.warn(this.$t("node-ip-address-thresholds-box@URL开头必须是http"), function () {
							that.$refs.webHookURL.focus()
						})
						return
					}
					options["url"] = this.actionWebHookURL
			}

			this.addingThreshold.actions.push({
				action: this.actionCode,
				options: options
			})

			// 还原
			this.cancelAction()
		},
		removeAction: function (index) {
			this.cancelAction()
			this.addingThreshold.actions.$remove(index)
		},
		actionName: function (actionCode) {
			let result = ""
			this.allActions.forEach(function (v) {
				if (v.code == actionCode) {
					result = v.name
				}
			})
			return result
		}
	},
	template: `<div>
	<input type="hidden" name="thresholdsJSON" :value="JSON.stringify(thresholds)"/>
		
	<!-- 已有条件 -->
	<div v-if="thresholds.length > 0">
		<div class="ui label basic small" v-for="(threshold, index) in thresholds">
			<span v-for="(item, itemIndex) in threshold.items">
				<span v-if="item.item != 'nodeHealthCheck'">
					[{{item.duration}}{{itemDurationUnitName(item.durationUnit)}}]
				</span> 
				{{itemName(item.item)}}
				
				<span v-if="item.item == 'nodeHealthCheck'">
					<!-- 健康检查 -->
					<span v-if="item.value == 1">{{$t("node-ip-address-thresholds-box@成功")}}</span>
					<span v-if="item.value == 0">{{$t("node-ip-address-thresholds-box@失败")}}</span>
				</span>
				<span v-else>
					<!-- 连通性 -->
					<span v-if="item.item == 'connectivity' && item.options != null && item.options.groups != null && item.options.groups.length > 0">[<span v-for="(group, groupIndex) in item.options.groups">{{group.name}} <span v-if="groupIndex != item.options.groups.length - 1">&nbsp; </span></span>]</span>
				
					<span  class="grey">[{{itemOperatorName(item.operator)}}]</span> &nbsp;{{item.value}}{{itemUnitName(item.item)}} 
			 	</span>
			 	&nbsp;<span v-if="itemIndex != threshold.items.length - 1" style="font-style: italic">AND &nbsp;</span>
			</span>
			-&gt;
			<span v-for="(action, actionIndex) in threshold.actions">{{actionName(action.action)}}
			<span v-if="action.action == 'switch'">到{{action.options.ips.join(", ")}}</span>
			<span v-if="action.action == 'webHook'" class="small grey">({{action.options.url}})</span>
			 &nbsp;<span v-if="actionIndex != threshold.actions.length - 1" style="font-style: italic">AND &nbsp;</span></span>
			&nbsp;
			<a href="" :title="$t('node-ip-address-thresholds-box@修改')" @click.prevent="update(index)"><i class="icon pencil small"></i></a> 
			<a href="" :title="$t('node-ip-address-thresholds-box@删除')" @click.prevent="remove(index)"><i class="icon small remove"></i></a>
		</div>
	</div>
	
	<!-- 新阈值 -->
	<div v-if="isAdding" style="margin-top: 0.5em">
		<table class="ui table celled">
			<thead>
				<tr>
					<th style="background: #f9fafb; box-shadow: none;">{{$t("node-ip-address-thresholds-box@阈值")}}</th>
					<th>{{$t("node-ip-address-thresholds-box@动作")}}</th>
				</tr>
			</thead>
			<tr>
				<td>
					<!-- 已经添加的项目 -->
					<div>
						<div v-for="(item, index) in addingThreshold.items" class="ui label basic small" style="margin-bottom: 0.5em;">
							<span v-if="item.item != 'nodeHealthCheck'">
								[{{item.duration}}{{itemDurationUnitName(item.durationUnit)}}]
							</span> 
							{{itemName(item.item)}}
							
							<span v-if="item.item == 'nodeHealthCheck'">
								<!-- 健康检查 -->
								<span v-if="item.value == 1">{{$t("node-ip-address-thresholds-box@成功")}}</span>
								<span v-if="item.value == 0">{{$t("node-ip-address-thresholds-box@失败")}}</span>
							</span>
							<span v-else>
								<!-- 连通性 -->
								<span v-if="item.item == 'connectivity' && item.options != null && item.options.groups != null && item.options.groups.length > 0">[<span v-for="(group, groupIndex) in item.options.groups">{{group.name}} <span v-if="groupIndex != item.options.groups.length - 1">&nbsp; </span></span>]</span>
								 <span class="grey">[{{itemOperatorName(item.operator)}}]</span> {{item.value}}{{itemUnitName(item.item)}}
							 </span> 
							 &nbsp;
							<a href="" :title="$t('node-ip-address-thresholds-box@删除')" @click.prevent="removeItem(index)"><i class="pi pi-times"></i></a>
						</div>
					</div>
					
					<!-- 正在添加的项目 -->
					<div v-if="isAddingItem" style="margin-top: 0.8em">
						<table class="ui table">
							<tr>
								<td style="width: 6em">{{$t("node-ip-address-thresholds-box@统计项目")}}</td>
								<td>
									<b-select
										v-model="itemCode"
										auto-width
										:options="[
											...allItems.map(item => ({
												label: item.name??'',
												value: item.code??'',
											}))
										]"
									></b-select>
									<p class="comment" style="font-weight: normal" v-for="item in allItems" v-if="item.code == itemCode">{{item.description}}</p>
								</td>
							</tr>
							<tr v-show="itemCode != 'nodeHealthCheck'">
								<td>{{$t("node-ip-address-thresholds-box@统计周期")}}</td>
								<td>
									<div class="ui input right labeled">
										<input type="text" v-model="itemDuration" style="width: 4em" maxlength="4" ref="itemDuration" @keyup.enter="confirmItem()" @keypress.enter.prevent="1"/>
										<span class="ui label">{{$t("node-ip-address-thresholds-box@分钟")}}</span>
									</div>
								</td>
							</tr>
							<tr v-show="itemCode != 'nodeHealthCheck'">
								<td>{{$t("node-ip-address-thresholds-box@操作符")}}</td>
								<td>
									<b-select
										v-model="itemOperator"
										auto-width
										:options="[
											{label: $t('node-ip-address-thresholds-box@选择系统用户Placeholder'), value: ''},
											...allOperators.map(operator => ({
												label: operator.name?? '',
												value: operator.code?? '',
											}))
										]"
									></b-select>
								</td>
							</tr>
							<tr v-show="itemCode != 'nodeHealthCheck'">
								<td>{{$t("node-ip-address-thresholds-box@对比值")}}</td>
								<td>
									<div class="ui input right labeled">
										<input type="text" maxlength="20" style="width: 5em" v-model="itemValue" ref="itemValue" @keyup.enter="confirmItem()" @keypress.enter.prevent="1"/>
										<span class="ui label" v-for="item in allItems" v-if="item.code == itemCode">{{item.unit}}</span>
									</div>
								</td>
							</tr>
							<tr v-show="itemCode == 'nodeHealthCheck'">
								<td>{{$t("node-ip-address-thresholds-box@检查结果")}}</td>
								<td>
									<b-select
										v-model="itemValue"
										auto-width
										:options="[
											{label: $t('node-ip-address-thresholds-box@成功'), value: '1'},
											{label: $t('node-ip-address-thresholds-box@失败'), value: '0'},
										]"
									></b-select>
									<p class="comment" style="font-weight: normal">{{$t("node-ip-address-thresholds-box@只有状态改变时触发")}}</p>
								</td>
							</tr>
							
							<!-- 连通性 -->
							<tr v-if="itemCode == 'connectivity'">
								<td>{{$t("node-ip-address-thresholds-box@终端分组")}}</td>
								<td style="font-weight: normal">
									<div style="zoom: 0.8"><report-node-groups-selector @change="changeReportGroups"></report-node-groups-selector></div>
								</td>
							</tr>
						</table>
						<div style="margin-top: 0.8em">
							<button class="ui button tiny" type="button" @click.prevent="confirmItem">{{$t("node-ip-address-thresholds-box@确定")}}</button>							 &nbsp;
							<a href="" :title="$t('node-ip-address-thresholds-box@取消')" @click.prevent="cancelItem"><i class="pi pi-times"></i></a>
						</div>
					</div>
					<div style="margin-top: 0.8em" v-if="!isAddingItem">
						<b-add-button @click="addItem"></b-add-button>
					</div>
				</td>
				<td>
					<!-- 已经添加的动作 -->
					<div>
						<div v-for="(action, index) in addingThreshold.actions" class="ui label basic small" style="margin-bottom: 0.5em">
							{{actionName(action.action)}} &nbsp;
							<span v-if="action.action == 'switch'">到{{action.options.ips.join(", ")}}</span>
							<span v-if="action.action == 'webHook'" class="small grey">({{action.options.url}})</span>
							<a href="" :title="$t('node-ip-address-thresholds-box@删除')" @click.prevent="removeAction(index)"><i class="pi pi-times"></i></a>
						</div>
					</div>
					
					<!-- 正在添加的动作 -->
					<div v-if="isAddingAction" style="margin-top: 0.8em">
						<table class="ui table">
							<tr>
								<td style="width: 6em">{{$t("node-ip-address-thresholds-box@动作类型")}}</td>
								<td>
									<b-select
										v-model="actionCode"
										auto-width
										:options="[
											...allActions.map(action => ({
												label: action.name??'',
												value: action.code??'',
											}))
										]"
									></b-select>
									<p class="comment" v-for="action in allActions" v-if="action.code == actionCode">{{action.description}}</p>
								</td>
							</tr>
							
							<!-- 切换 -->
							<tr v-if="actionCode == 'switch'">
								<td>{{$t("node-ip-address-thresholds-box@备用IPLabel")}} *</td>
								<td>
									<textarea rows="2" v-model="actionBackupIPs" ref="actionBackupIPs"></textarea>
									<p class="comment">{{$t("node-ip-address-thresholds-box@每行一个备用IP")}}</p>
								</td>
							</tr>
							
							<!-- WebHook -->
							<tr v-if="actionCode == 'webHook'">
								<td>{{$t("node-ip-address-thresholds-box@URLLabel")}} *</td>
								<td>
									<input type="text" maxlength="1000" placeholder="https://..." v-model="actionWebHookURL" ref="webHookURL" @keyup.enter="confirmAction()" @keypress.enter.prevent="1"/>
									<p class="comment">{{$t("node-ip-address-thresholds-box@完整的URL比如")}}<code-label>https://example.com/webhook/api</code-label>{{$t("node-ip-address-thresholds-box@系统将GET调用此URL")}}</p>
								</td>
							</tr>
						</table>
						<div style="margin-top: 0.8em">
							<button class="ui button tiny" type="button" @click.prevent="confirmAction">{{$t("node-ip-address-thresholds-box@确定")}}</button>	 &nbsp;
							<a href="" :title="$t('node-ip-address-thresholds-box@取消')" @click.prevent="cancelAction"><i class="pi pi-times"></i></a>
						</div>
					</div>
					
					<div style="margin-top: 0.8em" v-if="!isAddingAction">
						<b-add-button @click="addAction"></b-add-button>
					</div>	
				</td>
			</tr>
		</table>
		
		<!-- 添加阈值 -->
		<div>
			<button class="ui button tiny" :class="{disabled: (isAddingItem || isAddingAction)}" type="button" @click.prevent="confirm">{{$t("node-ip-address-thresholds-box@确定")}}</button> &nbsp;
			<a href="" :title="$t('node-ip-address-thresholds-box@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
		</div>
	</div>
	
	<div v-if="!isAdding" style="margin-top: 0.5em">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("node-ip-address-clusters-selector", {
	props: ["vClusters"],
	mounted: function () {
		this.checkClusters()
	},
	data: function () {
		let clusters = this.vClusters
		if (clusters == null) {
			clusters = []
		}
		return {
			clusters: clusters,
			hasCheckedCluster: false,
			clustersVisible: false
		}
	},
	methods: {
		checkClusters: function () {
			let that = this

			let b = false
			this.clusters.forEach(function (cluster) {
				if (cluster.isChecked) {
					b = true
				}
			})

			this.hasCheckedCluster = b

			return b
		},
		changeCluster: function (cluster) {
			cluster.isChecked = !cluster.isChecked
			this.checkClusters()
		},
		showClusters: function () {
			this.clustersVisible = !this.clustersVisible
		}
	},
	template: `<div>
  <span v-if="!hasCheckedCluster">{{$t('node_node-ip-address-cluters-selector@默认用于所有集群')}} &nbsp; <a href="" @click.prevent="showClusters">{{$t('node_node-ip-address-cluters-selector@修改Link')}} <i class="icon angle" :class="{down: !clustersVisible, up:clustersVisible}"></i></a></span>
	<div v-if="hasCheckedCluster">
		<span v-for="cluster in clusters" class="ui label basic small" v-if="cluster.isChecked">{{cluster.name}}</span> &nbsp; <a href="" @click.prevent="showClusters">{{$t('node_node-ip-address-cluters-selector@修改Link')}} <i class="icon angle" :class="{down: !clustersVisible, up:clustersVisible}"></i></a>
		<p class="comment">{{$t('node_node-ip-address-cluters-selector@当前IP仅在所选集群中有效')}}</p>
	</div>
	<div v-show="clustersVisible">
		<div class="ui divider"></div>
		<checkbox v-for="cluster in clusters" :v-value="cluster.id" :value="cluster.isChecked ? cluster.id : 0" style="margin-right: 1em" @input="changeCluster(cluster)" name="clusterIds">
			{{cluster.name}}
		</checkbox>
	</div>
</div>`
})

Vue.component("node-region-selector", {
	props: ["v-region"],
	data: function () {
		return {
			selectedRegion: this.vRegion
		}
	},
	methods: {
		selectRegion: function () {
			let that = this
			teaweb.popup("/clusters/regions/selectPopup?clusterId=" + this.vClusterId, {
				title: this.$t('node-region-selector@选择所属区域'),
				callback: function (resp) {
					that.selectedRegion = resp.data.region
				}
			})
		},
		addRegion: function () {
			let that = this
			teaweb.popup("/clusters/regions/createPopup?clusterId=" + this.vClusterId, {
				title: this.$t('node-region-selector@创建区域'),
				callback: function (resp) {
					that.selectedRegion = resp.data.region
				}
			})
		},
		removeRegion: function () {
			this.selectedRegion = null
		}
	},
	template: `<div>
	<div class="ui label small basic" v-if="selectedRegion != null">
		<input type="hidden" name="regionId" :value="selectedRegion.id"/>
		{{selectedRegion.name}} &nbsp;<a href="" :title="$t('node-region-selector@删除')" @click.prevent="removeRegion()"><i class="icon remove"></i></a>
	</div>
	<div v-if="selectedRegion == null">
		<a href="" @click.prevent="selectRegion()">{{ $t("node-region-selector@选择区域") }}</a> &nbsp; <a href="" @click.prevent="addRegion()">{{ $t("node-region-selector@添加区域") }}</a>
	</div>
</div>`
})

// 节点IP地址管理（标签形式）
Vue.component("node-ip-addresses-box", {
	props: ["v-ip-addresses", "role", "v-node-id"],
	data: function () {
		let nodeId = this.vNodeId
		if (nodeId == null) {
			nodeId = 0
		}

		return {
			ipAddresses: (this.vIpAddresses == null) ? [] : this.vIpAddresses,
			supportThresholds: this.role != "ns",
			nodeId: nodeId
		}
	},
	methods: {
		// 添加IP地址
		addIPAddress: function () {
			window.UPDATING_NODE_IP_ADDRESS = null

			let that = this;
			teaweb.popup("/nodes/ipAddresses/createPopup?nodeId=" + this.nodeId + "&supportThresholds=" + (this.supportThresholds ? 1 : 0), {
				title: that.$t('node-ip-addresses-box@添加IP地址'),
				callback: function (resp) {
					that.ipAddresses.push(resp.data.ipAddress);
				},
				height: "24em",
				width: "44em"
			})
		},

		// 修改地址
		updateIPAddress: function (index, address) {
			window.UPDATING_NODE_IP_ADDRESS = teaweb.clone(address)

			let that = this;
			teaweb.popup("/nodes/ipAddresses/updatePopup?nodeId=" + this.nodeId + "&supportThresholds=" + (this.supportThresholds ? 1 : 0), {
				title: that.$t('node-ip-addresses-box@修改IP地址'),
				callback: function (resp) {
					Vue.set(that.ipAddresses, index, resp.data.ipAddress);
				},
				height: "24em",
				width: "44em"
			})
		},

		// 删除IP地址
		removeIPAddress: function (index) {
			this.ipAddresses.$remove(index);
		},

		// 判断是否为IPv6
		isIPv6: function (ip) {
			return ip.indexOf(":") > -1
		}
	},
	template: `<div>
	<input type="hidden" name="ipAddressesJSON" :value="JSON.stringify(ipAddresses)"/>
	<div v-if="ipAddresses.length > 0">
		<div>
			<div v-for="(address, index) in ipAddresses" class="ui label tiny basic">
				<span v-if="isIPv6(address.ip)" class="grey">[IPv6]</span> {{address.ip}}
				<span class="small grey" v-if="address.name.length > 0">（{{$t("addPopup@备注")}}：{{address.name}}<span v-if="!address.canAccess">，{{$t("node-ip-addresses-box@不公开访问")}}</span>）</span>
				<span class="small grey" v-if="address.name.length == 0 && !address.canAccess">（不公开访问）</span>
				<span class="small red" v-if="!address.isOn" title="未启用">[off]</span>
				<span class="small red" v-if="!address.isUp" title="已下线">[down]</span>
				<span class="small" v-if="address.thresholds != null && address.thresholds.length > 0">[{{address.thresholds.length}}个阈值]</span>
				&nbsp;
				 <span v-if="address.clusters != null && address.clusters.length > 0">
					&nbsp; <span class="small grey">专属集群：[</span><span v-for="(cluster, index) in address.clusters" class="small grey">{{cluster.name}}<span v-if="index < address.clusters.length - 1">，</span></span><span class="small grey">]</span>
					&nbsp;
				</span>
				
				<a href="" title="修改" @click.prevent="updateIPAddress(index, address)"><i class="icon pencil small"></i></a>
				<a href="" title="删除" @click.prevent="removeIPAddress(index)"><i class="icon remove"></i></a>
			</div>
		</div>
		<div class="ui divider"></div>
	</div>
	<div>
		<b-add-button @click="addIPAddress()"></b-add-button>
	</div>
</div>`
})

Vue.component("node-combo-box", {
	props: ["v-cluster-id", "v-node-id"],
	data: function () {
		let that = this
		Tea.action("/clusters/nodeOptions")
			.params({
				clusterId: this.vClusterId
			})
			.post()
			.success(function (resp) {
				that.nodes = resp.data.nodes
			})
		return {
			nodes: []
		}
	},
	template: `<div v-if="nodes.length > 0">
	<combo-box :title="$t('node_node-combo-box@节点Title')" :placeholder="$t('node_node-combo-box@节点名称Placeholder')" :v-items="nodes" name="nodeId" :v-value="vNodeId"></combo-box>
</div>`
})

Vue.component("node-schedule-action-box", {
	props: ["value", "v-actions"],
	data: function () {
		let actionConfig = this.value
		if (actionConfig == null) {
			actionConfig = {
				code: "",
				params: {}
			}
		}

		return {
			actions: this.vActions,
			currentAction: null,
			actionConfig: actionConfig
		}
	},
	watch: {
		"actionConfig.code": function (actionCode) {
			if (actionCode.length == 0) {
				this.currentAction = null
			} else {
				this.currentAction = this.actions.$find(function (k, v) {
					return v.code == actionCode
				})
			}
			this.actionConfig.params = {}
		}
	},
	template: `<div>
	<input type="hidden" name="actionJSON" :value="JSON.stringify(actionConfig)"/>
	<div>
		<div>
			<b-select
				v-model="actionConfig.code"
				auto-width
				:options="[
					{label: '[选择动作]', value: ''},
					...actions.map(action => ({
						label: action.name??'',
						value: action.code??'',
					}))
				]"
			></b-select>
		</div>
		<p class="comment" v-if="currentAction != null">{{currentAction.description}}</p>
		
		<div v-if="actionConfig.code == 'webHook'">
			<input type="text" placeholder="https://..." v-model="actionConfig.params.url"/>
			<p class="comment">接收通知的URL。</p>
		</div>
	</div>
</div>`
})

// 节点级别选择器
Vue.component("node-level-selector", {
	props: ["v-node-level"],
	data: function () {
		let levelCode = this.vNodeLevel
		if (levelCode == null || levelCode < 1) {
			levelCode = 1
		}
		return {
			levels: [
				{
					name: this.$t("node-level-selector@边缘节点"),
					code: 1,
					description: this.$t("node-level-selector@普通的边缘节点")
				},
				{
					name: this.$t("node-level-selector@L2节点"),
					code: 2,
					description: this.$t("node-level-selector@特殊的边缘节点，同时负责同组上一级节点的回源")
				}
			],
			levelCode: levelCode
		}
	},
	watch: {
		levelCode: function (code) {
			this.$emit("change", code)
		}
	},
	template: `<div>
		<b-select
			name="level"
			v-model="levelCode"
			auto-width
			:options="[
				{label: $t('admins_admin-selector@选择系统用户'), value: 0},
				...levels.map(level => ({
					label: level.name??'',
					value: level.code??'',
				}))
			]"
		></b-select>
		<p class="comment" v-if="typeof(levels[levelCode - 1]) != null">
			<plus-label></plus-label>{{levels[levelCode - 1].description}}
		</p>
	</div>`
})

Vue.component("node-schedule-conds-box", {
	props: ["value", "v-params", "v-operators"],
	mounted: function () {
		this.formatConds(this.condsConfig.conds)
		this.$forceUpdate()
	},
	data: function () {
		let condsConfig = this.value
		if (condsConfig == null) {
			condsConfig = {
				conds: [],
				connector: "and"
			}
		}
		if (condsConfig.conds == null) {
			condsConfig.conds = []
		}

		let paramMap = {}
		this.vParams.forEach(function (param) {
			paramMap[param.code] = param
		})

		let operatorMap = {}
		this.vOperators.forEach(function (operator) {
			operatorMap[operator.code] = operator.name
		})

		return {
			condsConfig: condsConfig,
			params: this.vParams,
			paramMap: paramMap,
			operatorMap: operatorMap,
			operator: "",

			isAdding: false,

			paramCode: "",
			param: null,

			valueBandwidth: {
				count: 100,
				unit: "mb"
			},
			valueTraffic: {
				count: 1,
				unit: "gb"
			},
			valueCPU: 80,
			valueMemory: 90,
			valueLoad: 20,
			valueRate: 0
		}
	},
	watch: {
		paramCode: function (code) {
			if (code.length == 0) {
				this.param = null
			} else {
				this.param = this.params.$find(function (k, v) {
					return v.code == code
				})
			}
			this.$emit("changeparam", this.param)
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
		},
		confirm: function () {
			if (this.param == null) {
				teaweb.warn(this.$t("node-schedule-conds-box-plus@请选择参数"))
				return
			}
			if (this.param.operators != null && this.param.operators.length > 0 && this.operator.length == 0) {
				teaweb.warn(this.$t("node-schedule-conds-box-plus@请选择操作符"))
				return
			}
			if (this.param.operators == null || this.param.operators.length == 0) {
				this.operator = ""
			}

			let value = null
			switch (this.param.valueType) {
				case "bandwidth": {
					if (this.valueBandwidth.unit.length == 0) {
						teaweb.warn(this.$t("node-schedule-conds-box-plus@请选择带宽单位"))
						return
					}
					let count = parseInt(this.valueBandwidth.count.toString())
					if (isNaN(count)) {
						count = 0
					}
					if (count < 0) {
						count = 0
					}
					value = {
						count: count,
						unit: this.valueBandwidth.unit
					}
				}
					break
				case "traffic": {
					if (this.valueTraffic.unit.length == 0) {
						teaweb.warn(this.$t("node-schedule-conds-box-plus@请选择带宽单位"))
						return
					}
					let count = parseInt(this.valueTraffic.count.toString())
					if (isNaN(count)) {
						count = 0
					}
					if (count < 0) {
						count = 0
					}
					value = {
						count: count,
						unit: this.valueTraffic.unit
					}
				}
					break
				case "cpu":
					let cpu = parseInt(this.valueCPU.toString())
					if (isNaN(cpu)) {
						cpu = 0
					}
					if (cpu < 0) {
						cpu = 0
					}
					if (cpu > 100) {
						cpu = 100
					}
					value = cpu
					break
				case "memory":
					let memory = parseInt(this.valueMemory.toString())
					if (isNaN(memory)) {
						memory = 0
					}
					if (memory < 0) {
						memory = 0
					}
					if (memory > 100) {
						memory = 100
					}
					value = memory
					break
				case "load":
					let load = parseInt(this.valueLoad.toString())
					if (isNaN(load)) {
						load = 0
					}
					if (load < 0) {
						load = 0
					}
					value = load
					break
				case "rate":
					let rate = parseInt(this.valueRate.toString())
					if (isNaN(rate)) {
						rate = 0
					}
					if (rate < 0) {
						rate = 0
					}
					value = rate
					break
			}

			this.condsConfig.conds.push({
				param: this.param.code,
				operator: this.operator,
				value: value
			})
			this.formatConds(this.condsConfig.conds)

			this.cancel()
		},
		cancel: function () {
			this.isAdding = false
			this.paramCode = ""
			this.param = null
		},
		remove: function (index) {
			this.condsConfig.conds.$remove(index)
		},
		formatConds: function (conds) {
			let that = this
			conds.forEach(function (cond) {
				switch (that.paramMap[cond.param].valueType) {
					case "bandwidth":
						cond.valueFormat = cond.value.count + cond.value.unit[0].toUpperCase() + cond.value.unit.substring(1) + "ps"
						return
					case "traffic":
						cond.valueFormat = cond.value.count + cond.value.unit.toUpperCase()
						return
					case "cpu":
						cond.valueFormat = cond.value + "%"
						return
					case "memory":
						cond.valueFormat = cond.value + "%"
						return
					case "load":
						cond.valueFormat = cond.value
						return
					case "rate":
						cond.valueFormat = cond.value + "/秒"
						return
				}
			})
		}
	},
	template: `<div>
	<input type="hidden" name="condsJSON" :value="JSON.stringify(this.condsConfig)"/>
	
	<!-- 已有条件 -->
	<div v-if="condsConfig.conds.length > 0" style="margin-bottom: 1em">
		<span v-for="(cond, index) in condsConfig.conds">
			<span class="ui label basic small">
				<span>{{paramMap[cond.param].name}} 
					<span v-if="paramMap[cond.param].operators != null && paramMap[cond.param].operators.length > 0"><span class="grey">{{operatorMap[cond.operator]}}</span> {{cond.valueFormat}}</span> 
					&nbsp; <a href="" title="删除" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
				</span>
			</span>
			<span v-if="index < condsConfig.conds.length - 1"> &nbsp;<span v-if="condsConfig.connector == 'and'">且</span><span v-else>或</span>&nbsp; </span>
		</span>
	</div>
	
	<div v-if="isAdding">
		<table class="ui table">
			<tbody>
				<tr>
					<td class="title">参数</td>
					<td>
						<b-select
							v-model="paramCode"
							auto-width
							:options="[
								{label: $t('node-schedule-conds-box-plus@选择参数'), value: ''},
								...params.map(paramOption => ({
									label: paramOption.name??'',
									value: paramOption.code??'',
								}))
							]"
						></b-select>
						<p class="comment" v-if="param != null">{{param.description}}</p>
					</td>
				</tr>
				<tr v-if="param != null && param.operators != null && param.operators.length > 0">
					<td>操作符</td>
					<td>
						<b-select
							v-if="param != null"
							v-model="operator"
							auto-width
							:options="[
								{label: $t('node-schedule-conds-box-plus@选择操作符'), value: ''},
								...param.operators.map(operator => ({
									label: operatorMap[operator],
									value: operator??'',
								}))
							]"
						></b-select>
					</td>
				</tr>
				<tr v-if="param != null && param.operators != null && param.operators.length > 0">
					<td>{{param.valueName}}</td>
					<td>
						<!-- 带宽 -->
						<div v-if="param.valueType == 'bandwidth'">
							<div class="ui fields inline">
								<div class="ui field">
									<input type="text" maxlength="10" size="6" v-model="valueBandwidth.count" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
								</div>
								<div class="ui field">
									<b-select
										v-model="valueBandwidth.unit"
										auto-width
										:options="[
											{label: 'Gbps', value: 'gb'},
											{label: 'Mbps', value: 'mb'},
										]"
									></b-select>
								</div>
							</div>
						</div>
						
						<!-- 流量 -->
						<div v-if="param.valueType == 'traffic'">
							<div class="ui fields inline">
								<div class="ui field">
									<input type="text" maxlength="10" size="6" v-model="valueTraffic.count" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
								</div>
								<div class="ui field">
									<b-select
										v-model="valueTraffic.unit"
										auto-width
										:options="[
											{label: 'MiB', value: 'mb'},
											{label: 'GiB', value: 'gb'},
											{label: 'TiB', value: 'tb'},
											{label: 'PiB', value: 'pb'},
											{label: 'EiB', value: 'eb'},
										]"
									></b-select>
								</div>
							</div>
						</div>
						
						<!-- cpu -->
						<div v-if="param.valueType == 'cpu'">
							<div class="ui input right labeled">
								<input type="text" v-model="valueCPU" maxlength="3" size="3" style="width: 4em" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
								<span class="ui label">%</span>
							</div>
						</div>
						
						<!-- memory -->
						<div v-if="param.valueType == 'memory'">
							<div class="ui input right labeled">
								<input type="text" v-model="valueMemory" maxlength="3" size="3" style="width: 4em" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
								<span class="ui label">%</span>
							</div>
						</div>
						
						<!-- load -->
						<div v-if="param.valueType == 'load'">
							<input type="text" v-model="valueLoad" maxlength="3" size="3" style="width: 4em" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
						</div>
						
						<!-- rate -->
						<div v-if="param.valueType == 'rate'">
							<div class="ui input right labeled">
								<input type="text" v-model="valueRate" maxlength="8" size="8" style="width: 8em" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
								<span class="ui label">/秒</span>
							</div>
						</div>
					</td>
				</tr>
			</tbody>
		</table>
		<button class="ui button small" type="button" @click.prevent="confirm">确定</button> &nbsp; <a href="" @click.prevent="cancel">取消</a>
	</div>
	
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

// 节点登录推荐端口
Vue.component("node-login-suggest-ports", {
	data: function () {
		return {
			ports: [],
			availablePorts: [],
			autoSelected: false,
			isLoading: false
		}
	},
	methods: {
		reload: function (host) {
			let that = this
			this.autoSelected = false
			this.isLoading = true
			Tea.action("/clusters/cluster/suggestLoginPorts")
				.params({
					host: host
				})
				.success(function (resp) {
					if (resp.data.availablePorts != null) {
						that.availablePorts = resp.data.availablePorts
						if (that.availablePorts.length > 0) {
							that.autoSelectPort(that.availablePorts[0])
							that.autoSelected = true
						}
					}
					if (resp.data.ports != null) {
						that.ports = resp.data.ports
						if (that.ports.length > 0 && !that.autoSelected) {
							that.autoSelectPort(that.ports[0])
							that.autoSelected = true
						}
					}
				})
				.done(function () {
					that.isLoading = false
				})
				.post()
		},
		selectPort: function (port) {
			this.$emit("select", port)
		},
		autoSelectPort: function (port) {
			this.$emit("auto-select", port)
		}
	},
	template: `<span>
	<span v-if="isLoading">{{ $t("node-login-suggest-ports@正在检查端口") }}</span>
	<span v-if="availablePorts.length > 0">
		{{ $t("node-login-suggest-ports@可能端口") }}<a href="" v-for="port in availablePorts" @click.prevent="selectPort(port)" class="ui label tiny basic" style="border: 1px #2185d0 dashed; font-weight: normal">{{port}}</a>
		&nbsp; &nbsp;
	</span>
	<span v-if="ports.length > 0">
		{{ $t("node-login-suggest-ports@常用端口") }}<a href="" v-for="port in ports" @click.prevent="selectPort(port)" class="ui label tiny basic" style="border: 1px #2185d0 dashed;  font-weight: normal">{{port}}</a>
	</span>
	<span v-if="ports.length == 0">{{ $t("node-login-suggest-ports@常用端口有22等") }}</span>
	<span v-if="ports.length > 0" class="grey small">{{ $t("node-login-suggest-ports@可以点击要使用的端口") }}</span>
</span>`
})

Vue.component("node-schedule-conds-viewer", {
	props: ["value", "v-params", "v-operators"],
	mounted: function () {
		this.formatConds(this.condsConfig.conds)
		this.$forceUpdate()
	},
	data: function () {
		let paramMap = {}
		this.vParams.forEach(function (param) {
			paramMap[param.code] = param
		})

		let operatorMap = {}
		this.vOperators.forEach(function (operator) {
			operatorMap[operator.code] = operator.name
		})

		return {
			condsConfig: this.value,
			paramMap: paramMap,
			operatorMap: operatorMap
		}
	},
	methods: {
		formatConds: function (conds) {
			let that = this
			conds.forEach(function (cond) {
				switch (that.paramMap[cond.param].valueType) {
					case "bandwidth":
						cond.valueFormat = cond.value.count + cond.value.unit[0].toUpperCase() + cond.value.unit.substring(1) + "ps"
						return
					case "traffic":
						cond.valueFormat = cond.value.count + cond.value.unit.toUpperCase()
						return
					case "cpu":
						cond.valueFormat = cond.value + "%"
						return
					case "memory":
						cond.valueFormat = cond.value + "%"
						return
					case "load":
						cond.valueFormat = cond.value
						return
					case "rate":
						cond.valueFormat = cond.value + "/秒"
						return
				}
			})
		}
	},
	template: `<div>
	<span v-for="(cond, index) in condsConfig.conds">
		<span class="ui label basic small">
			<span>{{paramMap[cond.param].name}} 
				<span v-if="paramMap[cond.param].operators != null && paramMap[cond.param].operators.length > 0"><span class="grey">{{operatorMap[cond.operator]}}</span> {{cond.valueFormat}}</span> 
			</span>
		</span>
		<span v-if="index < condsConfig.conds.length - 1"> &nbsp;<span v-if="condsConfig.connector == 'and'">且</span><span v-else>或</span>&nbsp; </span>
	</span>
</div>`
})

// 节点IP阈值
Vue.component("node-ip-address-thresholds-view", {
	props: ["v-thresholds"],
	data: function () {
		let thresholds = this.vThresholds
		if (thresholds == null) {
			thresholds = []
		} else {
			thresholds.forEach(function (v) {
				if (v.items == null) {
					v.items = []
				}
				if (v.actions == null) {
					v.actions = []
				}
			})
		}

		return {
			thresholds: thresholds,
			allItems: window.IP_ADDR_THRESHOLD_ITEMS,
			allOperators: [
				{
					"name": this.$t('node-ip-address-thresholds-box@小于等于'),
					"code": "lte"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@大于'),
					"code": "gt"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@不等于'),
					"code": "neq"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@小于'),
					"code": "lt"
				},
				{
					"name": this.$t('node-ip-address-thresholds-box@大于等于'),
					"code": "gte"
				}
			],
			allActions: window.IP_ADDR_THRESHOLD_ACTIONS
		}
	},
	methods: {
		itemName: function (item) {
			let result = ""
			this.allItems.forEach(function (v) {
				if (v.code == item) {
					result = v.name
				}
			})
			return result
		},
		itemUnitName: function (itemCode) {
			let result = ""
			this.allItems.forEach(function (v) {
				if (v.code == itemCode) {
					result = v.unit
				}
			})
			return result
		},
		itemDurationUnitName: function (unit) {
			switch (unit) {
				case "minute":
					return this.$t("node-ip-address-thresholds-box@分钟")
				case "second":
					return this.$t("node-ip-address-thresholds-box@秒")
				case "hour":
					return this.$t("node-ip-address-thresholds-box@小时")
				case "day":
					return this.$t("node-ip-address-thresholds-box@天")
			}
			return unit
		},
		itemOperatorName: function (operator) {
			let result = ""
			this.allOperators.forEach(function (v) {
				if (v.code == operator) {
					result = v.name
				}
			})
			return result
		},
		actionName: function (actionCode) {
			let result = ""
			this.allActions.forEach(function (v) {
				if (v.code == actionCode) {
					result = v.name
				}
			})
			return result
		}
	},
	template: `<div>
	<!-- 已有条件 -->
	<div v-if="thresholds.length > 0">
		<div class="ui label basic small" v-for="(threshold, index) in thresholds" style="margin-bottom: 0.8em">
			<span v-for="(item, itemIndex) in threshold.items">
				<span>
					<span v-if="item.item != 'nodeHealthCheck'">
						[{{item.duration}}{{itemDurationUnitName(item.durationUnit)}}]
					</span>	 
					{{itemName(item.item)}}
					
					<span v-if="item.item == 'nodeHealthCheck'">
						<!-- 健康检查 -->
						<span v-if="item.value == 1">{{$t("node-ip-address-thresholds-box@成功")}}</span>
						<span v-if="item.value == 0">{{$t("node-ip-address-thresholds-box@失败")}}</span>
					</span>
					<span v-else>
						<!-- 连通性 -->
						<span v-if="item.item == 'connectivity' && item.options != null && item.options.groups != null && item.options.groups.length > 0">[<span v-for="(group, groupIndex) in item.options.groups">{{group.name}} <span v-if="groupIndex != item.options.groups.length - 1">&nbsp; </span></span>]</span>
						
						 <span class="grey">[{{itemOperatorName(item.operator)}}]</span> {{item.value}}{{itemUnitName(item.item)}} &nbsp;
					 </span>
				 </span>
				 <span v-if="itemIndex != threshold.items.length - 1" style="font-style: italic">AND &nbsp;</span></span>
				-&gt;
				<span v-for="(action, actionIndex) in threshold.actions">{{actionName(action.action)}}
				<span v-if="action.action == 'switch'">到{{action.options.ips.join(", ")}}</span>
				<span v-if="action.action == 'webHook'" class="small grey">({{action.options.url}})</span>
				 &nbsp;					 
				 <span v-if="actionIndex != threshold.actions.length - 1" style="font-style: italic">AND &nbsp;</span>
			 </span>
		</div>
	</div>
</div>`
})

Vue.component("node-cache-disk-dirs-box", {
	props: ["value", "name"],
	data: function () {
		let dirs = this.value
		if (dirs == null) {
			dirs = []
		}
		return {
			dirs: dirs,

			isEditing: false,
			isAdding: false,

			addingPath: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingPath.focus()
			}, 100)
		},
		confirm: function () {
			let addingPath = this.addingPath.trim()
			if (addingPath.length == 0) {
				let that = this
				teaweb.warn(this.$t('node_node-cache-disk-dirs-box@请输入缓存目录'), function () {
					that.$refs.addingPath.focus()
				})
				return
			}
			if (addingPath[0] != "/") {
				addingPath = "/" + addingPath
			}
			this.dirs.push({
				path: addingPath
			})
			this.cancel()
		},
		cancel: function () {
			this.addingPath = ""
			this.isAdding = false
			this.isEditing = false
		},
		remove: function (index) {
			let that = this
			teaweb.confirm(this.$t('node_node-cache-disk-dirs-box@确定要删除此目录吗'), function () {
				that.dirs.$remove(index)
			})
		}
	},
	template: `<div>
	<input type="hidden" :name="name" :value="JSON.stringify(dirs)"/>
	<div style="margin-bottom: 0.3em">
		<span class="ui label small basic" v-for="(dir, index) in dirs">
			<i class="icon folder"></i>{{dir.path}}  &nbsp;  <a href="" :title="$t('node_node-cache-disk-dirs-box@删除Title')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</span>
	</div>
	
	<!-- 添加 -->
	<div v-if="isAdding">
		<div class="ui fields inline">
			<div class="ui field">
				<input type="text" style="width: 30em" v-model="addingPath" @keyup.enter="confirm()" @keypress.enter.prevent="1" @keydown.esc="cancel()" ref="addingPath" :placeholder="$t('node_node-cache-disk-dirs-box@新的缓存目录Placeholder')"/>
			</div>
			<div class="ui field">
				<button class="ui button small" type="button" @click.prevent="confirm">{{$t('node_node-cache-disk-dirs-box@确定Button')}}</button>
				&nbsp; <a href="" :title="$t('node_node-cache-disk-dirs-box@取消Title')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
	</div>
	
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("node-group-selector", {
	props: ["v-cluster-id", "v-group"],
	data: function () {
		return {
			selectedGroup: this.vGroup
		}
	},
	methods: {
		selectGroup: function () {
			let that = this
			teaweb.popup("/clusters/cluster/groups/selectPopup?clusterId=" + this.vClusterId, {
				title: this.$t('node_node-group-selector@选择所属分组'),
				callback: function (resp) {
					that.selectedGroup = resp.data.group
				}
			})
		},
		addGroup: function () {
			let that = this
			teaweb.popup("/clusters/cluster/groups/createPopup?clusterId=" + this.vClusterId, {
				title: this.$t('node_node-group-selector@创建分组'),
				callback: function (resp) {
					that.selectedGroup = resp.data.group
				}
			})
		},
		removeGroup: function () {
			this.selectedGroup = null
		}
	},
	template: `<div>
	<div class="ui label small basic" v-if="selectedGroup != null">
		<input type="hidden" name="groupId" :value="selectedGroup.id"/>
		{{selectedGroup.name}} &nbsp;<a href="" :title="$t('node_node-group-selector@删除Title')" @click.prevent="removeGroup()"><i class="icon remove"></i></a>
	</div>
	<div v-if="selectedGroup == null">
		<a href="" @click.prevent="selectGroup()">{{$t('node_node-group-selector@选择分组Link')}}</a> &nbsp; <a href="" @click.prevent="addGroup()">{{$t('node_node-group-selector@添加分组Link')}}</a>
	</div>
</div>`
})

// 一个节点的多个集群选择器
Vue.component("node-clusters-selector", {
	props: ["v-primary-cluster", "v-secondary-clusters"],
	data: function () {
		let primaryCluster = this.vPrimaryCluster

		let secondaryClusters = this.vSecondaryClusters
		if (secondaryClusters == null) {
			secondaryClusters = []
		}

		return {
			primaryClusterId: (primaryCluster == null) ? 0 : primaryCluster.id,
			secondaryClusterIds: secondaryClusters.map(function (v) {
				return v.id
			}),

			primaryCluster: primaryCluster,
			secondaryClusters: secondaryClusters
		}
	},
	methods: {
		addPrimary: function () {
			let that = this
			let selectedClusterIds = [this.primaryClusterId].concat(this.secondaryClusterIds)
			teaweb.popup("/clusters/selectPopup?selectedClusterIds=" + selectedClusterIds.join(",") + "&mode=single", {
				title: this.$t('cluster_node-clusters-selector@选择集群'),
				height: "30em",
				width: "50em",
				callback: function (resp) {
					if (resp.data.cluster != null) {
						that.primaryCluster = resp.data.cluster
						that.primaryClusterId = that.primaryCluster.id
						that.notifyChange()
					}
				}
			})
		},
		removePrimary: function () {
			this.primaryClusterId = 0
			this.primaryCluster = null
			this.notifyChange()
		},
		addSecondary: function () {
			let that = this
			let selectedClusterIds = [this.primaryClusterId].concat(this.secondaryClusterIds)
			teaweb.popup("/clusters/selectPopup?selectedClusterIds=" + selectedClusterIds.join(",") + "&mode=multiple", {
				title: this.$t('cluster_node-clusters-selector@选择集群'),
				height: "30em",
				width: "50em",
				callback: function (resp) {
					if (resp.data.cluster != null) {
						that.secondaryClusterIds.push(resp.data.cluster.id)
						that.secondaryClusters.push(resp.data.cluster)
						that.notifyChange()
					}
				}
			})
		},
		removeSecondary: function (index) {
			this.secondaryClusterIds.$remove(index)
			this.secondaryClusters.$remove(index)
			this.notifyChange()
		},
		notifyChange: function () {
			this.$emit("change", {
				clusterId: this.primaryClusterId
			})
		}
	},
	template: `<div>
	<input type="hidden" name="primaryClusterId" :value="primaryClusterId"/>
	<input type="hidden" name="secondaryClusterIds" :value="JSON.stringify(secondaryClusterIds)"/>
	<table class="ui table">
		<tr>
			<td class="title">{{$t('cluster_node-clusters-selector@主集群')}}</td>
			<td>
				<div v-if="primaryCluster != null">
					<div class="ui label basic small">{{primaryCluster.name}} &nbsp; <a href="" :title="$t('cluster_node-clusters-selector@删除')" @click.prevent="removePrimary"><i class="pi pi-times"></i></a> </div>
				</div>
				<div style="margin-top: 0.6em" v-if="primaryClusterId == 0">
					<b-add-button @click="addPrimary"></b-add-button>
				</div>
				<p class="comment">{{$t('cluster_node-clusters-selector@多集群冲突优先主集群')}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t('cluster_node-clusters-selector@从集群')}}</td>
			<td>
				<div v-if="secondaryClusters.length > 0">
					<div class="ui label basic small" v-for="(cluster, index) in secondaryClusters"><span class="grey">{{cluster.name}}</span> &nbsp; <a href="" :title="$t('cluster_node-clusters-selector@删除')" @click.prevent="removeSecondary(index)"><i class="pi pi-times"></i></a> </div>
				</div>
				<div style="margin-top: 0.6em">
					<b-add-button @click="addSecondary"></b-add-button>
				</div>
			</td>
		</tr>
	</table>
</div>`
})

Vue.component("node-ddos-protection-config-box", {
	props: ["v-ddos-protection-config", "v-default-configs", "v-is-node", "v-cluster-is-on"],
	data: function () {
		let config = this.vDdosProtectionConfig
		if (config == null) {
			config = {
				tcp: {
					isPrior: false,
					isOn: false,
					maxConnections: 0,
					maxConnectionsPerIP: 0,
					newConnectionsRate: 0,
					newConnectionsRateBlockTimeout: 0,
					newConnectionsSecondlyRate: 0,
					newConnectionSecondlyRateBlockTimeout: 0,
					allowIPList: [],
					ports: []
				}
			}
		}

		// initialize
		if (config.tcp == null) {
			config.tcp = {
				isPrior: false,
				isOn: false,
				maxConnections: 0,
				maxConnectionsPerIP: 0,
				newConnectionsRate: 0,
				newConnectionsRateBlockTimeout: 0,
				newConnectionsSecondlyRate: 0,
				newConnectionSecondlyRateBlockTimeout: 0,
				allowIPList: [],
				ports: []
			}
		}


		return {
			config: config,
			defaultConfigs: this.vDefaultConfigs,
			isNode: this.vIsNode,

			isAddingPort: false
		}
	},
	methods: {
		changeTCPPorts: function (ports) {
			this.config.tcp.ports = ports
		},
		changeTCPAllowIPList: function (ipList) {
			this.config.tcp.allowIPList = ipList
		}
	},
	template: `<div>
 <input type="hidden" name="ddosProtectionJSON" :value="JSON.stringify(config)"/>

 <b-notice>
	{{$t('cluster_node-ddos-protection-config-box@功能说明')}}<strong>{{$t('cluster_node-ddos-protection-config-box@试验性质')}}</strong>{{$t('cluster_node-ddos-protection-config-box@目前仅能防御DDoS')}}<code-label>nftablesV0.9</code-label>{{$t('cluster_node-ddos-protection-config-box@以上Linux系统')}}<pro-warning-label></pro-warning-label>
 </b-notice>

 <div class="ui message" v-if="vClusterIsOn">{{$t('cluster_node-ddos-protection-config-box@当前节点集群已设DDoS防护')}}</div>

 <div class="config-section">
 	<div class="config-item">
 		<prior-checkbox :v-config="config.tcp" v-if="isNode"></prior-checkbox>
 	</div>
 	
 	<div v-show="config.tcp.isPrior || !isNode">
 		<div class="config-item">
 			<div class="item-content">
 				<checkbox v-model="config.tcp.isOn">{{$t('cluster_node-ddos-protection-config-box@启用DDoS防护')}}</checkbox>
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@启用后TCP连接将防护')}}</p>
 			</div>
 		</div>
 	</div>
 	
 	<div v-show="config.tcp.isOn && (config.tcp.isPrior || !isNode)">
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@单节点TCP最大连接数')}}</div>
 			<div class="item-content">
 				<digit-input name="tcpMaxConnections" v-model="config.tcp.maxConnections" maxlength="6" size="6" style="width: 6em" class="ui input"></digit-input>
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@单节点可接受TCP最大连接数Note', [defaultConfigs.tcpMaxConnections])}}</p>
 			</div>
 		</div>
 		
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@单IPTCP最大连接数')}}</div>
 			<div class="item-content">
 				<digit-input name="tcpMaxConnectionsPerIP" v-model="config.tcp.maxConnectionsPerIP" maxlength="6" size="6" style="width: 6em" class="ui input"></digit-input>
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@单IP可连接TCP最大连接数Note', [defaultConfigs.tcpMaxConnectionsPerIP, defaultConfigs.tcpMinConnectionsPerIP])}}</p>
 			</div>
 		</div>
 		
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@单IPTCP新连接速率')}}<em>（{{$t('cluster_node-ddos-protection-config-box@分钟')}}）</em></div>
 			<div class="item-content">
 				<div class="ui fields inline">
 					<div class="ui field">
 						<div class="ui input right labeled">
 							<digit-input name="tcpNewConnectionsRate" v-model="config.tcp.newConnectionsRate" maxlength="6" size="6" style="width: 6em" :min="defaultConfigs.tcpNewConnectionsMinRate" class="ui input"></digit-input>
 							<span class="ui label">{{$t('cluster_node-ddos-protection-config-box@个新连接每分钟')}}</span>
 						</div>
 					</div>
 					<div class="ui field" style="line-height: 2.4em">
 						{{$t('cluster_node-ddos-protection-config-box@屏蔽')}}
 					</div>
 					<div class="ui field">
 						<div class="ui input right labeled">
 							<digit-input name="tcpNewConnectionsRateBlockTimeout" v-model="config.tcp.newConnectionsRateBlockTimeout" maxlength="6" size="6" style="width: 5em" class="ui input"></digit-input>
 							<span class="ui label">{{$t('cluster_node-ddos-protection-config-box@秒')}}</span>
 						</div>
 					</div>
 				</div>
 				
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@单IP每分钟可创建TCPNote', [defaultConfigs.tcpNewConnectionsMinutelyRate, defaultConfigs.tcpNewConnectionsMinMinutelyRate])}}</p>
 			</div>
 		</div>
 		
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@单IPTCP新连接速率')}}<em>（{{$t('cluster_node-ddos-protection-config-box@秒钟')}}）</em></div>
 			<div class="item-content">
 				<div class="ui fields inline">
 					<div class="ui field">
 						<div class="ui input right labeled">
 							<digit-input name="tcpNewConnectionsSecondlyRate" v-model="config.tcp.newConnectionsSecondlyRate" maxlength="6" size="6" style="width: 6em" :min="defaultConfigs.tcpNewConnectionsMinRate" class="ui input"></digit-input>
 							<span class="ui label">{{$t('cluster_node-ddos-protection-config-box@个新连接每秒钟')}}</span>
 						</div>
 					</div>
 					<div class="ui field" style="line-height: 2.4em">
 						{{$t('cluster_node-ddos-protection-config-box@屏蔽')}}
 					</div>
 					<div class="ui field">
 						<div class="ui input right labeled">
 							<digit-input name="tcpNewConnectionsSecondlyRateBlockTimeout" v-model="config.tcp.newConnectionsSecondlyRateBlockTimeout" maxlength="6" size="6" style="width: 5em" class="ui input"></digit-input>
 							<span class="ui label">{{$t('cluster_node-ddos-protection-config-box@秒')}}</span>
 						</div>
 					</div>
 				</div>
 				
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@单IP每秒钟可创建TCPNote', [defaultConfigs.tcpNewConnectionsSecondlyRate, defaultConfigs.tcpNewConnectionsMinSecondlyRate])}}</p>
 			</div>
 		</div>
 		
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@TCP端口列表')}}</div>
 			<div class="item-content">
 				<ddos-protection-ports-config-box :v-ports="config.tcp.ports" @change="changeTCPPorts"></ddos-protection-ports-config-box>
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@TCP端口列表Note')}}</p>
 			</div>
 		</div>
 		
 		<div class="config-item">
 			<div class="item-label">{{$t('cluster_node-ddos-protection-config-box@IP白名单')}}</div>
 			<div class="item-content">
 				<ddos-protection-ip-list-config-box :v-ip-list="config.tcp.allowIPList" @change="changeTCPAllowIPList"></ddos-protection-ip-list-config-box>
 				<p class="comment">{{$t('cluster_node-ddos-protection-config-box@IP白名单Note')}}</p>
 			</div>
 		</div>
 	</div>
 </div>
</div>`
})

Vue.component("ddos-protection-ip-list-config-box", {
	props: ["v-ip-list"],
	data: function () {
		let list = this.vIpList
		if (list == null) {
			list = []
		}
		return {
			list: list,
			isAdding: false,
			addingIP: {
				ip: "",
				description: ""
			}
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingIPInput.focus()
			})
		},
		confirm: function () {
			let ip = this.addingIP.ip
			if (ip.length == 0) {
				this.warn(this.$t('cluster_ddos-protection-ip-list-config-box@请输入IP'))
				return
			}

			let exists = false
			this.list.forEach(function (v) {
				if (v.ip == ip) {
					exists = true
				}
			})
			if (exists) {
				this.warn(this.$t('cluster_ddos-protection-ip-list-config-box@IP已存在', [ip]))
				return
			}

			let that = this
			Tea.Vue.$post("/ui/validateIPs")
				.params({
					ips: [ip]
				})
				.success(function () {
					that.list.push({
						ip: ip,
						description: that.addingIP.description
					})
					that.notifyChange()
					that.cancel()
				})
				.fail(function () {
					that.warn(that.$t('cluster_ddos-protection-ip-list-config-box@请输入正确IP'))
				})
		},
		cancel: function () {
			this.isAdding = false
			this.addingIP = {
				ip: "",
				description: ""
			}
		},
		remove: function (index) {
			this.list.$remove(index)
			this.notifyChange()
		},
		warn: function (message) {
			let that = this
			teaweb.warn(message, function () {
				that.$refs.addingIPInput.focus()
			})
		},
		notifyChange: function () {
			this.$emit("change", this.list)
		}
	},
	template: `<div>
	<div v-if="list.length > 0">
		<div class="ui label basic tiny" v-for="(ipConfig, index) in list">
			{{ipConfig.ip}} <span class="grey small" v-if="ipConfig.description.length > 0">（{{ipConfig.description}}）</span> <a href="" @click.prevent="remove(index)" :title="$t('cluster_ddos-protection-ip-list-config-box@删除')"><i class="icon remove"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div v-if="isAdding">
		<div class="ui fields inline">
			<div class="ui field">
				<div class="ui input left labeled">
					<span class="ui label">{{$t('cluster_ddos-protection-ip-list-config-box@IP')}}</span>
					<input type="text" v-model="addingIP.ip" ref="addingIPInput" maxlength="40" size="20" :placeholder="$t('cluster_ddos-protection-ip-list-config-box@IP输入')" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
				</div>
			</div>
			<div class="ui field">
				<div class="ui input left labeled">
					<span class="ui label">{{$t('cluster_ddos-protection-ip-list-config-box@备注')}}</span>
					<input type="text" v-model="addingIP.description" maxlength="10" size="10" :placeholder="$t('cluster_ddos-protection-ip-list-config-box@备注可选')" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
				</div>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{$t('cluster_ddos-protection-ip-list-config-box@确定')}}</button>
				&nbsp;<a href="" @click.prevent="cancel()">{{$t('cluster_ddos-protection-ip-list-config-box@取消')}}</a>
			</div>
		</div>
	</div>
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

// 单个集群选择
Vue.component("cluster-selector", {
	props: ["v-cluster-id"],
	mounted: function () {
		let that = this

		Tea.action("/clusters/options")
			.post()
			.success(function (resp) {
				that.clusters = resp.data.clusters
			})
	},
	data: function () {
		let clusterId = this.vClusterId
		if (clusterId == null) {
			clusterId = 0
		}
		return {
			clusters: [],
			clusterId: clusterId
		}
	},
	template: `<div>
		<b-select
			style="max-width: 10em"
			name="clusterId"
			v-model="clusterId"
			:options="[
					{label: $t('cluster_cluster-selector@选择集群'), value: '0'},
					...clusters.map(cluster => ({
							label: cluster.name??'',
							value: cluster.id??'',
					}))
			]"
		></b-select>
</div>`
})

// 显示节点的多个集群
Vue.component("node-clusters-labels", {
	props: ["v-primary-cluster", "v-secondary-clusters", "size"],
	data: function () {
		let cluster = this.vPrimaryCluster
		let secondaryClusters = this.vSecondaryClusters
		if (secondaryClusters == null) {
			secondaryClusters = []
		}

		let labelSize = this.size
		if (labelSize == null) {
			labelSize = "small"
		}
		return {
			cluster: cluster,
			secondaryClusters: secondaryClusters,
			labelSize: labelSize
		}
	},
	template: `<div>
	<a v-if="cluster != null" :href="'/clusters/cluster?clusterId=' + cluster.id" :title="$t('cluster_node-clusters-labels@主集群')" style="margin-bottom: 0.3em;">
		<span class="ui label basic grey" :class="labelSize" v-if="labelSize != 'tiny'">{{cluster.name}}</span>
		<grey-label v-if="labelSize == 'tiny'">{{cluster.name}}</grey-label>
	</a>
	<a v-for="c in secondaryClusters" :href="'/clusters/cluster?clusterId=' + c.id" :class="labelSize" :title="$t('cluster_node-clusters-labels@从集群')">
		<span class="ui label basic grey" :class="labelSize" v-if="labelSize != 'tiny'">{{c.name}}</span>
		<grey-label v-if="labelSize == 'tiny'">{{c.name}}</grey-label>
	</a>
</div>`
})

Vue.component("node-cluster-combo-box", {
	props: ["v-cluster-id"],
	data: function () {
		let that = this
		Tea.action("/clusters/options")
			.post()
			.success(function (resp) {
				that.clusters = resp.data.clusters
			})
		return {
			clusters: []
		}
	},
	methods: {
		change: function (item) {
			if (item == null) {
				this.$emit("change", 0)
			} else {
				this.$emit("change", item.value)
			}
		}
	},
	template: `<div v-if="clusters.length > 0" style="min-width: 10.4em">
	<combo-box title="集群" :placeholder="$t('index_集群名称_0101')" :v-items="clusters" name="clusterId" :v-value="vClusterId" @change="change"></combo-box>
</div>`
})

Vue.component("ddos-protection-ports-config-box", {
	props: ["v-ports"],
	data: function () {
		let ports = this.vPorts
		if (ports == null) {
			ports = []
		}
		return {
			ports: ports,
			isAdding: false,
			addingPort: {
				port: "",
				description: ""
			}
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingPortInput.focus()
			})
		},
		confirm: function () {
			let portString = this.addingPort.port
			if (portString.length == 0) {
				this.warn(this.$t('cluster_ddos-protection-ports-config-box@请输入端口号'))
				return
			}
			if (!/^\d+$/.test(portString)) {
				this.warn(this.$t('cluster_ddos-protection-ports-config-box@请输入正确端口号'))
				return
			}
			let port = parseInt(portString, 10)
			if (port <= 0) {
				this.warn(this.$t('cluster_ddos-protection-ports-config-box@请输入正确端口号'))
				return
			}
			if (port > 65535) {
				this.warn(this.$t('cluster_ddos-protection-ports-config-box@请输入正确端口号'))
				return
			}

			let exists = false
			this.ports.forEach(function (v) {
				if (v.port == port) {
					exists = true
				}
			})
			if (exists) {
				this.warn(this.$t('cluster_ddos-protection-ports-config-box@端口号已存在'))
				return
			}

			this.ports.push({
				port: port,
				description: this.addingPort.description
			})
			this.notifyChange()
			this.cancel()
		},
		cancel: function () {
			this.isAdding = false
			this.addingPort = {
				port: "",
				description: ""
			}
		},
		remove: function (index) {
			this.ports.$remove(index)
			this.notifyChange()
		},
		warn: function (message) {
			let that = this
			teaweb.warn(message, function () {
				that.$refs.addingPortInput.focus()
			})
		},
		notifyChange: function () {
			this.$emit("change", this.ports)
		}
	},
	template: `<div>
	<div v-if="ports.length > 0">
		<div class="ui label basic tiny" v-for="(portConfig, index) in ports">
			{{portConfig.port}} <span class="grey small" v-if="portConfig.description.length > 0">（{{portConfig.description}}）</span> <a href="" @click.prevent="remove(index)" :title="$t('cluster_ddos-protection-ports-config-box@删除')"><i class="icon remove"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div v-if="isAdding">
		<div class="ui fields inline">
			<div class="ui field">
				<div class="ui input left labeled">
					<span class="ui label">{{$t('cluster_ddos-protection-ports-config-box@端口')}}</span>
					<input type="text" v-model="addingPort.port" ref="addingPortInput" maxlength="5" size="5" :placeholder="$t('cluster_ddos-protection-ports-config-box@端口号')" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
				</div>
			</div>
			<div class="ui field">
				<div class="ui input left labeled">
					<span class="ui label">{{$t('cluster_ddos-protection-ports-config-box@备注')}}</span>
					<input type="text" v-model="addingPort.description" maxlength="12" size="12" :placeholder="$t('cluster_ddos-protection-ports-config-box@备注可选')" @keyup.enter="confirm" @keypress.enter.prevent="1"/>
				</div>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{$t('cluster_ddos-protection-ports-config-box@确定')}}</button>
				&nbsp;<a href="" @click.prevent="cancel()">{{$t('cluster_ddos-protection-ports-config-box@取消')}}</a>
			</div>
		</div>
	</div>
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("page-size-selector", {
	data: function () {
		let query = window.location.search
		let pageSize = 10
		if (query.length > 0) {
			query = query.substr(1)
			let params = query.split("&")
			params.forEach(function (v) {
				let pieces = v.split("=")
				if (pieces.length == 2 && pieces[0] == "pageSize") {
					let pageSizeString = pieces[1]
					if (pageSizeString.match(/^\d+$/)) {
						pageSize = parseInt(pageSizeString, 10)
						if (isNaN(pageSize) || pageSize < 1) {
							pageSize = 10
						}
					}
				}
			})
		}
		return {
			pageSize: pageSize
		}
	},
	watch: {
		pageSize: function () {
			window.ChangePageSize(this.pageSize)
		}
	},
	template: `
		<b-select
			style="height:34px;padding-top:0;padding-bottom:0;margin-left:1em;color:#666"
			v-model="pageSize"
			:options="[
				{label: '[每页]', value: '10'},
				{label: '10条', value: '10'},
				{label: '20条', value: '20'},
				{label: '30条', value: '30'},
				{label: '40条', value: '40'},
				{label: '50条', value: '50'},
				{label: '60条', value: '60'},
				{label: '70条', value: '70'},
				{label: '80条', value: '80'},
				{label: '90条', value: '90'},
				{label: '100条', value: '100'},
			]"
		></b-select>
	`
	// `<select class="ui dropdown" style="height:34px;padding-top:0;padding-bottom:0;margin-left:1em;color:#666" v-model="pageSize">
	// 		<option value="10">[每页]</option>
	// 		<option value="10" selected="selected">10条</option>
	// 		<option value="20">20条</option>
	// 		<option value="30">30条</option>
	// 		<option value="40">40条</option>
	// 		<option value="50">50条</option>
	// 		<option value="60">60条</option>
	// 		<option value="70">70条</option>
	// 		<option value="80">80条</option>
	// 		<option value="90">90条</option>
	// 		<option value="100">100条</option>
	// 	</select>`
})

Vue.component("csrf-token", {
	created: function () {
		this.refreshToken()
	},
	mounted: function () {
		let that = this
		this.$refs.token.addEventListener("submit", function () {
			that.refreshToken()
		})

		// 自动刷新
		setInterval(function () {
			that.refreshToken()
		}, 10 * 60 * 1000)
	},
	data: function () {
		return {
			token: ""
		}
	},
	methods: {
		refreshToken: function () {
			let that = this
			Tea.action("/csrf/token")
				.get()
				.success(function (resp) {
					that.token = resp.data.token
					that.$emit("csrf-token", that.token)
				})
		}
	},
	template: `<input type="hidden" name="csrfToken" :value="token" ref="token"/>`
})

Vue.component("size-capacity-view", {
	props: ["v-default-text", "v-value"],
	methods: {
		composeCapacity: function (capacity) {
			return teaweb.convertSizeCapacityToString(capacity)
		}
	},
	template: `<div class="capacity-view">
	<span v-if="vValue != null && vValue.count > 0" class="capacity-value">{{composeCapacity(vValue)}}</span>
	<span v-else class="capacity-empty">{{vDefaultText}}</span>
</div>`
})

Vue.component("page-box", {
	data: function () {
		return {
			page: ""
		}
	},
	created: function () {
		let that = this;
		setTimeout(function () {
			that.page = Tea.Vue.page;
		})
	},
	template: `<div>
	<div class="page" v-html="page"></div>
</div>`
})

/**
 * 菜单项
 */
Vue.component("inner-menu-item", {
	props: ["href", "active", "code"],
	data: function () {
		var active = this.active;
		if (typeof (active) == "undefined") {
			var itemCode = "";
			if (typeof (window.TEA.ACTION.data.firstMenuItem) != "undefined") {
				itemCode = window.TEA.ACTION.data.firstMenuItem;
			}
			active = (itemCode == this.code);
		}
		return {
			vHref: (this.href == null) ? "" : this.href,
			vActive: active
		};
	},
	template: '\
		<a :href="vHref" class="item right" style="color:#4183c4" :class="{active:vActive}">[<slot></slot>]</a> \
		'
});


Vue.component("copy-to-clipboard", {
	props: ["v-target"],
	created: function () {
		if (typeof ClipboardJS == "undefined") {
			let jsFile = document.createElement("script")
			jsFile.setAttribute("src", "/js/clipboard.min.js")
			document.head.appendChild(jsFile)
		}
	},
	methods: {
		copy: function () {
			new ClipboardJS('[data-clipboard-target]');
			teaweb.successToast("已复制到剪切板")
		}
	},
	template: `<a href="" title="拷贝到剪切板" :data-clipboard-target="'#' + vTarget" @click.prevent="copy"><i class="ui icon copy small"></i></em></a>`
})

Vue.component("datepicker", {
	props: ["value", "v-name", "name", "v-value", "v-bottom-left", "placeholder"],
	mounted: function () {
		let that = this
		teaweb.datepicker(this.$refs.dayInput, function (v) {
			that.day = v
			that.change()
		}, !!this.vBottomLeft)
	},
	data: function () {
		let name = this.vName
		if (name == null) {
			name = this.name
		}
		if (name == null) {
			name = "day"
		}

		let day = this.vValue
		if (day == null) {
			day = this.value
			if (day == null) {
				day = ""
			}
		}

		let placeholder = "YYYY-MM-DD"
		if (this.placeholder != null) {
			placeholder = this.placeholder
		}

		return {
			realName: name,
			realPlaceholder: placeholder,
			day: day
		}
	},
	watch: {
		value: function (v) {
			this.day = v

			let picker = this.$refs.dayInput.picker
			if (picker != null) {
				if (v != null && /^\d+-\d+-\d+$/.test(v)) {
					picker.setDate(v)
				}
			}
		}
	},
	methods: {
		change: function () {
			this.$emit("input", this.day) // support v-model，事件触发需要在 change 之前
			this.$emit("change", this.day)
		}
	},
	template: `<div style="display: inline-block">
	<input type="text" :name="realName" v-model="day" :placeholder="realPlaceholder" style="width:8.6em" maxlength="10" @input="change" ref="dayInput" autocomplete="off"/>
</div>`
})

Vue.component("server-group-selector", {
	props: ["v-groups"],
	data: function () {
		let groups = this.vGroups
		if (groups == null) {
			groups = []
		}
		return {
			groups: groups
		}
	},
	methods: {
		selectGroup: function () {
			let that = this
			let groupIds = this.groups.map(function (v) {
				return v.id.toString()
			}).join(",")
			teaweb.popup("/servers/groups/selectPopup?selectedGroupIds=" + groupIds, {
				title: this.$t('server-group-selector@选择分组'),
				callback: function (resp) {
					that.groups.push(resp.data.group)
					that.submit()
				}
			})
		},
		addGroup: function () {
			let that = this
			teaweb.popup("/servers/groups/createPopup", {
				title: this.$t('server-group-selector@创建分组'),
				callback: function (resp) {
					that.groups.push(resp.data.group)
					that.submit()
				}
			})
		},
		removeGroup: function (index) {
			this.groups.$remove(index)
			this.submit()
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.groups)
			}, 100)
		},
		groupIds: function () {
			return this.groups.map(function (v) {
				return v.id
			})
		}
	},
	template: `<div class="groups-selector">
	<div class="groups-list" v-if="groups.length > 0">
		<div class="ui label small basic" v-for="(group, index) in groups">
			<input type="hidden" name="groupIds" :value="group.id"/>
			<i class="icon folder"></i> {{group.name}} 
			<a href="" title="删除" @click.prevent="removeGroup(index)" class="delete-link">
				<i class="icon remove"></i>
			</a>
		</div>
	</div>
	
	<div class="groups-actions">
		<a href="" @click.prevent="selectGroup()" class="action-link">
			<i class="icon plus circle"></i> {{$t('server-group-selector@选择分组')}}
		</a> 
		<a href="" @click.prevent="addGroup()" class="action-link">
			<i class="icon add"></i> {{$t('server-group-selector@添加分组')}}
		</a>
	</div>
</div>`
})

Vue.component("columns-grid", {
	props: [],
	mounted: function () {
		this.columns = this.calculateColumns()

		let that = this
		window.addEventListener("resize", function () {
			that.columns = that.calculateColumns()
		})
	},
	data: function () {
		return {
			columns: "four"
		}
	},
	methods: {
		calculateColumns: function () {
			let w = window.innerWidth
			let columns = Math.floor(w / 250)
			if (columns == 0) {
				columns = 1
			}

			let columnElements = this.$el.getElementsByClassName("column")
			if (columnElements.length == 0) {
				return
			}
			let maxColumns = columnElements.length
			if (columns > maxColumns) {
				columns = maxColumns
			}

			// 添加右侧边框
			for (let index = 0; index < columnElements.length; index++) {
				let el = columnElements[index]
				el.className = el.className.replace("with-border", "")
				if (index % columns == columns - 1 || index == columnElements.length - 1 /** 最后一个 **/) {
					el.className += " with-border"
				}
			}

			switch (columns) {
				case 1:
					return "one"
				case 2:
					return "two"
				case 3:
					return "three"
				case 4:
					return "four"
				case 5:
					return "five"
				case 6:
					return "six"
				case 7:
					return "seven"
				case 8:
					return "eight"
				case 9:
					return "nine"
				case 10:
					return "ten"
				default:
					return "ten"
			}
		}
	},
	template: `<div :class="'ui ' + columns + ' columns grid counter-chart'">
	<slot></slot>
</div>`
})

Vue.component("labeled-input", {
	props: ["name", "size", "maxlength", "label", "value"],
	template: '<div class="ui input right labeled"> \
	<input type="text" :name="name" :size="size" :maxlength="maxlength" :value="value"/>\
	<span class="ui label">{{label}}</span>\
</div>'
});

// 使用Icon的链接方式
Vue.component("link-icon", {
	props: ["href", "title", "target", "size"],
	data: function () {
		let realSize = this.size
		if (realSize == null || realSize.length == 0) {
			realSize = "small"
		}

		return {
			vTitle: (this.title == null) ? "打开链接" : this.title,
			realSize: realSize
		}
	},
	template: `<span><slot></slot><a :href="href" :title="vTitle" :target="target"><i class="icon linkify ant-btn-link" :class="realSize"></i></a></span>`
})

// 切换用户弹窗
Vue.component("switch-user-icon", {
	props: ["v-user-id"],
	data: function () {
		let userId = this.vUserId
		return {
			userId: userId
		}
	},
	methods: {
		switchUser: function (userId) {
			teaweb.confirm("确定要切换至这个用户吗？", function () {
				this.$post("/users/switch")
					.params({
						userId: userId
					})
					.success(function (resp) {
						window.open(resp.data.jumpURL,"_user_admin")
					})
			})
		},
	},
	template: `<a href="" title="切换用户" @click.prevent="switchUser(userId)"><i class="ui icon exchange"></i></em></a>`
})

// 带有下划虚线的连接
Vue.component("link-red", {
	props: ["href", "title"],
	data: function () {
		let href = this.href
		if (href == null) {
			href = ""
		}
		return {
			vHref: href
		}
	},
	methods: {
		clickPrevent: function () {
			emitClick(this, arguments)

			if (this.vHref.length > 0) {
				window.location = this.vHref
			}
		}
	},
	template: `<a :href="vHref" :title="title" style="border-bottom: 1px #db2828 dashed" @click.prevent="clickPrevent"><span class="red"><slot></slot></span></a>`
})

// 会弹出窗口的链接
Vue.component("link-popup", {
	props: ["title"],
	methods: {
		clickPrevent: function () {
			emitClick(this, arguments)
		}
	},
	template: `<a href="" :title="title" @click.prevent="clickPrevent"><slot></slot></a>`
})

Vue.component("popup-icon", {
	props: ["title", "href", "height"],
	methods: {
		clickPrevent: function () {
			if (this.href != null && this.href.length > 0) {
				teaweb.popup(this.href, {
					height: this.height
				})
			}
		}
	},
	template: `<span><slot></slot>&nbsp;<a href="" :title="title" @click.prevent="clickPrevent"><i class="icon expand small"></i></a></span>`
})

// 小提示
Vue.component("tip-icon", {
	props: ["content"],
	methods: {
		showTip: function () {
			teaweb.popupTip(this.content)
		}
	},
	template: `
		<a href="" title="查看帮助" @click.prevent="showTip">
			<i class="pi pi-question-circle gray"></i>
		</a>
	`,
})

// 提交点击事件
function emitClick(obj, arguments) {
	let event = "click"
	let newArgs = [event]
	for (let i = 0; i < arguments.length; i++) {
		newArgs.push(arguments[i])
	}
	obj.$emit.apply(obj, newArgs)
}

Vue.component("health-check-config-box", {
	props: ["v-health-check-config", "v-check-domain-url", "v-is-plus"],
	data: function () {
		let healthCheckConfig = this.vHealthCheckConfig
		let urlProtocol = "http"
		let urlPort = ""
		let urlRequestURI = "/"
		let urlHost = ""

		if (healthCheckConfig == null) {
			healthCheckConfig = {
				isOn: false,
				url: "",
				interval: {count: 60, unit: "second"},
				statusCodes: [200],
				timeout: {count: 10, unit: "second"},
				countTries: 3,
				tryDelay: {count: 100, unit: "ms"},
				autoDown: true,
				countUp: 1,
				countDown: 3,
				userAgent: "",
				onlyBasicRequest: true,
				accessLogIsOn: true
			}
			let that = this
			setTimeout(function () {
				that.changeURL()
			}, 500)
		} else {
			try {
				let url = new URL(healthCheckConfig.url)
				urlProtocol = url.protocol.substring(0, url.protocol.length - 1)

				// 域名
				urlHost = url.host
				if (urlHost == "%24%7Bhost%7D") {
					urlHost = "${host}"
				}
				let colonIndex = urlHost.indexOf(":")
				if (colonIndex > 0) {
					urlHost = urlHost.substring(0, colonIndex)
				}

				urlPort = url.port
				urlRequestURI = url.pathname
				if (url.search.length > 0) {
					urlRequestURI += url.search
				}
			} catch (e) {
			}

			if (healthCheckConfig.statusCodes == null) {
				healthCheckConfig.statusCodes = [200]
			}
			if (healthCheckConfig.interval == null) {
				healthCheckConfig.interval = {count: 60, unit: "second"}
			}
			if (healthCheckConfig.timeout == null) {
				healthCheckConfig.timeout = {count: 10, unit: "second"}
			}
			if (healthCheckConfig.tryDelay == null) {
				healthCheckConfig.tryDelay = {count: 100, unit: "ms"}
			}
			if (healthCheckConfig.countUp == null || healthCheckConfig.countUp < 1) {
				healthCheckConfig.countUp = 1
			}
			if (healthCheckConfig.countDown == null || healthCheckConfig.countDown < 1) {
				healthCheckConfig.countDown = 3
			}
		}

		return {
			healthCheck: healthCheckConfig,
			advancedVisible: false,
			urlProtocol: urlProtocol,
			urlHost: urlHost,
			urlPort: urlPort,
			urlRequestURI: urlRequestURI,
			urlIsEditing: healthCheckConfig.url.length == 0,

			hostErr: ""
		}
	},
	watch: {
		urlRequestURI: function () {
			if (this.urlRequestURI.length > 0 && this.urlRequestURI[0] != "/") {
				this.urlRequestURI = "/" + this.urlRequestURI
			}
			this.changeURL()
		},
		urlPort: function (v) {
			let port = parseInt(v)
			if (!isNaN(port)) {
				this.urlPort = port.toString()
			} else {
				this.urlPort = ""
			}
			this.changeURL()
		},
		urlProtocol: function () {
			this.changeURL()
		},
		urlHost: function () {
			this.changeURL()
			this.hostErr = ""
		},
		"healthCheck.countTries": function (v) {
			let count = parseInt(v)
			if (!isNaN(count)) {
				this.healthCheck.countTries = count
			} else {
				this.healthCheck.countTries = 0
			}
		},
		"healthCheck.countUp": function (v) {
			let count = parseInt(v)
			if (!isNaN(count)) {
				this.healthCheck.countUp = count
			} else {
				this.healthCheck.countUp = 0
			}
		},
		"healthCheck.countDown": function (v) {
			let count = parseInt(v)
			if (!isNaN(count)) {
				this.healthCheck.countDown = count
			} else {
				this.healthCheck.countDown = 0
			}
		}
	},
	methods: {
		showAdvanced: function () {
			this.advancedVisible = !this.advancedVisible
		},
		changeURL: function () {
			let urlHost = this.urlHost
			if (urlHost.length == 0) {
				urlHost = "${host}"
			}
			this.healthCheck.url = this.urlProtocol + "://" + urlHost + ((this.urlPort.length > 0) ? ":" + this.urlPort : "") + this.urlRequestURI
		},
		changeStatus: function (values) {
			this.healthCheck.statusCodes = values.$map(function (k, v) {
				let status = parseInt(v)
				if (isNaN(status)) {
					return 0
				} else {
					return status
				}
			})
		},
		onChangeURLHost: function () {
			let checkDomainURL = this.vCheckDomainUrl
			if (checkDomainURL == null || checkDomainURL.length == 0) {
				return
			}

			let that = this
			Tea.action(checkDomainURL)
				.params({host: this.urlHost})
				.success(function (resp) {
					if (!resp.data.isOk) {
						that.hostErr = that.$t("components_health_check_config_box@域名在集群中未找到")
					} else {
						that.hostErr = ""
					}
				})
				.post()
		},
		editURL: function () {
			this.urlIsEditing = !this.urlIsEditing
		}
	},
	template: `<div>
<input type="hidden" name="healthCheckJSON" :value="JSON.stringify(healthCheck)"/>
<div class="config-section">
	<div class="section-title">{{$t("components_health_check_config_box@健康检查设置")}}</div>

	<div class="config-item">
		<div class="item-content">
			<checkbox v-model="healthCheck.isOn" :v-value="1">{{$t("components_health_check_config_box@启用健康检查")}}</checkbox>
			<p class="comment">{{$t("components_health_check_config_box@通过访问节点上的网站URL来确定节点是否健康")}}</p>
		</div>
	</div>

	<div v-show="healthCheck.isOn">
		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@检测URL")}} *</div>
			<div class="item-content">
				<div v-if="healthCheck.url.length > 0 && !urlIsEditing" style="margin-bottom: 0.5em">
					<code-label>{{healthCheck.url}}</code-label> &nbsp;
					<a href="" @click.prevent="editURL"><span class="small">{{$t("components_health_check_config_box@修改")}} <i class="icon angle up"></i></span></a>
				</div>
				<div v-show="urlIsEditing" class="config-section" style="padding: 1em; border: 1px solid #eee;">
					<div class="config-item">
						<div class="item-label" style="width: 80px !important;">{{$t("components_health_check_config_box@协议")}}</div>
						<div class="item-content">
							<b-select
								v-model="urlProtocol"
								auto-width
								:options="[
										{label: 'http://', value: 'http'},
										{label: 'https://', value: 'https'},
								]"
							></b-select>
						</div>
					</div>
					<div class="config-item">
						<div class="item-label" style="width: 80px !important;">{{$t("components_health_check_config_box@域名")}}</div>
						<div class="item-content">
							<input type="text" v-model="urlHost" @change="onChangeURLHost"/>
							<p class="comment"><span v-if="hostErr.length > 0" class="red">{{hostErr}}</span>{{$t("components_health_check_config_box@已部署到当前集群的一个域名")}}<span class="red" v-if="urlProtocol == 'https' && urlHost.length == 0">{{$t("components_health_check_config_box@如果协议是https这里必须填写一个已经设置了SSL证书的域名")}}</span></p>
						</div>
					</div>
					<div class="config-item">
						<div class="item-label" style="width: 80px !important;">{{$t("components_health_check_config_box@端口")}}</div>
						<div class="item-content">
							<input type="text" maxlength="5" style="width:5.4em" :placeholder="$t('components_health_check_config_box@端口占位符')" v-model="urlPort"/>
							<p class="comment">{{$t("components_health_check_config_box@域名或者IP的端口可选项")}}</p>
						</div>
					</div>
					<div class="config-item">
						<div class="item-label" style="width: 80px !important;">{{$t("components_health_check_config_box@RequestURI")}}</div>
						<div class="item-content">
							<input type="text" v-model="urlRequestURI" placeholder="/" style="width:20em"/>
							<p class="comment">{{$t("components_health_check_config_box@请求的路径可以带参数可选项")}}</p>
						</div>
					</div>
					<div style="margin-top: 1em;">
						<a href="" @click.prevent="editURL" v-if="healthCheck.url.length > 0"><span class="small">{{$t("components_health_check_config_box@收起")}} <i class="icon angle down"></i></span></a>
					</div>
				</div>
				<b-notice v-if="urlIsEditing && healthCheck.url.length > 0">{{$t("components_health_check_config_box@拼接后的检测URL")}}：<code-label>{{healthCheck.url}}</code-label>{{$t("components_health_check_config_box@其中host指的是域名")}}</b-notice>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@检测时间间隔")}}</div>
			<div class="item-content">
				<time-duration-box :v-value="healthCheck.interval"></time-duration-box>
				<p class="comment">{{$t("components_health_check_config_box@两次检查之间的间隔")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="healthCheck.autoDown" :v-value="1">{{$t("components_health_check_config_box@自动上下线")}}<span v-if="vIsPlus">IP</span></checkbox>
				<p class="comment">{{$t("components_health_check_config_box@选中后系统会根据健康检查的结果自动标记")}}<span v-if="vIsPlus">{{$t("components_health_check_config_box@节点IP")}}</span><span v-else>{{$t("components_health_check_config_box@节点")}}</span>{{$t("components_health_check_config_box@的上线下线状态并可能自动同步DNS设置")}}<span v-if="!vIsPlus">{{$t("components_health_check_config_box@注意免费版的只能整体上下线整个节点商业版的可以下线单个IP")}}</span></p>
			</div>
		</div>

		<div class="config-item" v-show="healthCheck.autoDown">
			<div class="item-label">{{$t("components_health_check_config_box@连续上线次数")}}</div>
			<div class="item-content">
				<input type="text" v-model="healthCheck.countUp" style="width:5em" maxlength="6"/>
				<p class="comment">{{$t("components_health_check_config_box@连续")}}{{healthCheck.countUp}}{{$t("components_health_check_config_box@次检查成功后自动恢复上线")}}</p>
			</div>
		</div>

		<div class="config-item" v-show="healthCheck.autoDown">
			<div class="item-label">{{$t("components_health_check_config_box@连续下线次数")}}</div>
			<div class="item-content">
				<input type="text" v-model="healthCheck.countDown" style="width:5em" maxlength="6"/>
				<p class="comment">{{$t("components_health_check_config_box@连续")}}{{healthCheck.countDown}}{{$t("components_health_check_config_box@次检查失败后自动下线")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@更多选项")}}</div>
			<div class="item-content">
				<a href="" @click.prevent="showAdvanced()" class="more-options-toggle">
					<i class="icon angle" :class="{down:!advancedVisible, right:advancedVisible}"></i>
					<span v-if="!advancedVisible">{{$t("components_health_check_config_box@显示更多选项")}}</span>
					<span v-if="advancedVisible">{{$t("components_health_check_config_box@收起选项")}}</span>
				</a>
			</div>
		</div>
	</div>

	<div v-show="advancedVisible && healthCheck.isOn">
		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@允许的状态码")}}</div>
			<div class="item-content">
				<values-box :values="healthCheck.statusCodes" maxlength="3" @change="changeStatus"></values-box>
				<p class="comment">{{$t("components_health_check_config_box@允许检测URL返回的状态码列表")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@超时时间")}}</div>
			<div class="item-content">
				<time-duration-box :v-value="healthCheck.timeout"></time-duration-box>
				<p class="comment">{{$t("components_health_check_config_box@读取检测URL超时时间")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@连续尝试次数")}}</div>
			<div class="item-content">
				<input type="text" v-model="healthCheck.countTries" style="width: 5em" maxlength="2"/>
				<p class="comment">{{$t("components_health_check_config_box@如果读取检测URL失败后需要再次尝试的次数")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@每次尝试间隔")}}</div>
			<div class="item-content">
				<time-duration-box :v-value="healthCheck.tryDelay"></time-duration-box>
				<p class="comment">{{$t("components_health_check_config_box@如果读取检测URL失败后再次尝试时的间隔时间")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("components_health_check_config_box@终端信息UserAgent")}}<em>（User-Agent）</em></div>
			<div class="item-content">
				<input type="text" v-model="healthCheck.userAgent" maxlength="200"/>
				<p class="comment">{{$t("components_health_check_config_box@发送到服务器的UserAgent值不填写表示使用默认值")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-content">
				<checkbox :value="1" v-model="healthCheck.onlyBasicRequest">{{$t("components_health_check_config_box@只基础请求")}}</checkbox>
				<p class="comment">{{$t("components_health_check_config_box@只做基础的请求不处理反向代理不检查源站WAF等")}}</p>
			</div>
		</div>

		<div class="config-item">
			<div class="item-content">
				<checkbox :value="1" v-model="healthCheck.accessLogIsOn">{{$t("components_health_check_config_box@记录访问日志")}}</checkbox>
				<p class="comment">{{$t("components_health_check_config_box@记录健康检查的访问日志")}}</p>
			</div>
		</div>
	</div>
</div>
<div class="margin"></div>
</div>`
})

Vue.component("bytes-var", {
	props: ["v-bytes"],
	data: function () {
		let bytes = this.vBytes
		if (typeof bytes != "number") {
			bytes = 0
		}
		let format = teaweb.splitFormat(teaweb.formatBytes(bytes))
		return {
			format: format
		}
	},
	template: `<var class="normal">
	<span>{{format[0]}}</span>{{format[1]}}
</var>`
})

let checkboxId = 0
Vue.component("checkbox", {
	props: ["name", "value", "v-value", "id", "checked"],
	data: function () {
		checkboxId++
		let elementId = this.id
		if (elementId == null) {
			elementId = "checkbox" + checkboxId
		}

		let elementValue = this.vValue
		if (elementValue == null) {
			elementValue = "1"
		}

		let checkedValue = this.value
		if (checkedValue == null && this.checked == "checked") {
			checkedValue = elementValue
		}

		return {
			elementId: elementId,
			elementValue: elementValue,
			newValue: checkedValue,
		}
	},
	methods: {
		change: function (ev) {
			this.$emit("input", this.newValue)
			this.$emit("change", this.newValue)
		},
		check: function () {
			this.newValue = this.elementValue
		},
		uncheck: function () {
			this.newValue = ""
		},
		isChecked: function () {
			return (typeof (this.newValue) == "boolean" && this.newValue) || this.newValue == this.elementValue
		}
	},
	watch: {
		value: function (v) {
			if (typeof v == "boolean") {
				this.newValue = v
			}
		}
	},
	template: `
		<span>
			<div class="b-checkbox-container">
				<div class="checked-box" v-if="newValue">
					<!--<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg" class="p-icon p-checkbox-icon" aria-hidden="true" data-pc-section="icon"><path d="M4.86199 11.5948C4.78717 11.5923 4.71366 11.5745 4.64596 11.5426C4.57826 11.5107 4.51779 11.4652 4.46827 11.4091L0.753985 7.69483C0.683167 7.64891 0.623706 7.58751 0.580092 7.51525C0.536478 7.44299 0.509851 7.36177 0.502221 7.27771C0.49459 7.19366 0.506156 7.10897 0.536046 7.03004C0.565935 6.95111 0.613367 6.88 0.674759 6.82208C0.736151 6.76416 0.8099 6.72095 0.890436 6.69571C0.970973 6.67046 1.05619 6.66385 1.13966 6.67635C1.22313 6.68886 1.30266 6.72017 1.37226 6.76792C1.44186 6.81567 1.4997 6.8786 1.54141 6.95197L4.86199 10.2503L12.6397 2.49483C12.7444 2.42694 12.8689 2.39617 12.9932 2.40745C13.1174 2.41873 13.2343 2.47141 13.3251 2.55705C13.4159 2.64268 13.4753 2.75632 13.4938 2.87973C13.5123 3.00315 13.4888 3.1292 13.4271 3.23768L5.2557 11.4091C5.20618 11.4652 5.14571 11.5107 5.07801 11.5426C5.01031 11.5745 4.9368 11.5923 4.86199 11.5948Z" fill="currentColor"></path></svg>-->
					<i class="pi pi-check checkbox-icon"></i>
				</div>
				<input type="checkbox" :name="name" :value="elementValue" :id="elementId" @change="change" v-model="newValue"/>
			</div>
			<label :for="elementId"><slot></slot></label>
		</span>
	`
})

Vue.component("file-textarea", {
	props: ["value"],
	data: function () {
		let value = this.value
		if (typeof value != "string") {
			value = ""
		}
		return {
			realValue: value
		}
	},
	mounted: function () {
	},
	methods: {
		dragover: function () { },
		drop: function (e) {
			let that = this
			e.dataTransfer.items[0].getAsFile().text().then(function (data) {
				that.setValue(data)
			})
		},
		setValue: function (value) {
			this.realValue = value
		},
		focus: function () {
			this.$refs.textarea.focus()
		}
	},
	template: `<textarea @drop.prevent="drop" @dragover.prevent="dragover" ref="textarea" v-model="realValue"></textarea>`
})

Vue.component("keyword", {
	props: ["v-word"],
	data: function () {
		let word = this.vWord
		if (word == null) {
			word = ""
		} else {
			word = word.replace(/\)/g, "\\)")
			word = word.replace(/\(/g, "\\(")
			word = word.replace(/\+/g, "\\+")
			word = word.replace(/\^/g, "\\^")
			word = word.replace(/\$/g, "\\$")
			word = word.replace(/\?/g, "\\?")
			word = word.replace(/\*/g, "\\*")
			word = word.replace(/\[/g, "\\[")
			word = word.replace(/{/g, "\\{")
			word = word.replace(/\./g, "\\.")
		}

		let slot = this.$slots["default"][0]
		let text = slot.text
		if (word.length > 0) {
			let that = this
			let m = []  // replacement => tmp
			let tmpIndex = 0
			text = text.replaceAll(new RegExp("(" + word + ")", "ig"), function (replacement) {
				tmpIndex++
				let s = "<span style=\"border: 1px #ccc dashed; color: #ef4d58\">" + that.encodeHTML(replacement) + "</span>"
				let tmpKey = "$TMP__KEY__" + tmpIndex.toString() + "$"
				m.push([tmpKey, s])
				return tmpKey
			})
			text = this.encodeHTML(text)

			m.forEach(function (r) {
				text = text.replace(r[0], r[1])
			})

		} else {
			text = this.encodeHTML(text)
		}

		return {
			word: word,
			text: text
		}
	},
	methods: {
		encodeHTML: function (s) {
			s = s.replace(/&/g, "&amp;")
			s = s.replace(/</g, "&lt;")
			s = s.replace(/>/g, "&gt;")
			s = s.replace(/"/g, "&quot;")
			return s
		}
	},
	template: `<span><span style="display: none"><slot></slot></span><span class="ant-btn-link" v-html="text"></span></span>`
})

Vue.component("bits-var", {
	props: ["v-bits"],
	data: function () {
		let bits = this.vBits
		if (typeof bits != "number") {
			bits = 0
		}
		let format = teaweb.splitFormat(teaweb.formatBits(bits))
		return {
			format: format
		}
	},
	template: `<var class="normal">
	<span>{{format[0]}}</span>{{format[1]}}
</var>`
})

Vue.component('b-sortable-table', {
  props: {
    columns: {
      type: Array,
      required: true
    },
    dataSource: {
      type: Array,
      required: true
    },
    rowKey: {
      type: String,
      default: 'id'
    },
    bordered: {
      type: Boolean,
      default: false
    },
    size: {
      type: String,
      default: 'default'
    },
    pagination: {
      type: [Object, Boolean],
      default: false
    },
    loading: {
      type: Boolean,
      default: false
    },
    handleField: {
      type: String,
      default: null  // 用于指定拖拽把手所在的字段
    },
    onSort: {
      type: Function,
      default: null  // 排序回调函数
    }
  },
  data() {
    return {
      sortableInstance: null,
      justSorted: false
    }
  },
  methods: {
    customRender(column, record, index) {
      // 检查是否存在自定义渲染插槽
      if (column.scopedSlots && column.scopedSlots.customRender) {
        const slotName = column.scopedSlots.customRender;

        if (this.$scopedSlots[slotName]) {
          return this.$scopedSlots[slotName]({
            text: record[column.dataIndex],
            record: record,
            index: index,
            column: column
          });
        }
      }

      // 如果没有插槽或插槽不存在，则使用默认渲染
      if (record && column.dataIndex !== undefined) {
        return record[column.dataIndex];
      }
      return '';
    },
    getProcessedColumns() {
      if (!this.columns) return [];

      return this.columns.map(column => {
        const newColumn = { ...column };

        if (!newColumn.width) {
          newColumn.width = '150px';
        }

        if (column.scopedSlots && column.scopedSlots.customRender) {
          newColumn.customRender = (text, record, index) => {
            return this.customRender(column, record, index);
          };
        }

        if (column.slots && column.slots.title) {
          const titleSlotName = column.slots.title;
          if (this.$scopedSlots[titleSlotName]) {
              newColumn.title = () => {
                  return this.$scopedSlots[titleSlotName]({
                      column: column
                  });
              };
          }
      }

        return newColumn;
      });
    },
    initSortable() {
      // 确保 sortLoad 函数存在
      if (typeof sortLoad !== 'function') {
        console.error('sortLoad function is not defined');
        return;
      }

      // 使用 sortLoad 加载 Sortable.js 库
      sortLoad(() => {
        this.$nextTick(() => {
          this.setupSortable();
        });
      });
    },
    setupSortable() {
      // 确保 Sortable 已加载
      if (typeof Sortable === 'undefined') {
        console.error('Sortable is not loaded');
        return;
      }

      const tbody = this.$el.querySelector('.ant-table-tbody');
      if (!tbody) {
        console.error('Table body not found');
        return;
      }

      // 如果已经有实例，先销毁
      if (this.sortableInstance) {
        this.sortableInstance.destroy();
      }

      // 创建新的实例
      this.sortableInstance = Sortable.create(tbody, {
        handle: this.handleField ? `.handle-${this.handleField}` : '.icon.handle',
        animation: 150,
        draggable: 'tr', // 拖拽tr元素
        ghostClass: 'sortable-ghost', // 拖拽时，被"替代"的元素的类名
        chosenClass: 'sortable-chosen', // 被选中元素的类名
        dragClass: 'sortable-drag', // 正在被拖拽的元素的类名
        onStart: () => {
          this.justSorted = false;
          // 添加鼠标形状提示
          document.body.style.cursor = 'grabbing';
        },
        onEnd: (evt) => {
          // 恢复鼠标形状
          document.body.style.cursor = '';

          // 更新数据源顺序
          const newIndex = evt.newIndex;
          const oldIndex = evt.oldIndex;

          if (newIndex !== oldIndex) {
            this.justSorted = true;

            // 创建一个新的数组来保存重新排序的数据
            const newDataSource = [...this.dataSource];
            const movedItem = newDataSource.splice(oldIndex, 1)[0];
            newDataSource.splice(newIndex, 0, movedItem);

            // 添加排序成功的高亮效果
            const row = evt.item;
            row.classList.add('sort-success');
            setTimeout(() => {
              row.classList.remove('sort-success');
            }, 1000);

            // 收集所有行的ID，用于传递给回调函数
            const rowIds = newDataSource.map(item => item[this.rowKey]);

            // 调用回调函数
            if (typeof this.onSort === 'function') {
              this.onSort(rowIds);
            }
          }
        }
      });
    }
  },
  mounted() {
    this.$nextTick(() => {
      this.initSortable();
    });
  },
  updated() {
    this.$nextTick(() => {
      this.initSortable();
    });
  },
  beforeDestroy() {
    if (this.sortableInstance) {
      this.sortableInstance.destroy();
      this.sortableInstance = null;
    }
  },
  template: `
        <div class="b-sortable-table-container" style="overflow-x: auto;">
            <a-table
                :columns="getProcessedColumns()"
                :data-source="dataSource"
                :row-key="rowKey"
                :bordered="bordered"
                :size="size"
                :pagination="pagination"
                :loading="loading"
                :class="['b-sortable-table']"
            >
                <template
                    v-for="(_, name) in $slots"
                    :slot="name"
                    slot-scope="slotData"
                >
                    <slot :name="name" v-bind="slotData"></slot>
                </template>
            </a-table>
        </div>
    `
}); 

Vue.component("node-log-row", {
	props: ["v-log", "v-keyword"],
	data: function () {
		return {
			log: this.vLog,
			keyword: this.vKeyword
		}
	},
	template: `<div>
	<pre class="log-box" style="margin: 0; padding: 0"><span :class="{red:log.level == 'error', orange:log.level == 'warning', green: log.level == 'success'}"><span v-if="!log.isToday">[{{log.createdTime}}]</span><strong v-if="log.isToday">[{{log.createdTime}}]</strong><keyword :v-word="keyword">[{{log.tag}}]{{log.description}}</keyword></span> &nbsp; <span v-if="log.count > 1" class="ui label tiny" :class="{red:log.level == 'error', orange:log.level == 'warning'}">{{$t('dns_tasks@共x条',[log.count])}}</span> <span v-if="log.server != null && log.server.id > 0"><a :href="'/servers/server?serverId=' + log.server.id" class="ui label tiny basic">{{log.server.name}}</a></span></pre>
</div>`
})

Vue.component("bandwidth-size-capacity-box", {
	props: ["v-name", "v-value", "v-count", "v-unit", "size", "maxlength", "v-supported-units"],
	data: function () {
		let v = this.vValue
		if (v == null) {
			v = {
				count: this.vCount,
				unit: this.vUnit
			}
		}
		if (v.unit == null || v.unit.length == 0) {
			v.unit = "mb"
		}

		if (typeof (v["count"]) != "number") {
			v["count"] = -1
		}

		let vSize = this.size
		if (vSize == null) {
			vSize = 6
		}

		let vMaxlength = this.maxlength
		if (vMaxlength == null) {
			vMaxlength = 10
		}

		let supportedUnits = this.vSupportedUnits
		if (supportedUnits == null) {
			supportedUnits = []
		}

		return {
			capacity: v,
			countString: (v.count >= 0) ? v.count.toString() : "",
			vSize: vSize,
			vMaxlength: vMaxlength,
			supportedUnits: supportedUnits
		}
	},
	computed: {
		option: function () {
			const contains = [
				{ label: 'Bps', value: 'b' },
				{ label: 'Kbps', value: 'kb' },
				{ label: 'Mbps', value: 'mb' },
				{ label: 'Gbps', value: 'gb' },
				{ label: 'Tbps', value: 'tb' },
				{ label: 'Pbps', value: 'pb' },
				{ label: 'Ebps', value: 'eb' }
			]
			const options = this.supportedUnits.map(unit => ({ label: unit, value: unit }))
			if (options.length == 0) {
				return contains
			}

			return contains.filter(item => options.$contains(item.value))
		}
	},
	watch: {
		"countString": function (newValue) {
			let value = newValue.trim()
			if (value.length == 0) {
				this.capacity.count = -1
				this.change()
				return
			}
			let count = parseInt(value)
			if (!isNaN(count)) {
				this.capacity.count = count
			}
			this.change()
		}
	},
	methods: {
		change: function () {
			this.$emit("change", this.capacity)
		}
	},
	template: `<div class="ui fields inline">
	<input type="hidden" :name="vName" :value="JSON.stringify(capacity)"/>
	<div class="ui field">
		<input type="text" v-model="countString" :maxlength="vMaxlength" :size="vSize"/>
	</div>
	<div class="ui field">
		<b-select v-model="capacity.unit" @change="change" :options="option"></b-select>
	</div>
</div>`
})

// 信息提示窗口
Vue.component("tip-message-box", {
	props: ["code"],
	mounted: function () {
		let that = this
		Tea.action("/ui/showTip")
			.params({
				code: this.code
			})
			.success(function (resp) {
				that.visible = resp.data.visible
			})
			.post()
	},
	data: function () {
		return {
			visible: false
		}
	},
	methods: {
		close: function () {
			this.visible = false
			Tea.action("/ui/hideTip")
				.params({
					code: this.code
				})
				.post()
		}
	},
	template: `<div class="ui icon message" v-if="visible">
	<i class="icon info circle"></i>
	<i class="close icon" title="取消" @click.prevent="close" style="margin-top: 1em"></i>
	<div class="content">
		<slot></slot>
	</div>
</div>`
})

Vue.component("url-patterns-box", {
	props: ["value"],
	data: function () {
		let patterns = []
		if (this.value != null) {
			patterns = this.value
		}

		return {
			patterns: patterns,
			isAdding: false,

			addingPattern: { "type": "wildcard", "pattern": "" },
			editingIndex: -1,

			patternIsInvalid: false,

			windowIsSmall: window.innerWidth < 600
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.patternInput.focus()
			})
		},
		edit: function (index) {
			this.isAdding = true
			this.editingIndex = index
			this.addingPattern = {
				type: this.patterns[index].type,
				pattern: this.patterns[index].pattern
			}
		},
		confirm: function () {
			if (this.requireURL(this.addingPattern.type)) {
				let pattern = this.addingPattern.pattern.trim()
				if (pattern.length == 0) {
					let that = this
					teaweb.warn(this.$t('url-patterns-box@请输入URL'), function () {
						that.$refs.patternInput.focus()
					})
					return
				}
			}
			if (this.editingIndex < 0) {
				this.patterns.push({
					type: this.addingPattern.type,
					pattern: this.addingPattern.pattern
				})
			} else {
				this.patterns[this.editingIndex].type = this.addingPattern.type
				this.patterns[this.editingIndex].pattern = this.addingPattern.pattern
			}
			this.notifyChange()
			this.cancel()
		},
		remove: function (index) {
			this.patterns.$remove(index)
			this.cancel()
			this.notifyChange()
		},
		cancel: function () {
			this.isAdding = false
			this.addingPattern = { "type": "wildcard", "pattern": "" }
			this.editingIndex = -1
		},
		patternTypeName: function (patternType) {
			switch (patternType) {
				case "wildcard":
					return this.$t('url-patterns-box@通配符')
				case "regexp":
					return this.$t('url-patterns-box@正则')
				case "images":
					return this.$t('url-patterns-box@常见图片文件')
				case "audios":
					return this.$t('url-patterns-box@常见音频文件')
				case "videos":
					return this.$t('url-patterns-box@常见视频文件')
			}
			return ""
		},
		notifyChange: function () {
			this.$emit("input", this.patterns)
		},
		changePattern: function () {
			this.patternIsInvalid = false
			let pattern = this.addingPattern.pattern
			switch (this.addingPattern.type) {
				case "wildcard":
					if (pattern.indexOf("?") >= 0) {
						this.patternIsInvalid = true
					}
					break
				case "regexp":
					if (pattern.indexOf("?") >= 0) {
						let pieces = pattern.split("?")
						for (let i = 0; i < pieces.length - 1; i++) {
							if (pieces[i].length == 0 || pieces[i][pieces[i].length - 1] != "\\") {
								this.patternIsInvalid = true
							}
						}
					}
					break
			}
		},
		requireURL: function (patternType) {
			return patternType == "wildcard" || patternType == "regexp"
		}
	},
	template: `<div>
	<div v-show="patterns.length > 0">
		<div v-for="(pattern, index) in patterns" class="ui label basic small" :class="{blue: index == editingIndex, disabled: isAdding && index != editingIndex}" style="margin-bottom: 0.8em">
			<span class="grey" style="font-weight: normal">[{{patternTypeName(pattern.type)}}]</span> <span >{{pattern.pattern}}</span> &nbsp; 
			<a href="" :title="$t('url-patterns-box@修改')" @click.prevent="edit(index)"><i class="icon pencil tiny"></i></a> 
			<a href="" :title="$t('url-patterns-box@删除')" @click.prevent="remove(index)"><i class="icon remove small"></i></a>
		</div>
	</div>
	<div v-show="isAdding" style="margin-top: 0.5em">
		<div :class="{'ui fields inline': !windowIsSmall}">
			<div class="ui field">
				<b-select v-model="addingPattern.type" :options="[
					{label:$t('url-patterns-box@通配符'), value:'wildcard'},
					{label:$t('url-patterns-box@正则表达式'), value:'regexp'},
					{label:$t('url-patterns-box@常见图片'), value:'images'},
					{label:$t('url-patterns-box@常见音频'), value:'audios'},
					{label:$t('url-patterns-box@常见视频'), value:'videos'},
				]"></b-select>
			</div>
			<div class="ui field" v-show="addingPattern.type == 'wildcard' || addingPattern.type ==  'regexp'">
				<input type="text" :placeholder="$t(addingPattern.type == 'wildcard' ? 'url-patterns-box@通配符Placeholder' : 'url-patterns-box@正则Placeholder')" v-model="addingPattern.pattern" @input="changePattern" size="36" ref="patternInput" @keyup.enter="confirm()" @keypress.enter.prevent="1" spellcheck="false"/>
				<p class="comment" v-if="patternIsInvalid"><span class="red" style="font-weight: normal"><span v-if="addingPattern.type == 'wildcard'">{{$t('url-patterns-box@通配符')}}</span><span v-if="addingPattern.type == 'regexp'">{{$t('url-patterns-box@正则表达式')}}</span>{{$t('url-patterns-box@不能包含问号')}}</span></p>
			</div>
			<div class="ui field" style="padding-left: 0"  v-show="addingPattern.type == 'wildcard' || addingPattern.type ==  'regexp'">
				<tip-icon :content="$t('url-patterns-box@通配符示例')" v-if="addingPattern.type == 'wildcard'"></tip-icon>
				<tip-icon :content="$t('url-patterns-box@正则示例')" v-if="addingPattern.type == 'regexp'"></tip-icon>
			</div>
			<div class="ui field">
				<button class="ui button tiny" :class="{disabled:this.patternIsInvalid}" type="button" @click.prevent="confirm">{{$t('url-patterns-box@确定')}}</button><a href="" :title="$t('url-patterns-box@取消')" @click.prevent="cancel"><i class="icon remove small"></i></a>
			</div>
		</div>
	</div>
	<div v-if=!isAdding style="margin-top: 0.5em">
		<button class="ui button tiny basic" type="button" @click.prevent="add">+</button>
	</div>
</div>`
})

Vue.component("mask-warning", {
	template: `<span class="red">{{$t('mask-warning@为了安全起见此项数据保存后将不允许在界面查看完整明文为避免忘记请自行记录原始数据')}}</span>`
})

/**
 * 一级菜单
 */
Vue.component("first-menu", {
	props: ['hideDivider'],
	data(){
		return {
			showLeft: false,
			showRight: false,
		};
	},
	methods: {
		handleScroll() {
			const menuContainer = this.$el.querySelector('.menu-container');
			const {scrollLeft, clientWidth, scrollWidth} = menuContainer;

			if(scrollLeft > 0){
				this.showLeft = true;
			}else{
				this.showLeft = false;
			}

			if(clientWidth + scrollLeft >= scrollWidth){
				this.showRight = false;
			}else{
				this.showRight = true;
			}
		},
		moveLeft(){
			const menuContainer = this.$el.querySelector('.menu-container');
			menuContainer.scrollLeft -= 100;
		},
		moveRight(){
			const menuContainer = this.$el.querySelector('.menu-container');
			menuContainer.scrollLeft += 100;
		},
	},
	mounted(){
		const menuContainer = this.$el.querySelector('.menu-container');
		menuContainer.addEventListener('scroll', this.handleScroll);

		this.$nextTick(() => {
			this.handleScroll();
		});
	},
	unmounted(){
		const el = this.$el;
		el.removeEventListener('scroll', this.handleScroll);
	},
	template: `
		<div class="b-first-menu" :class="{'hide-divider': hideDivider}">
			<div class="left-btn-container" v-if="showLeft">
				<i class="btn left-btn pi pi-chevron-left" @click="moveLeft"></i>
			</div>
			<div class="right-btn-container" v-if="showRight">
				<i class="btn right-btn pi pi-chevron-right" @click="moveRight"></i>
			</div>
			<div class="menu-container">
				<slot></slot>
			</div>
		</div>`
});

Vue.component("datetime-input", {
	props: ["v-name", "v-timestamp"],
	mounted: function () {
		let that = this
		teaweb.datepicker(this.$refs.dayInput, function (v) {
			that.day = v
			that.hour = "23"
			that.minute = "59"
			that.second = "59"
			that.change()
		})
	},
	data: function () {
		let timestamp = this.vTimestamp
		if (timestamp != null) {
			timestamp = parseInt(timestamp)
			if (isNaN(timestamp)) {
				timestamp = 0
			}
		} else {
			timestamp = 0
		}

		let day = ""
		let hour = ""
		let minute = ""
		let second = ""

		if (timestamp > 0) {
			let date = new Date()
			date.setTime(timestamp * 1000)

			let year = date.getFullYear().toString()
			let month = this.leadingZero((date.getMonth() + 1).toString(), 2)
			day = year + "-" + month + "-" + this.leadingZero(date.getDate().toString(), 2)

			hour = this.leadingZero(date.getHours().toString(), 2)
			minute = this.leadingZero(date.getMinutes().toString(), 2)
			second = this.leadingZero(date.getSeconds().toString(), 2)
		}

		return {
			timestamp: timestamp,
			day: day,
			hour: hour,
			minute: minute,
			second: second,

			hasDayError: false,
			hasHourError: false,
			hasMinuteError: false,
			hasSecondError: false
		}
	},
	methods: {
		change: function () {
			// day
			if (!/^\d{4}-\d{1,2}-\d{1,2}$/.test(this.day)) {
				this.hasDayError = true
				return
			}
			let pieces = this.day.split("-")
			let year = parseInt(pieces[0])

			let month = parseInt(pieces[1])
			if (month < 1 || month > 12) {
				this.hasDayError = true
				return
			}

			let day = parseInt(pieces[2])
			if (day < 1 || day > 32) {
				this.hasDayError = true
				return
			}

			this.hasDayError = false

			// hour
			if (!/^\d+$/.test(this.hour)) {
				this.hasHourError = true
				return
			}
			let hour = parseInt(this.hour)
			if (isNaN(hour)) {
				this.hasHourError = true
				return
			}
			if (hour < 0 || hour >= 24) {
				this.hasHourError = true
				return
			}
			this.hasHourError = false

			// minute
			if (!/^\d+$/.test(this.minute)) {
				this.hasMinuteError = true
				return
			}
			let minute = parseInt(this.minute)
			if (isNaN(minute)) {
				this.hasMinuteError = true
				return
			}
			if (minute < 0 || minute >= 60) {
				this.hasMinuteError = true
				return
			}
			this.hasMinuteError = false

			// second
			if (!/^\d+$/.test(this.second)) {
				this.hasSecondError = true
				return
			}
			let second = parseInt(this.second)
			if (isNaN(second)) {
				this.hasSecondError = true
				return
			}
			if (second < 0 || second >= 60) {
				this.hasSecondError = true
				return
			}
			this.hasSecondError = false

			let date = new Date(year, month - 1, day, hour, minute, second)
			this.timestamp = Math.floor(date.getTime() / 1000)
		},
		leadingZero: function (s, l) {
			s = s.toString()
			if (l <= s.length) {
				return s
			}
			for (let i = 0; i < l - s.length; i++) {
				s = "0" + s
			}
			return s
		},
		resultTimestamp: function () {
			return this.timestamp
		},
		nextYear: function () {
			let date = new Date()
			date.setFullYear(date.getFullYear()+1)
			this.day = date.getFullYear() + "-" + this.leadingZero(date.getMonth() + 1, 2) + "-" + this.leadingZero(date.getDate(), 2)
			this.hour = this.leadingZero(date.getHours(), 2)
			this.minute = this.leadingZero(date.getMinutes(), 2)
			this.second = this.leadingZero(date.getSeconds(), 2)
			this.change()
		},
		nextDays: function (days) {
			let date = new Date()
			date.setTime(date.getTime() + days * 86400 * 1000)
			this.day = date.getFullYear() + "-" + this.leadingZero(date.getMonth() + 1, 2) + "-" + this.leadingZero(date.getDate(), 2)
			this.hour = this.leadingZero(date.getHours(), 2)
			this.minute = this.leadingZero(date.getMinutes(), 2)
			this.second = this.leadingZero(date.getSeconds(), 2)
			this.change()
		},
		nextHours: function (hours) {
			let date = new Date()
			date.setTime(date.getTime() + hours * 3600 * 1000)
			this.day = date.getFullYear() + "-" + this.leadingZero(date.getMonth() + 1, 2) + "-" + this.leadingZero(date.getDate(), 2)
			this.hour = this.leadingZero(date.getHours(), 2)
			this.minute = this.leadingZero(date.getMinutes(), 2)
			this.second = this.leadingZero(date.getSeconds(), 2)
			this.change()
		}
	},
	template: `<div>
	<input type="hidden" :name="vName" :value="timestamp"/>
	<div class="ui fields inline" style="padding: 0; margin:0">
		<div class="ui field" :class="{error: hasDayError}">
			<input type="text" v-model="day" placeholder="YYYY-MM-DD" style="width:8.6em" maxlength="10" @input="change" ref="dayInput"/>
		</div>
		<div class="ui field" :class="{error: hasHourError}"><input type="text" v-model="hour" maxlength="2" style="width:4em" placeholder="时" @input="change"/></div>
		<div class="ui field">:</div>
		<div class="ui field" :class="{error: hasMinuteError}"><input type="text" v-model="minute" maxlength="2" style="width:4em" placeholder="分" @input="change"/></div>
		<div class="ui field">:</div>
		<div class="ui field" :class="{error: hasSecondError}"><input type="text" v-model="second" maxlength="2" style="width:4em" placeholder="秒" @input="change"/></div>
	</div>
	<b-notice>常用时间：<a href="" @click.prevent="nextHours(1)"> &nbsp;1小时&nbsp; </a> <span class="disabled">|</span> <a href="" @click.prevent="nextDays(1)"> &nbsp;1天&nbsp; </a> <span class="disabled">|</span> <a href="" @click.prevent="nextDays(3)"> &nbsp;3天&nbsp; </a> <span class="disabled">|</span> <a href="" @click.prevent="nextDays(7)"> &nbsp;1周&nbsp; </a> <span class="disabled">|</span> <a href="" @click.prevent="nextDays(30)"> &nbsp;30天&nbsp; </a> <span class="disabled">|</span> <a href="" @click.prevent="nextYear()"> &nbsp;1年&nbsp; </a> </b-notice>
</div>`
})

Vue.component("more-options-angle", {
	data: function () {
		return {
			isVisible: false
		}
	},
	methods: {
		show: function () {
			this.isVisible = !this.isVisible
			this.$emit("change", this.isVisible)
		}
	},
	template: `<a href="" @click.prevent="show()"><span v-if="!isVisible">{{$t('index_更多选项_0101')}}</span><span v-if="isVisible">{{$t('index_收起选项_0101')}}</span><i class="icon angle" :class="{down:!isVisible, up:isVisible}"></i></a>`
})

Vue.component("countries-selector", {
	props: ["v-countries"],
	data: function () {
		let countries = this.vCountries
		if (countries == null) {
			countries = []
		}
		let countryIds = countries.$map(function (k, v) {
			return v.id
		})
		return {
			countries: countries,
			countryIds: countryIds
		}
	},
	methods: {
		add: function () {
			let countryStringIds = this.countryIds.map(function (v) {
				return v.toString()
			})
			let that = this
			teaweb.popup("/ui/selectCountriesPopup?countryIds=" + countryStringIds.join(","), {
				title: '选择国家和地区',
				width: "48em",
				height: "23em",
				callback: function (resp) {
					that.countries = resp.data.countries
					that.change()
				}
			})
		},
		remove: function (index) {
			this.countries.$remove(index)
			this.change()
		},
		change: function () {
			this.countryIds = this.countries.$map(function (k, v) {
				return v.id
			})
		}
	},
	template: `<div>
	<input type="hidden" name="countryIdsJSON" :value="JSON.stringify(countryIds)"/>
	<div v-if="countries.length > 0" style="margin-bottom: 0.5em">
		<div v-for="(country, index) in countries" class="ui label tiny basic">{{country.name}} <a href="" title="删除" @click.prevent="remove(index)"><i class="icon remove"></i></a></div>
		<div class="ui divider"></div>
	</div>
	<div>
		<button class="ui button tiny" type="button" @click.prevent="add">+</button>
	</div>
</div>`
})


// 给Table增加排序功能
function sortTable(callback) {
	// 引入js
	let jsFile = document.createElement("script")
	jsFile.setAttribute("src", "/js/sortable.min.js")
	jsFile.addEventListener("load", function () {
		// 初始化
		let box = document.querySelector("#sortable-table")
		if (box == null) {
			return
		}
		Sortable.create(box, {
			draggable: "tbody",
			handle: ".icon.handle",
			onStart: function () {
			},
			onUpdate: function (event) {
				let rows = box.querySelectorAll("tbody")
				let rowIds = []
				rows.forEach(function (row) {
					rowIds.push(parseInt(row.getAttribute("v-id")))
				})
				callback(rowIds)
			}
		})
	})
	document.head.appendChild(jsFile)
}

function sortLoad(callback) {
	let jsFile = document.createElement("script")
	jsFile.setAttribute("src", "/js/sortable.min.js")
	jsFile.addEventListener("load", function () {
		if (typeof (callback) == "function") {
			callback()
		}
	})
	document.head.appendChild(jsFile)
}

Vue.component("chart-columns-grid", {
	props: [],
	mounted: function () {
		this.columns = this.calculateColumns()

		let that = this
		window.addEventListener("resize", function () {
			that.columns = that.calculateColumns()
		})
	},
	updated: function () {
		let totalElements = this.$el.getElementsByClassName("column").length
		if (totalElements == this.totalElements) {
			return
		}
		this.totalElements = totalElements
		this.calculateColumns()
	},
	data: function () {
		return {
			columns: "four",
			totalElements: 0
		}
	},
	methods: {
		calculateColumns: function () {
			let w = window.innerWidth
			let columns = Math.floor(w / 500)
			if (columns == 0) {
				columns = 1
			}

			let columnElements = this.$el.getElementsByClassName("column")
			if (columnElements.length == 0) {
				return "one"
			}
			let maxColumns = columnElements.length
			if (columns > maxColumns) {
				columns = maxColumns
			}

			// 添加右侧边框
			for (let index = 0; index < columnElements.length; index++) {
				let el = columnElements[index]
				el.className = el.className.replace("with-border", "")
				if (index % columns == columns - 1 || index == columnElements.length - 1 /** 最后一个 **/) {
					el.className += " with-border"
				}
			}

			switch (columns) {
				case 1:
					return "one"
				case 2:
					return "two"
				case 3:
					return "three"
				case 4:
					return "four"
				case 5:
					return "five"
				case 6:
					return "six"
				case 7:
					return "seven"
				case 8:
					return "eight"
				case 9:
					return "nine"
				case 10:
					return "ten"
				default:
					return "ten"
			}
		}
	},
	template: `<div :class="'ui ' + columns + ' columns grid chart-grid'">
	<slot></slot>
</div>`
})

/**
 * 二级菜单
 */
Vue.component("second-menu", {
	template: ' \
		<div class="b-second-menu"> \
			<div class="menu-container">\
				<slot></slot>\
			</div> \
		</div>'
});


Vue.component("download-link", {
	props: ["v-element", "v-file", "v-value"],
	created: function () {
		let that = this
		setTimeout(function () {
			that.url = that.composeURL()
		}, 1000)
	},
	data: function () {
		let filename = this.vFile
		if (filename == null || filename.length == 0) {
			filename = "unknown-file"
		}
		return {
			file: filename,
			url: this.composeURL()
		}
	},
	methods: {
		composeURL: function () {
			let text = ""
			if (this.vValue != null) {
				text = this.vValue
			} else {
				let e = document.getElementById(this.vElement)
				if (e == null) {
					// 不提示错误，因为此时可能页面未加载完整
					return
				}
				text = e.innerText
				if (text == null) {
					text = e.textContent
				}
			}
			return Tea.url("/ui/download", {
				file: this.file,
				text: text
			})
		}
	},
	template: `<a :href="url" target="_blank" style="font-weight: normal"><slot></slot></a>`,
})

// 启用状态标签
Vue.component("label-on", {
	props: ["v-is-on"],
	template: '<div><span v-if="vIsOn" class="green"><i class="icon check circle"></i> {{$t(\'finance_bills_index@已启用\')}}</span><span v-if="!vIsOn" class="red"><i class="icon times circle"></i> {{$t(\'finance_bills_index@已停用\')}}</span></div>'
})

// 文字代码标签
Vue.component("code-label", {
	methods: {
		click: function (args) {
			this.$emit("click", args)
		}
	},
	template: `<span class="ui label basic small" style="padding: 3px;margin-left:2px;margin-right:2px" @click.prevent="click"><slot></slot></span>`
})

Vue.component("code-label-plain", {
	template: `<span class="ui label basic tiny" style="padding: 3px;margin-left:2px;margin-right:2px"><slot></slot></span>`
})


// tiny标签
Vue.component("tiny-label", {
	template: `<span class="ui label tiny" style="margin-bottom: 0.5em"><slot></slot></span>`
})

Vue.component("tiny-basic-label", {
	template: `<span class="ui label tiny basic" style="margin-bottom: 0.5em"><slot></slot></span>`
})

// 更小的标签
Vue.component("micro-basic-label", {
	template: `<span class="ui label tiny basic" style="margin-bottom: 0.5em; font-size: 0.7em; padding: 4px"><slot></slot></span>`
})


// 灰色的Label
Vue.component("grey-label", {
	props: ["color"],
	data: function () {
		let color = "grey"
		if (this.color != null && this.color.length > 0) {
			color = "red"
		}
		return {
			labelColor: color
		}
	},
	template: `<span class="ui label basic tiny" :class="labelColor" style="margin-top: 0.4em; font-size: 0.7em; border: 1px solid #ddd!important; font-weight: normal;"><slot></slot></span>`
})

// 可选标签
Vue.component("optional-label", {
	template: `<em><span class="grey"> {{$t('optional-label@可选')}} </span></em>`
})

// Plus专属
Vue.component("plus-label", {
	template: `<span style="color: #B18701;">{{$t('plus-label@Plus专属功能')}}</span>`
})

// 提醒设置项为专业设置
Vue.component("pro-warning-label", {
	template: `<span><i class="p-message-icon pi pi-exclamation-triangle yellow"></i>{{$t('pro-warning-label@注意')}}：{{$t('pro-warning-label@通常不需要修改')}}；{{$t('pro-warning-label@如要修改')}}，{{$t('pro-warning-label@请在专家指导下进行')}}。</span>`
})


// 将变量转换为中文
Vue.component("request-variables-describer", {
	data: function () {
		return {
			vars: []
		}
	},
	methods: {
		update: function (variablesString) {
			this.vars = []
			let that = this
			variablesString.replace(/\${.+?}/g, function (v) {
				let def = that.findVar(v)
				if (def == null) {
					return v
				}
				that.vars.push(def)
			})
		},
		findVar: function (name) {
			let def = null
			window.REQUEST_VARIABLES.forEach(function (v) {
				if (v.code == name) {
					def = v
				}
			})
			return def
		}
	},
	template: `<span>
	<span v-for="(v, index) in vars"><code-label :title="v.description">{{v.code}}</code-label> - {{v.name}}<span v-if="index < vars.length-1">；</span></span>
</span>`
})

let radioId = 0
Vue.component("radio", {
	props: ["name", "value", "v-value", "id"],
	data: function () {
		radioId++
		let elementId = this.id
		if (elementId == null) {
			elementId = "radio" + radioId
		}
		
		return {
			"elementId": elementId,
			"currentValue": this.value
		}
	},
	watch: {
		"value": function (v) {
			this.currentValue = v
		}
	},
	methods: {
		change: function (v) {
			this.currentValue = v
			this.$emit("input", v)
			this.$emit("change", v)
		}
	},
	template: `<div class="ui radio-wrapper">
		<p-radiobutton :name="name" :value="vValue" :id="elementId" v-model="currentValue" @change="change(vValue)">
		</p-radiobutton>
		<label :for="elementId" class="radio-label" @click="change(vValue)"><slot></slot></label>
	</div>`
})

Vue.component('b-table', {
    props: {
        columns: {
            type: Array,
            required: true
        },
        dataSource: {
            type: Array,
            required: true
        },
        rowKey: {
            type: [String, Function],
            default: 'id'
        },
        bordered: {
            type: Boolean,
            default: false
        },
        size: {
            type: String,
            default: 'default'
        },
        pagination: {
            type: [Object, Boolean],
            default: false
        },
        loading: {
            type: Boolean,
            default: false
        },
        rowSelection: {
            type: Object,
            default: null
        },
        onSort: {
            type: Function,
            default: null
        },
        scroll: {
            type: Object,
            default: function() {
                return { x: true };
            }
        }
    },
    data() {
        return {
            selectedRowKeys: [],
            selectedRows: []
        }
    },
    methods: {
        handleRowSelection(selectedRowKeys, selectedRows, sorter) {
            this.selectedRowKeys = selectedRowKeys;
            this.selectedRows = selectedRows;
            if (this.rowSelection && this.rowSelection.onChange) {
                this.rowSelection.onChange(selectedRowKeys, selectedRows);
            }
            if (this.onSort) {
                this.onSort(sorter);
            }
        },
        customRender(column, record, index) {
            if (column.scopedSlots && column.scopedSlots.customRender) {
                const slotName = column.scopedSlots.customRender;
                
                if (this.$scopedSlots[slotName]) {
                    return this.$scopedSlots[slotName]({
                        text: record[column.dataIndex],
                        record: record,
                        index: index,
                        column: column
                    });
                }
            }
            
            if (record && column.dataIndex !== undefined) {
                return record[column.dataIndex];
            }
            return '';
        },
        getProcessedColumns() {
            if (!this.columns) return [];
            
            return this.columns.map(column => {
                const newColumn = {...column};
                
                if (!newColumn.width) {
                    newColumn.width = '150px';
                }
                
                if (column.scopedSlots && column.scopedSlots.customRender) {
                    newColumn.customRender = (text, record, index) => {
                        return this.customRender(column, record, index);
                    };
                }
                
                if (column.slots && column.slots.title) {
                    const titleSlotName = column.slots.title;
                    if (this.$scopedSlots[titleSlotName]) {
                        newColumn.title = () => {
                            return this.$scopedSlots[titleSlotName]({
                                column: column
                            });
                        };
                    }
                }
                
                return newColumn;
            });
        }
    },
    template: `
        <div class="b-table-container" style="overflow-x: auto;">
            <a-table
                :columns="getProcessedColumns()"
                :data-source="dataSource"
                :row-key="rowKey"
                :bordered="bordered"
                :size="size"
                :pagination="pagination"
                :loading="loading"
                :row-selection="rowSelection"
                :scroll="scroll? scroll : { x: 1200 }"
                @change="handleRowSelection"
            >
                <template
                    v-for="(_, name) in $slots"
                    :slot="name"
                    slot-scope="slotData"
                >
                    <slot :name="name" v-bind="slotData"></slot>
                </template>
            </a-table>
        </div>
    `
}); 

Vue.component("combo-box", {
	// data-url 和 data-key 成对出现
	props: [
		"name", "title", "placeholder", "size", "v-items", "v-value",
		"data-url", // 数据源URL
		"data-key", // 数据源中数据的键名
		"data-search", // 是否启用动态搜索，如果值为on或true，则表示启用
		"width"
	],
	mounted: function () {
		if (this.dataURL.length > 0) {
			this.search("")
		}

		// 设定菜单宽度
		let searchBox = this.$refs.searchBox
		if (searchBox != null) {
			let inputWidth = searchBox.offsetWidth
			if (inputWidth != null && inputWidth > 0) {
				this.$refs.menu.style.width = inputWidth + "px"
			} else if (this.styleWidth.length > 0) {
				this.$refs.menu.style.width = this.styleWidth
			}
		}
	},
	data: function () {
		let items = this.vItems
		if (items == null || !(items instanceof Array)) {
			items = []
		}
		items = this.formatItems(items)

		// 当前选中项
		let selectedItem = null
		if (this.vValue != null) {
			let that = this
			items.forEach(function (v) {
				if (v.value == that.vValue) {
					selectedItem = v
				}
			})
		}

		let width = this.width
		if (width == null || width.length == 0) {
			width = "11em"
		} else {
			if (/\d+$/.test(width)) {
				width += "em"
			}
		}

		// data url
		let dataURL = ""
		if (typeof this.dataUrl == "string" && this.dataUrl.length > 0) {
			dataURL = this.dataUrl
		}

		return {
			allItems: items, // 原始的所有的items
			items: items.$copy(), // 候选的items
			selectedItem: selectedItem, // 选中的item
			keyword: "",
			visible: false,
			hideTimer: null,
			hoverIndex: 0,
			styleWidth: width,

			isInitial: true,
			dataURL: dataURL,
			urlRequestId: 0 // 记录URL请求ID，防止并行冲突
		}
	},
	methods: {
		search: function (keyword) {
			// 从URL中获取选项数据
			let dataUrl = this.dataURL
			let dataKey = this.dataKey
			let that = this

			let requestId = Math.random()
			this.urlRequestId = requestId

			Tea.action(dataUrl)
				.params({
					keyword: (keyword == null) ? "" : keyword
				})
				.post()
				.success(function (resp) {
					if (requestId != that.urlRequestId) {
						return
					}

					if (resp.data != null) {
						if (typeof (resp.data[dataKey]) == "object") {
							let items = that.formatItems(resp.data[dataKey])
							that.allItems = items
							that.items = items.$copy()

							if (that.isInitial) {
								that.isInitial = false
								if (that.vValue != null) {
									items.forEach(function (v) {
										if (v.value == that.vValue) {
											that.selectedItem = v
										}
									})
								}
							}
						}
					}
				})
		},
		formatItems: function (items) {
			items.forEach(function (v) {
				if (v.value == null) {
					v.value = v.id
				}
			})
			return items
		},
		reset: function () {
			this.selectedItem = null
			this.change()
			this.hoverIndex = 0

			let that = this
			setTimeout(function () {
				if (that.$refs.searchBox) {
					that.$refs.searchBox.focus()
				}
			})
		},
		clear: function () {
			this.selectedItem = null
			this.change()
			this.hoverIndex = 0
		},
		changeKeyword: function () {
			let shouldSearch = this.dataURL.length > 0 && (this.dataSearch == "on" || this.dataSearch == "true")

			this.hoverIndex = 0
			let keyword = this.keyword
			if (keyword.length == 0) {
				if (shouldSearch) {
					this.search(keyword)
				} else {
					this.items = this.allItems.$copy()
				}
				return
			}


			if (shouldSearch) {
				this.search(keyword)
			} else {
				this.items = this.allItems.$copy().filter(function (v) {
					if (v.fullname != null && v.fullname.length > 0 && teaweb.match(v.fullname, keyword)) {
						return true
					}
					return teaweb.match(v.name, keyword)
				})
			}
		},
		selectItem: function (item) {
			this.selectedItem = item
			this.change()
			this.hoverIndex = 0
			this.keyword = ""
			this.changeKeyword()
		},
		confirm: function () {
			if (this.items.length > this.hoverIndex) {
				this.selectItem(this.items[this.hoverIndex])
			}
		},
		show: function () {
			this.visible = true

			// 不要重置hoverIndex，以便焦点可以在输入框和可选项之间切换
		},
		hide: function () {
			let that = this
			this.hideTimer = setTimeout(function () {
				that.visible = false
			}, 500)
		},
		downItem: function () {
			this.hoverIndex++
			if (this.hoverIndex > this.items.length - 1) {
				this.hoverIndex = 0
			}
			this.focusItem()
		},
		upItem: function () {
			this.hoverIndex--
			if (this.hoverIndex < 0) {
				this.hoverIndex = 0
			}
			this.focusItem()
		},
		focusItem: function () {
			if (this.hoverIndex < this.items.length) {
				this.$refs.itemRef[this.hoverIndex].focus()
				let that = this
				setTimeout(function () {
					that.$refs.searchBox.focus()
					if (that.hideTimer != null) {
						clearTimeout(that.hideTimer)
						that.hideTimer = null
					}
				})
			}
		},
		change: function () {
			this.$emit("change", this.selectedItem)

			let that = this
			setTimeout(function () {
				if (that.$refs.selectedLabel != null) {
					that.$refs.selectedLabel.focus()
				}
			})
		},
		submitForm: function (event) {
			if (event.target.tagName != "A") {
				return
			}
			let parentBox = this.$refs.selectedLabel.parentNode
			while (true) {
				parentBox = parentBox.parentNode
				if (parentBox == null || parentBox.tagName == "BODY") {
					return
				}
				if (parentBox.tagName == "FORM") {
					parentBox.submit()
					break
				}
			}
		},

		setDataURL: function (dataURL) {
			this.dataURL = dataURL
		},
		reloadData: function () {
			this.search("")
		}
	},
	template: `<div style="display: inline; z-index: 10; background: white" class="combo-box">
	<!-- 搜索框 -->
	<div v-if="selectedItem == null">
		<input type="text" v-model="keyword" :placeholder="placeholder" :size="size" :style="{'width': styleWidth}"  @input="changeKeyword" @focus="show" @blur="hide" @keyup.enter="confirm()" @keypress.enter.prevent="1" ref="searchBox" @keydown.down.prevent="downItem" @keydown.up.prevent="upItem"/>
	</div>
	
	<!-- 当前选中 -->
	<div v-if="selectedItem != null">
		<input type="hidden" :name="name" :value="selectedItem.value"/>
		<span class="ui label basic" style="line-height: 1.4; font-weight: normal; font-size: 1em" ref="selectedLabel"><span><span v-if="title != null && title.length > 0">{{title}}：</span>{{selectedItem.name}}</span>
			<a href="" title="清除" @click.prevent="reset"><i class="icon remove small"></i></a>
		</span>
	</div>
	
	<!-- 菜单 -->
	<transition>
		<div v-if="selectedItem == null && items.length > 0 && visible">
			<div class="ui menu vertical small narrow-scrollbar" ref="menu">
				<a href="" v-for="(item, index) in items" ref="itemRef" class="item" :class="{active: index == hoverIndex, blue: index == hoverIndex}" @click.prevent="selectItem(item)" style="line-height: 1.4">
					<span v-if="item.fullname != null && item.fullname.length > 0">{{item.fullname}}</span>
						<span v-else>{{item.name}}</span>
					</a>
				</div>
			</div>
	</transition>
</div>`
})

/**
 * 菜单项
 */
Vue.component("menu-item", {
	props: ["href", "active", "code"],
	data: function () {
		let active = this.active
		if (typeof (active) == "undefined") {
			var itemCode = ""
			if (typeof (window.TEA.ACTION.data.firstMenuItem) != "undefined") {
				itemCode = window.TEA.ACTION.data.firstMenuItem
			}
			if (itemCode != null && itemCode.length > 0 && this.code != null && this.code.length > 0) {
				if (itemCode.indexOf(",") > 0) {
					active = itemCode.split(",").$contains(this.code)
				} else {
					active = (itemCode == this.code)
				}
			}
		}

		let href = (this.href == null) ? "" : this.href
		if (typeof (href) == "string" && href.length > 0 && href.startsWith(".")) {
			let qIndex = href.indexOf("?")
			if (qIndex >= 0) {
				href = Tea.url(href.substring(0, qIndex)) + href.substring(qIndex)
			} else {
				href = Tea.url(href)
			}
		}

		return {
			vHref: href,
			vActive: active
		}
	},
	methods: {
		click: function (e) {
			this.$emit("click", e)
		}
	},
	template: '\
		<a :href="vHref" class="item" :class="{active:vActive}" @click="click"><slot></slot></a> \
		'
});

// 排序使用的箭头
Vue.component("sort-arrow", {
	props: ["name"],
	data: function () {
		let url = window.location.toString()
		let order = ""
		let iconTitle = ""
		let newArgs = []
		if (window.location.search != null && window.location.search.length > 0) {
			let queryString = window.location.search.substring(1)
			let pieces = queryString.split("&")
			let that = this
			pieces.forEach(function (v) {
				let eqIndex = v.indexOf("=")
				if (eqIndex > 0) {
					let argName = v.substring(0, eqIndex)
					let argValue = v.substring(eqIndex + 1)
					if (argName == that.name) {
						order = argValue
					} else if (argName != "page" && argValue != "asc" && argValue != "desc") {
						newArgs.push(v)
					}
				} else {
					newArgs.push(v)
				}
			})
		}
		if (order == "asc") {
			newArgs.push(this.name + "=desc")
			iconTitle = "当前正序排列"
		} else if (order == "desc") {
			newArgs.push(this.name + "=asc")
			iconTitle = "当前倒序排列"
		} else {
			newArgs.push(this.name + "=desc")
			iconTitle = "当前正序排列"
		}

		let qIndex = url.indexOf("?")
		if (qIndex > 0) {
			url = url.substring(0, qIndex) + "?" + newArgs.join("&")
		} else {
			url = url + "?" + newArgs.join("&")
		}

		return {
			order: order,
			url: url,
			iconTitle: iconTitle
		}
	},
	template: `<a :href="url" :title="iconTitle">&nbsp; <i class="ui icon long arrow small" :class="{down: order == 'asc', up: order == 'desc', 'down grey': order == '' || order == null}"></i></a>`
})

Vue.component("base-with-menu", {
    props: {
        leftMenuItems: {
            type: Array,
            required: true
        },
        leftMenuItemIsDisabled: {
            type: Boolean,
            default: false
        }
    },
    data() {
        return {
            showLeft: false,
            showRight: false,
            isDragging: false,
            dragStartX: 0,
            dragScrollX: 0
        }
    },
    methods: {
        handleScroll() {
            const menuContainer = this.$el.querySelector('.edge-menu-container');
            const { scrollLeft, clientWidth, scrollWidth } = menuContainer;

            this.showLeft = scrollLeft > 0;
            this.showRight = clientWidth + scrollLeft < scrollWidth;
        },
        moveLeft() {
            const menuContainer = this.$el.querySelector('.edge-menu-container');
            menuContainer.scrollLeft -= menuContainer.clientWidth * 0.5;
        },
        moveRight() {
            const menuContainer = this.$el.querySelector('.edge-menu-container');
            menuContainer.scrollLeft += menuContainer.clientWidth * 0.5;
        },
        handleMouseDown(e) {
            this.isDragging = true;
            const container = this.$el.querySelector('.edge-menu-container');
            this.dragStartX = e.pageX - container.offsetLeft;
            this.dragScrollX = container.scrollLeft;
            container.style.cursor = 'grabbing';
        },
        handleMouseMove(e) {
            if (!this.isDragging) return;
            e.preventDefault();
            const container = this.$el.querySelector('.edge-menu-container');
            const x = e.pageX - container.offsetLeft;
            container.scrollLeft = this.dragScrollX - (x - this.dragStartX);
            this.handleScroll();
        },
        handleMouseUp() {
            this.isDragging = false;
            const container = this.$el.querySelector('.edge-menu-container');
            container.style.cursor = 'grab';
            this.handleScroll();
        },
        scrollToActiveItem() {
            const container = this.$el.querySelector('.edge-menu-container');
            if (!container) return;

            const activeItem = this.leftMenuItems.findIndex(item => item.isActive);
            if (activeItem === -1) return;

            const menuItems = container.querySelectorAll('.edge-menu-item');
            if (!menuItems[activeItem]) return;

            const itemElement = menuItems[activeItem];
            const itemLeft = itemElement.offsetLeft;
            const itemWidth = itemElement.offsetWidth;
            const containerWidth = container.offsetWidth;

            container.scrollTo({
                left: Math.max(0, itemLeft - (containerWidth - itemWidth) / 2),
                behavior: 'instant'
            });
        }
    },
    mounted() {
        const menuContainer = this.$el.querySelector('.edge-menu-container');
        menuContainer.addEventListener('scroll', this.handleScroll);
        menuContainer.addEventListener('mousedown', this.handleMouseDown);
        menuContainer.addEventListener('mousemove', this.handleMouseMove);
        menuContainer.addEventListener('mouseup', this.handleMouseUp);
        menuContainer.addEventListener('mouseleave', this.handleMouseUp);

        this.$nextTick(() => {
            this.handleScroll();
            this.scrollToActiveItem();
        });
    },
    unmounted() {
        const menuContainer = this.$el.querySelector('.edge-menu-container');
        menuContainer.removeEventListener('scroll', this.handleScroll);
        menuContainer.removeEventListener('mousedown', this.handleMouseDown);
        menuContainer.removeEventListener('mousemove', this.handleMouseMove);
        menuContainer.removeEventListener('mouseup', this.handleMouseUp);
        menuContainer.removeEventListener('mouseleave', this.handleMouseUp);
    },
    watch: {
        leftMenuItems: {
            handler() {
                this.$nextTick(() => {
                    this.scrollToActiveItem();
                });
            },
            deep: true
        }
    },
    template: `
        <div class="edge-menu-wrapper" :class="{ 'is-disabled': leftMenuItemIsDisabled, 'no-left-padding': !showLeft, 'no-right-padding': !showRight }">
            <div class="edge-menu-arrow left" v-if="showLeft">
                <i class="btn left-btn pi pi-chevron-left" @click="moveLeft"></i>
            </div>
            <div class="edge-menu-arrow right" v-if="showRight">
                <i class="btn right-btn pi pi-chevron-right" @click="moveRight"></i>
            </div>
            <div class="edge-menu-container">
                <div class="edge-menu">
                    <a v-for="item in leftMenuItems"
                       :key="item.url"
                       :href="item.url"
                       class="edge-menu-item"
                       :class="{
                           'is-active': item.isActive,
                           'is-separator': item.name === '-',
                           'is-on': item.isOn,
                           'is-off': item.isOff || item.isImportant,
                           'color-active': item.isActive
                       }">
                        <span v-if="item.name !== '-'" class="edge-menu-content">
                            <i class="icon circle tiny color-active" v-if="item.isActive"></i>
                            <span class="edge-menu-name">{{item.name}}</span>
                            <span v-if="item.isOff" class="edge-menu-status is-off">关</span>
                            <span v-if="item.isImportant" class="edge-menu-status is-on">开</span>
                            <span v-if="item.subName" class="edge-menu-subname">（{{item.subName}}）</span>
                        </span>
                    </a>
                </div>
            </div>
        </div>
    `
});


Vue.component("search-box", {
	props: ["placeholder", "width"],
	data: function () {
		let width = this.width
		if (width == null) {
			width = "10em"
		}
		return {
			realWidth: width,
			realValue: ""
		}
	},
	methods: {
		onInput: function () {
			this.$emit("input", { value: this.realValue })
			this.$emit("change", { value: this.realValue })
		},
		clearValue: function () {
			this.realValue = ""
			this.focus()
			this.onInput()
		},
		focus: function () {
			this.$refs.valueRef.focus()
		}
	},
	template: `<div>
	<div class="ui input small" :class="{'right labeled': realValue.length > 0}">
		<input type="text" :placeholder="placeholder" :style="{width: realWidth}" @input="onInput" v-model="realValue" ref="valueRef"/>
		<a href="" class="ui label blue" v-if="realValue.length > 0" @click.prevent="clearValue" style="padding-right: 0"><i class="icon remove"></i></a>
	</div>
</div>`
})

Vue.component("js-page", {
	props: ["v-max"],
	data: function () {
		let max = this.vMax
		if (max == null) {
			max = 0
		}
		return {
			max: max,
			page: 1
		}
	},
	methods: {
		updateMax: function (max) {
			this.max = max
		},
		selectPage: function (page) {
			this.page = page
			this.$emit("change", page)
		}
	},
	template: `<div>
	<div class="page" v-if="max > 1">
		<a href="" v-for="i in max" :class="{active: i == page}" @click.prevent="selectPage(i)">{{i}}</a>
	</div>
</div>`
})

/**
 * 更多选项
 */
Vue.component("more-options-indicator", {
	props:[],
	data: function () {
		return {
			visible: false
		}
	},
	methods: {
		changeVisible: function () {
			this.visible = !this.visible
			if (Tea.Vue != null) {
				Tea.Vue.moreOptionsVisible = this.visible
			}
			this.$emit("change", this.visible)
			this.$emit("input", this.visible)
		}
	},
	template: '<a href="" style="font-weight: normal" @click.prevent="changeVisible()"><slot><span v-if="!visible">{{$t(\'more-options-indicator@更多选项\')}}</span><span v-if="visible">{{$t(\'more-options-indicator@收起选项\')}}</span></slot> <i class="icon angle" :class="{down:!visible, up:visible}"></i> </a>'
});

// 节点角色名称
Vue.component("node-role-name", {
	props: ["v-role"],
	data: function () {
		let roleName = ""
		switch (this.vRole) {
			case "node":
				roleName = "边缘节点"
				break
			case "monitor":
				roleName = "监控节点"
				break
			case "api":
				roleName = "API节点"
				break
			case "user":
				roleName = "用户平台"
				break
			case "admin":
				roleName = "管理平台"
				break
			case "database":
				roleName = "数据库节点"
				break
			case "dns":
				roleName = "DNS节点"
				break
			case "report":
				roleName = "区域监控终端"
				break
		}
		return {
			roleName: roleName
		}
	},
	template: `<span>{{roleName}}</span>`
})

Vue.component("time-duration-box", {
	props: ["v-name", "v-value", "v-count", "v-unit", "placeholder", "v-min-unit", "maxlength"],
	mounted: function () {
		this.change()
	},
	data: function () {
		let v = this.vValue
		if (v == null) {
			v = {
				count: this.vCount,
				unit: this.vUnit
			}
		}
		if (typeof (v["count"]) != "number") {
			v["count"] = -1
		}

		let minUnit = this.vMinUnit
		let units = [
			{
				code: "ms",
				name: this.$t("毫秒")
			},
			{
				code: "second",
				name: this.$t("秒")
			},
			{
				code: "minute",
				name: this.$t("分钟")
			},
			{
				code: "hour",
				name: this.$t("小时")
			},
			{
				code: "day",
				name: this.$t("天")
			}
		]
		let minUnitIndex = -1
		if (minUnit != null && typeof minUnit == "string" && minUnit.length > 0) {
			for (let i = 0; i < units.length; i++) {
				if (units[i].code == minUnit) {
					minUnitIndex = i
					break
				}
			}
		}
		if (minUnitIndex > -1) {
			units = units.slice(minUnitIndex)
		}

		let maxLength = parseInt(this.maxlength)
		if (typeof maxLength != "number") {
			maxLength = 10
		}

		return {
			duration: v,
			countString: (v.count >= 0) ? v.count.toString() : "",
			units: units,
			realMaxLength: maxLength
		}
	},
	watch: {
		"countString": function (newValue) {
			let value = newValue.trim()
			if (value.length == 0) {
				this.duration.count = -1
				return
			}
			let count = parseInt(value)
			if (!isNaN(count)) {
				this.duration.count = count
			}
			this.change()
		}
	},
	methods: {
		change: function () {
			this.$emit("change", this.duration)
		}
	},
	template: `<div class="ui fields inline" style="padding-bottom: 0; margin-bottom: 0">
	<input type="hidden" :name="vName" :value="JSON.stringify(duration)"/>
	<div class="ui field">
		<input type="text" v-model="countString" :maxlength="realMaxLength" :size="realMaxLength" :placeholder="placeholder" @keypress.enter.prevent="1"/>
	</div>
	<div class="ui field">
		<b-select v-model="duration.unit" @change="change" :options="units.map(unit => ({label: unit.name, value: unit.code}))"></b-select>
	</div>
</div>`
})

Vue.component("time-duration-text", {
	props: ["v-value"],
	methods: {
		unitName: function (unit) {
			switch (unit) {
				case "ms":
					return this.$t("毫秒")
				case "second":
					return this.$t("秒")
				case "minute":
					return this.$t("分钟")
				case "hour":
					return this.$t("小时")
				case "day":
					return this.$t("天")
			}
		}
	},
	template: `<span>
	{{vValue.count}} {{unitName(vValue.unit)}}
</span>`
})

// 警告消息
Vue.component("warning-message", {
	template: `<div class="ui icon message warning"><i class="icon warning circle"></i><div class="content"><slot></slot></div></div>`
})

let sourceCodeBoxIndex = 0

Vue.component("source-code-box", {
	props: ["name", "type", "id", "read-only", "width", "height", "focus"],
	mounted: function () {
		let readOnly = this.readOnly
		if (typeof readOnly != "boolean") {
			readOnly = true
		}
		let box = document.getElementById("source-code-box-" + this.index)
		let valueBox = document.getElementById(this.valueBoxId)
		let value = ""
		if (valueBox.textContent != null) {
			value = valueBox.textContent
		} else if (valueBox.innerText != null) {
			value = valueBox.innerText
		}

		this.createEditor(box, value, readOnly)
	},
	data: function () {
		let index = sourceCodeBoxIndex++

		let valueBoxId = 'source-code-box-value-' + sourceCodeBoxIndex
		if (this.id != null) {
			valueBoxId = this.id
		}

		return {
			index: index,
			valueBoxId: valueBoxId
		}
	},
	methods: {
		createEditor: function (box, value, readOnly) {
			let boxEditor = CodeMirror.fromTextArea(box, {
				theme: "idea",
				lineNumbers: true,
				value: "",
				readOnly: readOnly,
				showCursorWhenSelecting: true,
				height: "auto",
				//scrollbarStyle: null,
				viewportMargin: Infinity,
				lineWrapping: true,
				highlightFormatting: false,
				indentUnit: 4,
				indentWithTabs: true,
			})
			let that = this
			boxEditor.on("change", function () {
				that.change(boxEditor.getValue())
			})
			boxEditor.setValue(value)

			if (this.focus) {
				boxEditor.focus()
			}

			let width = this.width
			let height = this.height
			if (width != null && height != null) {
				width = parseInt(width)
				height = parseInt(height)
				if (!isNaN(width) && !isNaN(height)) {
					if (width <= 0) {
						width = box.parentNode.offsetWidth
					}
					boxEditor.setSize(width, height)
				}
			} else if (height != null) {
				height = parseInt(height)
				if (!isNaN(height)) {
					boxEditor.setSize("100%", height)
				}
			}

			let info = CodeMirror.findModeByMIME(this.type)
			if (info != null) {
				boxEditor.setOption("mode", info.mode)
				CodeMirror.modeURL = "/codemirror/mode/%N/%N.js"
				CodeMirror.autoLoadMode(boxEditor, info.mode)
			}
		},
		change: function (code) {
			this.$emit("change", code)
		}
	},
	template: `<div class="source-code-box">
	<div style="display: none" :id="valueBoxId"><slot></slot></div>
	<textarea :id="'source-code-box-' + index" :name="name"></textarea>
</div>`
})


Vue.component("loading-message", {
	template: `<div class="ui message loading">
        <div class="ui active inline loader small"></div>  &nbsp; <slot></slot>
    </div>`
})

Vue.component('b-table-card', {
    props: {
        columns: {
            type: Array,
            required: true
        },
        dataSource: {
            type: Array,
            required: true
        },
        rowKey: {
            type: String,
            default: 'id'
        },
        bordered: {
            type: Boolean,
            default: false
        },
        size: {
            type: String,
            default: 'default'
        },
        pagination: {
            type: [Object, Boolean],
            default: false
        },
        loading: {
            type: Boolean,
            default: false
        },
        rowSelection: {
            type: Object,
            default: null
        },
        scroll: {
            type: Object,
            default: function() {
                return { x: true };
            }
        }
    },
    data() {
        return {
            selectedRowKeys: [],
            selectedRows: []
        }
    },
    mounted() {
        if (this.rowSelection && this.rowSelection.selectedRowKeys) {
            this.selectedRowKeys = [...this.rowSelection.selectedRowKeys];
        }
    },
    methods: {
        // 处理行选择变化
        handleSelectionChange(rowKey, isSelected) {
            // 更新选中状态
            if (isSelected) {
                if (this.selectedRowKeys.indexOf(rowKey) === -1) {
                    this.selectedRowKeys.push(rowKey);
                }
            } else {
                const index = this.selectedRowKeys.indexOf(rowKey);
                if (index !== -1) {
                    this.selectedRowKeys.splice(index, 1);
                }
            }

            // 触发父组件的onChange事件
            if (this.rowSelection && this.rowSelection.onChange) {
                // 仅传递行的key，避免循环引用
                this.rowSelection.onChange([...this.selectedRowKeys]);
            }
        },
        
        // 判断行是否被选中
        isRowSelected(record) {
            const key = record[this.rowKey];
            return this.selectedRowKeys.indexOf(key) !== -1;
        },
        
        // 切换选中状态
        toggleRowSelection(record) {
            const key = record[this.rowKey];
            const isSelected = !this.isRowSelected(record);
            this.handleSelectionChange(key, isSelected);
        }
    },
    watch: {
        'rowSelection.selectedRowKeys': function(newVal) {
            if (newVal) {
                this.selectedRowKeys = [...newVal];
            }
        }
    },
    template: `
        <div class="b-table-card-container">
            <!-- 加载状态 -->
            <div class="b-table-card-loading" v-if="loading">
                <div class="loading-spinner"></div>
            </div>
            
            <!-- 卡片网格 -->
            <div class="b-table-card-grid">
                <div v-for="(record, rowIndex) in dataSource" 
                    :key="record[rowKey]" 
                    class="b-table-card" 
                    :class="{'b-table-card-selected': isRowSelected(record)}">
                    
                    <!-- 选择框 -->
                    <div class="b-table-card-header" v-if="rowSelection">
                        <label class="b-table-card-checkbox">
                            <input type="checkbox" 
                                :checked="isRowSelected(record)" 
                                @change="toggleRowSelection(record)" />
                            <span class="checkmark"></span>
                        </label>
                    </div>
                    
                    <!-- 卡片内容 -->
                    <div class="b-table-card-body">
                        <div v-for="(column, colIndex) in columns" 
                            :key="column.key || colIndex" 
                            class="b-table-card-field" 
                            :class="[column.className, {'b-table-card-field-fixed': column.fixed === 'right'}]">
                            
                            <!-- 列标题 -->
                            <div class="b-table-card-label">{{ column.title }}</div>
                            
                            <!-- 列内容 -->
                            <div class="b-table-card-value">
                                <!-- 使用作用域插槽 -->
                                <slot v-if="column.scopedSlots && column.scopedSlots.customRender"
                                    :name="column.scopedSlots.customRender"
                                    :text="record[column.dataIndex]"
                                    :record="record"
                                    :index="rowIndex">
                                </slot>
                                
                                <!-- 默认显示数据 -->
                                <template v-else-if="column.dataIndex">
                                    {{ record[column.dataIndex] }}
                                </template>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <!-- 分页 -->
            <div class="b-table-card-pagination" v-if="pagination">
                <a-pagination
                    :current="pagination.current || 1"
                    :pageSize="pagination.pageSize || 10"
                    :total="pagination.total || 0"
                    :showSizeChanger="pagination.showSizeChanger || false"
                    :pageSizeOptions="pagination.pageSizeOptions || ['10', '20', '50', '100']"
                    @change="(page, pageSize) => pagination.onChange && pagination.onChange(page, pageSize)"
                    @showSizeChange="(current, size) => pagination.onShowSizeChange && pagination.onShowSizeChange(current, size)"
                />
            </div>
        </div>
    `
});


Vue.component("digit-input", {
	props: ["value", "maxlength", "size", "min", "max", "required", "placeholder"],
	mounted: function () {
		let that = this
		setTimeout(function () {
			that.check()
		})
	},
	data: function () {
		let realMaxLength = this.maxlength
		if (realMaxLength == null) {
			realMaxLength = 20
		}

		let realSize = this.size
		if (realSize == null) {
			realSize = 6
		}

		return {
			realValue: this.value,
			realMaxLength: realMaxLength,
			realSize: realSize,
			isValid: true
		}
	},
	watch: {
		realValue: function (v) {
			this.notifyChange()
		}
	},
	methods: {
		notifyChange: function () {
			let v = parseInt(this.realValue.toString(), 10)
			if (isNaN(v)) {
				v = 0
			}
			this.check()
			this.$emit("input", v)
		},
		check: function () {
			if (this.realValue == null) {
				return
			}
			let s = this.realValue.toString()
			if (!/^\d+$/.test(s)) {
				this.isValid = false
				return
			}
			let v = parseInt(s, 10)
			if (isNaN(v)) {
				this.isValid = false
			} else {
				if (this.required) {
					this.isValid = (this.min == null || this.min <= v) && (this.max == null || this.max >= v)
				} else {
					this.isValid = (v == 0 || (this.min == null || this.min <= v) && (this.max == null || this.max >= v))
				}
			}
		}
	},
	template: `<input type="text" v-model="realValue" :maxlength="realMaxLength" :size="realSize" :class="{error: !this.isValid}" :placeholder="placeholder" autocomplete="off"/>`
})

Vue.component("more-options-tbody", {
	data: function () {
		return {
			isVisible: false
		}
	},
	methods: {
		show: function () {
			this.isVisible = !this.isVisible
			this.$emit("change", this.isVisible)
		}
	},
	template: `<tbody>
	<tr>
		<td colspan="2"><a href="" @click.prevent="show()"><span v-if="!isVisible">更多选项</span><span v-if="isVisible">收起选项</span><i class="icon angle" :class="{down:!isVisible, up:isVisible}"></i></a></td>
	</tr>
</tbody>`
})

Vue.component("size-capacity-box", {
	props: ["v-name", "v-value", "v-count", "v-unit", "size", "maxlength", "v-supported-units"],
	data: function () {
		let v = this.vValue
		if (v == null) {
			v = {
				count: this.vCount,
				unit: this.vUnit
			}
		}
		if (typeof (v["count"]) != "number") {
			v["count"] = -1
		}

		let vSize = this.size
		if (vSize == null) {
			vSize = 6
		}

		let vMaxlength = this.maxlength
		if (vMaxlength == null) {
			vMaxlength = 10
		}

		let supportedUnits = this.vSupportedUnits
		if (supportedUnits == null) {
			supportedUnits = []
		}

		return {
			capacity: v,
			countString: (v.count >= 0) ? v.count.toString() : "",
			vSize: vSize,
			vMaxlength: vMaxlength,
			supportedUnits: supportedUnits
		}
	},
	watch: {
		"countString": function (newValue) {
			let value = newValue.trim()
			if (value.length == 0) {
				this.capacity.count = -1
				// this.change()
				return
			}
			let count = parseInt(value)
			if (!isNaN(count)) {
				this.capacity.count = count
			}
			// this.change()
		}
	},
	methods: {
		change: function () {
			this.$emit("change", this.capacity)
		}
	},
	template: `<div class="ui fields inline">
	<input type="hidden" :name="vName" :value="JSON.stringify(capacity)"/>
	<div class="ui field">
		<input type="text" v-model="countString" :maxlength="vMaxlength" :size="vSize" @blur="change"/>
	</div>
	<div class="ui field">
		<b-select
			v-model="capacity.unit"
			@change="change"
			:options="[
				(supportedUnits.length == 0 || supportedUnits.$contains('byte')) ? {label: '字节', value: 'byte'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('kb')) ? {label: 'KiB', value: 'kb'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('mb')) ? {label: 'MiB', value: 'mb'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('gb')) ? {label: 'GiB', value: 'gb'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('tb')) ? {label: 'TiB', value: 'tb'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('pb')) ? {label: 'PiB', value: 'pb'} : null,
				(supportedUnits.length == 0 || supportedUnits.$contains('eb')) ? {label: 'EiB', value: 'eb'} : null,
			].filter(option => option)"
		></b-select>
	</div>
</div>`
})

Vue.component("provinces-selector", {
	props: ["v-provinces"],
	data: function () {
		let provinces = this.vProvinces
		if (provinces == null) {
			provinces = []
		}
		let provinceIds = provinces.$map(function (k, v) {
			return v.id
		})
		return {
			provinces: provinces,
			provinceIds: provinceIds
		}
	},
	methods: {
		add: function () {
			let provinceStringIds = this.provinceIds.map(function (v) {
				return v.toString()
			})
			let that = this
			teaweb.popup("/ui/selectProvincesPopup?provinceIds=" + provinceStringIds.join(","), {
				title: '选择省份',
				width: "48em",
				height: "23em",
				callback: function (resp) {
					that.provinces = resp.data.provinces
					that.change()
				}
			})
		},
		remove: function (index) {
			this.provinces.$remove(index)
			this.change()
		},
		change: function () {
			this.provinceIds = this.provinces.$map(function (k, v) {
				return v.id
			})
		}
	},
	template: `<div>
	<input type="hidden" name="provinceIdsJSON" :value="JSON.stringify(provinceIds)"/>
	<div v-if="provinces.length > 0" style="margin-bottom: 0.5em">
		<div v-for="(province, index) in provinces" class="ui label tiny basic">{{province.name}} <a href="" title="删除" @click.prevent="remove(index)"><i class="icon remove"></i></a></div>
		<div class="ui divider"></div>
	</div>
	<div>
		<button class="ui button tiny" type="button" @click.prevent="add">+</button>
	</div>
</div>`
})

Vue.component("raquo-item", {
	template: `<span class="item disabled" style="padding: 0">&raquo;</span>`
})

Vue.component("network-addresses-box", {
	props: ["v-server-type", "v-addresses", "v-protocol", "v-name", "v-from", "v-support-range", "v-url"],
	data: function () {
		let addresses = this.vAddresses
		if (addresses == null) {
			addresses = []
		}
		let protocol = this.vProtocol
		if (protocol == null) {
			protocol = ""
		}

		let name = this.vName
		if (name == null) {
			name = "addresses"
		}

		let from = this.vFrom
		if (from == null) {
			from = ""
		}

		return {
			addresses: addresses,
			protocol: protocol,
			name: name,
			from: from,
			isEditing: false
		}
	},
	watch: {
		"vServerType": function () {
			this.addresses = []
		},
		"vAddresses": function () {
			if (this.vAddresses != null) {
				this.addresses = this.vAddresses
			}
		}
	},
	methods: {
		addAddr: function () {
			this.isEditing = true

			let that = this
			window.UPDATING_ADDR = null

			let url = this.vUrl
			if (url == null) {
				url = "/servers/addPortPopup"
			}

			teaweb.popup(url + "?serverType=" + this.vServerType + "&protocol=" + this.protocol + "&from=" + this.from + "&supportRange=" + (this.supportRange() ? 1 : 0), {
				title: this.$t('index_端口绑定_0101'),
				height: "18em",
				callback: function (resp) {
					var addr = resp.data.address
					if (that.addresses.$find(function (k, v) {
						return addr.host == v.host && addr.portRange == v.portRange && addr.protocol == v.protocol
					}) != null) {
						teaweb.warn(that.$t('index_要添加的网络地址已经存在_0101'))
						return
					}
					that.addresses.push(addr)
					if (["https", "https4", "https6"].$contains(addr.protocol)) {
						this.tlsProtocolName = "HTTPS"
					} else if (["tls", "tls4", "tls6"].$contains(addr.protocol)) {
						this.tlsProtocolName = "TLS"
					}

					// 发送事件
					that.$emit("change", that.addresses)
				}
			})
		},
		removeAddr: function (index) {
			this.addresses.$remove(index);

			// 发送事件
			this.$emit("change", this.addresses)
		},
		updateAddr: function (index, addr) {
			let that = this
			window.UPDATING_ADDR = addr

			let url = this.vUrl
			if (url == null) {
				url = "/servers/addPortPopup"
			}

			teaweb.popup(url + "?serverType=" + this.vServerType + "&protocol=" + this.protocol + "&from=" + this.from + "&supportRange=" + (this.supportRange() ? 1 : 0), {
				title: this.$t('index_端口绑定_0101'),
				height: "18em",
				callback: function (resp) {
					var addr = resp.data.address
					Vue.set(that.addresses, index, addr)

					if (["https", "https4", "https6"].$contains(addr.protocol)) {
						this.tlsProtocolName = "HTTPS"
					} else if (["tls", "tls4", "tls6"].$contains(addr.protocol)) {
						this.tlsProtocolName = "TLS"
					}

					// 发送事件
					that.$emit("change", that.addresses)
				}
			})
		},
		supportRange: function () {
			return this.vSupportRange || (this.vServerType == "tcpProxy" || this.vServerType == "udpProxy")
		},
		edit: function () {
			this.isEditing = true
		}
	},
	template: `<div>
	<input type="hidden" :name="name" :value="JSON.stringify(addresses)"/>
	<div v-show="!isEditing">
		<div v-if="addresses.length > 0">
			<div class="ui label small basic" v-for="(addr, index) in addresses">
				{{addr.protocol}}://<span v-if="addr.host.length > 0">{{addr.host.quoteIP()}}</span><span v-if="addr.host.length == 0">*</span>:<span v-if="addr.portRange.indexOf('-')<0">{{addr.portRange}}</span><span v-else style="font-style: italic">{{addr.portRange}}</span>
			</div>
			&nbsp; &nbsp; <a href="" @click.prevent="edit" style="font-size: 0.9em">[{{$t('index_修改_0101')}}]</a>
		</div>	
	</div>
	<div v-show="isEditing || addresses.length == 0">
		<div v-if="addresses.length > 0">
			<div class="ui label small basic" v-for="(addr, index) in addresses">
				{{addr.protocol}}://<span v-if="addr.host.length > 0">{{addr.host.quoteIP()}}</span><span v-if="addr.host.length == 0">*</span>:<span v-if="addr.portRange.indexOf('-')<0">{{addr.portRange}}</span><span v-else style="font-style: italic">{{addr.portRange}}</span>
				<a href="" @click.prevent="updateAddr(index, addr)" title="修改"><i class="icon pencil small"></i></a>
				<a href="" @click.prevent="removeAddr(index)" title="删除"><i class="icon remove"></i></a> 
			</div>
			<div class="ui divider"></div>
		</div>
		<a class="ui button small" href="" @click.prevent="addAddr()">{{$t('index_添加端口绑定_0101')}}</a>
	</div>
</div>`
})

Vue.component("values-box", {
	props: ["values", "v-values", "size", "maxlength", "name", "placeholder", "v-allow-empty", "validator"],
	data: function () {
		let values = this.values;
		if (values == null) {
			values = [];
		}

		if (this.vValues != null && typeof this.vValues == "object") {
			values = this.vValues
		}

		return {
			"realValues": values,
			"isUpdating": false,
			"isAdding": false,
			"index": 0,
			"value": "",
			isEditing: false
		}
	},
	methods: {
		create: function () {
			this.isAdding = true;
			var that = this;
			setTimeout(function () {
				that.$refs.value.focus();
			}, 200);
		},
		update: function (index) {
			this.cancel()
			this.isUpdating = true;
			this.index = index;
			this.value = this.realValues[index];
			var that = this;
			setTimeout(function () {
				that.$refs.value.focus();
			}, 200);
		},
		confirm: function () {
			if (this.value.length == 0) {
				if (typeof (this.vAllowEmpty) != "boolean" || !this.vAllowEmpty) {
					return
				}
			}

			// validate
			if (typeof (this.validator) == "function") {
				let resp = this.validator.call(this, this.value)
				if (typeof resp == "object") {
					if (typeof resp.isOk == "boolean" && !resp.isOk) {
						if (typeof resp.message == "string") {
							let that = this
							teaweb.warn(resp.message, function () {
								that.$refs.value.focus();
							})
						}
						return
					}
				}
			}

			if (this.isUpdating) {
				Vue.set(this.realValues, this.index, this.value);
			} else {
				this.realValues.push(this.value);
			}
			this.cancel()
			this.$emit("change", this.realValues)
		},
		remove: function (index) {
			this.realValues.$remove(index)
			this.$emit("change", this.realValues)
		},
		cancel: function () {
			this.isUpdating = false;
			this.isAdding = false;
			this.value = "";
		},
		updateAll: function (values) {
			this.realValues = values
		},
		addValue: function (v) {
			this.realValues.push(v)
		},

		startEditing: function () {
			this.isEditing = !this.isEditing
		},
		allValues: function () {
			return this.realValues
		}
	},
	template: `<div>
	<div v-show="!isEditing && realValues.length > 0">
		<div class="ui label tiny basic" v-for="(value, index) in realValues" style="margin-top:0.4em;margin-bottom:0.4em">
			<span v-if="value.toString().length > 0">{{value}}</span>
			<span v-if="value.toString().length == 0" class="disabled">{{$t('clusters_monitors_reporters_reporter@空')}}</span>
		</div>
		<a href="" @click.prevent="startEditing" style="font-size: 0.8em; margin-left: 0.2em">{{$t('clusters_monitors_reporters_reporter@修改')}}</a>
	</div>
	<div v-show="isEditing || realValues.length == 0">
		<div style="margin-bottom: 1em" v-if="realValues.length > 0">
			<div class="ui label tiny basic" v-for="(value, index) in realValues" style="margin-top:0.4em;margin-bottom:0.4em">
				<span v-if="value.toString().length > 0">{{value}}</span>
				<span v-if="value.toString().length == 0" class="disabled">{{$t('clusters_monitors_reporters_reporter@空')}}</span>
				<input type="hidden" :name="name" :value="value"/>
				&nbsp; <a href="" @click.prevent="update(index)" :title="$t('clusters_monitors_reporters_reporter@修改')"><i class="icon pencil small" ></i></a> 
				<a href="" @click.prevent="remove(index)" :title="$t('clusters_monitors_reporters_reporter@删除')"><i class="icon remove"></i></a> 
			</div> 
			<div class="ui divider"></div>
		</div> 
		<!-- 添加|修改 -->
		<div v-if="isAdding || isUpdating">
			<div class="ui fields inline">
				<div class="ui field">
					<input type="text" :size="size" :maxlength="maxlength" :placeholder="placeholder" v-model="value" ref="value" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
				</div> 
				<div class="ui field">
					<button class="ui button small" type="button" @click.prevent="confirm()">{{$t('clusters_monitors_reporters_reporter@确定')}}</button> 
				</div>
				<div class="ui field">
					<a href="" @click.prevent="cancel()" :title="$t('clusters_monitors_reporters_reporter@取消')"><i class="icon remove small"></i></a> 
				</div> 
			</div> 
		</div> 
		<div v-if="!isAdding && !isUpdating">
			<button class="ui button tiny" type="button" @click.prevent="create()">+</button> 
		</div>
	</div>	
</div>`
});

/**
 * 保存按钮
 */
Vue.component("submit-btn", {
	template: '<button class="ui button primary" type="submit"><slot>{{$t("index_保存_0101")}}</slot></button>'
});

Vue.component("reset-btn", {
    props: {
        formId: {
            type: String,
            required: true
        },
        inputName: {
            type: String,
            default: 'reset'
        },
        inputValue: {
            type: String,
            default: '1'
        }
    },
	methods: {
		reset: function () {
            let form = document.getElementById(this.formId);
            if (!form) {
                console.error('找不到表单:', this.formId);
                return;
            }

            // 创建隐藏的input
            let input = document.createElement('input');
            input.type = 'hidden';
            input.name = this.inputName;
            input.value = this.inputValue;

            // 添加到表单
            form.appendChild(input);

			// 找到表单中的提交按钮并触发点击
			let submitButton = form.querySelector('button[type="submit"]');
			if (submitButton) {
				submitButton.click();
			} else {
				// 如果没有找到submit按钮，则使用默认提交
				form.submit();
			}
			setTimeout(function() {
				if (input.parentNode) {
					input.parentNode.removeChild(input);
				}
			}, 100);
		},
	},
	template: '<button class="ui button red" type="button" @click.prevent="reset"><slot>{{$t("index_重置_0101")}}</slot></button>'
});

Vue.component("empty-chart", {
    props: {
        description: {
            type: String,
            default: "暂无数据"
        },
        height: {
            type: String,
            default: "22em"
        }
    },
    data: () => ({
        isDarkMode: false
    }),
    mounted() {
        // 检测暗色主题
        this.isDarkMode = document.documentElement.classList.contains("dark");
        
        // 监听主题变化
        const observer = new MutationObserver((mutations) => {
            mutations.forEach((mutation) => {
                if (mutation.attributeName === 'class') {
                    this.isDarkMode = document.documentElement.classList.contains("dark");
                }
            });
        });
        
        observer.observe(document.documentElement, {
            attributes: true
        });
    },
    template: `<div class="empty-chart" :style="{'height': height}">
        <div class="empty-chart-content">
            <div class="empty-icon">
                <i class="pi pi-chart-bar" :style="{fontSize: '48px', color: isDarkMode ? '#999 !important' : '#999 !important'}"></i>
            </div>
            <div class="empty-text">{{description}}</div>
        </div>
    </div>`
}); 

Vue.component("network-addresses-view", {
	props: ["v-addresses"],
	template: `<div>
	<div class="ui label tiny basic" v-if="vAddresses != null" v-for="addr in vAddresses">
		{{addr.protocol}}://<span v-if="addr.host.length > 0">{{addr.host.quoteIP()}}</span><span v-else>*</span>:{{addr.portRange}}
	</div>
</div>`
})

Vue.component("dot", {
	template: '<span style="display: inline-block; padding-bottom: 3px"><i class="icon circle tiny"></i></span>'
})

Vue.component("not-found-box", {
	props: ["message"],
	template: `<div style="text-align: center; margin-top: 5em;">
	<div style="font-size: 2em; margin-bottom: 1em"><i class="icon exclamation triangle large grey"></i></div>
	<b-notice>{{message}}<slot></slot></b-notice>
</div>`
})

Vue.component("bandwidth-size-capacity-view", {
	props: ["v-value"],
	data: function () {
		let capacity = this.vValue
		if (capacity != null && capacity.count > 0 && typeof capacity.unit === "string") {
			capacity.unit = capacity.unit[0].toUpperCase() + capacity.unit.substring(1) + "ps"
		}
		return {
			capacity: capacity
		}
	},
	template: `<span>
	<span v-if="capacity != null && capacity.count > 0">{{capacity.count}}{{capacity.unit}}</span>
</span>`
})

/**
 * 二级菜单
 */
Vue.component("inner-menu", {
	template: `
		<div class="second-menu" style="width:80%;position: absolute;top:-8px;right:1em"> 
			<div class="ui menu text blue small">
				<slot></slot>
			</div> 
		</div>`
});

// 可以展示更多条目的角图表
Vue.component("more-items-angle", {
	props: ["v-data-url", "v-url"],
	data: function () {
		return {
			visible: false
		}
	},
	methods: {
		show: function () {
			this.visible = !this.visible
			if (this.visible) {
				this.showBox()
			} else {
				this.hideBox()
			}
		},
		showBox: function () {
			let that = this

			this.visible = true

			Tea.action(this.vDataUrl)
				.params({
					url: this.vUrl
				})
				.post()
				.success(function (resp) {
					let groups = resp.data.groups
					let rect = that.$el.getBoundingClientRect()
					let boxLeft = rect.left + window.pageXOffset
					let boxTop = rect.top + window.pageYOffset + 30

					let box = document.createElement("div")
					box.setAttribute("id", "more-items-box")
					box.style.cssText = "z-index: 100; position: absolute; left: " + boxLeft + "px; top: " + boxTop + "px; max-height: 30em; overflow: auto; border-bottom: 1px solid rgba(34,36,38,.15)"
					document.body.append(box)

					let menuHTML = "<ul class=\"ui labeled menu vertical borderless\" style=\"padding: 0\">"
					groups.forEach(function (group) {
						menuHTML += "<div class=\"item header\">" + teaweb.encodeHTML(group.name) + "</div>"
						group.items.forEach(function (item) {
							menuHTML += "<a href=\"" + item.url + "\" class=\"item " + (item.isActive ? "active" : "") + "\" style=\"font-size: 0.9em;\">" + teaweb.encodeHTML(item.name) + "<i class=\"icon right angle\"></i></a>"
						})
					})
					menuHTML += "</ul>"
					box.innerHTML = menuHTML

					let listener = function (e) {
						if (e.target.tagName == "I") {
							return
						}

						if (!that.isInBox(box, e.target)) {
							document.removeEventListener("click", listener)
							that.hideBox()
						}
					}
					document.addEventListener("click", listener)
				})
		},
		hideBox: function () {
			let box = document.getElementById("more-items-box")
			if (box != null) {
				box.parentNode.removeChild(box)
			}
			this.visible = false
		},
		isInBox: function (parent, child) {
			while (true) {
				if (child == null) {
					break
				}
				if (child.parentNode == parent) {
					return true
				}
				child = child.parentNode
			}
			return false
		}
	},
	template: `<a href="" class="item" @click.prevent="show" style="padding-right: 0"><span style="font-size: 0.8em">{{$t('index_切换_0101')}}</span><i class="icon angle" :class="{down: !visible, up: visible}"></i></a>`
})

// 请求限制配置组件（封装请求限制配置页面，风格与remote-addr-details-box.js一致）
Vue.component("request-limit-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      requestLimitConfig: null,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取请求限制配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/requestLimit'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.requestLimitConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            maxConns: 0,
            maxConnsPerIP: 0,
            maxBodySize: {
              count: -1,
              unit: "kb"
            },
            outBandwidthPerConn: {
              count: -1,
              unit: "kb"
            }
          }
        }

        this.$set(this, 'requestLimitConfig', config)
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(value) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/requestLimit'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        requestLimitJSON: JSON.stringify(value)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('requestLimit@由于已经在当前')}}<a :href="groupSettingURL">{{$t("reverseProxy_index@网站分组")}}</a>{{$t("access-log-config-box@中进行了对应的配置，在这里的配置将不会生效")}}</warning-message>
        </div>

        <form method="post" class="ui form"  :class="{'opacity-mask': hasGroupConfig}">
          <http-request-limit-config-box
            :key="key"
            :v-request-limit-config="requestLimitConfig"
            @submit="saveConfig">
          </http-request-limit-config-box>
        </form>
      </a-spin>
    </div>
  `
}) 

// HTTP头管理组件（封装HTTP头配置页面，风格与request-limit-details-box.js一致）
Vue.component("http-header-details-box", {
  props: [
    "serverId",
    "vIsLocation",
    "vIsGroup"
  ],
  data: function () {
    return {
      type: "response", // 默认显示响应报头
      typeName: this.$t('http-header-policy-box@响应'),
      requestHeaderPolicy: null,
      responseHeaderPolicy: null,
      isLoading: false,
      hasGroupRequestConfig: false,
      hasGroupResponseConfig: false,
      groupSettingURL: "",
      key: 0,

      // 请求相关
      requestSettingHeaders: [],
      requestDeletingHeaders: [],
      requestNonStandardHeaders: [],

      // 响应相关
      responseSettingHeaders: [],
      responseDeletingHeaders: [],
      responseNonStandardHeaders: [],
      responseCORS: {
        isOn: false
      }
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    handleTabChange(type) {
      this.type = type
      this.typeName = (type === "request") ? this.$t('http-header-policy-box@请求') : this.$t('http-header-policy-box@响应')
    },
    addSettingHeader: function (policyId) {
      const that = this
      let url = "/servers/server/settings/headers/createSetPopup?serverId=" + this.serverId + "&headerPolicyId=" + policyId + "&type=" + this.type
      if (this.vIsLocation) {
        url += "&vIsLocation=1"
      }
      if (this.vIsGroup) {
        url += "&vIsGroup=1"
      }
      teaweb.popup(url, {
        height: "22em",
        title: this.$t('http-header-policy-box@创建自定义报头'),
        callback: function () {
          that.$message.success(that.$t('http-header-policy-box@保存成功'))
          that.getData()
        }
      })
    },
    addDeletingHeader: function (policyId, type) {
      const that = this
      let url = "/servers/server/settings/headers/createDeletePopup?serverId=" + this.serverId + "&headerPolicyId=" + policyId + "&type=" + type
      if (this.vIsLocation) {
        url += "&vIsLocation=1"
      }
      if (this.vIsGroup) {
        url += "&vIsGroup=1"
      }
      teaweb.popup(url, {
        title: this.$t('http-header-policy-box@创建自定义报头'),
        callback: function () {
          that.$message.success(that.$t('http-header-policy-box@保存成功'))
          that.getData()
        }
      })
    },
    addNonStandardHeader: function (policyId, type) {
      const that = this
      let url = "/servers/server/settings/headers/createNonStandardPopup?serverId=" + this.serverId + "&headerPolicyId=" + policyId + "&type=" + type
      if (this.vIsLocation) {
        url += "&vIsLocation=1"
      }
      if (this.vIsGroup) {
        url += "&vIsGroup=1"
      }
      teaweb.popup(url, {
        title: this.$t('http-header-policy-box@创建自定义报头'),
        callback: function () {
          that.$message.success(that.$t('http-header-policy-box@保存成功'))
          that.getData()
        }
      })
    },
    updateSettingPopup: function (policyId, headerId) {
      const that = this
      let url = "/servers/server/settings/headers/updateSetPopup?serverId=" + this.serverId + "&headerPolicyId=" + policyId + "&headerId=" + headerId + "&type=" + this.type
      if (this.vIsLocation) {
        url += "&vIsLocation=1"
      }
      if (this.vIsGroup) {
        url += "&vIsGroup=1"
      }
      teaweb.popup(url, {
        height: "22em",
        title: this.$t('http-header-policy-box@修改自定义报头'),
        callback: function () {
          that.$message.success(that.$t('http-header-policy-box@保存成功'))
          that.getData()
        }
      })
    },
    deleteDeletingHeader: function (policyId, headerName) {
      let that = this
      teaweb.confirm(this.$t('http-header-policy-box@确定要删除_headerName_吗', {'headerName': headerName}), function () {
        Tea.action("/servers/server/settings/headers/deleteDeletingHeader")
          .params({
            headerPolicyId: policyId,
            headerName: headerName
          })
          .post().success((resp) => {
            that.$message.success(that.$t('http-header-policy-box@保存成功'))
            that.getData()
          })
      })
    },
    deleteNonStandardHeader: function (policyId, headerName) {
      let that = this
      teaweb.confirm(this.$t('http-header-policy-box@确定要删除_headerName_吗', {'headerName': headerName}), function () {
        Tea.action("/servers/server/settings/headers/deleteNonStandardHeader")
          .params({
            headerPolicyId: policyId,
            headerName: headerName
          })
          .post().success((resp) => {
            that.$message.success(that.$t('http-header-policy-box@保存成功'))
            that.getData()
          })
      })
    },
    deleteHeader: function (policyId, type, headerId) {
      let that = this
      teaweb.confirm(this.$t('http-header-policy-box@确定要删除此报头吗'), function () {
        this.$post("/servers/server/settings/headers/delete")
          .params({
            headerPolicyId: policyId,
            type: type,
            headerId: headerId
          }).success((resp) => {
            that.$message.success(that.$t('http-header-policy-box@保存成功'))
            that.getData()
          })
      })
    },
    updateCORS: function (policyId) {
      const that = this
      teaweb.popup("/servers/server/settings/headers/updateCORSPopup?serverId=" + this.serverId + "&headerPolicyId=" + policyId + "&type=" + this.type, {
        height: "30em",
        title: this.$t('http-header-policy-box@修改CORS'),
        callback: function () {
          that.$message.success(that.$t('http-header-policy-box@保存成功'))
          
          that.getData()
        }
      })
    },

    // 获取HTTP头配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/headers'
      const params = {
        serverId: this.serverId
      }
      if (this.vIsLocation) {
        params.vIsLocation = 1
      }
      if (this.vIsGroup) {
        params.vIsGroup = 1
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.requestHeaderPolicy = resp.data.requestHeaderPolicy
        this.responseHeaderPolicy = resp.data.responseHeaderPolicy
        this.hasGroupRequestConfig = resp.data.hasGroupRequestConfig
        this.hasGroupResponseConfig = resp.data.hasGroupResponseConfig
        this.groupSettingURL = resp.data.groupSettingURL

        // 请求相关
        if (this.requestHeaderPolicy != null) {
          if (this.requestHeaderPolicy.setHeaders != null) {
            this.requestSettingHeaders = this.requestHeaderPolicy.setHeaders
          }
          if (this.requestHeaderPolicy.deleteHeaders != null) {
            this.requestDeletingHeaders = this.requestHeaderPolicy.deleteHeaders
          }
          if (this.requestHeaderPolicy.nonStandardHeaders != null) {
            this.requestNonStandardHeaders = this.requestHeaderPolicy.nonStandardHeaders
          }
        }

        // 响应相关
        if (this.responseHeaderPolicy != null) {
          if (this.responseHeaderPolicy.setHeaders != null) {
            this.responseSettingHeaders = this.responseHeaderPolicy.setHeaders
          }
          if (this.responseHeaderPolicy.deleteHeaders != null) {
            this.responseDeletingHeaders = this.responseHeaderPolicy.deleteHeaders
          }
          if (this.responseHeaderPolicy.nonStandardHeaders != null) {
            this.responseNonStandardHeaders = this.responseHeaderPolicy.nonStandardHeaders
          }
          if (this.responseHeaderPolicy.cors != null) {
            this.responseCORS = this.responseHeaderPolicy.cors
          }
        }

        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig() {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/headers'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        requestHeaderJSON: JSON.stringify(this.requestHeaderPolicy),
        responseHeaderJSON: JSON.stringify(this.responseHeaderPolicy)
      }
      if (this.vIsLocation) {
        params.vIsLocation = 1
      }
      if (this.vIsGroup) {
        params.vIsGroup = 1
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    },
    handleRequestChange(config) {
      this.requestHeaderPolicy = config
      this.saveConfig()
    },
    handleResponseChange(config) {
      this.responseHeaderPolicy = config
      this.saveConfig()
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div class="headers-box">
          <a-tabs v-model:activeKey="type" @change="handleTabChange">
            <a-tab-pane key="response">
              <template #tab>
                <span>
                  <i class="icon reply"></i>
                  {{$t('http-header-policy-box@响应报头')}}
                  <a-badge v-if="responseSettingHeaders.length > 0" :count="responseSettingHeaders.length" />
                </span>
              </template>
            </a-tab-pane>
            <a-tab-pane key="request">
              <template #tab>
                <span>
                  <i class="icon share"></i>
                  {{$t('http-header-policy-box@请求报头')}}
                  <a-badge v-if="requestSettingHeaders.length > 0" :count="requestSettingHeaders.length" />
                </span>
              </template>
            </a-tab-pane>
          </a-tabs>
          
          <input type="hidden" name="type" :value="type"/>
          
          <!-- 请求 -->
          <div v-if="(vIsLocation || vIsGroup) && type == 'request'" class="config-section">
            <div class="section-title">
              <i class="icon share"></i>
              <span>{{$t('http-header-policy-box@请求报头设置')}}</span>
            </div>
            
            <div class="config-item">
              <div class="item-content">
                <input type="hidden" name="requestHeaderJSON" :value="JSON.stringify(requestHeaderPolicy)"/>
                <prior-checkbox :v-config="requestHeaderPolicy" @change="handleRequestChange"></prior-checkbox>
              </div>
            </div>
            
            <div class="config-item">
              <div class="item-content">
                <submit-btn></submit-btn>
              </div>
            </div>
          </div>
          
          <div v-if="((!vIsLocation && !vIsGroup) || requestHeaderPolicy.isPrior) && type == 'request'">
            <div v-if="hasGroupRequestConfig">
              <div class="margin"></div>
              <warning-message>{{$t('http-header-policy-box@由于已经在当前')}}<a :href="groupSettingURL + '#request'">{{$t('http-header-policy-box@网站分组')}}</a>{{$t('http-header-policy-box@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
            </div>
            <div :class="{'opacity-mask': hasGroupRequestConfig}">
              <div class="config-section">
                <div class="section-title">
                  <i class="icon edit"></i>
                  <span>{{$t('http-header-policy-box@设置请求报头')}}</span>
                  <a href="" @click.prevent="addSettingHeader(requestHeaderPolicy.id)" class="ant-btn-link">{{$t('http-header-policy-box@添加新报头')}}</a>
                </div>
                
                <div class="config-item">
                  <div class="item-content">
                    <p class="comment" v-if="requestSettingHeaders.length == 0">{{$t('http-header-policy-box@暂时还没有自定义报头')}}</p>
                    <div v-if="requestSettingHeaders.length > 0" class="headers-table-box">
                      <b-table
                        :columns="[
                          { title: $t('http-header-policy-box@名称'), key: 'name', width: '30%', scopedSlots: { customRender: 'nameSlot' } },
                          { title: $t('http-header-policy-box@值'), dataIndex: 'value', key: 'value' },
                          { title: $t('http-header-policy-box@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
                        ]"
                        :data-source="requestSettingHeaders"
                        :row-key="'id'"
                        :pagination="false"
                      >
                        <template slot="nameSlot" slot-scope="{ text, record }">
                          <a href="" @click.prevent="updateSettingPopup(requestHeaderPolicy.id, record.id)">{{record.name}} <i class="icon expand small"></i></a>
                          <div>
                            <span v-if="record.status != null && record.status.codes != null && !record.status.always"><grey-label v-for="code in record.status.codes" :key="code">{{code}}</grey-label></span>
                            <span v-if="record.methods != null && record.methods.length > 0"><grey-label v-for="method in record.methods" :key="method">{{method}}</grey-label></span>
                            <span v-if="record.domains != null && record.domains.length > 0"><grey-label v-for="domain in record.domains" :key="domain">{{domain}}</grey-label></span>
                            <grey-label v-if="record.shouldAppend">{{$t('http-header-policy-box@附加')}}</grey-label>
                            <grey-label v-if="record.disableRedirect">{{$t('http-header-policy-box@跳转禁用')}}</grey-label>
                            <grey-label v-if="record.shouldReplace && record.replaceValues != null && record.replaceValues.length > 0">{{$t('http-header-policy-box@替换')}}</grey-label>
                          </div>
                        </template>
                        <template slot="actionSlot" slot-scope="{ text, record }">
                          <a-button type="link" @click.prevent="updateSettingPopup(requestHeaderPolicy.id, record.id)">{{$t('http-header-policy-box@修改')}}</a-button>
                          <a-button type="link" danger @click.prevent="deleteHeader(requestHeaderPolicy.id, 'setHeader', record.id)">{{$t('http-header-policy-box@删除')}}</a-button>
                        </template>
                      </b-table>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="config-section">
                <div class="section-title">
                  <i class="icon cog"></i>
                  <span>{{$t('http-header-policy-box@其他设置')}}</span>
                </div>
                
                <div class="config-item">
                  <div class="item-label">{{$t('http-header-policy-box@删除报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能删除转发到源站的请求报文中不需要的报头')"></tip-icon></div>
                  <div class="item-content">
                    <div v-if="requestDeletingHeaders.length > 0" class="headers-labels-box">
                      <div class="ui label small basic" v-for="headerName in requestDeletingHeaders">
                        {{headerName}} 
                        <a href=""><i class="icon remove" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteDeletingHeader(requestHeaderPolicy.id, headerName)"></i></a>
                      </div>
                    </div>
                    <button class="ui button small" type="button" @click.prevent="addDeletingHeader(requestHeaderPolicy.id, 'request')">
                      <i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
                    </button>
                  </div>
                </div>
                
                <div class="config-item">
                  <div class="item-label">{{$t('http-header-policy-box@非标报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能设置转发到源站的请求报文中非标准的报头比如hello_world')"></tip-icon></div>
                  <div class="item-content">
                    <div v-if="requestNonStandardHeaders.length > 0" class="headers-labels-box">
                      <div class="ui label small basic" v-for="headerName in requestNonStandardHeaders">
                        {{headerName}} 
                        <a href=""><i class="icon remove" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteNonStandardHeader(requestHeaderPolicy.id, headerName)"></i></a>
                      </div>
                    </div>
                    <button class="ui button small" type="button" @click.prevent="addNonStandardHeader(requestHeaderPolicy.id, 'request')">
                      <i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
                    </button>
                  </div>
                </div>
              </div>
            </div>			
          </div>
          
          <!-- 响应 -->
          <div v-if="(vIsLocation || vIsGroup) && type == 'response'" class="config-section">
            <div class="section-title">
              <i class="icon reply"></i>
              <span>{{$t('http-header-policy-box@响应报头设置')}}</span>
            </div>
            
            <div class="config-item">
              <div class="item-content">
                <input type="hidden" name="responseHeaderJSON" :value="JSON.stringify(responseHeaderPolicy)"/>
                <prior-checkbox :v-config="responseHeaderPolicy" @change="handleResponseChange"></prior-checkbox>
              </div>
            </div>
            
            <div class="config-item">
              <div class="item-content">
                <submit-btn></submit-btn>
              </div>
            </div>
          </div>
          
          <div v-if="((!vIsLocation && !vIsGroup) || responseHeaderPolicy.isPrior) && type == 'response'">
            <div v-if="hasGroupResponseConfig">
              <div class="margin"></div>
              <warning-message>{{$t('http-header-policy-box@由于已经在当前')}}<a :href="groupSettingURL + '#response'">{{$t('http-header-policy-box@网站分组')}}</a>{{$t('http-header-policy-box@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
            </div>
            <div :class="{'opacity-mask': hasGroupResponseConfig}">
              <div class="config-section">
                <div class="section-title">
                  <i class="icon edit"></i>
                  <span>{{$t('http-header-policy-box@设置响应报头')}}</span>
                  <a href="" @click.prevent="addSettingHeader(responseHeaderPolicy.id)" class="ant-btn-link">{{$t('http-header-policy-box@添加新报头')}}</a>
                </div>
                
                <div class="config-item">
                  <div class="item-content">
                    <p class="comment">{{$t('http-header-policy-box@将会覆盖已有的同名报头')}}</p>
                    <p class="comment" v-if="responseSettingHeaders.length == 0">{{$t('http-header-policy-box@暂时还没有自定义报头')}}</p>
                    <div v-if="responseSettingHeaders.length > 0" class="headers-table-box">
                      <b-table
                        :columns="[
                          { title: $t('http-header-policy-box@名称'), key: 'name', width: '30%', scopedSlots: { customRender: 'nameSlot' } },
                          { title: $t('http-header-policy-box@值'), dataIndex: 'value', key: 'value' },
                          { title: $t('http-header-policy-box@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
                        ]"
                        :data-source="responseSettingHeaders"
                        :row-key="'id'"
                        :pagination="false"
                      >
                        <template slot="nameSlot" slot-scope="{ text, record }">
                          <a href="" @click.prevent="updateSettingPopup(responseHeaderPolicy.id, record.id)">{{record.name}} <i class="icon expand small"></i></a>
                          <div>
                            <span v-if="record.status != null && record.status.codes != null && !record.status.always"><grey-label v-for="code in record.status.codes" :key="code">{{code}}</grey-label></span>
                            <span v-if="record.methods != null && record.methods.length > 0"><grey-label v-for="method in record.methods" :key="method">{{method}}</grey-label></span>
                            <span v-if="record.domains != null && record.domains.length > 0"><grey-label v-for="domain in record.domains" :key="domain">{{domain}}</grey-label></span>
                            <grey-label v-if="record.shouldAppend">{{$t('http-header-policy-box@附加')}}</grey-label>
                            <grey-label v-if="record.disableRedirect">{{$t('http-header-policy-box@跳转禁用')}}</grey-label>
                            <grey-label v-if="record.shouldReplace && record.replaceValues != null && record.replaceValues.length > 0">{{$t('http-header-policy-box@替换')}}</grey-label>
                          </div>
                          
                          <!-- CORS -->
                          <div v-if="record.name == 'Access-Control-Allow-Origin' && record.value == '*'">
                            <span class="red small">{{$t('http-header-policy-box@建议使用当前页面下方的CORS自适应跨域功能代替AccessControl相关报头')}}</span>
                          </div>
                        </template>
                        <template slot="actionSlot" slot-scope="{ text, record }">
                          <a-button type="link" @click.prevent="updateSettingPopup(responseHeaderPolicy.id, record.id)">{{$t('http-header-policy-box@修改')}}</a-button>
                          <a-button type="link" danger @click.prevent="deleteHeader(responseHeaderPolicy.id, 'setHeader', record.id)">{{$t('http-header-policy-box@删除')}}</a-button>
                        </template>
                      </b-table>
                    </div>
                  </div>
                </div>
              </div>
              
              <div class="config-section">
                <div class="section-title">
                  <i class="icon cog"></i>
                  <span>{{$t('http-header-policy-box@其他设置')}}</span>
                </div>
                
                <div class="config-item">
                  <div class="item-label">{{$t('http-header-policy-box@删除报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能删除响应报文中不需要的报头')"></tip-icon></div>
                  <div class="item-content">
                    <div v-if="responseDeletingHeaders.length > 0" class="headers-labels-box">
                      <div class="ui label small basic" v-for="headerName in responseDeletingHeaders">
                        {{headerName}} &nbsp; 
                        <a href=""><i class="icon remove small" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteDeletingHeader(responseHeaderPolicy.id, headerName)"></i></a>
                      </div>
                    </div>
                    <button class="ui button small" type="button" @click.prevent="addDeletingHeader(responseHeaderPolicy.id, 'response')">
                      <i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
                    </button>
                  </div>
                </div>
                
                <div class="config-item">
                  <div class="item-label">{{$t('http-header-policy-box@非标报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能设置响应报文中非标准的报头比如hello_world')"></tip-icon></div>
                  <div class="item-content">
                    <div v-if="responseNonStandardHeaders.length > 0" class="headers-labels-box">
                      <div class="ui label small basic" v-for="headerName in responseNonStandardHeaders">
                        {{headerName}} &nbsp; 
                        <a href=""><i class="icon remove small" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteNonStandardHeader(responseHeaderPolicy.id, headerName)"></i></a>
                      </div>
                    </div>
                    <button class="ui button small" type="button" @click.prevent="addNonStandardHeader(responseHeaderPolicy.id, 'response')">
                      <i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
                    </button>
                  </div>
                </div>
                
                <div class="config-item">
                  <div class="item-label">{{$t('http-header-policy-box@CORS自适应跨域')}}</div>
                  <div class="item-content">
                    <span v-if="responseCORS.isOn" class="green">{{$t('http-header-policy-box@已启用')}}</span><span class="disabled" v-else="">{{$t('http-header-policy-box@未启用')}}</span> &nbsp; 
                    <a href="" @click.prevent="updateCORS(responseHeaderPolicy.id)">[{{$t('http-header-policy-box@修改')}}]</a>
                    <p class="comment">{{$t('http-header-policy-box@启用后服务器可以自动生成')}}<code-label>Access-Control-*-*</code-label> {{$t('http-header-policy-box@相关的报头')}}</p>
                  </div>
                </div>
              </div>
            </div>			
          </div>
        </div>
      </a-spin>
    </div>
  `
}) 

// WebSocket配置详情组件
Vue.component("websocket-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      websocketRef: null,
      websocketConfig: null,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取WebSocket配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/websocket'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let websocketRef = resp.data.websocketRef
        if (websocketRef == null) {
          websocketRef = {
            isPrior: false,
            isOn: false,
            websocketId: 0
          }
        }

        let websocketConfig = resp.data.websocketConfig
        if (websocketConfig == null) {
          websocketConfig = {
            id: 0,
            isOn: false,
            handshakeTimeout: {
              count: 30,
              unit: "second"
            },
            allowAllOrigins: true,
            allowedOrigins: [],
            requestSameOrigin: true,
            requestOrigin: ""
          }
        } else {
          if (websocketConfig.handshakeTimeout == null) {
            websocketConfig.handshakeTimeout = {
              count: 30,
              unit: "second",
            }
          }
          if (websocketConfig.allowedOrigins == null) {
            websocketConfig.allowedOrigins = []
          }
        }
        this.websocketRef = websocketRef
        this.websocketConfig = websocketConfig
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(websocketRef, websocketConfig) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/websocket'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        websocketRefJSON: JSON.stringify(websocketRef),
        websocketJSON: JSON.stringify(websocketConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('websocket_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('websocket_index@网站分组')}}</a>{{$t('websocket_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
        </div>

        <form method="post" class="ui form"  :class="{'opacity-mask': hasGroupConfig}">
          <http-websocket-box
            :key="key"
            :v-websocket-ref="websocketRef"
            :v-websocket-config="websocketConfig"
            @submit="saveConfig">
          </http-websocket-box>
        </form>
      </a-spin>
    </div>
  `
}) 

// Referer防盗链管理组件（封装Referer配置页面，风格与compression-details-box.js一致）
Vue.component("referers-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      referersConfig: null,
      isLoading: false,
      referersWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getReferersConfig()
    }, 10)
  },
  methods: {
    // 获取Referer配置
    async getReferersConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/referers'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.referersConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            allowEmpty: true,
            allowSameDomain: true,
            allowDomains: [],
            denyDomains: [],
            checkOrigin: true
          }
        }
        if (config.allowDomains == null) {
          config.allowDomains = []
        }
        if (config.denyDomains == null) {
          config.denyDomains = []
        }
        this.referersConfig = config
        this.referersWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存Referer配置
    async saveReferersConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/referers'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.referersWebId,
        referersJSON: JSON.stringify(this.referersConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('referers-box@保存成功'))
        this.getReferersConfig()
      })
    },
    // 组件内触发保存
    submit(config) {
      this.referersConfig = config
      this.saveReferersConfig()
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" @submit.prevent="saveReferersConfig" id="referersForm">
        <http-referers-config-box v-if="referersConfig" :key="key" :v-referers-config="referersConfig" @submit="submit"></http-referers-config-box>
      </form>
    </a-spin>
  `
}) 

// 页面与关机配置详情组件
Vue.component("pages-and-shutdown-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      pages: null,
      shutdownConfig: null,
      enableGlobalPages: false,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取页面与关机配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/pages'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let pages = []
        if (resp.data.pages != null) {
          pages = resp.data.pages
        }
        let shutdownConfig = {
          isPrior: false,
          isOn: false,
          bodyType: "html",
          url: "",
          body: "",
          status: 0
        }
        if (resp.data.shutdownConfig != null) {
          if (resp.data.shutdownConfig.body == null) {
            resp.data.shutdownConfig.body = ""
          }
          if (resp.data.shutdownConfig.bodyType == null) {
            resp.data.shutdownConfig.bodyType = "html"
          }
          shutdownConfig = resp.data.shutdownConfig
        }

        this.pages = pages
        this.shutdownConfig = shutdownConfig
        this.enableGlobalPages = resp.data.enableGlobalPages
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(pages, shutdownConfig, enableGlobalPages) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/pages'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        pagesJSON: JSON.stringify(pages),
        shutdownJSON: JSON.stringify(shutdownConfig),
        enableGlobalPages: enableGlobalPages
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('pages-and-shutdown-box@由于已经在当前')}}<a :href="groupSettingURL">{{$t('pages-and-shutdown-box@网站分组')}}</a>{{$t('pages-and-shutdown-box@中进行了对应的配置，在这里的配置将不会生效')}}</warning-message>
        </div>

        <form method="post" class="ui form"  :class="{'opacity-mask': hasGroupConfig}" @submit.prevent="">
          <http-pages-and-shutdown-box
            :key="key"
            :v-pages="pages"
            :v-shutdown-config="shutdownConfig"
            :v-enable-global-pages="enableGlobalPages"
            @submit="saveConfig">
          </http-pages-and-shutdown-box>
        </form>
      </a-spin>
    </div>
  `
}) 

// FastCGI管理组件（封装FastCGI配置页面，风格与compression-details-box.js一致）
Vue.component("fastcgi-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      fastcgiRef: null,
      fastcgiConfigs: [],
      isLoading: false,
      fastcgiWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getFastcgiConfig()
    }, 10)
  },
  methods: {
    // 获取FastCGI配置
    async getFastcgiConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/fastcgi'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let fastcgiRef = resp.data.fastcgiRef
        if (fastcgiRef == null) {
          fastcgiRef = {
            isPrior: false,
            isOn: false,
            fastcgiIds: []
          }
        }
        let fastcgiConfigs = resp.data.fastcgiConfigs
        if (fastcgiConfigs == null) {
          fastcgiConfigs = []
        } else {
          fastcgiRef.fastcgiIds = fastcgiConfigs.map(function (v) {
            return v.id
          })
        }

        this.fastcgiRef = fastcgiRef
        this.fastcgiConfigs = fastcgiConfigs
        this.fastcgiWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存FastCGI配置
    async saveFastcgiConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/fastcgi'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.fastcgiWebId,
        fastcgiRefJSON: JSON.stringify(this.fastcgiRef),
        fastcgiConfigsJSON: JSON.stringify(this.fastcgiConfigs)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getFastcgiConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading" :key="key">
      <form class="ui form" @submit.prevent="saveFastcgiConfig" :key="key">
        <http-fastcgi-box v-if="fastcgiRef" :key="key" :v-fastcgi-ref="fastcgiRef" :v-fastcgi-configs="fastcgiConfigs"></http-fastcgi-box>
        <submit-btn></submit-btn>
      </form>
    </a-spin>
  `
}) 

// 通用配置管理组件（封装通用配置页面，风格与compression-details-box.js一致）
Vue.component("common-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      commonConfig: null,
      isLoading: false,
      commonWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getCommonConfig()
    }, 10)
  },
  methods: {
    // 获取通用配置
    async getCommonConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/common'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.commonConfig
        if (config == null) {
          config = {
            mergeSlashes: false
          }
        }
        this.commonConfig = config
        this.commonWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存通用配置
    async saveCommonConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/common'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.commonWebId,
        mergeSlashes: this.commonConfig.mergeSlashes
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getCommonConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" @submit.prevent="saveCommonConfig">
        <http-common-config-box v-if="commonConfig" :key="key" :v-common-config="commonConfig"></http-common-config-box>
        <submit-btn></submit-btn>
      </form>
    </a-spin>
  `
}) 

// 重写规则管理组件（封装重写规则配置页面，风格与auth-details-box.js一致）
Vue.component("rewrite-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      rewriteRules: [],
      isLoading: false,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getRewriteRules()
    }, 10)
  },
  methods: {
    // 获取重写规则列表
    async getRewriteRules() {
      this.isLoading = true
      const path = '/servers/server/settings/rewrite'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.rewriteRules = resp.data.rewriteRules || []
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 创建重写规则
    createRewriteRule() {
      let that = this
      teaweb.popup("/servers/server/settings/rewrite/createPopup?webId=" + this.webId, {
        title: this.$t('rewrite_index@创建重写规则'),
        height: "26em",
        callback: function () {
          teaweb.success(that.$t('rewrite_index@保存成功'), function () {
            that.getRewriteRules()
          })
        }
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
        <first-menu>
          <a class="item" @click.prevent="createRewriteRule()">
            <i class="pi pi-pen-to-square"></i>
            {{$t('rewrite_index@创建')}}
          </a>
        </first-menu>
        <http-rewrite-rule-list :key="key" :v-web-id="webId" :v-rewrite-rules="rewriteRules"></http-rewrite-rule-list>
    </a-spin>
  `
}) 

// 缓存管理组件（a-tabs切换，集成配置、刷新、预热）
Vue.component("cache-details-box", {
  props: [
    "serverId",
  ],
  data: function () {
    return {
      activeTab: "cacheConfig",
      cacheConfig: null,
      cachePolicy: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      // 批量刷新
      purgeKeyType: "key",
      purgeKeys: "",
      purgeResult: {
        isRequesting: false,
        isOk: false,
        message: "",
        failKeys: []
      },
      // 批量预热
      fetchKeys: "",
      fetchResult: {
        isRequesting: false,
        isOk: false,
        message: "",
        failKeys: []
      },
      cacheWebId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getCacheConfig()
    }, 10)
  },
  methods: {
    // 获取缓存配置
    async getCacheConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/cache'
      const params = {
        serverId: this.serverId,
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.cacheConfig = resp.data.cacheConfig
        this.cachePolicy = resp.data.cachePolicy
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.cacheWebId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存缓存配置
    async saveCacheConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/cache'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.cacheWebId,
        cacheJSON: JSON.stringify(this.cacheConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('cache_index@保存成功'))
        this.getCacheConfig()
      })
    },
    // 批量刷新缓存
    async purgeCache() {
      this.purgeResult.isRequesting = true
      this.purgeResult.isOk = false
      this.purgeResult.message = ""
      this.purgeResult.failKeys = []
      const path = '/servers/server/settings/cache/purge'
      const params = {
        serverId: this.serverId,
        webId: this.cacheWebId,
        keyType: this.purgeKeyType,
        keys: this.purgeKeys
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.purgeResult.isOk = true
        this.$message.success(this.$t('cache_purge@任务提交成功'))
      }).fail((resp) => {
        this.purgeResult.message = resp.message
        if (resp.data && resp.data.failKeys) {
          this.purgeResult.failKeys = resp.data.failKeys
        }
      }).done(() => {
        this.purgeResult.isRequesting = false
      })
    },
    // 批量预热缓存
    async fetchCache() {
      this.fetchResult.isRequesting = true
      this.fetchResult.isOk = false
      this.fetchResult.message = ""
      this.fetchResult.failKeys = []
      const path = '/servers/server/settings/cache/fetch'
      const params = {
        serverId: this.serverId,
        webId: this.cacheWebId,
        keys: this.fetchKeys
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.fetchResult.isOk = true
        this.$message.success(this.$t('cache_fetch@任务提交成功'))
      }).fail((resp) => {
        this.fetchResult.message = resp.message
        if (resp.data && resp.data.failKeys) {
          this.fetchResult.failKeys = resp.data.failKeys
        }
      }).done(() => {
        this.fetchResult.isRequesting = false
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <a-tabs v-model="activeTab" :key="key">
        <a-tab-pane key="cacheConfig" :tab="$t('cache_index@缓存配置')">
          <div v-if="hasGroupConfig">
            <div class="margin"></div>
            <warning-message>{{$t('cache_index@分组配置提示')}} <a :href="groupSettingURL">{{$t('reverseProxy_index@网站分组')}}</a> {{$t('access-log-config-box@中进行了对应的配置，在这里的配置将不会生效')}}</warning-message>
          </div>
          <div :class="{'opacity-mask': hasGroupConfig}">
            <form class="ui form" @submit.prevent="saveCacheConfig">
              <http-cache-config-box v-if="!isLoading" :v-cache-config="cacheConfig" :v-cache-policy="cachePolicy" :v-web-id="cacheWebId"></http-cache-config-box>
              <submit-btn></submit-btn>
              <p class="comment">{{$t('cache_index@保存提示')}}</p>
            </form>
          </div>
        </a-tab-pane>
        <a-tab-pane key="purge" :tab="$t('cache_purge@批量刷新')">
          <form class="ui form" @submit.prevent="purgeCache">
            <div class="config-section">
              <div class="section-title">
                <i class="pi pi-server"></i>
                {{$t('cache_purge@刷新缓存')}}
              </div>
              <div class="config-item">
                <div class="item-label">{{$t('cache_purge@URL类型')}}</div>
                <div class="item-content">
                  <radio name="keyType" :v-value="'key'" v-model="purgeKeyType">{{$t('cache_purge@URL')}}</radio> &nbsp;
                  <radio name="keyType" :v-value="'prefix'" v-model="purgeKeyType">{{$t('cache_purge@目录')}}</radio>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">
                  <span v-if="purgeKeyType == 'key'">{{$t('cache_purge@URL')}}</span>
                  <span v-if="purgeKeyType == 'prefix'">{{$t('cache_purge@目录')}}</span>
                </div>
                <div class="item-content">
                  <textarea name="keys" rows="10" v-model="purgeKeys"></textarea>
                  <p class="comment" v-if="purgeKeyType == 'key'">{{$t('cache_purge@每行一个URL比如_example_com_hello_world_html')}}<code-label>https://example.com/hello/world.html</code-label>。</p>
                  <p class="comment" v-if="purgeKeyType == 'prefix'">{{$t('cache_purge@每行一个URL目录比如_example_com_hello_如果只填写域名部分表示清理全站比如_example_com')}}<code-label>https://example.com/</code-label>;{{$t('cache_purge@如果只填写域名部分表示清理全站比如_example_com')}}<code-label>example.com</code-label>。</p>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">{{$t('cache_purge@操作结果')}}</div>
                <div class="item-content">
                  <div v-if="purgeResult.isRequesting">{{$t('cache_purge@数据发送中')}}</div>
                  <span class="red" v-if="!purgeResult.isRequesting && !purgeResult.isOk && purgeResult.message.length > 0">{{$t('cache_purge@失败')}}{{purgeResult.message}}</span>
                  <div v-if="!purgeResult.isRequesting && !purgeResult.isOk && purgeResult.failKeys.length > 0" class="fail-keys-box">
                    <div v-for="failKey in purgeResult.failKeys" :key="failKey.key">
                      <span class="red">{{failKey.key}}: {{failKey.reason}}</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <submit-btn v-if="!purgeResult.isRequesting">{{$t('cache_purge@提交')}}</submit-btn>
          </form>
        </a-tab-pane>
        <a-tab-pane key="fetch" :tab="$t('cache_fetch@批量预热')">
          <form class="ui form" @submit.prevent="fetchCache">
            <div class="config-section">
              <div class="section-title">{{$t('cache_fetch@预热缓存')}}</div>
              <div class="config-item">
                <div class="item-label">{{$t('cache_fetch@URL列表')}}</div>
                <div class="item-content">
                  <textarea name="keys" rows="10" v-model="fetchKeys"></textarea>
                  <p class="comment">{{$t('cache_fetch@每行一个URL')}}</p>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">{{$t('cache_fetch@操作结果')}}</div>
                <div class="item-content">
                  <div v-if="fetchResult.isRequesting">{{$t('cache_fetch@数据发送中')}}</div>
                  <span class="red" v-if="!fetchResult.isRequesting && !fetchResult.isOk && fetchResult.message.length > 0">{{$t('cache_fetch@失败')}}{{fetchResult.message}}</span>
                  <div v-if="!fetchResult.isRequesting && !fetchResult.isOk && fetchResult.failKeys.length > 0" class="fail-keys-box">
                    <div v-for="failKey in fetchResult.failKeys" :key="failKey.key">
                      <span class="red">{{failKey.key}}: {{failKey.reason}}</span>
                    </div>
                  </div>
                </div>
              </div>
            </div>
            <submit-btn v-if="!fetchResult.isRequesting">{{$t('cache_fetch@提交')}}</submit-btn>
          </form>
        </a-tab-pane>
      </a-tabs>
    </a-spin>
  `
}) 

// 远程地址配置组件（封装远程地址配置页面，风格与stat-details-box.js一致）
Vue.component("remote-addr-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      remoteAddrConfig: null,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取远程地址配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/remoteAddr'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.remoteAddrConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            value: "${rawRemoteAddr}",
            type: "default",
    
            requestHeaderName: ""
          }
        }
    
        // type
        if (config.type == null || config.type.length == 0) {
          config.type = "default"
          switch (config.value) {
            case "${rawRemoteAddr}":
              config.type = "default"
              break
            case "${remoteAddrValue}":
              config.type = "default"
              break
            case "${remoteAddr}":
              config.type = "proxy"
              break
            default:
              if (config.value != null && config.value.length > 0) {
                config.type = "variable"
              }
          }
        }
    
        // value
        if (config.value == null || config.value.length == 0) {
          config.value = "${rawRemoteAddr}"
        }
        this.$set(this, 'remoteAddrConfig', config)
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(value) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/remoteAddr'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        remoteAddrJSON: JSON.stringify(value)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('remoteAddr_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('reverseProxy_index@网站分组')}}</a>{{$t('access-log-config-box@中进行了对应的配置，在这里的配置将不会生效')}}</warning-message>
        </div>

        <div :class="{'opacity-mask': hasGroupConfig}">
          <http-remote-addr-config-box
            :key="key"
            :v-remote-addr-config="remoteAddrConfig"
            @submit="saveConfig">
          </http-remote-addr-config-box>
        </div>
      </a-spin>
    </div>
  `
}) 

// 规则分组和规则集管理组件，迁移自groups.js/group.js及相关html，结构参考webp-details-box.js
Vue.component("waf-groups-box", {
  props: ["serverId"],
  data: function () {
    return {
      groups: [],
      groupsColumns: [],
      wafIsOn: true,
      firewallPolicyId: null,
      type: 'inbound', // 默认展示入站分组，可扩展
      isLoading: false,
      // 详情页相关
      showDetailView: false,
      detailDialogGroup: null,
      detailDialogSets: [],
      detailDialogGroupId: null,
      detailSetsColumns: [
        { title: '', width: '3em', dataIndex: 'handle', key: 'handle', scopedSlots: { customRender: 'handleSlot' }, className: 'drag-handle' },
        { title: '规则集名称', dataIndex: 'name', key: 'name', scopedSlots: { customRender: 'nameSlot' } },
        { title: '规则', dataIndex: 'rules', key: 'rules', scopedSlots: { customRender: 'rulesSlot' } },
        { title: this.$t('waf_group@规则关系提示'), dataIndex: 'connector', key: 'connector', scopedSlots: { customRender: 'connectorSlot' }, slots: { title: 'customTitle' }, align: 'center', width: '8em' },
        { title: '动作', dataIndex: 'actions', key: 'actions', scopedSlots: { customRender: 'actionsSlot' } },
        { title: '操作', key: 'op', scopedSlots: { customRender: 'opSlot' }, width: '180px' }
      ]
    }
  },
  async mounted() {
    await this.getWafConfig()
  },
  methods: {
    // 获取WAF配置
    async getWafConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/waf'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.firewallPolicyId = resp.data.firewallPolicyId || null
        this.getGroups()
        this.isLoading = false
      })
    },
    // 获取分组列表
    async getGroups() {
      this.isLoading = true
      // 这里需要先获取firewallPolicyId，实际项目中可通过props或接口传递
      // 假设firewallPolicyId已知或通过接口获取
      // 这里只做演示，实际应完善firewallPolicyId的获取逻辑
      if (!this.firewallPolicyId) {
        // TODO: 通过接口获取firewallPolicyId
        this.firewallPolicyId = window.currentFirewallPolicyId || null
        if (!this.firewallPolicyId) {
          this.isLoading = false
          return
        }
      }
      const path = '/servers/server/settings/waf/groups'
      const params = {
        serverId: this.serverId,
        firewallPolicyId: this.firewallPolicyId,
        type: this.type
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.groups = resp.data.groups || []
        this.wafIsOn = resp.data.wafIsOn
        // 表格列定义
        this.groupsColumns = [
          { title: '', width: '3em', dataIndex: 'handle', key: 'handle', scopedSlots: { customRender: 'handleSlot' }, className: 'drag-handle' },
          { title: '规则分组', dataIndex: 'name', key: 'name', scopedSlots: { customRender: 'nameSlot' } },
          { title: '规则集', dataIndex: 'countSets', key: 'countSets', scopedSlots: { customRender: 'countSetsSlot' }, width: '100px', align: 'center' },
          { title: '操作', key: 'action', scopedSlots: { customRender: 'actionSlot' }, width: '150px' }
        ]
        this.isLoading = false
      })
    },
    // 排序处理
    sortGroups(groupIds) {
      window.Tea.Vue.$post('/servers/components/waf/sortGroups')
        .params({
          firewallPolicyId: this.firewallPolicyId,
          type: this.type,
          groupIds: groupIds
        })
        .success(() => {
          this.$message.success('排序保存成功')
          this.getGroups()
        })
    },
    // 启用分组
    enableGroup(groupId) {
      window.Tea.Vue.$post('/servers/components/waf/updateGroupOn')
        .params({ groupId: groupId, isOn: 1 })
        .success(() => this.getGroups())
    },
    // 停用分组
    disableGroup(groupId) {
      window.Tea.Vue.$post('/servers/components/waf/updateGroupOn')
        .params({ groupId: groupId, isOn: 0 })
        .success(() => this.getGroups())
    },
    // 删除分组
    deleteGroup(groupId) {
      if (!confirm('确定要删除此规则分组吗？')) return
      window.Tea.Vue.$post('/servers/components/waf/deleteGroup')
        .params({ firewallPolicyId: this.firewallPolicyId, groupId: groupId })
        .success(() => this.getGroups())
    },
    // 添加分组
    createGroup() {
      // 弹窗添加分组，实际应调用弹窗组件
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/components/waf/createGroupPopup?firewallPolicyId=${this.firewallPolicyId}&type=${this.type}`, {
        title: '添加分组',
        callback: () => {
          this.$message.success('保存成功')
          this.getGroups()
        }
      })
    },
    changeType(type) {
      console.log("changeType -> type", type)
      this.type = type
      this.getGroups()
    },
    // 详情按钮：隐藏表格，展示详情
    async showDetail(groupId) {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/group')
        .params({
          serverId: this.serverId,
          firewallPolicyId: this.firewallPolicyId,
          groupId: groupId,
          type: this.type
        })
        .success((resp) => {
          this.detailDialogGroup = resp.data.group || null
          this.detailDialogSets = resp.data.sets || (resp.data.group && resp.data.group.sets) || []
          this.detailDialogGroupId = groupId
          this.showDetailView = true
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 返回分组列表
    backToList() {
      this.showDetailView = false
      this.detailDialogGroup = null
      this.detailDialogSets = []
      this.detailDialogGroupId = null
      this.getGroups()
    },
    // 点击规则集数量也跳转到详情页
    showSets(groupId) {
      this.showDetail(groupId)
    },
    // 规则集排序处理
    sortSets(setIds) {
      window.Tea.Vue.$post('/servers/components/waf/sortSets')
        .params({
          groupId: this.detailDialogGroupId,
          setIds: setIds
        })
        .success(() => {
          this.$message.success('排序保存成功')
          this.showDetail(this.detailDialogGroupId)
        })
    },
    // 修改规则集
    updateSet(setId) {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/components/waf/updateSetPopup?firewallPolicyId=${this.firewallPolicyId}&groupId=${this.detailDialogGroupId}&type=${this.type}&setId=${setId}`, {
        title: '修改规则集',
        width: '50em',
        height: '40em',
        callback: () => {
          this.$message.success('保存成功')
          this.showDetail(this.detailDialogGroupId)
        }
      })
    },
    // 启用/停用规则集
    updateSetOn(setId, isOn) {
      window.Tea.Vue.$post('/servers/components/waf/updateSetOn')
        .params({ setId: setId, isOn: isOn ? 1 : 0 })
        .success(() => this.showDetail(this.detailDialogGroupId))
    },
    // 删除规则集
    deleteSet(setId) {
      window.teaweb.confirm(this.$t('waf_group@确定要删除此规则集吗'), async () => {
        await window.Tea.Vue.$post('/servers/components/waf/deleteSet')
          .params({ groupId: this.detailDialogGroupId, setId: setId })
          .success(() => {
            this.$message.success(this.$t('iplists@删除成功'))
            this.showDetail(this.detailDialogGroupId)
          })
      })

    },
    // 显示规则集代码
    showSetCode(setId) {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/components/waf/setCodePopup?setId=${setId}`, {
        title: '规则集代码',
        height: '26em'
      })
    },
    // 创建规则集
    createSet(groupId) {
      let that = this
      teaweb.popup("/servers/components/waf/createSetPopup?firewallPolicyId=" + this.firewallPolicyId + "&groupId=" + groupId + "&type=" + this.type, {
        title: this.$t('waf_group@添加规则集PopupTitle'),
        width: "50em",
        height: "40em",
        callback: (resp) => {
          teaweb.success(this.$t('waf_group@保存成功'), () => {
            this.showDetail(this.detailDialogGroupId)
          })
        }
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div>
        <div v-if="!showDetailView">
          <div class="ui secondary menu">
            <a class="item" :class="{active: type==='inbound'}" @click="changeType('inbound')">入站分组</a>
            <a class="item" :class="{active: type==='outbound'}" @click="changeType('outbound')">出站分组</a>
            <a class="item right" @click="createGroup()">添加分组</a>
          </div>
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <b-empty v-if="groups.length == 0">暂时还没有规则分组</b-empty>
          <div v-if="groups.length > 0">
            <b-sortable-table 
              :columns="groupsColumns" 
              :data-source="groups" 
              :row-key="'id'" 
              :scroll="{ x: 800 }"
              size="middle"
              :on-sort="sortGroups"
            >
              <!-- 拖动把手 -->
              <template slot="handleSlot" slot-scope="{ text, record }">
                <i class="icon handle bars" title="拖动排序"></i>
              </template>
              <template slot="nameSlot" slot-scope="{ text, record }">
                <span :class="{disabled:!record.isOn}">{{record.name}}</span>
                <p class="comment" v-if="record.description && record.description.length > 0" style="padding-bottom:0">{{record.description}}</p>
                <p style="margin-top: 0.5em">
                  <span v-if="record.isOn" class="ui label tiny basic green">启用</span>
                  <span v-if="!record.isOn" class="ui label tiny basic red">停用</span>
                  <span v-if="record.code && record.code.length > 0" class="ui label basic tiny">预置</span>
                  <span v-if="!record.code || record.code.length == 0" class="ui label basic tiny">自定义</span>
                </p>
              </template>
              <template slot="countSetsSlot" slot-scope="{ text, record }">
                <a href="javascript:;" @click.prevent="showSets(record.id)">{{record.countSets}}</a>
              </template>
              <template slot="actionSlot" slot-scope="{ text, record }">
                <a href="javascript:;" @click.prevent="showDetail(record.id)">详情</a> &nbsp;
                <a href="" v-if="!record.isOn" @click.prevent="enableGroup(record.id)">启用</a>
                <a href="" v-if="record.isOn" @click.prevent="disableGroup(record.id)">停用</a> &nbsp;
                <a href="" @click.prevent="deleteGroup(record.id)" v-if="record.canDelete">删除</a>
              </template>
            </b-sortable-table>
          </div>
          <p class="comment" v-if="groups.length > 0">可拖动分组进行排序，排序后自动保存。</p>
        </div>
        <div v-else>
          <button class="ui button basic" @click="backToList"><i class="icon angle left"></i>返回分组列表</button>
          <div v-if="detailDialogGroup" style="margin-top:1em;">
            <div><b>分组名称：</b>{{detailDialogGroup.name}}</div>
            <div><b>描述：</b>{{detailDialogGroup.description}}</div>
          </div>
          <b-settings-header
            style="padding-top:0.8em"
            @action="createSet(detailDialogGroup.id)"
            :action-text="$t('waf_group@添加规则集')"
          >
            {{$t('waf_group@规则集')}}
          </b-settings-header>
          <div v-if="detailDialogSets && detailDialogSets.length > 0" style="margin-top:1em;">
            <b-sortable-table
              :columns="detailSetsColumns"
              :data-source="detailDialogSets"
              :row-key="'id'"
              :pagination="false"
              size="middle"
              :on-sort="sortSets"
            >
              <!-- 拖动把手 -->
              <template slot="handleSlot" slot-scope="{ text, record }">
                <i class="icon handle bars" title="拖动排序"></i>
              </template>
              <template slot="customTitle" slot-scope="{ text, record }">
                <span>{{$t('waf_group@规则关系')}}<tip-icon :content="$t('waf_group@规则关系提示')"></tip-icon></span>
              </template>
              <template slot="nameSlot" slot-scope="{ text, record }">
                <span :class="{disabled:!record.isOn}">{{record.name}}</span>
                <p style="margin-top:0.5em">
                  <label-on :v-is-on="record.isOn"></label-on>
                </p>
              </template>
              <template slot="rulesSlot" slot-scope="{ text, record }">
                <div v-for="rule in record.rules" style="margin-top: 0.4em;margin-bottom:0.4em">
                  <http-firewall-rule-label :v-rule="rule"></http-firewall-rule-label>
                </div>
                <b-empty v-if="record.rules.length == 0">暂时还没有规则</b-empty>
              </template>
              <template slot="connectorSlot" slot-scope="{ text, record }">
                <span v-if="record.rules && record.rules.length > 1">
                  <span v-if="record.connector && record.connector.toUpperCase() == 'OR'">或</span>
                  <span v-else>和</span>
                  <span class="small grey">({{record.connector && record.connector.toUpperCase()}})</span>
                </span>
                <span v-else class="disabled">-</span>
              </template>
              <template slot="actionsSlot" slot-scope="{ text, record }">
                <http-firewall-actions-view :v-actions="record.actions"></http-firewall-actions-view>
              </template>
              <template slot="opSlot" slot-scope="{ text, record }">
                <a href="javascript:;" @click.prevent="updateSet(record.id)">修改</a> &nbsp;
                <a href="javascript:;" v-if="record.isOn" @click.prevent="updateSetOn(record.id, false)">停用</a>
                <a href="javascript:;" v-if="!record.isOn" @click.prevent="updateSetOn(record.id, true)"><span class="red">启用</span></a> &nbsp;
                <a href="javascript:;" @click.prevent="showSetCode(record.id)">代码</a> &nbsp;
                <a href="javascript:;" @click.prevent="deleteSet(record.id)">删除</a>
              </template>
            </b-sortable-table>
          </div>
          <b-empty v-if="!detailDialogSets || detailDialogSets.length == 0">暂时还没有规则集</b-empty>
        </div>
      </div>
    </a-spin>
  `
}) 

Vue.component("ssl-server-details-box", {
	props: [
		"v-ssl-policy",
		"v-protocol",
		"v-server-id",
		"v-support-http3"
	],
	created: function () {
		let that = this
		setTimeout(function () {
			that.sortableCipherSuites()
		}, 100)
	},
	data: function () {
		let policy = this.vSslPolicy
		if (policy == null) {
			policy = {
				id: 0,
				isOn: true,
				certRefs: [],
				certs: [],
				clientCARefs: [],
				clientCACerts: [],
				clientAuthType: 0,
				minVersion: "TLS 1.1",
				hsts: null,
				cipherSuitesIsOn: false,
				cipherSuites: [],
				http2Enabled: true,
				http3Enabled: false,
				ocspIsOn: false
			}
		} else {
			if (policy.certRefs == null) {
				policy.certRefs = []
			}
			if (policy.certs == null) {
				policy.certs = []
			}
			if (policy.clientCARefs == null) {
				policy.clientCARefs = []
			}
			if (policy.clientCACerts == null) {
				policy.clientCACerts = []
			}
			if (policy.cipherSuites == null) {
				policy.cipherSuites = []
			}
		}

		let hsts = policy.hsts
		let hstsMaxAgeString = "31536000"
		if (hsts == null) {
			hsts = {
				isOn: false,
				maxAge: 31536000,
				includeSubDomains: false,
				preload: false,
				domains: []
			}
		}
		if (hsts.maxAge != null) {
			hstsMaxAgeString = hsts.maxAge.toString()
		}

		return {
			policy: policy,

			// hsts
			hsts: hsts,
			hstsOptionsVisible: false,
			hstsDomainAdding: false,
			hstsMaxAgeString: hstsMaxAgeString,
			addingHstsDomain: "",
			hstsDomainEditingIndex: -1,

			// 相关数据
			allVersions: ['TLS 1.0', 'TLS 1.1', 'TLS 1.2', 'TLS 1.3'],
			SSL_ALL_CIPHER_SUITES: [
				"TLS_RSA_WITH_RC4_128_SHA",
				"TLS_RSA_WITH_3DES_EDE_CBC_SHA",
				"TLS_RSA_WITH_AES_128_CBC_SHA",
				"TLS_RSA_WITH_AES_256_CBC_SHA",
				"TLS_RSA_WITH_AES_128_CBC_SHA256",
				"TLS_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_RC4_128_SHA",
				"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
				"TLS_AES_128_GCM_SHA256",
				"TLS_AES_256_GCM_SHA384",
				"TLS_CHACHA20_POLY1305_SHA256"
			],
			allCipherSuites: [
				"TLS_RSA_WITH_RC4_128_SHA",
				"TLS_RSA_WITH_3DES_EDE_CBC_SHA",
				"TLS_RSA_WITH_AES_128_CBC_SHA",
				"TLS_RSA_WITH_AES_256_CBC_SHA",
				"TLS_RSA_WITH_AES_128_CBC_SHA256",
				"TLS_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_RC4_128_SHA",
				"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
				"TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
				"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
				"TLS_AES_128_GCM_SHA256",
				"TLS_AES_256_GCM_SHA384",
				"TLS_CHACHA20_POLY1305_SHA256"
			],
			modernCipherSuites: [
				"TLS_AES_128_GCM_SHA256",
				"TLS_CHACHA20_POLY1305_SHA256",
				"TLS_AES_256_GCM_SHA384",
				"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
			],
			intermediateCipherSuites: [
				"TLS_AES_128_GCM_SHA256",
				"TLS_CHACHA20_POLY1305_SHA256",
				"TLS_AES_256_GCM_SHA384",
				"TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
				"TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
				"TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
				"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
				"TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
				"TLS_RSA_WITH_3DES_EDE_CBC_SHA"
			],
			allClientAuthTypes: [
				{
					"name": "不需要客户端证书",
					"requireCA": false,
					"type": 0
				},
				{
					"name": "请求客户端证书",
					"requireCA": true,
					"type": 1
				},
				{
					"name": "需要客户端证书，但不校验",
					"requireCA": true,
					"type": 2
				},
				{
					"name": "有客户端证书的时候才校验",
					"requireCA": true,
					"type": 3
				},
				{
					"name": "校验客户端提供的证书",
					"requireCA": true,
					"type": 4
				}
			],
			cipherSuitesVisible: false,

			// 高级选项
			moreOptionsVisible: true
		}
	},
	watch: {
		hsts: {
			deep: true,
			handler: function () {
				this.policy.hsts = this.hsts
			}
		}
	},
	methods: {
		// 删除证书
		removeCert: function (index) {
			let that = this
			teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
				that.policy.certRefs.$remove(index)
				that.policy.certs.$remove(index)
			})
		},

		// 选择证书
		selectCert: function () {
			let that = this
			let selectedCertIds = []
			if (this.policy != null && this.policy.certs.length > 0) {
				this.policy.certs.forEach(function (cert) {
					selectedCertIds.push(cert.id.toString())
				})
			}
			let serverId = this.vServerId
			if (serverId == null) {
				serverId = 0
			}
			teaweb.popup("/servers/certs/selectPopup?selectedCertIds=" + selectedCertIds + "&serverId=" + serverId, {
				width: "50em",
				height: "30em",
				title: this.$t('index_选择证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null && resp.data.certRef != null) {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null && resp.data.certRefs != null) {
						that.policy.certRefs.$pushAll(resp.data.certRefs)
						that.policy.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 上传证书
		uploadCert: function () {
			let that = this
			let serverId = this.vServerId
			if (typeof serverId != "number" && typeof serverId != "string") {
				serverId = 0
			}
			teaweb.popup("/servers/certs/uploadPopup?serverId=" + serverId, {
				height: "30em",
				title: this.$t('index_上传证书_0101'),
				callback: function (resp) {
					teaweb.success(this.$t('index_上传成功_0101'), function () {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					})
				}
			})
		},

		// 批量上传
		uploadBatch: function () {
			let that = this
			let serverId = this.vServerId
			if (typeof serverId != "number" && typeof serverId != "string") {
				serverId = 0
			}
			teaweb.popup("/servers/certs/uploadBatchPopup?serverId=" + serverId, {
				title: this.$t('index_批量上传证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null) {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null) {
						that.policy.certRefs.$pushAll(resp.data.certRefs)
						that.policy.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 申请证书
		requestCert: function () {
			// 已经在证书中的域名
			let excludeServerNames = []
			if (this.policy != null && this.policy.certs.length > 0) {
				this.policy.certs.forEach(function (cert) {
					excludeServerNames.$pushAll(cert.dnsNames)
				})
			}

			let that = this
			teaweb.popup("/servers/server/settings/https/requestCertPopup?serverId=" + this.vServerId + "&excludeServerNames=" + excludeServerNames.join(","), {
				title: this.$t('index_申请免费证书_0101'),
				callback: function () {
					that.policy.certRefs.push(resp.data.certRef)
					that.policy.certs.push(resp.data.cert)
				}
			})
		},

		// 更多选项
		changeOptionsVisible: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},

		// 格式化时间
		formatTime: function (timestamp) {
			return new Date(timestamp * 1000).format("Y-m-d")
		},

		// 格式化加密套件
		formatCipherSuite: function (cipherSuite) {
			return cipherSuite.replace(/(AES|3DES)/, "<var style=\"font-weight: bold\">$1</var>")
		},

		// 添加单个套件
		addCipherSuite: function (cipherSuite) {
			if (!this.policy.cipherSuites.$contains(cipherSuite)) {
				this.policy.cipherSuites.push(cipherSuite)
			}
			this.allCipherSuites.$removeValue(cipherSuite)
		},

		// 删除单个套件
		removeCipherSuite: function (cipherSuite) {
			let that = this
			teaweb.confirm(this.$t('index_确定要删除此套件吗？_0101'), function () {
				that.policy.cipherSuites.$removeValue(cipherSuite)
				that.allCipherSuites = window.SSL_ALL_CIPHER_SUITES.$findAll(function (k, v) {
					return !that.policy.cipherSuites.$contains(v)
				})
			})
		},

		// 清除所选套件
		clearCipherSuites: function () {
			let that = this
			teaweb.confirm(this.$t('index_确定要清除所有已选套件吗？_0101'), function () {
				that.policy.cipherSuites = []
				that.allCipherSuites = window.SSL_ALL_CIPHER_SUITES.$copy()
			})
		},

		// 批量添加套件
		addBatchCipherSuites: function (suites) {
			var that = this
			teaweb.confirm(this.$t('index_确定要批量添加套件？_0101'), function () {
				suites.$each(function (k, v) {
					if (that.policy.cipherSuites.$contains(v)) {
						return
					}
					that.policy.cipherSuites.push(v)
				})
			})
		},

		/**
		 * 套件拖动排序
		 */
		sortableCipherSuites: function () {
			var box = document.querySelector(".cipher-suites-box")
			Sortable.create(box, {
				draggable: ".label",
				handle: ".icon.handle",
				onStart: function () {

				},
				onUpdate: function (event) {

				}
			})
		},

		// 显示所有套件
		showAllCipherSuites: function () {
			this.cipherSuitesVisible = !this.cipherSuitesVisible
		},

		// 显示HSTS更多选项
		showMoreHSTS: function () {
			this.hstsOptionsVisible = !this.hstsOptionsVisible;
			if (this.hstsOptionsVisible) {
				this.changeHSTSMaxAge()
			}
		},

		// 监控HSTS有效期修改
		changeHSTSMaxAge: function () {
			var v = parseInt(this.hstsMaxAgeString)
			if (isNaN(v) || v < 0) {
				this.hsts.maxAge = 0
				this.hsts.days = "-"
				return
			}
			this.hsts.maxAge = v
			this.hsts.days = v / 86400
			if (this.hsts.days == 0) {
				this.hsts.days = "-"
			}
		},

		// 设置HSTS有效期
		setHSTSMaxAge: function (maxAge) {
			this.hstsMaxAgeString = maxAge.toString()
			this.changeHSTSMaxAge()
		},

		// 添加HSTS域名
		addHstsDomain: function () {
			this.hstsDomainAdding = true
			this.hstsDomainEditingIndex = -1
			let that = this
			setTimeout(function () {
				that.$refs.addingHstsDomain.focus()
			}, 100)
		},

		// 修改HSTS域名
		editHstsDomain: function (index) {
			this.hstsDomainEditingIndex = index
			this.addingHstsDomain = this.hsts.domains[index]
			this.hstsDomainAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingHstsDomain.focus()
			}, 100)
		},

		// 确认HSTS域名添加
		confirmAddHstsDomain: function () {
			this.addingHstsDomain = this.addingHstsDomain.trim()
			if (this.addingHstsDomain.length == 0) {
				return;
			}
			if (this.hstsDomainEditingIndex > -1) {
				this.hsts.domains[this.hstsDomainEditingIndex] = this.addingHstsDomain
			} else {
				this.hsts.domains.push(this.addingHstsDomain)
			}
			this.cancelHstsDomainAdding()
		},

		// 取消HSTS域名添加
		cancelHstsDomainAdding: function () {
			this.hstsDomainAdding = false
			this.addingHstsDomain = ""
			this.hstsDomainEditingIndex = -1
		},

		// 删除HSTS域名
		removeHstsDomain: function (index) {
			this.cancelHstsDomainAdding()
			this.hsts.domains.$remove(index)
		},

		// 选择客户端CA证书
		selectClientCACert: function () {
			let that = this
			teaweb.popup("/servers/certs/selectPopup?isCA=1", {
				width: "50em",
				height: "30em",
				title: this.$t('index_选择客户端CA证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null && resp.data.certRef != null) {
						that.policy.clientCARefs.push(resp.data.certRef)
						that.policy.clientCACerts.push(resp.data.cert)
					}
					if (resp.data.certs != null && resp.data.certRefs != null) {
						that.policy.clientCARefs.$pushAll(resp.data.certRefs)
						that.policy.clientCACerts.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 上传CA证书
		uploadClientCACert: function () {
			let that = this
			teaweb.popup("/servers/certs/uploadPopup?isCA=1", {
				height: "28em",
				title: this.$t('index_上传CA证书_0101'),
				callback: function (resp) {
					teaweb.success(this.$t('index_上传成功_0101'), function () {
						that.policy.clientCARefs.push(resp.data.certRef)
						that.policy.clientCACerts.push(resp.data.cert)
					})
				}
			})
		},

		// 删除客户端CA证书
		removeClientCACert: function (index) {
			let that = this
			teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
				that.policy.clientCARefs.$remove(index)
				that.policy.clientCACerts.$remove(index)
			})
		}
	},
	template: `<div>
	<div class="config-section ui form">
		<div class="section-title">
			<i class="icon shield alternate"></i>
			<span>{{$t('index_SSL/TLS相关配置_0101')}}</span>
		</div>
		
		<input type="hidden" name="sslPolicyJSON" :value="JSON.stringify(policy)"/>
		
		<div class="config-item" v-show="vProtocol == 'https'">
			<div class="item-label">{{$t('index_启用HTTP/2_0101')}}</div>
			<div class="item-content">
				<p-switch v-model="policy.http2Enabled" binary></p-switch>
			</div>
		</div>
		
		<div class="config-item" v-show="vProtocol == 'https' && vSupportHttp3">
			<div class="item-label">{{$t('index_启用HTTP/3_0101')}}</div>
			<div class="item-content">
				<p-switch v-model="policy.http3Enabled" binary></p-switch>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('index_设置证书_0101')}}</div>
			<div class="item-content">
				<div v-if="policy.certs != null && policy.certs.length > 0">
					<div class="ui label small basic" v-for="(cert, index) in policy.certs" style="margin-top: 0.2em">
						{{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeCert(index)"><i class="icon remove"></i></a>
					</div>
					<div class="ui divider"></div>
				</div>
				<div v-else>
					<span class="red">{{$t('index_选择或上传证书后_0101')}}<span v-if="vProtocol == 'https'">HTTPS</span><span v-if="vProtocol == 'tls'">TLS</span>{{$t('index_服务才能生效_0101')}}。</span>
					<div class="ui divider"></div>
				</div>
				<button class="ui button tiny" type="button" @click.prevent="selectCert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
				<span class="disabled">|</span> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="uploadCert()">{{$t('index_上传新证书_0101')}}</button> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="uploadBatch()">{{$t('index_批量上传证书_0101')}}</button> &nbsp;
				<span class="disabled">|</span> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="requestCert()" v-if="vServerId != null && vServerId > 0">{{$t('index_申请免费证书_0101')}}</button>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('index_TLS最低版本_0101')}}</div>
			<div class="item-content">
				<b-select v-model="policy.minVersion" :options="[
					...allVersions.map(version => ({label: version, value: version})),
				]"></b-select>
			</div>
		</div>
	</div>
	
	<div>
		<!-- 加密套件 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon key"></i>
				<span>{{$t('index_加密算法套件_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_自定义加密套件_0101')}}</div>
				<div class="item-content">
					<div class="ui checkbox">
						<p-switch v-model="policy.cipherSuitesIsOn" binary></p-switch>
						<label>{{$t('index_是否要自定义_0101')}}</label>
					</div>
					<div v-show="policy.cipherSuitesIsOn">
						<div class="ui divider"></div>
						<div class="cipher-suites-box">
							{{$t('index_已添加套件_0101')}}({{policy.cipherSuites.length}})：
							<div v-for="cipherSuite in policy.cipherSuites" class="ui label tiny basic" style="margin-bottom: 0.5em">
								<input type="hidden" name="cipherSuites" :value="cipherSuite"/>
								<span v-html="formatCipherSuite(cipherSuite)"></span> &nbsp; <a href="" title="删除套件" @click.prevent="removeCipherSuite(cipherSuite)"><i class="icon remove"></i></a>
								<a href="" title="拖动改变顺序"><i class="icon bars handle"></i></a>
							</div>
						</div>
						<div>
							<div class="ui divider"></div>
							<span v-if="policy.cipherSuites.length > 0"><a href="" @click.prevent="clearCipherSuites()">[{{$t('index_清除所有已选套件_0101')}}]</a> &nbsp; </span>
							<a href="" @click.prevent="addBatchCipherSuites(modernCipherSuites)">[{{$t('index_添加推荐套件_0101')}}]</a> &nbsp;
							<a href="" @click.prevent="addBatchCipherSuites(intermediateCipherSuites)">[{{$t('index_添加兼容套件_0101')}}]</a>
							<div class="ui divider"></div>
						</div>
		
						<div class="cipher-all-suites-box">
							<a href="" @click.prevent="showAllCipherSuites()"><span v-if="policy.cipherSuites.length == 0">{{$t('index_所有_0101')}}</span>{{$t('index_可选套件_0101')}}({{allCipherSuites.length}}) <i class="icon angle" :class="{down:!cipherSuitesVisible, up:cipherSuitesVisible}"></i></a>
							<a href="" v-if="cipherSuitesVisible" v-for="cipherSuite in allCipherSuites" class="ui label tiny" title="点击添加到自定义套件中" @click.prevent="addCipherSuite(cipherSuite)" v-html="formatCipherSuite(cipherSuite)" style="margin-bottom:0.5em"></a>
						</div>
						<p class="comment" v-if="cipherSuitesVisible">{{$t('index_点击可选套件添加_0101')}}。</p>
					</div>
				</div>
			</div>
		</div>
		
		<!-- HSTS -->
		<div class="config-section" v-show="vProtocol == 'https'">
			<div class="section-title">
				<i class="icon lock"></i>
				<span>{{$t('index_HSTS设置_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_开启HSTS_0101')}}</div>
				<div class="item-content">
					<p-switch name="hstsOn" v-model="hsts.isOn" value="1" binary></p-switch>
					<p class="comment">{{$t('index_开启后，会自动在响应Header中加入_0101')}}<span class="ui label small">Strict-Transport-Security:<var v-if="!hsts.isOn">...</var><var v-if="hsts.isOn"><span>max-age=</span>{{hsts.maxAge}}</var><var v-if="hsts.isOn && hsts.includeSubDomains">; includeSubDomains</var><var v-if="hsts.isOn && hsts.preload">; preload</var></span><span v-if="hsts.isOn"><a href="" @click.prevent="showMoreHSTS()">修改<i class="icon angle" :class="{down:!hstsOptionsVisible, up:hstsOptionsVisible}"></i> </a></span></p>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS有效时间_0101')}}</div>
				<div class="item-content">
					<div class="ui fields inline">
						<div class="ui field">
							<input class="ui input" type="text" name="hstsMaxAge" v-model="hstsMaxAgeString" maxlength="10" size="10" @input="changeHSTSMaxAge()"/>
						</div>
						<div class="ui field">
							{{$t('index_秒_0101')}}
						</div>
						<div class="ui field">{{hsts.days}} {{$t('index_天_0101')}}</div>
					</div>
					<p class="comment"><a href="" @click.prevent="setHSTSMaxAge(31536000)" :class="{active:hsts.maxAge == 31536000}">[1年/365天]</a> &nbsp; &nbsp;<a href="" @click.prevent="setHSTSMaxAge(15768000)" :class="{active:hsts.maxAge == 15768000}">[6个月/182.5天]</a> &nbsp;  &nbsp;<a href="" @click.prevent="setHSTSMaxAge(2592000)"  :class="{active:hsts.maxAge == 2592000}">[1个月/30天]</a></p>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_包含子域名_0101')}}</div>
				<div class="item-content">
					<p-checkbox name="hstsIncludeSubDomains" value="1" v-model="hsts.includeSubDomains" binary></p-checkbox>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS预加载_0101')}}</div>
				<div class="item-content">
					<p-checkbox name="hstsPreload" value="1" v-model="hsts.preload" binary></p-checkbox>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS生效的域名_0101')}}</div>
				<div class="item-content">
					<div class="names-box">
					<span class="ui label tiny basic" v-for="(domain, arrayIndex) in hsts.domains" :class="{blue:hstsDomainEditingIndex == arrayIndex}">{{domain}}
						<input type="hidden" name="hstsDomains" :value="domain"/> &nbsp;
						<a href="" @click.prevent="editHstsDomain(arrayIndex)" title="修改"><i class="icon pencil"></i></a>
						<a href="" @click.prevent="removeHstsDomain(arrayIndex)" title="删除"><i class="icon remove"></i></a>
					</span>
					</div>
					<div class="ui fields inline" v-if="hstsDomainAdding" style="margin-top:0.8em">
						<div class="ui field">
							<input type="text" name="addingHstsDomain" ref="addingHstsDomain" style="width:16em" maxlength="100" :placeholder="$t('index_域名，比如')" @keyup.enter="confirmAddHstsDomain()" @keypress.enter.prevent="1" v-model="addingHstsDomain" />
						</div>
						<div class="ui field">
							<button class="ui button tiny" type="button" @click="confirmAddHstsDomain()">{{$t('index_确定_0101')}}</button>
							&nbsp; <a href="" @click.prevent="cancelHstsDomainAdding()">{{$t('index_取消_0101')}}</a>
						</div>
					</div>
					<div class="ui field" style="margin-top: 1em">
						<button class="ui button tiny" type="button" @click="addHstsDomain()">+</button>
					</div>
					<p class="comment">{{$t('index_如果没有设置域名的话，则默认支持所有的域名_0101')}}。</p>
				</div>
			</div>
		</div>
		
		<!-- OCSP -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon check circle"></i>
				<span>{{$t('index_OCSP设置_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-content">
					<checkbox name="ocspIsOn" v-model="policy.ocspIsOn" binary>OCSP Stapling</checkbox>
					<p class="comment">{{$t('index_选中表示启用OCSP Stapling_0101')}}。</p>
				</div>
			</div>
		</div>
		
		<!-- 客户端认证 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon user shield"></i>
				<span>{{$t('index_客户端认证_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_客户端认证方式_0101')}}</div>
				<div class="item-content">
					<b-select v-model="policy.clientAuthType" :options="[
						...allClientAuthTypes.map(authType => ({label: authType.name, value: authType.type})),
					]"></b-select>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_客户端认证CA证书_0101')}}</div>
				<div class="item-content">
					<div v-if="policy.clientCACerts != null && policy.clientCACerts.length > 0">
						<div class="ui label small basic" v-for="(cert, index) in policy.clientCACerts">
							{{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeClientCACert()"><i class="icon remove"></i></a>
						</div>
						<div class="ui divider"></div>
					</div>
					<button class="ui button tiny" type="button" @click.prevent="selectClientCACert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
					<button class="ui button tiny" type="button" @click.prevent="uploadClientCACert()">{{$t('index_上传新证书_0101')}}</button>
					<p class="comment">{{$t('index_用来校验客户端证书以增强安全性_0101')}}，{{$t('index_通常不需要设置_0101')}}。</p>
				</div>
			</div>
		</div>
	</div>
	
	<div class="margin"></div>
</div>`
})

// 访问控制（认证）管理组件（封装认证配置页面，风格与compression-details-box.js一致）
Vue.component("auth-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      authConfig: null,
      isLoading: false,
      authWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getAuthConfig()
    }, 10)
  },
  methods: {
    // 获取认证配置
    async getAuthConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/access'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.authConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false
          }
        }
        if (config.policyRefs == null) {
          config.policyRefs = []
        }
        this.authConfig = config
        this.authWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存认证配置
    async saveAuthConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/access'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.authWebId,
        authJSON: JSON.stringify(this.authConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('http-auth-config-box@保存成功'))
        this.getAuthConfig()
      })
    },
    // 认证方式变更时自动保存
    changeMethods(config) {
      this.authConfig = config
      this.saveAuthConfig()
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" @submit.prevent="saveAuthConfig" ref="authForm">
        <http-auth-config-box :key="key" v-if="authConfig" :v-auth-config="authConfig" @change="changeMethods"></http-auth-config-box>
        <submit-btn></submit-btn>
      </form>
    </a-spin>
  `
}) 

// HTTP服务设置组件
Vue.component("http-config-box", {
  props: ["serverId"],
  data: function () {
    return {
      webId: "",
      serverType: "",
      httpConfig: {
        isOn: false,
        addresses: []
      },
      redirectToHTTPSConfig: {},
      conflictingPorts: [],
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/http'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        // 保存子组件的展开状态
        let wasExpanded = false
        if (this.$refs.httpRedirectToHttpsBox) {
          wasExpanded = this.$refs.httpRedirectToHttpsBox.saveExpandedState()
        }
        
        this.webId = resp.data.webId
        this.serverType = resp.data.serverType
        this.$set(this, 'httpConfig', resp.data.httpConfig)
        this.$set(this, 'redirectToHTTPSConfig', resp.data.redirectToHTTPSConfig)
        this.conflictingPorts = [...resp.data.conflictingPorts]
        this.$forceUpdate()
        this.key++
        
        // 恢复子组件的展开状态
        this.$nextTick(() => {
          if (this.$refs.httpRedirectToHttpsBox) {
            this.$refs.httpRedirectToHttpsBox.restoreExpandedState(wasExpanded)
          }
        })
        
        this.isLoading = false
      })
    },
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    async updateData() {
      const path = '/servers/server/settings/http'
      let csrfToken = await this.getCsrfToken()
      let redirectToHTTPSJSON = this.$refs.httpRedirectToHttpsBox.redirectToHttpsConfig
      this.$set(this, 'redirectToHTTPSConfig', redirectToHTTPSJSON)
      const params = {
        serverId: this.serverId,
        webId: this.webId,
        serverType: this.serverType,
        isOn: this.httpConfig.isOn ? 1 : 0,
        addresses: JSON.stringify(this.httpConfig.addresses),
        redirectToHTTPSJSON: JSON.stringify(redirectToHTTPSJSON),
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    submit: function () {
      this.$emit('submit')
    }
  },
  template: `
    <a-spin :spinning="isLoading" :key="key" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-server"></i>
        {{$t('index_HTTP服务设置_0101')}}
      </div>
      <form class="ui form" method="post" data-tea-action="$" data-tea-success="success">
        <input type="hidden" name="serverId" :value="serverId"/>
        <input type="hidden" name="webId" :value="webId"/>
        <input type="hidden" name="serverType" :value="serverType"/>
        <div class="x-form-item">
          <div class="x-form-label">{{$t('index_启用HTTP_0101')}}</div>
          <div class="x-form-content">
            <checkbox class="x-checkbox" name="isOn" :v-value="1" v-model="httpConfig.isOn" @change="updateData"></checkbox>
          </div>
        </div>
        <div v-show="httpConfig.isOn">
          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_绑定端口_0101')}} *</div>
            <div class="x-form-content">
              <div v-if="httpConfig.isOn && (httpConfig.addresses == null || httpConfig.addresses.length == 0)" class="ui message warning">
                <i class="pi pi-exclamation-triangle"></i>
                {{$t('index_还没有添加端口绑定_0101')}}，{{$t('index_会导致HTTP服务无法访问_0101')}}。
              </div>
              <network-addresses-box :v-server-type="serverType" :v-addresses="httpConfig.addresses" :v-protocol="'http'" @change="updateData"></network-addresses-box>
              <p v-if="conflictingPorts.length > 0" class="ui message error">
                <i class="pi pi-times-circle"></i>
                {{$t('index_配置错误_0101')}}：<span v-for="(port, index) in conflictingPorts">{{port}}<span v-if="index != conflictingPorts.length - 1">、</span></span><span v-if="conflictingPorts.length > 1">{{$t('index_等_0101')}}</span>{{$t('index_端口同HTTPS设置的端口冲突_0101')}}，{{$t('index_请删除HTTP或HTTPS中的相关端口_0101')}}。
              </p>
            </div>
          </div>
          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_自动跳转到HTTPS_0101')}}</div>
            <div class="x-form-content">
              <http-redirect-to-https-box ref="httpRedirectToHttpsBox" :v-redirect-to-https-config="redirectToHTTPSConfig" @change="updateData"></http-redirect-to-https-box>
            </div>
          </div>
        </div>
      </form>
    </a-spin>
  `
}) 

// 流量限制配置组件（封装流量限制配置页面，风格与request-limit-details-box.js一致）
Vue.component("traffic-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      trafficLimitConfig: null,
      isLoading: false,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取流量限制配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/traffic'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.trafficLimitConfig
        if (config == null) {
          config = {
            isOn: false,
            dailySize: {
              count: -1,
              unit: "gb"
            },
            monthlySize: {
              count: -1,
              unit: "gb"
            },
            totalSize: {
              count: -1,
              unit: "gb"
            },
            noticePageBody: ""
          }
        }
        if (config.dailySize == null) {
          config.dailySize = {
            count: -1,
            unit: "gb"
          }
        }
        if (config.monthlySize == null) {
          config.monthlySize = {
            count: -1,
            unit: "gb"
          }
        }
        if (config.totalSize == null) {
          config.totalSize = {
            count: -1,
            unit: "gb"
          }
        }

        this.$set(this, 'trafficLimitConfig', config)
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(value) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/traffic'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        trafficLimitJSON: JSON.stringify(value)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div class="hls-config-container">
          <div class="config-section">
            <div class="section-title">{{$t("traffic@流量限制配置")}}</div>
            <form method="post" class="ui form">
              <traffic-limit-config-box
                :key="key"
                :v-traffic-limit="trafficLimitConfig"
                @submit="saveConfig">
              </traffic-limit-config-box>
            </form>
          </div>
        </div>
      </a-spin>
    </div>
  `
}) 

// HTTPS服务设置组件
Vue.component("https-config-box", {
  props: [
    "serverId",
  ],
  data: function () {
    return {
      isLoading: false,
      config: {},
      policy: {},
      // hsts
      hsts: {
        isOn: false,
        maxAge: 31536000,
        includeSubDomains: false,
        preload: false,
        domains: []
      },
      hstsOptionsVisible: false,
      hstsDomainAdding: false,
      hstsMaxAgeString: "31536000",
      addingHstsDomain: "",
      hstsDomainEditingIndex: -1,
      // 相关数据
      allVersions: ['TLS 1.0', 'TLS 1.1', 'TLS 1.2', 'TLS 1.3'],
      SSL_ALL_CIPHER_SUITES: [
        "TLS_RSA_WITH_RC4_128_SHA",
        "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
        "TLS_RSA_WITH_AES_128_CBC_SHA",
        "TLS_RSA_WITH_AES_256_CBC_SHA",
        "TLS_RSA_WITH_AES_128_CBC_SHA256",
        "TLS_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_RC4_128_SHA",
        "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
        "TLS_AES_128_GCM_SHA256",
        "TLS_AES_256_GCM_SHA384",
        "TLS_CHACHA20_POLY1305_SHA256"
      ],
      allCipherSuites: [
        "TLS_RSA_WITH_RC4_128_SHA",
        "TLS_RSA_WITH_3DES_EDE_CBC_SHA",
        "TLS_RSA_WITH_AES_128_CBC_SHA",
        "TLS_RSA_WITH_AES_256_CBC_SHA",
        "TLS_RSA_WITH_AES_128_CBC_SHA256",
        "TLS_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_RC4_128_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_RC4_128_SHA",
        "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA",
        "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA",
        "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
        "TLS_AES_128_GCM_SHA256",
        "TLS_AES_256_GCM_SHA384",
        "TLS_CHACHA20_POLY1305_SHA256"
      ],
      modernCipherSuites: [
        "TLS_AES_128_GCM_SHA256",
        "TLS_CHACHA20_POLY1305_SHA256",
        "TLS_AES_256_GCM_SHA384",
        "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384"
      ],
      intermediateCipherSuites: [
        "TLS_AES_128_GCM_SHA256",
        "TLS_CHACHA20_POLY1305_SHA256",
        "TLS_AES_256_GCM_SHA384",
        "TLS_ECDHE_RSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_ECDSA_WITH_CHACHA20_POLY1305",
        "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256",
        "TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384",
        "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256",
        "TLS_ECDHE_RSA_WITH_3DES_EDE_CBC_SHA",
        "TLS_RSA_WITH_3DES_EDE_CBC_SHA"
      ],
      allClientAuthTypes: [
        {
          "name": "不需要客户端证书",
          "requireCA": false,
          "type": 0
        },
        {
          "name": "请求客户端证书",
          "requireCA": true,
          "type": 1
        },
        {
          "name": "需要客户端证书，但不校验",
          "requireCA": true,
          "type": 2
        },
        {
          "name": "有客户端证书的时候才校验",
          "requireCA": true,
          "type": 3
        },
        {
          "name": "校验客户端提供的证书",
          "requireCA": true,
          "type": 4
        }
      ],
      cipherSuitesVisible: false,
      // 高级选项
      moreOptionsVisible: true,
      serverType: '',
      httpsConfig: {},
      missingCertServerNames: [],
      conflictingPorts: [],
      key: 0
    }
  },
  watch: {
    hsts: {
      deep: true,
      handler: function () {
        this.policy.hsts = this.hsts
      }
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/https'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.$set(this, 'httpsConfig', resp.data.httpsConfig)
        this.$set(this, 'missingCertServerNames', [...resp.data.missingCertServerNames])
        this.$set(this, 'conflictingPorts', [...resp.data.conflictingPorts])
        this.$set(this, 'serverType', resp.data.serverType)

        let policy = this.httpsConfig.sslPolicy
        if (policy == null) {
          policy = {
            id: 0,
            isOn: true,
            certRefs: [],
            certs: [],
            clientCARefs: [],
            clientCACerts: [],
            clientAuthType: 0,
            minVersion: "TLS 1.1",
            hsts: null,
            cipherSuitesIsOn: false,
            cipherSuites: [],
            http2Enabled: true,
            http3Enabled: false,
            ocspIsOn: false
          }
        } else {
          if (policy.certRefs == null) {
            policy.certRefs = []
          }
          if (policy.certs == null) {
            policy.certs = []
          }
          if (policy.clientCARefs == null) {
            policy.clientCARefs = []
          }
          if (policy.clientCACerts == null) {
            policy.clientCACerts = []
          }
          if (policy.cipherSuites == null) {
            policy.cipherSuites = []
          }
        }

        let hsts = policy.hsts
        let hstsMaxAgeString = "31536000"
        if (hsts == null) {
          hsts = {
            isOn: false,
            maxAge: 31536000,
            includeSubDomains: false,
            preload: false,
            domains: []
          }
        }
        if (hsts.maxAge != null) {
          hstsMaxAgeString = hsts.maxAge.toString()
        }
        this.$set(this, 'policy', policy)
        this.hstsMaxAgeString = hstsMaxAgeString
        this.$set(this, 'config', this.httpsConfig)
        this.$set(this, 'hsts', hsts)
        this.isLoading = false
        this.key++
        this.$forceUpdate()
      })
    },
    async updateData() {
      const path = '/servers/server/settings/https'
      let csrfToken = await this.getCsrfToken()
      const sslPolicyJSON = {
        ...this.policy,
        certRefs: this.policy.certRefs.filter(Boolean),
        certs: this.policy.certs.filter(Boolean)
      }
      const params = {
        serverId: this.serverId,
        serverType: this.serverType,
        isOn: this.config.isOn ? 1 : 0,
        sslPolicyJSON: JSON.stringify(sslPolicyJSON),
        cipherSuites: JSON.stringify(this.policy.cipherSuites),
        hstsOn: this.hsts.isOn ? 1 : 0,
        hstsMaxAge: this.hsts.maxAge,
        hstsIncludeSubDomains: this.hsts.includeSubDomains ? 1 : 0,
        hstsPreload: this.hsts.preload ? 1 : 0,
        hstsDomains: JSON.stringify(this.hsts.domains),
        addingHstsDomain: this.addingHstsDomain,
        ocspIsOn: this.policy.ocspIsOn ? 1 : 0,
        addresses: JSON.stringify(this.config.addresses),
        csrfToken: csrfToken
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    // 下面方法全部从ssl-config-box迁移
    removeCert: function (index) {
      let that = this
      teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
        that.policy.certRefs.$remove(index)
        that.policy.certs.$remove(index)
        that.updateData()
      })
    },
    selectCert: function () {
      let that = this
      let selectedCertIds = []
      if (this.policy != null && this.policy.certs.length > 0) {
        this.policy.certs.forEach(function (cert) {
          selectedCertIds.push(cert.id.toString())
        })
      }
      let serverId = this.serverId
      if (serverId == null) {
        serverId = 0
      }
      teaweb.popup("/servers/certs/selectPopup?selectedCertIds=" + selectedCertIds + "&serverId=" + serverId, {
        width: "50em",
        height: "30em",
        title: this.$t('index_选择证书_0101'),
        callback: function (resp) {
          if (resp.data.cert != null && resp.data.certRef != null) {
            that.policy.certRefs.push(resp.data.certRef)
            that.policy.certs.push(resp.data.cert)
          }
          if (resp.data.certs != null && resp.data.certRefs != null) {
            that.policy.certRefs.$pushAll(resp.data.certRefs)
            that.policy.certs.$pushAll(resp.data.certs)
          }
          that.$forceUpdate()
          that.updateData()
        }
      })
    },
    uploadCert: function () {
      let that = this
      let serverId = this.serverId
      if (typeof serverId != "number" && typeof serverId != "string") {
        serverId = 0
      }
      teaweb.popup("/servers/certs/uploadPopup?serverId=" + serverId, {
        height: "30em",
        title: this.$t('index_上传证书_0101'),
        callback: function (resp) {
          teaweb.success(this.$t('index_上传成功_0101'), function () {
            that.policy.certRefs.push(resp.data.certRef)
            that.policy.certs.push(resp.data.cert)
            that.updateData()
          })
        }
      })
    },
    uploadBatch: function () {
      let that = this
      let serverId = this.serverId
      if (typeof serverId != "number" && typeof serverId != "string") {
        serverId = 0
      }
      teaweb.popup("/servers/certs/uploadBatchPopup?serverId=" + serverId, {
        title: this.$t('index_批量上传证书_0101'),
        callback: function (resp) {
          if (resp.data.cert != null) {
            that.policy.certRefs.push(resp.data.certRef)
            that.policy.certs.push(resp.data.cert)
          }
          if (resp.data.certs != null) {
            that.policy.certRefs.$pushAll(resp.data.certRefs)
            that.policy.certs.$pushAll(resp.data.certs)
          }
          that.$forceUpdate()
          that.updateData()
        }
      })
    },
    requestCert: function () {
      let excludeServerNames = []
      if (this.policy != null && this.policy.certs.length > 0) {
        this.policy.certs.forEach(function (cert) {
          excludeServerNames.$pushAll(cert.dnsNames)
        })
      }
      let that = this
      teaweb.popup("/servers/server/settings/https/requestCertPopup?serverId=" + this.serverId + "&excludeServerNames=" + excludeServerNames.join(","), {
        title: this.$t('index_申请免费证书_0101'),
        callback: function (resp) {
          that.policy.certRefs.push(resp.data.certRef)
          that.policy.certs.push(resp.data.cert)
          that.updateData()
        }
      })
    },
    changeOptionsVisible: function () {
      this.moreOptionsVisible = !this.moreOptionsVisible
    },
    formatTime: function (timestamp) {
      return new Date(timestamp * 1000).format("Y-m-d")
    },
    formatCipherSuite: function (cipherSuite) {
      return cipherSuite.replace(/(AES|3DES)/, "<var style=\"font-weight: bold\">$1</var>")
    },
    addCipherSuite: function (cipherSuite) {
      if (!this.policy.cipherSuites.$contains(cipherSuite)) {
        this.policy.cipherSuites.push(cipherSuite)
      }
      this.allCipherSuites.$removeValue(cipherSuite)
    },
    removeCipherSuite: function (cipherSuite) {
      let that = this
      teaweb.confirm(this.$t('index_确定要删除此套件吗？_0101'), function () {
        that.policy.cipherSuites.$removeValue(cipherSuite)
        that.allCipherSuites = that.SSL_ALL_CIPHER_SUITES.$findAll(function (k, v) {
          return !that.policy.cipherSuites.$contains(v)
        })
        that.updateData()
      })
    },
    clearCipherSuites: function () {
      let that = this
      teaweb.confirm(this.$t('index_确定要清除所有已选套件吗？_0101'), function () {
        that.policy.cipherSuites = []
        that.allCipherSuites = that.SSL_ALL_CIPHER_SUITES.$copy()
        that.updateData()
      })
    },
    addBatchCipherSuites: function (suites) {
      var that = this
      teaweb.confirm(this.$t('index_确定要批量添加套件？_0101'), function () {
        suites.$each(function (k, v) {
          if (that.policy.cipherSuites.$contains(v)) {
            return
          }
          that.policy.cipherSuites.push(v)
        })
        that.$forceUpdate()
        that.updateData()
      })
    },
    sortableCipherSuites: function () {
      setTimeout(() => {
        var box = document.querySelector(".cipher-suites-box")
        if (!box) return
        Sortable.create(box, {
          draggable: ".label",
          handle: ".icon.handle",
          onStart: function () { },
          onUpdate: function (event) { }
        })
      }, 100)

    },
    showAllCipherSuites: function () {
      this.cipherSuitesVisible = !this.cipherSuitesVisible
    },
    showMoreHSTS: function () {
      this.hstsOptionsVisible = !this.hstsOptionsVisible;
      if (this.hstsOptionsVisible) {
        this.changeHSTSMaxAge()
      }
    },
    changeHSTSMaxAge: function () {
      var v = parseInt(this.hstsMaxAgeString)
      if (isNaN(v) || v < 0) {
        this.hsts.maxAge = 0
        this.hsts.days = "-"
        return
      }
      this.hsts.maxAge = v
      this.hsts.days = v / 86400
      if (this.hsts.days == 0) {
        this.hsts.days = "-"
      }
    },
    setHSTSMaxAge: function (maxAge) {
      this.hstsMaxAgeString = maxAge.toString()
      this.changeHSTSMaxAge()
    },
    addHstsDomain: function () {
      this.hstsDomainAdding = true
      this.hstsDomainEditingIndex = -1
      let that = this
      setTimeout(function () {
        that.$refs.addingHstsDomain.focus()
      }, 100)
    },
    editHstsDomain: function (index) {
      this.hstsDomainEditingIndex = index
      this.addingHstsDomain = this.hsts.domains[index]
      this.hstsDomainAdding = true
      let that = this
      setTimeout(function () {
        that.$refs.addingHstsDomain.focus()
      }, 100)
    },
    confirmAddHstsDomain: function () {
      this.addingHstsDomain = this.addingHstsDomain.trim()
      if (this.addingHstsDomain.length == 0) {
        return;
      }
      if (this.hstsDomainEditingIndex > -1) {
        this.hsts.domains[this.hstsDomainEditingIndex] = this.addingHstsDomain
      } else {
        this.hsts.domains.push(this.addingHstsDomain)
      }
      this.cancelHstsDomainAdding()
      this.updateData()
    },
    cancelHstsDomainAdding: function () {
      this.hstsDomainAdding = false
      this.addingHstsDomain = ""
      this.hstsDomainEditingIndex = -1
    },
    removeHstsDomain: function (index) {
      this.cancelHstsDomainAdding()
      this.hsts.domains.$remove(index)
      this.updateData()
    },
    selectClientCACert: function () {
      let that = this
      teaweb.popup("/servers/certs/selectPopup?isCA=1", {
        width: "50em",
        height: "30em",
        title: this.$t('index_选择客户端CA证书_0101'),
        callback: function (resp) {
          if (resp.data.cert != null && resp.data.certRef != null) {
            that.policy.clientCARefs.push(resp.data.certRef)
            that.policy.clientCACerts.push(resp.data.cert)
          }
          if (resp.data.certs != null && resp.data.certRefs != null) {
            that.policy.clientCARefs.$pushAll(resp.data.certRefs)
            that.policy.clientCACerts.$pushAll(resp.data.certs)
          }
          that.$forceUpdate()
          that.updateData()
        }
      })
    },
    uploadClientCACert: function () {
      let that = this
      teaweb.popup("/servers/certs/uploadPopup?isCA=1", {
        height: "28em",
        title: this.$t('index_上传CA证书_0101'),
        callback: function (resp) {
          teaweb.success(this.$t('index_上传成功_0101'), function () {
            that.policy.clientCARefs.push(resp.data.certRef)
            that.policy.clientCACerts.push(resp.data.cert)
            that.updateData()
          })
        }
      })
    },
    removeClientCACert: function (index) {
      let that = this
      teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
        that.policy.clientCARefs.$remove(index)
        that.policy.clientCACerts.$remove(index)
        that.updateData()
      })
    },
    submit: function () {
      this.$emit('submit')
    }
  },
  template: `<div>
    <a-spin :spinning="isLoading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-lock"></i>
        {{$t('index_HTTPS服务设置_0101')}}
      </div>
      <form class="ui form" method="post">
        <input type="hidden" name="serverId" :value="serverId" />
        <input type="hidden" name="serverType" :value="serverType" />
        <div class="x-alert x-alert-warning"
          v-if="config.isOn && missingCertServerNames && missingCertServerNames.length > 0">
          <i class="pi pi-exclamation-triangle"></i>
          {{$t('index_警告_0101')}}：{{$t('index_当前网站绑定的以下域名尚未配置证书，将无法通过HTTPS协议访问_0101')}}：{{missingCertServerNames.join('、')}}
        </div>
        <div class="x-form-item">
          <div class="x-form-label">{{$t('index_启用HTTPS_0101')}}</div>
          <div class="x-form-content">
            <p-switch class="x-switch" name="isOn" v-model="config.isOn" value="1" binary @change="updateData"></p-switch>
          </div>
        </div>
        <div v-show="config.isOn">
          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_绑定端口_0101')}} *</div>
            <div class="x-form-content">
              <div v-if="config.isOn && (config.addresses == null || config.addresses.length == 0)"
                class="x-alert x-alert-warning">
                <i class="pi pi-exclamation-triangle"></i>
                {{$t('index_还没有添加端口绑定_0101')}}，{{$t('index_会导致HTTPS服务无法访问_0101')}}。
              </div>
              <network-addresses-box 
                :key="key"
                :v-server-type="serverType" 
                :v-addresses="config.addresses"
                :v-protocol="'https'"
                :v-conflicting-ports="conflictingPorts"
                @change="updateData"
              ></network-addresses-box>
              <p v-if="conflictingPorts.length > 0" class="x-alert x-alert-error">
                <i class="pi pi-times-circle"></i>
                {{$t('index_配置错误_0101')}}：<span v-for="(port, index) in conflictingPorts">{{port}}<span
                    v-if="index != conflictingPorts.length - 1">、</span></span><span v-if="conflictingPorts.length > 1">
                  {{$t('index_等_0101')}}</span>
                {{$t('index_端口同HTTP设置的端口冲突_0101')}}，{{$t('index_请删除HTTP或HTTPS中的相关端口_0101')}}。
              </p>
            </div>
          </div>
        </div>
        <!-- SSL配置区，直接搬运ssl-config-box的内容 -->
        <div v-show="config.isOn">
          <a-collapse accordion @change="sortableCipherSuites" :key="key">
            <a-collapse-panel :header="$t('index_SSL/TLS相关配置_0101')" key="ssl">
              <div class="config-section ui form">
                <input type="hidden" name="sslPolicyJSON" :value="JSON.stringify(policy)"/>
                <div class="config-item">
                  <div class="item-label">{{$t('index_启用HTTP/2_0101')}}</div>
                  <div class="item-content">
                    <p-switch v-model="policy.http2Enabled" binary @change="updateData"></p-switch>
                  </div>
                </div>
                
                <div class="config-item" v-show="httpsConfig.supportsHTTP3">
                  <div class="item-label">{{$t('index_启用HTTP/3_0101')}}</div>
                  <div class="item-content">
                    <p-switch v-model="policy.http3Enabled" binary @change="updateData"></p-switch>
                  </div>
                </div>
                <div class="config-item">
                  <div class="item-label">{{$t('index_设置证书_0101')}}</div>
                  <div class="item-content">
                    <div v-if="policy.certs != null && policy.certs.length > 0">
                      <div class="ui label small basic" v-for="(cert, index) in policy.certs" style="margin-top: 0.2em">
                        {{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeCert(index)"><i class="icon remove"></i></a>
                      </div>
                      <div class="ui divider"></div>
                    </div>
                    <div v-else>
                      <span class="red">{{$t('index_选择或上传证书后_0101')}}HTTPS{{$t('index_服务才能生效_0101')}}。</span>
                      <div class="ui divider"></div>
                    </div>
                    <button class="ui button tiny" type="button" @click.prevent="selectCert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
                    <span class="disabled">|</span> &nbsp;
                    <button class="ui button tiny" type="button" @click.prevent="uploadCert()">{{$t('index_上传新证书_0101')}}</button> &nbsp;
                    <button class="ui button tiny" type="button" @click.prevent="uploadBatch()">{{$t('index_批量上传证书_0101')}}</button> &nbsp;
                    <span class="disabled">|</span> &nbsp;
                    <button class="ui button tiny" type="button" @click.prevent="requestCert()" v-if="serverId != null && serverId > 0">{{$t('index_申请免费证书_0101')}}</button>
                  </div>
                </div>
                <div class="config-item">
                  <div class="item-label">{{$t('index_TLS最低版本_0101')}}</div>
                  <div class="item-content">
                    <b-select v-model="policy.minVersion" :options="[
                      ...allVersions.map(version => ({label: version, value: version})),
                    ]" @change="updateData"></b-select>
                  </div>
                </div>
              </div>
            </a-collapse-panel>
            <a-collapse-panel :header="$t('index_加密算法套件_0101')" key="cipher">
              <div class="config-section">
                <div class="config-item">
                  <div class="item-label">{{$t('index_自定义加密套件_0101')}}</div>
                  <div class="item-content">
                    <div class="ui checkbox">
                      <p-switch v-model="policy.cipherSuitesIsOn" binary @change="updateData"></p-switch>
                      <label>{{$t('index_是否要自定义_0101')}}</label>
                    </div>
                    <div v-show="policy.cipherSuitesIsOn">
                      <div class="ui divider"></div>
                      <div class="cipher-suites-box">
                        {{$t('index_已添加套件_0101')}}({{policy.cipherSuites.length}})：
                        <div v-for="cipherSuite in policy.cipherSuites" class="ui label tiny basic" style="margin-bottom: 0.5em">
                          <input type="hidden" name="cipherSuites" :value="cipherSuite"/>
                          <span v-html="formatCipherSuite(cipherSuite)"></span> &nbsp; <a href="" title="删除套件" @click.prevent="removeCipherSuite(cipherSuite)"><i class="icon remove"></i></a>
                          <a href="" title="拖动改变顺序"><i class="icon bars handle"></i></a>
                        </div>
                      </div>
                      <div>
                        <div class="ui divider"></div>
                        <span v-if="policy.cipherSuites.length > 0"><a href="" @click.prevent="clearCipherSuites()">[{{$t('index_清除所有已选套件_0101')}}]</a> &nbsp; </span>
                        <a href="" @click.prevent="addBatchCipherSuites(modernCipherSuites)">[{{$t('index_添加推荐套件_0101')}}]</a> &nbsp;
                        <a href="" @click.prevent="addBatchCipherSuites(intermediateCipherSuites)">[{{$t('index_添加兼容套件_0101')}}]</a>
                        <div class="ui divider"></div>
                      </div>
                      <div class="cipher-all-suites-box">
                        <a href="" @click.prevent="showAllCipherSuites()"><span v-if="policy.cipherSuites.length == 0">{{$t('index_所有_0101')}}</span>{{$t('index_可选套件_0101')}}({{allCipherSuites.length}}) <i class="icon angle" :class="{down:!cipherSuitesVisible, up:cipherSuitesVisible}"></i></a>
                        <a href="" v-if="cipherSuitesVisible" v-for="cipherSuite in allCipherSuites" class="ui label tiny" title="点击添加到自定义套件中" @click.prevent="addCipherSuite(cipherSuite)" v-html="formatCipherSuite(cipherSuite)" style="margin-bottom:0.5em"></a>
                      </div>
                      <p class="comment" v-if="cipherSuitesVisible">{{$t('index_点击可选套件添加_0101')}}。</p>
                    </div>
                  </div>
                </div>
              </div>
            </a-collapse-panel>
            <a-collapse-panel :header="$t('index_HSTS设置_0101')" key="hsts">
              <div class="config-section" v-show="config.isOn">
                <div class="config-item">
                  <div class="item-label">{{$t('index_开启HSTS_0101')}}</div>
                  <div class="item-content">
                    <p-switch name="hstsOn" v-model="hsts.isOn" value="1" binary @change="updateData"></p-switch>
                    <p class="comment">{{$t('index_开启后，会自动在响应Header中加入_0101')}}<span class="ui label small">Strict-Transport-Security:<var v-if="!hsts.isOn">...</var><var v-if="hsts.isOn"><span>max-age=</span>{{hsts.maxAge}}</var><var v-if="hsts.isOn && hsts.includeSubDomains">; includeSubDomains</var><var v-if="hsts.isOn && hsts.preload">; preload</var></span><span v-if="hsts.isOn"><a href="" @click.prevent="showMoreHSTS()">修改<i class="icon angle" :class="{down:!hstsOptionsVisible, up:hstsOptionsVisible}"></i> </a></span></p>
                  </div>
                </div>
                <div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
                  <div class="item-label">{{$t('index_HSTS有效时间_0101')}}</div>
                  <div class="item-content">
                    <div class="ui fields inline">
                      <div class="ui field">
                        <input class="ui input" type="text" name="hstsMaxAge" v-model="hstsMaxAgeString" maxlength="10" size="10" @input="changeHSTSMaxAge()" @blur="updateData"/>
                      </div>
                      <div class="ui field">
                        {{$t('index_秒_0101')}}
                      </div>
                      <div class="ui field">{{hsts.days}} {{$t('index_天_0101')}}</div>
                    </div>
                    <p class="comment"><a href="" @click.prevent="setHSTSMaxAge(31536000)" :class="{active:hsts.maxAge == 31536000}">[1年/365天]</a> &nbsp; &nbsp;<a href="" @click.prevent="setHSTSMaxAge(15768000)" :class="{active:hsts.maxAge == 15768000}">[6个月/182.5天]</a> &nbsp;  &nbsp;<a href="" @click.prevent="setHSTSMaxAge(2592000)"  :class="{active:hsts.maxAge == 2592000}">[1个月/30天]</a></p>
                  </div>
                </div>
                <div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
                  <div class="item-label">{{$t('index_包含子域名_0101')}}</div>
                  <div class="item-content">
                    <p-checkbox name="hstsIncludeSubDomains" value="1" v-model="hsts.includeSubDomains" binary @change="updateData"></p-checkbox>
                  </div>
                </div>
                <div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
                  <div class="item-label">{{$t('index_HSTS预加载_0101')}}</div>
                  <div class="item-content">
                    <p-checkbox name="hstsPreload" value="1" v-model="hsts.preload" binary @change="updateData"></p-checkbox>
                  </div>
                </div>
                <div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
                  <div class="item-label">{{$t('index_HSTS生效的域名_0101')}}</div>
                  <div class="item-content">
                    <div class="names-box">
                    <span class="ui label tiny basic" v-for="(domain, arrayIndex) in hsts.domains" :class="{blue:hstsDomainEditingIndex == arrayIndex}">{{domain}}
                      <input type="hidden" name="hstsDomains" :value="domain"/> &nbsp;
                      <a href="" @click.prevent="editHstsDomain(arrayIndex)" title="修改"><i class="icon pencil"></i></a>
                      <a href="" @click.prevent="removeHstsDomain(arrayIndex)" title="删除"><i class="icon remove"></i></a>
                    </span>
                    </div>
                    <div class="ui fields inline" v-if="hstsDomainAdding" style="margin-top:0.8em">
                      <div class="ui field">
                        <input type="text" name="addingHstsDomain" ref="addingHstsDomain" style="width:16em" maxlength="100" :placeholder="$t('index_域名，比如')" @keyup.enter="confirmAddHstsDomain()" @keypress.enter.prevent="1" v-model="addingHstsDomain" />
                      </div>
                      <div class="ui field">
                        <button class="ui button tiny" type="button" @click="confirmAddHstsDomain()">{{$t('index_确定_0101')}}</button>
                        &nbsp; <a href="" @click.prevent="cancelHstsDomainAdding()">{{$t('index_取消_0101')}}</a>
                      </div>
                    </div>
                    <div class="ui field" style="margin-top: 1em">
                      <button class="ui button tiny" type="button" @click="addHstsDomain()">+</button>
                    </div>
                    <p class="comment">{{$t('index_如果没有设置域名的话，则默认支持所有的域名_0101')}}。</p>
                  </div>
                </div>
              </div>
            </a-collapse-panel>
            <a-collapse-panel :header="$t('index_OCSP设置_0101')" key="ocsp">
              <div class="config-section">
                <div class="config-item">
                  <div class="item-content">
                    <checkbox name="ocspIsOn" @change="updateData" v-model="policy.ocspIsOn" binary>OCSP Stapling</checkbox>
                    <p class="comment">{{$t('index_选中表示启用OCSP Stapling_0101')}}。</p>
                  </div>
                </div>
              </div>
            </a-collapse-panel>
            <a-collapse-panel :header="$t('index_客户端认证_0101')" key="client">
              <div class="config-section">
                <div class="config-item">
                  <div class="item-label">{{$t('index_客户端认证方式_0101')}}</div>
                  <div class="item-content">
                    <b-select v-model="policy.clientAuthType" :options="[
                      ...allClientAuthTypes.map(authType => ({label: authType.name, value: authType.type})),
                    ]" @change="updateData"></b-select>
                  </div>
                </div>
                <div class="config-item">
                  <div class="item-label">{{$t('index_客户端认证CA证书_0101')}}</div>
                  <div class="item-content">
                    <div v-if="policy.clientCACerts != null && policy.clientCACerts.length > 0">
                      <div class="ui label small basic" v-for="(cert, index) in policy.clientCACerts">
                        {{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeClientCACert()"><i class="icon remove"></i></a>
                      </div>
                      <div class="ui divider"></div>
                    </div>
                    <button class="ui button tiny" type="button" @click.prevent="selectClientCACert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
                    <button class="ui button tiny" type="button" @click.prevent="uploadClientCACert()">{{$t('index_上传新证书_0101')}}</button>
                    <p class="comment">{{$t('index_用来校验客户端证书以增强安全性_0101')}}，{{$t('index_通常不需要设置_0101')}}。</p>
                  </div>
                </div>
              </div>
            </a-collapse-panel>
          </a-collapse>
        </div>
      </form>
    </a-spin>
  </div>`
}) 

// TCP配置组件（封装TCP配置页面，风格与udp-server-details-box.js一致）
Vue.component("tcp-server-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      tcpConfig: null,
      isLoading: false,
      serverType: "",
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取TCP配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/tcp'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.tcpConfig
        if (config == null) {
          config = {
            isOn: false,
            listen: []
          }
        }

        this.$set(this, 'tcpConfig', config)
        this.serverType = resp.data.serverType || ""
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig() {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/tcp'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        serverType: this.serverType,
        addresses: JSON.stringify(this.tcpConfig.listen)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('acme_users_index_js@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-exchange-alt"></i>
        {{$t('settings_tcp_index@TCP服务设置')}}
      </div>
      
      <div class="x-alert x-alert-info" v-if="tcpConfig && !tcpConfig.isOn">
        <i class="pi pi-info-circle"></i>
        {{$t('settings_tcp_index@当前TCP服务未启用，配置完端口后将自动启用')}}
      </div>

      <form class="x-form ui form" @submit.prevent="saveConfig">
        <input type="hidden" name="serverId" :value="serverId"/>
        <input type="hidden" name="serverType" :value="serverType"/>
        
        <div class="x-form-item">
          <div class="x-form-label">{{$t('绑定端口')}} *</div>
          <div class="x-form-content">
            <network-addresses-box 
              :key="key"
              v-if="!isLoading"
              :v-server-type="serverType" 
              :v-addresses="tcpConfig.listen" 
              :v-protocol="'tcp'" 
              @change="saveConfig"
              :v-support-range="true">
            </network-addresses-box>
          </div>
        </div>
      </form>
    </a-spin>
  `
}) 

// 统计配置组件（封装统计配置页面，风格与access-log-details-box.js一致）
Vue.component("stat-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      statConfig: null,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取统计配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/stat'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let stat = resp.data.statConfig
        if (stat == null) {
          stat = {
            isPrior: false,
            isOn: false
          }
        }
        this.$set(this, 'statConfig', stat)
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(value) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/stat'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        statJSON: JSON.stringify(value)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('stat_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('stat_index@网站分组')}}</a>{{$t('stat_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
        </div>

        <div :class="{'opacity-mask': hasGroupConfig}">
          <http-stat-config-box
            :key="key"
            :v-stat-config="statConfig"
            @submit="saveConfig">
          </http-stat-config-box>
        </div>
      </a-spin>
    </div>
  `
}) 

// DNS CNAME 解析设置组件
Vue.component("dns-cname-box", {
  props: ["serverId",],
  data: function () {
    return {
      server: {},
      dnsName: "",
      dnsDomain: "",
      supportCNAME: false,
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/dns'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        Object.assign(this.server, resp.data.server)
        this.dnsName = resp.data.dnsName
        this.dnsDomain = resp.data.dnsDomain
        this.supportCNAME = resp.data.supportCNAME
        this.key++
        this.isLoading = false
      })
    },
    async updateData() {
      const path = '/servers/server/settings/dns'
      let csrfToken = await this.getCsrfToken()
      const params = {
        serverId: this.serverId,
        dnsName: this.dnsName,
        dnsDomain: this.dnsDomain,
        supportCNAME: this.supportCNAME,
        csrfToken: csrfToken
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    async regenerateCNAME() {
      let serverId = this.serverId
      teaweb.confirm(this.$t('index_确定要重新生成此服务的CNAME吗？_0101'), async () => {
        const path = '/servers/server/settings/dns/regenerateCNAME'
        let csrfToken = await this.getCsrfToken()
        const params = {
          serverId: serverId,
          csrfToken: csrfToken
        }
        await window.Tea.Vue.$post(path).params(params).success((resp) => {
          this.$message.success(this.$t('index_保存成功_0101'))
          this.getData()
        })
      })
    },
    updateCNAME: function () {
      let that = this
      let serverId = this.serverId
      teaweb.popup("/servers/server/settings/dns/updateCNAMEPopup?serverId=" + serverId, {
        title: this.$t('index_修改服务CNAME_0101'),
        callback: function () {
          this.$message.success(that.$t('index_保存成功_0101'))
          that.getData()
        }
      })
    }
  },
  template: ` 
    <a-spin :spinning="isLoading" class="x-section" :key="key">
      <div class="x-section-title">
        <i class="pi pi-globe"></i>
        {{$t('index_DNS解析设置_0101')}}
      </div>
      <form class="ui form" method="post">
        <input type="hidden" name="serverId" :value="serverId"/>
        <div class="x-form-item">
          <div class="x-form-label">{{$t('index_当前网站CNAME_0101')}}</div>
          <div class="x-form-content">
            <a-tag>{{dnsName}}.<span v-if="dnsDomain.length > 0">{{dnsDomain}}</span><span v-else>{{$t('index_根域名_0101')}}</span></a-tag>
            <span class="ant-btn ant-btn-link" @click="regenerateCNAME()"><i class="pi pi-refresh"></i> {{$t('index_重新生成_0101')}}</span>
            <span class="ant-btn ant-btn-link" @click="updateCNAME()"><i class="pi pi-edit"></i> {{$t('index_手动修改_0101')}}</span>
            <div class="x-comment">{{$t('index_你需要为你的每个_0101')}}<a :href="'/servers/server/settings/serverNames?serverId=' + serverId">{{$t('index_网站域名_0101')}}</a>{{$t('index_设置一个CNAME解析_0101')}}，{{$t('index_值为上面内容_0101')}}。</div>
          </div>
        </div>
        <div class="x-form-item">
          <div class="x-form-label"></div>
          <div class="x-form-content">
            <checkbox class="x-checkbox" name="supportCNAME" :v-value="1" v-model="supportCNAME" @change="updateData">{{$t('index_支持任意域名CNAME_0101')}}</checkbox>
            <div class="x-comment">{{$t('index_选中后表示允许任意域名使用此服务的CNAME直接访问此服务_0101')}}。{{$t('index_需要节点服务器可以正确解析DNS记录_0101')}}。{{$t('index_在严格匹配域名时才会生效_0101')}}。{{$t('index_此选项可能导致安全问题_0101')}}，{{$t('index_请谨慎开启_0101')}}。</div>
          </div>
        </div>
      </form>
    </a-spin>
  `
}) 

// IP与地域管理组件，整合IP白名单、黑名单、灰名单、国家、省份、运营商等管理功能
Vue.component("ip-admin-box", {
  props: ["serverId"],
  data: function () {
    return {
      activeTab: 'white', // white, black, grey, country, province, provider
      isLoading: false,
      // IP白名单相关数据
      whiteListItems: [],
      whiteListFeatureIsOn: false,
      whiteListId: null,
      whiteListPage: {
        current: 1,
        total: 0,
        pageSize: 10,
        totalPages: 0
      },
      // IP黑名单相关数据
      blackListItems: [],
      blackListFeatureIsOn: false,
      blackListId: null,
      blackListPage: {
        current: 1,
        total: 0,
        pageSize: 10,
        totalPages: 0
      },
      // IP灰名单相关数据
      greyListItems: [],
      greyListFeatureIsOn: false,
      greyListId: null,
      greyListPage: {
        current: 1,
        total: 0,
        pageSize: 10,
        totalPages: 0
      },
      // 国家相关数据
      countryAllowed: [],
      countryDenied: [],
      countryExceptURLPatterns: [],
      countryOnlyURLPatterns: [],
      countryHTML: '',
      allowSearchEngine: false,
      countryFeatureIsOn: true,
      countryWafIsOn: true,
      countryMoreOptionsVisible: false,
      // 省份相关数据
      provinceAllowed: [],
      provinceDenied: [],
      provinceExceptURLPatterns: [],
      provinceOnlyURLPatterns: [],
      provinceHTML: '',
      provinceFeatureIsOn: true,
      provinceWafIsOn: true,
      provinceMoreOptionsVisible: false,
      // 运营商相关数据
      providerAllowed: [],
      providerDenied: [],
      providerExceptURLPatterns: [],
      providerOnlyURLPatterns: [],
      providerHTML: '',
      providerFeatureIsOn: true,
      providerWafIsOn: true,
      providerMoreOptionsVisible: false,
      greyListFeatureIsOn: false,
      greyListWafIsOn: false,
      firewallPolicyId: null
    }
  },
  mounted() {
    this.getWafConfig()
    this.loadWhiteList()
  },
  methods: {
    // 获取WAF配置
    async getWafConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/waf'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.firewallPolicyId = resp.data.firewallPolicyId || null
        this.wafIsOn = resp.data.wafIsOn !== false
        this.isLoading = false
      })
    },
    switchTab(tab) {
      this.activeTab = tab
      if (tab === 'white') {
        this.loadWhiteList()
      } else if (tab === 'black') {
        this.loadBlackList()
      } else if (tab === 'grey') {
        this.loadGreyList()
      } else if (tab === 'country') {
        this.loadCountry()
      } else if (tab === 'province') {
        this.loadProvince()
      } else if (tab === 'provider') {
        this.loadProvider()
      }
      // 其它tab可在此处扩展加载逻辑
    },
    // 页码获取 由于接口返回的分页是html，所以要解析html获取页码
    // 解析分页HTML，提取分页信息用于Antd表格
    parsePaginationFromHtml(html) {
      if (!html) {
        return {
          current: 1,
          total: 0,
          pageSize: 10
        }
      }

      // 提取当前页码 - 查找带有 active 类的链接
      let currentPage = 1
      const activePageMatch = html.match(/<a[^>]*class="[^"]*active[^"]*"[^>]*>(\d+)<\/a>/)
      if (activePageMatch) {
        currentPage = parseInt(activePageMatch[1]) || 1
      }

      // 提取总页数 - 查找"尾页"链接中的page参数
      let totalPages = 1
      const lastPageMatch = html.match(/<a[^>]*href="[^"]*page=(\d+)[^"]*"[^>]*>尾页<\/a>/)
      if (lastPageMatch) {
        totalPages = parseInt(lastPageMatch[1]) || 1
      } else {
        // 如果没有尾页链接，尝试找到所有数字页码链接中的最大值
        const pageMatches = html.match(/<a[^>]*href="[^"]*page=(\d+)[^"]*"[^>]*>(\d+)<\/a>/g)
        if (pageMatches) {
          pageMatches.forEach(match => {
            const pageNum = match.match(/page=(\d+)/)
            if (pageNum) {
              totalPages = Math.max(totalPages, parseInt(pageNum[1]) || 1)
            }
          })
        }
      }

      // 提取每页条数 - 查找选中的option
      let pageSize = 10
      const pageSizeMatch = html.match(/<option[^>]*value="(\d+)"[^>]*selected[^>]*>/)
      if (pageSizeMatch) {
        pageSize = parseInt(pageSizeMatch[1]) || 10
      }

      return {
        current: currentPage,
        total: totalPages * pageSize, // Antd需要的是总记录数，这里用总页数*每页条数估算
        pageSize: pageSize,
        totalPages: totalPages
      }
    },
    // 加载IP白名单数据
    async loadWhiteList() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/allowList')
        .params({ serverId: this.serverId, page: this.whiteListPage.current })
        .success((resp) => {
          this.whiteListItems = resp.data.items || []
          this.whiteListId = resp.data.listId
          this.whiteListPage = this.parsePaginationFromHtml(resp.data.page)
          this.whiteListFeatureIsOn = resp.data.featureIsOn !== false
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 加载IP黑名单数据
    async loadBlackList() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/denyList')
        .params({ serverId: this.serverId, page: this.blackListPage.current })
        .success((resp) => {
          this.blackListItems = resp.data.items || []
          this.blackListId = resp.data.listId
          this.blackListPage = this.parsePaginationFromHtml(resp.data.page)
          this.blackListFeatureIsOn = resp.data.featureIsOn !== false
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 加载IP灰名单数据
    async loadGreyList() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/greyList')
        .params({ serverId: this.serverId, page: this.greyListPage.current })
        .success((resp) => {
          this.greyListItems = resp.data.items || []
          this.greyListId = resp.data.listId
          this.greyListPage = this.parsePaginationFromHtml(resp.data.page)
          console.log("loadGreyList -> this.parsePaginationFromHtml(resp.data.page)", this.parsePaginationFromHtml(resp.data.page))
          this.greyListFeatureIsOn = resp.data.featureIsOn !== false
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 加载国家设置
    async loadCountry() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/countries')
        .params({ serverId: this.serverId, firewallPolicyId: this.firewallPolicyId })
        .success((resp) => {
          this.countryAllowed = resp.data.allowedCountries || []
          this.countryDenied = resp.data.deniedCountries || []
          this.countryExceptURLPatterns = resp.data.exceptURLPatterns || []
          this.countryOnlyURLPatterns = resp.data.onlyURLPatterns || []
          this.countryHTML = resp.data.countryHTML || ''
          this.allowSearchEngine = resp.data.allowSearchEngine || false
          this.countryFeatureIsOn = resp.data.featureIsOn !== false
          this.countryWafIsOn = resp.data.wafIsOn !== false
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 保存国家设置
    async saveCountry() {
      this.isLoading = true
      await window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/countries')
        .params({
          serverId: this.serverId,
          firewallPolicyId: this.firewallPolicyId,
          allowCountryIds: this.countryAllowed.map(country => country.id),
          denyCountryIds: this.countryDenied.map(country => country.id),
          exceptURLPatternsJSON: JSON.stringify(this.countryExceptURLPatterns),
          onlyURLPatternsJSON: JSON.stringify(this.countryOnlyURLPatterns),
          countryHTML: this.countryHTML,
          allowSearchEngine: this.allowSearchEngine
        })
        .success(() => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadCountry()
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 国家tab内事件
    changeAllowedCountries(event) {
      this.countryAllowed = event.countries
    },
    changeDeniedCountries(event) {
      this.countryDenied = event.countries
    },
    toggleCountryMoreOptions() {
      this.countryMoreOptionsVisible = !this.countryMoreOptionsVisible
    },
    // 添加IP（白名单）
    createWhiteIP() {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/iplists/createIPPopup?listId=${this.whiteListId}&type=white`, {
        title: '添加IP',
        height: '30em',
        callback: () => {
          this.$message.success('保存成功')
          this.loadWhiteList()
        }
      })
    },
    // 编辑IP（白名单）
    updateWhiteIP(itemId) {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/server/settings/waf/ipadmin/updateIPPopup?listId=${this.whiteListId}&itemId=${itemId}`, {
        height: '30em',
        title: this.$t('iplists@修改IP'),
        callback: () => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadWhiteList()
        }
      })
    },
    // 删除IP（白名单）
    deleteWhiteIP(itemId) {
      window.teaweb.confirm(this.$t('ipadmin_allowList@确定要删除这个IP吗'), async () => {
        window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/deleteIP')
          .params({ listId: this.whiteListId, itemId: itemId })
          .success(() => {
            this.$message.success(this.$t('iplists@删除成功'))
            this.loadWhiteList()
          })
      })

    },
    // 分页切换（白名单）
    changeWhiteListPage(page) {
      this.whiteListPage.current = page
      this.loadWhiteList()
    },
    // 添加IP（黑名单）
    createBlackIP() {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/iplists/createIPPopup?listId=${this.blackListId}&type=black`, {
        title: this.$t('iplists@添加IP'),
        height: '30em',
        callback: () => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadBlackList()
        }
      })
    },
    // 添加IP（灰名单）
    createGreyIP() {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/iplists/createIPPopup?listId=${this.greyListId}&type=grey`, {
        title: this.$t('iplists@添加IP'),
        height: '30em',
        callback: () => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadGreyList()
        }
      })
    },
    // 编辑IP（灰名单） 
    updateGreyIP(itemId) {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/server/settings/waf/ipadmin/updateIPPopup?listId=${this.greyListId}&itemId=${itemId}`, {
        height: '30em',
        callback: () => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadGreyList()
        }
      })
    },
    // 删除IP（灰名单）
    deleteGreyIP(itemId) {
      window.teaweb.confirm(this.$t('ipadmin_allowList@确定要删除这个IP吗'), async () => {
        window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/deleteIP')
          .params({ listId: this.greyListId, itemId: itemId })
          .success(() => {
            this.$message.success(this.$t('iplists@删除成功'))
            this.loadGreyList()
          })
      })
    },
    // 编辑IP（黑名单）
    updateBlackIP(itemId) {
      window.teaweb && window.teaweb.popup && window.teaweb.popup(`/servers/server/settings/waf/ipadmin/updateIPPopup?listId=${this.blackListId}&itemId=${itemId}`, {
        height: '30em',
        callback: () => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadBlackList()
        }
      })
    },
    // 删除IP（黑名单）
    deleteBlackIP(itemId) {
      window.teaweb.confirm(this.$t('ipadmin_allowList@确定要删除这个IP吗'), async () => {
        window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/deleteIP')
          .params({ listId: this.blackListId, itemId: itemId })
          .success(() => {
            this.$message.success(this.$t('iplists@删除成功'))
            this.loadBlackList()
          })
      })
    },
    // 分页切换（黑名单）
    changeBlackListPage(page) {
      this.blackListPage.current = page
      this.loadBlackList()
    },
    // 分页切换（灰名单）
    changeGreyListPage(page) {
      this.greyListPage.current = page
      this.loadGreyList()
    },
    // 加载省份设置
    async loadProvince() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/provinces')
        .params({ serverId: this.serverId, firewallPolicyId: this.firewallPolicyId })
        .success((resp) => {
          this.provinceAllowed = resp.data.allowedProvinces
          this.provinceDenied = resp.data.deniedProvinces
          this.provinceExceptURLPatterns = resp.data.exceptURLPatterns
          this.provinceOnlyURLPatterns = resp.data.onlyURLPatterns
          this.provinceHTML = resp.data.provinceHTML || ''
          this.provinceFeatureIsOn = resp.data.featureIsOn !== false
          this.provinceWafIsOn = resp.data.wafIsOn !== false
          this.$forceUpdate()
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 保存省份设置
    async saveProvince() {
      this.isLoading = true
      await window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/provinces')
        .params({
          serverId: this.serverId,
          firewallPolicyId: this.firewallPolicyId,
          allowProvinceIds: this.provinceAllowed.map(province => province.id),
          denyProvinceIds: this.provinceDenied.map(province => province.id),
          exceptURLPatternsJSON: JSON.stringify(this.provinceExceptURLPatterns),
          onlyURLPatternsJSON: JSON.stringify(this.provinceOnlyURLPatterns),
          provinceHTML: this.provinceHTML
        })
        .success(() => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadProvince()
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 省份tab内事件
    changeAllowedProvinces(event) {
      this.provinceAllowed = event.provinces
    },
    changeDeniedProvinces(event) {
      this.provinceDenied = event.provinces
    },
    toggleProvinceMoreOptions() {
      this.provinceMoreOptionsVisible = !this.provinceMoreOptionsVisible
    },
    // 加载运营商设置
    async loadProvider() {
      this.isLoading = true
      await window.Tea.Vue.$get('/servers/server/settings/waf/ipadmin/providers')
        .params({ serverId: this.serverId, firewallPolicyId: this.firewallPolicyId })
        .success((resp) => {
          this.providerAllowed = resp.data.allowedProviders || []
          console.log("loadProvider -> this.providerAllowed", this.providerAllowed)
          this.providerDenied = resp.data.deniedProviders || []
          this.providerExceptURLPatterns = resp.data.exceptURLPatterns || []
          this.providerOnlyURLPatterns = resp.data.onlyURLPatterns || []
          this.providerHTML = resp.data.providerHTML || ''
          this.providerFeatureIsOn = resp.data.featureIsOn !== false
          this.providerWafIsOn = resp.data.wafIsOn !== false
          this.isLoading = false
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 保存运营商设置
    async saveProvider() {
      this.isLoading = true
      await window.Tea.Vue.$post('/servers/server/settings/waf/ipadmin/providers')
        .params({
          serverId: this.serverId,
          firewallPolicyId: this.firewallPolicyId,
          allowProviderIds: this.providerAllowed.map(provider => provider.id),
          denyProviderIds: this.providerDenied.map(provider => provider.id),
          exceptURLPatternsJSON: JSON.stringify(this.providerExceptURLPatterns),
          onlyURLPatternsJSON: JSON.stringify(this.providerOnlyURLPatterns),
          providerHTML: this.providerHTML
        })
        .success(() => {
          this.$message.success(this.$t('locations_index@保存成功'))
          this.loadProvider()
        })
        .fail(() => {
          this.isLoading = false
        })
    },
    // 运营商tab内事件
    changeAllowedProviders(event) {
      this.providerAllowed = event.providers
    },
    changeDeniedProviders(event) {
      this.providerDenied = event.providers
    },
    toggleProviderMoreOptions() {
      this.providerMoreOptionsVisible = !this.providerMoreOptionsVisible
    },
  },
  template: `
    <a-spin :spinning="isLoading">
      <div class="ui top attached tabular menu">
        <a class="item" :class="{active: activeTab==='white'}" @click.prevent="switchTab('white')">IP白名单</a>
        <a class="item" :class="{active: activeTab==='black'}" @click.prevent="switchTab('black')">IP黑名单</a>
        <a class="item" :class="{active: activeTab==='grey'}" @click.prevent="switchTab('grey')">IP灰名单</a>
        <a class="item" :class="{active: activeTab==='country'}" @click.prevent="switchTab('country')">国家</a>
        <a class="item" :class="{active: activeTab==='province'}" @click.prevent="switchTab('province')">省份</a>
        <a class="item" :class="{active: activeTab==='provider'}" @click.prevent="switchTab('provider')">运营商</a>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='white'">
        <warning-message v-if="!whiteListFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="whiteListFeatureIsOn">
          <div class="ui menu">
            <a class="item" @click.prevent="createWhiteIP">添加IP</a>
            <span class="item">ID: {{whiteListId}}</span>
            <span class="item"><ip-list-bind-box v-if="!isLoading && firewallPolicyId" :v-http-firewall-policy-id="firewallPolicyId" :v-type="'white'"></ip-list-bind-box></span>
          </div>
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <b-empty v-if="whiteListItems.length == 0">暂时还没有IP</b-empty>
          <div class="table-box" v-if="whiteListItems.length > 0">
            <ip-list-table v-if="!isLoading" :v-items="whiteListItems" @update-item="updateWhiteIP" @delete-item="deleteWhiteIP"></ip-list-table>
          </div>
          <div class="flex-center" v-if="whiteListPage.total > 0">
            <a-pagination v-model="whiteListPage.current" :total="whiteListPage.total" :page-size="whiteListPage.pageSize" @change="changeWhiteListPage"></a-pagination>
          </div>
        </div>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='black'">
        <warning-message v-if="!blackListFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="blackListFeatureIsOn">
          <div class="ui menu">
            <a class="item" @click.prevent="createBlackIP">添加IP</a>
            <span class="item">ID: {{blackListId}}</span>
            <span class="item"><ip-list-bind-box v-if="!isLoading && firewallPolicyId" :v-http-firewall-policy-id="firewallPolicyId" :v-type="'black'"></ip-list-bind-box></span>
          </div>
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <b-empty v-if="blackListItems.length == 0">暂时还没有IP</b-empty>
          <div class="table-box" v-if="blackListItems.length > 0">
            <ip-list-table v-if="!isLoading" :v-items="blackListItems" @update-item="updateBlackIP" @delete-item="deleteBlackIP"></ip-list-table>
          </div>
          <div class="flex-center" v-if="blackListPage.total > 0">
            <a-pagination v-model="blackListPage.current" :total="blackListPage.total" :page-size="blackListPage.pageSize" @change="changeBlackListPage"></a-pagination>
          </div>
        </div>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='grey'">
        <warning-message v-if="!greyListFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="greyListFeatureIsOn">
          <div class="ui menu">
            <a class="item" @click.prevent="createGreyIP">添加IP</a>
            <span class="item">ID: {{greyListId}}</span>
            <span class="item"><ip-list-bind-box v-if="!isLoading && firewallPolicyId" :v-http-firewall-policy-id="firewallPolicyId" :v-type="'grey'"></ip-list-bind-box></span>
          </div>
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <b-empty v-if="greyListItems.length == 0">暂时还没有IP</b-empty>
          <div class="table-box" v-if="greyListItems.length > 0">
            <ip-list-table v-if="!isLoading" :v-items="greyListItems" @update-item="updateGreyIP" @delete-item="deleteGreyIP"></ip-list-table>
          </div>
          <div class="flex-center" v-if="greyListPage.total > 0">
            <a-pagination v-model="greyListPage.current" :total="greyListPage.total" :page-size="greyListPage.pageSize" @change="changeGreyListPage"></a-pagination>
          </div>
        </div>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='country'">
        <warning-message v-if="!countryFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="countryFeatureIsOn">
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <form class="ui form base-form config-section" @submit.prevent="saveCountry">
            <div class="section-title">
              <i class="pi pi-server"></i>
              国家地区设置
            </div>
            <div class="config-item">
              <div class="item-label">仅允许的区域</div>
              <div class="item-content">
                <http-firewall-region-selector v-if="!isLoading" :v-countries="countryAllowed" :v-type="'allow'" @change="changeAllowedCountries"></http-firewall-region-selector>
              </div>
            </div>
            <div class="config-item">
              <div class="item-label">仅封禁的区域</div>
              <div class="item-content">
                <p class="comment" v-if="countryAllowed.length > 0">已设置允许区域后，封禁区域将不生效</p>
                <http-firewall-region-selector v-if="!isLoading" :v-countries="countryDenied" :v-type="'deny'" v-show="countryAllowed.length == 0" @change="changeDeniedCountries"></http-firewall-region-selector>
              </div>
            </div>
            <div class="config-item">
              <a href="javascript:;" class="more-options-toggle" @click="toggleCountryMoreOptions">更多选项</a>
            </div>
            <div v-show="countryMoreOptionsVisible">
              <div class="config-item">
                <div class="item-label">例外URL</div>
                <div class="item-content">
                  <url-patterns-box v-model="countryExceptURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">限制URL</div>
                <div class="item-content">
                  <url-patterns-box v-model="countryOnlyURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">提示内容</div>
                <div class="item-content">
                  <textarea v-model="countryHTML" name="countryHTML" rows="3"></textarea>
                  <p class="comment">当访问被限制时显示的内容</p>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">允许搜索引擎</div>
                <div class="item-content">
                  <checkbox name="allowSearchEngine" v-model="allowSearchEngine"></checkbox>
                  <p class="comment">允许主流搜索引擎访问</p>
                </div>
              </div>
            </div>
            <div style="padding: 1rem;">
              <submit-btn></submit-btn>
            </div>
          </form>
        </div>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='province'">
        <warning-message v-if="!provinceFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="provinceFeatureIsOn">
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <form class="ui form base-form config-section" @submit.prevent="saveProvince">
            <div class="section-title">
              <i class="pi pi-server"></i>
              省份设置
            </div>
            <div class="config-item">
              <div class="item-label">仅允许的省份</div>
              <div class="item-content">
                <http-firewall-province-selector v-if="!isLoading" :v-provinces="provinceAllowed" :v-type="'allow'" @change="changeAllowedProvinces"></http-firewall-province-selector>
              </div>
            </div>
            <div class="config-item">
              <div class="item-label">仅封禁的省份</div>
              <div class="item-content">
                <p class="comment" v-if="provinceAllowed.length > 0">已设置允许省份后，封禁省份将不生效</p>
                <http-firewall-province-selector v-if="!isLoading" :v-provinces="provinceDenied" :v-type="'deny'" v-show="provinceAllowed.length == 0" @change="changeDeniedProvinces"></http-firewall-province-selector>
              </div>
            </div>
            <div class="config-item">
              <a href="javascript:;" class="more-options-toggle" @click="toggleProvinceMoreOptions">更多选项</a>
            </div>
            <div v-show="provinceMoreOptionsVisible">
              <div class="config-item">
                <div class="item-label">例外URL</div>
                <div class="item-content">
                  <url-patterns-box v-if="!isLoading" v-model="provinceExceptURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">限制URL</div>
                <div class="item-content">
                  <url-patterns-box v-if="!isLoading" v-model="provinceOnlyURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">提示内容</div>
                <div class="item-content">
                  <textarea v-model="provinceHTML" name="provinceHTML" rows="3"></textarea>
                  <p class="comment">当访问被限制时显示的内容</p>
                </div>
              </div>
            </div>
            <div style="padding: 1rem;">
              <submit-btn></submit-btn>
            </div>
          </form>
        </div>
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='provider'">
        <warning-message v-if="!providerFeatureIsOn">尚未开通功能</warning-message>
        <div v-if="providerFeatureIsOn">
          <warning-message v-if="!wafIsOn">WAF未启用，请先在WAF设置中启用。</warning-message>
          <form class="ui form base-form config-section" @submit.prevent="saveProvider">
            <div class="section-title">
              <i class="pi pi-server"></i>
              运营商设置
            </div>
            <div class="config-item">
              <div class="item-label">仅允许的运营商</div>
              <div class="item-content">
                <http-firewall-provider-selector v-if="!isLoading" :v-providers="providerAllowed" :v-type="'allow'" @change="changeAllowedProviders"></http-firewall-provider-selector>
              </div>
            </div>
            <div class="config-item">
              <div class="item-label">仅封禁的运营商</div>
              <div class="item-content">
                <p class="comment" v-if="providerAllowed.length > 0">已设置允许运营商后，封禁运营商将不生效</p>
                <http-firewall-provider-selector v-if="!isLoading" :v-providers="providerDenied" :v-type="'deny'" v-show="providerAllowed.length == 0" @change="changeDeniedProviders"></http-firewall-provider-selector>
              </div>
            </div>
            <div class="config-item">
              <a href="javascript:;" class="more-options-toggle" @click="toggleProviderMoreOptions">更多选项</a>
            </div>
            <div v-show="providerMoreOptionsVisible">
              <div class="config-item">
                <div class="item-label">例外URL</div>
                <div class="item-content">
                  <url-patterns-box v-if="!isLoading" v-model="providerExceptURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">限制URL</div>
                <div class="item-content">
                  <url-patterns-box v-if="!isLoading" v-model="providerOnlyURLPatterns"></url-patterns-box>
                </div>
              </div>
              <div class="config-item">
                <div class="item-label">提示内容</div>
                <div class="item-content">
                  <textarea v-model="providerHTML" name="providerHTML" rows="3"></textarea>
                  <p class="comment">当访问被限制时显示的内容</p>
                </div>
              </div>
            </div>
            <div style="padding: 1rem;">
              <submit-btn></submit-btn>
            </div>
          </form>
        </div>
      </div>
    </a-spin>
  `
}) 

// 源站管理组件
Vue.component("reverse-proxy-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      activeTab: "origin",
      schedulingData: {},
      hasGroupConfig: false,
      groupSettingURL: '',
      reverseProxyRef: {},
      primaryOrigins: [],
      backupOrigins: [],
      serverType: '',
      reverseProxyConfig: {},
      serverFamily: '',
      loading: false,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getReverseProxyConfig()
      this.getScheduling()
      this.getSetting()
    }, 10)
  },
  methods: {

    async getReverseProxyConfig() {
      this.loading = true
      const path = 'servers/server/settings/reverseProxy'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.$set(this, 'primaryOrigins', resp.data.primaryOrigins)
        this.$set(this, 'backupOrigins', resp.data.backupOrigins)
        this.$set(this, 'serverType', resp.data.serverType)
        this.$set(this, 'hasGroupConfig', resp.data.hasGroupConfig)
        this.$set(this, 'groupSettingURL', resp.data.groupSettingURL)
        this.$set(this, 'reverseProxyRef', resp.data.reverseProxyRef)
        this.loading = false
        this.key++
      })
    },

    async getScheduling() {
      this.loading = true
      const path = '/servers/server/settings/reverseProxy/scheduling'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.$set(this, 'schedulingData', resp.data.scheduling)
        this.key++
        this.loading = false
      })
      // this.schedulingData = response.data.scheduling
      // console.log("getScheduling -> this.schedulingData", this.schedulingData)
    },

    async getSetting() {
      const path = '/servers/server/settings/reverseProxy/setting'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.$set(this, 'reverseProxyConfig', resp.data.reverseProxyConfig)
        this.$set(this, 'serverFamily', resp.data.serverFamily)
        this.key++
      })
    },
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    async updateReverseProxyConfig() {
      this.getReverseProxyConfig()
    },
    async updateScheduling() {
      this.getScheduling()
    },
    async updateSetting(data) {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/reverseProxy/setting'
      const params = {
        serverId: this.serverId,
        reverseProxyRefJSON: JSON.stringify(data.reverseProxyRef),
        reverseProxyJSON: JSON.stringify(data.reverseProxyConfig),
        csrfToken: csrfToken
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getSetting()
      })
    },
    changeTab(key) {
      this.activeTab = key
    }
  },
  template: `
    <a-spin :spinning="loading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-server"></i>
        {{$t('reverseProxy_index@源站管理')}}
      </div>
      <a-tabs default-active-key="origin" :active-key="activeTab" @change="changeTab">
        <a-tab-pane key="origin" :tab="$t('reverseProxy_index@源站管理')">
          <div class="x-alert x-alert-warning" v-if="hasGroupConfig">
            <i class="pi pi-exclamation-triangle"></i>
            {{$t('reverseProxy_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('reverseProxy_index@网站分组')}}</a>{{$t('reverseProxy_index@中进行了对应的配置，在这里的配置将不会生效')}}
          </div>
          <div :class="{'opacity-mask': hasGroupConfig}">
            <div class="x-alert x-alert-warning" v-if="!reverseProxyRef.isOn">
              <i class="pi pi-exclamation-triangle"></i>
              {{$t('reverseProxy_index@当前源站没有启用，可以通过点击')}} <span class="cursor-pointer" @click="changeTab('setting')">{{$t('reverseProxy_index@更多设置')}}</span> {{$t('reverseProxy_index@开启')}}
            </div>
            <div class="x-form-item">
              <origin-list-box 
                v-if="!loading"
                :key="primaryOrigins.length" 
                :v-primary-origins="primaryOrigins" 
                :v-backup-origins="backupOrigins" 
                :v-server-type="serverType" 
                :v-params="'type=server&serverId=' + serverId + '&reverseProxyId=' + reverseProxyConfig.id"
                @change="updateReverseProxyConfig"
              ></origin-list-box>
            </div>
          </div>
        </a-tab-pane>
        <a-tab-pane key="scheduling" :tab="$t('reverseProxy_index@调度配置')">
          <origin-scheduling-view-box 
            v-if="!loading"
            :key="key"
            :v-scheduling="schedulingData" 
            :v-params="'type=server&serverId=' + serverId + '&reverseProxyId=' + reverseProxyConfig.id"
            @change="updateScheduling"
          ></origin-scheduling-view-box>
        </a-tab-pane>
        <a-tab-pane key="setting" :tab="$t('reverseProxy_index@更多设置')">
          <form class="x-form ui form">
            <reverse-proxy-box 
              :key="key"
              :v-reverse-proxy-ref="reverseProxyRef" 
              :v-reverse-proxy-config="reverseProxyConfig" 
              :v-family="serverFamily"
              @change="updateSetting"
            ></reverse-proxy-box>
          </form>
        </a-tab-pane>
      </a-tabs>
    </a-spin>
  `
}) 

// WebP管理组件（封装WebP配置页面，风格与compression-details-box.js一致）
Vue.component("webp-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      webpConfig: null,
      requireCache: false,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      webpWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getWebpConfig()
    }, 10)
  },
  methods: {
    // 获取WebP配置
    async getWebpConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/webp'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.webpConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            minLength: { count: 0, "unit": "kb" },
            maxLength: { count: 0, "unit": "kb" },
            mimeTypes: ["image/png", "image/jpeg", "image/bmp", "image/x-ico"],
            extensions: [".png", ".jpeg", ".jpg", ".bmp", ".ico"],
            conds: null
          }
        }

        if (config.mimeTypes == null) {
          config.mimeTypes = []
        }
        if (config.extensions == null) {
          config.extensions = []
        }
        this.webpConfig = config
        this.requireCache = resp.data.requireCache
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webpWebId = resp.data.webId
        this.webId = resp.data.webId
        this.isLoading = false
        this.key++
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存WebP配置
    async saveWebpConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/webp'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.webpWebId,
        webpJSON: JSON.stringify(this.webpConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getWebpConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>{{$t('webp_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('webp_index@网站分组')}}</a>{{$t('webp_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveWebpConfig">
          <http-webp-config-box v-if="webpConfig" :key="key" :v-webp-config="webpConfig" :v-require-cache="requireCache"></http-webp-config-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// WAF管理入口组件，整合WAF设置、规则分组管理、IP与地域管理
Vue.component("waf-details-box", {
  props: ["serverId"],
  data: function () {
    return {
      activeTab: "waf" // waf: WAF设置, group: 规则分组管理, ip: IP与地域管理
    }
  },
  methods: {
    switchTab(tab) {
      this.activeTab = tab
    }
  },
  template: `
    <div>
      <div class="ui top attached tabular menu">
        <a class="item" :class="{active: activeTab==='waf'}" @click.prevent="switchTab('waf')">WAF设置</a>
        <a class="item" :class="{active: activeTab==='group'}" @click.prevent="switchTab('group')">规则分组管理</a>
        <a class="item" :class="{active: activeTab==='ip'}" @click.prevent="switchTab('ip')">IP与地域管理</a>
      </div>
      <waf-config-box :server-id="serverId" v-if="activeTab==='waf'" />
      <div class="ui bottom attached segment" v-if="activeTab==='group'">
        <waf-groups-box :server-id="serverId" />
      </div>
      <div class="ui bottom attached segment" v-if="activeTab==='ip'">
        <ip-admin-box :server-id="serverId" />
      </div>
    </div>
  `
}) 

// 访问日志配置组件（封装访问日志配置页面，风格与rewrite-details-box.js一致）
Vue.component("access-log-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      accessLogConfig: null,
      fields: [],
      defaultFieldCodes: [],
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取访问日志配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/accessLog'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.accessLogConfig = resp.data.accessLogConfig
        this.fields = resp.data.fields
        this.defaultFieldCodes = resp.data.defaultFieldCodes
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig(value) {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/accessLog'
      const params = {
        csrfToken: csrfToken,
        webId: this.webId,
        accessLogJSON: JSON.stringify(value)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('http-auth-config-box@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <div>
      <a-spin :spinning="isLoading">
        <div v-if="hasGroupConfig">
          <div class="margin"></div>
          <warning-message>{{$t('access-log-config-box@由于已经在当前')}}<a :href="groupSettingURL">{{$t('access-log-config-box@网站分组')}}</a>{{$t('access-log-config-box@中进行了对应的配置，在这里的配置将不会生效')}}。</warning-message>
        </div>

        <div :class="{'opacity-mask': hasGroupConfig}">
          <http-access-log-config-box
            :key="key"
            :v-access-log-config="accessLogConfig"
            :v-fields="fields"
            :v-default-field-codes="defaultFieldCodes"
            @submit="saveConfig">
          </http-access-log-config-box>
        </div>
      </a-spin>
    </div>
  `
}) 

// 请求脚本管理组件（封装请求脚本配置页面，风格与compression-details-box.js一致）
Vue.component("request-scripts-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      requestScriptsConfig: null,
      auditingStatus: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      requestScriptsWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getRequestScriptsConfig()
    }, 10)
  },
  methods: {
    // 获取请求脚本配置
    async getRequestScriptsConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/requestScripts'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.requestScriptsConfig
        if (config == null) {
          config = {}
        }
        this.requestScriptsConfig = config
        this.auditingStatus = resp.data.auditingStatus
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.requestScriptsWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存请求脚本配置
    async saveRequestScriptsConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/requestScripts'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.requestScriptsWebId,
        requestScriptsJSON: JSON.stringify(this.requestScriptsConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getRequestScriptsConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>由于已经在当前<a :href="groupSettingURL">网站分组</a>中进行了对应的配置，在这里的配置将不会生效。</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveRequestScriptsConfig">
          <http-request-scripts-config-box v-if="requestScriptsConfig" :key="key" :v-request-scripts-config="requestScriptsConfig" :v-auditing-status="auditingStatus"></http-request-scripts-config-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// 主动防御配置与管理组件（重构版，适用于serverDetails目录）
Vue.component("defense-config-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      config: null, // 主配置对象，接口获取后赋值
      isAdding: false,
      addRecord: null, // 新增规则对象，接口获取后赋值
      riskTags: [],
      riskLevels: [],
      riskActions: [],
      columns: [],
      webId: null,
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取主动防御配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/defense'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        // 初始化配置
        let config = resp.data.defenseConfig
        if (!config) {
          config = {
            isOn: false,
            records: [{
              enable: false,
              riskTags: [],
              riskLevel: 0,
            }]
          }
        }
        if (!config.records) {
          config.records = []
        }
        this.config = config
        this.webId = resp.data.webId
        // 初始化风险标签、等级、动作
        this.riskTags = [
          { id: 1, name: this.$t('defense-config-box@代理'), isChecked: false },
          { id: 2, name: "Tor", isChecked: false },
          { id: 3, name: "VPN", isChecked: false },
          { id: 4, name: this.$t('defense-config-box@扫描'), isChecked: false },
          { id: 5, name: "IDC", isChecked: false },
          { id: 6, name: this.$t('defense-config-box@暴力破解'), isChecked: false },
          { id: 7, name: this.$t('defense-config-box@秒拨'), isChecked: false }
        ]
        this.riskLevels = [this.$t('defense-config-box@未选中'), this.$t('defense-config-box@低风险'), this.$t('defense-config-box@中风险'), this.$t('defense-config-box@高风险')]
        this.riskActions = [
          { id: 1, name: this.$t('defense-config-box@5秒盾') },
          { id: 2, name: this.$t('defense-config-box@无感验证') },
          { id: 3, name: this.$t('defense-config-box@验证码') },
          { id: 4, name: this.$t('defense-config-box@封禁') }
        ]
        this.columns = [
          { title: this.$t('defense-config-box@风险标签'), key: 'riskTags', scopedSlots: { customRender: 'riskTagsSlot' }, width: '200px' },
          { title: this.$t('defense-config-box@风险等级'), key: 'riskLevel', scopedSlots: { customRender: 'riskLevelSlot' }, width: '120px' },
          { title: this.$t('defense-config-box@风险评分'), key: 'riskScore', scopedSlots: { customRender: 'riskScoreSlot' }, width: '120px' },
          { title: this.$t('defense-config-box@处理动作'), key: 'action', scopedSlots: { customRender: 'actionSlot' }, width: '120px' },
          { title: this.$t('defense-config-box@观察模式'), key: 'recordOnly', scopedSlots: { customRender: 'recordOnlySlot' }, width: '120px' },
          { title: this.$t('defense-config-box@操作'), key: 'operation', scopedSlots: { customRender: 'operationSlot' }, width: '80px', align: 'center' }
        ]
        // 初始化新增规则对象
        this.addRecord = {
          enable: true,
          riskLevel: 0,
          riskTags: [],
          recordOnly: false,
          action: 1,
        }
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 提交主动防御配置数据
    async updateData() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/defense'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        defenseJSON: JSON.stringify(this.config),
        webId: this.webId
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    add: function () {
      this.isAdding = true
    },
    save: function () {
      this.config.records.push(this.addRecord)
      this.cancel()
      this.updateData()
    },
    remove: function (index) {
      let that = this
      teaweb.confirm(this.$t('defense-config-box@确定要删除此条规则吗'), function () {
        that.config.records.$remove(index)
        that.updateData()
      })
    },
    cancel: function () {
      this.isAdding = false
      this.riskTags.forEach(function (v) {
        v.isChecked = false
      })
      this.addRecord = {
        enable: true,
        riskLevel: 0,
        riskTags: [],
        recordOnly: false,
        action: 1,
      }
    },
    changeRiskTag: function () {
      this.addRecord.riskTags = this.riskTags.filter(function (v) {
        return v.isChecked
      }).map(function (v) {
        return v.id
      })
    },
    changeRiskScore: function (event) {
      const value = parseInt(event.target.value, 10);
      if (value >= 0 && value <= 100) {
        this.addRecord.riskScore = value;
      } else {
        event.target.value = this.addRecord.riskScore;
      }
    },
    submit: function () {
      setTimeout(() => {
        this.updateData()
      }, 100)
    }
  },
  template: `<a-spin :spinning="isLoading">
  <input type="hidden" name="defenseJSON" :value="JSON.stringify(config)" />
  <div class="config-section" :key="key">
    <div class="section-title">
      <i class="icon shield"></i>
      <span>{{$t('defense-config-box@基本设置')}}</span>
    </div>
    <div class="config-item">
      <div class="item-label">{{$t('defense-config-box@启用主动防御')}}</div>
      <div class="item-content">
        <p-switch v-model="config.isOn" binary @change="submit"></p-switch>
        <p class="comment"><plus-label></plus-label>{{$t('defense-config-box@启用主动防御提示')}}</p>
      </div>
    </div>
  </div>
  <div class="config-section" v-if="config.isOn" :key="key">
    <div class="section-title">
      <i class="icon list"></i>
      <span>{{$t('defense-config-box@规则列表')}}</span>
    </div>
    <div class="config-item" v-if="config.records && config.records.length > 0">
      <div class="item-content">
        <b-table :columns="columns" :data-source="config.records" :row-key="(record, index) => index"
          :scroll="{ x: 800 }" size="middle">
          <template slot="riskTagsSlot" slot-scope="{ text, record }">
            <div v-for="tag in riskTags" :key="tag.id" v-if="record.riskTags && record.riskTags.$contains(tag.id)">
              {{tag.name}}
            </div>
          </template>
          <template slot="riskLevelSlot" slot-scope="{ text, record }">
            {{riskLevels[record.riskLevel]}}
          </template>
          <template slot="riskScoreSlot" slot-scope="{ text, record }">
            {{record.riskScore||0}}
          </template>
          <template slot="actionSlot" slot-scope="{ text, record }">
            {{riskActions[record.action-1].name}}
          </template>
          <template slot="recordOnlySlot" slot-scope="{ text, record }">
            {{record.recordOnly ? $t('defense-config-box@是') : $t('defense-config-box@否')}}
          </template>
          <template slot="operationSlot" slot-scope="{ text, record, index }">
            <a href="" @click.prevent="remove(index)" :title="$t('defense-config-box@删除')">
              <i class="pi pi-trash" style="font-size: 12px; padding: 4px;"></i>
            </a>
          </template>
        </b-table>
      </div>
    </div>
    <div class="config-item" v-if="isAdding">
      <div class="item-content">
        <div
          style="background: var(--color-panel); border: 1px solid var(--color-border); border-radius: 6px; padding: 1em; margin-bottom: 1em;">
          <div class="section-title" style="font-size: 14px; margin-bottom: 1em;">
            <i class="icon plus"></i>
            <span>{{$t('defense-config-box@添加规则')}}</span>
          </div>
          <div style="margin-bottom: 1.5em;">
            <div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险标签')}}</div>
            <div style="display: flex; flex-wrap: wrap; gap: 1em;">
              <div v-for="tag in riskTags" :key="tag.id" style="width: 8em; margin-bottom: 0.8em;">
                <p-checkbox :id="tag.id" v-model="tag.isChecked" @change="changeRiskTag" binary></p-checkbox>
                <label :for="tag.id" style="margin-left: 0.3em;">{{tag.name}}</label>
              </div>
            </div>
            <p class="comment">{{$t('defense-config-box@风险标签提示')}}</p>
          </div>
          <div style="margin-bottom: 1.5em;">
            <div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险等级')}}</div>
            <div>
              <b-select v-model="addRecord.riskLevel"
                :options="riskLevels.map((level,idx) => ({label: level, value: idx}))"></b-select>
              <p class="comment">{{$t('defense-config-box@风险等级提示')}}</p>
            </div>
          </div>
          <div style="margin-bottom: 1.5em;">
            <div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险评分')}}</div>
            <div>
              <div class="ui input right labeled">
                <input type="number" max="100" min="0" style="width: 6em" :value="addRecord.riskScore"
                  @input="changeRiskScore" />
                <span class="ui label">{{$t('defense-config-box@取值区间0-100')}}</span>
              </div>
              <p class="comment">{{$t('defense-config-box@风险评分提示')}}</p>
            </div>
          </div>
          <div style="margin-bottom: 1.5em;">
            <div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@处理动作')}}</div>
            <div style="display: flex; gap: 0.8em;">
              <div v-for="act in riskActions" style="margin-bottom: 0.5em; display: flex; align-items: center;">
                <radio name="action" :id="'action-' + act.id" v-model="addRecord.action" :v-value="act.id"></radio>
                <label :for="'action-' + act.id" style="margin-left: 0.3em;">{{act.name}}</label>
              </div>
            </div>
            <p class="comment">{{$t('defense-config-box@处理动作提示')}}</p>
          </div>
          <div style="margin-bottom: 1.5em;">
            <div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@观察模式')}}</div>
            <div>
              <p-checkbox v-model="addRecord.recordOnly" binary></p-checkbox>
              <span style="margin-left: 0.3em;">{{$t('defense-config-box@启用观察模式')}}</span>
              <p class="comment">{{$t('defense-config-box@观察模式提示')}}</p>
            </div>
          </div>
          <div style="margin-top: 1.5em;">
            <button type="button" class="ui button tiny" @click.prevent="save">{{$t('defense-config-box@保存')}}</button>
            &nbsp;
            <a href="" @click.prevent="cancel" :title="$t('defense-config-box@取消')"><i
                class="icon remove small"></i></a>
          </div>
        </div>
      </div>
    </div>
    <div class="config-item" v-show="!isAdding">
      <div class="item-label"></div>
      <div class="item-content">
        <button class="ui button tiny" type="button" @click.prevent="add">{{$t('defense-config-box@添加规则')}}</button>
      </div>
    </div>
  </div>
</a-spin>`
}) 

// WAF主配置组件，迁移自原index.js和index.html，结构参考webp-details-box.js
Vue.component("waf-config-box", {
  props: ["serverId"],
  data: function () {
    return {
      firewallConfig: null,
      firewallPolicy: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getWafConfig()
    }, 10)
  },
  methods: {
    // 获取WAF配置
    async getWafConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/waf'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.firewallConfig = resp.data.firewallConfig
        this.firewallPolicy = resp.data.firewallPolicy
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webId = resp.data.webId
        this.isLoading = false
        this.key++
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存WAF配置
    async saveWafConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/waf'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.webId,
        firewallJSON: JSON.stringify(this.firewallConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success('保存成功')
        this.getWafConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>已在当前<a :href="groupSettingURL">网站分组</a>中进行了对应的配置，在这里的配置将不会生效</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveWafConfig">
          <input type="hidden" name="webId" :value="webId"/>
          <div class="config-section">
            <div class="section-title">
              <i class="pi pi-server"></i>
              WAF设置
            </div>
            <http-firewall-config-box v-if="firewallConfig" :key="key" :v-firewall-config="firewallConfig" :v-firewall-policy="firewallPolicy"></http-firewall-config-box>
          </div>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// 路由规则（Locations）管理组件（a-tabs切换，集成列表与新建页面，风格与reverse-proxy-details-box.js一致）
Vue.component("locations-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      activeTab: "list",
      locations: [],
      isLoading: false,
      webId: null,
      // 新建路由规则表单
      createForm: {
        pattern: "",
        patternType: 1,
        isBreak: false,
        name: "",
        conds: {
          isOn: true,
          connector: "or",
          groups: []
        },
        domains: [],
        isCaseInsensitive: false,
        isReverse: false,
        description: ""
      },
      patternTypes: [],
      selectedType: null,
      moreOptionsVisible: false,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getLocations()
      this.getPatternTypes()
    }, 10)
  },
  methods: {
    // 获取路由规则列表
    async getLocations() {
      this.isLoading = true
      const path = '/servers/server/settings/locations'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let locations = resp.data.locations
        if (!locations) locations = []
        this.locations = locations
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取匹配类型
    async getPatternTypes() {
      const path = '/servers/server/settings/locations/create'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.patternTypes = resp.data.patternTypes
        this.selectedType = this.patternTypes[0]
        this.createForm.patternType = this.selectedType.type
      })
    },
    // 删除路由规则
    async deleteLocation(locationId) {
      const text = this.$t('locations_index@确定要删除此路由规则吗')
      this.$confirm({
        content: text,
        onOk: async () => {
          const path = '/servers/server/settings/locations/delete'
          await window.Tea.Vue.$post(path).params({
            serverId: this.serverId,
            webId: this.webId,
            locationId: locationId
          }).success(() => {
            this.$message.success(this.$t('iplists@删除成功'))
            this.getLocations()
          })
        }
      })
    },
    // 排序
    async handleSort(ids) {
      const path = '/servers/server/settings/locations/sort'
      await window.Tea.Vue.$post(path).params({
        serverId: this.serverId,
        webId: this.webId,
        locationIds: ids
      }).success(() => {
        this.$message.success(this.$t('locations_index@保存成功'))
        this.getLocations()
      })
    },
    // 新建路由规则
    async createLocation() {
      const path = '/servers/server/settings/locations/create'
      const params = Object.assign({}, this.createForm, {
        serverId: this.serverId,
        webId: this.webId,
        pattern: this.createForm.pattern,
        patternType: this.createForm.patternType,
        isBreak: this.createForm.isBreak ? 1 : 0,
        name: this.createForm.name,
        condsJSON: JSON.stringify(this.createForm.conds),
        domainsJSON: JSON.stringify(this.createForm.domains),
        isCaseInsensitive: this.createForm.isCaseInsensitive ? 1 : 0,
        isReverse: this.createForm.isReverse ? 1 : 0,
        description: this.createForm.description
      })
      await window.Tea.Vue.$post(path).params(params).success(() => {
        this.$message.success(this.$t('locations_create@添加成功'))
        this.activeTab = "list"
        this.getLocations()
        this.resetCreateForm()
      })
    },
    // 切换匹配类型
    changePatternType(type) {
      this.selectedType = this.patternTypes.find(pt => pt.type === type)
      this.createForm.patternType = type
    },
    // 重置新建表单
    resetCreateForm() {
      this.createForm = {
        pattern: "",
        patternType: this.patternTypes.length > 0 ? this.patternTypes[0].type : 1,
        isBreak: false,
        name: "",
        conds: [],
        domains: [],
        isCaseInsensitive: false,
        isReverse: false,
        description: ""
      }
      this.selectedType = this.patternTypes.length > 0 ? this.patternTypes[0] : null
      this.moreOptionsVisible = false
    },
    changeDomains(domains) {
      this.createForm.domains = domains
    },
    changeConds(conds) {
      this.createForm.conds = conds
    }
  },
  template: `
    <a-spin :spinning="isLoading" class="x-section">
      <a-tabs v-model="activeTab" :key="key">
        <a-tab-pane key="list" :tab="$t('@menu@列表')">
          <b-empty v-if="locations.length == 0">{{$t('locations_index@暂时还没有路由规则')}}</b-empty>
          <b-sortable-table
            v-if="locations.length > 0"
            :columns="[
              { title: '', key: 'handle', scopedSlots: { customRender: 'handleSlot' }, width: '50px', align: 'center' },
              { title: $t('locations_index@匹配规则'), key: 'pattern', scopedSlots: { customRender: 'patternSlot' } },
              { title: $t('locations_index@匹配类型'), dataIndex: 'patternTypeName', key: 'patternType', width: '10em' },
              { title: $t('locations_index@状态'), key: 'status', width: '6em', scopedSlots: { customRender: 'statusSlot' } },
              { title: $t('locations_index@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
            ]"
            :data-source="locations"
            :row-key="'id'"
            :pagination="false"
            :on-sort="handleSort"
          >
            <template slot="handleSlot" slot-scope="{ record }">
              <i class="icon bars handle grey"></i>
            </template>
            <template slot="patternSlot" slot-scope="{ text, record }">
              <a :href="'/servers/server/settings/locations/location?serverId=' + serverId + '&locationId=' + record.id">{{record.pattern}}</a>
              <http-location-labels :v-location-config="record" :v-server-id="serverId"></http-location-labels>
            </template>
            <template slot="statusSlot" slot-scope="{ text, record }">
              <label-on :v-is-on="record.isOn"></label-on>
            </template>
            <template slot="actionSlot" slot-scope="{ text, record }">
              <a-button type="link" :href="'/servers/server/settings/locations/location?serverId=' + serverId + '&locationId=' + record.id">{{$t('locations_index@详情')}}</a-button>
              <a-button type="link" danger @click.prevent="deleteLocation(record.id)">{{$t('locations_index@删除')}}</a-button>
            </template>
          </b-sortable-table>
          <p class="comment" v-if="locations.length > 0" v-html="$t('locations_index@排序提示')"></p>
        </a-tab-pane>
        <a-tab-pane key="create" :tab="$t('@menu@创建')">
          <div class="config-section">
            <div class="section-title">{{$t('locations_create@创建新的路由规则')}}</div>
            <form class="ui form" @submit.prevent="createLocation">
              <div class="config-item">
                <div class="item-label">{{$t('locations_create@路径匹配规则*')}}</div>
                <div class="item-content">
                  <input type="text" name="pattern" maxlength="500" ref="focus" class="ui input" v-model="createForm.pattern"/>
                  <p class="comment">{{$t('locations_create@路径匹配规则提示')}}</p>
                </div>
              </div>

              <div class="config-item">
                <div class="item-label">{{$t('locations_create@匹配类型')}}</div>
                <div class="item-content">
                  <b-select
                    name="patternType"
                    v-model="createForm.patternType"
                    @change="changePatternType(createForm.patternType)"
                    auto-width
                    :options="[
                      ...patternTypes.map(patternType => ({
                        label: patternType.name,
                        value: patternType.type,
                      }))
                    ]"
                  ></b-select>
                  <p class="comment" v-if="selectedType != null" v-html="selectedType.description"></p>
                </div>
              </div>

              <div class="config-item">
                <div class="item-label">{{$t('locations_create@终止往下匹配')}}</div>
                <div class="item-content">
                  <checkbox name="isBreak" :v-value="1" v-model="createForm.isBreak"></checkbox>
                  <p class="comment">{{$t('locations_create@终止往下匹配提示')}}</p>
                </div>
              </div>

              <div class="config-item">
                <div class="item-label">{{$t('locations_create@名称')}}</div>
                <div class="item-content">
                  <input type="text" name="name" maxlength="100" class="ui input" v-model="createForm.name"/>
                  <p class="comment">{{$t('locations_create@名称提示')}}</p>
                </div>
              </div>

              <div class="config-item">
                <div class="item-label">{{$t('locations_create@匹配条件')}}</div>
                <div class="item-content">
                  <http-request-conds-box @change="changeConds"></http-request-conds-box>
                </div>
              </div>

              <!-- 更多选项 -->
              <div class="config-item">
                <div class="item-label">{{$t('locations_create@更多选项')}}</div>
                <div class="item-content">
                  <a href="" @click.prevent="moreOptionsVisible = !moreOptionsVisible" class="more-options-toggle">
                    <i class="icon angle" :class="{down:!moreOptionsVisible, right:moreOptionsVisible}"></i>
                    <span v-if="!moreOptionsVisible">{{$t('locations_create@显示更多选项')}}</span>
                    <span v-if="moreOptionsVisible">{{$t('locations_create@收起选项')}}</span>
                  </a>
                </div>
              </div>

              <div v-show="moreOptionsVisible">
                <div class="config-item">
                  <div class="item-label">{{$t('locations_create@专属域名')}}</div>
                  <div class="item-content">
                    <domains-box @change="changeDomains"></domains-box>
                    <p class="comment">{{$t('locations_create@专属域名提示')}}</p>
                  </div>
                </div>

                <div class="config-item">
                  <div class="item-label">{{$t('locations_create@不区分大小写')}}</div>
                  <div class="item-content">
                    <checkbox name="isCaseInsensitive" :v-value="1" v-model="createForm.isCaseInsensitive"></checkbox>
                    <p class="comment">{{$t('locations_create@不区分大小写提示')}}</p>
                  </div>
                </div>

                <div class="config-item">
                  <div class="item-label">{{$t('locations_create@反向匹配')}}</div>
                  <div class="item-content">
                    <checkbox name="isReverse" :v-value="1" v-model="createForm.isReverse"></checkbox>
                    <p class="comment" v-html="$t('locations_create@反向匹配提示')"></p>
                  </div>
                </div>

                <div class="config-item">
                  <div class="item-label">{{$t('locations_create@描述')}}</div>
                  <div class="item-content">
                    <textarea rows="3" name="description" maxlength="200" class="ui input" v-model="createForm.description"></textarea>
                  </div>
                </div>
              </div>
              <!-- / 更多选项 -->

              <div class="config-item">
                <div class="item-label"></div>
                <div class="item-content">
                  <submit-btn></submit-btn>
                </div>
              </div>
            </form>
          </div>
        </a-tab-pane>
      </a-tabs>
    </a-spin>
  `
}) 

// 字符集管理组件（封装字符集配置页面，风格与compression-details-box.js一致）
Vue.component("charset-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      usualCharsets: [],
      allCharsets: [],
      charsetConfig: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      charsetWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getCharsetConfig()
    }, 10)
  },
  methods: {
    // 获取字符集配置
    async getCharsetConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/charset'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let charsetConfig = resp.data.charsetConfig
        if (charsetConfig == null) {
          charsetConfig = {
            isPrior: false,
            isOn: false,
            charset: "",
            isUpper: false,
            force: false
          }
        }
        this.usualCharsets = resp.data.usualCharsets
        this.allCharsets = resp.data.allCharsets
        this.charsetConfig = charsetConfig
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.charsetWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存字符集配置
    async saveCharsetConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/charset'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.charsetWebId,
        charsetJSON: JSON.stringify(this.charsetConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getCharsetConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>{{$t('charset_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('charset_index@网站分组')}}</a>{{$t('charset_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveCharsetConfig" >
          <http-charsets-box v-if="charsetConfig" :key="key" :v-usual-charsets="usualCharsets" :v-all-charsets="allCharsets" :v-charset-config="charsetConfig"></http-charsets-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// 网站根目录管理组件（封装网站根目录配置页面，风格与compression-details-box.js一致）
Vue.component("web-root-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      rootConfig: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      webRootWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getWebRootConfig()
    }, 10)
  },
  methods: {
    // 获取网站根目录配置
    async getWebRootConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/web'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.rootConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            dir: "",
            indexes: [],
            stripPrefix: "",
            decodePath: false,
            isBreak: false,
            exceptHiddenFiles: true,
            onlyURLPatterns: [],
            exceptURLPatterns: []
          }
        }
        if (config.indexes == null) {
          config.indexes = []
        }

        if (config.onlyURLPatterns == null) {
          config.onlyURLPatterns = []
        }
        if (config.exceptURLPatterns == null) {
          config.exceptURLPatterns = []
        }
        this.rootConfig = config
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.webRootWebId = resp.data.webId
        this.webId = resp.data.webId
        this.isLoading = false
        this.key++
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存网站根目录配置
    async saveWebRootConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/web'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.webRootWebId,
        rootJSON: JSON.stringify(this.rootConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getWebRootConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>{{$t('web_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('web_index@网站分组')}}</a>{{$t('web_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveWebRootConfig">
          <http-web-root-box v-if="rootConfig" :key="key" :v-root-config="rootConfig"></http-web-root-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// 页面优化管理组件（封装页面优化配置页面，风格与compression-details-box.js一致）
Vue.component("optimization-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      optimizationConfig: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      optimizationWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getOptimizationConfig()
    }, 10)
  },
  methods: {
    // 获取页面优化配置
    async getOptimizationConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/optimization'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.optimizationConfig = resp.data.optimizationConfig
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.optimizationWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存页面优化配置
    async saveOptimizationConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/optimization'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.optimizationWebId,
        optimizationJSON: JSON.stringify(this.optimizationConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getOptimizationConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>{{$t('optimization_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('optimization_index@网站分组')}}</a>{{$t('optimization_index@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveOptimizationConfig">
          <http-optimization-config-box v-if="optimizationConfig" :key="key" :v-optimization-config="optimizationConfig"></http-optimization-config-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// UAM模式配置与管理组件（重构版，适用于serverDetails目录）
Vue.component("uam-config-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      config: {
        isPrior: false,
        isOn: false,
        addToWhiteList: true,
        onlyURLPatterns: [],
        exceptURLPatterns: [],
        minQPSPerIP: 0,
        keyLife: 0,
        conds: []
      },
      moreOptionsVisible: true,
      minQPSPerIP: 0,
      keyLife: 0,
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  watch: {
    minQPSPerIP: function (v) {
      let qps = parseInt(v.toString())
      if (isNaN(qps) || qps < 0) {
        qps = 0
      }
      this.config.minQPSPerIP = qps
    },
    keyLife: function (v) {
      let keyLife = parseInt(v)
      if (isNaN(keyLife) || keyLife <= 0) {
        keyLife = 0
      }
      this.config.keyLife = keyLife
    }
  },
  methods: {
    // 获取UAM配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/uam'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.$set(this, 'config', resp.data.uamConfig)
        this.minQPSPerIP = this.config.minQPSPerIP
        this.keyLife = this.config.keyLife
        this.isLoading = false
        this.key++
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 提交UAM配置数据
    async updateData() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/uam'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        uamJSON: JSON.stringify({ ...this.config }),
        minQPSPerIP: this.config.minQPSPerIP,
        keyLife: this.config.keyLife,
        condsJSON: JSON.stringify(this.config.conds)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    showMoreOptions: function () {
      this.moreOptionsVisible = !this.moreOptionsVisible
    },
    changeConds: function (conds) {
      this.config.conds = conds
      this.updateData()
    },
    submit: function () {
      setTimeout(() => {
        this.updateData()
      }, 100)
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" method="post" :key="key">
        <input type="hidden" name="serverId" :value="serverId" />
        <input type="hidden" name="uamJSON" :value="JSON.stringify(config)"/>

        <div class="config-section">
          <div class="section-title">
            <i class="icon power"></i>
            <span>{{$t('uam-config-box@基本设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@启用5秒盾')}}</div>
            <div class="item-content">
              <p-switch v-model="config.isOn" binary @change="submit"></p-switch>
              <p class="comment"><plus-label></plus-label>{{$t('uam-config-box@启用5秒盾提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon shield alternate"></i>
            <span>{{$t('uam-config-box@防护设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@验证有效期')}}</div>
            <div class="item-content">
              <div class="ui input right labeled">
                <input type="text" name="keyLife" v-model="keyLife" maxlength="6" size="6" style="width: 6em" @blur="submit"/>
                <span class="ui label">{{$t('uam-config-box@秒')}}</span>
              </div>
              <p class="comment">{{$t('uam-config-box@验证有效期提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@单IP最低QPS')}}</div>
            <div class="item-content">
              <div class="ui input right labeled">
                <input type="text" name="minQPSPerIP" maxlength="6" style="width: 6em" v-model="minQPSPerIP" @blur="submit"/>
                <span class="ui label">{{$t('uam-config-box@请求数每秒')}}</span>
              </div>
              <p class="comment">{{$t('uam-config-box@单IP最低QPS提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@加入IP白名单')}}</div>
            <div class="item-content">
              <p-checkbox v-model="config.addToWhiteList" binary @change="submit"></p-checkbox>
              <p class="comment">{{$t('uam-config-box@加入IP白名单提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon filter"></i>
            <span>{{$t('uam-config-box@URL过滤设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@例外URL')}}</div>
            <div class="item-content">
              <url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
              <p class="comment">{{$t('uam-config-box@例外URL提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@限制URL')}}</div>
            <div class="item-content">
              <url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
              <p class="comment">{{$t('uam-config-box@限制URL提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon sliders horizontal"></i>
            <span>{{$t('uam-config-box@匹配条件')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('uam-config-box@匹配条件')}}</div>
            <div class="item-content">
              <http-request-conds-box :v-conds="config.conds" @change="changeConds"></http-request-conds-box>
            </div>
          </div>
        </div>

        <div class="margin"></div>
      </form>
    </a-spin>
  `
}) 

// User-Agent管理组件（封装User-Agent配置页面，风格与compression-details-box.js一致）
Vue.component("user-agent-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      userAgentConfig: null,
      isLoading: false,
      userAgentWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getUserAgentConfig()
    }, 10)
  },
  methods: {
    // 获取User-Agent配置
    async getUserAgentConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/userAgent'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.userAgentConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            filters: []
          }
        }
        if (config.filters == null) {
          config.filters = []
        }
        this.userAgentConfig = config
        this.userAgentWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存User-Agent配置
    async saveUserAgentConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/userAgent'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.userAgentWebId,
        userAgentJSON: JSON.stringify(this.userAgentConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getUserAgentConfig()
      })
    },
    // 组件内触发保存
    submit(config) {
      this.userAgentConfig = config
      this.saveUserAgentConfig()
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" @submit.prevent="saveUserAgentConfig" id="userAgentForm">
        <user-agent-config-box v-if="userAgentConfig" :key="key" v-model="userAgentConfig" @submit="submit"></user-agent-config-box>
      </form>
    </a-spin>
  `
}) 

// HLS管理组件（封装HLS配置页面，风格与compression-details-box.js一致）
Vue.component("hls-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      hlsConfig: null,
      isLoading: false,
      hlsWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getHlsConfig()
    }, 10)
  },
  methods: {
    // 获取HLS配置
    async getHlsConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/multimedia/hls'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.hlsConfig
        if (config == null) {
          config = {
            isPrior: false
          }
        }

        let encryptingConfig = config.encrypting
        if (encryptingConfig == null) {
          encryptingConfig = {
            isOn: false,
            onlyURLPatterns: [],
            exceptURLPatterns: []
          }
          config.encrypting = encryptingConfig
        }
        this.hlsConfig = config
        this.hlsWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存HLS配置
    async saveHlsConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/multimedia/hls'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.hlsWebId,
        hlsJSON: JSON.stringify(this.hlsConfig)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getHlsConfig()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading" :key="key">
      <form class="ui form" @submit.prevent="saveHlsConfig">
        <http-hls-config-box v-if="hlsConfig" :key="key" v-model="hlsConfig"></http-hls-config-box>
        <submit-btn></submit-btn>
      </form>
    </a-spin>
  `
}) 

// UDP配置组件（封装UDP配置页面，风格与request-limit-details-box.js一致）
Vue.component("udp-server-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      udpConfig: null,
      isLoading: false,
      serverType: "",
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取UDP配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/udp'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.udpConfig
        if (config == null) {
          config = {
            isOn: false,
            listen: []
          }
        }

        this.$set(this, 'udpConfig', config)
        this.serverType = resp.data.serverType || ""
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig() {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/udp'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        serverType: this.serverType,
        addresses: JSON.stringify(this.udpConfig.listen)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('acme_users_index_js@保存成功'))
        this.getData()
      })
    }
  },
  template: `
    <a-spin :spinning="isLoading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-broadcast"></i>
        {{$t('settings_udp_index@UDP服务设置')}}
      </div>
      

      <div class="x-alert x-alert-info" v-if="udpConfig && !udpConfig.isOn">
        <i class="pi pi-info-circle"></i>
        {{$t('settings_udp_index@当前UDP服务未启用，配置完端口后将自动启用')}}
      </div>

      <form class="x-form ui form" @submit.prevent="saveConfig">
        <input type="hidden" name="serverId" :value="serverId"/>
        <input type="hidden" name="serverType" :value="serverType"/>
        
        <div class="x-form-item">
          <div class="x-form-label">绑定端口 *</div>
          <div class="x-form-content">
            <network-addresses-box 
              :key="key"
              v-if="!isLoading"
              :v-server-type="serverType" 
              :v-addresses="udpConfig.listen" 
              :v-protocol="'udp'" 
              @change="saveConfig"
              :v-support-range="true">
            </network-addresses-box>
          </div>
        </div>
      </form>
    </a-spin>
  `
}) 

// HTTP CC防护配置与管理组件（重构版，适用于serverDetails目录）
Vue.component("http-cc-config-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      config: {
        isPrior: false,
        isOn: false,
        enableFingerprint: true,
        enableGET302: true,
        onlyURLPatterns: [],
        exceptURLPatterns: [],
        useDefaultThresholds: true,
        ignoreCommonFiles: true,
        thresholds: [
          { maxRequests: 0 },
          { maxRequests: 0 },
          { maxRequests: 0 }
        ]
      },
      moreOptionsVisible: true,
      minQPSPerIP: 0,
      useCustomThresholds: false,
      thresholdMaxRequests0: '',
      thresholdMaxRequests1: '',
      thresholdMaxRequests2: '',
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  watch: {
    minQPSPerIP: function (v) {
      let qps = parseInt(v.toString())
      if (isNaN(qps) || qps < 0) {
        qps = 0
      }
      this.config.minQPSPerIP = qps
    },
    thresholdMaxRequests0: function (v) {
      this.setThresholdMaxRequests(0, v)
    },
    thresholdMaxRequests1: function (v) {
      this.setThresholdMaxRequests(1, v)
    },
    thresholdMaxRequests2: function (v) {
      this.setThresholdMaxRequests(2, v)
    },
    useCustomThresholds: function (b) {
      this.config.useDefaultThresholds = !b
    }
  },
  methods: {
    // 获取HTTP CC配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/cc'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.ccConfig
        if (config == null) {
          config = {
            isPrior: false,
            isOn: false,
            enableFingerprint: true,
            enableGET302: true,
            onlyURLPatterns: [],
            exceptURLPatterns: [],
            useDefaultThresholds: true,
            ignoreCommonFiles: true
          }
        }

        if (config.thresholds == null || config.thresholds.length == 0) {
          config.thresholds = [
            {
              maxRequests: 0
            },
            {
              maxRequests: 0
            },
            {
              maxRequests: 0
            }
          ]
        }

        if (typeof config.enableFingerprint != "boolean") {
          config.enableFingerprint = true
        }
        if (typeof config.enableGET302 != "boolean") {
          config.enableGET302 = true
        }

        if (config.onlyURLPatterns == null) {
          config.onlyURLPatterns = []
        }
        if (config.exceptURLPatterns == null) {
          config.exceptURLPatterns = []
        }
        this.$set(this, 'config', config)
        this.minQPSPerIP = this.config.minQPSPerIP || 0
        this.useCustomThresholds = !this.config.useDefaultThresholds
        this.thresholdMaxRequests0 = this.maxRequestsStringAtThresholdIndex(this.config, 0)
        this.thresholdMaxRequests1 = this.maxRequestsStringAtThresholdIndex(this.config, 1)
        this.thresholdMaxRequests2 = this.maxRequestsStringAtThresholdIndex(this.config, 2)
        this.webId = resp.data.webId
        this.key++
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 提交HTTP CC配置数据
    async updateData() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/cc'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.webId,
        ccJSON: JSON.stringify(this.config),
        minQPSPerIP: this.config.minQPSPerIP,
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
        this.getData()
      })
    },
    maxRequestsStringAtThresholdIndex: function (config, index) {
      if (config.thresholds == null) {
        return ""
      }
      if (index < config.thresholds.length) {
        let s = config.thresholds[index].maxRequests.toString()
        if (s == "0") {
          s = ""
        }
        return s
      }
      return ""
    },
    setThresholdMaxRequests: function (index, v) {
      let maxRequests = parseInt(v)
      if (isNaN(maxRequests) || maxRequests < 0) {
        maxRequests = 0
      }
      if (index < this.config.thresholds.length) {
        this.config.thresholds[index].maxRequests = maxRequests
      }
    },
    showMoreOptions: function () {
      this.moreOptionsVisible = !this.moreOptionsVisible
    },
    submit: function () {
      setTimeout(() => {
        this.updateData()
      }, 100)
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <form class="ui form" method="post" :key="key">
        <input type="hidden" name="serverId" :value="serverId" />
        <input type="hidden" name="ccJSON" :value="JSON.stringify(config)"/>

        <div class="config-section">
          <div class="section-title">
            <i class="icon power"></i>
            <span>{{$t('http-cc-config-box@基本设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@启用CC无感防护')}}</div>
            <div class="item-content">
              <p-switch v-model="config.isOn" binary @change="submit"></p-switch>
              <p class="comment"><plus-label></plus-label>{{$t('http-cc-config-box@启用CC无感防护提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon filter"></i>
            <span>{{$t('http-cc-config-box@URL过滤设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@例外URL')}}</div>
            <div class="item-content">
              <url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
              <p class="comment">{{$t('http-cc-config-box@例外URL提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@限制URL')}}</div>
            <div class="item-content">
              <url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
              <p class="comment">{{$t('http-cc-config-box@限制URL提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@忽略常用文件')}}</div>
            <div class="item-content">
              <p-checkbox v-model="config.ignoreCommonFiles" binary @change="submit"></p-checkbox> 
              <p class="comment">{{$t('http-cc-config-box@忽略常用文件提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon shield alternate"></i>
            <span>{{$t('http-cc-config-box@防护设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@检查请求来源指纹')}}</div>
            <div class="item-content">
              <p-checkbox v-model="config.enableFingerprint" binary @change="submit"></p-checkbox>
              <p class="comment">{{$t('http-cc-config-box@检查请求来源指纹提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@启用GET302校验')}}</div>
            <div class="item-content">
              <p-checkbox v-model="config.enableGET302" binary @change="submit"></p-checkbox>
              <p class="comment">{{$t('http-cc-config-box@启用GET302校验提示')}}</p>
            </div>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@单IP最低QPS')}}</div>
            <div class="item-content">
              <div class="ui input right labeled">
                <input type="text" name="minQPSPerIP" maxlength="6" style="width: 6em" v-model="minQPSPerIP" @blur="submit"/>
                <span class="ui label">{{$t('http-cc-config-box@请求数每秒')}}</span>
              </div>
              <p class="comment">{{$t('http-cc-config-box@单IP最低QPS提示')}}</p>
            </div>
          </div>
        </div>

        <div class="config-section" v-show="moreOptionsVisible && config.isOn">
          <div class="section-title">
            <i class="icon sliders horizontal"></i>
            <span>{{$t('http-cc-config-box@拦截阈值设置')}}</span>
          </div>
          <div class="config-item">
            <div class="item-label">{{$t('http-cc-config-box@使用自定义拦截阈值')}}</div>
            <div class="item-content">
              <p-switch v-model="useCustomThresholds" binary @change="submit"></p-switch>
            </div>
          </div>
          <div class="config-item" v-show="!config.useDefaultThresholds">
            <div class="item-label">{{$t('http-cc-config-box@自定义拦截阈值')}}</div>
            <div class="item-content">
              <div class="threshold-item">
                <div class="ui input left right labeled">
                  <span class="ui label basic">{{$t('http-cc-config-box@单IP每5秒最多')}}</span>
                  <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests0" @blur="submit"/>
                  <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
              </div>
              <div class="threshold-item">
                <div class="ui input left right labeled">
                  <span class="ui label basic">{{$t('http-cc-config-box@单IP每60秒最多')}}</span>
                  <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests1" @blur="submit"/>
                  <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
              </div>
              <div class="threshold-item">
                <div class="ui input left right labeled">
                  <span class="ui label basic">{{$t('http-cc-config-box@单IP每300秒最多')}}</span>
                  <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests2" @blur="submit"/>
                  <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
              </div>
            </div>
          </div>
        </div>

        <div class="margin"></div>
      </form>
    </a-spin>
  `
}) 

// 压缩管理组件（封装压缩配置页面，风格与cache-details-box.js一致）
Vue.component("compression-details-box", {
  props: [
    "serverId",
  ],
  data: function () {
    return {
      compressionConfig: null,
      hasGroupConfig: false,
      groupSettingURL: '',
      isLoading: false,
      compressionWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getCompressionConfig()
    }, 10)
  },
  methods: {
    // 获取压缩配置
    async getCompressionConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/compression'
      const params = {
        serverId: this.serverId,
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        this.compressionConfig = resp.data.compressionConfig
        this.hasGroupConfig = resp.data.hasGroupConfig
        this.groupSettingURL = resp.data.groupSettingURL
        this.compressionWebId = resp.data.webId
        this.webId = resp.data.webId
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存压缩配置
    async saveCompressionConfig() {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/compression'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.compressionWebId,
        compressionJSON: JSON.stringify(this.compressionConfig),
        minLength: JSON.stringify(this.compressionConfig.minLength),
        maxLength: JSON.stringify(this.compressionConfig.maxLength),
        condsJSON: JSON.stringify(this.compressionConfig.conds),
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('http-compression-config-box@保存成功'))
        this.getCompressionConfig()
      })
    },
    changeCompressionConfig(config) {
      this.compressionConfig = config
    }
  },
  template: `
    <a-spin :spinning="isLoading">
      <div v-if="hasGroupConfig">
        <div class="margin"></div>
        <warning-message>{{$t('compression-config-box@由于已经在当前')}}<a :href="groupSettingURL">{{$t('compression-config-box@网站分组')}}</a>{{$t('compression-config-box@中进行了对应的配置，在这里的配置将不会生效')}}。</warning-message>
      </div>
      <div :class="{'opacity-mask': hasGroupConfig}">
        <form class="ui form" @submit.prevent="saveCompressionConfig">
          <http-compression-config-box v-if="!isLoading" :key="key" :v-compression-config="compressionConfig" @submit="changeCompressionConfig"></http-compression-config-box>
          <submit-btn></submit-btn>
        </form>
      </div>
    </a-spin>
  `
}) 

// 网站基本设置表单配置
Vue.component("basic-configuration", {
  props: [
    "serverId",
  ],
  data: function () {
    return {
      // 这里可以根据需要添加本地状态
      server: {},
      user: {},
      plans: [],
      clusters: [],
      userPlan: null,
      userPlanId: null,
      oldClusterId: null,
      typeName: null,
      moreOptionsVisible: false,
      teaIsPlus: false,
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        Object.assign(this.server, resp.data.server)
        Object.assign(this.user, resp.data.user)
        this.clusters = [...resp.data.clusters]
        this.typeName = resp.data.typeName
        this.userPlan = resp.data.userPlan
        this.teaIsPlus = resp.data.teaIsPlus
        this.getUserData()
        this.key = this.key + 1
        this.isLoading = false
      })
    },
    async updateData() {
      const path = '/servers/server/settings'
      const params = {
        serverId: this.serverId,
        name: this.server.name,
        userPlanId: this.userPlanId,
        clusterId: this.server.clusterId,
        keepOldConfigs: this.server.keepOldConfigs,
        isOn: this.server.isOn,
        description: this.server.description,
        groupIds: this.server.groups.map(group => group.id),
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        console.log("updateData -> resp", resp)
        this.$message.success(this.$t('index_保存成功_3b10'))
        this.getData()
      })
    },
    showUserSelector() {
      this.userSelectorVisible = !this.userSelectorVisible
    },
    async getUserData() {
      this.userSelectorVisible = false
      this.userId = 0
      this.plans = []
      this.userPlanId = 0
      this.oldClusterId = this.server.clusterId

      if (this.userPlan != null) {
        this.userPlanId = this.userPlan.id
      }


      if (this.user != null) {
        this.changeUserId(this.user.id)
      }
    },
    async changeUserId(v) {
      this.userId = v

      if (this.userId == 0) {
        this.plans = []
        return
      }

      await window.Tea.Vue.$post("/servers/users/plans").params({
        userId: this.userId,
        serverId: this.serverId
      }).success((resp) => {
        this.plans = resp.data.plans
      })
    }
  },
  template: `
  <a-spin :spinning="isLoading" class="x-section" v-if="server != null">
    <div class="x-section-title">
      <i class="pi pi-cog"></i>
      {{$t('index_网站基本设置_0101')}}
    </div>
    <form class="ui form" method="post" :key="key">
      <input type="hidden" name="serverId" :value="serverId" />
      <div v-if="server.trafficLimitStatus != null">
        <div class="custom-menu-margin"></div>
        <div class="x-alert x-alert-warning">
          <i class="pi pi-exclamation-triangle"></i>
          <server-traffic-limit-status-viewer
            v-model="server.trafficLimitStatus"
          >
          </server-traffic-limit-status-viewer>
        </div>
      </div>
      <div class="x-form-item">
        <div class="x-form-label">{{$t('index_所属用户_0101')}}</div>
        <div class="x-form-content">
          <div v-if="user != null">
            {{user.fullname}} <span class="x-comment">（{{user.username}}）</span>
            <a class="ant-btn ant-btn-link" type="link" :href="'/users/user?userId=' + user.id">
              <i class="pi pi-external-link"></i>
            </a>
          </div>
          <div v-if="user == null">
            <div v-show="!userSelectorVisible">
              <span class="x-comment">{{$t('index_没有指定用户_0101')}}</span>
              <a class="ant-btn ant-btn-link" type="link" @click.prevent="showUserSelector">{{$t('index_指定用户_0101')}}</a>
            </div>
            <div v-show="userSelectorVisible">
              <user-selector style="display:inline-block"></user-selector>
              <p class="x-comment"><span style="color:#e74c3c">{{$t('index_此操作同时会将与当前网站相关联的证书等数据自动修改为此用户所属_0101')}}</span></p>
            </div>
          </div>
        </div>
      </div>
      <div class="x-form-item">
        <div class="x-form-label">{{$t('index_网站名称_0101')}} *</div>
        <div class="x-form-content">
          <input class="x-input" type="text" name="name" maxlength="60" ref="focus" v-model="server.name" @blur="updateData" :placeholder="$t('index_请输入网站名称_0101')">
        </div>
      </div>
      <div class="x-form-item" v-if="plans.length > 0">
        <div class="x-form-label">{{$t('index_选择套餐_0101')}}</div>
        <div class="x-form-content">
          <b-select name="userPlanId" @change="updateData" v-model="userPlanId" auto-width :options="[
            {label: $t('index_选择套餐_0101'), value: '0'},
            ...plans.map(plan => ({
              label: (plan.name??'') + '（' + (plan.dayTo??'') + '）',
              value: plan.id,
            }))
          ]"></b-select>
        </div>
      </div>
      <div class="x-form-item" v-if="plans.length == 0 && teaIsPlus">
        <div class="x-form-label">{{$t('index_选择套餐_0101')}}</div>
        <div class="x-form-content">
          <span class="x-comment">{{$t('index_当前网站所属用户没有可用套餐_0101')}}</span>
        </div>
      </div>
      <div class="x-form-item">
        <div class="x-form-label" >{{$t('index_部署的集群_0101')}} *</div>
        <div class="x-form-content">
          <b-select name="clusterId" @change="updateData" v-model="server.clusterId" auto-width :options="[
            ...clusters.map(cluster => ({
              label: cluster.name,
              value: cluster.id,
            }))
          ]"></b-select>
        </div>
      </div>
      <div class="x-form-item" v-show="server.clusterId != oldClusterId">
        <div class="x-form-label">{{$t('index_是否保留原集群配置_0101')}}</div>
        <div class="x-form-content">
          <checkbox class="x-checkbox" name="keepOldConfigs" checked="checked" @change="updateData"></checkbox>
          <p class="x-comment">
            {{$t('index_选中表示在先前的集群节点上仍然保留当前网站的配置，直至节点配置全部刷新时才会删除；不选中，则表示立即删除原集群上关于当前网站的配置。_0101')}}
          </p>
        </div>
      </div>
      <div class="x-form-item">
        <div class="x-form-label">{{$t('index_网站类型_0101')}} *</div>
        <div class="x-form-content">
          <span class="x-comment">{{typeName}}</span>
        </div>
      </div>
      <div class="x-form-item">
        <div class="x-form-label">{{$t('index_选择分组_0101')}}</div>
        <div class="x-form-content">
          <server-group-selector :v-groups="server.groups" @submit="updateData"></server-group-selector>
        </div>
      </div>
      <div>
        <div class="x-form-item">
          <div class="x-form-label">{{$t('index_描述_0101')}}</div>
          <div class="x-form-content">
            <textarea name="description" rows="3" v-model="server.description" @blur="updateData" :placeholder="$t('index_请输入网站描述信息_0101')"></textarea>
          </div>
        </div>
        <div class="x-form-item">
          <div class="x-form-label">{{$t('index_启用当前网站_0101')}}</div>
          <div class="x-form-content">
            <checkbox class="x-checkbox" name="isOn" :v-value="1" v-model="server.isOn" @change="updateData"></checkbox>
            <p class="x-comment">{{$t('index_可以使用此选项整体关闭当前网站。_0101')}}</p>
          </div>
        </div>
      </div>
    </form>
  </a-spin>
  `
})


// 域名审核与管理组件
Vue.component("server-name-audit", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      serverNames: [],
      passedDomains: [],
      allServerNames: [],
      hasPassedDomains: false,
      auditing: 1,
      auditingResult: {
        isOk: true,
        reason: '',
        createdTime: ''
      },
      isAuditing: false,
      auditingTime: '',
      auditingReason: '',
      isLoading: false,
      key: 0
    }
  },
  mounted: function () {
    setTimeout(() => {
      this.getData()
    }, 10)
    // 其他变量可根据需要初始化
  },
  methods: {
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/serverNames'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        console.log("getData -> resp", resp)
        this.serverNames = resp.data.serverNames
        this.passedDomains = resp.data.passedDomains
        this.auditingTime = resp.data.auditingTime
        this.isAuditing = resp.data.isAuditing
        this.auditingResult = resp.data.auditingResult
        // 组装 allServerNames
        this.allServerNames = []
        let that = this
        this.serverNames.forEach(function (v) {
          if (v.subNames == null || v.subNames.length == 0) {
            that.allServerNames.push({
              name: v.name,
              isPassed: that.passedDomains.$contains(v.name)
            })
          } else {
            v.subNames.forEach(function (subName) {
              that.allServerNames.push({
                name: subName,
                isPassed: that.passedDomains.$contains(subName)
              })
            })
          }
        })

        this.hasPassedDomains = false
        this.allServerNames.forEach(function (serverName) {
          if (serverName.isPassed) {
            that.hasPassedDomains = true
          }
        })

        this.auditing = 1
        this.isLoading = false
        this.key++
      })
    },
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    async updateData() {
      const path = '/servers/server/settings/serverNames'
      let that = this
      let csrfToken = await this.getCsrfToken()
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        auditingOK: this.auditing,
        auditingReason: this.auditingReason,
        serverNames: JSON.stringify(this.serverNames)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('index_保存成功_0101'))
      })
    },
    submitAudit: function () {
      this.$emit('submit-audit')
    },
    submit: function () {
      this.$emit('submit')
    }
  },
  template: `
    <a-spin :spinning="isLoading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-shield"></i>
        {{$t('index_域名管理_0101')}}
      </div>
      <!-- 审核中 -->
      <div v-show="isAuditing" class="ui form x-form">
        <warning-message>{{$t('index_当前域名正在审核中，请审核域名的所有人、备案情况等。_0101')}}</warning-message>
        <form method="post" class="ui form">
          <input type="hidden" name="serverId" :value="serverId" />
          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_审核中域名_0101')}}</div>
            <div class="x-form-content">
              <div class="domain-labels">
                <div v-for="serverName in allServerNames" class="domain-label" :class="{green: serverName.isPassed}">
                  <div class="domain-name">
                    <i class="pi pi-globe"></i>
                    {{serverName.name}}
                  </div>
                </div>
              </div>
              <p class="comment" v-if="hasPassedDomains"><span class="green">{{$t('index_绿色_0101')}}</span>
                {{$t('index_标注的域名表示之前已经审核通过的域名。_0101')}}</p>
            </div>
          </div>

          <div class="x-form-item" v-if="auditingTime.length > 0">
            <div class="x-form-label">{{$t('index_提交审核时间_0101')}}</div>
            <div class="x-form-content">
              <span class="ui label basic">{{auditingTime}}</span>
            </div>
          </div>

          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_审核结果_0101')}}</div>
            <div class="x-form-content">
              <div class="ui segment basic">
                <radio name="auditingOK" :v-value="1" v-model="auditing">{{$t('index_审核通过_0101')}}</radio> &nbsp;
                <radio name="auditingOK" :v-value="0" v-model="auditing">{{$t('index_审核不通过_0101')}}</radio>
              </div>
            </div>
          </div>

          <div class="x-form-item" v-show="auditing == 0">
            <div class="x-form-label">{{$t('index_审核不通过原因_0101')}} *</div>
            <div class="x-form-content">
              <input class="ui input" type="text" name="auditingReason" maxlength="100" v-model="auditingReason" @blur="updateData"
                :placeholder="$t('index_包含审核不通过的域名等_0101')"></input>
            </div>
          </div>

          <div class="x-form-item">
            <div class="x-form-label"></div>
            <div class="x-form-content">
              <submit-btn>{{$t('index_提交审核结果_0101')}}</submit-btn>
            </div>
          </div>
        </form>
      </div>
      <!-- 审核不通过 -->
      <div class="audit-message error" v-if="!isAuditing && !auditingResult.isOk">
        <i class="pi pi-times-circle"></i>
        <div>
          {{$t('index_审核不通过_0101')}}，{{$t('index_原因_0101')}}：{{auditingResult.reason}}
          <div class="ui text small">（{{auditingResult.createdTime}}）。{{$t('index_等待用户重新提交_0101')}}。</div>
        </div>
      </div>
      <!-- 不在审核中 -->
      <div v-show="!isAuditing && auditingResult.isOk" class="x-form">
        <form method="post" class="ui form">
          <input type="hidden" name="serverId" :value="serverId" />
          <div class="x-form-item">
            <div class="x-form-label">{{$t('index_已绑定的域名_0101')}}</div>
            <div class="x-form-content">
              <server-name-box :key="key" :v-server-names="serverNames" @submit="updateData"></server-name-box>
              <p class="comment">{{$t('index_用户可以通过这些域名访问当前网站。_0101')}}</p>
            </div>
          </div>
        </form>
      </div>
    </a-spin>
  `
}) 

// 主机重定向管理组件（封装主机重定向配置页面，风格与compression-details-box.js一致）
Vue.component("host-redirect-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      redirects: null,
      isLoading: false,
      hostRedirectWebId: null,
      webId: null,
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getRedirectsConfig()
    }, 10)
  },
  methods: {
    // 获取主机重定向配置
    async getRedirectsConfig() {
      this.isLoading = true
      const path = '/servers/server/settings/redirects'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let redirects = resp.data.redirects
        if (redirects == null) {
          redirects = []
        }

        let id = 0
        redirects.forEach(function (v) {
          id++
          v.id = id
        })
        console.log("getRedirectsConfig -> redirects", redirects)
        this.$set(this, 'redirects', redirects)
        this.hostRedirectWebId = resp.data.webId
        this.webId = resp.data.webId
        this.isLoading = false
        this.key++
      })
    },
    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },
    // 保存主机重定向配置
    async saveRedirectsConfig(values) {
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/redirects'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        webId: this.hostRedirectWebId,
        hostRedirectsJSON: JSON.stringify(values)
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        window.teaweb.successToast(this.$t('index_保存成功_0101'), null, () => {
          this.getRedirectsConfig()
        })
      })
    },
    // 变更时自动保存
    change(values) {
      this.saveRedirectsConfig(values)
    }
  },
  template: `
      <a-spin :spinning="isLoading">
        <form class="ui form" @submit.prevent id="hostRedirectForm">
          <http-host-redirect-box v-if="redirects" :key="key" :v-redirects="redirects" @change="change"></http-host-redirect-box>
        </form>
      </a-spin>
  `
}) 

// TLS配置组件（封装TLS配置页面，风格与request-limit-details-box.js一致）
Vue.component("tls-server-details-box", {
  props: [
    "serverId"
  ],
  data: function () {
    return {
      tlsConfig: null,
      isLoading: false,
      hasGroupConfig: false,
      groupSettingURL: "",
      webId: 0,
      serverType: "",
      key: 0
    }
  },
  mounted() {
    setTimeout(() => {
      this.getData()
    }, 10)
  },
  methods: {
    // 获取TLS配置数据
    async getData() {
      this.isLoading = true
      const path = '/servers/server/settings/tls'
      const params = {
        serverId: this.serverId
      }
      await window.Tea.Vue.$get(path).params(params).success((resp) => {
        let config = resp.data.tlsConfig
        if (config == null) {
          config = {
            isOn: false,
            listen: [],
            sslPolicy: null
          }
        }

        this.$set(this, 'tlsConfig', config)
        this.hasGroupConfig = resp.data.hasGroupConfig || false
        this.groupSettingURL = resp.data.groupSettingURL || ""
        this.webId = resp.data.webId || 0
        this.serverType = resp.data.serverType || ""
        this.key = this.key + 1
        this.isLoading = false
      })
    },

    // 获取CSRF Token
    async getCsrfToken() {
      return new Promise((resolve, reject) => {
        Tea.action("/csrf/token")
          .get()
          .success(function (resp) {
            resolve(resp.data.token)
          })
      })
    },

    // 保存配置
    async saveConfig() {
      let that = this
      let csrfToken = await this.getCsrfToken()
      const path = '/servers/server/settings/tls'
      const params = {
        csrfToken: csrfToken,
        serverId: this.serverId,
        serverType: this.serverType,
        addresses: JSON.stringify(this.tlsConfig.listen),
        sslPolicyJSON: JSON.stringify(this.tlsConfig.sslPolicy),
        hstsMaxAge: this.tlsConfig.hstsMaxAge
      }
      await window.Tea.Vue.$post(path).params(params).success((resp) => {
        this.$message.success(this.$t('user-agent-config-box@保存成功'))
        this.getData()
      })
    },
    change(addresses) {
      this.tlsConfig.listen = addresses
      this.saveConfig()
    }
  },
  template: `
    <a-spin :spinning="isLoading" class="x-section">
      <div class="x-section-title">
        <i class="pi pi-shield"></i>
        {{$t('settings_tls_index@TLS服务设置')}}
      </div>
      
      <div class="x-alert x-alert-warning" v-if="hasGroupConfig">
        <i class="pi pi-exclamation-triangle"></i>
        {{$t('reverseProxy_index@由于已经在当前')}}<a :href="groupSettingURL">{{$t('reverseProxy_index@网站分组')}}</a>{{$t('reverseProxy_index@中进行了对应的配置，在这里的配置将不会生效')}}
      </div>

      <div class="x-alert x-alert-info" v-if="tlsConfig && !tlsConfig.isOn">
        <i class="pi pi-info-circle"></i>
        {{$t('settings_tls_index@当前TLS服务未启用，配置完端口后将自动启用')}}
      </div>

      <a-tabs default-active-key="basic">
        <a-tab-pane key="basic" :tab="$t('settings_tls_index@端口配置')">
          <form class="x-form ui form" :class="{'opacity-mask': hasGroupConfig}" @submit.prevent="saveConfig">
            <input type="hidden" name="serverId" :value="serverId"/>
            <input type="hidden" name="serverType" :value="serverType"/>
            
            <div class="x-form-item">
              <div class="x-form-label">{{$t('绑定端口')}} *</div>
              <div class="x-form-content">
                <network-addresses-box 
                  :key="key"
                  v-if="!isLoading"
                  :v-server-type="serverType" 
                  :v-addresses="tlsConfig.listen" 
                  :v-protocol="'tls'" 
                  :v-support-range="true"
                  @change="change">
                </network-addresses-box>
              </div>
            </div>

           
          </form>
        </a-tab-pane>
        
        <a-tab-pane key="ssl" :tab="$t('settings_tls_index@SSL/TLS配置')" v-if="tlsConfig && tlsConfig.isOn">
          <form class="x-form" @submit.prevent="saveConfig">
            <ssl-server-details-box 
              :key="key"
              v-if="!isLoading"
              :v-ssl-policy="tlsConfig.sslPolicy" 
              :v-protocol="'tls'"
              >
            </ssl-server-details-box>
             <div class="x-form-actions">
                <submit-btn>{{$t('settings_tls_index@保存设置')}}</submit-btn>
              </div>
          </form>
        </a-tab-pane>
      </a-tabs>
    </a-spin>
  `
}) 

Vue.component("ip-item-text", {
	props: ["v-item"],
	template: `<span>
    <span v-if="vItem.type == 'all'">*</span>
    <span v-else>
    	<span v-if="vItem.value != null && vItem.value.length > 0">{{vItem.value}}</span>
    	<span v-else>
			{{vItem.ipFrom}}
			<span v-if="vItem.ipTo != null &&vItem.ipTo.length > 0">- {{vItem.ipTo}}</span>
		</span>
	</span>
    <span v-if="vItem.eventLevelName != null && vItem.eventLevelName.length > 0">&nbsp; {{$t("iplist_ip-item-text@级别Colon")}} {{vItem.eventLevelName}}</span>
</span>`
})

// 绑定IP列表
Vue.component("ip-list-bind-box", {
	props: ["v-http-firewall-policy-id", "v-type"],
	mounted: function () {
		this.refresh()
	},
	data: function () {
		return {
			policyId: this.vHttpFirewallPolicyId,
			type: this.vType,
			lists: []
		}
	},
	methods: {
		bind: function () {
			let that = this
			teaweb.popup("/servers/iplists/bindHTTPFirewallPopup?httpFirewallPolicyId=" + this.policyId + "&type=" + this.type, {
				title: this.$t("iplist_ip-list-bind-box@绑定公用IP名单"),
				width: "50em",
				height: "34em",
				callback: function () {

				},
				onClose: function () {
					that.refresh()
				}
			})
		},
		remove: function (index, listId) {
			let that = this
			teaweb.confirm(this.$t("iplist_ip-list-bind-box@确定要删除这个绑定的IP名单吗"), function () {
				Tea.action("/servers/iplists/unbindHTTPFirewall")
					.params({
						httpFirewallPolicyId: that.policyId,
						listId: listId
					})
					.post()
					.success(function (resp) {
						that.lists.$remove(index)
					})
			})
		},
		refresh: function () {
			let that = this
			Tea.action("/servers/iplists/httpFirewall")
				.params({
					httpFirewallPolicyId: this.policyId,
					type: this.vType
				})
				.post()
				.success(function (resp) {
					that.lists = resp.data.lists
				})
		}
	},
	template: `<div>
	<a href="" @click.prevent="bind()" style="color: rgba(0,0,0,.6)">{{$t("iplist_ip-list-bind-box@绑定Plus")}}</a> &nbsp; <span v-if="lists.length > 0"><span class="disabled small">|&nbsp;</span> {{$t("iplist_ip-list-bind-box@已绑定Colon")}}</span>
	<div class="ui label basic small" v-for="(list, index) in lists">
		<a :href="'/servers/iplists/list?listId=' + list.id" :title="$t('iplist_ip-list-bind-box@点击查看详情')" style="opacity: 1">{{list.name}}</a>
		<a href="" :title="$t('iplist_ip-list-bind-box@删除')" @click.prevent="remove(index, list.id)"><i class="icon remove small"></i></a>
	</div>
</div>`
})

Vue.component("ip-box", {
	props: ["v-ip"],
	methods: {
		popup: function () {
			let ip = this.vIp
			if (ip == null || ip.length == 0) {
				let e = this.$refs.container
				ip = e.innerText
				if (ip == null) {
					ip = e.textContent
				}
			}

			teaweb.popup("/servers/ipbox?ip=" + ip, {
				title: this.$t("iplist_ip-box@IP最近访问日志"),
				width: "50em",
				height: "30em"
			})
		}
	},
	template: `<span @click.prevent="popup()" ref="container"><slot></slot></span>`
})

Vue.component("ip-list-table", {
	props: ["v-items", "v-keyword", "v-show-search-button"],
	data: function () {
		return {
			items: this.vItems,
			keyword: (this.vKeyword != null) ? this.vKeyword : "",
			selectedRowKeys: [],
			columns: [
				{
					title: this.$t("iplist_ip-list-table@IP"),
					key: 'ip',
					scopedSlots: { customRender: 'ipSlot' },
					width: '300px'
				},
				{
					title: this.$t("iplist_ip-list-table@类型"),
					key: 'type',
					scopedSlots: { customRender: 'typeSlot' },
					width: '100px'
				},
				{
					title: this.$t("iplist_ip-list-table@级别"),
					key: 'level',
					scopedSlots: { customRender: 'levelSlot' },
					width: '100px'
				},
				{
					title: this.$t("iplist_ip-list-table@过期时间"),
					key: 'expiredTime',
					scopedSlots: { customRender: 'expiredTimeSlot' },
					width: '200px'
				},
				{
					title: this.$t("iplist_ip-list-table@备注"),
					key: 'reason',
					scopedSlots: { customRender: 'reasonSlot' }
				},
				{
					title: this.$t("iplist_ip-list-table@操作"),
					key: 'operation',
					scopedSlots: { customRender: 'operationSlot' },
					width: '250px',
					align: 'center',
					fixed: 'right'
				}
			]
		}
	},
	methods: {
		updateItem: function (itemId) {
			this.$emit("update-item", itemId)
		},
		deleteItem: function (itemId) {
			this.$emit("delete-item", itemId)
		},
		viewLogs: function (itemId) {
			teaweb.popup("/servers/iplists/accessLogsPopup?itemId=" + itemId, {
				title: this.$t("iplist_ip-list-table@访问日志"),
				width: "50em",
				height: "30em"
			})
		},
		deleteAll: function () {
			if (this.selectedRowKeys.length === 0) return;
			let that = this;
			Tea.action("/waf/iplists/deleteItems")
				.post()
				.params({
					itemIds: this.selectedRowKeys
				})
				.success(function () {
					teaweb.successToast(that.$t("iplist_ip-list-table@批量删除成功"), 1200, teaweb.reload)
				})
		},
		formatSeconds: function (seconds) {
			if (seconds < 60) {
				return seconds + this.$t("iplist_ip-list-table@秒")
			}
			if (seconds < 3600) {
				return Math.ceil(seconds / 60) + this.$t("iplist_ip-list-table@分钟")
			}
			if (seconds < 86400) {
				return Math.ceil(seconds / 3600) + this.$t("iplist_ip-list-table@小时")
			}
			return Math.ceil(seconds / 86400) + this.$t("iplist_ip-list-table@天")
		},
		handleSelectionChange: function(selectedRowKeys) {
			this.selectedRowKeys = selectedRowKeys;
		}
	},
	computed: {
		hasSelectedItems() {
			return this.selectedRowKeys.length > 0;
		}
	},
	template: `<div>
		<div v-show="hasSelectedItems">
			<div class="ui divider"></div>
			<button class="ui button basic" type="button" @click.prevent="deleteAll">{{$t("iplist_ip-list-table@批量删除所选")}}</button>
		</div>

		<div class="margin"></div>

		<b-table
			v-if="items.length > 0"
			:columns="columns"
			:data-source="items"
			:row-key="'id'"
			:scroll="{ x: 1200 }"
			:row-selection="{
				type: 'checkbox',
				selectedRowKeys: selectedRowKeys,
				onChange: handleSelectionChange
			}"
			size="middle"
		>
			<template slot="ipSlot" slot-scope="{ text, record }">
				<span v-if="record.type != 'all'" :class="{green: record.list != null && record.list.type == 'white'}">
					<span v-if="record.value != null && record.value.length > 0">
						<keyword :v-word="keyword">{{record.value}}</keyword>
					</span>
					<span v-else>
						<keyword :v-word="keyword">{{record.ipFrom}}</keyword>
						<span>
							<span class="small red" v-if="record.isRead != null && !record.isRead">&nbsp;New&nbsp;</span>
							<a :href="'/servers/iplists?ip=' + record.ipFrom" v-if="vShowSearchButton" :title="$t('iplist_ip-list-table@搜索此IP')">
								<span><i class="icon search small" style="color: #ccc"></i></span>
							</a>
						</span>
						<span v-if="record.ipTo.length > 0"> - <keyword :v-word="keyword">{{record.ipTo}}</keyword></span>
					</span>
				</span>
				
				<div v-if="record.region != null && record.region.length > 0">
					<span class="grey small">{{record.region}}</span>
					<span v-if="record.isp != null && record.isp.length > 0 && record.isp != '内网IP'" class="grey small">
						<span class="disabled">|</span> {{record.isp}}
					</span>
				</div>
				<div v-else-if="record.isp != null && record.isp.length > 0 && record.isp != '内网IP'">
					<span class="grey small">{{record.isp}}</span>
				</div>
				
				<div v-if="record.createdTime != null">
					<span class="small grey">{{$t("iplist_ip-list-table@添加于")}} {{record.createdTime}}</span>
						<span v-if="record.list != null && record.list.id > 0">
							@ 
							<a :href="'/waf/iplists/list?listId=' + record.list.id" v-if="record.policy.id == 0">
								<span>[<span v-if="record.list.type == 'black'">{{$t("iplist_ip-list-table@黑")}}</span><span v-if="record.list.type == 'white'">{{$t("iplist_ip-list-table@白")}}</span><span v-if="record.list.type == 'grey'">{{$t("iplist_ip-list-table@灰")}}</span>{{$t("iplist_ip-list-table@名单Colon")+record.list.name}}]</span>
							</a>
							<span v-else>[<span v-if="record.list.type == 'black'">{{$t("iplist_ip-list-table@黑")}}</span><span v-if="record.list.type == 'white'">{{$t("iplist_ip-list-table@白")}}</span><span v-if="record.list.type == 'grey'">{{$t("iplist_ip-list-table@灰")}}</span>{{$t("iplist_ip-list-table@名单Colon")+record.list.name}}</span>
							
							<span v-if="record.policy.id > 0">
								<span v-if="record.policy.server != null">
									<a :href="'/servers/server/settings/waf/ipadmin/allowList?serverId=' + record.policy.server.id + '&firewallPolicyId=' + record.policy.id" v-if="record.list.type == 'white'">[{{$t("iplist_ip-list-table@网站Colon")}} {{record.policy.server.name}}]</a>
									<a :href="'/servers/server/settings/waf/ipadmin/denyList?serverId=' + record.policy.server.id + '&firewallPolicyId=' + record.policy.id" v-if="record.list.type == 'black'">[{{$t("iplist_ip-list-table@网站Colon")}} {{record.policy.server.name}}]</a>
									<a :href="'/servers/server/settings/waf/ipadmin/greyList?serverId=' + record.policy.server.id + '&firewallPolicyId=' + record.policy.id" v-if="record.list.type == 'grey'">[{{$t("iplist_ip-list-table@网站Colon")}} {{record.policy.server.name}}]</a>
								</span>
							</span>
						</span>
					</span>
				</div>
			</template>

			<template slot="typeSlot" slot-scope="{ text, record }">
				<span v-if="record.type.length == 0">IPv4</span>
				<span v-else-if="record.type == 'ipv4'">IPv4</span>
				<span v-else-if="record.type == 'ipv6'">IPv6</span>
				<span v-else-if="record.type == 'all'"><strong>{{$t("iplist_ip-list-table@所有IP")}}</strong></span>
			</template>

			<template slot="levelSlot" slot-scope="{ text, record }">
				<span v-if="record.eventLevelName != null && record.eventLevelName.length > 0">{{record.eventLevelName}}</span>
				<span v-else class="disabled">-</span>
			</template>

			<template slot="expiredTimeSlot" slot-scope="{ text, record }">
				<div v-if="record.expiredTime.length > 0">
					{{record.expiredTime}}
					<div v-if="record.isExpired && record.lifeSeconds == null" style="margin-top: 0.5em">
						<span class="ui label tiny basic red">{{$t("iplist_ip-list-table@已过期")}}</span>
					</div>
					<div v-if="record.lifeSeconds != null">
						<span class="small grey" v-if="record.lifeSeconds > 0">{{formatSeconds(record.lifeSeconds)}}</span>
						<span class="small red" v-if="record.lifeSeconds < 0">{{$t("iplist_ip-list-table@已过期")}}</span>
					</div>
				</div>
				<span v-else class="disabled">{{$t("iplist_ip-list-table@不过期")}}</span>
			</template>

			<template slot="reasonSlot" slot-scope="{ text, record }">
				<span v-if="record.reason.length > 0">{{record.reason}}</span>
				<span v-else class="disabled">-</span>
		
				<div style="margin-top: 0.4em" v-if="record.sourceServer != null && record.sourceServer.id > 0">
					<a :href="'/servers/server?serverId=' + record.sourceServer.id" style="border: 0">
						<span class="small"><i class="icon clone outline"></i>{{record.sourceServer.name}}</span>
					</a>
				</div>
				<div v-if="record.sourcePolicy != null && record.sourcePolicy.id > 0" style="margin-top: 0.4em">
					<a :href="'/servers/server/settings/waf/group?serverId=' + record.sourcePolicy.serverId + '&firewallPolicyId=' + record.sourcePolicy.id + '&type=inbound&groupId=' + record.sourceGroup.id + '#set' + record.sourceSet.id" v-if="record.sourcePolicy.serverId > 0">
						<span class="small"><i class="icon shield"></i> {{record.sourcePolicy.name}} &raquo; {{record.sourceGroup.name}} &raquo; {{record.sourceSet.name}}</span>
					</a>
				</div>
			</template>

			<template slot="operationSlot" slot-scope="{ text, record }">
				<a-button type="link" @click.prevent="viewLogs(record.id)">
					<i class="pi pi-eye" style="font-size: 12px; padding: 4px 2px;"></i> {{$t("iplist_ip-list-table@日志")}}
				</a-button>
				<a-button type="link" @click.prevent="updateItem(record.id)">
					<i class="pi pi-pencil" style="font-size: 12px; padding: 4px 2px;"></i> {{$t("iplist_ip-list-table@修改")}}
				</a-button>
				<a-button type="link" @click.prevent="deleteItem(record.id)">
					<i class="pi pi-trash" style="font-size: 12px; padding: 4px 2px;"></i> {{$t("iplist_ip-list-table@删除")}}
				</a-button>
			</template>
		</b-table>
	</div>`
})

Vue.component("origin-list-box", {
	props: ["v-primary-origins", "v-backup-origins", "v-server-type", "v-params"],
	data: function () {
		return {
			primaryOrigins: this.vPrimaryOrigins,
			backupOrigins: this.vBackupOrigins
		}
	},
	methods: {
		createPrimaryOrigin: function () {
			let that = this
			teaweb.popup("/servers/server/settings/origins/addPopup?originType=primary&" + this.vParams, {
				width: "45em",
				height: "27em",
				title: this.$t('origin-list-box@添加主要源站'),
				callback: function (resp) {
					teaweb.success(that.$t('index_保存成功_0101'), function () {
						// window.location.reload()
						that.$emit("change")
					})
				}
			})
		},
		createBackupOrigin: function () {
			let that = this
			teaweb.popup("/servers/server/settings/origins/addPopup?originType=backup&" + this.vParams, {
				width: "45em",
				height: "27em",
				title: this.$t('origin-list-box@添加备用源站'),
				callback: function (resp) {
					teaweb.success(that.$t('index_保存成功_0101'), function () {
						// window.location.reload()
						that.$emit("change")
					})
				}
			})
		},
		updateOrigin: function (originId, originType) {
			let that = this
			teaweb.popup("/servers/server/settings/origins/updatePopup?originType=" + originType + "&" + this.vParams + "&originId=" + originId, {
				title: this.$t('origin-list-box@修改源站'),
				width: "45em",
				height: "27em",
				callback: function (resp) {
					teaweb.success(that.$t('index_保存成功_0101'), function () {
						// window.location.reload()
						that.$emit("change")
					})
				}
			})
		},
		deleteOrigin: function (originId, originAddr, originType) {
			let that = this
			teaweb.confirm(that.$t('origin-list-box@确定要删除此源站')+"（" + originAddr + "）" + that.$t('origin-list-box@吗'), function () {
				Tea.action("/servers/server/settings/origins/delete?" + that.vParams + "&originId=" + originId + "&originType=" + originType)
					.post()
					.success(function () {
						teaweb.success(that.$t('index_删除_0101') + that.$t('index_成功_0101'), function () {
							// window.location.reload()
							that.$emit("change")
						})
					})
			})
		},
		updateOriginIsOn: function (originId, originAddr, isOn) {
			let message
			let resultMessage
			if (isOn) {
				message = this.$t('origin-list-box@确定要启用此源站')+"（" + originAddr + "）" + this.$t('origin-list-box@吗');
				resultMessage = this.$t('origin-list-box@启用成功')
			} else {
				message = this.$t('origin-list-box@确定要停用此源站')+"（" + originAddr + "）" + this.$t('origin-list-box@吗');
				resultMessage = this.$t('origin-list-box@停用成功')
			}
			let that = this
			teaweb.confirm(message, function () {
				Tea.action("/servers/server/settings/origins/updateIsOn?" + that.vParams + "&originId=" + originId + "&isOn=" + (isOn ? 1 : 0))
					.post()
					.success(function () {
						teaweb.success(resultMessage, function () {
							// window.location.reload()
							that.$emit("change")
						})
					})
			})
		},
	},
	template: `<div class="http-config-container">
		<div class="config-item">
			<div class="item-label">{{$t('origin-list-box@主要源站')}}</div>
			<div class="item-content">
				<div class="action-buttons">
					<button class="ui button small" type="button" @click.prevent="createPrimaryOrigin()">{{$t('origin-list-box@添加主要源站')}}</button>
				</div>
				<p class="comment" v-if="primaryOrigins.length == 0">{{$t('origin-list-box@暂时还没有主要源站')}}</p>
				<origin-list-table v-if="primaryOrigins.length > 0" :v-origins="vPrimaryOrigins" :v-origin-type="'primary'" @delete-origin="deleteOrigin" @update-origin="updateOrigin" @update-origin-is-on="updateOriginIsOn"></origin-list-table>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('origin-list-box@备用源站')}}</div>
			<div class="item-content">
				<div class="action-buttons">
					<button class="ui button small" type="button" @click.prevent="createBackupOrigin()">{{$t('origin-list-box@添加备用源站')}}</button>
				</div>
				<p class="comment" v-if="backupOrigins.length == 0">{{$t('origin-list-box@暂时还没有备用源站')}}</p>
				<origin-list-table v-if="backupOrigins.length > 0" :v-origins="backupOrigins" :v-origin-type="'backup'" @delete-origin="deleteOrigin" @update-origin="updateOrigin" @update-origin-is-on="updateOriginIsOn"></origin-list-table>
			</div>
		</div>
	</div>`
})

Vue.component("firewall-event-level-options", {
    props: ["v-value"],
    mounted: function () {
        let that = this
        Tea.action("/ui/eventLevelOptions")
            .post()
            .success(function (resp) {
                that.levels = resp.data.eventLevels
                that.change()
            })
    },
    data: function () {
        let value = this.vValue
        if (value == null || value.length == 0) {
            value = "" // 不要给默认值，因为黑白名单等默认值均有不同
        }

        return {
            levels: [],
            description: "",
            level: value
        }
    },
    methods: {
        change: function () {
            this.$emit("change")

            let that = this
            let l = this.levels.$find(function (k, v) {
                return v.code == that.level
            })
            if (l != null) {
                this.description = l.description
            } else {
                this.description = ""
            }
        }
    },
    template: `<div>
        <b-select
            name="eventLevel"
            v-model="level"
            @change="change"
            auto-width
            :options="[
                ...levels.map(level => ({
                label: level.name??'',
                value: level.code??'',
                }))
            ]"
        ></b-select>

        <p class="comment">{{description}}</p>
    </div>`
})

Vue.component("prior-checkbox", {
	props: ["v-config", "description"],
	data: function () {
		let description = this.description
		const t = this.$root.t
		if (description == null) {
			description = t("prior-checkbox@打开后可以覆盖父级或子级配置")
		}
		return {
			isPrior: this.vConfig.isPrior,
			realDescription: description
		}
	},
	watch: {
		isPrior: function (v) {
			this.vConfig.isPrior = v
		}
	},
	methods: {
		handleChange: function () {
			this.vConfig.isPrior = this.isPrior
			this.$emit('change', this.vConfig)
		}
	},
	template: `<div class="config-item" :class="{active:isPrior}">
		<div class="item-label">{{$t('prior-checkbox@打开独立配置')}}</div>
		<div class="item-content">
			<p-switch v-model="isPrior" binary @change="handleChange"></p-switch>
			<p class="comment"><strong v-if="isPrior">{{$t('prior-checkbox@已打开')}}</strong> {{realDescription}}</p>
		</div>
	</div>`
})

Vue.component("http-location-labels", {
	props: ["v-location-config", "v-server-id"],
	data: function () {
		return {
			location: this.vLocationConfig
		}
	},
	methods: {
		// 判断是否已启用某配置
		configIsOn: function (config) {
			return config != null && config.isPrior && config.isOn
		},

		refIsOn: function (ref, config) {
			return this.configIsOn(ref) && config != null && config.isOn
		},

		len: function (arr) {
			return (arr == null) ? 0 : arr.length
		},
		url: function (path) {
			return "/servers/server/settings/locations" + path + "?serverId=" + this.vServerId + "&locationId=" + this.location.id
		}
	},
	template: `	<div class="labels-box">
	<!-- 基本信息 -->
	<http-location-labels-label v-if="location.name != null && location.name.length > 0" :class="'olive'" :href="url('/location')">{{location.name}}</http-location-labels-label>
	
	<!-- domains -->
	<div v-if="location.domains != null && location.domains.length > 0">
		<grey-label v-for="domain in location.domains">{{domain}}</grey-label>
	</div>
	
	<!-- break -->
	<http-location-labels-label v-if="location.isBreak" :href="url('/location')">BREAK</http-location-labels-label>
	
	<!-- redirectToHTTPS -->
	<http-location-labels-label v-if="location.web != null && configIsOn(location.web.redirectToHTTPS)" :href="url('/http')">{{$t('http-location-labels@自动跳转HTTPS')}}</http-location-labels-label>
	
	<!-- Web -->
	<http-location-labels-label v-if="location.web != null && configIsOn(location.web.root)" :href="url('/web')">{{$t('http-location-labels@文档根目录')}}</http-location-labels-label>
	
	<!-- 反向代理 -->
	<http-location-labels-label v-if="refIsOn(location.reverseProxyRef, location.reverseProxy)" :v-href="url('/reverseProxy')">{{$t('http-location-labels@源站')}}</http-location-labels-label>
	
	<!-- UAM -->
	<http-location-labels-label v-if="location.web != null && location.web.uam != null && location.web.uam.isPrior"><span :class="{disabled: !location.web.uam.isOn, red:location.web.uam.isOn}">{{$t('http-location-labels@5秒盾')}}</span></http-location-labels-label>
	
	<!-- CC -->
	<http-location-labels-label v-if="location.web != null && location.web.cc != null && location.web.cc.isPrior"><span :class="{disabled: !location.web.cc.isOn, red:location.web.cc.isOn}">{{$t('http-location-labels@CC防护')}}</span></http-location-labels-label>
	
	<!-- WAF -->
	<!-- TODO -->
	
	<!-- Cache -->
	<http-location-labels-label v-if="location.web != null && configIsOn(location.web.cache)" :v-href="url('/cache')">CACHE</http-location-labels-label>
	
	<!-- Charset -->
	<http-location-labels-label v-if="location.web != null && configIsOn(location.web.charset) && location.web.charset.charset.length > 0" :href="url('/charset')">{{location.web.charset.charset}}</http-location-labels-label>
	
	<!-- 访问日志 -->
	<!-- TODO -->
	
	<!-- 统计 -->
	<!-- TODO -->
	
	<!-- Gzip -->
	<http-location-labels-label v-if="location.web != null && refIsOn(location.web.gzipRef, location.web.gzip) && location.web.gzip.level > 0" :href="url('/gzip')">Gzip:{{location.web.gzip.level}}</http-location-labels-label>
	
	<!-- HTTP Header -->
	<http-location-labels-label v-if="location.web != null && refIsOn(location.web.requestHeaderPolicyRef, location.web.requestHeaderPolicy) && (len(location.web.requestHeaderPolicy.addHeaders) > 0 || len(location.web.requestHeaderPolicy.setHeaders) > 0 || len(location.web.requestHeaderPolicy.replaceHeaders) > 0 || len(location.web.requestHeaderPolicy.deleteHeaders) > 0)" :href="url('/headers')">{{$t('http-location-labels@请求Header')}}</http-location-labels-label>
	<http-location-labels-label v-if="location.web != null && refIsOn(location.web.responseHeaderPolicyRef, location.web.responseHeaderPolicy) && (len(location.web.responseHeaderPolicy.addHeaders) > 0 || len(location.web.responseHeaderPolicy.setHeaders) > 0 || len(location.web.responseHeaderPolicy.replaceHeaders) > 0 || len(location.web.responseHeaderPolicy.deleteHeaders) > 0)" :href="url('/headers')">{{$t('http-location-labels@响应Header')}}</http-location-labels-label>
	
	<!-- Websocket -->
	<http-location-labels-label v-if="location.web != null && refIsOn(location.web.websocketRef, location.web.websocket)" :href="url('/websocket')">Websocket</http-location-labels-label>
	
	<!-- 请求脚本 -->
	<http-location-labels-label v-if="location.web != null && location.web.requestScripts != null && ((location.web.requestScripts.initGroup != null && location.web.requestScripts.initGroup.isPrior) || (location.web.requestScripts.requestGroup != null && location.web.requestScripts.requestGroup.isPrior))" :href="url('/requestScripts')">{{$t('http-location-labels@请求脚本')}}</http-location-labels-label>
	
	<!-- 自定义访客IP地址 -->
	<http-location-labels-label v-if="location.web != null && location.web.remoteAddr != null && location.web.remoteAddr.isPrior" :href="url('/remoteAddr')" :class="{disabled: !location.web.remoteAddr.isOn}">{{$t('http-location-labels@访客IP地址')}}</http-location-labels-label>
	
	<!-- 请求限制 -->
	<http-location-labels-label v-if="location.web != null && location.web.requestLimit != null && location.web.requestLimit.isPrior" :href="url('/requestLimit')" :class="{disabled: !location.web.requestLimit.isOn}">{{$t('http-location-labels@请求限制')}}</http-location-labels-label>
		
	<!-- 自定义页面 -->
	<div v-if="location.web != null && location.web.pages != null && location.web.pages.length > 0">
		<div v-for="page in location.web.pages" :key="page.id"><http-location-labels-label :href="url('/pages')" v-html="$t('http-location-labels@自定义页面状态码提示', [page.status[0], page.url])"></http-location-labels-label></div>
	</div>
	<div v-if="location.web != null && configIsOn(location.web.shutdown)">
		<http-location-labels-label :v-class="'red'" :href="url('/pages')">{{$t('http-location-labels@临时关闭')}}</http-location-labels-label>
	</div>
	
	<!-- 重写规则 -->
	<div v-if="location.web != null && location.web.rewriteRules != null && location.web.rewriteRules.length > 0">
		<div v-for="rewriteRule in location.web.rewriteRules">
			<http-location-labels-label :href="url('/rewrite')" v-html="$t('http-location-labels@重写规则提示', [rewriteRule.pattern, rewriteRule.replace])"></http-location-labels-label>
		</div>
	</div>
</div>`
})

Vue.component("http-location-labels-label", {
	props: ["v-class", "v-href"],
	template: `<a :href="vHref" class="ui label tiny basic" :class="vClass" style="font-size:0.7em;padding:4px;margin-top:0.3em;margin-bottom:0.3em"><slot></slot></a>`
})

Vue.component("user-agent-config-box", {
	props: ["v-is-location", "v-is-group", "value"],
	data: function () {
		let config = this.value
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				filters: []
			}
		}
		if (config.filters == null) {
			config.filters = []
		}
		return {
			config: config,
			isAdding: false,
			addingFilter: {
				keywords: [],
				action: "deny"
			},
			moreOptionsVisible: false,
			batchKeywords: ""
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		remove: function (index) {
			let that = this
			teaweb.confirm(this.$t('user-agent-config-box@确定要删除此名单吗'), function () {
				that.config.filters.$remove(index)
				that.submit()
			})
		},
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.batchKeywords.focus()
			})
		},
		confirm: function () {
			if (this.addingFilter.action == "deny") {
				this.config.filters.push(this.addingFilter)
			} else {
				let index = -1
				this.config.filters.forEach(function (filter, filterIndex) {
					if (filter.action == "allow") {
						index = filterIndex
					}
				})

				if (index < 0) {
					this.config.filters.unshift(this.addingFilter)
				} else {
					this.config.filters.$insert(index + 1, this.addingFilter)
				}
			}
			this.submit()
			this.cancel()
		},
		cancel: function () {
			this.isAdding = false
			this.addingFilter = {
				keywords: [],
				action: "deny"
			}
			this.batchKeywords = ""
		},
		changeKeywords: function (keywords) {
			let arr = keywords.split(/\n/)
			let resultKeywords = []
			arr.forEach(function (keyword) {
				keyword = keyword.trim()
				if (!resultKeywords.$contains(keyword)) {
					resultKeywords.push(keyword)
				}
			})
			this.addingFilter.keywords = resultKeywords
		},
		showMoreOptions: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="user-agent-box">
	<input type="hidden" name="userAgentJSON" :value="JSON.stringify(config)"/>
	
	<div class="config-section">
		<div class="section-title">
		  <i class="icon power"></i>
			<span>{{$t('user-agent-config-box@UserAgent设置')}}</span>
		</div>
		
		<div v-if="vIsLocation || vIsGroup" class="config-item">
			<prior-checkbox :v-config="config"></prior-checkbox>
		</div>
		
		<div v-show="(!vIsLocation && !vIsGroup) || config.isPrior" class="config-item">
			<div class="item-label">{{$t('user-agent-config-box@启用UA名单')}}</div>
			<div class="item-content">
				<p-switch v-model="config.isOn" binary @change="submit"></p-switch>
				<p class="comment">{{$t('user-agent-config-box@选中后表示开启UserAgent名单')}}</p>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon list"></i>
			<span>{{$t('user-agent-config-box@UA名单')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<div v-if="config.filters.length > 0" class="ua-filters-table-box">
                    <b-table
                        :columns="[
                            { title: $t('user-agent-config-box@UA关键词'), key: 'keywords', scopedSlots: { customRender: 'keywordsSlot' } },
                            { title: $t('user-agent-config-box@动作'), key: 'actionType', width: '8em', scopedSlots: { customRender: 'actionTypeSlot' } },
                            { title: $t('user-agent-config-box@操作'), key: 'action', width: '6em', scopedSlots: { customRender: 'actionSlot' } }
                        ]"
                        :data-source="config.filters"
                        :row-key="(record, index) => index"
                        :pagination="false"
                    >
                        <template slot="keywordsSlot" slot-scope="{ text, record }">
                             <div class="ua-keywords">
                                <span v-for="keyword in record.keywords" class="ui label basic tiny" :key="keyword">
                                    <span v-if="keyword.length > 0">{{keyword}}</span>
                                    <span v-if="keyword.length == 0" class="disabled">{{$t('user-agent-config-box@空')}}</span>
                                </span>
                            </div>
                        </template>
                        <template slot="actionTypeSlot" slot-scope="{ text, record }">
                            <span v-if="record.action == 'allow'" class="green">{{$t('user-agent-config-box@允许')}}</span>
                            <span v-if="record.action == 'deny'" class="red">{{$t('user-agent-config-box@不允许')}}</span>
                        </template>
                        <template slot="actionSlot" slot-scope="{ text, record, index }">
                            <a-button type="link" danger @click.prevent="remove(index)">{{$t('user-agent-config-box@删除')}}</a-button>
                        </template>
                    </b-table>
				</div>
				
				<div v-if="isAdding" class="ua-adding-box">
					<div class="config-item">
						<div class="item-label">{{$t('user-agent-config-box@UA关键词')}}</div>
						<div class="item-content">
							<textarea v-model="batchKeywords" @input="changeKeywords(batchKeywords)" ref="batchKeywords" style="width: 100%; max-width: 30em" :placeholder="$t('user-agent-config-box@浏览器标识')"></textarea>
							<p class="comment">{{$t('user-agent-config-box@每行一个关键词不区分大小写比如')}}<code-label>Chrome</code-label>{{$t('user-agent-config-box@支持')}}<code-label>*</code-label>{{$t('user-agent-config-box@通配符比如')}}<code-label>Firefox</code-label>{{$t('user-agent-config-box@也支持空行的关键词表示空UserAgent')}}</p>
						</div>
					</div>
					
					<div class="config-item">
						<div class="item-label">{{$t('user-agent-config-box@动作')}}</div>
						<div class="item-content">
							<b-select v-model="addingFilter.action" :options="[
								{label: $t('user-agent-config-box@不允许'), value:'deny'},
								{label: $t('user-agent-config-box@允许'), value:'allow'},
							]"></b-select>
						</div>
					</div>
					
					<div class="config-item">
						<div class="item-label"></div>
						<div class="item-content">
							<div class="ua-actions-box">
								<button type="button" class="ui button tiny primary" @click.prevent="confirm">{{$t('user-agent-config-box@保存')}}</button>
								<a href="" @click.prevent="cancel" class="ui button tiny">{{$t('user-agent-config-box@取消')}}</a>
							</div>
						</div>
					</div>
				</div>
				
				<div v-show="!isAdding" class="ua-add-button">
					<button class="ui button tiny primary" type="button" @click.prevent="add">{{$t('user-agent-config-box@添加UA名单')}}</button>
				</div>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon cog"></i>
			<span>{{$t('user-agent-config-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('user-agent-config-box@例外URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('user-agent-config-box@如果填写了例外URL表示这些URL跳过不做处理')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('user-agent-config-box@限制URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('user-agent-config-box@如果填写了限制URL表示只对这些URL进行处理如果不填则表示支持所有的URL')}}</p>
			</div>
		</div>
	</div>
	
	<div class="margin"></div>
</div>`
})

Vue.component("http-firewall-province-selector", {
	props: ["v-type", "v-provinces"],
	data: function () {
		let provinces = this.vProvinces
		if (provinces == null) {
			provinces = []
		}

		return {
			listType: this.vType,
			provinces: provinces
		}
	},
	methods: {
		addProvince: function () {
			let selectedProvinceIds = this.provinces.map(function (province) {
				return province.id
			})
			let that = this
			teaweb.popup("/servers/server/settings/waf/ipadmin/selectProvincesPopup?type=" + this.listType + "&selectedProvinceIds=" + selectedProvinceIds.join(","), {
				width: "50em",
				height: "26em",
				title: this.$t('http-firewall-province-selector@选择省份PopupTitle'),
				callback: function (resp) {
					that.provinces = resp.data.selectedProvinces
					that.$forceUpdate()
					that.notifyChange()
				}
			})
		},
		removeProvince: function (index) {
			this.provinces.$remove(index)
			this.notifyChange()
		},
		resetProvinces: function () {
			this.provinces = []
			this.notifyChange()
		},
		notifyChange: function () {
			this.$emit("change", {
				"provinces": this.provinces
			})
		}
	},
	template: `<div>
	<span v-if="provinces.length == 0" class="disabled">{{$t('http-firewall-province-selector@暂时没有选择')}}<span v-if="listType =='allow'">{{$t('http-firewall-province-selector@允许')}}</span><span v-else>{{$t('http-firewall-province-selector@封禁')}}</span>{{$t('http-firewall-province-selector@的省份')}}</span>
	<div v-show="provinces.length > 0">
		<div class="ui label tiny basic" v-for="(province, index) in provinces" style="margin-bottom: 0.5em">
			<input type="hidden" :name="listType + 'ProvinceIds'" :value="province.id"/>
			{{province.name}} <a href="" @click.prevent="removeProvince(index)" :title="$t('http-firewall-province-selector@删除')"><i class="icon remove"></i></a>
		</div>
	</div>
	<div class="ui divider"></div>
	<button type="button" class="ui button tiny" @click.prevent="addProvince">{{$t('http-firewall-province-selector@修改')}}</button> &nbsp; <button type="button" class="ui button tiny" v-show="provinces.length > 0" @click.prevent="resetProvinces">{{$t('http-firewall-province-selector@清空')}}</button>
</div>`
})

Vue.component("http-firewall-provider-selector", {
	props: ["v-type", "v-providers"],
	data: function () {
		let providers = this.vProviders
		if (providers == null) {
			providers = []
		}

		return {
			listType: this.vType,
			providers: providers
		}
	},
	methods: {
		addProvider: function () {
			let selectedProviderIds = this.providers.map(function (provider) {
				return provider.id
			})
			let that = this
			teaweb.popup("/servers/server/settings/waf/ipadmin/selectProvidersPopup?type=" + this.listType + "&selectedProviderIds=" + selectedProviderIds.join(","), {
				title: this.$t('http-firewall-provider-selector@选择运营商PopupTitle'),
				width: "50em",
				height: "26em",
				callback: function (resp) {
					that.providers = resp.data.selectedProviders
					that.$forceUpdate()
					that.notifyChange()
				}
			})
		},
		removeProvider: function (index) {
			this.providers.$remove(index)
			this.notifyChange()
		},
		resetProviders: function () {
			this.providers = []
			this.notifyChange()
		},
		notifyChange: function () {
			this.$emit("change", {
				"providers": this.providers
			})
		}
	},
	template: `<div>
	<span v-if="providers.length == 0" class="disabled">{{$t('http-firewall-provider-selector@暂时没有选择')}}<span v-if="listType =='allow'">{{$t('http-firewall-provider-selector@允许')}}</span><span v-else>{{$t('http-firewall-provider-selector@封禁')}}</span>{{$t('http-firewall-provider-selector@的运营商')}}</span>
	<div v-show="providers.length > 0">
		<div class="ui label tiny basic" v-for="(provider, index) in providers" style="margin-bottom: 0.5em">
			<input type="hidden" :name="listType + 'ProviderIds'" :value="provider.id"/>
			{{provider.name}} <a href="" @click.prevent="removeProvider(index)" :title="$t('http-firewall-provider-selector@删除')"><i class="icon remove"></i></a>
		</div>
	</div>
	<div class="ui divider"></div>
	<button type="button" class="ui button tiny" @click.prevent="addProvider">{{$t('http-firewall-provider-selector@修改')}}</button> &nbsp; <button type="button" class="ui button tiny" v-show="providers.length > 0" @click.prevent="resetProviders">{{$t('http-firewall-provider-selector@清空')}}</button>
</div>`
})

// 通用设置
Vue.component("http-common-config-box", {
	props: ["v-common-config"],
	data: function () {
		let config = this.vCommonConfig
		if (config == null) {
			config = {
				mergeSlashes: false
			}
		}
		return {
			config: config
		}
	},
	template: `<div class="config-section">
	<div class="section-title">
		<i class="icon setting"></i>
		<span>{{$t("http-common-config-box@通用设置")}}</span>
	</div>
	<div class="config-content">
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="config.mergeSlashes" name="mergeSlashes" :v-value="1">{{$t("http-common-config-box@合并重复的路径分隔符")}}</checkbox>
				<p class="comment">{{$t('http-common-config-box@合并URL中重复的路径')}}<code-label>//hello/world</code-label>{{$t('http-common-config-box@中的')}}<code-label>//</code-label>。</p>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("server-group-selector", {
	props: ["v-groups"],
	data: function () {
		let groups = this.vGroups
		if (groups == null) {
			groups = []
		}
		return {
			groups: groups
		}
	},
	methods: {
		selectGroup: function () {
			let that = this
			let groupIds = this.groups.map(function (v) {
				return v.id.toString()
			}).join(",")
			teaweb.popup("/servers/groups/selectPopup?selectedGroupIds=" + groupIds, {
				title: this.$t('server-group-selector@选择分组'),
				callback: function (resp) {
					that.groups.push(resp.data.group)
					that.$emit("change", that.groups)
				}
			})
		},
		addGroup: function () {
			let that = this
			teaweb.popup("/servers/groups/createPopup", {
				title: this.$t('server-group-selector@创建分组'),
				callback: function (resp) {
					that.groups.push(resp.data.group)
					that.$emit("change", that.groups)
				}
			})
		},
		removeGroup: function (index) {
			this.groups.$remove(index)
			this.$emit("change", this.groups)
		},
		groupIds: function () {
			return this.groups.map(function (v) {
				return v.id
			})
		}
	},
	template: `<div>
	<div v-if="groups.length > 0">
		<div class="ui label small basic" v-if="groups.length > 0" v-for="(group, index) in groups">
			<input type="hidden" name="groupIds" :value="group.id"/>
			{{group.name}} &nbsp;<a href="" title="删除" @click.prevent="removeGroup(index)"><i class="icon remove"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div>
		<a href="" @click.prevent="selectGroup()">{{$t('server-group-selector@选择分组')}}</a> &nbsp; <a href="" @click.prevent="addGroup()">{{$t('server-group-selector@添加分组')}}</a>
	</div>
</div>`
})

Vue.component("http-gzip-box", {
	props: ["v-gzip-config", "v-gzip-ref", "v-is-location"],
	data: function () {
		let gzip = this.vGzipConfig
		if (gzip == null) {
			gzip = {
				isOn: true,
				level: 0,
				minLength: null,
				maxLength: null,
				conds: null
			}
		}

		return {
			gzip: gzip,
			advancedVisible: false
		}
	},
	methods: {
		isOn: function () {
			return (!this.vIsLocation || this.vGzipRef.isPrior) && this.vGzipRef.isOn
		},
		changeAdvancedVisible: function (v) {
			this.advancedVisible = v
		}
	},
	template: `<div>
<input type="hidden" name="gzipRefJSON" :value="JSON.stringify(vGzipRef)"/> 
<table class="ui table selectable definition">
	<prior-checkbox :v-config="vGzipRef" v-if="vIsLocation"></prior-checkbox>
	<tbody v-show="!vIsLocation || vGzipRef.isPrior">
		<tr>
			<td class="title">{{$t("server_http-gzip-box@启用Gzip压缩")}}</td>
			<td>
				<checkbox :v-value="1" v-model="vGzipRef.isOn"></checkbox>
			</td>
		</tr>
	</tbody>
	<tbody v-show="isOn()">
		<tr>
			<td class="title">{{$t("server_http-gzip-box@压缩级别")}}</td>
			<td>
				<select class="dropdown auto-width" name="level" v-model="gzip.level">
					<option value="0">{{$t("server_http-gzip-box@不压缩")}}</option>
					<option v-for="i in 9" :value="i">{{i}}</option>
				</select>
				<p class="comment">{{$t("server_http-gzip-box@级别越高压缩比例越大")}}</p>
			</td>
		</tr>
	</tbody>
	<more-options-tbody @change="changeAdvancedVisible" v-if="isOn()"></more-options-tbody>
	<tbody v-show="isOn() && advancedVisible">
		<tr>
			<td>{{$t("server_http-gzip-box@Gzip内容最小长度")}}</td>
			<td>
				<size-capacity-box :v-name="'minLength'" :v-value="gzip.minLength" :v-unit="'kb'"></size-capacity-box>
				<p class="comment">{{$t("server_http-gzip-box@Gzip内容最小长度提示")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-gzip-box@Gzip内容最大长度")}}</td>
			<td>
				<size-capacity-box :v-name="'maxLength'" :v-value="gzip.maxLength" :v-unit="'mb'"></size-capacity-box>
				<p class="comment">{{$t("server_http-gzip-box@Gzip内容最大长度提示")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-gzip-box@匹配条件")}}</td>
			<td>
				<http-request-conds-box :v-conds="gzip.conds"></http-request-conds-box>
</td>
		</tr>
	</tbody>
</table>
</div>`
})

// URL扩展名条件
Vue.component("http-cond-url-extension", {
	props: ["v-cond"],
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPathLowerExtension}",
			operator: "in",
			value: "[]"
		}
		if (this.vCond != null && this.vCond.param == cond.param) {
			cond.value = this.vCond.value
		}

		let extensions = []
		try {
			extensions = JSON.parse(cond.value)
		} catch (e) {

		}

		return {
			cond: cond,
			extensions: extensions, // TODO 可以拖动排序

			isAdding: false,
			addingExt: ""
		}
	},
	watch: {
		extensions: function () {
			this.cond.value = JSON.stringify(this.extensions)
		}
	},
	methods: {
		addExt: function () {
			this.isAdding = !this.isAdding

			if (this.isAdding) {
				let that = this
				setTimeout(function () {
					that.$refs.addingExt.focus()
				}, 100)
			}
		},
		cancelAdding: function () {
			this.isAdding = false
			this.addingExt = ""
		},
		confirmAdding: function () {
			// TODO 做更详细的校验
			// TODO 如果有重复的则提示之

			if (this.addingExt.length == 0) {
				return
			}

			let that = this
			this.addingExt.split(/[,;，；|]/).forEach(function (ext) {
				ext = ext.trim()
				if (ext.length > 0) {
					if (ext[0] != ".") {
						ext = "." + ext
					}
					ext = ext.replace(/\s+/g, "").toLowerCase()
					that.extensions.push(ext)
				}
			})

			// 清除状态
			this.cancelAdding()
		},
		removeExt: function (index) {
			this.extensions.$remove(index)
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<div v-if="extensions.length > 0">
		<div class="ui label small basic" v-for="(ext, index) in extensions">{{ext}} <a href="" :title="$t('http-cond-url-extension@删除')" @click.prevent="removeExt(index)"><i class="pi pi-times"></i></a></div>
		<div class="ui divider"></div>
	</div>
	<div class="ui fields inline" v-if="isAdding">
		<div class="ui field">
			<input type="text" size="20" maxlength="100" v-model="addingExt" ref="addingExt" placeholder=".xxx, .yyy" @keyup.enter="confirmAdding" @keypress.enter.prevent="1" />
		</div>
		<div class="ui field">
			<button class="ui button tiny basic" type="button" @click.prevent="confirmAdding">{{$t('http-cond-url-extension@确认')}}</button>
			<a href="" :title="$t('http-cond-url-extension@取消')" @click.prevent="cancelAdding"><i class="icon remove"></i></a>
		</div> 
	</div>
	<div style="margin-top: 1em" v-show="!isAdding">
		<button class="ui button tiny basic" type="button" @click.prevent="addExt()">{{$t('http-cond-url-extension@添加扩展名')}}</button>
	</div>
	<p class="comment">{{$t('http-cond-url-extension@扩展名需要包含点_符号_例如')}}<code-label>.jpg</code-label>、<code-label>.png</code-label>{{$t('之类_多个扩展名用逗号分割')}}</p>
</div>`
})

// 排除URL扩展名条件
Vue.component("http-cond-url-not-extension", {
	props: ["v-cond"],
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPathLowerExtension}",
			operator: "not in",
			value: "[]"
		}
		if (this.vCond != null && this.vCond.param == cond.param) {
			cond.value = this.vCond.value
		}

		let extensions = []
		try {
			extensions = JSON.parse(cond.value)
		} catch (e) {

		}

		return {
			cond: cond,
			extensions: extensions, // TODO 可以拖动排序

			isAdding: false,
			addingExt: ""
		}
	},
	watch: {
		extensions: function () {
			this.cond.value = JSON.stringify(this.extensions)
		}
	},
	methods: {
		addExt: function () {
			this.isAdding = !this.isAdding

			if (this.isAdding) {
				let that = this
				setTimeout(function () {
					that.$refs.addingExt.focus()
				}, 100)
			}
		},
		cancelAdding: function () {
			this.isAdding = false
			this.addingExt = ""
		},
		confirmAdding: function () {
			// TODO 做更详细的校验
			// TODO 如果有重复的则提示之

			if (this.addingExt.length == 0) {
				return
			}
			if (this.addingExt[0] != ".") {
				this.addingExt = "." + this.addingExt
			}
			this.addingExt = this.addingExt.replace(/\s+/g, "").toLowerCase()
			this.extensions.push(this.addingExt)

			// 清除状态
			this.cancelAdding()
		},
		removeExt: function (index) {
			this.extensions.$remove(index)
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<div v-if="extensions.length > 0">
		<div class="ui label small basic" v-for="(ext, index) in extensions">{{ext}} <a href="" :title="$t('http-cond-url-not-extension@删除')" @click.prevent="removeExt(index)"><i class="icon remove"></i></a></div>
		<div class="ui divider"></div>
	</div>
	<div class="ui fields inline" v-if="isAdding">
		<div class="ui field">
			<input type="text" size="6" maxlength="100" v-model="addingExt" ref="addingExt" placeholder=".xxx" @keyup.enter="confirmAdding" @keypress.enter.prevent="1" />
		</div>
		<div class="ui field">
			<button class="ui button tiny basic" type="button" @click.prevent="confirmAdding">{{$t('http-cond-url-not-extension@确认')}}</button>
			<a href="" :title="$t('http-cond-url-not-extension@取消')" @click.prevent="cancelAdding"><i class="icon remove"></i></a>
		</div> 
	</div>
	<div style="margin-top: 1em" v-show="!isAdding">
		<button class="ui button tiny basic" type="button" @click.prevent="addExt()">{{$t('http-cond-url-not-extension@添加扩展名')}}</button>
	</div>
	<p class="comment">{{$t('http-cond-url-not-extension@扩展名需要包含点_符号_例如')}}<code-label>.jpg</code-label>、<code-label>.png</code-label>{{$t('http-cond-url-not-extension@之类')}}</p>
</div>`
})

// 根据URL前缀
Vue.component("http-cond-url-prefix", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "prefix",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof (this.vCond.value) == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-prefix@URL前缀_有此前缀的URL都将会被匹配_通常以')}}<code-label>/</code-label>{{$t('http-cond-url-prefix@开头_比如')}}<code-label>/static</code-label><code-label>/images</code-label>{{$t('http-cond-url-prefix@不需要带域名')}}</p>
</div>`
})

Vue.component("http-cond-url-not-prefix", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "prefix",
			value: "",
			isReverse: true,
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-not-prefix@要排除的URL前缀_有此前缀的URL都将会被匹配_通常以')}}<code-label>/</code-label>{{$t('http-cond-url-not-prefix@开头_比如')}}<code-label>/static</code-label>、<code-label>/images</code-label>{{$t('http-cond-url-not-prefix@不需要带域名')}}</p>
</div>`
})

// 首页
Vue.component("http-cond-url-eq-index", {
	props: ["v-cond"],
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "eq",
			value: "/",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" disabled="disabled" style="background: #eee"/>
	<p class="comment">{{$t('http-cond-url-eq-index@检查URL路径是为')}}<code-label>/</code-label>{{$t('http-cond-url-eq-index@不需要带域名')}}</p>
</div>`
})

// 全站
Vue.component("http-cond-url-all", {
	props: ["v-cond"],
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "prefix",
			value: "/",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" disabled="disabled" style="background: #eee"/>
	<p class="comment">{{$t('http-cond-url-all@支持全站所有URL')}}</p>
</div>`
})

// URL精准匹配
Vue.component("http-cond-url-eq", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "eq",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-eq@完整的URL路径_通常以')}}<code-label>/</code-label>{{$t('http-cond-url-eq@开头_比如')}}<code-label>/static/ui.js</code-label>{{$t('http-cond-url-eq@不需要带域名')}}</p>
</div>`
})

Vue.component("http-cond-url-not-eq", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "eq",
			value: "",
			isReverse: true,
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-not-eq@要排除的完整的URL路径_通常以')}}<code-label>/</code-label>{{$t('http-cond-url-not-eq@开头_比如')}}<code-label>/static/ui.js</code-label>{{$t('http-cond-url-not-eq@不需要带域名')}}</p>
</div>`
})

// URL正则匹配
Vue.component("http-cond-url-regexp", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "regexp",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-regexp@匹配URL的正则表达式_比如')}}<code-label>^/static/(.*).js$</code-label>，{{$t('http-cond-url-regexp@不需要带域名')}}</p>
</div>`
})

// 排除URL正则匹配
Vue.component("http-cond-url-not-regexp", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "not regexp",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-not-regexp@strong_不要_strong_匹配URL的正则表达式_意即只要匹配成功则排除此条件_比如')}}<code-label>^/static/(.*).js$</code-label>，{{$t('http-cond-url-not-regexp@不需要带域名')}}</p>
</div>`
})

// URL通配符
Vue.component("http-cond-url-wildcard-match", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${requestPath}",
			operator: "wildcard match",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-url-wildcard-match@匹配URL的通配符_用星号')}}<code-label>*</code-label>{{$t('http-cond-url-wildcard-match@表示任意字符_比如')}}<code-label>/images/*.png</code-label>、<code-label>/static/*</code-label>，{{$t('http-cond-url-wildcard-match@不需要带域名')}}</p>
</div>`
})

// User-Agent正则匹配
Vue.component("http-cond-user-agent-regexp", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${userAgent}",
			operator: "regexp",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-user-agent-regexp@匹配User_Agent的正则表达式_比如')}}<code-label>Android</code-label>、<code-label>iPhone</code-label></p>
</div>`
})

// User-Agent正则不匹配
Vue.component("http-cond-user-agent-not-regexp", {
	props: ["v-cond"],
	mounted: function () {
		this.$refs.valueInput.focus()
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "${userAgent}",
			operator: "not regexp",
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null && typeof this.vCond.value == "string") {
			cond.value = this.vCond.value
		}
		return {
			cond: cond
		}
	},
	methods: {
		changeCaseInsensitive: function (isCaseInsensitive) {
			this.cond.isCaseInsensitive = isCaseInsensitive
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<input type="text" v-model="cond.value" ref="valueInput"/>
	<p class="comment">{{$t('http-cond-user-agent-not-regexp@匹配User_Agent的正则表达式_比如')}}<code-label>Android|iPhone</code-label>，{{$t('http-cond-user-agent-not-regexp@如果匹配_则排除此条件')}}</p>
</div>`
})

// 根据MimeType
Vue.component("http-cond-mime-type", {
	props: ["v-cond"],
	data: function () {
		let cond = {
			isRequest: false,
			param: "${response.contentType}",
			operator: "mime type",
			value: "[]"
		}
		if (this.vCond != null && this.vCond.param == cond.param) {
			cond.value = this.vCond.value
		}
		return {
			cond: cond,
			mimeTypes: JSON.parse(cond.value), // TODO 可以拖动排序

			isAdding: false,
			addingMimeType: ""
		}
	},
	watch: {
		mimeTypes: function () {
			this.cond.value = JSON.stringify(this.mimeTypes)
		}
	},
	methods: {
		addMimeType: function () {
			this.isAdding = !this.isAdding

			if (this.isAdding) {
				let that = this
				setTimeout(function () {
					that.$refs.addingMimeType.focus()
				}, 100)
			}
		},
		cancelAdding: function () {
			this.isAdding = false
			this.addingMimeType = ""
		},
		confirmAdding: function () {
			// TODO 做更详细的校验
			// TODO 如果有重复的则提示之

			if (this.addingMimeType.length == 0) {
				return
			}
			this.addingMimeType = this.addingMimeType.replace(/\s+/g, "")
			this.mimeTypes.push(this.addingMimeType)

			// 清除状态
			this.cancelAdding()
		},
		removeMimeType: function (index) {
			this.mimeTypes.$remove(index)
		}
	},
	template: `<div>
	<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
	<div v-if="mimeTypes.length > 0">
		<div class="ui label small" v-for="(mimeType, index) in mimeTypes">{{mimeType}} <a href="" :title="$t('http-cond-mime-type@删除')" @click.prevent="removeMimeType(index)"><i class="icon remove"></i></a></div>
		<div class="ui divider"></div>
	</div>
	<div class="ui fields inline" v-if="isAdding">
		<div class="ui field">
			<input type="text" size="16" maxlength="100" v-model="addingMimeType" ref="addingMimeType" :placeholder="$t('http-cond-mime-type@类似于image_png')" @keyup.enter="confirmAdding" @keypress.enter.prevent="1" />
		</div>
		<div class="ui field">
			<button class="ui button tiny basic" type="button" @click.prevent="confirmAdding">{{$t('http-cond-mime-type@确认')}}</button>
			<a href="" :title="$t('http-cond-mime-type@取消')" @click.prevent="cancelAdding"><i class="icon remove"></i></a>
		</div> 
	</div>
	<div style="margin-top: 1em">
		<button class="ui button tiny basic" type="button" @click.prevent="addMimeType()">{{$t('http-cond-mime-type@添加MimeType')}}</button>
	</div>
	<p class="comment" v-html="$t('http-cond-mime-type@服务器返回的内容的MimeType_比如_span_class_ui_label_tiny_text_html_span_span_class_ui_label_tiny_image_span_等')"></p>
</div>`
})

// 参数匹配
Vue.component("http-cond-params", {
	props: ["v-cond"],
	mounted: function () {
		let cond = this.vCond
		if (cond == null) {
			return
		}
		this.operator = cond.operator

		// stringValue
		if (["regexp", "not regexp", "eq", "not", "prefix", "suffix", "contains", "not contains", "eq ip", "gt ip", "gte ip", "lt ip", "lte ip", "ip range"].$contains(cond.operator)) {
			this.stringValue = cond.value
			return
		}

		// numberValue
		if (["eq int", "eq float", "gt", "gte", "lt", "lte", "mod 10", "ip mod 10", "mod 100", "ip mod 100"].$contains(cond.operator)) {
			this.numberValue = cond.value
			return
		}

		// modValue
		if (["mod", "ip mod"].$contains(cond.operator)) {
			let pieces = cond.value.split(",")
			this.modDivValue = pieces[0]
			if (pieces.length > 1) {
				this.modRemValue = pieces[1]
			}
			return
		}

		// stringValues
		let that = this
		if (["in", "not in", "file ext", "mime type"].$contains(cond.operator)) {
			try {
				let arr = JSON.parse(cond.value)
				if (arr != null && (arr instanceof Array)) {
					arr.forEach(function (v) {
						that.stringValues.push(v)
					})
				}
			} catch (e) {

			}
			return
		}

		// versionValue
		if (["version range"].$contains(cond.operator)) {
			let pieces = cond.value.split(",")
			this.versionRangeMinValue = pieces[0]
			if (pieces.length > 1) {
				this.versionRangeMaxValue = pieces[1]
			}
			return
		}
	},
	data: function () {
		let cond = {
			isRequest: true,
			param: "",
			operator: window.REQUEST_COND_OPERATORS[0].op,
			value: "",
			isCaseInsensitive: false
		}
		if (this.vCond != null) {
			cond = this.vCond
		}
		return {
			cond: cond,
			operators: window.REQUEST_COND_OPERATORS,
			operator: window.REQUEST_COND_OPERATORS[0].op,
			operatorDescription: window.REQUEST_COND_OPERATORS[0].description,
			variables: window.REQUEST_VARIABLES,
			variable: "",

			// 各种类型的值
			stringValue: "",
			numberValue: "",

			modDivValue: "",
			modRemValue: "",

			stringValues: [],

			versionRangeMinValue: "",
			versionRangeMaxValue: ""
		}
	},
	methods: {
		changeVariable: function () {
			let v = this.cond.param
			if (v == null) {
				v = ""
			}
			this.cond.param = v + this.variable
		},
		changeOperator: function () {
			let that = this
			this.operators.forEach(function (v) {
				if (v.op == that.operator) {
					that.operatorDescription = v.description
				}
			})

			this.cond.operator = this.operator

			// 移动光标
			let box = document.getElementById("variables-value-box")
			if (box != null) {
				setTimeout(function () {
					let input = box.getElementsByTagName("INPUT")
					if (input.length > 0) {
						input[0].focus()
					}
				}, 100)
			}
		},
		changeStringValues: function (v) {
			this.stringValues = v
			this.cond.value = JSON.stringify(v)
		}
	},
	watch: {
		stringValue: function (v) {
			this.cond.value = v
		},
		numberValue: function (v) {
			// TODO 校验数字
			this.cond.value = v
		},
		modDivValue: function (v) {
			if (v.length == 0) {
				return
			}
			let div = parseInt(v)
			if (isNaN(div)) {
				div = 1
			}
			this.modDivValue = div
			this.cond.value = div + "," + this.modRemValue
		},
		modRemValue: function (v) {
			if (v.length == 0) {
				return
			}
			let rem = parseInt(v)
			if (isNaN(rem)) {
				rem = 0
			}
			this.modRemValue = rem
			this.cond.value = this.modDivValue + "," + rem
		},
		versionRangeMinValue: function (v) {
			this.cond.value = this.versionRangeMinValue + "," + this.versionRangeMaxValue
		},
		versionRangeMaxValue: function (v) {
			this.cond.value = this.versionRangeMinValue + "," + this.versionRangeMaxValue
		}
	},
	template: `<tbody>
	<tr>
		<td style="width: 8em">{{$t('http-cond-params@参数值')}}</td>
		<td>
			<input type="hidden" name="condJSON" :value="JSON.stringify(cond)"/>
			<div>
				<div class="ui field">
					<input type="text" placeholder="\${xxx}" v-model="cond.param"/>
				</div>
				<div class="ui field">
					<b-select
						style="width: 16em; color: grey"
						v-model="variable"
						@change="changeVariable"
						:options="[
							{label: $t('http-cond-params@常用参数'), value: ''},
							...variables.map(v => ({
								label: (v.code??'') + '-' + (v.name??''),
								value: v.code??'',
							}))
						]"
					></b-select>

					<!--<select class="ui dropdown" style="width: 16em; color: grey" v-model="variable" @change="changeVariable">
						<option value="">[常用参数]</option>
						<option v-for="v in variables" :value="v.code">{{v.code}} - {{v.name}}</option>
					</select>-->
				</div>
			</div>
			<p class="comment">{{$t('http-cond-params@其中可以使用变量_类似于')}}<code-label>\\$\{requestPath\}</code-label>{{$t('http-cond-params@也可以是多个变量的组合')}}</p>
		</td>
	</tr>
	<tr>
		<td>{{$t('http-cond-params@操作符')}}</td>
		<td>
			<div>
				<b-select
					v-model="operator"
					auto-width
					@change="changeOperator"
					:options="[
						{label: 'aaaa', value: ''},
						...operators.map(operator => ({
							label: operator.name??'',
							value: operator.id??'',
						}))
					]"
				></b-select>

				<!--<select class="ui dropdown auto-width" v-model="operator" @change="changeOperator">
					<option v-for="operator in operators" :value="operator.op">{{operator.name}}</option>
				</select>-->
				<p class="comment" v-html="operatorDescription"></p>
			</div>
		</td>
	</tr>
	<tr v-show="!['file exist', 'file not exist'].$contains(cond.operator)">
		<td>{{$t('http-cond-params@对比值')}}</td>
		<td id="variables-value-box">
			<!-- 正则表达式 -->
			<div v-if="['regexp', 'not regexp'].$contains(cond.operator)">
				<input type="text" v-model="stringValue"/>
				<p class="comment">{{$t('http-cond-params@要匹配的正则表达式_比如')}}<code-label>^/static/(.+).js</code-label>。</p>
			</div>
			
			<!-- 数字相关 -->
			<div v-if="['eq int', 'eq float', 'gt', 'gte', 'lt', 'lte'].$contains(cond.operator)">
				<input type="text" maxlength="11" size="11" style="width: 5em" v-model="numberValue"/>
				<p class="comment">{{$t('http-cond-params@要对比的数字')}}</p>
			</div>
			
			<!-- 取模 -->
			<div v-if="['mod 10'].$contains(cond.operator)">
				<input type="text" maxlength="11" size="11" style="width: 5em" v-model="numberValue"/>
				<p class="comment">{{$t('http-cond-params@参数值除以10的余数_在0_9之间')}}</p>
			</div>
			<div v-if="['mod 100'].$contains(cond.operator)">
				<input type="text" maxlength="11" size="11" style="width: 5em" v-model="numberValue"/>
				<p class="comment">{{$t('http-cond-params@参数值除以100的余数_在0_99之间')}}</p>
			</div>
			<div v-if="['mod', 'ip mod'].$contains(cond.operator)">
				<div class="ui fields inline">
					<div class="ui field">{{$t('http-cond-params@除')}}</div>
					<div class="ui field">
						<input type="text" maxlength="11" size="11" style="width: 5em" v-model="modDivValue" :placeholder="$t('http-cond-params@除数')"/>
					</div>
					<div class="ui field">{{$t('http-cond-params@余')}}</div>
					<div class="ui field">
						<input type="text" maxlength="11" size="11" style="width: 5em" v-model="modRemValue" :placeholder="$t('http-cond-params@余数')"/>
					</div>
				</div>
			</div>
			
			<!-- 字符串相关 -->
			<div v-if="['eq', 'not', 'prefix', 'suffix', 'contains', 'not contains'].$contains(cond.operator)">
				<input type="text" v-model="stringValue"/>
				<p class="comment" v-if="cond.operator == 'eq'">{{$t('http-cond-params@和参数值一致的字符串')}}</p>
				<p class="comment" v-if="cond.operator == 'not'">{{$t('http-cond-params@和参数值不一致的字符串')}}</p>
				<p class="comment" v-if="cond.operator == 'prefix'">{{$t('http-cond-params@参数值的前缀')}}</p>
				<p class="comment" v-if="cond.operator == 'suffix'">{{$t('http-cond-params@参数值的后缀为此字符串')}}</p>
				<p class="comment" v-if="cond.operator == 'contains'">{{$t('http-cond-params@参数值包含此字符串')}}</p>
				<p class="comment" v-if="cond.operator == 'not contains'">{{$t('http-cond-params@参数值不包含此字符串')}}</p>
			</div>
			<div v-if="['in', 'not in', 'file ext', 'mime type'].$contains(cond.operator)">
				<values-box @change="changeStringValues" :values="stringValues" size="15"></values-box>
				<p class="comment" v-if="cond.operator == 'in'">{{$t('http-cond-params@添加参数值列表')}}</p>
				<p class="comment" v-if="cond.operator == 'not in'">{{$t('http-cond-params@添加参数值列表')}}</p>
				<p class="comment" v-if="cond.operator == 'file ext'">{{$t('http-cond-params@添加扩展名列表_比如')}}<code-label>png</code-label>、<code-label>html</code-label>、{{$t('http-cond-params@不包括点')}}</p>
				<p class="comment" v-if="cond.operator == 'mime type'">{{$t('http-cond-params@添加MimeType列表_类似于')}}<code-label>text/html</code-label>、<code-label>image/*</code-label>。</p>
			</div>
			<div v-if="['version range'].$contains(cond.operator)">
				<div class="ui fields inline">
					<div class="ui field"><input type="text" v-model="versionRangeMinValue" maxlength="200" :placeholder="$t('http-cond-params@最小版本')" style="width: 10em"/></div>
					<div class="ui field">-</div>
					<div class="ui field"><input type="text" v-model="versionRangeMaxValue" maxlength="200" :placeholder="$t('http-cond-params@最大版本')" style="width: 10em"/></div>
				</div>
			</div>
			
			<!-- IP相关 -->
			<div v-if="['eq ip', 'gt ip', 'gte ip', 'lt ip', 'lte ip', 'ip range'].$contains(cond.operator)">
				<input type="text" style="width: 10em" v-model="stringValue" placeholder="x.x.x.x"/>
				<p class="comment">{{$t('http-cond-params@要对比的IP')}}</p>
			</div>
			<div v-if="['ip mod 10'].$contains(cond.operator)">
				<input type="text" maxlength="11" size="11" style="width: 5em" v-model="numberValue"/>
				<p class="comment">{{$t('http-cond-params@参数中IP转换成整数后除以10的余数_在0_9之间')}}</p>
			</div>
			<div v-if="['ip mod 100'].$contains(cond.operator)">
				<input type="text" maxlength="11" size="11" style="width: 5em" v-model="numberValue"/>
				<p class="comment">{{$t('http-cond-params@参数中IP转换成整数后除以100的余数_在0_99之间')}}</p>
			</div>
		</td>
	</tr>
	<tr v-if="['regexp', 'not regexp', 'eq', 'not', 'prefix', 'suffix', 'contains', 'not contains', 'in', 'not in'].$contains(cond.operator)">
		<td>{{$t('http-cond-params@不区分大小写')}}</td>
		<td>
			<checkbox :v-value="1" name="condIsCaseInsensitive" v-model="cond.isCaseInsensitive"></checkbox>
			<p class="comment">{{$t('http-cond-params@选中后表示对比时忽略参数值的大小写')}}</p>
		</td>
	</tr>
</tbody>
`
})

// 域名列表
Vue.component("domains-box", {
	props: ["v-domains", "name", "v-support-wildcard"],
	data: function () {
		let domains = this.vDomains
		if (domains == null) {
			domains = []
		}

		let realName = "domainsJSON"
		if (this.name != null && typeof this.name == "string") {
			realName = this.name
		}

		let supportWildcard = true
		if (typeof this.vSupportWildcard == "boolean") {
			supportWildcard = this.vSupportWildcard
		}

		return {
			domains: domains,

			mode: "single", // single | batch
			batchDomains: "",

			isAdding: false,
			addingDomain: "",

			isEditing: false,
			editingIndex: -1,

			realName: realName,
			supportWildcard: supportWildcard
		}
	},
	watch: {
		vSupportWildcard: function (v) {
			if (typeof v == "boolean") {
				this.supportWildcard = v
			}
		},
		mode: function (mode) {
			let that = this
			setTimeout(function () {
				if (mode == "single") {
					if (that.$refs.addingDomain != null) {
						that.$refs.addingDomain.focus()
					}
				} else if (mode == "batch") {
					if (that.$refs.batchDomains != null) {
						that.$refs.batchDomains.focus()
					}
				}
			}, 100)
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingDomain.focus()
			}, 100)
		},
		confirm: function () {
			if (this.mode == "batch") {
				this.confirmBatch()
				return
			}

			let that = this

			// 删除其中的空格
			this.addingDomain = this.addingDomain.replace(/\s/g, "")

			if (this.addingDomain.length == 0) {
				teaweb.warn(this.$t('domains-box@请输入要添加的域名'), function () {
					that.$refs.addingDomain.focus()
				})
				return
			}

			// 基本校验
			if (this.supportWildcard) {
				if (this.addingDomain[0] == "~") {
					let expr = this.addingDomain.substring(1)
					try {
						new RegExp(expr)
					} catch (e) {
						teaweb.warn(this.$t('domains-box@正则表达式错误') + "：" + e.message, function () {
							that.$refs.addingDomain.focus()
						})
						return
					}
				}
			} else {
				if (/[*~^]/.test(this.addingDomain)) {
					teaweb.warn(this.$t('domains-box@当前只支持添加普通域名域名中不能含有特殊符号'), function () {
						that.$refs.addingDomain.focus()
					})
					return
				}
			}

			if (this.isEditing && this.editingIndex >= 0) {
				this.domains[this.editingIndex] = this.addingDomain
			} else {
				// 分割逗号（，）、顿号（、）
				if (this.addingDomain.match("[，、,;]")) {
					let domainList = this.addingDomain.split(new RegExp("[，、,;]"))
					domainList.forEach(function (v) {
						if (v.length > 0) {
							that.domains.push(v)
						}
					})
				} else {
					this.domains.push(this.addingDomain)
				}
			}
			this.cancel()
			this.change()
		},
		confirmBatch: function () {
			let domains = this.batchDomains.split("\n")
			let realDomains = []
			let that = this
			let hasProblems = false
			domains.forEach(function (domain) {
				if (hasProblems) {
					return
				}
				if (domain.length == 0) {
					return
				}
				if (that.supportWildcard) {
					if (domain == "~") {
						let expr = domain.substring(1)
						try {
							new RegExp(expr)
						} catch (e) {
							hasProblems = true
							teaweb.warn(this.$t('domains-box@正则表达式错误') + "：" + e.message, function () {
								that.$refs.batchDomains.focus()
							})
							return
						}
					}
				} else {
					if (/[*~^]/.test(domain)) {
						hasProblems = true
						teaweb.warn(this.$t('domains-box@当前只支持添加普通域名域名中不能含有特殊符号'), function () {
							that.$refs.batchDomains.focus()
						})
						return
					}
				}
				realDomains.push(domain)
			})
			if (hasProblems) {
				return
			}
			if (realDomains.length == 0) {
				teaweb.warn(this.$t('domains-box@请输入要添加的域名'), function () {
					that.$refs.batchDomains.focus()
				})
				return
			}

			realDomains.forEach(function (domain) {
				that.domains.push(domain)
			})
			this.cancel()
			this.change()
		},
		edit: function (index) {
			this.addingDomain = this.domains[index]
			this.isEditing = true
			this.editingIndex = index
			let that = this
			setTimeout(function () {
				that.$refs.addingDomain.focus()
			}, 50)
		},
		remove: function (index) {
			this.domains.$remove(index)
			this.change()
		},
		cancel: function () {
			this.isAdding = false
			this.mode = "single"
			this.batchDomains = ""
			this.isEditing = false
			this.editingIndex = -1
			this.addingDomain = ""
		},
		change: function () {
			this.$emit("change", this.domains)
		}
	},
	template: `<div>
	<input type="hidden" :name="realName" :value="JSON.stringify(domains)"/>
	<div v-if="domains.length > 0">
		<span class="ui label small basic" v-for="(domain, index) in domains" :class="{blue: index == editingIndex}">
			<span v-if="domain.length > 0 && domain[0] == '~'" class="grey" style="font-style: normal">{{$t('domains-box@正则')}}</span>
			<span v-if="domain.length > 0 && domain[0] == '.'" class="grey" style="font-style: normal">{{$t('domains-box@后缀')}}</span>
			<span v-if="domain.length > 0 && domain[0] == '*'" class="grey" style="font-style: normal">{{$t('domains-box@泛域名')}}</span>
			{{domain}}
			<span v-if="!isAdding && !isEditing">
				&nbsp; <a href="" :title="$t('domains-box@修改')" @click.prevent="edit(index)"><i class="icon pencil small"></i></a>
				&nbsp; <a href="" :title="$t('domains-box@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
			</span>
			<span v-if="isAdding || isEditing">
				&nbsp; <a class="disabled"><i class="icon pencil small"></i></a>
				&nbsp; <a class="disabled"><i class="pi pi-times"></i></a>
			</span>
		</span>
		<div class="ui divider"></div>
	</div>
	<div v-if="isAdding || isEditing">
		<div class="ui fields">
			<div class="ui field" v-if="isAdding">
				<b-select
					v-model="mode"
					:options="[
						{label: $t('domains-box@单个'), value: 'single'},
						{label: $t('domains-box@批量'), value: 'batch'},
					]"
				></b-select>
			</div>
			<div class="ui field">
				<div v-show="mode == 'single'">
					<input type="text" v-model="addingDomain" @keyup.enter="confirm()" @keypress.enter.prevent="1" @keydown.esc="cancel()" ref="addingDomain" :placeholder="supportWildcard ? $t('domains-box@example_com_example_com') : $t('domains-box@example_com_www_example_com')" size="30" maxlength="100"/>
				</div>
				<div v-show="mode == 'batch'">
					<textarea cols="30" v-model="batchDomains" :placeholder="$t('domains-box@example1_com_example2_com_每行一个域名')" ref="batchDomains"></textarea>
				</div>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{$t('domains-box@确定')}}</button>
				&nbsp; <a href="" :title="$t('domains-box@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<p class="comment" v-if="supportWildcard">{{$t('domains-box@支持普通域名')}}（<code-label>example.com</code-label>）、{{ $t('domains-box@泛域名') }}（<code-label>*.example.com</code-label>）<span v-if="vSupportWildcard == undefined">、{{ $t('domains-box@域名后缀') }}（{{ $t('domains-box@以点号开头') }}，{{ $t('domains-box@如') }}<code-label>.example.com</code-label>）和{{ $t('domains-box@正则表达式') }}（{{ $t('domains-box@以波浪号开头') }}，{{ $t('domains-box@如') }}<code-label>~.*.example.com</code-label>）</span>；{{ $t('domains-box@如果域名后有端口，请加上端口号') }}。</p>
		<p class="comment" v-if="!supportWildcard">{{ $t('domains-box@只支持普通域名') }}（<code-label>example.com</code-label>、<code-label>www.example.com</code-label>）。</p>
		<div class="ui divider"></div>
	</div>
	<div style="margin-top: 0.5em" v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

// 浏览条件列表
Vue.component("http-request-conds-view", {
	props: ["v-conds"],
	data: function () {
		let conds = this.vConds
		if (conds == null) {
			conds = {
				isOn: true,
				connector: "or",
				groups: []
			}
		}
		if (conds.groups == null) {
			conds.groups = []
		}

		let that = this
		conds.groups.forEach(function (group) {
			group.conds.forEach(function (cond) {
				cond.typeName = that.typeName(cond)
			})
		})

		return {
			initConds: conds
		}
	},
	computed: {
		// 之所以使用computed，是因为需要动态更新
		conds: function () {
			return this.initConds
		}
	},
	methods: {
		typeName: function (cond) {
			let c = window.REQUEST_COND_COMPONENTS.$find(function (k, v) {
				return v.type == cond.type
			})
			if (c != null) {
				return c.name;
			}
			return cond.param + " " + cond.operator
		},
		updateConds: function (conds) {
			this.initConds = conds
		},
		notifyChange: function () {
			let that = this
			if (this.initConds.groups != null) {
				this.initConds.groups.forEach(function (group) {
					group.conds.forEach(function (cond) {
						cond.typeName = that.typeName(cond)
					})
				})
				this.$forceUpdate()
			}
		}
	},
	template: `<div>
		<div v-if="conds.groups.length > 0">
			<div v-for="(group, groupIndex) in conds.groups">
				<var v-for="(cond, index) in group.conds" style="font-style: normal;display: inline-block; margin-bottom:0.5em">
					<span class="ui label small basic" style="line-height: 1.5">
						<var v-if="cond.type.length == 0 || cond.type == 'params'" style="font-style: normal">{{cond.param}} <var>{{cond.operator}}</var></var>
						<var v-if="cond.type.length > 0 && cond.type != 'params'" style="font-style: normal">{{cond.typeName}}: </var>
						{{cond.value}}
						<sup v-if="cond.isCaseInsensitive" title="不区分大小写"><i class="icon info small"></i></sup>
					</span>
					
					<var v-if="index < group.conds.length - 1"> {{group.connector}} &nbsp;</var>
				</var>
				<div class="ui divider" v-if="groupIndex != conds.groups.length - 1" style="margin-top:0.3em;margin-bottom:0.5em"></div>
				<div>
					<span class="ui label tiny olive" v-if="group.description != null && group.description.length > 0">{{group.description}}</span>
				</div>
			</div>	
		</div>
	</div>	
</div>`
})

Vue.component("server-name-box", {
	props: ["v-server-names"],
	data: function () {
		let serverNames = this.vServerNames;
		if (serverNames == null) {
			serverNames = []
		}
		return {
			serverNames: serverNames,
			isSearching: false,
			keyword: ""
		}
	},
	methods: {
		addServerName: function () {
			window.UPDATING_SERVER_NAME = null
			let that = this
			teaweb.popup("/servers/addServerNamePopup", {
				title: this.$t('index_添加域名绑定_0101'),
				callback: function (resp) {
					var serverName = resp.data.serverName
					that.serverNames.push(serverName)
					setTimeout(that.submitForm, 100)
				}
			});
		},

		removeServerName: function (index) {
			this.serverNames.$remove(index)
			setTimeout(that.submitForm, 100)
		},

		updateServerName: function (index, serverName) {
			window.UPDATING_SERVER_NAME = teaweb.clone(serverName)
			let that = this
			teaweb.popup("/servers/addServerNamePopup", {
				title: this.$t('index_修改域名绑定_0101'),
				callback: function (resp) {
					var serverName = resp.data.serverName
					Vue.set(that.serverNames, index, serverName)
					setTimeout(that.submitForm, 100)
				}
			});
		},
		showSearchBox: function () {
			this.isSearching = !this.isSearching
			if (this.isSearching) {
				let that = this
				setTimeout(function () {
					that.$refs.keywordRef.focus()
				}, 200)
			} else {
				this.keyword = ""
			}
		},
		allServerNames: function () {
			if (this.serverNames == null) {
				return []
			}
			let result = []
			this.serverNames.forEach(function (serverName) {
				if (serverName.subNames != null && serverName.subNames.length > 0) {
					serverName.subNames.forEach(function (subName) {
						if (subName != null && subName.length > 0) {
							if (!result.$contains(subName)) {
								result.push(subName)
							}
						}
					})
				} else if (serverName.name != null && serverName.name.length > 0) {
					if (!result.$contains(serverName.name)) {
						result.push(serverName.name)
					}
				}
			})
			return result
		},
		submitForm: function () {
			this.$emit('submit')
			//Tea.runActionOn(this.$refs.serverNamesRef.form)
		}
	},
	watch: {
		keyword: function (v) {
			this.serverNames.forEach(function (serverName) {
				if (v.length == 0) {
					serverName.isShowing = true
					return
				}
				if (serverName.subNames == null || serverName.subNames.length == 0) {
					if (!teaweb.match(serverName.name, v)) {
						serverName.isShowing = false
					}
				} else {
					let found = false
					serverName.subNames.forEach(function (subName) {
						if (teaweb.match(subName, v)) {
							found = true
						}
					})
					serverName.isShowing = found
				}
			})
		}
	},
	template: `<div>
	<input type="hidden" name="serverNames" :value="JSON.stringify(serverNames)" ref="serverNamesRef"/>
	<div v-if="serverNames.length > 0">
		<div v-for="(serverName, index) in serverNames" class="ui label small basic" :class="{hidden: serverName.isShowing === false}">
			<em v-if="serverName.type != 'full'">{{serverName.type}}</em>  
			<span v-if="serverName.subNames == null || serverName.subNames.length == 0" :class="{disabled: serverName.isShowing === false}">{{serverName.name}}</span>
			<span v-else :class="{disabled: serverName.isShowing === false}">{{$t('index_等N个域名_0101', [serverName.subNames[0], serverName.subNames.length])}}</span>
			<a href="" title="修改" @click.prevent="updateServerName(index, serverName)"><i class="icon pencil small"></i></a> <a href="" title="删除" @click.prevent="removeServerName(index)"><i class="icon remove"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div class="ui fields inline">
	    <div class="ui field"><a href="" @click.prevent="addServerName()">[{{$t('index_添加域名绑定_0101')}}]</a></div>
	    <div class="ui field" v-if="serverNames.length > 0"><span class="grey">|</span> </div>
	    <div class="ui field" v-if="serverNames.length > 0">
	        <a href="" @click.prevent="showSearchBox()" v-if="!isSearching"><i class="icon search small"></i></a>
	        <a href="" @click.prevent="showSearchBox()" v-if="isSearching"><i class="icon close small"></i></a>
        </div>
        <div class="ui field" v-if="isSearching">
            <input type="text" :placeholder="$t('index_搜索域名_0101')" ref="keywordRef" class="ui input tiny" v-model="keyword"/>
        </div>
    </div>
</div>`
})

Vue.component("http-access-log-box", {
	props: ["v-access-log", "v-keyword", "v-show-server-link"],
	data: function () {
		let accessLog = this.vAccessLog
		if (accessLog.header != null && accessLog.header.Upgrade != null && accessLog.header.Upgrade.values != null && accessLog.header.Upgrade.values.$contains("websocket")) {
			if (accessLog.scheme == "http") {
				accessLog.scheme = "ws"
			} else if (accessLog.scheme == "https") {
				accessLog.scheme = "wss"
			}
		}

		// 对TAG去重
		if (accessLog.tags != null && accessLog.tags.length > 0) {
			let tagMap = {}
			accessLog.tags = accessLog.tags.$filter(function (k, tag) {
				let b = (typeof (tagMap[tag]) == "undefined")
				tagMap[tag] = true
				return b
			})
		}

		// 域名
		accessLog.unicodeHost = ""
		if (accessLog.host != null && accessLog.host.startsWith("xn--")) {
			// port
			let portIndex = accessLog.host.indexOf(":")
			if (portIndex > 0) {
				accessLog.unicodeHost = punycode.ToUnicode(accessLog.host.substring(0, portIndex))
			} else {
				accessLog.unicodeHost = punycode.ToUnicode(accessLog.host)
			}
		}

		return {
			accessLog: accessLog
		}
	},
	methods: {
		formatCost: function (seconds) {
			if (seconds == null) {
				return "0"
			}
			let s = (seconds * 1000).toString();
			let pieces = s.split(".");
			if (pieces.length < 2) {
				return s;
			}

			return pieces[0] + "." + pieces[1].substring(0, 3);
		},
		showLog: function () {
			let that = this
			let requestId = this.accessLog.requestId
			this.$parent.$children.forEach(function (v) {
				if (v.deselect != null) {
					v.deselect()
				}
			})
			this.select()
			teaweb.popup("/servers/server/log/viewPopup?requestId=" + requestId, {
				title: this.$t('index_访问日志详情_0101'),
				width: "50em",
				height: "28em",
				onClose: function () {
					that.deselect()
				}
			})
		},
		select: function () {
			this.$refs.box.parentNode.style.cssText = "background: rgba(0, 0, 0, 0.1)"
		},
		deselect: function () {
			this.$refs.box.parentNode.style.cssText = ""
		},
		mismatch: function () {
			teaweb.warn(this.$t('index_当前访问没有匹配到任何网站_0101'))
		}
	},
	template: `<div style="word-break: break-all" :style="{'color': (accessLog.status >= 400) ? '#dc143c' : ''}" ref="box">
	<div>
		<a v-if="accessLog.node != null && accessLog.node.nodeCluster != null" :href="'/clusters/cluster/node?nodeId=' + accessLog.node.id + '&clusterId=' + accessLog.node.nodeCluster.id" title="点击查看节点详情" target="_top">
			<span class="grey">
				[{{accessLog.node.name}}<span v-if="!accessLog.node.name.endsWith('节点')"> {{$t('index_节点_0101')}}</span>]
			</span>
		</a>
		
		<!-- 网站 -->
		<a :href="'/servers/server/log?serverId=' + accessLog.serverId" title="点击到网站" v-if="vShowServerLink && accessLog.serverId > 0"><span class="grey">[{{$t('index_网站_0101')}}]</span></a>
		<span v-if="vShowServerLink && (accessLog.serverId == null || accessLog.serverId == 0)" @click.prevent="mismatch()"><span class="disabled">[{{$t('index_网站_0101')}}]</span></span>
		
		<!-- 地区 -->
		<span v-if="accessLog.region != null && accessLog.region.length > 0" class="grey"><ip-box :v-ip="accessLog.remoteAddr">[{{accessLog.region}}]</ip-box></span> 
		<ip-box><keyword :v-word="vKeyword">{{accessLog.remoteAddr}}</keyword></ip-box> [{{accessLog.timeLocal}}] <em>&quot;<keyword :v-word="vKeyword">{{accessLog.requestMethod}}</keyword> {{accessLog.scheme}}://<keyword :v-word="vKeyword">{{accessLog.host}}</keyword><keyword :v-word="vKeyword">{{accessLog.requestURI}}</keyword> {{accessLog.proto}}&quot; </em> <keyword :v-word="vKeyword">{{accessLog.status}}</keyword> 
		
		<code-label v-if="accessLog.unicodeHost != null && accessLog.unicodeHost.length > 0">{{accessLog.unicodeHost}}</code-label>
		
		<!-- attrs -->
		<code-label v-if="accessLog.attrs != null && (accessLog.attrs['cache.status'] == 'HIT' || accessLog.attrs['cache.status'] == 'STALE')">cache {{accessLog.attrs['cache.status'].toLowerCase()}}</code-label> 
		<!-- waf -->
		<code-label v-if="accessLog.firewallActions != null && accessLog.firewallActions.length > 0">waf {{accessLog.firewallActions}}</code-label> 
		
		<!-- tags -->
		<span v-if="accessLog.tags != null && accessLog.tags.length > 0">- <code-label v-for="tag in accessLog.tags" :key="tag">{{tag}}</code-label>
		</span>
		<span  v-if="accessLog.wafInfo != null">
			<a :href="(accessLog.wafInfo.policy.serverId == 0) ? '/servers/components/waf/group?firewallPolicyId=' +  accessLog.firewallPolicyId + '&type=inbound&groupId=' + accessLog.firewallRuleGroupId+ '#set' + accessLog.firewallRuleSetId : '/servers/server/settings/waf/group?serverId=' + accessLog.serverId + '&firewallPolicyId=' + accessLog.firewallPolicyId + '&type=inbound&groupId=' + accessLog.firewallRuleGroupId + '#set' + accessLog.firewallRuleSetId" target="_blank">
				<code-label-plain>
					<span>
						WAF -
						<span v-if="accessLog.wafInfo.group != null">{{accessLog.wafInfo.group.name}} -</span>
						<span v-if="accessLog.wafInfo.set != null">{{accessLog.wafInfo.set.name}}</span>
					</span>
				</code-label-plain>
			</a>
		</span>
			
		<span v-if="accessLog.requestTime != null"> - {{$t('index_耗时_0101')}}:{{formatCost(accessLog.requestTime)}} ms </span><span v-if="accessLog.humanTime != null && accessLog.humanTime.length > 0" class="grey small">&nbsp; ({{accessLog.humanTime}})</span>
		&nbsp; <a href="" @click.prevent="showLog" title="查看详情"><i class="icon expand"></i></a>
	</div>
</div>`
})

// Javascript Punycode converter derived from example in RFC3492.
// This implementation is created by some@domain.name and released into public domain
// 代码来自：https://stackoverflow.com/questions/183485/converting-punycode-with-dash-character-to-unicode
var punycode = new function Punycode() {
	// This object converts to and from puny-code used in IDN
	//
	// punycode.ToASCII ( domain )
	//
	// Returns a puny coded representation of "domain".
	// It only converts the part of the domain name that
	// has non ASCII characters. I.e. it dosent matter if
	// you call it with a domain that already is in ASCII.
	//
	// punycode.ToUnicode (domain)
	//
	// Converts a puny-coded domain name to unicode.
	// It only converts the puny-coded parts of the domain name.
	// I.e. it dosent matter if you call it on a string
	// that already has been converted to unicode.
	//
	//
	this.utf16 = {
		// The utf16-class is necessary to convert from javascripts internal character representation to unicode and back.
		decode: function (input) {
			var output = [], i = 0, len = input.length, value, extra;
			while (i < len) {
				value = input.charCodeAt(i++);
				if ((value & 0xF800) === 0xD800) {
					extra = input.charCodeAt(i++);
					if (((value & 0xFC00) !== 0xD800) || ((extra & 0xFC00) !== 0xDC00)) {
						throw new RangeError("UTF-16(decode): Illegal UTF-16 sequence");
					}
					value = ((value & 0x3FF) << 10) + (extra & 0x3FF) + 0x10000;
				}
				output.push(value);
			}
			return output;
		},
		encode: function (input) {
			var output = [], i = 0, len = input.length, value;
			while (i < len) {
				value = input[i++];
				if ((value & 0xF800) === 0xD800) {
					throw new RangeError("UTF-16(encode): Illegal UTF-16 value");
				}
				if (value > 0xFFFF) {
					value -= 0x10000;
					output.push(String.fromCharCode(((value >>> 10) & 0x3FF) | 0xD800));
					value = 0xDC00 | (value & 0x3FF);
				}
				output.push(String.fromCharCode(value));
			}
			return output.join("");
		}
	}

	//Default parameters
	var initial_n = 0x80;
	var initial_bias = 72;
	var delimiter = "\x2D";
	var base = 36;
	var damp = 700;
	var tmin = 1;
	var tmax = 26;
	var skew = 38;
	var maxint = 0x7FFFFFFF;

	// decode_digit(cp) returns the numeric value of a basic code
	// point (for use in representing integers) in the range 0 to
	// base-1, or base if cp is does not represent a value.

	function decode_digit(cp) {
		return cp - 48 < 10 ? cp - 22 : cp - 65 < 26 ? cp - 65 : cp - 97 < 26 ? cp - 97 : base;
	}

	// encode_digit(d,flag) returns the basic code point whose value
	// (when used for representing integers) is d, which needs to be in
	// the range 0 to base-1. The lowercase form is used unless flag is
	// nonzero, in which case the uppercase form is used. The behavior
	// is undefined if flag is nonzero and digit d has no uppercase form.

	function encode_digit(d, flag) {
		return d + 22 + 75 * (d < 26) - ((flag != 0) << 5);
		//  0..25 map to ASCII a..z or A..Z
		// 26..35 map to ASCII 0..9
	}

	//** Bias adaptation function **
	function adapt(delta, numpoints, firsttime) {
		var k;
		delta = firsttime ? Math.floor(delta / damp) : (delta >> 1);
		delta += Math.floor(delta / numpoints);

		for (k = 0; delta > (((base - tmin) * tmax) >> 1); k += base) {
			delta = Math.floor(delta / (base - tmin));
		}
		return Math.floor(k + (base - tmin + 1) * delta / (delta + skew));
	}

	// encode_basic(bcp,flag) forces a basic code point to lowercase if flag is zero,
	// uppercase if flag is nonzero, and returns the resulting code point.
	// The code point is unchanged if it is caseless.
	// The behavior is undefined if bcp is not a basic code point.

	function encode_basic(bcp, flag) {
		bcp -= (bcp - 97 < 26) << 5;
		return bcp + ((!flag && (bcp - 65 < 26)) << 5);
	}

	// Main decode
	this.decode = function (input, preserveCase) {
		// Dont use utf16
		var output = [];
		var case_flags = [];
		var input_length = input.length;

		var n, out, i, bias, basic, j, ic, oldi, w, k, digit, t, len;

		// Initialize the state:

		n = initial_n;
		i = 0;
		bias = initial_bias;

		// Handle the basic code points: Let basic be the number of input code
		// points before the last delimiter, or 0 if there is none, then
		// copy the first basic code points to the output.

		basic = input.lastIndexOf(delimiter);
		if (basic < 0) basic = 0;

		for (j = 0; j < basic; ++j) {
			if (preserveCase) case_flags[output.length] = (input.charCodeAt(j) - 65 < 26);
			if (input.charCodeAt(j) >= 0x80) {
				throw new RangeError("Illegal input >= 0x80");
			}
			output.push(input.charCodeAt(j));
		}

		// Main decoding loop: Start just after the last delimiter if any
		// basic code points were copied; start at the beginning otherwise.

		for (ic = basic > 0 ? basic + 1 : 0; ic < input_length;) {

			// ic is the index of the next character to be consumed,

			// Decode a generalized variable-length integer into delta,
			// which gets added to i. The overflow checking is easier
			// if we increase i as we go, then subtract off its starting
			// value at the end to obtain delta.
			for (oldi = i, w = 1, k = base; ; k += base) {
				if (ic >= input_length) {
					throw RangeError("punycode_bad_input(1)");
				}
				digit = decode_digit(input.charCodeAt(ic++));

				if (digit >= base) {
					throw RangeError("punycode_bad_input(2)");
				}
				if (digit > Math.floor((maxint - i) / w)) {
					throw RangeError("punycode_overflow(1)");
				}
				i += digit * w;
				t = k <= bias ? tmin : k >= bias + tmax ? tmax : k - bias;
				if (digit < t) {
					break;
				}
				if (w > Math.floor(maxint / (base - t))) {
					throw RangeError("punycode_overflow(2)");
				}
				w *= (base - t);
			}

			out = output.length + 1;
			bias = adapt(i - oldi, out, oldi === 0);

			// i was supposed to wrap around from out to 0,
			// incrementing n each time, so we'll fix that now:
			if (Math.floor(i / out) > maxint - n) {
				throw RangeError("punycode_overflow(3)");
			}
			n += Math.floor(i / out);
			i %= out;

			// Insert n at position i of the output:
			// Case of last character determines uppercase flag:
			if (preserveCase) {
				case_flags.splice(i, 0, input.charCodeAt(ic - 1) - 65 < 26);
			}

			output.splice(i, 0, n);
			i++;
		}
		if (preserveCase) {
			for (i = 0, len = output.length; i < len; i++) {
				if (case_flags[i]) {
					output[i] = (String.fromCharCode(output[i]).toUpperCase()).charCodeAt(0);
				}
			}
		}
		return this.utf16.encode(output);
	};

	//** Main encode function **

	this.encode = function (input, preserveCase) {
		//** Bias adaptation function **

		var n, delta, h, b, bias, j, m, q, k, t, ijv, case_flags;

		if (preserveCase) {
			// Preserve case, step1 of 2: Get a list of the unaltered string
			case_flags = this.utf16.decode(input);
		}
		// Converts the input in UTF-16 to Unicode
		input = this.utf16.decode(input.toLowerCase());

		var input_length = input.length; // Cache the length

		if (preserveCase) {
			// Preserve case, step2 of 2: Modify the list to true/false
			for (j = 0; j < input_length; j++) {
				case_flags[j] = input[j] != case_flags[j];
			}
		}

		var output = [];


		// Initialize the state:
		n = initial_n;
		delta = 0;
		bias = initial_bias;

		// Handle the basic code points:
		for (j = 0; j < input_length; ++j) {
			if (input[j] < 0x80) {
				output.push(
					String.fromCharCode(
						case_flags ? encode_basic(input[j], case_flags[j]) : input[j]
					)
				);
			}
		}

		h = b = output.length;

		// h is the number of code points that have been handled, b is the
		// number of basic code points

		if (b > 0) output.push(delimiter);

		// Main encoding loop:
		//
		while (h < input_length) {
			// All non-basic code points < n have been
			// handled already. Find the next larger one:

			for (m = maxint, j = 0; j < input_length; ++j) {
				ijv = input[j];
				if (ijv >= n && ijv < m) m = ijv;
			}

			// Increase delta enough to advance the decoder's
			// <n,i> state to <m,0>, but guard against overflow:

			if (m - n > Math.floor((maxint - delta) / (h + 1))) {
				throw RangeError("punycode_overflow (1)");
			}
			delta += (m - n) * (h + 1);
			n = m;

			for (j = 0; j < input_length; ++j) {
				ijv = input[j];

				if (ijv < n) {
					if (++delta > maxint) return Error("punycode_overflow(2)");
				}

				if (ijv == n) {
					// Represent delta as a generalized variable-length integer:
					for (q = delta, k = base; ; k += base) {
						t = k <= bias ? tmin : k >= bias + tmax ? tmax : k - bias;
						if (q < t) break;
						output.push(String.fromCharCode(encode_digit(t + (q - t) % (base - t), 0)));
						q = Math.floor((q - t) / (base - t));
					}
					output.push(String.fromCharCode(encode_digit(q, preserveCase && case_flags[j] ? 1 : 0)));
					bias = adapt(delta, h + 1, h == b);
					delta = 0;
					++h;
				}
			}

			++delta, ++n;
		}
		return output.join("");
	}

	this.ToASCII = function (domain) {
		var domain_array = domain.split(".");
		var out = [];
		for (var i = 0; i < domain_array.length; ++i) {
			var s = domain_array[i];
			out.push(
				s.match(/[^A-Za-z0-9-]/) ?
					"xn--" + punycode.encode(s) :
					s
			);
		}
		return out.join(".");
	}
	this.ToUnicode = function (domain) {
		var domain_array = domain.split(".");
		var out = [];
		for (var i = 0; i < domain_array.length; ++i) {
			var s = domain_array[i];
			out.push(
				s.match(/^xn--/) ?
					punycode.decode(s.slice(4)) :
					s
			);
		}
		return out.join(".");
	}
}();

Vue.component("origin-scheduling-view-box", {
	props: ["v-scheduling", "v-params"],
	data: function () {
		let scheduling = this.vScheduling
		if (scheduling == null) {
			scheduling = {}
		}
		return {
			scheduling: scheduling
		}
	},
	methods: {
		update: function () {
			let that = this
			teaweb.popup("/servers/server/settings/reverseProxy/updateSchedulingPopup?" + this.vParams, {
				title: this.$t('origin-scheduling-view-box@修改调度算法'),
				height: "21em",
				callback: function () {
					window.teaweb.success(that.$t('index_保存成功_0101'))
					that.$emit("change")
				},
			})
		}
	},
	template: `<div class="http-config-container">
		<div class="config-item">
			<div class="item-label">{{$t('origin-scheduling-view-box@当前算法')}}</div>
			<div class="item-content">
				<span class="ui label basic">{{scheduling.name}}</span>
				<a href="" @click.prevent="update()" class="action-link"><i class="icon pencil small"></i>{{$t('updateSchedulingPopup@修改')}}</a>
				<p class="comment">{{scheduling.description}}</p>
			</div>
		</div>
	</div>`
})

// 指标图表
Vue.component("metric-chart", {
	props: ["v-chart", "v-stats", "v-item", "v-column" /** in column? **/],
	mounted: function () {
		this.load()
	},
	data: function () {
		let stats = this.vStats
		if (stats == null) {
			stats = []
		}
		if (stats.length > 0) {
			let sum = stats.$sum(function (k, v) {
				return v.value
			})
			if (sum < stats[0].total) {
				if (this.vChart.type == "pie") {
					stats.push({
						keys: ["其他"],
						value: stats[0].total - sum,
						total: stats[0].total,
						time: stats[0].time
					})
				}
			}
		}
		if (this.vChart.maxItems > 0) {
			stats = stats.slice(0, this.vChart.maxItems)
		} else {
			stats = stats.slice(0, 10)
		}

		stats.$rsort(function (v1, v2) {
			return v1.value - v2.value
		})

		let widthPercent = 100
		if (this.vChart.widthDiv > 0) {
			widthPercent = 100 / this.vChart.widthDiv
		}

		return {
			chart: this.vChart,
			stats: stats,
			item: this.vItem,
			width: widthPercent + "%",
			chartId: "metric-chart-" + this.vChart.id,
			valueTypeName: (this.vItem != null && this.vItem.valueTypeName != null && this.vItem.valueTypeName.length > 0) ? this.vItem.valueTypeName : ""
		}
	},
	computed: {
		hasData: function () {
			return this.stats.length > 0
		}
	},
	methods: {
		load: function () {
			var el = document.getElementById(this.chartId)
			if (el == null || el.offsetWidth == 0 || el.offsetHeight == 0) {
				setTimeout(this.load, 100)
			} else {
				this.render(el)
			}
		},
		render: function (el) {
			let chart = echarts.init(el)
			window.addEventListener("resize", function () {
				chart.resize()
			})
			switch (this.chart.type) {
				case "pie":
					this.renderPie(chart)
					break
				case "bar":
					this.renderBar(chart)
					break
				case "timeBar":
					this.renderTimeBar(chart)
					break
				case "timeLine":
					this.renderTimeLine(chart)
					break
				case "table":
					this.renderTable(chart)
					break
			}
		},
		renderPie: function (chart) {
			let t = this.$t.bind(this)
			let values = this.stats.map(function (v) {
				return {
					name: v.keys[0],
					value: v.value
				}
			})
			let that = this
			chart.setOption({
				tooltip: {
					show: true,
					trigger: "item",
					backgroundColor: 'rgba(255, 255, 255, 0.9)',
					borderColor: 'rgba(0, 0, 0, 0.05)',
					borderWidth: 1,
					textStyle: {
						color: '#2c3e50',
					},
					formatter: function (data) {
						let stat = that.stats[data.dataIndex]
						let percent = 0
						if (stat.total > 0) {
							percent = Math.round((stat.value * 100 / stat.total) * 100) / 100
						}
						let value = stat.value
						switch (that.item.valueType) {
							case "byte":
								value = teaweb.formatBytes(value)
								break
							case "count":
								value = teaweb.formatNumber(value)
								break
						}
						return stat.keys[0] + "<br/>" + that.valueTypeName + ": " + value + "<br/>" + t('dash_占比_5c59') + "：" + percent + "%"
					}
				},
				series: [
					{
						name: name,
						type: "pie",
						radius: ['40%', '70%'],
						avoidLabelOverlap: true,
						itemStyle: {
							borderRadius: 4,
							borderColor: '#fff',
							borderWidth: 2
						},
						label: {
							show: false,
							position: 'center'
						},
						emphasis: {
							label: {
								show: true,
								fontSize: '14',
								fontWeight: 'bold'
							}
						},
						labelLine: {
							show: false
						},
						data: values,
						color: ["#3498db", "#2ecc71", "#e74c3c", "#f39c12", "#9b59b6", "#1abc9c", "#34495e", "#e67e22", "#7f8c8d", "#27ae60"]
					}
				]
			})
		},
		renderTimeBar: function (chart) {
			this.stats.$sort(function (v1, v2) {
				return (v1.time < v2.time) ? -1 : 1
			})
			let values = this.stats.map(function (v) {
				return v.value
			})

			let axis = {unit: "", divider: 1}
			switch (this.item.valueType) {
				case "count":
					axis = teaweb.countAxis(values, function (v) {
						return v
					})
					break
				case "byte":
					axis = teaweb.bytesAxis(values, function (v) {
						return v
					})
					break
			}

			let that = this
			chart.setOption({
				xAxis: {
					data: this.stats.map(function (v) {
						return that.formatTime(v.time)
					}),
					axisLine: {
						lineStyle: {
							color: '#ddd'
						}
					},
					axisTick: {
						show: false
					}
				},
				yAxis: {
					axisLabel: {
						formatter: function (value) {
							return value + axis.unit
						}
					},
					axisLine: {
						show: false
					},
					axisTick: {
						show: false
					},
					splitLine: {
						lineStyle: {
							color: '#eee'
						}
					}
				},
				tooltip: {
					show: true,
					trigger: "item",
					backgroundColor: 'rgba(255, 255, 255, 0.9)',
					borderColor: 'rgba(0, 0, 0, 0.05)',
					borderWidth: 1,
					textStyle: {
						color: '#2c3e50',
					},
					formatter: function (data) {
						let stat = that.stats[data.dataIndex]
						let value = stat.value
						switch (that.item.valueType) {
							case "byte":
								value = teaweb.formatBytes(value)
								break
						}
						return that.formatTime(stat.time) + ": " + value
					}
				},
				grid: {
					left: 50,
					top: 10,
					right: 20,
					bottom: 25
				},
				series: [
					{
						name: name,
						type: "bar",
						data: values.map(function (v) {
							return v / axis.divider
						}),
						itemStyle: {
							color: '#3498db',
							borderRadius: [4, 4, 0, 0]
						},
						barWidth: "60%"
					}
				]
			})
		},
		renderTimeLine: function (chart) {
			this.stats.$sort(function (v1, v2) {
				return (v1.time < v2.time) ? -1 : 1
			})
			let values = this.stats.map(function (v) {
				return v.value
			})

			let axis = {unit: "", divider: 1}
			switch (this.item.valueType) {
				case "count":
					axis = teaweb.countAxis(values, function (v) {
						return v
					})
					break
				case "byte":
					axis = teaweb.bytesAxis(values, function (v) {
						return v
					})
					break
			}

			let that = this
			chart.setOption({
				xAxis: {
					data: this.stats.map(function (v) {
						return that.formatTime(v.time)
					}),
					axisLine: {
						lineStyle: {
							color: '#ddd'
						}
					},
					axisTick: {
						show: false
					}
				},
				yAxis: {
					axisLabel: {
						formatter: function (value) {
							return value + axis.unit
						}
					},
					axisLine: {
						show: false
					},
					axisTick: {
						show: false
					},
					splitLine: {
						lineStyle: {
							color: '#eee'
						}
					}
				},
				tooltip: {
					show: true,
					trigger: "item",
					backgroundColor: 'rgba(255, 255, 255, 0.9)',
					borderColor: 'rgba(0, 0, 0, 0.05)',
					borderWidth: 1,
					textStyle: {
						color: '#2c3e50',
					},
					formatter: function (data) {
						let stat = that.stats[data.dataIndex]
						let value = stat.value
						switch (that.item.valueType) {
							case "byte":
								value = teaweb.formatBytes(value)
								break
						}
						return that.formatTime(stat.time) + ": " + value
					}
				},
				grid: {
					left: 50,
					top: 10,
					right: 20,
					bottom: 25
				},
				series: [
					{
						name: name,
						type: "line",
						data: values.map(function (v) {
							return v / axis.divider
						}),
						itemStyle: {
							color: '#ff8a00',
						},
						lineStyle: {
							width: 3,
							color: '#ff8a00'
						},
						symbol: 'circle',
						symbolSize: 6,
						areaStyle: {
							color: {
								type: 'linear',
								x: 0,
								y: 0,
								x2: 0,
								y2: 1,
								colorStops: [{
									offset: 0, color: 'rgba(255, 138, 0, 0.3)'
								}, {
									offset: 1, color: 'rgba(255, 138, 0, 0.1)'
								}]
							}
						}
					}
				]
			})
		},
		renderBar: function (chart) {
			let t = this.$t.bind(this)
			let values = this.stats.map(function (v) {
				return v.value
			})
			let axis = {unit: "", divider: 1}
			switch (this.item.valueType) {
				case "count":
					axis = teaweb.countAxis(values, function (v) {
						return v
					})
					break
				case "byte":
					axis = teaweb.bytesAxis(values, function (v) {
						return v
					})
					break
			}
			let bottom = 24
			let rotate = 0
			let result = teaweb.xRotation(chart, this.stats.map(function (v) {
				return v.keys[0]
			}))
			if (result != null) {
				bottom = result[0]
				rotate = result[1]
			}
			let that = this
			chart.setOption({
				xAxis: {
					data: this.stats.map(function (v) {
						return v.keys[0]
					}),
					axisLabel: {
						interval: 0,
						rotate: rotate
					},
					axisLine: {
						lineStyle: {
							color: '#ddd'
						}
					},
					axisTick: {
						show: false
					}
				},
				tooltip: {
					show: true,
					trigger: "item",
					backgroundColor: 'rgba(255, 255, 255, 0.9)',
					borderColor: 'rgba(0, 0, 0, 0.05)',
					borderWidth: 1,
					textStyle: {
						color: '#2c3e50',
					},
					formatter: function (data) {
						let stat = that.stats[data.dataIndex]
						let percent = 0
						if (stat.total > 0) {
							percent = Math.round((stat.value * 100 / stat.total) * 100) / 100
						}
						let value = stat.value
						switch (that.item.valueType) {
							case "byte":
								value = teaweb.formatBytes(value)
								break
							case "count":
								value = teaweb.formatNumber(value)
								break
						}
						return stat.keys[0] + "<br/>" + that.valueTypeName + "：" + value + "<br/>" + t('dash_占比_5c59') + "：" + percent + "%"
					}
				},
				yAxis: {
					axisLabel: {
						formatter: function (value) {
							return value + axis.unit
						}
					},
					axisLine: {
						show: false
					},
					axisTick: {
						show: false
					},
					splitLine: {
						lineStyle: {
							color: '#eee'
						}
					}
				},
				grid: {
					left: 40,
					top: 10,
					right: 20,
					bottom: bottom
				},
				series: [
					{
						name: name,
						type: "bar",
						data: values.map(function (v) {
							return v / axis.divider
						}),
						itemStyle: {
							color: '#3498db',
							borderRadius: [4, 4, 0, 0]
						},
						barWidth: "60%"
					}
				]
			})

			if (this.item.keys != null) {
				// IP相关操作
				if (this.item.keys.$contains("${remoteAddr}")) {
					let that = this
					chart.on("click", function (args) {
						let index = that.item.keys.$indexesOf("${remoteAddr}")[0]
						let value = that.stats[args.dataIndex].keys[index]
						teaweb.popup("/servers/ipbox?ip=" + value, {
							title: t('dash_IP最近访问日志_5c59'),
							subTitle: value,
							width: "50em",
							height: "30em"
						})
					})
				}
			}
		},
		renderTable: function (chart) {
			let t = this.$t.bind(this)
			let table = `<table class="ui table celled">
	<thead>
		<tr>
			<th>${t('dash_对象_5c59')}</th>
			<th>${t('dash_数值_5c59')}</th>
			<th>${t('dash_占比_5c59')}</th>
		</tr>
	</thead>`
			let that = this
			this.stats.forEach(function (v) {
				let value = v.value
				switch (that.item.valueType) {
					case "byte":
						value = teaweb.formatBytes(value)
						break
				}
				table += "<tr><td>" + v.keys[0] + "</td><td>" + value + "</td>"
				let percent = 0
				if (v.total > 0) {
					percent = Math.round((v.value * 100 / v.total) * 100) / 100
				}
				table += "<td><div class=\"progress-bar\"><div class=\"bar\" style=\"width: " + percent + "%\"></div></div>" + percent + "%</td>"
				table += "</tr>"
			})

			table += `</table>`
			let el = document.getElementById(this.chartId)
			el.innerHTML = table
			
			// 添加表格样式
			let style = document.createElement('style')
			style.innerHTML = `
				.progress-bar {
					height: 4px;
					background: #f1f1f1;
					border-radius: 2px;
					margin-bottom: 4px;
					overflow: hidden;
				}
				.progress-bar .bar {
					height: 100%;
					background: linear-gradient(to right, #3498db, #2980b9);
					border-radius: 2px;
					min-width: 0;
				}
				.ui.table {
					border: none;
					box-shadow: none;
					border-radius: 8px;
					overflow: hidden;
				}
				.ui.table th {
					background: #f9fafb;
					font-weight: 600;
					color: #2c3e50;
					padding: 0.8em;
				}
				.ui.table td {
					padding: 0.8em;
					border-top: 1px solid #f1f1f1;
				}
			`
			el.appendChild(style)
		},
		formatTime: function (time) {
			if (time == null) {
				return ""
			}
			switch (this.item.periodUnit) {
				case "month":
					return time.substring(0, 4) + "-" + time.substring(4, 6)
				case "week":
					return time.substring(0, 4) + "-" + time.substring(4, 6)
				case "day":
					return time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8)
				case "hour":
					return time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8) + " " + time.substring(8, 10)
				case "minute":
					return time.substring(0, 4) + "-" + time.substring(4, 6) + "-" + time.substring(6, 8) + " " + time.substring(8, 10) + ":" + time.substring(10, 12)
			}
			return time
		}
	},
	template: `<div class="chart-container">
	<div class="chart-card">
		<div class="card-header">
			<h4>{{chart.name}} <span v-if="valueTypeName.length > 0">（{{valueTypeName}}）</span></h4>
		</div>
		<div class="chart-content">
			<div v-show="hasData" :id="chartId" class="metric-chart-box" :class="{'scroll-box': chart.type == 'table'}"></div>
			<empty-chart v-show="!hasData" :description="$t('index_暂无数据_0101')"></empty-chart>
		</div>
	</div>
</div>`
})

Vue.component("metric-board", {
	template: `<div class="charts-section"><slot></slot></div>`
})

Vue.component("traffic-limit-config-box", {
	props: ["v-traffic-limit"],
	data: function () {
		let config = this.vTrafficLimit
		if (config == null) {
			config = {
				isOn: false,
				dailySize: {
					count: -1,
					unit: "gb"
				},
				monthlySize: {
					count: -1,
					unit: "gb"
				},
				totalSize: {
					count: -1,
					unit: "gb"
				},
				noticePageBody: ""
			}
		}
		if (config.dailySize == null) {
			config.dailySize = {
				count: -1,
				unit: "gb"
			}
		}
		if (config.monthlySize == null) {
			config.monthlySize = {
				count: -1,
				unit: "gb"
			}
		}
		if (config.totalSize == null) {
			config.totalSize = {
				count: -1,
				unit: "gb"
			}
		}
		return {
			config: config
		}
	},
	methods: {
		showBodyTemplate: function () {
			this.config.noticePageBody = `<!DOCTYPE html>
<html>
<head>
<title>Traffic Limit Exceeded Warning</title>
<body>

<h1>Traffic Limit Exceeded Warning</h1>
<p>The site traffic has exceeded the limit. Please contact with the site administrator.</p>
<address>Request ID: \${requestId}.</address>

</body>
</html>`
		},
		submit: function () {
			this.$emit("submit", this.config)
		}
	},
	template: `<div class="hls-box">
	<input type="hidden" name="trafficLimitJSON" :value="JSON.stringify(config)"/>
	<div class="config-item">
		<div class="item-label">{{$t("traffic-limit-config-box@启用流量限制")}}</div>
		<div class="item-content">
			<p-switch :v-value="1" v-model="config.isOn" @change="submit"></p-switch>
			<p class="comment">{{$t("traffic-limit-config-box@注意_由于流量统计是每5分钟统计一次_所以超出流量限制后_对用户的提醒也会有所延迟")}}</p>
		</div>
	</div>
	<div v-show="config.isOn">
		<div class="config-item">
			<div class="item-label">{{$t("traffic-limit-config-box@日流量限制")}}</div>
			<div class="item-content">
				<size-capacity-box :v-value="config.dailySize" @change="submit"></size-capacity-box>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("traffic-limit-config-box@月流量限制")}}</div>
			<div class="item-content">
				<size-capacity-box :v-value="config.monthlySize" @change="submit"></size-capacity-box>
			</div>
		</div>
		<!--<div class="config-item">
			<div class="item-label">{{$t("traffic-limit-config-box@总体限制")}}</div>
			<div class="item-content">
				<size-capacity-box :v-value="config.totalSize" @change="submit"></size-capacity-box>
				<p class="comment"></p>
			</div>
		</div>-->
		<div class="config-item">
			<div class="item-label">{{$t("traffic-limit-config-box@网页提示内容")}}</div>
			<div class="item-content">
				<textarea v-model="config.noticePageBody" rows="10" class="ui input" @blur="submit"></textarea>
				<p class="comment"><a href="#" @click.prevent="showBodyTemplate()">{{$t("http-pages-and-shutdown-box@使用模板")}}</a>{{$t("traffic-limit-config-box@当达到流量限制时网页显示的HTML内容_不填写则显示默认的提示内容_适用于网站类服务")}}</p>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("http-redirect-to-https-box", {
	props: ["v-redirect-to-https-config", "v-is-location"],
	data: function () {
		let redirectToHttpsConfig = this.vRedirectToHttpsConfig
		if (redirectToHttpsConfig == null) {
			redirectToHttpsConfig = {
				isPrior: false,
				isOn: false,
				host: "",
				port: 0,
				status: 0,
				onlyDomains: [],
				exceptDomains: []
			}
		} else {
			if (redirectToHttpsConfig.onlyDomains == null) {
				redirectToHttpsConfig.onlyDomains = []
			}
			if (redirectToHttpsConfig.exceptDomains == null) {
				redirectToHttpsConfig.exceptDomains = []
			}
		}
		return {
			redirectToHttpsConfig: redirectToHttpsConfig,
			portString: (redirectToHttpsConfig.port > 0) ? redirectToHttpsConfig.port.toString() : "",
			moreOptionsVisible: false,
			statusOptions: [
				{ "code": 301, "text": "Moved Permanently" },
				{ "code": 308, "text": "Permanent Redirect" },
				{ "code": 302, "text": "Found" },
				{ "code": 303, "text": "See Other" },
				{ "code": 307, "text": "Temporary Redirect" }
			]
		}
	},
	watch: {
		"redirectToHttpsConfig.status": function () {
			this.redirectToHttpsConfig.status = parseInt(this.redirectToHttpsConfig.status)
		},
		portString: function (v) {
			let port = parseInt(v)
			if (!isNaN(port)) {
				this.redirectToHttpsConfig.port = port
			} else {
				this.redirectToHttpsConfig.port = 0
			}
		}
	},
	methods: {
		changeMoreOptions: function (isVisible) {
			this.moreOptionsVisible = isVisible
		},
		changeOnlyDomains: function (values) {
			this.redirectToHttpsConfig.onlyDomains = values
			this.$forceUpdate()
			this.updateData()
		},
		changeExceptDomains: function (values) {
			this.redirectToHttpsConfig.exceptDomains = values
			this.$forceUpdate()
			this.updateData()
		},
		updateData: function () {
			this.$emit("change", this.redirectToHttpsConfig)
		},
		// 保存展开状态
		saveExpandedState: function() {
			return this.moreOptionsVisible
		},
		// 恢复展开状态
		restoreExpandedState: function(wasExpanded) {
			this.$nextTick(() => {
				this.moreOptionsVisible = wasExpanded
			})
		}
	},
	template: `<div>
	<input type="hidden" name="redirectToHTTPSJSON" :value="JSON.stringify(redirectToHttpsConfig)"/>
	
	<!-- Location -->
	<div v-if="vIsLocation">
		<prior-checkbox :v-config="redirectToHttpsConfig"></prior-checkbox>
		<div v-show="redirectToHttpsConfig.isPrior">
		  <div class="config-item">
				<div class="item-label">{{$t('index_自动跳转到HTTPS_0101')}}</div>
				<div class="item-content">
					<p-switch v-model="redirectToHttpsConfig.isOn" binary></p-switch>
					<p class="comment">{{$t('index_开启后，所有HTTP的请求都会自动跳转到对应的HTTPS URL上_0101')}}，<more-options-angle @change="changeMoreOptions"></more-options-angle></p>
				</div>
			</div>
			
			<div class="more-options-box" v-show="moreOptionsVisible">
				<div class="config-item">
					<div class="item-label">{{$t('index_状态码_0101')}}</div>
					<div class="item-content">
						<b-select v-model="redirectToHttpsConfig.status" @change="updateData" :options="[
							{label: $t('index_使用默认_0101'), value:0},
							...statusOptions.map(option => ({label: option.code + ' ' + option.text, value: option.code})),
						]"></b-select>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('index_域名或IP地址_0101')}}</div>
					<div class="item-content">
						<input type="text" name="host" v-model="redirectToHttpsConfig.host" @blur="updateData"/>
						<p class="comment">{{$t('index_默认和用户正在访问的域名或IP地址一致_0101')}}。</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('index_端口_0101')}}</div>
					<div class="item-content">
						<input type="text" name="port" v-model="portString" maxlength="5" style="width:6em" @blur="updateData"/>
						<p class="comment">{{$t('index_默认端口为443_0101')}}。</p>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<!-- 非Location -->
	<div v-if="!vIsLocation">
		<p-switch v-model="redirectToHttpsConfig.isOn" binary @change="updateData"></p-switch>
		<p class="comment">{{$t('index_开启后，所有HTTP的请求都会自动跳转到对应的HTTPS URL上_0101')}}，<more-options-angle @change="changeMoreOptions"></more-options-angle></p>
		
		<div class="more-options-box" v-show="moreOptionsVisible">
			<div class="config-item">
				<div class="item-label">{{$t('index_状态码_0101')}}</div>
				<div class="item-content">
					<b-select v-model="redirectToHttpsConfig.status" @change="updateData" :options="[
						{label: $t('index_使用默认_0101'), value:0},
						...statusOptions.map(option => ({label: option.code + ' ' + option.text, value: option.code})),
					]"></b-select>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_跳转后域名或IP地址_0101')}}</div>
				<div class="item-content">
					<input type="text" name="host" v-model="redirectToHttpsConfig.host" @blur="updateData"/>
					<p class="comment">{{$t('index_默认和用户正在访问的域名或IP地址一致_0101')}}，{{$t('index_不填写就表示使用当前的域名_0101')}}。</p>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_端口_0101')}}</div>
				<div class="item-content">
					<input type="text" name="port" v-model="portString" maxlength="5" style="width:6em" @blur="updateData"/>
					<p class="comment">{{$t('index_默认端口为443_0101')}}。</p>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_允许的域名_0101')}}</div>
				<div class="item-content">
					<domains-box :v-domains="redirectToHttpsConfig.onlyDomains" @change="changeOnlyDomains"></domains-box>
					<p class="comment">{{$t('index_如果填写了允许的域名_0101')}}，{{$t('index_那么只有这些域名可以自动跳转_0101')}}。</p>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_排除的域名_0101')}}</div>
				<div class="item-content">
					<domains-box :v-domains="redirectToHttpsConfig.exceptDomains" @change="changeExceptDomains"></domains-box>
					<p class="comment">{{$t('index_如果填写了排除的域名_0101')}}，{{$t('index_那么这些域名将不跳转_0101')}}。</p>
				</div>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("user-selector", {
	props: ["v-user-id", "data-url"],
	data: function () {
		let userId = this.vUserId
		if (userId == null) {
			userId = 0
		}

		let dataURL = this.dataUrl
		if (dataURL == null || dataURL.length == 0) {
			dataURL = "/servers/users/options"
		}

		return {
			users: [],
			userId: userId,
			dataURL: dataURL
		}
	},
	methods: {
		change: function(item) {
			if (item != null) {
				this.$emit("change", item.id)
			} else {
				this.$emit("change", 0)
			}
		},
		clear: function () {
			this.$refs.comboBox.clear()
		}
	},
	template: `<div>
	<combo-box :placeholder="$t('index_选择用户_0101')" :data-url="dataURL" :data-key="'users'" data-search="on" name="userId" :v-value="userId" @change="change" ref="comboBox"></combo-box>
</div>`
})

Vue.component("http-firewall-param-filters-box", {
	props: ["v-filters"],
	data: function () {
		let filters = this.vFilters
		if (filters == null) {
			filters = []
		}

		return {
			filters: filters,
			isAdding: false,
			options: [
				{name: "MD5", code: "md5"},
				{name: "URLEncode", code: "urlEncode"},
				{name: "URLDecode", code: "urlDecode"},
				{name: "BASE64Encode", code: "base64Encode"},
				{name: "BASE64Decode", code: "base64Decode"},
				{name: "UNICODE编码", code: "unicodeEncode"},
				{name: "UNICODE解码", code: "unicodeDecode"},
				{name: "HTML实体编码", code: "htmlEscape"},
				{name: "HTML实体解码", code: "htmlUnescape"},
				{name: "计算长度", code: "length"},
				{name: "十六进制->十进制", "code": "hex2dec"},
				{name: "十进制->十六进制", "code": "dec2hex"},
				{name: "SHA1", "code": "sha1"},
				{name: "SHA256", "code": "sha256"}
			],
			addingCode: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			this.addingCode = ""
		},
		confirm: function () {
			if (this.addingCode.length == 0) {
				return
			}
			let that = this
			this.filters.push(this.options.$find(function (k, v) {
				return (v.code == that.addingCode)
			}))
			this.isAdding = false
		},
		cancel: function () {
			this.isAdding = false
		},
		remove: function (index) {
			this.filters.$remove(index)
		}
	},
	template: `<div>
		<input type="hidden" name="paramFiltersJSON" :value="JSON.stringify(filters)" />
		<div v-if="filters.length > 0">
			<div v-for="(filter, index) in filters" class="ui label small basic">
				{{filter.name}} <a href="" :title="$t('server_http-firewall-param-filters-box@删除')" @click.prevent="remove(index)"><i class="icon remove"></i></a>
			</div>
			<div class="ui divider"></div>
		</div>
		<div v-if="isAdding">
			<div class="ui fields inline">
				<div class="ui field">
					<b-select
						v-model="addingCode"
						auto-width
						:options="[
							{label: $t('server_http-firewall-param-filters-box@请选择'), value: ''},
							...options.map(option => ({
								label: option.name??'',
								value: option.code??'',
							}))
						]"
					></b-select>
				</div>
				<div class="ui field">
					<button class="ui button tiny" type="button" @click.prevent="confirm()">{{$t("server_http-firewall-param-filters-box@确定")}}</button>
					&nbsp; <a href="" @click.prevent="cancel()" :title="$t('server_http-firewall-param-filters-box@取消')"><i class="icon remove"></i></a>
				</div>
			</div>
		</div>
		<div v-if="!isAdding">
			<b-add-button @click="add"></b-add-button>
		</div>
		<p class="comment">{{$t("server_http-firewall-param-filters-box@编解码处理提示")}}</p>
</div>`
})

Vue.component("http-firewall-config-box", {
	props: ["v-firewall-config", "v-is-location", "v-firewall-policy"],
	data: function () {
		let firewall = this.vFirewallConfig
		if (firewall == null) {
			firewall = {
				isPrior: false,
				isOn: false,
				firewallPolicyId: 0,
				ignoreGlobalRules: false,
				defaultCaptchaType: "none"
			}
		}

		if (firewall.defaultCaptchaType == null || firewall.defaultCaptchaType.length == 0) {
			firewall.defaultCaptchaType = "none"
		}

		let allCaptchaTypes = window.WAF_CAPTCHA_TYPES? window.WAF_CAPTCHA_TYPES.$copy() : []

		// geetest
		let geeTestIsOn = false
		if (this.vFirewallPolicy != null && this.vFirewallPolicy.captchaAction != null && this.vFirewallPolicy.captchaAction.geeTestConfig != null) {
			geeTestIsOn = this.vFirewallPolicy.captchaAction.geeTestConfig.isOn
		}

		// 如果没有启用geetest，则还原
		if (!geeTestIsOn && firewall.defaultCaptchaType == "geetest") {
			firewall.defaultCaptchaType = "none"
		}

		return {
			firewall: firewall,
			moreOptionsVisible: true,
			execGlobalRules: !firewall.ignoreGlobalRules,
			captchaTypes: allCaptchaTypes,
			geeTestIsOn: geeTestIsOn
		}
	},
	watch: {
		execGlobalRules: function (v) {
			this.firewall.ignoreGlobalRules = !v
		}
	},
	methods: {
		changeOptionsVisible: function (v) {
			this.moreOptionsVisible = v
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.firewall)
			}, 100)
		}
	},
	template: `<div class="http-config-container">
	<input type="hidden" name="firewallJSON" :value="JSON.stringify(firewall)"/>
	
	<prior-checkbox :v-config="firewall" v-if="vIsLocation"></prior-checkbox>
	
	<div class="config-item" v-show="!vIsLocation || firewall.isPrior">
		<div class="item-label">{{$t('http-firewall-config-box@启用Web防火墙')}}</div>
		<div class="item-content">
			<p-switch v-model="firewall.isOn" binary @change="submit"></p-switch> 
		</div>
	</div>
	
	<div v-show="moreOptionsVisible">
		<div class="config-item">
			<div class="item-label">{{$t('http-firewall-config-box@人机识别验证方式')}}</div>
			<div class="item-content">
				<b-select v-model="firewall.defaultCaptchaType" :options="[
					{label: $t('http-firewall-config-box@默认'), value:'none'},
					...captchaTypes.map(captchaType => ({label: captchaType.name, value: captchaType.code})),
				]" @change="submit"></b-select>
				<p class="comment" v-if="firewall.defaultCaptchaType == 'none'">{{$t('http-firewall-config-box@默认验证方式提示')}}</p>
				<p class="comment" v-for="captchaType in captchaTypes" v-if="captchaType.code == firewall.defaultCaptchaType" v-html="$t('http-firewall-config-box@验证方式提示', [captchaType.description])"></p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-firewall-config-box@启用系统全局规则')}}</div>
			<div class="item-content">
				<p-switch v-model="execGlobalRules" binary @change="submit"></p-switch>
				<p class="comment">{{$t('http-firewall-config-box@启用系统全局规则提示')}}</p>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("ssl-config-box", {
	props: [
		"v-ssl-policy",
		"v-protocol",
		"v-server-id",
		"v-support-http3"
	],
	created: function () {
		let that = this
		setTimeout(function () {
			that.sortableCipherSuites()
		}, 100)
	},
	data: function () {
		let policy = this.vSslPolicy
		if (policy == null) {
			policy = {
				id: 0,
				isOn: true,
				certRefs: [],
				certs: [],
				clientCARefs: [],
				clientCACerts: [],
				clientAuthType: 0,
				minVersion: "TLS 1.1",
				hsts: null,
				cipherSuitesIsOn: false,
				cipherSuites: [],
				http2Enabled: true,
				http3Enabled: false,
				ocspIsOn: false
			}
		} else {
			if (policy.certRefs == null) {
				policy.certRefs = []
			}
			if (policy.certs == null) {
				policy.certs = []
			}
			if (policy.clientCARefs == null) {
				policy.clientCARefs = []
			}
			if (policy.clientCACerts == null) {
				policy.clientCACerts = []
			}
			if (policy.cipherSuites == null) {
				policy.cipherSuites = []
			}
		}

		let hsts = policy.hsts
		let hstsMaxAgeString = "31536000"
		if (hsts == null) {
			hsts = {
				isOn: false,
				maxAge: 31536000,
				includeSubDomains: false,
				preload: false,
				domains: []
			}
		}
		if (hsts.maxAge != null) {
			hstsMaxAgeString = hsts.maxAge.toString()
		}

		return {
			policy: policy,

			// hsts
			hsts: hsts,
			hstsOptionsVisible: false,
			hstsDomainAdding: false,
			hstsMaxAgeString: hstsMaxAgeString,
			addingHstsDomain: "",
			hstsDomainEditingIndex: -1,

			// 相关数据
			allVersions: window.SSL_ALL_VERSIONS,
			allCipherSuites: window.SSL_ALL_CIPHER_SUITES.$copy(),
			modernCipherSuites: window.SSL_MODERN_CIPHER_SUITES,
			intermediateCipherSuites: window.SSL_INTERMEDIATE_CIPHER_SUITES,
			allClientAuthTypes: window.SSL_ALL_CLIENT_AUTH_TYPES,
			cipherSuitesVisible: false,

			// 高级选项
			moreOptionsVisible: true
		}
	},
	watch: {
		hsts: {
			deep: true,
			handler: function () {
				this.policy.hsts = this.hsts
			}
		}
	},
	methods: {
		// 删除证书
		removeCert: function (index) {
			let that = this
			teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
				that.policy.certRefs.$remove(index)
				that.policy.certs.$remove(index)
			})
		},

		// 选择证书
		selectCert: function () {
			let that = this
			let selectedCertIds = []
			if (this.policy != null && this.policy.certs.length > 0) {
				this.policy.certs.forEach(function (cert) {
					selectedCertIds.push(cert.id.toString())
				})
			}
			let serverId = this.vServerId
			if (serverId == null) {
				serverId = 0
			}
			teaweb.popup("/servers/certs/selectPopup?selectedCertIds=" + selectedCertIds + "&serverId=" + serverId, {
				width: "50em",
				height: "30em",
				title: this.$t('index_选择证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null && resp.data.certRef != null) {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null && resp.data.certRefs != null) {
						that.policy.certRefs.$pushAll(resp.data.certRefs)
						that.policy.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 上传证书
		uploadCert: function () {
			let that = this
			let serverId = this.vServerId
			if (typeof serverId != "number" && typeof serverId != "string") {
				serverId = 0
			}
			teaweb.popup("/servers/certs/uploadPopup?serverId=" + serverId, {
				height: "30em",
				title: this.$t('index_上传证书_0101'),
				callback: function (resp) {
					teaweb.success(this.$t('index_上传成功_0101'), function () {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					})
				}
			})
		},

		// 批量上传
		uploadBatch: function () {
			let that = this
			let serverId = this.vServerId
			if (typeof serverId != "number" && typeof serverId != "string") {
				serverId = 0
			}
			teaweb.popup("/servers/certs/uploadBatchPopup?serverId=" + serverId, {
				title: this.$t('index_批量上传证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null) {
						that.policy.certRefs.push(resp.data.certRef)
						that.policy.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null) {
						that.policy.certRefs.$pushAll(resp.data.certRefs)
						that.policy.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 申请证书
		requestCert: function () {
			// 已经在证书中的域名
			let excludeServerNames = []
			if (this.policy != null && this.policy.certs.length > 0) {
				this.policy.certs.forEach(function (cert) {
					excludeServerNames.$pushAll(cert.dnsNames)
				})
			}

			let that = this
			teaweb.popup("/servers/server/settings/https/requestCertPopup?serverId=" + this.vServerId + "&excludeServerNames=" + excludeServerNames.join(","), {
				title: this.$t('index_申请免费证书_0101'),
				callback: function () {
					that.policy.certRefs.push(resp.data.certRef)
					that.policy.certs.push(resp.data.cert)
				}
			})
		},

		// 更多选项
		changeOptionsVisible: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},

		// 格式化时间
		formatTime: function (timestamp) {
			return new Date(timestamp * 1000).format("Y-m-d")
		},

		// 格式化加密套件
		formatCipherSuite: function (cipherSuite) {
			return cipherSuite.replace(/(AES|3DES)/, "<var style=\"font-weight: bold\">$1</var>")
		},

		// 添加单个套件
		addCipherSuite: function (cipherSuite) {
			if (!this.policy.cipherSuites.$contains(cipherSuite)) {
				this.policy.cipherSuites.push(cipherSuite)
			}
			this.allCipherSuites.$removeValue(cipherSuite)
		},

		// 删除单个套件
		removeCipherSuite: function (cipherSuite) {
			let that = this
			teaweb.confirm(this.$t('index_确定要删除此套件吗？_0101'), function () {
				that.policy.cipherSuites.$removeValue(cipherSuite)
				that.allCipherSuites = window.SSL_ALL_CIPHER_SUITES.$findAll(function (k, v) {
					return !that.policy.cipherSuites.$contains(v)
				})
			})
		},

		// 清除所选套件
		clearCipherSuites: function () {
			let that = this
			teaweb.confirm(this.$t('index_确定要清除所有已选套件吗？_0101'), function () {
				that.policy.cipherSuites = []
				that.allCipherSuites = window.SSL_ALL_CIPHER_SUITES.$copy()
			})
		},

		// 批量添加套件
		addBatchCipherSuites: function (suites) {
			var that = this
			teaweb.confirm(this.$t('index_确定要批量添加套件？_0101'), function () {
				suites.$each(function (k, v) {
					if (that.policy.cipherSuites.$contains(v)) {
						return
					}
					that.policy.cipherSuites.push(v)
				})
			})
		},

		/**
		 * 套件拖动排序
		 */
		sortableCipherSuites: function () {
			var box = document.querySelector(".cipher-suites-box")
			Sortable.create(box, {
				draggable: ".label",
				handle: ".icon.handle",
				onStart: function () {

				},
				onUpdate: function (event) {

				}
			})
		},

		// 显示所有套件
		showAllCipherSuites: function () {
			this.cipherSuitesVisible = !this.cipherSuitesVisible
		},

		// 显示HSTS更多选项
		showMoreHSTS: function () {
			this.hstsOptionsVisible = !this.hstsOptionsVisible;
			if (this.hstsOptionsVisible) {
				this.changeHSTSMaxAge()
			}
		},

		// 监控HSTS有效期修改
		changeHSTSMaxAge: function () {
			var v = parseInt(this.hstsMaxAgeString)
			if (isNaN(v) || v < 0) {
				this.hsts.maxAge = 0
				this.hsts.days = "-"
				return
			}
			this.hsts.maxAge = v
			this.hsts.days = v / 86400
			if (this.hsts.days == 0) {
				this.hsts.days = "-"
			}
		},

		// 设置HSTS有效期
		setHSTSMaxAge: function (maxAge) {
			this.hstsMaxAgeString = maxAge.toString()
			this.changeHSTSMaxAge()
		},

		// 添加HSTS域名
		addHstsDomain: function () {
			this.hstsDomainAdding = true
			this.hstsDomainEditingIndex = -1
			let that = this
			setTimeout(function () {
				that.$refs.addingHstsDomain.focus()
			}, 100)
		},

		// 修改HSTS域名
		editHstsDomain: function (index) {
			this.hstsDomainEditingIndex = index
			this.addingHstsDomain = this.hsts.domains[index]
			this.hstsDomainAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingHstsDomain.focus()
			}, 100)
		},

		// 确认HSTS域名添加
		confirmAddHstsDomain: function () {
			this.addingHstsDomain = this.addingHstsDomain.trim()
			if (this.addingHstsDomain.length == 0) {
				return;
			}
			if (this.hstsDomainEditingIndex > -1) {
				this.hsts.domains[this.hstsDomainEditingIndex] = this.addingHstsDomain
			} else {
				this.hsts.domains.push(this.addingHstsDomain)
			}
			this.cancelHstsDomainAdding()
		},

		// 取消HSTS域名添加
		cancelHstsDomainAdding: function () {
			this.hstsDomainAdding = false
			this.addingHstsDomain = ""
			this.hstsDomainEditingIndex = -1
		},

		// 删除HSTS域名
		removeHstsDomain: function (index) {
			this.cancelHstsDomainAdding()
			this.hsts.domains.$remove(index)
		},

		// 选择客户端CA证书
		selectClientCACert: function () {
			let that = this
			teaweb.popup("/servers/certs/selectPopup?isCA=1", {
				width: "50em",
				height: "30em",
				title: this.$t('index_选择客户端CA证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null && resp.data.certRef != null) {
						that.policy.clientCARefs.push(resp.data.certRef)
						that.policy.clientCACerts.push(resp.data.cert)
					}
					if (resp.data.certs != null && resp.data.certRefs != null) {
						that.policy.clientCARefs.$pushAll(resp.data.certRefs)
						that.policy.clientCACerts.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 上传CA证书
		uploadClientCACert: function () {
			let that = this
			teaweb.popup("/servers/certs/uploadPopup?isCA=1", {
				height: "28em",
				title: this.$t('index_上传CA证书_0101'),
				callback: function (resp) {
					teaweb.success(this.$t('index_上传成功_0101'), function () {
						that.policy.clientCARefs.push(resp.data.certRef)
						that.policy.clientCACerts.push(resp.data.cert)
					})
				}
			})
		},

		// 删除客户端CA证书
		removeClientCACert: function (index) {
			let that = this
			teaweb.confirm(this.$t('index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。_0101'), function () {
				that.policy.clientCARefs.$remove(index)
				that.policy.clientCACerts.$remove(index)
			})
		}
	},
	template: `<div>
	<div class="config-section ui form">
		<div class="section-title">
			<i class="icon shield alternate"></i>
			<span>{{$t('index_SSL/TLS相关配置_0101')}}</span>
		</div>
		
		<input type="hidden" name="sslPolicyJSON" :value="JSON.stringify(policy)"/>
		
		<div class="config-item" v-show="vProtocol == 'https'">
			<div class="item-label">{{$t('index_启用HTTP/2_0101')}}</div>
			<div class="item-content">
				<p-switch v-model="policy.http2Enabled" binary></p-switch>
			</div>
		</div>
		
		<div class="config-item" v-show="vProtocol == 'https' && vSupportHttp3">
			<div class="item-label">{{$t('index_启用HTTP/3_0101')}}</div>
			<div class="item-content">
				<p-switch v-model="policy.http3Enabled" binary></p-switch>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('index_设置证书_0101')}}</div>
			<div class="item-content">
				<div v-if="policy.certs != null && policy.certs.length > 0">
					<div class="ui label small basic" v-for="(cert, index) in policy.certs" style="margin-top: 0.2em">
						{{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeCert(index)"><i class="icon remove"></i></a>
					</div>
					<div class="ui divider"></div>
				</div>
				<div v-else>
					<span class="red">{{$t('index_选择或上传证书后_0101')}}<span v-if="vProtocol == 'https'">HTTPS</span><span v-if="vProtocol == 'tls'">TLS</span>{{$t('index_服务才能生效_0101')}}。</span>
					<div class="ui divider"></div>
				</div>
				<button class="ui button tiny" type="button" @click.prevent="selectCert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
				<span class="disabled">|</span> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="uploadCert()">{{$t('index_上传新证书_0101')}}</button> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="uploadBatch()">{{$t('index_批量上传证书_0101')}}</button> &nbsp;
				<span class="disabled">|</span> &nbsp;
				<button class="ui button tiny" type="button" @click.prevent="requestCert()" v-if="vServerId != null && vServerId > 0">{{$t('index_申请免费证书_0101')}}</button>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('index_TLS最低版本_0101')}}</div>
			<div class="item-content">
				<b-select v-model="policy.minVersion" :options="[
					...allVersions.map(version => ({label: version, value: version})),
				]"></b-select>
			</div>
		</div>
	</div>
	
	<div>
		<!-- 加密套件 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon key"></i>
				<span>{{$t('index_加密算法套件_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_自定义加密套件_0101')}}</div>
				<div class="item-content">
					<div class="ui checkbox">
						<p-switch v-model="policy.cipherSuitesIsOn" binary></p-switch>
						<label>{{$t('index_是否要自定义_0101')}}</label>
					</div>
					<div v-show="policy.cipherSuitesIsOn">
						<div class="ui divider"></div>
						<div class="cipher-suites-box">
							{{$t('index_已添加套件_0101')}}({{policy.cipherSuites.length}})：
							<div v-for="cipherSuite in policy.cipherSuites" class="ui label tiny basic" style="margin-bottom: 0.5em">
								<input type="hidden" name="cipherSuites" :value="cipherSuite"/>
								<span v-html="formatCipherSuite(cipherSuite)"></span> &nbsp; <a href="" title="删除套件" @click.prevent="removeCipherSuite(cipherSuite)"><i class="icon remove"></i></a>
								<a href="" title="拖动改变顺序"><i class="icon bars handle"></i></a>
							</div>
						</div>
						<div>
							<div class="ui divider"></div>
							<span v-if="policy.cipherSuites.length > 0"><a href="" @click.prevent="clearCipherSuites()">[{{$t('index_清除所有已选套件_0101')}}]</a> &nbsp; </span>
							<a href="" @click.prevent="addBatchCipherSuites(modernCipherSuites)">[{{$t('index_添加推荐套件_0101')}}]</a> &nbsp;
							<a href="" @click.prevent="addBatchCipherSuites(intermediateCipherSuites)">[{{$t('index_添加兼容套件_0101')}}]</a>
							<div class="ui divider"></div>
						</div>
		
						<div class="cipher-all-suites-box">
							<a href="" @click.prevent="showAllCipherSuites()"><span v-if="policy.cipherSuites.length == 0">{{$t('index_所有_0101')}}</span>{{$t('index_可选套件_0101')}}({{allCipherSuites.length}}) <i class="icon angle" :class="{down:!cipherSuitesVisible, up:cipherSuitesVisible}"></i></a>
							<a href="" v-if="cipherSuitesVisible" v-for="cipherSuite in allCipherSuites" class="ui label tiny" title="点击添加到自定义套件中" @click.prevent="addCipherSuite(cipherSuite)" v-html="formatCipherSuite(cipherSuite)" style="margin-bottom:0.5em"></a>
						</div>
						<p class="comment" v-if="cipherSuitesVisible">{{$t('index_点击可选套件添加_0101')}}。</p>
					</div>
				</div>
			</div>
		</div>
		
		<!-- HSTS -->
		<div class="config-section" v-show="vProtocol == 'https'">
			<div class="section-title">
				<i class="icon lock"></i>
				<span>{{$t('index_HSTS设置_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_开启HSTS_0101')}}</div>
				<div class="item-content">
					<p-switch name="hstsOn" v-model="hsts.isOn" value="1" binary></p-switch>
					<p class="comment">{{$t('index_开启后，会自动在响应Header中加入_0101')}}<span class="ui label small">Strict-Transport-Security:<var v-if="!hsts.isOn">...</var><var v-if="hsts.isOn"><span>max-age=</span>{{hsts.maxAge}}</var><var v-if="hsts.isOn && hsts.includeSubDomains">; includeSubDomains</var><var v-if="hsts.isOn && hsts.preload">; preload</var></span><span v-if="hsts.isOn"><a href="" @click.prevent="showMoreHSTS()">修改<i class="icon angle" :class="{down:!hstsOptionsVisible, up:hstsOptionsVisible}"></i> </a></span></p>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS有效时间_0101')}}</div>
				<div class="item-content">
					<div class="ui fields inline">
						<div class="ui field">
							<input class="ui input" type="text" name="hstsMaxAge" v-model="hstsMaxAgeString" maxlength="10" size="10" @input="changeHSTSMaxAge()"/>
						</div>
						<div class="ui field">
							{{$t('index_秒_0101')}}
						</div>
						<div class="ui field">{{hsts.days}} {{$t('index_天_0101')}}</div>
					</div>
					<p class="comment"><a href="" @click.prevent="setHSTSMaxAge(31536000)" :class="{active:hsts.maxAge == 31536000}">[1年/365天]</a> &nbsp; &nbsp;<a href="" @click.prevent="setHSTSMaxAge(15768000)" :class="{active:hsts.maxAge == 15768000}">[6个月/182.5天]</a> &nbsp;  &nbsp;<a href="" @click.prevent="setHSTSMaxAge(2592000)"  :class="{active:hsts.maxAge == 2592000}">[1个月/30天]</a></p>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_包含子域名_0101')}}</div>
				<div class="item-content">
					<p-checkbox name="hstsIncludeSubDomains" value="1" v-model="hsts.includeSubDomains" binary></p-checkbox>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS预加载_0101')}}</div>
				<div class="item-content">
					<p-checkbox name="hstsPreload" value="1" v-model="hsts.preload" binary></p-checkbox>
				</div>
			</div>
			
			<div class="config-item" v-show="hsts.isOn && hstsOptionsVisible">
				<div class="item-label">{{$t('index_HSTS生效的域名_0101')}}</div>
				<div class="item-content">
					<div class="names-box">
					<span class="ui label tiny basic" v-for="(domain, arrayIndex) in hsts.domains" :class="{blue:hstsDomainEditingIndex == arrayIndex}">{{domain}}
						<input type="hidden" name="hstsDomains" :value="domain"/> &nbsp;
						<a href="" @click.prevent="editHstsDomain(arrayIndex)" title="修改"><i class="icon pencil"></i></a>
						<a href="" @click.prevent="removeHstsDomain(arrayIndex)" title="删除"><i class="icon remove"></i></a>
					</span>
					</div>
					<div class="ui fields inline" v-if="hstsDomainAdding" style="margin-top:0.8em">
						<div class="ui field">
							<input type="text" name="addingHstsDomain" ref="addingHstsDomain" style="width:16em" maxlength="100" :placeholder="$t('index_域名，比如')" @keyup.enter="confirmAddHstsDomain()" @keypress.enter.prevent="1" v-model="addingHstsDomain" />
						</div>
						<div class="ui field">
							<button class="ui button tiny" type="button" @click="confirmAddHstsDomain()">{{$t('index_确定_0101')}}</button>
							&nbsp; <a href="" @click.prevent="cancelHstsDomainAdding()">{{$t('index_取消_0101')}}</a>
						</div>
					</div>
					<div class="ui field" style="margin-top: 1em">
						<button class="ui button tiny" type="button" @click="addHstsDomain()">+</button>
					</div>
					<p class="comment">{{$t('index_如果没有设置域名的话，则默认支持所有的域名_0101')}}。</p>
				</div>
			</div>
		</div>
		
		<!-- OCSP -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon check circle"></i>
				<span>{{$t('index_OCSP设置_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-content">
					<checkbox name="ocspIsOn" v-model="policy.ocspIsOn" binary>OCSP Stapling</checkbox>
					<p class="comment">{{$t('index_选中表示启用OCSP Stapling_0101')}}。</p>
				</div>
			</div>
		</div>
		
		<!-- 客户端认证 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon user shield"></i>
				<span>{{$t('index_客户端认证_0101')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_客户端认证方式_0101')}}</div>
				<div class="item-content">
					<b-select v-model="policy.clientAuthType" :options="[
						...allClientAuthTypes.map(authType => ({label: authType.name, value: authType.type})),
					]"></b-select>
				</div>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('index_客户端认证CA证书_0101')}}</div>
				<div class="item-content">
					<div v-if="policy.clientCACerts != null && policy.clientCACerts.length > 0">
						<div class="ui label small basic" v-for="(cert, index) in policy.clientCACerts">
							{{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}}{{formatTime(cert.timeEndAt)}} &nbsp; <a href="" title="删除" @click.prevent="removeClientCACert()"><i class="icon remove"></i></a>
						</div>
						<div class="ui divider"></div>
					</div>
					<button class="ui button tiny" type="button" @click.prevent="selectClientCACert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
					<button class="ui button tiny" type="button" @click.prevent="uploadClientCACert()">{{$t('index_上传新证书_0101')}}</button>
					<p class="comment">{{$t('index_用来校验客户端证书以增强安全性_0101')}}，{{$t('index_通常不需要设置_0101')}}。</p>
				</div>
			</div>
		</div>
	</div>
	
	<div class="margin"></div>
</div>`
})

// 认证设置
Vue.component("http-auth-config-box", {
	props: ["v-auth-config", "v-is-location", "vIsGroup"],
	data: function () {
		let authConfig = this.vAuthConfig
		if (authConfig == null) {
			authConfig = {
				isPrior: false,
				isOn: false
			}
		}
		if (authConfig.policyRefs == null) {
			authConfig.policyRefs = []
		}
		return {
			authConfig: authConfig
		}
	},
	methods: {
		isOn: function () {
			return (!this.vIsLocation || this.authConfig.isPrior) && this.authConfig.isOn
		},
		add: function () {
			let that = this
			teaweb.popup("/servers/server/settings/access/createPopup", {
				title: this.$t('http-auth-config-box@创建鉴权方式'),
				callback: function (resp) {
					that.authConfig.policyRefs.push(resp.data.policyRef)
					that.change()
				},
				height: "28em"
			})
		},
		update: function (index, policyId) {
			let that = this
			teaweb.popup("/servers/server/settings/access/updatePopup?policyId=" + policyId, {
				title: this.$t('http-auth-config-box@修改鉴权方式'),
				callback: function (resp) {
					teaweb.success(this.$t('http-auth-config-box@保存成功'), function () {
						teaweb.reload()
					})
				},
				height: "28em"
			})
		},
		remove: function (index) {
			this.authConfig.policyRefs.$remove(index)
			this.change()
		},
		methodName: function (methodType) {
			switch (methodType) {
				case "basicAuth":
					return "BasicAuth"
				case "subRequest":
					return this.$t('http-auth-config-box@子请求')
				case "typeA":
					return this.$t('http-auth-config-box@URL鉴权A')
				case "typeB":
					return this.$t('http-auth-config-box@URL鉴权B')
				case "typeC":
					return this.$t('http-auth-config-box@URL鉴权C')
				case "typeD":
					return this.$t('http-auth-config-box@URL鉴权D')
			}
			return ""
		},
		change: function () {
			let that = this
			setTimeout(function () {
				// 延时通知，是为了让表单有机会变更数据
				that.$emit("change", that.authConfig)
			}, 100)
		}
	},
	template: `
	<div>
    <input type="hidden" name="authJSON" :value="JSON.stringify(authConfig)" />
    <div class="config-section">
      <div class="section-title">
        <i class="icon shield"></i>
        <span>{{ $t('http-auth-config-box@基本设置') }}</span>
      </div>
      <div class="config-item">
        <div class="item-label">{{ $t('http-auth-config-box@启用鉴权') }}</div>
        <div class="item-content">
          <p-switch v-model="authConfig.isOn" binary @change="change"></p-switch>
          <p class="comment" v-if="vIsLocation">
            <span v-if="!authConfig.isPrior">{{ $t('http-auth-config-box@当前使用上级配置') }}</span>
            <span v-if="authConfig.isPrior">{{ $t('http-auth-config-box@当前覆盖上级配置') }}</span>
          </p>
        </div>
      </div>
    </div>
    <div class="config-section" v-if="vIsLocation || vIsGroup">
      <div class="section-title">
        <i class="icon sliders horizontal"></i>
        <span>{{ $t('http-cc-config-box@独立配置') }}</span>
      </div>
      <prior-checkbox :v-config="authConfig"></prior-checkbox>
    </div>
    <!-- 鉴权方式 -->
    <div v-show="isOn()" class="config-section">
      <div class="section-title">
        <i class="icon key"></i>
        <span>{{ $t('http-auth-config-box@鉴权方式') }}</span>
      </div>
      <div class="config-item" v-show="authConfig.policyRefs.length > 0">
        <div class="item-content">
          <b-table :columns="[
            { title: $t('http-auth-config-box@名称'), dataIndex: 'authPolicy.name', key: 'name', width: '100px' },
            { title: $t('http-auth-config-box@鉴权方法'), key: 'method', width: '150px', scopedSlots: { customRender: 'methodSlot' } },
            { title: $t('http-auth-config-box@参数'), key: 'params', scopedSlots: { customRender: 'paramsSlot' } },
            { title: $t('http-auth-config-box@状态'), key: 'status', width: '120px', scopedSlots: { customRender: 'statusSlot' } },
            { title: $t('http-auth-config-box@操作'), key: 'action', width: '150px', scopedSlots: { customRender: 'actionSlot' } }
          ]" :data-source="authConfig.policyRefs" :row-key="'authPolicyId'" :pagination="false">
            <template slot="methodSlot" slot-scope="{ text, record }">
              {{ methodName(record.authPolicy.type) }}
            </template>
            <template slot="paramsSlot" slot-scope="{ text, record }">
              <span v-if="record.authPolicy.type == 'basicAuth'">{{ $t('http-auth-config-box@N个用户',
                [record.authPolicy.params.users.length])}}</span>
              <span v-if="record.authPolicy.type == 'subRequest'">
                <span v-if="record.authPolicy.params.method.length > 0"
                  class="grey">[{{ record.authPolicy.params.method }}]</span>
                {{ record.authPolicy.params.url }}
              </span>
              <span
                v-if="record.authPolicy.type == 'typeA'">{{ record.authPolicy.params.signParamName }}/{{ $t('http-auth-config-box@有效期N秒',
                  [record.authPolicy.params.life])}}</span>
              <span v-if="record.authPolicy.type == 'typeB'">{{ $t('http-auth-config-box@有效期N秒',
                [record.authPolicy.params.life])}}</span>
              <span v-if="record.authPolicy.type == 'typeC'">{{ $t('http-auth-config-box@有效期N秒',
                [record.authPolicy.params.life])}}</span>
              <span
                v-if="record.authPolicy.type == 'typeD'">{{ record.authPolicy.params.signParamName }}/{{ record.authPolicy.params.timestampParamName }}/{{ $t('http-auth-config-box@有效期N秒',
                  [record.authPolicy.params.life])}}</span>

              <div
                v-if="(record.authPolicy.params.exts != null && record.authPolicy.params.exts.length > 0) || (record.authPolicy.params.domains != null && record.authPolicy.params.domains.length > 0)">
                <grey-label v-if="record.authPolicy.params.exts != null" v-for="ext in record.authPolicy.params.exts"
                  :key="ext">{{ $t('http-auth-config-box@扩展名') }}：{{ ext }}</grey-label>
                <grey-label v-if="record.authPolicy.params.domains != null"
                  v-for="domain in record.authPolicy.params.domains"
                  :key="domain">{{ $t('http-auth-config-box@域名') }}：{{ domain }}</grey-label>
              </div>
            </template>
            <template slot="statusSlot" slot-scope="{ text, record }">
              <label-on :v-is-on="record.authPolicy.isOn"></label-on>
            </template>
            <template slot="actionSlot" slot-scope="{ text, record, index }">
              <a-button type="link"
                @click.prevent="update(index, record.authPolicyId)">{{ $t('http-auth-config-box@修改') }}</a-button>
              <a-button type="link" danger @click.prevent="remove(index)">{{ $t('http-auth-config-box@删除') }}</a-button>
            </template>
          </b-table>
        </div>
      </div>
      <div class="config-item">
        <div class="item-content">
          <button class="ui button small" type="button"
            @click.prevent="add">{{ $t('http-auth-config-box@添加鉴权方式') }}</button>
        </div>
      </div>
    </div>
  </div>
	`
})

Vue.component("http-firewall-page-options-viewer", {
	props: ["v-page-options"],
	data: function () {
		return {
			options: this.vPageOptions
		}
	},
	template: `<div>
	<span v-if="options == null">{{$t("http-firewall-block-options-viewer@默认设置")}}</span>
	<div v-else>
		{{$t("http-firewall-block-options-viewer@状态码")}}：{{options.status}} / {{$t("http-firewall-block-options-viewer@提示内容")}}：<span v-if="options.body != null && options.body.length > 0">[{{options.body.length}}{{$t("http-firewall-block-options-viewer@字符")}}]</span>
	</div>
</div>	
`
})

Vue.component("http-request-cond-view", {
	props: ["v-cond"],
	data: function () {
		return {
			cond: this.vCond,
			components: window.REQUEST_COND_COMPONENTS
		}
	},
	methods: {
		typeName: function (cond) {
			let c = this.components.$find(function (k, v) {
				return v.type == cond.type
			})
			if (c != null) {
				return c.name;
			}
			return cond.param + " " + cond.operator
		},
		updateConds: function (conds, simpleCond) {
			for (let k in simpleCond) {
				if (simpleCond.hasOwnProperty(k)) {
					this.cond[k] = simpleCond[k]
				}
			}
		},
		notifyChange: function () {

		}
	},
	template: `<div style="margin-bottom: 0.5em">
	<span class="ui label small basic">
		<var v-if="cond.type.length == 0 || cond.type == 'params'" style="font-style: normal">{{cond.param}} <var>{{cond.operator}}</var></var>
		<var v-if="cond.type.length > 0 && cond.type != 'params'" style="font-style: normal">{{typeName(cond)}}: </var>
		{{cond.value}}
		<sup v-if="cond.isCaseInsensitive" title="不区分大小写"><i class="icon info small"></i></sup>
	</span>
</div>`
})

// Action列表
Vue.component("http-firewall-actions-view", {
	props: ["v-actions"],
	template: `<div>
		<div v-for="action in vActions" style="margin-bottom: 0.3em">
			<span :class="{red: action.category == 'block', orange: action.category == 'verify', green: action.category == 'allow'}">{{action.name}} ({{action.code.toUpperCase()}})
			  	<div v-if="action.options != null">
			  		<span class="grey small" v-if="action.code.toLowerCase() == 'page'">[{{action.options.status}}]</span>
			  		<span class="grey small" v-if="action.code.toLowerCase() == 'allow' && action.options != null && action.options.scope != null && action.options.scope.length > 0">
			  			<span v-if="action.options.scope == 'group'">[{{$t('waf_rule@分组')}}]</span>
						<span v-if="action.options.scope == 'server'">[{{$t('waf_rule@网站')}}]</span>
						<span v-if="action.options.scope == 'global'">[{{$t('waf_rule@网站和策略')}}]</span>	
					</span>
					<span class="grey small" v-if="action.code.toLowerCase() == 'record_ip'">
						<span v-if="action.options.type == 'black'" class="red">{{$t('waf_rule@黑名单')}}</span>
						<span v-if="action.options.type == 'white'" class="green">{{$t('waf_rule@白名单')}}</span>
						<span v-if="action.options.type == 'grey'" class="grey">{{$t('waf_rule@灰名单')}}</span>
					</span>
				</div>	
			</span>
		</div>             
</div>`
})

Vue.component("http-stat-config-box", {
	props: ["v-stat-config", "v-is-location"],
	data: function () {
		let stat = this.vStatConfig
		if (stat == null) {
			stat = {
				isPrior: false,
				isOn: false
			}
		}
		return {
			stat: stat
		}
	},
	methods: {
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.stat)
			}, 100)
		}
	},
	template: `<div class="stat-box">
	<input type="hidden" name="statJSON" :value="JSON.stringify(stat)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-if="vIsLocation">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-stat-config-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="stat" class="config-item"></prior-checkbox>
	</div>
	
	<!-- 统计设置 -->
	<div class="config-section" v-show="!vIsLocation || stat.isPrior">
		<div class="section-title">
			<i class="icon chart bar"></i>
			<span>{{$t('http-stat-config-box@统计设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-stat-config-box@启用统计')}}</div>
			<div class="item-content">
				<p-switch v-model="stat.isOn" binary @change="submit"></p-switch>
				<p class="comment">{{$t('http-stat-config-box@启用后_系统将收集网站访问数据并生成统计报表')}}</p>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("http-header-policy-box", {
	props: ["v-request-header-policy", "v-request-header-ref", "v-response-header-policy", "v-response-header-ref", "v-params", "v-is-location", "v-is-group", "v-has-group-request-config", "v-has-group-response-config", "v-group-setting-url"],
	data: function () {
		let type = "response"
		let hash = window.location.hash
		if (hash == "#request") {
			type = "request"
		}

		// ref
		let requestHeaderRef = this.vRequestHeaderRef
		if (requestHeaderRef == null) {
			requestHeaderRef = {
				isPrior: false,
				isOn: true,
				headerPolicyId: 0
			}
		}

		let responseHeaderRef = this.vResponseHeaderRef
		if (responseHeaderRef == null) {
			responseHeaderRef = {
				isPrior: false,
				isOn: true,
				headerPolicyId: 0
			}
		}

		// 请求相关
		let requestSettingHeaders = []
		let requestDeletingHeaders = []
		let requestNonStandardHeaders = []

		let requestPolicy = this.vRequestHeaderPolicy
		if (requestPolicy != null) {
			if (requestPolicy.setHeaders != null) {
				requestSettingHeaders = requestPolicy.setHeaders
			}
			if (requestPolicy.deleteHeaders != null) {
				requestDeletingHeaders = requestPolicy.deleteHeaders
			}
			if (requestPolicy.nonStandardHeaders != null) {
				requestNonStandardHeaders = requestPolicy.nonStandardHeaders
			}
		}

		// 响应相关
		let responseSettingHeaders = []
		let responseDeletingHeaders = []
		let responseNonStandardHeaders = []

		let responsePolicy = this.vResponseHeaderPolicy
		if (responsePolicy != null) {
			if (responsePolicy.setHeaders != null) {
				responseSettingHeaders = responsePolicy.setHeaders
			}
			if (responsePolicy.deleteHeaders != null) {
				responseDeletingHeaders = responsePolicy.deleteHeaders
			}
			if (responsePolicy.nonStandardHeaders != null) {
				responseNonStandardHeaders = responsePolicy.nonStandardHeaders
			}
		}

		let responseCORS = {
			isOn: false
		}
		if (responsePolicy.cors != null) {
			responseCORS = responsePolicy.cors
		}

		return {
			type: type,
			typeName: (type == "request") ? this.$t('http-header-policy-box@请求') : this.$t('http-header-policy-box@响应'),

			requestHeaderRef: requestHeaderRef,
			responseHeaderRef: responseHeaderRef,
			requestSettingHeaders: requestSettingHeaders,
			requestDeletingHeaders: requestDeletingHeaders,
			requestNonStandardHeaders: requestNonStandardHeaders,

			responseSettingHeaders: responseSettingHeaders,
			responseDeletingHeaders: responseDeletingHeaders,
			responseNonStandardHeaders: responseNonStandardHeaders,
			responseCORS: responseCORS
		}
	},
	methods: {
		selectType: function (type) {
			this.type = type
			window.location.hash = "#" + type
			window.location.reload()
		},
		addSettingHeader: function (policyId) {
			teaweb.popup("/servers/server/settings/headers/createSetPopup?" + this.vParams + "&headerPolicyId=" + policyId + "&type=" + this.type, {
				height: "22em",
				title: this.$t('http-header-policy-box@创建自定义报头'),
				callback: function () {
					teaweb.successRefresh(this.$t('http-header-policy-box@保存成功'))
				}
			})
		},
		addDeletingHeader: function (policyId, type) {
			teaweb.popup("/servers/server/settings/headers/createDeletePopup?" + this.vParams + "&headerPolicyId=" + policyId + "&type=" + type, {
				title: this.$t('http-header-policy-box@创建自定义报头'),
				callback: function () {
					teaweb.successRefresh(this.$t('http-header-policy-box@保存成功'))
				}
			})
		},
		addNonStandardHeader: function (policyId, type) {
			teaweb.popup("/servers/server/settings/headers/createNonStandardPopup?" + this.vParams + "&headerPolicyId=" + policyId + "&type=" + type, {
				title: this.$t('http-header-policy-box@创建自定义报头'),
				callback: function () {
					teaweb.successRefresh(this.$t('http-header-policy-box@保存成功'))
				}
			})
		},
		updateSettingPopup: function (policyId, headerId) {
			teaweb.popup("/servers/server/settings/headers/updateSetPopup?" + this.vParams + "&headerPolicyId=" + policyId + "&headerId=" + headerId + "&type=" + this.type, {
				height: "22em",
				title: this.$t('http-header-policy-box@修改自定义报头'),
				callback: function () {
					teaweb.successRefresh(this.$t('http-header-policy-box@保存成功'))
				}
			})
		},
		deleteDeletingHeader: function (policyId, headerName) {
			let that = this
			teaweb.confirm(this.$t('http-header-policy-box@确定要删除_headerName_吗', {'headerName': headerName}), function () {
				Tea.action("/servers/server/settings/headers/deleteDeletingHeader")
					.params({
						headerPolicyId: policyId,
						headerName: headerName
					})
					.post()
					.refresh()
			})
		},
		deleteNonStandardHeader: function (policyId, headerName) {
			let that = this
			teaweb.confirm(this.$t('http-header-policy-box@确定要删除_headerName_吗', {'headerName': headerName}), function () {
				Tea.action("/servers/server/settings/headers/deleteNonStandardHeader")
					.params({
						headerPolicyId: policyId,
						headerName: headerName
					})
					.post()
					.refresh()
			})
		},
		deleteHeader: function (policyId, type, headerId) {
			let that = this
			teaweb.confirm(this.$t('http-header-policy-box@确定要删除此报头吗'), function () {
				this.$post("/servers/server/settings/headers/delete")
					.params({
						headerPolicyId: policyId,
						type: type,
						headerId: headerId
					})
					.refresh()
			}
			)
		},
		updateCORS: function (policyId) {
			teaweb.popup("/servers/server/settings/headers/updateCORSPopup?" + this.vParams + "&headerPolicyId=" + policyId + "&type=" + this.type, {
				height: "30em",
				title: this.$t('http-header-policy-box@修改CORS'),
				callback: function () {
					teaweb.successRefresh(this.$t('http-header-policy-box@保存成功'))
				}
			})
		}
	},
	template: `<div class="headers-box">
	<div class="headers-tab-menu">
		<div class="ui menu tabular small">
			<a class="item" :class="{active:type == 'response'}" @click.prevent="selectType('response')">
				<i class="icon reply"></i>
				{{$t('http-header-policy-box@响应报头')}}
				<span v-if="responseSettingHeaders.length > 0" class="ui label small circular">{{responseSettingHeaders.length}}</span>
			</a>
			<a class="item" :class="{active:type == 'request'}" @click.prevent="selectType('request')">
				<i class="icon share"></i>
				{{$t('http-header-policy-box@请求报头')}}
				<span v-if="requestSettingHeaders.length > 0" class="ui label small circular">{{requestSettingHeaders.length}}</span>
			</a>
		</div>
	</div>
	
	<input type="hidden" name="type" :value="type"/>
	
	<!-- 请求 -->
	<div v-if="(vIsLocation || vIsGroup) && type == 'request'" class="config-section">
		<div class="section-title">
			<i class="icon share"></i>
			<span>{{$t('http-header-policy-box@请求报头设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<input type="hidden" name="requestHeaderJSON" :value="JSON.stringify(requestHeaderRef)"/>
				<prior-checkbox :v-config="requestHeaderRef"></prior-checkbox>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<submit-btn></submit-btn>
			</div>
		</div>
	</div>
	
	<div v-if="((!vIsLocation && !vIsGroup) || requestHeaderRef.isPrior) && type == 'request'">
		<div v-if="vHasGroupRequestConfig">
        	<div class="margin"></div>
        	<warning-message>{{$t('http-header-policy-box@由于已经在当前')}}<a :href="vGroupSettingUrl + '#request'">{{$t('http-header-policy-box@网站分组')}}</a>{{$t('http-header-policy-box@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
    	</div>
    	<div :class="{'opacity-mask': vHasGroupRequestConfig}">
			<div class="config-section">
				<div class="section-title">
					<i class="icon edit"></i>
					<span>{{$t('http-header-policy-box@设置请求报头')}}</span>
					<a href="" @click.prevent="addSettingHeader(vRequestHeaderPolicy.id)" class="ant-btn-link">{{$t('http-header-policy-box@添加新报头')}}</a>
				</div>
				
				<div class="config-item">
					<div class="item-content">
						<p class="comment" v-if="requestSettingHeaders.length == 0">{{$t('http-header-policy-box@暂时还没有自定义报头')}}</p>
						<div v-if="requestSettingHeaders.length > 0" class="headers-table-box">
                            <b-table
                                :columns="[
                                    { title: $t('http-header-policy-box@名称'), key: 'name', width: '30%', scopedSlots: { customRender: 'nameSlot' } },
                                    { title: $t('http-header-policy-box@值'), dataIndex: 'value', key: 'value' },
                                    { title: $t('http-header-policy-box@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
                                ]"
                                :data-source="requestSettingHeaders"
                                :row-key="'id'"
                                :pagination="false"
                            >
                                <template slot="nameSlot" slot-scope="{ text, record }">
                                     <a href="" @click.prevent="updateSettingPopup(vRequestHeaderPolicy.id, record.id)">{{record.name}} <i class="icon expand small"></i></a>
                                     <div>
                                        <span v-if="record.status != null && record.status.codes != null && !record.status.always"><grey-label v-for="code in record.status.codes" :key="code">{{code}}</grey-label></span>
                                        <span v-if="record.methods != null && record.methods.length > 0"><grey-label v-for="method in record.methods" :key="method">{{method}}</grey-label></span>
                                        <span v-if="record.domains != null && record.domains.length > 0"><grey-label v-for="domain in record.domains" :key="domain">{{domain}}</grey-label></span>
                                        <grey-label v-if="record.shouldAppend">{{$t('http-header-policy-box@附加')}}</grey-label>
                                        <grey-label v-if="record.disableRedirect">{{$t('http-header-policy-box@跳转禁用')}}</grey-label>
                                        <grey-label v-if="record.shouldReplace && record.replaceValues != null && record.replaceValues.length > 0">{{$t('http-header-policy-box@替换')}}</grey-label>
                                    </div>
                                </template>
                                <template slot="actionSlot" slot-scope="{ text, record }">
                                    <a-button type="link" @click.prevent="updateSettingPopup(vRequestHeaderPolicy.id, record.id)">{{$t('http-header-policy-box@修改')}}</a-button>
                                    <a-button type="link" danger @click.prevent="deleteHeader(vRequestHeaderPolicy.id, 'setHeader', record.id)">{{$t('http-header-policy-box@删除')}}</a-button>
                                </template>
                            </b-table>
						</div>
					</div>
				</div>
			</div>
			
			<div class="config-section">
				<div class="section-title">
					<i class="icon cog"></i>
					<span>{{$t('http-header-policy-box@其他设置')}}</span>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-header-policy-box@删除报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能删除转发到源站的请求报文中不需要的报头')"></tip-icon></div>
					<div class="item-content">
						<div v-if="requestDeletingHeaders.length > 0" class="headers-labels-box">
							<div class="ui label small basic" v-for="headerName in requestDeletingHeaders">
								{{headerName}} 
								<a href=""><i class="icon remove" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteDeletingHeader(vRequestHeaderPolicy.id, headerName)"></i></a>
							</div>
						</div>
						<button class="ui button small" type="button" @click.prevent="addDeletingHeader(vRequestHeaderPolicy.id, 'request')">
							<i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
						</button>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-header-policy-box@非标报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能设置转发到源站的请求报文中非标准的报头比如hello_world')"></tip-icon></div>
					<div class="item-content">
						<div v-if="requestNonStandardHeaders.length > 0" class="headers-labels-box">
							<div class="ui label small basic" v-for="headerName in requestNonStandardHeaders">
								{{headerName}} 
								<a href=""><i class="icon remove" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteNonStandardHeader(vRequestHeaderPolicy.id, headerName)"></i></a>
							</div>
						</div>
						<button class="ui button small" type="button" @click.prevent="addNonStandardHeader(vRequestHeaderPolicy.id, 'request')">
							<i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
						</button>
					</div>
				</div>
			</div>
		</div>			
	</div>
	
	<!-- 响应 -->
	<div v-if="(vIsLocation || vIsGroup) && type == 'response'" class="config-section">
		<div class="section-title">
			<i class="icon reply"></i>
			<span>{{$t('http-header-policy-box@响应报头设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<input type="hidden" name="responseHeaderJSON" :value="JSON.stringify(responseHeaderRef)"/>
				<prior-checkbox :v-config="responseHeaderRef"></prior-checkbox>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<submit-btn></submit-btn>
			</div>
		</div>
	</div>
	
	<div v-if="((!vIsLocation && !vIsGroup) || responseHeaderRef.isPrior) && type == 'response'">
		<div v-if="vHasGroupResponseConfig">
        	<div class="margin"></div>
        	<warning-message>{{$t('http-header-policy-box@由于已经在当前')}}<a :href="vGroupSettingUrl + '#response'">{{$t('http-header-policy-box@网站分组')}}</a>{{$t('http-header-policy-box@中进行了对应的配置在这里的配置将不会生效')}}</warning-message>
    	</div>
    	<div :class="{'opacity-mask': vHasGroupResponseConfig}">
			<div class="config-section">
				<div class="section-title">
					<i class="icon edit"></i>
					<span>{{$t('http-header-policy-box@设置响应报头')}}</span>
					<a href="" @click.prevent="addSettingHeader(vResponseHeaderPolicy.id)" class="ant-btn-link">{{$t('http-header-policy-box@添加新报头')}}</a>
				</div>
				
				<div class="config-item">
					<div class="item-content">
						<p class="comment">{{$t('http-header-policy-box@将会覆盖已有的同名报头')}}</p>
						<p class="comment" v-if="responseSettingHeaders.length == 0">{{$t('http-header-policy-box@暂时还没有自定义报头')}}</p>
						<div v-if="responseSettingHeaders.length > 0" class="headers-table-box">
                            <b-table
                                :columns="[
                                    { title: $t('http-header-policy-box@名称'), key: 'name', width: '30%', scopedSlots: { customRender: 'nameSlot' } },
                                    { title: $t('http-header-policy-box@值'), dataIndex: 'value', key: 'value' },
                                    { title: $t('http-header-policy-box@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
                                ]"
                                :data-source="responseSettingHeaders"
                                :row-key="'id'"
                                :pagination="false"
                            >
                                <template slot="nameSlot" slot-scope="{ text, record }">
                                    <a href="" @click.prevent="updateSettingPopup(vResponseHeaderPolicy.id, record.id)">{{record.name}} <i class="icon expand small"></i></a>
                                    <div>
                                        <span v-if="record.status != null && record.status.codes != null && !record.status.always"><grey-label v-for="code in record.status.codes" :key="code">{{code}}</grey-label></span>
                                        <span v-if="record.methods != null && record.methods.length > 0"><grey-label v-for="method in record.methods" :key="method">{{method}}</grey-label></span>
                                        <span v-if="record.domains != null && record.domains.length > 0"><grey-label v-for="domain in record.domains" :key="domain">{{domain}}</grey-label></span>
                                        <grey-label v-if="record.shouldAppend">{{$t('http-header-policy-box@附加')}}</grey-label>
                                        <grey-label v-if="record.disableRedirect">{{$t('http-header-policy-box@跳转禁用')}}</grey-label>
                                        <grey-label v-if="record.shouldReplace && record.replaceValues != null && record.replaceValues.length > 0">{{$t('http-header-policy-box@替换')}}</grey-label>
                                    </div>
                                    
                                    <!-- CORS -->
                                    <div v-if="record.name == 'Access-Control-Allow-Origin' && record.value == '*'">
                                        <span class="red small">{{$t('http-header-policy-box@建议使用当前页面下方的CORS自适应跨域功能代替AccessControl相关报头')}}</span>
                                    </div>
                                </template>
                                <template slot="actionSlot" slot-scope="{ text, record }">
                                    <a-button type="link" @click.prevent="updateSettingPopup(vResponseHeaderPolicy.id, record.id)">{{$t('http-header-policy-box@修改')}}</a-button>
                                    <a-button type="link" danger @click.prevent="deleteHeader(vResponseHeaderPolicy.id, 'setHeader', record.id)">{{$t('http-header-policy-box@删除')}}</a-button>
                                </template>
                            </b-table>
						</div>
					</div>
				</div>
			</div>
			
			<div class="config-section">
				<div class="section-title">
					<i class="icon cog"></i>
					<span>{{$t('http-header-policy-box@其他设置')}}</span>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-header-policy-box@删除报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能删除响应报文中不需要的报头')"></tip-icon></div>
					<div class="item-content">
						<div v-if="responseDeletingHeaders.length > 0" class="headers-labels-box">
							<div class="ui label small basic" v-for="headerName in responseDeletingHeaders">
								{{headerName}} &nbsp; 
								<a href=""><i class="icon remove small" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteDeletingHeader(vResponseHeaderPolicy.id, headerName)"></i></a>
							</div>
						</div>
						<button class="ui button small" type="button" @click.prevent="addDeletingHeader(vResponseHeaderPolicy.id, 'response')">
							<i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
						</button>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-header-policy-box@非标报头')}} <tip-icon :content="$t('http-header-policy-box@可以通过此功能设置响应报文中非标准的报头比如hello_world')"></tip-icon></div>
					<div class="item-content">
						<div v-if="responseNonStandardHeaders.length > 0" class="headers-labels-box">
							<div class="ui label small basic" v-for="headerName in responseNonStandardHeaders">
								{{headerName}} &nbsp; 
								<a href=""><i class="icon remove small" :title="$t('http-header-policy-box@删除')" @click.prevent="deleteNonStandardHeader(vResponseHeaderPolicy.id, headerName)"></i></a>
							</div>
						</div>
						<button class="ui button small" type="button" @click.prevent="addNonStandardHeader(vResponseHeaderPolicy.id, 'response')">
							<i class="icon plus"></i>{{$t('http-header-policy-box@添加')}}
						</button>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-header-policy-box@CORS自适应跨域')}}</div>
					<div class="item-content">
						<span v-if="responseCORS.isOn" class="green">{{$t('http-header-policy-box@已启用')}}</span><span class="disabled" v-else="">{{$t('http-header-policy-box@未启用')}}</span> &nbsp; 
						<a href="" @click.prevent="updateCORS(vResponseHeaderPolicy.id)">[{{$t('http-header-policy-box@修改')}}]</a>
						<p class="comment">{{$t('http-header-policy-box@启用后服务器可以自动生成')}}<code-label>Access-Control-*-*</code-label> {{$t('http-header-policy-box@相关的报头')}}</p>
					</div>
				</div>
			</div>
		</div>			
	</div>
</div>`
})

Vue.component("http-access-log-partitions-box", {
	props: ["v-partition", "v-day", "v-query"],
	mounted: function () {
		let that = this
		Tea.action("/servers/logs/partitionData")
			.params({
				day: this.vDay
			})
			.success(function (resp) {
				that.partitions = []
				resp.data.partitions.reverse().forEach(function (v) {
					that.partitions.push({
						code: v,
						isDisabled: false,
						hasLogs: false
					})
				})
				if (that.partitions.length > 0) {
					if (that.vPartition == null || that.vPartition < 0) {
						that.selectedPartition = that.partitions[0].code
					}

					if (that.partitions.length > 1) {
						that.checkLogs()
					}
				}
			})
			.post()
	},
	data: function () {
		return {
			partitions: [],
			selectedPartition: this.vPartition,
			checkingPartition: 0
		}
	},
	methods: {
		url: function (p) {
			let u = window.location.toString()
			u = u.replace(/\?partition=-?\d+/, "?")
			u = u.replace(/\?requestId=-?\d+/, "?")
			u = u.replace(/&partition=-?\d+/, "")
			u = u.replace(/&requestId=-?\d+/, "")
			if (u.indexOf("?") > 0) {
				u += "&partition=" + p
			} else {
				u += "?partition=" + p
			}
			return u
		},
		disable: function (partition) {
			this.partitions.forEach(function (p) {
				if (p.code == partition) {
					p.isDisabled = true
				}
			})
		},
		checkLogs: function () {
			let that = this
			let index = this.checkingPartition
			let params = {
				partition: index
			}
			let query = this.vQuery
			if (query == null || query.length == 0) {
				return
			}
			query.split("&").forEach(function (v) {
				let param = v.split("=")
				params[param[0]] = decodeURIComponent(param[1])
			})
			Tea.action("/servers/logs/hasLogs")
				.params(params)
				.post()
				.success(function (response) {
					if (response.data.hasLogs) {
						// 因为是倒序，所以这里需要使用总长度减去index
						that.partitions[that.partitions.length - 1 - index].hasLogs = true
					}

					index++
					if (index >= that.partitions.length) {
						return
					}
					that.checkingPartition = index
					that.checkLogs()
				})
		}
	},
	template: `<div v-if="partitions.length > 1">
	<div class="ui divider" style="margin-bottom: 0"></div>
	<div class="ui menu text small" style="margin-bottom: 0; margin-top: 0">
		<a v-for="(p, index) in partitions" :href="url(p.code)" class="item" :class="{active: selectedPartition == p.code, disabled: p.isDisabled}">分表{{p.code+1}} <span v-if="p.hasLogs">&nbsp; <dot></dot></span> &nbsp; &nbsp; <span class="disabled" v-if="index != partitions.length - 1">|</span></a>
	</div>
	<div class="ui divider" style="margin-top: 0"></div>
</div>`
})

Vue.component("http-header-assistant", {
	props: ["v-type", "v-value"],
	mounted: function () {
		let that = this
		Tea.action("/servers/headers/options?type=" + this.vType)
			.post()
			.success(function (resp) {
				that.allHeaders = resp.data.headers
			})
	},
	data: function () {
		return {
			allHeaders: [],
			matchedHeaders: [],

			selectedHeaderName: ""
		}
	},
	watch: {
		vValue: function (v) {
			if (v != this.selectedHeaderName) {
				this.selectedHeaderName = ""
			}

			if (v.length == 0) {
				this.matchedHeaders = []
				return
			}
			this.matchedHeaders = this.allHeaders.filter(function (header) {
				return teaweb.match(header, v)
			}).slice(0, 10)
		}
	},
	methods: {
		select: function (header) {
			this.$emit("select", header)
			this.selectedHeaderName = header
		}
	},
	template: `<span v-if="selectedHeaderName.length == 0">
	<a href="" v-for="header in matchedHeaders" class="ui label basic tiny" style="font-weight: normal; margin-bottom: 0.3em" @click.prevent="select(header)">{{header}}</a>
	<span v-if="matchedHeaders.length > 0">&nbsp; &nbsp;</span>
</span>`
})

Vue.component("http-firewall-policy-selector", {
	props: ["v-http-firewall-policy"],
	mounted: function () {
		let that = this
		Tea.action("/servers/components/waf/count")
			.post()
			.success(function (resp) {
				that.count = resp.data.count
			})
	},
	data: function () {
		let firewallPolicy = this.vHttpFirewallPolicy
		return {
			count: 0,
			firewallPolicy: firewallPolicy
		}
	},
	methods: {
		remove: function () {
			this.firewallPolicy = null
		},
		select: function () {
			let that = this
			teaweb.popup("/servers/components/waf/selectPopup", {
				title: this.$t("server_http-firewall-policy-selector@选择WAF策略"),
				height: "26em",
				callback: function (resp) {
					that.firewallPolicy = resp.data.firewallPolicy
				}
			})
		},
		create: function () {
			let that = this
			teaweb.popup("/servers/components/waf/createPopup", {
				title: this.$t("server_http-firewall-policy-selector@创建WAF策略"),
				height: "26em",
				callback: function (resp) {
					that.firewallPolicy = resp.data.firewallPolicy
				}
			})
		}
	},
	template: `<div>
	<div v-if="firewallPolicy != null" class="ui label basic">
		<input type="hidden" name="httpFirewallPolicyId" :value="firewallPolicy.id"/>
		{{firewallPolicy.name}} &nbsp; <a :href="'/servers/components/waf/policy?firewallPolicyId=' + firewallPolicy.id" target="_blank" :title="$t('server_http-firewall-policy-selector@修改')"><i class="icon pencil small"></i></a>&nbsp; <a href="" @click.prevent="remove()" :title="$t('server_http-firewall-policy-selector@删除')"><i class="pi pi-times"></i></a>
	</div>
	<div v-if="firewallPolicy == null">
		<span v-if="count > 0">
			<a href="" @click.prevent="select">{{$t("server_http-firewall-policy-selector@选择已有策略")}}</a> &nbsp; &nbsp;
		</span>
		<a href="" @click.prevent="create">
			<i class="pi pi-pen-to-square"></i>
			{{$t("server_http-firewall-policy-selector@创建新策略")}}
		</a>
	</div>
</div>`
})

Vue.component("http-cors-header-config-box", {
	props: ["value"],
	data: function () {
		let config = this.value
		if (config == null) {
			config = {
				isOn: false,
				allowMethods: [],
				allowOrigin: "",
				allowCredentials: true,
				exposeHeaders: [],
				maxAge: 0,
				requestHeaders: [],
				requestMethod: "",
				optionsMethodOnly: false
			}
		}
		if (config.allowMethods == null) {
			config.allowMethods = []
		}
		if (config.exposeHeaders == null) {
			config.exposeHeaders = []
		}

		let maxAgeSecondsString = config.maxAge.toString()
		if (maxAgeSecondsString == "0") {
			maxAgeSecondsString = ""
		}

		return {
			config: config,

			maxAgeSecondsString: maxAgeSecondsString,

			moreOptionsVisible: false
		}
	},
	watch: {
		maxAgeSecondsString: function (v) {
			let seconds = parseInt(v)
			if (isNaN(seconds)) {
				seconds = 0
			}
			this.config.maxAge = seconds
		}
	},
	methods: {
		changeMoreOptions: function (visible) {
			this.moreOptionsVisible = visible
		},
		addDefaultAllowMethods: function () {
			let that = this
			let defaultMethods = ["PUT", "GET", "POST", "DELETE", "HEAD", "OPTIONS", "PATCH"]
			defaultMethods.forEach(function (method) {
				if (!that.config.allowMethods.$contains(method)) {
					that.config.allowMethods.push(method)
				}
			})
		}
	},
	template: `<div>
	<input type="hidden" name="corsJSON" :value="JSON.stringify(config)"/>
	<table class="ui table definition selectable">
		<tbody>
			<tr>
				<td class="title">{{$t('http-cors-header-config-box@启用CORS自适应跨域')}}</td>
				<td>
					<checkbox :v-value="1" v-model="config.isOn"></checkbox>
					<p class="comment">{{$t('http-cors-header-config-box@启用后自动在响应报头中增加对应的')}}<code-label>Access-Control-*</code-label>{{$t('http-cors-header-config-box@相关的报头')}}</p>
				</td>
			</tr>
		</tbody>
		<tbody v-show="config.isOn">
			<tr>
				<td colspan="2"><more-options-indicator @change="changeMoreOptions"></more-options-indicator></td>
			</tr>
		</tbody>
		<tbody v-show="config.isOn && moreOptionsVisible">
			<tr>
				<td>{{$t('http-cors-header-config-box@允许的请求方法列表')}}</td>
				<td>
					<http-methods-box :v-methods="config.allowMethods"></http-methods-box>
					<p class="comment"><a href="" @click.prevent="addDefaultAllowMethods">[{{$t('http-cors-header-config-box@添加默认')}}]</a>。<code-label>Access-Control-Allow-Methods</code-label>{{$t('http-cors-header-config-box@值设置所访问资源允许使用的方法列表不设置则表示默认为')}}<code-label>PUT</code-label>、<code-label>GET</code-label>、<code-label>POST</code-label>、<code-label>DELETE</code-label>、<code-label>HEAD</code-label>、<code-label>OPTIONS</code-label>、<code-label>PATCH</code-label>。</p>
				</td>
			</tr>
			<tr>
				<td>{{$t('http-cors-header-config-box@预检结果缓存时间')}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 6em" maxlength="6" v-model="maxAgeSecondsString"/>
						<span class="ui label">{{$t('http-cors-header-config-box@秒')}}</span>
					</div>
					<p class="comment"><code-label>Access-Control-Max-Age</code-label>{{$t('http-cors-header-config-box@值设置预检结果缓存时间0或者不填表示使用浏览器默认设置注意每个浏览器有不同的缓存时间上限')}}</p>
				</td>
			</tr>
			<tr>
				<td>{{$t('http-cors-header-config-box@允许服务器暴露的报头')}}</td>
				<td>
					<values-box :v-values="config.exposeHeaders"></values-box>
					<p class="comment"><code-label>Access-Control-Expose-Headers</code-label>{{$t('http-cors-header-config-box@值设置允许服务器暴露的报头请注意报头的大小写')}}</p>
				</td>
			</tr>
			<tr>
				<td>{{$t('http-cors-header-config-box@实际请求方法')}}</td>
				<td>
					<input type="text" v-model="config.requestMethod"/>
					<p class="comment"><code-label>Access-Control-Request-Method</code-label>{{$t('http-cors-header-config-box@值设置实际请求服务器时使用的方法比如')}}<code-label>POST</code-label>。</p>
				</td>
			</tr>
			<tr>
				<td>{{$t('http-cors-header-config-box@仅OPTIONS有效')}}</td>
				<td>
					<checkbox :v-value="1" v-model="config.optionsMethodOnly"></checkbox>
					<p class="comment">{{$t('http-cors-header-config-box@选中后表示当前CORS设置仅在OPTIONS方法请求时有效')}}</p>
				</td>
			</tr>
		</tbody>
	</table>
	<div class="margin"></div>
</div>`
})

Vue.component("http-webp-config-box", {
	props: ["v-webp-config", "v-is-location", "v-is-group", "v-require-cache"],
	data: function () {
		let config = this.vWebpConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				minLength: { count: 0, "unit": "kb" },
				maxLength: { count: 0, "unit": "kb" },
				mimeTypes: ["image/png", "image/jpeg", "image/bmp", "image/x-ico"],
				extensions: [".png", ".jpeg", ".jpg", ".bmp", ".ico"],
				conds: null
			}
		}

		if (config.mimeTypes == null) {
			config.mimeTypes = []
		}
		if (config.extensions == null) {
			config.extensions = []
		}

		return {
			config: config,
			moreOptionsVisible: true
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		changeExtensions: function (values) {
			values.forEach(function (v, k) {
				if (v.length > 0 && v[0] != ".") {
					values[k] = "." + v
				}
			})
			this.config.extensions = values
			this.submit()
		},
		changeMimeTypes: function (values) {
			this.config.mimeTypes = values
			this.submit()
		},
		changeAdvancedVisible: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		changeConds: function (conds) {
			this.config.conds = conds
			this.submit()
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="webp-box">
	<input type="hidden" name="webpJSON" :value="JSON.stringify(config)"/>
	
	<!-- 基本设置 -->
	<div class="config-section">
		<div class="section-title">
			<i class="icon image"></i>
			<span>{{$t('http-webp-config-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="config" v-if="vIsLocation || vIsGroup" class="config-item"></prior-checkbox>
		
		<div class="config-item" v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
			<div class="item-label">{{$t('http-webp-config-box@启用WebP压缩')}}</div>
			<div class="item-content">
				<p-switch v-model="config.isOn" binary @change="submit"></p-switch>
				<p class="comment">{{$t('http-webp-config-box@选中后表示开启自动WebP压缩图片的宽和高均不能超过16383像素')}}<span v-if="vRequireCache">{{$t('http-webp-config-box@只有满足缓存条件的图片内容才会被转换')}}</span>。</p>
			</div>
		</div>
	</div>
	
	<!-- 详细配置 -->
	<div class="config-section" v-show="isOn() && moreOptionsVisible">
		<div class="section-title">
			<i class="icon sliders"></i>
			<span>{{$t('http-webp-config-box@详细配置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-webp-config-box@支持的扩展名')}}</div>
			<div class="item-content">
				<values-box :values="config.extensions" @change="changeExtensions" :placeholder="$t('http-webp-config-box@比如html')"></values-box>
				<p class="comment">{{$t('http-webp-config-box@含有这些扩展名的URL将会被转成WebP不区分大小写')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-webp-config-box@支持的MimeType')}}</div>
			<div class="item-content">
				<values-box :values="config.mimeTypes" @change="changeMimeTypes" :placeholder="$t('http-webp-config-box@比如text')"></values-box>
				<p class="comment">{{$t('http-webp-config-box@响应的ContentType里包含这些MimeType的内容将会被转成WebP')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-webp-config-box@内容最小长度')}}</div>
			<div class="item-content">
				<size-capacity-box :v-name="'minLength'" :v-value="config.minLength" :v-unit="'kb'" @change="submit"></size-capacity-box>
				<p class="comment">{{$t('http-webp-config-box@0表示不限制内容长度从文件尺寸或ContentLength中获取')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-webp-config-box@内容最大长度')}}</div>
			<div class="item-content">
				<size-capacity-box :v-name="'maxLength'" :v-value="config.maxLength" :v-unit="'mb'" @change="submit"></size-capacity-box>
				<p class="comment">{{$t('http-webp-config-box@0表示不限制内容长度从文件尺寸或ContentLength中获取')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-webp-config-box@匹配条件')}}</div>
			<div class="item-content">
				<http-request-conds-box :v-conds="config.conds" @change="changeConds"></http-request-conds-box>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("server-config-copy-link", {
	props: ["v-server-id", "v-config-code"],
	data: function () {
		return {
			serverId: this.vServerId,
			configCode: this.vConfigCode
		}
	},
	methods: {
		copy: function () {
			teaweb.popup("/servers/server/settings/copy?serverId=" + this.serverId + "&configCode=" + this.configCode, {
				title: this.$t('server-config-copy-link-plus@批量复制配置'),
				height: "25em",
				callback: function () {
					teaweb.success(this.$t('server-config-copy-link-plus@批量复制成功'))
				}
			})
		}
	},
	template: `<a href=\"" class="item" @click.prevent="copy" style="padding-right:0"><span style="font-size: 0.8em">{{$t('server-config-copy-link-plus@批量')}}</span>&nbsp;<i class="icon copy small"></i></a>`
})

Vue.component("origin-list-table", {
	props: ["v-origins", "v-origin-type"],
	data: function () {
		let hasMatchedDomains = false
		let origins = this.vOrigins
		if (origins != null && origins.length > 0) {
			origins.forEach(function (origin) {
				if (origin.domains != null && origin.domains.length > 0) {
					hasMatchedDomains = true
				}
			})
		}

		return {
			hasMatchedDomains: hasMatchedDomains,
			columns: [
				{
					title: this.$t('origin-list-table@源站地址'),
					key: 'addr',
					scopedSlots: { customRender: 'addrSlot' },
					width: '50%'
				},
				{
					title: this.$t('origin-list-table@权重'),
					key: 'weight',
					scopedSlots: { customRender: 'weightSlot' },
					width: '100px'
				},
				{
					title: this.$t('origin-list-table@状态'),
					key: 'status',
					scopedSlots: { customRender: 'statusSlot' },
					width: '100px',
					align: 'center'
				},
				{
					title: this.$t('origin-list-table@操作'),
					key: 'operation',
					scopedSlots: { customRender: 'operationSlot' },
					width: '180px',
					align: 'center',
				}
			]
		}
	},
	methods: {
		deleteOrigin: function (originId, originAddr) {
			this.$emit("delete-origin", originId, originAddr, this.vOriginType)
		},
		updateOrigin: function (originId) {
			this.$emit("update-origin", originId, this.vOriginType)
		},
		updateOriginIsOn: function (originId, originAddr, isOn) {
			this.$emit("update-origin-is-on", originId, originAddr, isOn)
		}
	},
	template: `
<div>
	<div class="margin"></div>
	<b-table
		:columns="columns"
		:data-source="vOrigins"
		:row-key="'id'"
		:scroll="{ x: 800 }"
		size="middle"
	>
		<template slot="addrSlot" slot-scope="{ text, record }">
			<div :class="{disabled:!record.isOn}">
				<a href="" @click.prevent="updateOrigin(record.id)" :class="{disabled:!record.isOn}">{{record.addr}} &nbsp;<i class="pi pi-external-link" style="font-size: 12px; padding: 2px;"></i></a>
				<div style="margin-top: 0.3em">
					<tiny-basic-label class="grey border-grey" v-if="record.isOSS"><i class="pi pi-database" style="font-size: 12px; padding: 2px;"></i>{{$t('origin-list-table@对象存储')}}</tiny-basic-label>
					<tiny-basic-label class="grey border-grey" v-if="record.name.length > 0">{{record.name}}</tiny-basic-label>
					<tiny-basic-label class="grey border-grey" v-if="record.hasCert">{{$t('origin-list-table@证书')}}</tiny-basic-label>
					<tiny-basic-label class="grey border-grey" v-if="record.host != null && record.host.length > 0">{{$t('origin-list-table@主机名')}}: {{record.host}}</tiny-basic-label>
					<tiny-basic-label class="grey border-grey" v-if="record.followPort">{{$t('origin-list-table@端口跟随')}}</tiny-basic-label>
					<tiny-basic-label class="grey border-grey" v-if="record.addr != null && record.addr.startsWith('https://') && record.http2Enabled">HTTP/2</tiny-basic-label>
	
					<span v-if="record.domains != null && record.domains.length > 0"><tiny-basic-label class="grey border-grey" v-for="domain in record.domains">{{$t('origin-list-table@匹配')}}: {{domain}}</tiny-basic-label></span>
					<span v-else-if="hasMatchedDomains"><tiny-basic-label class="grey border-grey">{{$t('origin-list-table@匹配')}}: {{$t('origin-list-table@所有域名')}}</tiny-basic-label></span>
				</div>
			</div>
		</template>

		<template slot="weightSlot" slot-scope="{ text, record }">
			<span :class="{disabled:!record.isOn}">{{record.weight}}</span>
		</template>

		<template slot="statusSlot" slot-scope="{ text, record }">
			<label-on :v-is-on="record.isOn"></label-on>
		</template>

		<template slot="operationSlot" slot-scope="{ text, record }">
			<a-button type="link" @click.prevent="updateOrigin(record.id)">
				<i class="pi pi-pencil" style="font-size: 12px; padding: 4px 2px;"></i> {{$t('origin-list-table@修改')}}
			</a-button>
			<a-button type="link" v-if="record.isOn" @click.prevent="updateOriginIsOn(record.id, record.addr, false)">
				<i class="pi pi-pause" style="font-size: 12px; padding: 4px 2px;"></i> {{$t('origin-list-table@停用')}}
			</a-button>
			<a-button type="link" v-if="!record.isOn" @click.prevent="updateOriginIsOn(record.id, record.addr, true)" class="red">
				<i class="pi pi-play" style="font-size: 12px; padding: 4px 2px;"></i> {{$t('origin-list-table@启用')}}
			</a-button>
			<a-button type="link" @click.prevent="deleteOrigin(record.id, record.addr)">
				<i class="pi pi-trash" style="font-size: 12px; padding: 4px 2px;"></i> {{$t('origin-list-table@删除')}}
			</a-button>
		</template>
	</b-table>
</div>`
})


Vue.component("http-cache-policy-selector", {
	props: ["v-cache-policy"],
	mounted: function () {
		let that = this
		Tea.action("/servers/components/cache/count")
			.post()
			.success(function (resp) {
				that.count = resp.data.count
			})
	},
	data: function () {
		let cachePolicy = this.vCachePolicy
		return {
			count: 0,
			cachePolicy: cachePolicy
		}
	},
	methods: {
		remove: function () {
			this.cachePolicy = null
		},
		select: function () {
			let that = this
			teaweb.popup("/servers/components/cache/selectPopup", {
				title: this.$t("http-cache-policy-selector@选择缓存策略"),
				width: "42em",
				height: "26em",
				callback: function (resp) {
					that.cachePolicy = resp.data.cachePolicy
				}
			})
		},
		create: function () {
			let that = this
			teaweb.popup("/servers/components/cache/createPopup", {
				title: this.$t("http-cache-policy-selector@创建缓存策略"),
				height: "26em",
				callback: function (resp) {
					that.cachePolicy = resp.data.cachePolicy
				}
			})
		}
	},
	template: `<div>
	<div v-if="cachePolicy != null" class="ui label basic">
		<input type="hidden" name="cachePolicyId" :value="cachePolicy.id"/>
		{{cachePolicy.name}} &nbsp; <a :href="'/servers/components/cache/update?cachePolicyId=' + cachePolicy.id" target="_blank" :title="$t('http-cache-policy-selector@修改')"><i class="icon pencil small"></i></a>&nbsp; <a href="" @click.prevent="remove()" :title="$t('http-cache-policy-selector@删除')"><i class="pi pi-times"></i></a>
	</div>
	<div v-if="cachePolicy == null">
		<span v-if="count > 0">
			<a href="" @click.prevent="select">{{$t("http-cache-policy-selector@选择已有策略")}}</a> &nbsp; &nbsp;
		</span>
		<a href="" @click.prevent="create">
			<i class="pi pi-pen-to-square"></i>
			{{$t("http-cache-policy-selector@创建新策略")}} 
		</a>
	</div>
</div>`
})

Vue.component("http-firewall-captcha-options", {
	props: ["v-captcha-options"],
	mounted: function () {
		this.updateSummary()
	},
	data: function () {
		let options = this.vCaptchaOptions
		if (options == null) {
			options = {
				captchaType: "default",
				countLetters: 0,
				life: 0,
				maxFails: 0,
				failBlockTimeout: 0,
				failBlockScopeAll: false,
				uiIsOn: false,
				uiTitle: "",
				uiPrompt: "",
				uiButtonTitle: "",
				uiShowRequestId: true,
				uiCss: "",
				uiFooter: "",
				uiBody: "",
				cookieId: "",
				lang: "",
				geeTestConfig: {
					isOn: false,
					captchaId: "",
					captchaKey: ""
				}
			}
		}
		if (options.countLetters <= 0) {
			options.countLetters = 6
		}

		if (options.captchaType == null || options.captchaType.length == 0) {
			options.captchaType = "default"
		}


		return {
			options: options,
			isEditing: false,
			summary: "",
			uiBodyWarning: "",
			captchaTypes: window.WAF_CAPTCHA_TYPES
		}
	},
	watch: {
		"options.countLetters": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			} else if (i < 0) {
				i = 0
			} else if (i > 10) {
				i = 10
			}
			this.options.countLetters = i
		},
		"options.life": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.life = i
			this.updateSummary()
		},
		"options.maxFails": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.maxFails = i
			this.updateSummary()
		},
		"options.failBlockTimeout": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.failBlockTimeout = i
			this.updateSummary()
		},
		"options.failBlockScopeAll": function (v) {
			this.updateSummary()
		},
		"options.captchaType": function (v) {
			this.updateSummary()
		},
		"options.uiIsOn": function (v) {
			this.updateSummary()
		},
		"options.uiBody": function (v) {
			if (/<form(>|\s).+\$\{body}.*<\/form>/s.test(v)) {
				this.uiBodyWarning = "页面模板中不能使用<form></form>标签包裹\${body}变量，否则将导致验证码表单无法提交。"
			} else {
				this.uiBodyWarning = ""
			}
		},
		"options.geeTestConfig.isOn": function (v) {
			this.updateSummary()
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		},
		updateSummary: function () {
			let summaryList = []
			if (this.options.life > 0) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@有效时间") + this.options.life + this.$t("server_http-firewall-captcha-options@秒"))
			}
			if (this.options.maxFails > 0) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@最多失败") + this.options.maxFails + this.$t("server_http-firewall-captcha-options@次"))
			}
			if (this.options.failBlockTimeout > 0) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@失败拦截") + this.options.failBlockTimeout + this.$t("server_http-firewall-captcha-options@秒"))
			}
			if (this.options.failBlockScopeAll) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@尝试全局封禁"))
			}

			let that = this
			let typeDef = this.captchaTypes.$find(function (k, v) {
				return v.code == that.options.captchaType
			})
			if (typeDef != null) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@默认验证方式Colon") + typeDef.name)
			}

			if (this.options.captchaType == "default") {
				if (this.options.uiIsOn) {
					summaryList.push(this.$t("server_http-firewall-captcha-options@定制UI"))
				}
			}

			if (this.options.geeTestConfig != null && this.options.geeTestConfig.isOn) {
				summaryList.push(this.$t("server_http-firewall-captcha-options@已配置极验"))
			}

			if (summaryList.length == 0) {
				this.summary = this.$t("server_http-firewall-captcha-options@默认配置")
			} else {
				this.summary = summaryList.join(" / ")
			}
		},
		confirm: function () {
			this.isEditing = false
		}
	},
	template: `<div>
	<input type="hidden" name="captchaOptionsJSON" :value="JSON.stringify(options)"/>
	<a href="" @click.prevent="edit">{{summary}} <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
	<div v-show="isEditing" style="margin-top: 0.5em">
		<table class="ui table definition selectable">
			<tbody>
				<tr>
					<td>{{$t("server_http-firewall-captcha-options@默认验证方式")}}</td>
					<td>
						<b-select
							v-model="options.captchaType"
							auto-width
							:options="[
								...captchaTypes.map(captchaDef => ({
									label: captchaDef.name??'',
									value: captchaDef.code??'',
								}))
							]"
						></b-select>
						<p class="comment" v-for="captchaDef in captchaTypes" v-if="captchaDef.code == options.captchaType">{{captchaDef.description}}</p>
					</td>
				</tr>
				<tr>
					<td class="title">{{$t("server_http-firewall-captcha-options@有效时间")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.life" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("server_http-firewall-captcha-options@秒")}}</span>
						</div>
						<p class="comment">{{$t("server_http-firewall-captcha-options@有效时间Help")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("server_http-firewall-captcha-options@最多失败次数")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.maxFails" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("server_http-firewall-captcha-options@次")}}</span>
						</div>
						<p class="comment"><span v-if="options.maxFails > 0 && options.maxFails < 5" class="red">{{$t("server_http-firewall-captcha-options@建议填入一个不小于5的数字")}}</span>{{$t("server_http-firewall-captcha-options@最多失败次数Help")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("server_http-firewall-captcha-options@失败拦截时间")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.failBlockTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("server_http-firewall-captcha-options@秒")}}</span>
						</div>
						<p class="comment">{{$t("server_http-firewall-captcha-options@失败拦截时间Help")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("server_http-firewall-captcha-options@失败全局封禁")}}</td>
					<td>
						<checkbox :v-value="1" v-model="options.failBlockScopeAll"></checkbox>
						<p class="comment">{{$t("server_http-firewall-captcha-options@失败全局封禁Help")}}</p>
					</td>
				</tr>
				
				<tr v-show="options.captchaType == 'default'">
					<td>{{$t("server_http-firewall-captcha-options@验证码中数字个数")}}</td>
					<td>
						<b-select
							v-model="options.countLetters"
							auto-width
							:options="[
								...[1, 2, 3, 4, 5, 6, 7, 8, 9, 10].map(i => ({
									label: i,
									value: i,
								})),
							]"
						></b-select>
					</td>
				</tr>
				<tr v-show="options.captchaType == 'default'">
					<td class="color-border">{{$t("server_http-firewall-captcha-options@定制UI")}}</td>
					<td><checkbox :v-value="1" v-model="options.uiIsOn"></checkbox></td>
				</tr>
			</tbody>
			<tbody v-show="options.uiIsOn && options.captchaType == 'default'">
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@页面标题")}}</td>
					<td>
						<input type="text" v-model="options.uiTitle" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@按钮标题")}}</td>
					<td>
						<input type="text" v-model="options.uiButtonTitle" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<p class="comment">{{$t("server_http-firewall-captcha-options@按钮标题Help")}}<code-label>{{$t("server_http-firewall-captcha-options@提交验证")}}</code-label>。</p>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@显示请求ID")}}</td>
					<td>
						<checkbox :v-value="1" v-model="options.uiShowRequestId"></checkbox>
						<p class="comment">{{$t("server_http-firewall-captcha-options@显示请求IDHelp")}}</p>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@CSS样式")}}</td>
					<td>
						<textarea spellcheck="false" v-model="options.uiCss" rows="2"></textarea>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@页头提示")}}</td>
					<td>
						<textarea spellcheck="false" v-model="options.uiPrompt" rows="2"></textarea>
						<p class="comment">{{$t("server_http-firewall-captcha-options@页头提示Help")}}<code-label>{{$t("server_http-firewall-captcha-options@请输入上面的验证码")}}</code-label>{{$t("server_http-firewall-captcha-options@支持HTML")}}</p>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@页尾提示")}}</td>
					<td>
						<textarea spellcheck="false" v-model="options.uiFooter" rows="2"></textarea>
						<p class="comment">{{$t("server_http-firewall-captcha-options@支持HTML")}}</p>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@页面模板")}}</td>
					<td>
						<textarea spellcheck="false" rows="2" v-model="options.uiBody"></textarea>
						<p class="comment"><span v-if="uiBodyWarning.length > 0" class="red">{{$t("server_http-firewall-captcha-options@页面模板警告前缀")+uiBodyWarning}}</span><span v-if="options.uiBody.length > 0 && options.uiBody.indexOf('\${body}') < 0 " class="red">{{$t("server_http-firewall-captcha-options@模板中必须包含body表示验证码表单")}}</span>{{$t("server_http-firewall-captcha-options@页面模板Help")}}<code-label>\${body}</code-label>{{$t("server_http-firewall-captcha-options@变量代表验证码表单")}}</p>
					</td>
				</tr>
			</tbody>
		</table>
		
		<table class="ui table definition selectable">
			<tr>
				<td class="title">{{$t("server_http-firewall-captcha-options@允许用户使用极验")}}</td>
				<td><checkbox :v-value="1" v-model="options.geeTestConfig.isOn"></checkbox>
					<p class="comment">{{$t("server_http-firewall-captcha-options@允许用户使用极验Help")}}</p>
				</td>
			</tr>
			<tbody v-show="options.geeTestConfig.isOn">
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@极验验证ID*")}}</td>
					<td>
						<input type="text" maxlength="100" name="geetestCaptchaId" v-model="options.geeTestConfig.captchaId" spellcheck="false"/>
						<p class="comment">{{$t("server_http-firewall-captcha-options@极验验证IDHelp")}}</p>
					</td>
				</tr>
				<tr>
					<td class="color-border">{{$t("server_http-firewall-captcha-options@极验验证Key*")}}</td>
					<td>
						<input type="text" maxlength="100" name="geetestCaptchaKey" v-model="options.geeTestConfig.captchaKey" spellcheck="false"/>
						<p class="comment">{{$t("server_http-firewall-captcha-options@极验验证KeyHelp")}}</p>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
`
})

Vue.component("http-request-scripts-config-box", {
	props: ["vRequestScriptsConfig", "v-auditing-status", "v-is-location"],
	data: function () {
		let config = this.vRequestScriptsConfig
		if (config == null) {
			config = {}
		}

		return {
			config: config
		}
	},
	methods: {
		changeInitGroup: function (group) {
			this.config.initGroup = group
			this.$forceUpdate()
		},
		changeRequestGroup: function (group) {
			this.config.requestGroup = group
			this.$forceUpdate()
		}
	},
	template: `<div class="request-scripts-box">
	<input type="hidden" name="requestScriptsJSON" :value="JSON.stringify(config)"/>
	
	<!-- 请求初始化脚本 -->
	<div class="config-section">
		<div class="section-title">
			<i class="icon code"></i>
			<span>{{$t("http-request-scripts-config-box@请求初始化")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<p class="comment">{{$t("http-request-scripts-config-box@在请求刚初始化时调用此时自定义报头")}}</p>
				<script-group-config-box :v-group="config.initGroup" :v-auditing-status="vAuditingStatus" @change="changeInitGroup" :v-is-location="vIsLocation"></script-group-config-box>
			</div>
		</div>
	</div>
	
	<!-- 准备发送请求脚本 -->
	<div class="config-section">
		<div class="section-title">
			<i class="icon send"></i>
			<span>{{$t("http-request-scripts-config-box@准备发送请求")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<p class="comment">{{$t("http-request-scripts-config-box@在准备执行请求或者转发请求之前调用")}}</p>
				<script-group-config-box :v-group="config.requestGroup" :v-auditing-status="vAuditingStatus" @change="changeRequestGroup" :v-is-location="vIsLocation"></script-group-config-box>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("http-pages-and-shutdown-box", {
	props: ["v-enable-global-pages", "v-pages", "v-shutdown-config", "v-is-location"],
	data: function () {
		let pages = []
		if (this.vPages != null) {
			pages = this.vPages
		}
		let shutdownConfig = {
			isPrior: false,
			isOn: false,
			bodyType: "html",
			url: "",
			body: "",
			status: 0
		}
		if (this.vShutdownConfig != null) {
			if (this.vShutdownConfig.body == null) {
				this.vShutdownConfig.body = ""
			}
			if (this.vShutdownConfig.bodyType == null) {
				this.vShutdownConfig.bodyType = "html"
			}
			shutdownConfig = this.vShutdownConfig
		}

		let shutdownStatus = ""
		if (shutdownConfig.status > 0) {
			shutdownStatus = shutdownConfig.status.toString()
		}

		return {
			pages: pages,
			shutdownConfig: shutdownConfig,
			shutdownStatus: shutdownStatus,
			enableGlobalPages: this.vEnableGlobalPages
		}
	},
	watch: {
		shutdownStatus: function (status) {
			let statusInt = parseInt(status)
			if (!isNaN(statusInt) && statusInt > 0 && statusInt < 1000) {
				this.shutdownConfig.status = statusInt
			} else {
				this.shutdownConfig.status = 0
			}
		}
	},
	computed: {
		tableColumns: function() {
			return [
				{
					title: this.$t('http-pages-and-shutdown-box@响应状态码'),
					dataIndex: 'status',
					width: '120px',
					scopedSlots: { customRender: 'status' }
				},
				{
					title: this.$t('http-pages-and-shutdown-box@页面类型'),
					dataIndex: 'pageType',
					scopedSlots: { customRender: 'pageType' }
				},
				{
					title: this.$t('http-pages-and-shutdown-box@新状态码'),
					dataIndex: 'newStatus',
					width: '120px',
					scopedSlots: { customRender: 'newStatus' }
				},
				{
					title: this.$t('http-pages-and-shutdown-box@例外URL'),
					dataIndex: 'exceptURLPatterns',
					scopedSlots: { customRender: 'exceptURLPatterns' }
				},
				{
					title: this.$t('http-pages-and-shutdown-box@限制URL'),
					dataIndex: 'onlyURLPatterns',
					scopedSlots: { customRender: 'onlyURLPatterns' }
				},
				{
					title: this.$t('http-pages-and-shutdown-box@操作'),
					dataIndex: 'actions',
					width: '200px',
					scopedSlots: { customRender: 'actions' }
				}
			]
		}
	},
	methods: {
		addPage: function () {
			let that = this
			teaweb.popup("/servers/server/settings/pages/createPopup", {
				title: this.$t('http-pages-and-shutdown-box@创建自定义页面'),
				height: "30em",
				callback: function (resp) {
					that.pages.push(resp.data.page)
					that.notifyChange()
					that.submit()
				}
			})
		},
		updatePage: function (pageIndex, pageId) {
			let that = this
			teaweb.popup("/servers/server/settings/pages/updatePopup?pageId=" + pageId, {
				title: this.$t('http-pages-and-shutdown-box@修改自定义页面'),
				height: "30em",
				callback: function (resp) {
					Vue.set(that.pages, pageIndex, resp.data.page)
					that.notifyChange()
					that.submit()
				}
			})
		},
		removePage: function (pageIndex) {
			let that = this
			teaweb.confirm(this.$t('http-pages-and-shutdown-box@确定要删除此自定义页面吗'), function () {
				that.pages.$remove(pageIndex)
				that.notifyChange()
				that.submit()
			})
		},
		addShutdownHTMLTemplate: function () {
			this.shutdownConfig.body = `<!DOCTYPE html>
<html lang="en">
<head>
\t<title>升级中</title>
\t<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
\t<style>
\t\taddress { line-height: 1.8; }
\t</style>
</head>
<body>

<h1>网站升级中</h1>
<p>为了给您提供更好的服务，我们正在升级网站，请稍后重新访问。</p>

<address>Connection: \${remoteAddr} (Client) -&gt; \${serverAddr} (Server)</address>
<address>Request ID: \${requestId}</address>

</body>
</html>`
			this.submit()
		},
		notifyChange: function () {
			let parent = this.$el.parentNode
			while (true) {
				if (parent == null) {
					break
				}
				if (parent.tagName == "FORM") {
					break
				}
				parent = parent.parentNode
			}
			if (parent != null) {
				setTimeout(function () {
					Tea.runActionOn(parent)
				}, 100)
			}
		},
        submit: function () {
            this.$emit("submit", this.pages, this.shutdownConfig, this.enableGlobalPages)
        }
	},
	template: `<div class="pages-box">
<input type="hidden" name="pagesJSON" :value="JSON.stringify(pages)"/>
<input type="hidden" name="shutdownJSON" :value="JSON.stringify(shutdownConfig)"/>

<div class="config-section">
    <div class="section-title">
        <i class="icon file alternate outline"></i>
        <span>{{$t('http-pages-and-shutdown-box@自定义页面')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-content">
            <p class="comment">{{$t('http-pages-and-shutdown-box@根据响应状态码返回一些自定义页面比如404_500等错误页面')}}</p>
            
            <div v-if="pages.length > 0" class="custom-pages-table-box">
                <b-table :columns="tableColumns" :data-source="pages" :bordered="true">
                    <template slot="status" slot-scope="{ text, record, index }">
                        <a href="" @click.prevent="updatePage(index, record.id)">
                            <span v-if="record.status != null && record.status.length == 1">{{record.status[0]}}</span>
                            <span v-else>{{record.status}}</span>
                            <i class="icon expand small"></i>
                        </a>
                    </template>
                    
                    <template slot="pageType" slot-scope="{ text, record, index }">
                        <div style="word-break: break-all">
                            <div v-if="record.bodyType == 'url'">
                                {{record.url}}
                                <div>
                                    <grey-label>{{$t('http-pages-and-shutdown-box@读取URL')}}</grey-label>
                                </div>
                            </div>
                            <div v-if="record.bodyType == 'redirectURL'">
                                {{record.url}}
                                <div>
                                    <grey-label>{{$t('http-pages-and-shutdown-box@跳转URL')}}</grey-label>	
                                    <grey-label v-if="record.newStatus > 0">{{record.newStatus}}</grey-label>
                                </div>
                            </div>
                            <div v-if="record.bodyType == 'html'">
                                {{$t('http-pages-and-shutdown-box@HTML内容')}}
                                <div>
                                    <grey-label v-if="record.newStatus > 0">{{record.newStatus}}</grey-label>
                                </div>
                            </div>
                        </div>
                    </template>
                    
                    <template slot="newStatus" slot-scope="{ text, record, index }">
                        <span v-if="record.newStatus > 0">{{record.newStatus}}</span>
                        <span v-else class="disabled">{{$t('http-pages-and-shutdown-box@保持')}}</span>
                    </template>
                    
                    <template slot="exceptURLPatterns" slot-scope="{ text, record, index }">
                        <div v-if="record.exceptURLPatterns != null && record.exceptURLPatterns">
                            <span v-for="urlPattern in record.exceptURLPatterns" class="ui basic label small">{{urlPattern.pattern}}</span>
                        </div>
                        <span v-else class="disabled">-</span>
                    </template>
                    
                    <template slot="onlyURLPatterns" slot-scope="{ text, record, index }">
                        <div v-if="record.onlyURLPatterns != null && record.onlyURLPatterns">
                            <span v-for="urlPattern in record.onlyURLPatterns" class="ui basic label small">{{urlPattern.pattern}}</span>
                        </div>
                        <span v-else class="disabled">-</span>
                    </template>
                    
                    <template slot="actions" slot-scope="{ text, record, index }">
                        <a href="" :title="$t('http-pages-and-shutdown-box@修改')" @click.prevent="updatePage(index, record.id)">{{$t('http-pages-and-shutdown-box@修改')}}</a> &nbsp; 
                        <a href="" :title="$t('http-pages-and-shutdown-box@删除')" @click.prevent="removePage(index)">{{$t('http-pages-and-shutdown-box@删除')}}</a>
                    </template>
                </b-table>
            </div>
            <div class="page-actions-box" style="margin-top: 1em">
                <button class="ui button small" type="button" @click.prevent="addPage()">
                    <i class="icon plus"></i>{{$t('http-pages-and-shutdown-box@添加自定义页面')}}
                </button>
            </div>
        </div>
    </div>
</div>

<div class="config-section">
    <div class="section-title">
        <i class="icon power off"></i>
        <span>{{$t('http-pages-and-shutdown-box@临时关闭页面')}}</span>
    </div>
    
    <div class="config-item" v-if="vIsLocation">
        <div class="item-content">
            <prior-checkbox :v-config="shutdownConfig" @change="submit"></prior-checkbox>
        </div>
    </div>
    
    <div class="config-item" v-show="!vIsLocation || shutdownConfig.isPrior">
        <div class="item-content">
            <checkbox v-model="shutdownConfig.isOn" binary @change="submit">{{$t('http-pages-and-shutdown-box@启用临时关闭网站')}}</checkbox> 
            <p class="comment">{{$t('http-pages-and-shutdown-box@选中后表示临时关闭当前网站并显示自定义内容')}}</p>
        </div>
    </div>
    
    <div v-show="(!vIsLocation || shutdownConfig.isPrior) && shutdownConfig.isOn">
        <div class="config-item">
            <div class="item-label">{{$t('http-pages-and-shutdown-box@显示内容类型')}} *</div>
            <div class="item-content">
                <b-select v-model="shutdownConfig.bodyType" @change="submit" :options="[
                    {label: $t('http-pages-and-shutdown-box@HTML'), value:'html'},
                    {label: $t('http-pages-and-shutdown-box@读取URL'), value:'url'},
                    {label: $t('http-pages-and-shutdown-box@跳转URL'), value:'redirectURL'},
                ]"></b-select>
            </div>
        </div>
        
        <div class="config-item" v-if="shutdownConfig.bodyType == 'url'">
            <div class="item-label">{{$t('http-pages-and-shutdown-box@显示页面URL')}} *</div>
            <div class="item-content">
                <input type="text" v-model="shutdownConfig.url" @blur="submit" :placeholder="$t('http-pages-and-shutdown-box@类似于_example_com_page_html')"/>
                <p class="comment">{{$t('http-pages-and-shutdown-box@将从此URL中读取内容')}}</p>
            </div>
        </div>
        
        <div class="config-item" v-if="shutdownConfig.bodyType == 'redirectURL'">
            <div class="item-label">{{$t('http-pages-and-shutdown-box@跳转到URL')}} *</div>
            <div class="item-content">
                <input type="text" v-model="shutdownConfig.url" @blur="submit" :placeholder="$t('http-pages-and-shutdown-box@类似于_example_com_page_html')"/>
                <p class="comment">{{$t('http-pages-and-shutdown-box@将会跳转到此URL')}}</p>
            </div>
        </div>
        
        <div class="config-item" v-show="shutdownConfig.bodyType == 'html'">
            <div class="item-label">{{$t('http-pages-and-shutdown-box@显示页面HTML')}} *</div>
            <div class="item-content">
                <textarea name="body" ref="shutdownHTMLBody" v-model="shutdownConfig.body" @blur="submit"></textarea>
                <p class="comment"><a href="" @click.prevent="addShutdownHTMLTemplate">[{{$t('http-pages-and-shutdown-box@使用模板')}}]</a>。{{$t('http-pages-and-shutdown-box@填写页面的HTML内容支持请求变量')}}</p>
            </div>
        </div>
        
        <div class="config-item">
            <div class="item-label">{{$t('http-pages-and-shutdown-box@状态码')}}</div>
            <div class="item-content">
                <input type="text" size="3" maxlength="3" @blur="submit" name="shutdownStatus" style="width:5.2em" :placeholder="$t('http-pages-and-shutdown-box@状态码')" v-model="shutdownStatus"/>
            </div>
        </div>
    </div>
</div>

<div class="config-section">
    <div class="section-title">
        <i class="icon cog"></i>
        <span>{{$t('http-pages-and-shutdown-box@其他设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-content">
            <checkbox name="enableGlobalPages" @change="submit" v-model="enableGlobalPages" binary>{{$t('http-pages-and-shutdown-box@启用系统自定义页面')}}</checkbox>
            <p class="comment">{{$t('http-pages-and-shutdown-box@选中后表示如果当前网站没有自定义页面则尝试使用系统对应的自定义页面')}}</p>
        </div>
    </div>
</div>

</div>`
})

Vue.component("http-firewall-block-options-viewer", {
	props: ["v-block-options"],
	data: function () {
		return {
			options: this.vBlockOptions
		}
	},
	template: `<div>
	<span v-if="options == null">{{$t("http-firewall-block-options-viewer@默认设置")}}</span>
	<div v-else>
		{{$t("http-firewall-block-options-viewer@状态码")}}：{{options.statusCode}} / {{$t("http-firewall-block-options-viewer@提示内容")}}：<span v-if="options.body != null && options.body.length > 0">[{{options.body.length}}{{$t("http-firewall-block-options-viewer@字符")}}]</span><span v-else class="disabled">[{{$t("http-firewall-block-options-viewer@无")}}]</span>  / {{$t("http-firewall-block-options-viewer@超时时间")}}：{{options.timeout}}{{$t("http-firewall-block-options-viewer@秒")}} <span v-if="options.timeoutMax > options.timeout">/ {{$t("http-firewall-block-options-viewer@最大封禁时长")}}：{{options.timeoutMax}}{{$t("http-firewall-block-options-viewer@秒")}}</span>
		<span v-if="options.failBlockScopeAll"> / {{$t("http-firewall-block-options-viewer@尝试全局封禁")}}</span>
	</div>
</div>	
`
})

// 显示WAF规则的标签
Vue.component("http-firewall-rule-label", {
	props: ["v-rule"],
	data: function () {
		return {
			rule: this.vRule
		}
	},
	methods: {
		showErr: function (err) {
			teaweb.popupTip(this.$t('waf_rule@规则校验错误，请修正') + "：<span class=\"red\">"  + teaweb.encodeHTML(err) + "</span>")
		},
		calculateParamName: function (param) {
			let paramName = ""
			if (param != null) {
				window.WAF_RULE_CHECKPOINTS.forEach(function (checkpoint) {
					if (param == "${" + checkpoint.prefix + "}" || param.startsWith("${" + checkpoint.prefix + ".")) {
						paramName = checkpoint.name
					}
				})
			}
			return paramName
		},
		calculateParamDescription: function (param) {
			let paramName = ""
			let paramDescription = ""
			if (param != null) {
				window.WAF_RULE_CHECKPOINTS.forEach(function (checkpoint) {
					if (param == "${" + checkpoint.prefix + "}" || param.startsWith("${" + checkpoint.prefix + ".")) {
						paramName = checkpoint.name
						paramDescription = checkpoint.description
					}
				})
			}
			return paramName + ": " + paramDescription
		},
		operatorName: function (operatorCode) {
			let operatorName = operatorCode
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorName = v.name
					}
				})
			}

			return operatorName
		},
		operatorDescription: function (operatorCode) {
			let operatorName = operatorCode
			let operatorDescription = ""
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorName = v.name
						operatorDescription = v.description
					}
				})
			}

			return operatorName + ": " + operatorDescription
		},
		operatorDataType: function (operatorCode) {
			let operatorDataType = "none"
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorDataType = v.dataType
					}
				})
			}

			return operatorDataType
		},
		isEmptyString: function (v) {
			return typeof v == "string" && v.length == 0
		}
	},
	template: `<div>
	<div class="ui label small basic" style="line-height: 1.5">
		{{rule.name}} <span :title="calculateParamDescription(rule.param)" class="hover">{{calculateParamName(rule.param)}}<span class="small grey"> {{rule.param}}</span></span>

		<!-- cc2 -->
		<span v-if="rule.param == '\${cc2}'">
			{{rule.checkpointOptions.period}} {{$t('waf_rule@秒内请求数')}}
		</span>

		<!-- refererBlock -->
		<span v-if="rule.param == '\${refererBlock}'">
			<span v-if="rule.checkpointOptions.allowDomains != null && rule.checkpointOptions.allowDomains.length > 0">{{$t('waf_rule@允许')}} {{rule.checkpointOptions.allowDomains}}</span>
			<span v-if="rule.checkpointOptions.denyDomains != null && rule.checkpointOptions.denyDomains.length > 0">{{$t('waf_rule@禁止')}} {{rule.checkpointOptions.denyDomains}}</span>
		</span>

		<span v-else>
			<span v-if="rule.paramFilters != null && rule.paramFilters.length > 0" v-for="paramFilter in rule.paramFilters"> | {{paramFilter.code}}</span> 
		<span class="hover" :class="{dash:!rule.isComposed && rule.isCaseInsensitive}" :title="operatorDescription(rule.operator) + ((!rule.isComposed && rule.isCaseInsensitive) ? '\\n[大小写不敏感] ':'')">&lt;{{operatorName(rule.operator)}}&gt;</span> 
			<span class="hover" v-if="!isEmptyString(rule.value)">{{rule.value}}</span>
			<span v-else-if="operatorDataType(rule.operator) != 'none'" class="disabled" style="font-weight: normal" title="空字符串">[{{$t('waf_rule@空')}}]</span>
		</span>
		
		<!-- description -->
		<span v-if="rule.description != null && rule.description.length > 0" class="grey small">（{{rule.description}}）</span>
		
		<a href="" v-if="rule.err != null && rule.err.length > 0" @click.prevent="showErr(rule.err)" style="color: #db2828; opacity: 1; border-bottom: 1px #db2828 dashed; margin-left: 0.5em">{{$t('waf_rule@规则错误')}}</a>
	</div>
</div>`
})

Vue.component("http-access-log-config-box", {
	props: ["v-access-log-config", "v-fields", "v-default-field-codes", "v-access-log-policies", "v-is-location", "v-is-group"],
	data: function () {
		let that = this

		// 初始化
		setTimeout(function () {
			that.changeFields(true)
			that.changePolicy(true)
		}, 100)

		let accessLog = {
			isPrior: false,
			isOn: false,
			fields: [],
			status1: true,
			status2: true,
			status3: true,
			status4: true,
			status5: true,

			storageOnly: false,
			storagePolicies: [],

			firewallOnly: false
		}
		if (this.vAccessLogConfig != null) {
			accessLog = this.vAccessLogConfig
		}

		this.vFields.forEach(function (v) {
			if (that.vAccessLogConfig == null) { // 初始化默认值
				v.isChecked = that.vDefaultFieldCodes.$contains(v.code)
			} else {
				v.isChecked = accessLog.fields.$contains(v.code)
			}
		})
		if (this.vAccessLogPolicies != null) {
			this.vAccessLogPolicies.forEach(function (v) {
				v.isChecked = accessLog.storagePolicies.$contains(v.id)
			})
		}

		return {
			accessLog: accessLog,
			showAdvancedOptions: true
		}
	},
	methods: {
		changeFields: function (submit) {
			this.accessLog.fields = this.vFields.filter(function (v) {
				return v.isChecked
			}).map(function (v) {
				return v.code
			})
			if (!submit) {
				this.submit()
			}
		},
		changePolicy: function (submit) {
			if(this.vAccessLogPolicies == null){
				return
			}
			this.accessLog.storagePolicies = this.vAccessLogPolicies.filter(function (v) {
				return v.isChecked
			}).map(function (v) {
				return v.id
			})
			if (!submit) {
				this.submit()
			}
		},
		changeAdvanced: function (v) {
			this.showAdvancedOptions = v
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.accessLog)
			}, 100)
		}
	},
	template: `<div class="access-log-box">
	<input type="hidden" name="accessLogJSON" :value="JSON.stringify(accessLog)"/>
	
	<div class="config-section">
		<div class="section-title">
			<i class="icon file alternate"></i>
			<span>{{$t('http-access-log-config-box@访问日志设置')}}</span>
		</div>
		
		<div v-if="vIsLocation" class="config-item">
			<prior-checkbox :v-config="accessLog"></prior-checkbox>
		</div>
		
		<div v-show="!vIsLocation || accessLog.isPrior" class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@启用访问日志')}}</div>
			<div class="item-content">
				<p-switch v-model="accessLog.isOn" binary @change="submit"></p-switch>
			</div>
		</div>
	</div>
	
	<div v-show="(!vIsLocation || accessLog.isPrior) && accessLog.isOn && showAdvancedOptions" class="config-section">
		<div class="section-title">
			<i class="icon cog"></i>
			<span>{{$t('http-access-log-config-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@要存储的访问日志字段')}}</div>
			<div class="item-content">
				<div class="log-fields-box">
					<div class="ui checkbox" v-for="field in vFields">
						<p-checkbox :id="field.id" v-model="field.isChecked" @change="changeFields(false)" binary/>
						<label :for="field.id">{{field.name}}</label>
					</div>
				</div>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@要存储的访问日志状态码')}}</div>
			<div class="item-content">
				<div class="log-status-box">
					<div class="ui checkbox">
						<p-checkbox v-model="accessLog.status1" @change="submit" binary/>
						<label>1xx</label>
					</div>
					<div class="ui checkbox">
						<p-checkbox v-model="accessLog.status2" @change="submit" binary/>
						<label>2xx</label>
					</div>
					<div class="ui checkbox">
						<p-checkbox v-model="accessLog.status3" @change="submit" binary/>
						<label>3xx</label>
					</div>
					<div class="ui checkbox">
						<p-checkbox v-model="accessLog.status4" @change="submit" binary/>
						<label>4xx</label>
					</div>
					<div class="ui checkbox">
						<p-checkbox v-model="accessLog.status5" @change="submit" binary/>
						<label>5xx</label>
					</div>
				</div>
			</div>
		</div>
		
		<div v-show="vAccessLogPolicies != null && vAccessLogPolicies.length > 0" class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@选择输出的日志策略')}}</div>
			<div class="item-content">
				<span class="disabled" v-if="vAccessLogPolicies == null || vAccessLogPolicies.length == 0">{{$t('http-access-log-config-box@暂时还没有日志策略')}}</span>
				<div v-if="vAccessLogPolicies != null && vAccessLogPolicies.length > 0" class="log-policies-box">
					<div class="ui checkbox" v-for="policy in vAccessLogPolicies">
						<p-checkbox :id="policy.id" v-model="policy.isChecked" @change="changePolicy(false)" binary/>
						<label :for="policy.id">{{policy.name}}</label>
					</div>
				</div>
			</div>
		</div>
		
		<div v-show="vAccessLogPolicies != null && vAccessLogPolicies.length > 0" class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@是否只输出到日志策略')}}</div>
			<div class="item-content">
				<p-checkbox v-model="accessLog.storageOnly" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-access-log-config-box@选中表示只输出日志到日志策略而停止默认的日志存储')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-access-log-config-box@只记录WAF相关日志')}}</div>
			<div class="item-content">
				<p-checkbox v-model="accessLog.firewallOnly" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-access-log-config-box@选中后只记录WAF相关的日志')}}</p>
			</div>
		</div>
	</div>
	
	<div class="margin"></div>
</div>`
})

Vue.component("http-cache-config-box", {
	props: ["v-cache-config", "v-is-location", "v-is-group", "v-cache-policy", "v-web-id"],
	data: function () {
		let cacheConfig = this.vCacheConfig
		if (cacheConfig == null) {
			cacheConfig = {
				isPrior: false,
				isOn: false,
				addStatusHeader: true,
				addAgeHeader: false,
				enableCacheControlMaxAge: false,
				cacheRefs: [],
				purgeIsOn: false,
				purgeKey: "",
				disablePolicyRefs: false
			}
		}
		if (cacheConfig.cacheRefs == null) {
			cacheConfig.cacheRefs = []
		}

		let maxBytes = null
		if (this.vCachePolicy != null && this.vCachePolicy.maxBytes != null) {
			maxBytes = this.vCachePolicy.maxBytes
		}

		// key
		if (cacheConfig.key == null) {
			// use Vue.set to activate vue events
			Vue.set(cacheConfig, "key", {
				isOn: false,
				scheme: "https",
				host: ""
			})
		}

		return {
			cacheConfig: cacheConfig,
			moreOptionsVisible: true,
			enablePolicyRefs: !cacheConfig.disablePolicyRefs,
			maxBytes: maxBytes,

			searchBoxVisible: false,
			searchKeyword: "",

			keyOptionsVisible: false
		}
	},
	watch: {
		enablePolicyRefs: function (v) {
			this.cacheConfig.disablePolicyRefs = !v
		},
		searchKeyword: function (v) {
			this.$refs.cacheRefsConfigBoxRef.search(v)
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.cacheConfig.isPrior) && this.cacheConfig.isOn
		},
		isPlus: function () {
			return true
		},
		generatePurgeKey: function () {
			let r = Math.random().toString() + Math.random().toString()
			let s = r.replace(/0\./g, "")
				.replace(/\./g, "")
			let result = ""
			for (let i = 0; i < s.length; i++) {
				result += String.fromCharCode(parseInt(s.substring(i, i + 1)) + ((Math.random() < 0.5) ? "a" : "A").charCodeAt(0))
			}
			this.cacheConfig.purgeKey = result
		},
		showMoreOptions: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		changeStale: function (stale) {
			this.cacheConfig.stale = stale
		},
		showSearchBox: function () {
			this.searchBoxVisible = !this.searchBoxVisible
			if (this.searchBoxVisible) {
				let that = this
				setTimeout(function () {
					that.$refs.searchBox.focus()
				})
			} else {
				this.searchKeyword = ""
			}
		}
	},
	template: `<div>
	<input type="hidden" name="cacheJSON" :value="JSON.stringify(cacheConfig)"/>
	
	<div class="config-section">
		<div class="section-title">
			<i class="icon database"></i>
			<span>{{$t('http-cache-config-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox v-if="vIsLocation" :v-config="cacheConfig"></prior-checkbox>
		
		<div class="config-item" v-show="!vIsLocation || cacheConfig.isPrior">
			<div class="item-label">{{$t('http-cache-config-box@启用缓存')}}</div>
			<div class="item-content">
				<p-switch v-model="cacheConfig.isOn" binary></p-switch>
			</div>
		</div>
		
		<div class="config-item" v-show="isOn() && !vIsGroup">
			<div class="item-label">{{$t('http-cache-config-box@缓存主域名')}}</div>
			<div class="item-content">
				<div v-show="!cacheConfig.key.isOn">{{$t('http-cache-config-box@默认')}} &nbsp; <a href="" @click.prevent="keyOptionsVisible = !keyOptionsVisible"><span class="small">[{{$t('http-cache-config-box@修改')}}]</span></a></div>
				<div v-show="cacheConfig.key.isOn">{{$t('http-cache-config-box@使用主域名')}}：{{cacheConfig.key.scheme}}://{{cacheConfig.key.host}} &nbsp;  <a href="" @click.prevent="keyOptionsVisible = !keyOptionsVisible"><span class="small">[{{$t('http-cache-config-box@修改')}}]</span></a></div>
			</div>
		</div>
		<div v-show="keyOptionsVisible" class="more-options-box" style="margin-top: 1em">
				<div class="config-item">
					<div class="item-label">{{$t('http-cache-config-box@启用主域名')}}</div>
					<div class="item-content">
						<p-checkbox v-model="cacheConfig.key.isOn" binary></p-checkbox>
						<p class="comment">{{$t('http-cache-config-box@启用主域名提示')}}</p>
					</div>
				</div>
				
				<div class="config-item" v-show="cacheConfig.key.isOn">
					<div class="item-label">{{$t('http-cache-config-box@主域名*')}}</div>
					<div class="item-content">
						<div class="ui fields inline">
							<div class="ui field">
								<b-select v-model="cacheConfig.key.scheme" :options="[
									{label:'https://', value:'https'},
									{label:'http://', value:'http'},
								]"></b-select>
							</div>
							<div class="ui field">
								<input type="text" v-model="cacheConfig.key.host" :placeholder="$t('http-cache-config-box@主域名Placeholder')" @keyup.enter="keyOptionsVisible = false" @keypress.enter.prevent="1"/>
							</div>
						</div>
						<p class="comment" v-html="$t('http-cache-config-box@主域名提示')"></p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label"></div>
					<div class="item-content">
						<button class="ui button tiny" type="button" @click.prevent="keyOptionsVisible = false">{{$t('http-cache-config-box@完成')}}</button>
					</div>
				</div>
			</div>
	</div>
	
	<div class="config-section" v-show="isOn() && moreOptionsVisible">
		<div class="section-title">
			<i class="icon cog"></i>
			<span>{{$t('http-cache-config-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="enablePolicyRefs" binary>{{$t('http-cache-config-box@使用默认缓存条件')}}</checkbox>
				<p style="padding-left: 1.8em;" class="comment">{{$t('http-cache-config-box@使用默认缓存条件提示')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="cacheConfig.addStatusHeader" binary>{{$t('http-cache-config-box@添加X-Cache报头')}}</checkbox>
				<p style="padding-left: 1.8em;" class="comment">{{$t('http-cache-config-box@添加X-Cache报头提示')}}<code-label>X-Cache: BYPASS|MISS|HIT|PURGE</code-label>; {{$t('http-cache-config-box@添加X-Cache报头提示2')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="cacheConfig.addAgeHeader" binary>{{$t('http-cache-config-box@添加AgeHeader')}}</checkbox>
				<p style="padding-left: 1.8em;" class="comment">{{$t('http-cache-config-box@添加AgeHeader提示')}}<code-label>Age: [{{$t('http-cache-config-box@存活时间秒数')}}]</code-label></p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="cacheConfig.enableCacheControlMaxAge" binary>{{$t('http-cache-config-box@支持源站控制有效时间')}}</checkbox>
				<p style="padding-left: 1.8em;" class="comment">{{$t('http-cache-config-box@支持源站控制有效时间提示')}}<code-label>Cache-Control: max-age=[{{$t('http-cache-config-box@有效时间秒数')}}]</code-label></p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="cacheConfig.purgeIsOn" binary>{{$t('http-cache-config-box@允许PURGE')}}</checkbox>
				<p style="padding-left: 1.8em;" class="comment">{{$t('http-cache-config-box@允许PURGE提示')}}</p>
			</div>
		</div>
		
		<div class="config-item" v-show="cacheConfig.purgeIsOn">
			<div class="item-label">{{$t('http-cache-config-box@PURGEKey*')}}</div>
			<div class="item-content">
				<input type="text" maxlength="200" v-model="cacheConfig.purgeKey"/>
				<p class="comment">
					<a href="" @click.prevent="generatePurgeKey()">[随机生成]</a>
					{{$t('http-cache-config-box@需要在PURGE方法调用时加入')}}<code-label>Edge-Purge-Key: {0}</code-label>{{$t('http-cache-config-box@Header。只能包含字符、数字、下划线。')}}
				</p>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()">
		<div class="config-section">
			<div class="section-title">
				<i class="icon list"></i>
				<span>{{$t('http-cache-config-box@缓存条件')}}</span>
				<div style="margin-top: -2px; margin-left: 0.5em;">
					<a href="" class="ui button tiny" @click.prevent="$refs.cacheRefsConfigBoxRef.addRef(false)">{{$t('http-cache-config-box@添加')}}</a>
					<a href="" class="ui button tiny" @click.prevent="showSearchBox" v-show="!searchBoxVisible">{{$t('http-cache-config-box@搜索')}}</a>
					<div class="ui input small right labeled" style="display: inline-flex; margin-left: 0.5em" v-show="searchBoxVisible">
						<input type="text" :placeholder="$t('http-cache-config-box@搜索Placeholder')" ref="searchBox" @keypress.enter.prevent="1" @keydown.esc="showSearchBox" v-model="searchKeyword" size="20"/>
						<a href="" class="ui label blue" @click.prevent="showSearchBox"><i class="icon remove small"></i></a>
					</div>
				</div>
			</div>
			
			<http-cache-refs-config-box ref="cacheRefsConfigBoxRef" :v-cache-config="cacheConfig" :v-cache-refs="cacheConfig.cacheRefs" :v-web-id="vWebId" :v-max-bytes="maxBytes"></http-cache-refs-config-box>
		</div>
	</div>
</div>`
})


Vue.component("http-fastcgi-box", {
	props: ["v-fastcgi-ref", "v-fastcgi-configs", "v-is-location"],
	data: function () {
		let fastcgiRef = this.vFastcgiRef
		if (fastcgiRef == null) {
			fastcgiRef = {
				isPrior: false,
				isOn: false,
				fastcgiIds: []
			}
		}
		let fastcgiConfigs = this.vFastcgiConfigs
		if (fastcgiConfigs == null) {
			fastcgiConfigs = []
		} else {
			fastcgiRef.fastcgiIds = fastcgiConfigs.map(function (v) {
				return v.id
			})
		}

		return {
			fastcgiRef: fastcgiRef,
			fastcgiConfigs: fastcgiConfigs,
			advancedVisible: false
		}
	},
	methods: {
		isOn: function () {
			return (!this.vIsLocation || this.fastcgiRef.isPrior) && this.fastcgiRef.isOn
		},
		createFastcgi: function () {
			let that = this
			teaweb.popup("/servers/server/settings/fastcgi/createPopup", {
				title: this.$t('http-fastcgi-box@添加Fastcgi服务'),
				height: "26em",
				callback: function (resp) {
					teaweb.success(this.$t('http-fastcgi-box@添加成功'), function () {
						that.fastcgiConfigs.push(resp.data.fastcgi)
						that.fastcgiRef.fastcgiIds.push(resp.data.fastcgi.id)
					})
				}
			})
		},
		updateFastcgi: function (fastcgiId, index) {
			let that = this
			teaweb.popup("/servers/server/settings/fastcgi/updatePopup?fastcgiId=" + fastcgiId, {
				title: this.$t('http-fastcgi-box@修改Fastcgi服务'),
				callback: function (resp) {
					teaweb.success(this.$t('http-fastcgi-box@修改成功'), function () {
						Vue.set(that.fastcgiConfigs, index, resp.data.fastcgi)
					})
				}
			})
		},
		removeFastcgi: function (index) {
			this.fastcgiRef.fastcgiIds.$remove(index)
			this.fastcgiConfigs.$remove(index)
		}
	},
	template: `<div class="config-section">
	<input type="hidden" name="fastcgiRefJSON" :value="JSON.stringify(fastcgiRef)"/>
	<div class="section-title">
		<i class="pi pi-server"></i>
		{{$t('http-fastcgi-box@FastCGI设置')}}
	</div>
	<div class="base-form">
		<div v-if="vIsLocation" class="config-item">
			<div class="item-content">
				<prior-checkbox :v-config="fastcgiRef"></prior-checkbox>
			</div>
		</div>
		
		<div v-show="(!this.vIsLocation || this.fastcgiRef.isPrior)" class="config-item">
			<div class="item-label">{{$t('http-fastcgi-box@启用配置')}}</div>
			<div class="item-content">
				<p-switch :v-value="1" v-model="fastcgiRef.isOn"></p-switch>
			</div>
		</div>
		
			<div v-if="isOn()" class="config-item">
				<div class="item-label">{{$t('http-fastcgi-box@Fastcgi服务')}}</div>
				<div class="item-content">
					<div v-show="fastcgiConfigs.length > 0" class="fastcgi-list">
						<div class="ui label basic small" :class="{disabled: !fastcgi.isOn}" v-for="(fastcgi, index) in fastcgiConfigs">
							{{fastcgi.address}} &nbsp; 
							<a href="" :title="$t('http-fastcgi-box@修改')" @click.prevent="updateFastcgi(fastcgi.id, index)" class="action-button">
								<i class="pi pi-pencil small"></i>
							</a> &nbsp; 
							<a href="" :title="$t('http-fastcgi-box@删除')" @click.prevent="removeFastcgi(index)" class="action-button">
								<i class="pi pi-trash"></i>
							</a>
						</div>
					</div>
					<div class="config-item">
						<b-add-button @click="createFastcgi()"></b-add-button>
					</div>
				</div>
			</div>
	</div>
</div>`
})

Vue.component("firewall-syn-flood-config-viewer", {
	props: ["v-syn-flood-config"],
	data: function () {
		let config = this.vSynFloodConfig
		if (config == null) {
			config = {
				isOn: false,
				minAttempts: 10,
				timeoutSeconds: 600,
				ignoreLocal: true
			}
		}
		return {
			config: config
		}
	},
	template: `<div>
	<span v-if="config.isOn">
		{{$t("server_firewall-syn-flood-config-viewer@StatusEnabled_Prefix")}}<span>{{$t("server_firewall-syn-flood-config-viewer@空连接次数_WithValue", [config.minAttempts])}}</span>{{$t("server_firewall-syn-flood-config-viewer@封禁时长_WithValue", [config.timeoutSeconds])}} <span v-if="config.ignoreLocal">{{$t("server_firewall-syn-flood-config-viewer@忽略局域网访问_Suffix")}}</span>
	</span>
	<span v-else>{{$t("server_firewall-syn-flood-config-viewer@未启用")}}</span>
</div>`
})

Vue.component("http-rewrite-rule-list", {
	props: ["v-web-id", "v-rewrite-rules"],
	mounted: function () {
		setTimeout(this.sort, 1000)
	},
	data: function () {
		let rewriteRules = this.vRewriteRules
		if (rewriteRules == null) {
			rewriteRules = []
		}

		// 定义表格列
		const columns = [
			{
				title: '',
				key: 'handle',
				scopedSlots: { customRender: 'handleSlot' },
				width: '50px',
				align: 'center'
			},
			{
				title: this.$t("server_http-rewrite-rule-list@匹配规则"),
				key: 'pattern',
				scopedSlots: { customRender: 'patternSlot' },
				width: '300px'
			},
			{
				title: this.$t("server_http-rewrite-rule-list@转发目标"),
				key: 'replace',
				scopedSlots: { customRender: 'replaceSlot' },
				width: '200px'
			},
			{
				title: this.$t("server_http-rewrite-rule-list@转发方式"),
				key: 'mode',
				scopedSlots: { customRender: 'modeSlot' },
				width: '100px'
			},
			{
				title: this.$t("server_http-rewrite-rule-list@状态"),
				key: 'isOn',
				scopedSlots: { customRender: 'isOnSlot' },
				width: '100px',
				align: 'center'
			},
			{
				title: this.$t("server_http-rewrite-rule-list@操作"),
				key: 'operation',
				scopedSlots: { customRender: 'operationSlot' },
				width: '180px',
				align: 'center',
			}
		]

		return {
			rewriteRules: rewriteRules,
			columns: columns
		}
	},
	methods: {
		updateRewriteRule: function (rewriteRuleId) {
			teaweb.popup("/servers/server/settings/rewrite/updatePopup?webId=" + this.vWebId + "&rewriteRuleId=" + rewriteRuleId, {
				title: this.$t("server_http-rewrite-rule-list@修改重写规则"),
				height: "26em",
				callback: function () {
					window.location.reload()
				}
			})
		},
		deleteRewriteRule: function (rewriteRuleId) {
			let that = this
			teaweb.confirm(this.$t("server_http-rewrite-rule-list@确定要删除此重写规则吗"), function () {
				Tea.action("/servers/server/settings/rewrite/delete")
					.params({
						webId: that.vWebId,
						rewriteRuleId: rewriteRuleId
					})
					.post()
					.refresh()
			})
		},
		// 排序
		sort: function () {
			if (this.rewriteRules.length == 0) {
				return
			}
			let that = this
			sortTable(function (rowIds) {
				Tea.action("/servers/server/settings/rewrite/sort")
					.post()
					.params({
						webId: that.vWebId,
						rewriteRuleIds: rowIds
					})
					.success(function () {
						teaweb.success(that.$t("server_http-rewrite-rule-list@保存成功"))
					})
			})
		},
		// 处理拖拽排序
		handleSort: function (ids) {
			let that = this;
			Tea.action("/servers/server/settings/rewrite/sort")
				.post()
				.params({
					webId: this.vWebId,
					rewriteRuleIds: ids
				})
				.success(function () {
					teaweb.success(that.$t("server_http-rewrite-rule-list@保存成功"))
				})
		}
	},
	template: `<div>
	<div class="margin"></div>
	<p class="comment" v-if="rewriteRules.length == 0">{{ $t("server_http-rewrite-rule-list@暂时还没有重写规则") }}</p>
	<b-sortable-table
		v-if="rewriteRules.length > 0"
		:columns="columns"
		:data-source="rewriteRules"
		:row-key="'id'"
		:scroll="{ x: 1000 }"
		:on-sort="handleSort"
	>
		<template slot="handleSlot" slot-scope="{ text, record }">
			<i class="icon bars grey handle"></i>
		</template>

		<template slot="patternSlot" slot-scope="{ text, record }">
			{{record.pattern}}
			<br/>
			<http-rewrite-labels-label class="ui label tiny" v-if="record.isBreak">BREAK</http-rewrite-labels-label>
			<http-rewrite-labels-label class="ui label tiny" v-if="record.mode == 'redirect' && record.redirectStatus != 307">{{record.redirectStatus}}</http-rewrite-labels-label>
			<http-rewrite-labels-label class="ui label tiny" v-if="record.proxyHost.length > 0">Host: {{record.proxyHost}}</http-rewrite-labels-label>
		</template>

		<template slot="replaceSlot" slot-scope="{ text, record }">
			{{record.replace}}
		</template>

		<template slot="modeSlot" slot-scope="{ text, record }">
			<span v-if="record.mode == 'proxy'">{{ $t("server_http-rewrite-rule-list@隐式") }}</span>
			<span v-if="record.mode == 'redirect'">{{ $t("server_http-rewrite-rule-list@显示") }}</span>
		</template>

		<template slot="isOnSlot" slot-scope="{ text, record }">
			<label-on :v-is-on="record.isOn"></label-on>
		</template>

		<template slot="operationSlot" slot-scope="{ text, record }">
			<a-button type="link" @click.prevent="updateRewriteRule(record.id)">
				<i class="pi pi-pencil" style="font-size: 12px; padding: 4px 2px;"></i> {{ $t("server_http-rewrite-rule-list@修改") }}
			</a-button>
			<a-button type="link" @click.prevent="deleteRewriteRule(record.id)">
				<i class="pi pi-trash" style="font-size: 12px; padding: 4px 2px;"></i> {{ $t("server_http-rewrite-rule-list@删除") }}
			</a-button>
		</template>
	</b-sortable-table>
	<p class="comment" v-if="rewriteRules.length > 0">{{ $t("server_http-rewrite-rule-list@拖动左侧的") }}<i class="icon bars grey"></i>{{ $t("server_http-rewrite-rule-list@图标可以对重写规则进行排序") }}</p>

</div>`
})

// 动作选择
Vue.component("http-firewall-actions-box", {
	props: ["v-actions", "v-firewall-policy", "v-action-configs", "v-group-type"],
	mounted: function () {
		let that = this
		Tea.action("/servers/iplists/levelOptions")
			.success(function (resp) {
				that.ipListLevels = resp.data.levels
			})
			.post()

		this.loadJS(function () {
			let box = document.getElementById("actions-box")
			Sortable.create(box, {
				draggable: ".label",
				handle: ".icon.handle",
				onStart: function () {
					that.cancel()
				},
				onUpdate: function (event) {
					let labels = box.getElementsByClassName("label")
					let newConfigs = []
					for (let i = 0; i < labels.length; i++) {
						let index = parseInt(labels[i].getAttribute("data-index"))
						newConfigs.push(that.configs[index])
					}
					that.configs = newConfigs
				}
			})
		})
	},
	data: function () {
		if (this.vFirewallPolicy.inbound == null) {
			this.vFirewallPolicy.inbound = {}
		}
		if (this.vFirewallPolicy.inbound.groups == null) {
			this.vFirewallPolicy.inbound.groups = []
		}

		if (this.vFirewallPolicy.outbound == null) {
			this.vFirewallPolicy.outbound = {}
		}
		if (this.vFirewallPolicy.outbound.groups == null) {
			this.vFirewallPolicy.outbound.groups = []
		}

		let id = 0
		let configs = []
		if (this.vActionConfigs != null) {
			configs = this.vActionConfigs
			configs.forEach(function (v) {
				v.id = (id++)
			})
		}

		var defaultPageBody = `<!DOCTYPE html>
<html lang="en">
<head>
\t<title>403 Forbidden</title>
\t<style>
\t\taddress { line-height: 1.8; }
\t</style>
</head>
<body>
<h1>403 Forbidden</h1>
<address>Connection: \${remoteAddr} (Client) -&gt; \${serverAddr} (Server)</address>
<address>Request ID: \${requestId}</address>
</body>
</html>`


		return {
			id: id,

			actions: this.vActions,
			configs: configs,
			isAdding: false,
			editingIndex: -1,

			action: null,
			actionCode: "",
			actionOptions: {},

			// IPList相关
			ipListLevels: [],

			// 动作参数
			allowScope: "global",

			blockTimeout: "",
			blockTimeoutMax: "",
			blockScope: "global",

			captchaLife: "",
			captchaMaxFails: "",
			captchaFailBlockTimeout: "",

			get302Life: "",

			post307Life: "",

			recordIPType: "black",
			recordIPLevel: "critical",
			recordIPTimeout: "",
			recordIPListId: 0,
			recordIPListName: "",

			tagTags: [],

			pageUseDefault: true,
			pageStatus: 403,
			pageBody: defaultPageBody,
			defaultPageBody: defaultPageBody,

			redirectStatus: 307,
			redirectURL: "",

			goGroupName: "",
			goGroupId: 0,
			goGroup: null,

			goSetId: 0,
			goSetName: "",

			jsCookieLife: "",
			jsCookieMaxFails: "",
			jsCookieFailBlockTimeout: "",

			statusOptions: [
				{"code": 301, "text": "Moved Permanently"},
				{"code": 308, "text": "Permanent Redirect"},
				{"code": 302, "text": "Found"},
				{"code": 303, "text": "See Other"},
				{"code": 307, "text": "Temporary Redirect"}
			]
		}
	},
	watch: {
		actionCode: function (code) {
			this.action = this.actions.$find(function (k, v) {
				return v.code == code
			})
			this.actionOptions = {}
		},
		allowScope: function (v) {
			this.actionOptions["scope"] = v
		},
		blockTimeout: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["timeout"] = 0
			} else {
				this.actionOptions["timeout"] = v
			}
		},
		blockTimeoutMax: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["timeoutMax"] = 0
			} else {
				this.actionOptions["timeoutMax"] = v
			}
		},
		blockScope: function (v) {
			this.actionOptions["scope"] = v
		},
		captchaLife: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["life"] = 0
			} else {
				this.actionOptions["life"] = v
			}
		},
		captchaMaxFails: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["maxFails"] = 0
			} else {
				this.actionOptions["maxFails"] = v
			}
		},
		captchaFailBlockTimeout: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["failBlockTimeout"] = 0
			} else {
				this.actionOptions["failBlockTimeout"] = v
			}
		},
		get302Life: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["life"] = 0
			} else {
				this.actionOptions["life"] = v
			}
		},
		post307Life: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["life"] = 0
			} else {
				this.actionOptions["life"] = v
			}
		},
		recordIPType: function (v) {
			this.recordIPListId = 0
		},
		recordIPTimeout: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["timeout"] = 0
			} else {
				this.actionOptions["timeout"] = v
			}
		},
		goGroupId: function (groupId) {
			let group = this.vFirewallPolicy.inbound.groups.$find(function (k, v) {
				return v.id == groupId
			})
			this.goGroup = group
			if (group == null) {
				// search outbound groups
				group = this.vFirewallPolicy.outbound.groups.$find(function (k, v) {
					return v.id == groupId
				})
				if (group == null) {
					this.goGroupName = ""
				} else {
					this.goGroup = group
					this.goGroupName = group.name
				}
			} else {
				this.goGroupName = group.name
			}
			this.goSetId = 0
			this.goSetName = ""
		},
		goSetId: function (setId) {
			if (this.goGroup == null) {
				return
			}
			let set = this.goGroup.sets.$find(function (k, v) {
				return v.id == setId
			})
			if (set == null) {
				this.goSetId = 0
				this.goSetName = ""
			} else {
				this.goSetName = set.name
			}
		},
		jsCookieLife: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["life"] = 0
			} else {
				this.actionOptions["life"] = v
			}
		},
		jsCookieMaxFails: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["maxFails"] = 0
			} else {
				this.actionOptions["maxFails"] = v
			}
		},
		jsCookieFailBlockTimeout: function (v) {
			v = parseInt(v)
			if (isNaN(v)) {
				this.actionOptions["failBlockTimeout"] = 0
			} else {
				this.actionOptions["failBlockTimeout"] = v
			}
		},
	},
	methods: {
		add: function () {
			this.action = null
			this.actionCode = "page"
			this.isAdding = true
			this.actionOptions = {}

			// 动作参数
			this.allowScope = "global"

			this.blockTimeout = ""
			this.blockTimeoutMax = ""
			this.blockScope = "global"

			this.captchaLife = ""
			this.captchaMaxFails = ""
			this.captchaFailBlockTimeout = ""

			this.jsCookieLife = ""
			this.jsCookieMaxFails = ""
			this.jsCookieFailBlockTimeout = ""

			this.get302Life = ""

			this.post307Life = ""

			this.recordIPLevel = "critical"
			this.recordIPType = "black"
			this.recordIPTimeout = ""
			this.recordIPListId = 0
			this.recordIPListName = ""

			this.tagTags = []

			this.pageUseDefault = true
			this.pageStatus = 403
			this.pageBody = this.defaultPageBody

			this.redirectStatus = 307
			this.redirectURL = ""

			this.goGroupName = ""
			this.goGroupId = 0
			this.goGroup = null

			this.goSetId = 0
			this.goSetName = ""

			let that = this
			this.action = this.vActions.$find(function (k, v) {
				return v.code == that.actionCode
			})

			// 滚到界面底部
			this.scroll()
		},
		remove: function (index) {
			this.isAdding = false
			this.editingIndex = -1
			this.configs.$remove(index)
		},
		update: function (index, config) {
			if (this.isAdding && this.editingIndex == index) {
				this.cancel()
				return
			}

			this.add()

			this.isAdding = true
			this.editingIndex = index

			this.actionCode = config.code
			this.action = this.actions.$find(function (k, v) {
				return v.code == config.code
			})

			switch (config.code) {
				case "block":
					this.blockTimeout = ""
					this.blockTimeoutMax = ""
					if (config.options.timeout != null || config.options.timeout > 0) {
						this.blockTimeout = config.options.timeout.toString()
					}
					if (config.options.timeoutMax != null || config.options.timeoutMax > 0) {
						this.blockTimeoutMax = config.options.timeoutMax.toString()
					}
					if (config.options.scope != null && config.options.scope.length > 0) {
						this.blockScope = config.options.scope
					} else {
						this.blockScope = "global" // 兼容先前版本遗留的默认值
					}
					break
				case "allow":
					if (config.options != null && config.options.scope != null && config.options.scope.length > 0) {
						this.allowScope = config.options.scope
					} else {
						this.allowScope = "global"
					}
					break
				case "log":
					break
				case "captcha":
					this.captchaLife = ""
					if (config.options.life != null || config.options.life > 0) {
						this.captchaLife = config.options.life.toString()
					}
					this.captchaMaxFails = ""
					if (config.options.maxFails != null || config.options.maxFails > 0) {
						this.captchaMaxFails = config.options.maxFails.toString()
					}
					this.captchaFailBlockTimeout = ""
					if (config.options.failBlockTimeout != null || config.options.failBlockTimeout > 0) {
						this.captchaFailBlockTimeout = config.options.failBlockTimeout.toString()
					}
					break
				case "js_cookie":
					this.jsCookieLife = ""
					if (config.options.life != null || config.options.life > 0) {
						this.jsCookieLife = config.options.life.toString()
					}
					this.jsCookieMaxFails = ""
					if (config.options.maxFails != null || config.options.maxFails > 0) {
						this.jsCookieMaxFails = config.options.maxFails.toString()
					}
					this.jsCookieFailBlockTimeout = ""
					if (config.options.failBlockTimeout != null || config.options.failBlockTimeout > 0) {
						this.jsCookieFailBlockTimeout = config.options.failBlockTimeout.toString()
					}
					break
				case "notify":
					break
				case "get_302":
					this.get302Life = ""
					if (config.options.life != null || config.options.life > 0) {
						this.get302Life = config.options.life.toString()
					}
					break
				case "post_307":
					this.post307Life = ""
					if (config.options.life != null || config.options.life > 0) {
						this.post307Life = config.options.life.toString()
					}
					break;
				case "record_ip":
					if (config.options != null) {
						this.recordIPLevel = config.options.level
						this.recordIPType = config.options.type
						if (config.options.timeout > 0) {
							this.recordIPTimeout = config.options.timeout.toString()
						}
						let that = this

						// VUE需要在函数执行完之后才会调用watch函数，这样会导致设置的值被覆盖，所以这里使用setTimeout
						setTimeout(function () {
							that.recordIPListId = config.options.ipListId
							that.recordIPListName = config.options.ipListName
						})
					}
					break
				case "tag":
					this.tagTags = []
					if (config.options.tags != null) {
						this.tagTags = config.options.tags
					}
					break
				case "page":
					this.pageUseDefault = true
					this.pageStatus = 403
					this.pageBody = this.defaultPageBody
					if (typeof config.options.useDefault === "boolean") {
						this.pageUseDefault = config.options.useDefault
					} else {
						this.pageUseDefault = false
					}
					if (config.options.status != null) {
						this.pageStatus = config.options.status
					}
					if (config.options.body != null) {
						this.pageBody = config.options.body
					}
					break
				case "redirect":
					this.redirectStatus = 307
					this.redirectURL = ""
					if (config.options.status != null) {
						this.redirectStatus = config.options.status
					}
					if (config.options.url != null) {
						this.redirectURL = config.options.url
					}
					break
				case "go_group":
					if (config.options != null) {
						this.goGroupName = config.options.groupName
						this.goGroupId = config.options.groupId
						this.goGroup = this.vFirewallPolicy.inbound.groups.$find(function (k, v) {
							return v.id == config.options.groupId
						})
					}
					break
				case "go_set":
					if (config.options != null) {
						this.goGroupName = config.options.groupName
						this.goGroupId = config.options.groupId
						this.goGroup = this.vFirewallPolicy.inbound.groups.$find(function (k, v) {
							return v.id == config.options.groupId
						})

						// VUE需要在函数执行完之后才会调用watch函数，这样会导致设置的值被覆盖，所以这里使用setTimeout
						let that = this
						setTimeout(function () {
							that.goSetId = config.options.setId
							if (that.goGroup != null) {
								let set = that.goGroup.sets.$find(function (k, v) {
									return v.id == config.options.setId
								})
								if (set != null) {
									that.goSetName = set.name
								}
							}
						})
					}
					break
			}

			// 滚到界面底部
			this.scroll()
		},
		cancel: function () {
			this.isAdding = false
			this.editingIndex = -1
		},
		confirm: function () {
			if (this.action == null) {
				return
			}

			if (this.actionOptions == null) {
				this.actionOptions = {}
			}

			// record_ip
			if (this.actionCode == "record_ip") {
				let timeout = parseInt(this.recordIPTimeout)
				if (isNaN(timeout)) {
					timeout = 0
				}
				if (this.recordIPListId < 0) {
					return
				}

				// recordIPListId can be 0

				this.actionOptions = {
					type: this.recordIPType,
					level: this.recordIPLevel,
					timeout: timeout,
					ipListId: this.recordIPListId,
					ipListName: this.recordIPListName
				}
			} else if (this.actionCode == "tag") { // tag
				if (this.tagTags == null || this.tagTags.length == 0) {
					return
				}
				this.actionOptions = {
					tags: this.tagTags
				}
			} else if (this.actionCode == "page") {
				let pageStatus = this.pageStatus.toString()
				if (!pageStatus.match(/^\d{3}$/)) {
					pageStatus = 403
				} else {
					pageStatus = parseInt(pageStatus)
				}

				this.actionOptions = {
					useDefault: this.pageUseDefault,
					status: pageStatus,
					body: this.pageBody
				}
			} else if (this.actionCode == "redirect") {
				let redirectStatus = this.redirectStatus.toString()
				if (!redirectStatus.match(/^\d{3}$/)) {
					redirectStatus = 307
				} else {
					redirectStatus = parseInt(redirectStatus)
				}

				if (this.redirectURL.length == 0) {
					teaweb.warn(this.$t("server_http-firewall-actions-box@请输入跳转到URL"))
					return
				}

				this.actionOptions = {
					status: redirectStatus,
					url: this.redirectURL
				}
			} else if (this.actionCode == "go_group") { // go_group
				let groupId = this.goGroupId
				if (typeof (groupId) == "string") {
					groupId = parseInt(groupId)
					if (isNaN(groupId)) {
						groupId = 0
					}
				}
				if (groupId <= 0) {
					return
				}
				this.actionOptions = {
					groupId: groupId.toString(),
					groupName: this.goGroupName
				}
			} else if (this.actionCode == "go_set") { // go_set
				let groupId = this.goGroupId
				if (typeof (groupId) == "string") {
					groupId = parseInt(groupId)
					if (isNaN(groupId)) {
						groupId = 0
					}
				}

				let setId = this.goSetId
				if (typeof (setId) == "string") {
					setId = parseInt(setId)
					if (isNaN(setId)) {
						setId = 0
					}
				}
				if (setId <= 0) {
					return
				}
				this.actionOptions = {
					groupId: groupId.toString(),
					groupName: this.goGroupName,
					setId: setId.toString(),
					setName: this.goSetName
				}
			}

			let options = {}
			for (let k in this.actionOptions) {
				if (this.actionOptions.hasOwnProperty(k)) {
					options[k] = this.actionOptions[k]
				}
			}
			if (this.editingIndex > -1) {
				this.configs[this.editingIndex] = {
					id: this.configs[this.editingIndex].id,
					code: this.actionCode,
					name: this.action.name,
					options: options
				}
			} else {
				this.configs.push({
					id: (this.id++),
					code: this.actionCode,
					name: this.action.name,
					options: options
				})
			}

			this.cancel()
		},
		removeRecordIPList: function () {
			this.recordIPListId = 0
		},
		selectRecordIPList: function () {
			let that = this
			teaweb.popup("/servers/iplists/selectPopup?type=" + this.recordIPType, {
				title: this.$t("server_http-firewall-actions-box@选择公用IP名单"),
				width: "50em",
				height: "30em",
				callback: function (resp) {
					that.recordIPListId = resp.data.list.id
					that.recordIPListName = resp.data.list.name
				}
			})
		},
		changeTags: function (tags) {
			this.tagTags = tags
		},
		loadJS: function (callback) {
			if (typeof Sortable != "undefined") {
				callback()
				return
			}

			// 引入js
			let jsFile = document.createElement("script")
			jsFile.setAttribute("src", "/js/sortable.min.js")
			jsFile.addEventListener("load", function () {
				callback()
			})
			document.head.appendChild(jsFile)
		},
		scroll: function () {
			setTimeout(function () {
				let mainDiv = document.getElementsByClassName("main")
				if (mainDiv.length > 0) {
					mainDiv[0].scrollTo(0, 1000)
				}
			}, 10)
		}
	},
	template: `<div>
	<input type="hidden" name="actionsJSON" :value="JSON.stringify(configs)"/>
	<div v-show="configs.length > 0" style="margin-bottom: 0.5em" id="actions-box"> 
		<div v-for="(config, index) in configs" :data-index="index" :key="config.id" class="ui label small basic" :class="{blue: index == editingIndex}" style="margin-bottom: 0.4em">
			{{config.name}} <span class="small">({{config.code.toUpperCase()}})</span> 
			
			<!-- allow -->
			<span class="small" v-if="config.code == 'allow' && config.options != null && config.options.scope != null && config.options.scope.length > 0">
				<span v-if="config.options.scope == 'group'">[{{$t("server_http-firewall-actions-box@分组")}}]</span>
				<span v-if="config.options.scope == 'server'">[{{$t("server_http-firewall-actions-box@网站")}}]</span>
				<span v-if="config.options.scope == 'global'">[{{$t("server_http-firewall-actions-box@网站和策略")}}]</span>
			</span>
			
			<!-- block -->
			<span v-if="config.code == 'block' && config.options.timeout > 0">：{{$t("server_http-firewall-actions-box@封禁时长")[0]}}{{config.options.timeout}}<span v-if="config.options.timeoutMax > config.options.timeout">-{{config.options.timeoutMax}}</span>{{$t("server_http-firewall-actions-box@秒")}}</span>
			
			<!-- captcha -->
			<span v-if="config.code == 'captcha' && config.options.life > 0">：{{$t("server_http-firewall-actions-box@有效期")}}{{config.options.life}}{{$t("server_http-firewall-actions-box@秒")}}
				<span v-if="config.options.maxFails > 0"> / {{$t("server_http-firewall-actions-box@最多失败")}}{{config.options.maxFails}}{{$t("server_http-firewall-actions-box@次")}}</span>
			</span>
			
			<!-- js cookie -->
			<span v-if="config.code == 'js_cookie' && config.options.life > 0">：{{$t("server_http-firewall-actions-box@有效期")}}{{config.options.life}}{{$t("server_http-firewall-actions-box@秒")}}
				<span v-if="config.options.maxFails > 0"> / {{$t("server_http-firewall-actions-box@最多失败")}}{{config.options.maxFails}}{{$t("server_http-firewall-actions-box@次")}}</span>
			</span>
			
			<!-- get 302 -->
			<span v-if="config.code == 'get_302' && config.options.life > 0">：{{$t("server_http-firewall-actions-box@有效期")}}{{config.options.life}}{{$t("server_http-firewall-actions-box@秒")}}</span>
			
			<!-- post 307 -->
			<span v-if="config.code == 'post_307' && config.options.life > 0">：{{$t("server_http-firewall-actions-box@有效期")}}{{config.options.life}}{{$t("server_http-firewall-actions-box@秒")}}</span>
			
			<!-- record_ip -->
			<span v-if="config.code == 'record_ip'">：<span :class="{red: config.options.ipListIsDeleted}">{{config.options.ipListName}}</span></span>
			
			<!-- tag -->
			<span v-if="config.code == 'tag'">：{{config.options.tags.join(", ")}}</span>
			
			<!-- page -->
			<span v-if="config.code == 'page'">：[{{config.options.status}}]<span v-if="config.options.useDefault">&nbsp; [{{$t("server_http-firewall-actions-box@默认页面")}}]</span></span>
			
			<!-- redirect -->
			<span v-if="config.code == 'redirect'">：{{config.options.url}}</span>
			
			<!-- go_group -->
			<span v-if="config.code == 'go_group'">：{{config.options.groupName}}</span>
			
			<!-- go_set -->
			<span v-if="config.code == 'go_set'">：{{config.options.groupName}} / {{config.options.setName}}</span>
			
			<!-- 范围 -->
			<span v-if="config.code != 'allow' && config.options.scope != null && config.options.scope.length > 0" class="small grey">
				&nbsp; 
				<span v-if="config.options.scope == 'global'">[{{$t("server_http-firewall-actions-box@所有网站")}}]</span>
				<span v-if="config.options.scope == 'service'">[{{$t("server_http-firewall-actions-box@当前网站")}}]</span>
			</span>
			
			<!-- 操作按钮 -->
			 &nbsp; <a href="" :title="$t('server_http-firewall-actions-box@修改')" @click.prevent="update(index, config)"><i class="icon pencil small"></i></a> &nbsp; <a href="" :title="$t('server_http-firewall-actions-box@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a> &nbsp; <a href="" :title="$t('server_http-firewall-actions-box@拖动改变顺序')"><i class="icon bars handle"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div style="margin-bottom: 0.5em" v-if="isAdding">
		<table class="ui table" :class="{blue: editingIndex > -1}">
			<tr>
				<td class="title">{{$t("server_http-firewall-actions-box@动作类型*")}}</td>
				<td>
					<b-select
						v-model="actionCode"
						auto-width
						:options="[
							...actions.map(action => ({
								label: (action.name??'') + '（' + (action.code?action.code.toUpperCase():'') + '）',
								value: action.code??'',
							}))
						]"
					></b-select>
					<p class="comment" v-if="action != null && action.description.length > 0">{{action.description}}</p>
				</td>
			</tr>
			
			<!-- allow -->
			<tr v-if="actionCode == 'allow'">
				<td>{{$t("server_http-firewall-actions-box@有效范围")}}</td>
				<td>
					<b-select
						v-model="allowScope"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@分组'), value: 'group'},
							{label: $t('server_http-firewall-actions-box@网站'), value: 'server'},
							{label: $t('server_http-firewall-actions-box@网站和策略'), value: 'global'},
						]"
					></b-select>
					<p class="comment" v-if="allowScope == 'group'">{{$t("server_http-firewall-actions-box@跳过当前分组其他规则集")}}</p>
					<p class="comment" v-if="allowScope == 'server'">{{$t("server_http-firewall-actions-box@跳过当前网站所有的规则集")}}</p>
					<p class="comment" v-if="allowScope =='global'">{{$t("server_http-firewall-actions-box@跳过当前网站和网站对应WAF策略所有的规则集")}}</p>
				</td>
			</tr>
			
			<!-- block -->
			<tr v-if="actionCode == 'block'">
				<td>{{$t("server_http-firewall-actions-box@封禁范围")}}</td>
				<td>
					<b-select
						v-model="blockScope"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@当前网站'), value: 'service'},
							{label: $t('server_http-firewall-actions-box@所有网站'), value: 'global'},
						]"
					></b-select>

					<p class="comment" v-if="blockScope == 'service'">{{$t("server_http-firewall-actions-box@只封禁用户对当前网站的访问")}}</p>
					<p class="comment" v-if="blockScope =='global'">{{$t("server_http-firewall-actions-box@封禁用户对所有网站的访问")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'block'">
				<td>{{$t("server_http-firewall-actions-box@封禁时长")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="blockTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
				</td>
			</tr>
			<tr v-if="actionCode == 'block'">
				<td>{{$t("server_http-firewall-actions-box@最大封禁时长")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="blockTimeoutMax" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@最大封禁时长Help")}}</p>
				</td>
			</tr>
			
			<!-- captcha -->
			<tr v-if="actionCode == 'captcha'">
				<td>{{$t("server_http-firewall-actions-box@有效时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="captchaLife" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@验证通过后在这个时间内不再验证默认")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'captcha'">
				<td>{{$t("server_http-firewall-actions-box@最多失败次数")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="captchaMaxFails" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@次")}}</span>
					</div>
					<p class="comment"><span v-if="captchaMaxFails > 0 && captchaMaxFails < 5" class="red">{{$t("server_http-firewall-actions-box@建议填入一个不小于5的数字")}}</span>{{$t("server_http-firewall-actions-box@最多失败次数Help")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'captcha'">
				<td>{{$t("server_http-firewall-actions-box@失败拦截时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="captchaFailBlockTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@失败拦截时间Help")}}</p>
				</td>
			</tr>
			
			<!-- js cookie -->
			<tr v-if="actionCode == 'js_cookie'">
				<td>{{$t("server_http-firewall-actions-box@有效时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="jsCookieLife" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@验证通过后在这个时间内不再验证默认")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'js_cookie'">
				<td>{{$t("server_http-firewall-actions-box@最多失败次数")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="jsCookieMaxFails" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@次")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@最多失败次数Help")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'js_cookie'">
				<td>{{$t("server_http-firewall-actions-box@失败拦截时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="jsCookieFailBlockTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@失败拦截时间Help")}}</p>
				</td>
			</tr>
			
			<!-- get_302 -->
			<tr v-if="actionCode == 'get_302'">
				<td>{{$t("server_http-firewall-actions-box@有效时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="get302Life" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@验证通过后在这个时间内不再验证")}}</p>
				</td>
			</tr>
			
			<!-- post_307 -->
			<tr v-if="actionCode == 'post_307'">
				<td>{{$t("server_http-firewall-actions-box@有效时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 5em" maxlength="9" v-model="post307Life" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@验证通过后在这个时间内不再验证")}}</p>
				</td>
			</tr>
			
			<!-- record_ip -->
			<tr v-if="actionCode == 'record_ip'">
				<td>{{$t("server_http-firewall-actions-box@IP名单类型*")}}</td>
				<td>
					<b-select
						v-model="recordIPType"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@黑名单'), value: 'black'},
							{label: $t('server_http-firewall-actions-box@白名单'), value: 'white'},
							{label: $t('server_http-firewall-actions-box@灰名单'), value: 'grey'},
						]"
					></b-select>
				</td>
			</tr>
			<tr v-if="actionCode == 'record_ip'">
				<td>{{$t("server_http-firewall-actions-box@选择IP名单")}}</td>
				<td>
					<div v-if="recordIPListId > 0" class="ui label basic small">{{recordIPListName}} <a href="" @click.prevent="removeRecordIPList"><i class="pi pi-times"></i></a></div>
					<b-add-button @click="selectRecordIPList"></b-add-button>
					<p class="comment">{{$t("server_http-firewall-actions-box@选择IP名单Help")}}</p>
				</td>
			</tr>
			<tr v-if="actionCode == 'record_ip'">
				<td>{{$t("server_http-firewall-actions-box@级别")}}</td>
				<td>
					<b-select
						v-model="recordIPLevel"
						auto-width
						:options="[
							...ipListLevels.map(level => ({
								label: level.name??'',
								value: level.code??'',
							}))
						]"
					></b-select>
				</td>
			</tr>
			<tr v-if="actionCode == 'record_ip'">
				<td>{{$t("server_http-firewall-actions-box@超时时间")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 6em" maxlength="9" v-model="recordIPTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
						<span class="ui label">{{$t("server_http-firewall-actions-box@秒")}}</span>
					</div>
					<p class="comment">{{$t("server_http-firewall-actions-box@超时时间Help")}}</p>
				</td>
			</tr>
			
			<!-- tag -->
			<tr v-if="actionCode == 'tag'">
				<td>{{$t("server_http-firewall-actions-box@标签*")}}</td>
				<td>
					<values-box @change="changeTags" :values="tagTags"></values-box>
				</td>
			</tr>
			
			<!-- page -->
			<tr v-if="actionCode == 'page'">
				<td>{{$t("server_http-firewall-actions-box@使用默认提示")}}</td>
				<td>
					<checkbox :v-value="1" v-model="pageUseDefault"></checkbox>
				</td>
			</tr>
			<tr v-if="actionCode == 'page' && !pageUseDefault">
				<td class="color-border">{{$t("server_http-firewall-actions-box@状态码*")}}</td>
				<td><input type="text" style="width: 4em" maxlength="3" v-model="pageStatus"/></td>
			</tr>
			<tr v-if="actionCode == 'page' && !pageUseDefault">
				<td class="color-border">{{$t("server_http-firewall-actions-box@网页内容")}}</td>
				<td>
					<textarea v-model="pageBody"></textarea>
				</td>
			</tr>
			
			<!-- redirect -->
			<tr v-if="actionCode == 'redirect'">
				<td>{{$t("server_http-firewall-actions-box@状态码*")}}</td>
				<td>
					<b-select
						v-model="redirectStatus"
						auto-width
						:options="[
							...statusOptions.map(status => ({
								label: (status.code??'') + '（' + (status.text??'') + '）',
								value: status.code??'',
							}))
						]"
					></b-select>
				</td>
			</tr>
			<tr v-if="actionCode == 'redirect'">
				<td>{{$t("server_http-firewall-actions-box@跳转到URL")}}</td>
				<td>
					<input type="text" v-model="redirectURL"/>
				</td>
			</tr>
			
			<!-- 规则分组 -->
			<tr v-if="actionCode == 'go_group'">
				<td>{{$t("server_http-firewall-actions-box@下一个分组*")}}</td>
				<td>
					<b-select
						v-model="goGroupId"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@选择分组'), value: '0'},
							...vFirewallPolicy.inbound != null && vFirewallPolicy.inbound.groups != null ? vFirewallPolicy.inbound.groups.map(group => ({
								label: $t('server_http-firewall-actions-box@入站Colon') + (group.name??''),
								value: (group.id??''),
							})): [],
							...vGroupType == 'outbound' && vFirewallPolicy.outbound != null && vFirewallPolicy.outbound.groups != null ? vFirewallPolicy.outbound.groups.map(group => ({
								label: $t('server_http-firewall-actions-box@出站Colon') + (group.name??''),
								value: group.id??'',
							})) : [],
						]"
					></b-select>
				</td>
			</tr>
			
			<!-- 规则集 -->
			<tr v-if="actionCode == 'go_set'">
				<td>{{$t("server_http-firewall-actions-box@下一个分组*")}}</td>
				<td>
					<b-select
						v-model="goGroupId"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@选择分组'), value: '0'},
							...vFirewallPolicy.inbound != null && vFirewallPolicy.inbound.groups != null ? vFirewallPolicy.inbound.groups.map(group => ({
								label: $t('server_http-firewall-actions-box@入站Colon') + (group.name??''),
								value: group.id??'',
							})): [],
							...vGroupType == 'outbound' && vFirewallPolicy.outbound != null && vFirewallPolicy.outbound.groups != null ? vFirewallPolicy.outbound.groups.map(group => ({
								label: $t('server_http-firewall-actions-box@出站Colon') + (group.name??''),
								value: group.id??'',
							})) : [],
						]"
					></b-select>
				</td>
			</tr>
			<tr v-if="actionCode == 'go_set' && goGroup != null">
				<td>{{$t("server_http-firewall-actions-box@下一个规则集*")}}</td>
				<td>
					<b-select
						v-model="goSetId"
						auto-width
						:options="[
							{label: $t('server_http-firewall-actions-box@选择规则集'), value: '0'},
							...goGroup.sets.map(set => ({
								label: set.name??'',
								value: set.id??'',
							}))
						]"
					></b-select>
				</td>
			</tr>
		</table>
		<button class="ui button tiny" type="button" @click.prevent="confirm">{{$t("server_http-firewall-actions-box@确定")}}</button> &nbsp;
		<a href="" @click.prevent="cancel" :title="$t('server_http-firewall-actions-box@取消')"><i class="pi pi-times"></i></a>
	</div>
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
	<p class="comment">{{$t("server_http-firewall-actions-box@动作提示信息")}}</p>
</div>`
})

Vue.component("http-cache-stale-config", {
	props: ["v-cache-stale-config"],
	data: function () {
		let config = this.vCacheStaleConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				status: [],
				supportStaleIfErrorHeader: true,
				life: {
					count: 1,
					unit: "day"
				}
			}
		}
		return {
			config: config
		}
	},
	watch: {
		config: {
			deep: true,
			handler: function () {
				this.$emit("change", this.config)
			}
		}
	},
	methods: {},
	template: `<table class="ui table definition selectable">
	<tbody>
		<tr>
			<td class="title">{{$t("http-cache-stale-config@启用过时缓存")}}</td>
			<td>
				<checkbox :v-value="1" v-model="config.isOn"></checkbox>
				<p class="comment"><plus-label></plus-label>{{$t("http-cache-stale-config@选中后在更新缓存失败后会尝试读取过时的缓存")}}</p>
			</td>
		</tr>
		<tr v-show="config.isOn">
			<td>{{$t("http-cache-stale-config@有效期")}}</td>
			<td>
				<time-duration-box :v-value="config.life"></time-duration-box>
				<p class="comment">{{$t("http-cache-stale-config@缓存在过期之后仍然保留的时间")}}</p>
			</td>
		</tr>
		<tr v-show="config.isOn">
			<td>{{$t("http-cache-stale-config@状态码")}}</td>
			<td><http-status-box :v-status-list="config.status"></http-status-box>
				<p class="comment">{{$t("http-cache-stale-config@在这些状态码出现时使用过时缓存默认支持")}}<code-label>50x</code-label>{{$t("http-cache-stale-config@状态码")}}</p>
			</td>
		</tr>
		<tr v-show="config.isOn">
			<td>{{$t("http-cache-stale-config@支持staleiferror")}}</td>
			<td>
				<checkbox :v-value="1" v-model="config.supportStaleIfErrorHeader"></checkbox>
				<p class="comment">{{$t("http-cache-stale-config@选中后支持在CacheControl中通过")}}<code-label>stale-if-error</code-label>{{$t("http-cache-stale-config@指定过时缓存有效期")}}</p>
			</td>
		</tr>
	</tbody>
</table>`
})

// 请求方法列表
Vue.component("http-methods-box", {
	props: ["v-methods"],
	data: function () {
		let methods = this.vMethods
		if (methods == null) {
			methods = []
		}
		return {
			methods: methods,
			isAdding: false,
			addingMethod: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingMethod.focus()
			}, 100)
		},
		confirm: function () {
			let that = this

			// 删除其中的空格
			this.addingMethod = this.addingMethod.replace(/\s/g, "").toUpperCase()

			if (this.addingMethod.length == 0) {
				teaweb.warn(this.$t("server_http-methods-box@请输入要添加的请求方法"), function () {
					that.$refs.addingMethod.focus()
				})
				return
			}

			// 是否已经存在
			if (this.methods.$contains(this.addingMethod)) {
				teaweb.warn(this.$t("server_http-methods-box@此请求方法已经存在无需重复添加"), function () {
					that.$refs.addingMethod.focus()
				})
				return
			}

			this.methods.push(this.addingMethod)
			this.cancel()
		},
		remove: function (index) {
			this.methods.$remove(index)
		},
		cancel: function () {
			this.isAdding = false
			this.addingMethod = ""
		}
	},
	template: `<div>
	<input type="hidden" name="methodsJSON" :value="JSON.stringify(methods)"/>
	<div v-if="methods.length > 0">
		<span class="ui label small basic" v-for="(method, index) in methods">
			{{method}}
			&nbsp; <a href="" :title="$t('server_http-methods-box@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</span>
		<div class="ui divider"></div>
	</div>
	<div v-if="isAdding">
		<div class="ui fields">
			<div class="ui field">
				<input type="text" v-model="addingMethod" @keyup.enter="confirm()" @keypress.enter.prevent="1" ref="addingMethod" :placeholder="$t('server_http-methods-box@如GET')" size="10"/>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{ $t("server_http-methods-box@确定") }}</button>
				&nbsp; <a href="" :title="$t('server_http-methods-box@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<p class="comment">{{ $t("server_http-methods-box@格式为大写比如") }}<code-label>GET</code-label>、<code-label>POST</code-label>{{ $t("server_http-methods-box@等") }}</p>
		<div class="ui divider"></div>
	</div>
	<div style="margin-top: 0.5em" v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

// HTTP CC防护配置
Vue.component("defense-config-box", {
	props: ["v-defense-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vDefenseConfig
		if (config == null) {
			config = {
				isOn: false,
				records: [{
					enable: false,
					riskTags: [],
					riskLevel: 0,
				}]
			}
		}
		if (config.records == null) {
			config.records = []
		}
		let riskTags = [
			{
				id: 1,
				name: this.$t('defense-config-box@代理'),
				isChecked: false
			},
			{
				id: 2,
				name: "Tor",
				isChecked: false
			},
			{
				id: 3,
				name: "VPN",
				isChecked: false
			},
			{
				id: 4,
				name: this.$t('defense-config-box@扫描'),
				isChecked: false
			},
			{
				id: 5,
				name: "IDC",
				isChecked: false
			},
			{
				id: 6,
				name: this.$t('defense-config-box@暴力破解'),
				isChecked: false
			},
			{
				id: 7,
				name: this.$t('defense-config-box@秒拨'),
				isChecked: false
			},
		]
		let riskLevels = [this.$t('defense-config-box@未选中'), this.$t('defense-config-box@低风险'), this.$t('defense-config-box@中风险'), this.$t('defense-config-box@高风险')]
		let riskActions = [{ id: 1, name: this.$t('defense-config-box@5秒盾') }, { id: 2, name: this.$t('defense-config-box@无感验证') }, { id: 3, name: this.$t('defense-config-box@验证码') }, { id: 4, name: this.$t('defense-config-box@封禁') }]

		// 定义表格列
		const columns = [
			{
				title: this.$t('defense-config-box@风险标签'),
				key: 'riskTags',
				scopedSlots: { customRender: 'riskTagsSlot' },
				width: '200px'
			},
			{
				title: this.$t('defense-config-box@风险等级'),
				key: 'riskLevel',
				scopedSlots: { customRender: 'riskLevelSlot' },
				width: '120px'
			},
			{
				title: this.$t('defense-config-box@风险评分'),
				key: 'riskScore',
				scopedSlots: { customRender: 'riskScoreSlot' },
				width: '120px'
			},
			{
				title: this.$t('defense-config-box@处理动作'),
				key: 'action',
				scopedSlots: { customRender: 'actionSlot' },
				width: '120px'
			},
			{
				title: this.$t('defense-config-box@观察模式'),
				key: 'recordOnly',
				scopedSlots: { customRender: 'recordOnlySlot' },
				width: '120px'
			},
			{
				title: this.$t('defense-config-box@操作'),
				key: 'operation',
				scopedSlots: { customRender: 'operationSlot' },
				width: '80px',
				align: 'center'
			}
		]

		return {
			isAdding: false,
			addRecord: {
				enable: true,
				riskLevel: 0,
				riskTags: [],
				recordOnly: false,
				action: 1,
			},
			config: config,
			riskTags: riskTags,
			riskLevels: riskLevels,
			riskActions: riskActions,
			columns: columns
		}
	},
	watch: {
	},
	methods: {
		add: function () {
			this.isAdding = true
		},
		save: function () {
			this.config.records.push(this.addRecord)
			this.cancel()
			this.submit()
		},
		remove: function (index) {
			let that = this
			teaweb.confirm(this.$t('defense-config-box@确定要删除此条规则吗'), function () {
				that.config.records.$remove(index)
				that.submit()
			})
		},
		cancel: function () {
			this.isAdding = false
			this.riskTags.forEach(function (v) {
				v.isChecked = false
			})
			this.addRecord = {
				enable: true,
				riskLevel: 0,
				riskTags: [],
				recordOnly: false,
				action: 1,
			}
		},
		changeRiskTag: function () {
			this.addRecord.riskTags = this.riskTags.filter(function (v) {
				return v.isChecked
			}).map(function (v) {
				return v.id
			})
		},
		changeRiskScore: function (event) {
			const value = parseInt(event.target.value, 10);
			if (value >= 0 && value <= 100) {
				this.addRecord.riskScore = value;
			} else {
				event.target.value = this.addRecord.riskScore;
			}
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div>
<input type="hidden" name="defenseJSON" :value="JSON.stringify(config)"/>

<div class="config-section">
	<div class="section-title">
		<i class="icon shield"></i>
		<span>{{$t('defense-config-box@基本设置')}}</span>
	</div>
	
	<div class="config-item">
		<div class="item-label">{{$t('defense-config-box@启用主动防御')}}</div>
		<div class="item-content">
			<p-switch v-model="config.isOn" binary @change="submit"></p-switch> 
			<p class="comment"><plus-label></plus-label>{{$t('defense-config-box@启用主动防御提示')}}</p>
		</div>
	</div>
</div>

<div class="config-section" v-if="config.isOn">
	<div class="section-title">
		<i class="icon list"></i>
		<span>{{$t('defense-config-box@规则列表')}}</span>
	</div>
	
	<div class="config-item" v-if="config.records && config.records.length > 0">
		<div class="item-label"></div>
		<div class="item-content">
			<b-table
				:columns="columns"
				:data-source="config.records"
				:row-key="(record, index) => index"
				:scroll="{ x: 800 }"
				size="middle"
			>
				<template slot="riskTagsSlot" slot-scope="{ text, record }">
					<div v-for="tag in riskTags" :key="tag.id" v-if="record.riskTags.$contains(tag.id)">
						{{tag.name}}
					</div>
				</template>

				<template slot="riskLevelSlot" slot-scope="{ text, record }">
					{{riskLevels[record.riskLevel]}}
				</template>

				<template slot="riskScoreSlot" slot-scope="{ text, record }">
					{{record.riskScore||0}}
				</template>

				<template slot="actionSlot" slot-scope="{ text, record }">
					{{riskActions[record.action-1].name}}
				</template>

				<template slot="recordOnlySlot" slot-scope="{ text, record }">
					{{record.recordOnly ? $t('defense-config-box@是') : $t('defense-config-box@否')}}
				</template>

				<template slot="operationSlot" slot-scope="{ text, record, index }">
					<a href="" @click.prevent="remove(index)" :title="$t('defense-config-box@删除')">
						<i class="pi pi-trash" style="font-size: 12px; padding: 4px;"></i>
					</a>
				</template>
			</b-table>
		</div>
	</div>
	
	<div class="config-item" v-if="isAdding">
		<div class="item-label"></div>
		<div class="item-content">
			<div style="background: var(--color-panel); border: 1px solid var(--color-border); border-radius: 6px; padding: 1em; margin-bottom: 1em;">
				<div class="section-title" style="font-size: 14px; margin-bottom: 1em;">
					<i class="icon plus"></i>
					<span>{{$t('defense-config-box@添加规则')}}</span>
				</div>
				
				<div style="margin-bottom: 1.5em;">
					<div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险标签')}}</div>
					<div style="display: flex; flex-wrap: wrap; gap: 1em;">
						<div v-for="tag in riskTags" :key="tag.id" style="width: 8em; margin-bottom: 0.8em;">
							<p-checkbox :id="tag.id" v-model="tag.isChecked" @change="changeRiskTag" binary></p-checkbox>
							<label :for="tag.id" style="margin-left: 0.3em;">{{tag.name}}</label>
						</div>
					</div>
					<p class="comment">{{$t('defense-config-box@风险标签提示')}}</p>
				</div>
				
				<div style="margin-bottom: 1.5em;">
					<div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险等级')}}</div>
					<div>
						<b-select v-model="addRecord.riskLevel" :options="riskLevels.map((level,idx) => ({label: level, value: idx}))"></b-select>
						<p class="comment">{{$t('defense-config-box@风险等级提示')}}</p>
					</div>
				</div>
				
				<div style="margin-bottom: 1.5em;">
					<div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@风险评分')}}</div>
					<div>
						<div class="ui input right labeled">
							<input type="number" max="100" min="0" style="width: 6em" :value="addRecord.riskScore" @input="changeRiskScore"/>
							<span class="ui label">{{$t('defense-config-box@取值区间0-100')}}</span>
						</div>
						<p class="comment">{{$t('defense-config-box@风险评分提示')}}</p>
					</div>
				</div>
				
				<div style="margin-bottom: 1.5em;">
					<div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@处理动作')}}</div>
					<div style="display: flex; gap: 0.8em;">
						<div v-for="act in riskActions" style="margin-bottom: 0.5em; display: flex; align-items: center;">
							<radio name="action" :id="'action-' + act.id" v-model="addRecord.action" :v-value="act.id"></radio>
							<label :for="'action-' + act.id" style="margin-left: 0.3em;">{{act.name}}</label>
						</div>
					</div>
					<p class="comment">{{$t('defense-config-box@处理动作提示')}}</p>
				</div>
				
				<div style="margin-bottom: 1.5em;">
					<div style="font-weight: 500; margin-bottom: 0.5em;">{{$t('defense-config-box@观察模式')}}</div>
					<div>
						<p-checkbox v-model="addRecord.recordOnly" binary></p-checkbox>
						<span style="margin-left: 0.3em;">{{$t('defense-config-box@启用观察模式')}}</span>
						<p class="comment">{{$t('defense-config-box@观察模式提示')}}</p>
					</div>
				</div>
				
				<div style="margin-top: 1.5em;">
					<button type="button" class="ui button tiny" @click.prevent="save">{{$t('defense-config-box@保存')}}</button> &nbsp; 
					<a href="" @click.prevent="cancel" :title="$t('defense-config-box@取消')"><i class="icon remove small"></i></a>
				</div>
			</div>
		</div>
	</div>
	
	<div class="config-item" v-show="!isAdding">
		<div class="item-label"></div>
		<div class="item-content">
			<button class="ui button tiny" type="button" @click.prevent="add">{{$t('defense-config-box@添加规则')}}</button>
		</div>
	</div>
</div>
</div>`
})

Vue.component("http-header-replace-values", {
	props: ["v-replace-values"],
	data: function () {
		let values = this.vReplaceValues
		if (values == null) {
			values = []
		}
		return {
			values: values,
			isAdding: false,
			addingValue: {"pattern": "", "replacement": "", "isCaseInsensitive": false, "isRegexp": false}
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.pattern.focus()
			})
		},
		remove: function (index) {
			this.values.$remove(index)
		},
		confirm: function () {
			let that = this
			if (this.addingValue.pattern.length == 0) {
				teaweb.warn(this.$t("server_http-header-replace-values@替换前内容不能为空"), function () {
					that.$refs.pattern.focus()
				})
				return
			}

			this.values.push(this.addingValue)
			this.cancel()
		},
		cancel: function () {
			this.isAdding = false
			this.addingValue = {"pattern": "", "replacement": "", "isCaseInsensitive": false, "isRegexp": false}
		}
	},
	template: `<div>
	<input type="hidden" name="replaceValuesJSON" :value="JSON.stringify(values)"/>
	<div>
		<div v-for="(value, index) in values" class="ui label small" style="margin-bottom: 0.5em">
			<var>{{value.pattern}}</var><sup v-if="value.isCaseInsensitive" :title="$t('server_http-header-replace-values@不区分大小写')"><i class="icon info tiny"></i></sup> =&gt; <var v-if="value.replacement.length > 0">{{value.replacement}}</var><var v-else><span class="small grey">{{ $t("server_http-header-replace-values@空") }}</span></var>
			<a href="" @click.prevent="remove(index)" :title="$t('server_http-header-replace-values@删除')"><i class="pi pi-times"></i></a>
		</div>
	</div>
	<div v-if="isAdding">
		<table class="ui table">
			<tr>
				<td class="title">{{ $t("server_http-header-replace-values@替换前内容*") }}</td>
				<td><input type="text" v-model="addingValue.pattern" :placeholder="$t('server_http-header-replace-values@替换前内容')" ref="pattern" @keyup.enter="confirm()" @keypress.enter.prevent="1"/></td>
			</tr>	
			<tr>
				<td>{{ $t("server_http-header-replace-values@替换后内容") }}</td>
				<td><input type="text" v-model="addingValue.replacement" :placeholder="$t('server_http-header-replace-values@替换后内容')" @keyup.enter="confirm()" @keypress.enter.prevent="1"/></td>
			</tr>
			<tr>
				<td>{{ $t("server_http-header-replace-values@是否忽略大小写") }}</td>
				<td>
					<checkbox :v-value="1" v-model="addingValue.isCaseInsensitive"></checkbox>
				</td>
			</tr>
		</table>

		<div>
			<button type="button" class="ui button tiny" @click.prevent="confirm">{{ $t("server_http-header-replace-values@确定") }}</button> &nbsp;
			<a href="" :title="$t('server_http-header-replace-values@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
		</div>
	</div>
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("firewall-syn-flood-config-box", {
	props: ["v-syn-flood-config"],
	data: function () {
		let config = this.vSynFloodConfig
		if (config == null) {
			config = {
				isOn: false,
				minAttempts: 10,
				timeoutSeconds: 600,
				ignoreLocal: true
			}
		}
		return {
			config: config,
			isEditing: false,
			minAttempts: config.minAttempts,
			timeoutSeconds: config.timeoutSeconds
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		}
	},
	watch: {
		minAttempts: function (v) {
			let count = parseInt(v)
			if (isNaN(count)) {
				count = 10
			}
			if (count < 5) {
				count = 5
			}
			this.config.minAttempts = count
		},
		timeoutSeconds: function (v) {
			let seconds = parseInt(v)
			if (isNaN(seconds)) {
				seconds = 10
			}
			if (seconds < 60) {
				seconds = 60
			}
			this.config.timeoutSeconds = seconds
		}
	},
	template: `<div>
	<input type="hidden" name="synFloodJSON" :value="JSON.stringify(config)"/>
	<a href="" @click.prevent="edit">
		<span v-if="config.isOn">
			{{$t("server_firewall-syn-flood-config-box@已启用")}} / <span>{{$t("server_firewall-syn-flood-config-box@空连接次数Colon")+config.minAttempts+$t("server_firewall-syn-flood-config-box@次PerMinute")}}</span> / {{$t("server_firewall-syn-flood-config-box@封禁时长Colon")+config.timeoutSeconds+$t("server_firewall-syn-flood-config-box@秒Unit")}} <span v-if="config.ignoreLocal">{{$t("server_firewall-syn-flood-config-box@slash忽略局域网访问")}}</span>
		</span>
		<span v-else>{{$t("server_firewall-syn-flood-config-box@未启用")}}</span>
		<i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i>
	</a>
	
	<table class="ui table selectable" v-show="isEditing">
		<tr>
			<td class="title">{{$t("server_firewall-syn-flood-config-box@启用Title")}}</td>
			<td>
				<checkbox :v-value="1" v-model="config.isOn"></checkbox>
				<p class="comment">{{$t("server_firewall-syn-flood-config-box@启用HelpText")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_firewall-syn-flood-config-box@空连接次数Title")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="minAttempts" style="width: 5em" maxlength="4"/>
					<span class="ui label">{{$t("server_firewall-syn-flood-config-box@次PerMinute")}}</span>
				</div>
				<p class="comment">{{$t("server_firewall-syn-flood-config-box@空连接次数HelpText")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_firewall-syn-flood-config-box@封禁时长Title")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="timeoutSeconds" style="width: 5em" maxlength="8"/>
					<span class="ui label">{{$t("server_firewall-syn-flood-config-box@秒Unit")}}</span>
				</div>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_firewall-syn-flood-config-box@忽略局域网访问Title")}}</td>
			<td>
				<checkbox :v-value="1" v-model="config.ignoreLocal"></checkbox>
			</td>
		</tr>
	</table>
</div>`
})

Vue.component("script-group-config-box", {
	props: ["v-group", "v-auditing-status", "v-is-location"],
	data: function () {
		let group = this.vGroup
		if (group == null) {
			group = {
				isPrior: false,
				isOn: true,
				scripts: []
			}
		}
		if (group.scripts == null) {
			group.scripts = []
		}

		let script = null
		if (group.scripts.length > 0) {
			script = group.scripts[group.scripts.length - 1]
		}

		return {
			group: group,
			script: script
		}
	},
	methods: {
		changeScript: function (script) {
			this.group.scripts = [script] // 目前只支持单个脚本
			this.change()
		},
		change: function () {
			this.$emit("change", this.group)
		}
	},
	template: `<div>
		<table class="ui table definition selectable">
			<prior-checkbox :v-config="group" v-if="vIsLocation"></prior-checkbox>
		</table>
		<div :style="{opacity: (!vIsLocation || group.isPrior) ? 1 : 0.5}">
			<script-config-box :v-script-config="script" :v-auditing-status="vAuditingStatus" :comment="$t('script-group-config-box@在接收到客户端请求之后立即调用预置')" @change="changeScript" :v-is-location="vIsLocation"></script-config-box>
		</div>
</div>`
})

Vue.component("http-request-conds-box", {
	props: ["v-conds"],
	data: function () {
		let conds = this.vConds
		if (conds == null) {
			conds = {
				isOn: true,
				connector: "or",
				groups: []
			}
		}
		if (conds.groups == null) {
			conds.groups = []
		}
		return {
			conds: conds,
			components: window.REQUEST_COND_COMPONENTS
		}
	},
	methods: {
		change: function () {
			this.$emit("change", this.conds)
		},
		addGroup: function () {
			window.UPDATING_COND_GROUP = null

			let that = this
			teaweb.popup("/servers/server/settings/conds/addGroupPopup", {
				title: this.$t('http-request-conds-box@添加条件分组'),
				height: "30em",
				callback: function (resp) {
					that.conds.groups.push(resp.data.group)
					that.change()
				}
			})
		},
		updateGroup: function (groupIndex, group) {
			window.UPDATING_COND_GROUP = group
			let that = this
			teaweb.popup("/servers/server/settings/conds/addGroupPopup", {
				title: this.$t('http-request-conds-box@修改条件分组'),
				height: "30em",
				callback: function (resp) {
					Vue.set(that.conds.groups, groupIndex, resp.data.group)
					that.change()
				}
			})
		},
		removeGroup: function (groupIndex) {
			let that = this
			teaweb.confirm(this.$t('http-request-conds-box@确定要删除这一组条件吗'), function () {
				that.conds.groups.$remove(groupIndex)
				that.change()
			})
		},
		typeName: function (cond) {
			let c = this.components.$find(function (k, v) {
				return v.type == cond.type
			})
			if (c != null) {
				return c.name;
			}
			return cond.param + " " + cond.operator
		}
	},
	template: `<div>
		<input type="hidden" name="condsJSON" :value="JSON.stringify(conds)"/>
		<div v-if="conds.groups.length > 0">
			<table class="ui table">
				<tr v-for="(group, groupIndex) in conds.groups">
					<td class="title" :class="{'color-border':conds.connector == 'and'}" :style="{'border-bottom':(groupIndex < conds.groups.length-1) ? '1px solid rgba(34,36,38,.15)':''}">{{$t('http-request-conds-box@分组')}}{{groupIndex+1}}</td>
					<td style="background: white; word-break: break-all" :style="{'border-bottom':(groupIndex < conds.groups.length-1) ? '1px solid rgba(34,36,38,.15)':''}">
						<var v-for="(cond, index) in group.conds" style="font-style: normal;display: inline-block; margin-bottom:0.5em">
							<span class="ui label tiny">
								<var v-if="cond.type.length == 0 || cond.type == 'params'" style="font-style: normal">{{cond.param}} <var>{{cond.operator}}</var></var>
								<var v-if="cond.type.length > 0 && cond.type != 'params'" style="font-style: normal">{{typeName(cond)}}: </var>
								{{cond.value}}
								<sup v-if="cond.isCaseInsensitive" :title="$t('http-request-conds-box@不区分大小写')"><i class="icon info small"></i></sup>
							</span>
							
							<var v-if="index < group.conds.length - 1"> {{group.connector}} &nbsp;</var>
						</var>
					</td>
					<td style="width: 5em; background: white" :style="{'border-bottom':(groupIndex < conds.groups.length-1) ? '1px solid rgba(34,36,38,.15)':''}">
						<a href="" :title="$t('http-request-conds-box@修改分组')" @click.prevent="updateGroup(groupIndex, group)"><i class="icon pencil small"></i></a> <a href="" :title="$t('http-request-conds-box@删除分组')" @click.prevent="removeGroup(groupIndex)"><i class="icon remove"></i></a>
					</td>
				</tr>
			</table>
			<div class="ui divider"></div>
		</div>
		
		<!-- 分组之间关系 -->
		<table class="ui table" v-if="conds.groups.length > 1">
			<tr>
				<td class="title">{{$t('http-request-conds-box@分组之间关系')}}</td>
				<td>
					<b-select
						v-model="conds.connector"
						auto-width
						@change="change"
						:options="[
							{label: $t('http-request-conds-box@和'), value: 'and'},
							{label: $t('http-request-conds-box@或'), value: 'or'},
						]"
					></b-select>
					
					<p class="comment">
						<span v-if="conds.connector == 'or'">{{$t('http-request-conds-box@或提示')}}</span>
						<span v-if="conds.connector == 'and'">{{$t('http-request-conds-box@和提示')}}</span>
					</p>	
				</td>
			</tr>
		</table>
		
		<div>
			<button class="ui button tiny basic" type="button" @click.prevent="addGroup()">{{$t('http-request-conds-box@添加分组')}}</button>
		</div>
	</div>	
</div>`
})

// 压缩配置
Vue.component("http-optimization-config-box", {
	props: ["v-optimization-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vOptimizationConfig

		return {
			config: config,
			htmlMoreOptions: true,
			javascriptMoreOptions: true,
			cssMoreOptions: true
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="optimization-box">
	<input type="hidden" name="optimizationJSON" :value="JSON.stringify(config)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-if="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-optimization-config-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="config" class="config-item"></prior-checkbox>
	</div>
	
	<div v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
		<!-- HTML优化 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon html5"></i>
				<span>{{$t('http-optimization-config-box@HTML优化')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('http-optimization-config-box@启用HTML优化')}}</div>
				<div class="item-content">
					<p-switch value="1" v-model="config.html.isOn" binary @change="submit"></p-switch>
					<p class="comment">{{$t('http-optimization-config-box@可以自动优化HTML中包含的空白_注释_空标签等_只有文件可以缓存时才会被优化')}}</p>
				</div>
			</div>
			
			<div v-show="htmlMoreOptions && config.html.isOn">
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@HTML例外URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.html.exceptURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了例外URL_表示这些URL跳过不做处理')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@HTML限制URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.html.onlyURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了限制URL_表示只对这些URL进行优化处理_如果不填则表示支持所有的URL')}}</p>
					</div>
				</div>
			</div>
		</div>
		
		<!-- Javascript优化 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon js"></i>
				<span>{{$t('http-optimization-config-box@Javascript优化')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('http-optimization-config-box@启用JS优化')}}</div>
				<div class="item-content">
					<p-switch value="1" v-model="config.javascript.isOn" binary @change="submit"></p-switch>
					<p class="comment">{{$t('http-optimization-config-box@可以自动缩短Javascript中变量_函数名称等_只有文件可以缓存时才会被优化')}}</p>
				</div>
			</div>
			
			<div v-show="javascriptMoreOptions && config.javascript.isOn">
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@JS例外URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.javascript.exceptURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了例外URL_表示这些URL跳过不做处理')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@JS限制URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.javascript.onlyURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了限制URL_表示只对这些URL进行优化处理_如果不填则表示支持所有的URL')}}</p>
					</div>
				</div>
			</div>
		</div>
		
		<!-- CSS优化 -->
		<div class="config-section">
			<div class="section-title">
				<i class="icon css3"></i>
				<span>{{$t('http-optimization-config-box@CSS优化')}}</span>
			</div>
			
			<div class="config-item">
				<div class="item-label">{{$t('http-optimization-config-box@启用CSS优化')}}</div>
				<div class="item-content">
					<p-switch value="1" v-model="config.css.isOn" binary @change="submit"></p-switch>
					<p class="comment">{{$t('http-optimization-config-box@可以自动去除CSS中包含的空白_只有文件可以缓存时才会被优化')}}</p>
				</div>
			</div>
			
			<div v-show="cssMoreOptions && config.css.isOn">
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@CSS例外URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.css.exceptURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了例外URL_表示这些URL跳过不做处理')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-optimization-config-box@CSS限制URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.css.onlyURLPatterns" @input="submit"></url-patterns-box>
						<p class="comment">{{$t('http-optimization-config-box@如果填写了限制URL_表示只对这些URL进行优化处理_如果不填则表示支持所有的URL')}}</p>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>`
})


Vue.component("server-traffic-limit-status-viewer", {
	props: ["value"],
	data: function () {
		let targetTypeName = "流量"
		if (this.value != null) {
			targetTypeName = this.targetTypeToName(this.value.targetType)
		}

		return {
			status: this.value,
			targetTypeName: targetTypeName
		}
	},
	methods: {
		targetTypeToName: function (targetType) {
			switch (targetType) {
				case "traffic":
					return this.$t('server-traffic-limit-status-viewer@流量')
				case "request":
					return this.$t('server-traffic-limit-status-viewer@请求数')
				case "websocketConnections":
					return this.$t('server-traffic-limit-status-viewer@Websocket连接数')
			}
			return this.$t('server-traffic-limit-status-viewer@流量')
		}
	},
	template: `<span v-if="status != null">
	<span v-if="status.dateType == 'day'" class="small red">{{$t('server-traffic-limit-status-viewer@已达到')}}<span v-if="status.planId > 0">{{$t('server-traffic-limit-status-viewer@套餐')}}</span>{{$t('server-traffic-limit-status-viewer@当日')}}{{targetTypeName}}{{$t('server-traffic-limit-status-viewer@限制')}}</span>
	<span v-if="status.dateType == 'month'" class="small red">{{$t('server-traffic-limit-status-viewer@已达到')}}<span v-if="status.planId > 0">{{$t('server-traffic-limit-status-viewer@套餐')}}</span>{{$t('server-traffic-limit-status-viewer@当月')}}{{targetTypeName}}{{$t('server-traffic-limit-status-viewer@限制')}}</span>
	<span v-if="status.dateType == 'total'" class="small red">{{$t('server-traffic-limit-status-viewer@已达到')}}<span v-if="status.planId > 0">{{$t('server-traffic-limit-status-viewer@套餐')}}</span>{{$t('server-traffic-limit-status-viewer@总体')}}{{targetTypeName}}{{$t('server-traffic-limit-status-viewer@限制')}}</span>
</span>`
})

Vue.component("http-remote-addr-config-box", {
	props: ["v-remote-addr-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vRemoteAddrConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				value: "${rawRemoteAddr}",
				type: "default",

				requestHeaderName: ""
			}
		}

		// type
		if (config.type == null || config.type.length == 0) {
			config.type = "default"
			switch (config.value) {
				case "${rawRemoteAddr}":
					config.type = "default"
					break
				case "${remoteAddrValue}":
					config.type = "default"
					break
				case "${remoteAddr}":
					config.type = "proxy"
					break
				default:
					if (config.value != null && config.value.length > 0) {
						config.type = "variable"
					}
			}
		}

		// value
		if (config.value == null || config.value.length == 0) {
			config.value = "${rawRemoteAddr}"
		}

		return {
			config: config,
			options: [
				{
					name: this.$t("http-remote-addr-config-box@直接获取"),
					description: this.$t("http-remote-addr-config-box@用户直接访问边缘节点_即_用户_边缘节点_模式_这时候系统会试图从直接的连接中读取到客户端IP地址"),
					value: "${rawRemoteAddr}",
					type: "default"
				},
				{
					name: this.$t("http-remote-addr-config-box@从上级代理中获取"),
					description: this.$t("http-remote-addr-config-box@用户和边缘节点之间有别的代理服务转发_即_用户_第三方代理服务_边缘节点_这时候只能从上级代理中获取传递的IP地址_上级代理传递的请求报头中必须包含X_Forwarded_For或X_Real_IP信息"),
					value: "${remoteAddr}",
					type: "proxy"
				},
				{
					name: this.$t("http-remote-addr-config-box@从请求报头中读取"),
					description: this.$t("http-remote-addr-config-box@从自定义请求报头读取客户端IP"),
					value: "",
					type: "requestHeader"
				},
				{
					name: this.$t("http-remote-addr-config-box@自定义变量"),
					description: this.$t("http-remote-addr-config-box@通过自定义变量来获取客户端真实的IP地址"),
					value: "",
					type: "variable"
				}
			]
		}
	},
	watch: {
		"config.requestHeaderName": function (value) {
			if (this.config.type == "requestHeader") {
				this.config.value = "${header." + value.trim() + "}"
			}
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		blur: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		},
		changeOptionType: function () {
			let that = this

			switch (this.config.type) {
				case "default":
					this.config.value = "${rawRemoteAddr}"
					this.blur()
					break
				case "proxy":
					this.config.value = "${remoteAddr}"
					this.blur()
					break
				case "requestHeader":
					this.config.value = ""
					if (this.requestHeaderName != null && this.requestHeaderName.length > 0) {
						this.config.value = "${header." + this.requestHeaderName + "}"
					}

					setTimeout(function () {
						that.$refs.requestHeaderInput.focus()
					})
					break
				case "variable":
					this.config.value = "${rawRemoteAddr}"

					setTimeout(function () {
						that.$refs.variableInput.focus()
					})

					break
			}
			
		}
	},
	template: `<div class="remote-addr-box">
	<input type="hidden" name="remoteAddrJSON" :value="JSON.stringify(config)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-if="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t("http-remote-addr-config-box@基本设置")}}</span>
		</div>
		
		<prior-checkbox :v-config="config" class="config-item"></prior-checkbox>
	</div>
	
	<!-- 访客IP设置 -->
	<div class="config-section" v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
		<div class="section-title">
			<i class="icon globe"></i>
			<span>{{$t("http-remote-addr-config-box@访客IP设置")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-remote-addr-config-box@启用访客IP设置")}}</div>
			<div class="item-content">
				<p-switch v-model="config.isOn" binary @change="blur"></p-switch>
				<p class="comment">{{$t("http-remote-addr-config-box@选中后_表示使用自定义的请求变量获取客户端IP")}}</p>
			</div>
		</div>
	</div>
	
	<!-- IP获取方式 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon server"></i>
			<span>{{$t("http-remote-addr-config-box@IP获取方式")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-remote-addr-config-box@获取IP方式*")}}</div>
			<div class="item-content">
				<b-select v-model="config.type" :options="[
					{label: $t('http-remote-addr-config-box@请选择'), value:''},
					...options.map(option => ({label: option.name, value: option.type})),
				]" @change="changeOptionType"></b-select>
				<p class="comment" v-for="option in options" v-if="option.type == config.type && option.description.length > 0">{{option.description}}</p>
			</div>
		</div>
		
		<!-- 从请求报头中读取 -->
		<div class="config-item" v-show="config.type == 'requestHeader'">
			<div class="item-label">{{$t("http-remote-addr-config-box@请求报头*")}}</div>
			<div class="item-content">
				<input type="text" name="requestHeaderName" v-model="config.requestHeaderName" maxlength="100" ref="requestHeaderInput" @blur="blur"/>
				<p class="comment">{{$t('http-remote-addr-config-box@请输入包含有客户端IP的请求报头_需要注意大小写_常见的有')}}<code-label>X_Forwarded_For</code-label>X_Real_IP<code-label>X_Client_IP</code-label>{{$t('http-remote-addr-config-box_等')}}</p>
			</div>
		</div>
		
		<!-- 自定义变量 -->
		<div class="config-item" v-show="config.type == 'variable'">
			<div class="item-label">{{$t("http-remote-addr-config-box@读取IP变量值*")}}</div>
			<div class="item-content">
				<input type="text" name="value" v-model="config.value" maxlength="100" ref="variableInput" @blur="blur"/>
				<p class="comment">{{$t('http-remote-addr-config-box@通过此变量获取用户的IP地址_具体可用的请求变量列表可参考官方网站文档_比如通过报头传递IP的情形_可以使用')}}<code-label>\$\{header.你的自定义报头\}</code-label>（{{$t('http-remote-addr-config-box@类似于')}}<code-label>\\$\{header.X-Forwarded-For\}</code-label>{{$t('http-remote-addr-config-box@需要注意大小写规范')}}）</p>
			</div>
		</div>
	</div>
</div>`
})

// 指标周期设置
Vue.component("metric-period-config-box", {
	props: ["v-period", "v-period-unit"],
	data: function () {
		let period = this.vPeriod
		let periodUnit = this.vPeriodUnit
		if (period == null || period.toString().length == 0) {
			period = 1
		}
		if (periodUnit == null || periodUnit.length == 0) {
			periodUnit = "day"
		}
		return {
			periodConfig: {
				period: period,
				unit: periodUnit
			}
		}
	},
	watch: {
		"periodConfig.period": function (v) {
			v = parseInt(v)
			if (isNaN(v) || v <= 0) {
				v = 1
			}
			this.periodConfig.period = v
		}
	},
	template: `<div>
	<input type="hidden" name="periodJSON" :value="JSON.stringify(periodConfig)"/>
	<div class="ui fields inline">
		<div class="ui field">
			<input type="text" v-model="periodConfig.period" maxlength="4" size="4"/>
		</div>
		<div class="ui field">
			<b-select
				v-model="periodConfig.unit"
				:options="[
					{label: $t('metric-period-config-box@分钟'), value: 'minute'},
					{label: $t('metric-period-config-box@小时'), value: 'hour'},
					{label: $t('metric-period-config-box@天'), value: 'day'},
					{label: $t('metric-period-config-box@周'), value: 'week'},
					{label: $t('metric-period-config-box@月'), value: 'month'},
				]"
			></b-select>
		</div>
	</div>
	<p class="comment">{{$t('metric-period-config-box@在此周期内同一对象累积为同一数据')}}</p>
</div>`
})

Vue.component("ssl-certs-view", {
	props: ["v-certs"],
	data: function () {
		let certs = this.vCerts
		if (certs == null) {
			certs = []
		}
		return {
			certs: certs
		}
	},
	methods: {
		// 格式化时间
		formatTime: function (timestamp) {
			return new Date(timestamp * 1000).format("Y-m-d")
		},

		// 查看详情
		viewCert: function (certId) {
			teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
				title: '证书详情',
				height: "28em",
				width: "48em"
			})
		}
	},
	template: `<div>
	<div v-if="certs != null && certs.length > 0">
		<div class="ui label small basic" v-for="(cert, index) in certs">
			{{cert.name}} / {{cert.dnsNames}} / {{$t('ssl-certs-view@有效至')}}{{formatTime(cert.timeEndAt)}} &nbsp;<a href="" title="查看" @click.prevent="viewCert(cert.id)"><i class="icon expand"></i></a>
		</div>
	</div>
</div>`
})

// 基本认证用户配置
Vue.component("http-auth-basic-auth-user-box", {
	props: ["v-users"],
	data: function () {
		let users = this.vUsers
		if (users == null) {
			users = []
		}
		return {
			users: users,
			isAdding: false,
			updatingIndex: -1,

			username: "",
			password: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			this.username = ""
			this.password = ""

			let that = this
			setTimeout(function () {
				that.$refs.username.focus()
			}, 100)
		},
		cancel: function () {
			this.isAdding = false
			this.updatingIndex = -1
		},
		confirm: function () {
			let that = this
			if (this.username.length == 0) {
				teaweb.warn(this.$t("server_http-auth-basic-auth-user-box@请输入用户名"), function () {
					that.$refs.username.focus()
				})
				return
			}
			if (this.password.length == 0) {
				teaweb.warn(this.$t("server_http-auth-basic-auth-user-box@请输入密码"), function () {
					that.$refs.password.focus()
				})
				return
			}
			if (this.updatingIndex < 0) {
				this.users.push({
					username: this.username,
					password: this.password
				})
			} else {
				this.users[this.updatingIndex].username = this.username
				this.users[this.updatingIndex].password = this.password
			}
			this.cancel()
		},
		update: function (index, user) {
			this.updatingIndex = index

			this.isAdding = true
			this.username = user.username
			this.password = user.password

			let that = this
			setTimeout(function () {
				that.$refs.username.focus()
			}, 100)
		},
		remove: function (index) {
			this.users.$remove(index)
		}
	},
	template: `<div>
	<input type="hidden" name="httpAuthBasicAuthUsersJSON" :value="JSON.stringify(users)"/>
	<div v-if="users.length > 0">
		<div class="ui label small basic" v-for="(user, index) in users">
			{{user.username}} <a href="" :title="$t('server_http-auth-basic-auth-user-box@修改')" @click.prevent="update(index, user)"><i class="icon pencil tiny"></i></a>
			<a href="" :title="$t('server_http-auth-basic-auth-user-box@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	<div v-show="isAdding">
		<div class="ui fields inline">
			<div class="ui field">
				<input type="text" :placeholder="$t('server_http-auth-basic-auth-user-box@用户名Placeholder')" v-model="username" size="15" ref="username"/>
			</div>
			<div class="ui field">
				<input type="password" :placeholder="$t('server_http-auth-basic-auth-user-box@密码Placeholder')" v-model="password" size="15" ref="password"/>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{$t("server_http-auth-basic-auth-user-box@确定")}}</button>&nbsp;
				<a href="" :title="$t('server_http-auth-basic-auth-user-box@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
	</div>
	<div v-if="!isAdding" style="margin-top: 1em">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

// UAM模式配置
Vue.component("uam-config-box", {
	props: ["v-uam-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vUamConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				addToWhiteList: true,
				onlyURLPatterns: [],
				exceptURLPatterns: [],
				minQPSPerIP: 0,
				keyLife: 0
			}
		}
		if (config.onlyURLPatterns == null) {
			config.onlyURLPatterns = []
		}
		if (config.exceptURLPatterns == null) {
			config.exceptURLPatterns = []
		}
		return {
			config: config,
			moreOptionsVisible: true,
			minQPSPerIP: config.minQPSPerIP,
			keyLife: config.keyLife
		}
	},
	watch: {
		minQPSPerIP: function (v) {
			let qps = parseInt(v.toString())
			if (isNaN(qps) || qps < 0) {
				qps = 0
			}
			this.config.minQPSPerIP = qps
		},
		keyLife: function (v) {
			let keyLife = parseInt(v)
			if (isNaN(keyLife) || keyLife <= 0) {
				keyLife = 0
			}
			this.config.keyLife = keyLife
		}
	},
	methods: {
		showMoreOptions: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		changeConds: function (conds) {
			this.config.conds = conds
			this.submit()
		},
		submit: function () {
			setTimeout(()=>{
				this.$emit('submit')
			}, 100)
		}
	},
	template: `<div>
<input type="hidden" name="uamJSON" :value="JSON.stringify(config)"/>

<div class="config-section">
    <div class="section-title">
        <i class="icon power"></i>
        <span>{{$t('uam-config-box@基本设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@启用5秒盾')}}</div>
        <div class="item-content">
            <p-switch v-model="config.isOn" binary @change="submit"></p-switch>
            <p class="comment"><plus-label></plus-label>{{$t('uam-config-box@启用5秒盾提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon shield alternate"></i>
        <span>{{$t('uam-config-box@防护设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@验证有效期')}}</div>
        <div class="item-content">
            <div class="ui input right labeled">
                <input type="text" name="keyLife" v-model="keyLife" maxlength="6" size="6" style="width: 6em" @blur="submit"/>
                <span class="ui label">{{$t('uam-config-box@秒')}}</span>
            </div>
            <p class="comment">{{$t('uam-config-box@验证有效期提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@单IP最低QPS')}}</div>
        <div class="item-content">
            <div class="ui input right labeled">
                <input type="text" name="minQPSPerIP" maxlength="6" style="width: 6em" v-model="minQPSPerIP" @blur="submit"/>
                <span class="ui label">{{$t('uam-config-box@请求数每秒')}}</span>
            </div>
            <p class="comment">{{$t('uam-config-box@单IP最低QPS提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@加入IP白名单')}}</div>
        <div class="item-content">
            <p-checkbox v-model="config.addToWhiteList" binary @change="submit"></p-checkbox>
            <p class="comment">{{$t('uam-config-box@加入IP白名单提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon filter"></i>
        <span>{{$t('uam-config-box@URL过滤设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@例外URL')}}</div>
        <div class="item-content">
            <url-patterns-box v-model="config.exceptURLPatterns" @change="submit"></url-patterns-box>
            <p class="comment">{{$t('uam-config-box@例外URL提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@限制URL')}}</div>
        <div class="item-content">
            <url-patterns-box v-model="config.onlyURLPatterns" @change="submit"></url-patterns-box>
            <p class="comment">{{$t('uam-config-box@限制URL提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon sliders horizontal"></i>
        <span>{{$t('uam-config-box@匹配条件')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('uam-config-box@匹配条件')}}</div>
        <div class="item-content">
            <http-request-conds-box :v-conds="config.conds" @change="changeConds"></http-request-conds-box>
        </div>
    </div>
</div>

<div class="config-section" v-if="vIsLocation || vIsGroup">
	<div class="section-title">
		<i class="icon sliders horizontal"></i>
		<span>{{$t('uam-config-box@独立配置')}}</span>
	</div>
        <prior-checkbox :v-config="config"></prior-checkbox>
</div>

<div class="margin"></div>
</div>`
})

Vue.component("http-websocket-box", {
	props: ["v-websocket-ref", "v-websocket-config", "v-is-location"],
	data: function () {
		let websocketRef = this.vWebsocketRef
		if (websocketRef == null) {
			websocketRef = {
				isPrior: false,
				isOn: false,
				websocketId: 0
			}
		}

		let websocketConfig = this.vWebsocketConfig
		if (websocketConfig == null) {
			websocketConfig = {
				id: 0,
				isOn: false,
				handshakeTimeout: {
					count: 30,
					unit: "second"
				},
				allowAllOrigins: true,
				allowedOrigins: [],
				requestSameOrigin: true,
				requestOrigin: ""
			}
		} else {
			if (websocketConfig.handshakeTimeout == null) {
				websocketConfig.handshakeTimeout = {
					count: 30,
					unit: "second",
				}
			}
			if (websocketConfig.allowedOrigins == null) {
				websocketConfig.allowedOrigins = []
			}
		}

		return {
			websocketRef: websocketRef,
			websocketConfig: websocketConfig,
			handshakeTimeoutCountString: websocketConfig.handshakeTimeout.count.toString(),
			advancedVisible: true
		}
	},
	watch: {
		handshakeTimeoutCountString: function (v) {
			let count = parseInt(v)
			if (!isNaN(count) && count >= 0) {
				this.websocketConfig.handshakeTimeout.count = count
			} else {
				this.websocketConfig.handshakeTimeout.count = 0
			}
		}
	},
	methods: {
		isOn: function () {
			return (!this.vIsLocation || this.websocketRef.isPrior) && this.websocketRef.isOn
		},
		changeAdvancedVisible: function (v) {
			this.advancedVisible = v
		},
		createOrigin: function () {
			let that = this
			teaweb.popup("/servers/server/settings/websocket/createOrigin", {
				title: this.$t('http-websocket-box@创建来源域'),
				height: "12.5em",
				callback: function (resp) {
					that.websocketConfig.allowedOrigins.push(resp.data.origin)
					that.submit()
				}
			})
		},
		removeOrigin: function (index) {
			this.websocketConfig.allowedOrigins.$remove(index)
			this.submit()
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.websocketRef, this.websocketConfig)
			}, 100)
		}
	},
	template: `<div class="websocket-box">
	<input type="hidden" name="websocketRefJSON" :value="JSON.stringify(websocketRef)"/>
	<input type="hidden" name="websocketJSON" :value="JSON.stringify(websocketConfig)"/>
	
	<!-- 基本设置 -->
	<div class="config-section">
		<div class="section-title">
			<i class="icon exchange"></i>
			<span>{{$t('http-websocket-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="websocketRef" v-if="vIsLocation" class="config-item"></prior-checkbox>
		
		<div class="config-item" v-show="(!this.vIsLocation || this.websocketRef.isPrior)">
			<div class="item-label">{{$t('http-websocket-box@启用WebSocket')}}</div>
			<div class="item-content">
				<p-switch v-model="websocketRef.isOn" binary @change="submit"></p-switch>
			</div>
		</div>
	</div>
	
	<!-- 来源域设置 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon globe"></i>
			<span>{{$t('http-websocket-box@来源域设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-content">
				<checkbox v-model="websocketConfig.allowAllOrigins" binary @change="submit">{{$t('http-websocket-box@允许所有来源域')}}<em>（Origin）</em></checkbox>
				<p class="comment">{{$t('http-websocket-box@选中表示允许所有的来源域')}}</p>
			</div>
		</div>
		
		<div class="config-item" v-show="!websocketConfig.allowAllOrigins">
			<div class="item-label">{{$t('http-websocket-box@允许的来源域列表')}}<em>（Origin）</em></div>
			<div class="item-content">
				<div v-if="websocketConfig.allowedOrigins.length > 0" class="origins-box">
					<div class="ui label small basic" v-for="(origin, index) in websocketConfig.allowedOrigins">
						{{origin}} <a href="" :title="$t('http-websocket-box@删除')" @click.prevent="removeOrigin(index)"><i class="icon remove small"></i></a>
					</div>
				</div>
				<div class="margin"></div>
				<button class="ui button tiny" type="button" @click.prevent="createOrigin()">
					<i class="icon plus small"></i>{{$t('http-websocket-box@添加来源域')}}
				</button>
				<p class="comment">{{$t('http-websocket-box@只允许在列表中的来源域名访问WebSocket服务')}}</p>
			</div>
		</div>
	</div>
	
	<!-- 高级选项 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-websocket-box@高级选项')}}</span>
		</div>
		
		<div v-show="advancedVisible">
			<div class="config-item">
				<div class="item-content">
					<checkbox v-model="websocketConfig.requestSameOrigin" binary @change="submit">{{$t('http-websocket-box@传递请求来源域')}}</checkbox>
					<p class="comment">{{$t('http-websocket-box@选中后表示把接收到的请求中的')}}<code-label>Origin</code-label>{{$t('http-websocket-box@字段传递到源站')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="!websocketConfig.requestSameOrigin">
				<div class="item-label">{{$t('http-websocket-box@指定传递的来源域')}}</div>
				<div class="item-content">
					<input type="text" @blur="submit" maxlength="200" v-model="websocketConfig.requestOrigin"/>
					<p class="comment">{{$t('http-websocket-box@指定向源站传递的')}}<span class="ui label tiny">Origin</span>{{$t('http-websocket-box@字段值')}}</p>
				</div>
			</div>
			
			<!-- TODO 这个选项暂时保留 -->
			<div class="config-item" v-show="false">
				<div class="item-label">{{$t('http-websocket-box@握手超时时间')}}<em>（Handshake）</em></div>
				<div class="item-content">
					<div class="ui fields inline">
						<div class="ui field">
							<input type="text" @blur="submit" maxlength="10" v-model="handshakeTimeoutCountString" style="width:6em"/>
						</div>
						<div class="ui field">
							{{$t('http-websocket-box@秒')}}
						</div>
					</div>
					<p class="comment">{{$t('http-websocket-box@0表示使用默认的时间设置')}}</p>
				</div>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("http-web-root-box", {
	props: ["v-root-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vRootConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				dir: "",
				indexes: [],
				stripPrefix: "",
				decodePath: false,
				isBreak: false,
				exceptHiddenFiles: true,
				onlyURLPatterns: [],
				exceptURLPatterns: []
			}
		}
		if (config.indexes == null) {
			config.indexes = []
		}

		if (config.onlyURLPatterns == null) {
			config.onlyURLPatterns = []
		}
		if (config.exceptURLPatterns == null) {
			config.exceptURLPatterns = []
		}

		return {
			config: config,
			advancedVisible: true
		}
	},
	methods: {
		changeAdvancedVisible: function (v) {
			this.advancedVisible = v
		},
		addIndex: function () {
			let that = this
			teaweb.popup("/servers/server/settings/web/createIndex", {
				title: '添加首页文件',
				height: "10em",
				callback: function (resp) {
					that.config.indexes.push(resp.data.index)
				}
			})
		},
		removeIndex: function (i) {
			this.config.indexes.$remove(i)
		},
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		}
	},
	template: `<div class="user-agent-box">
	<input type="hidden" name="rootJSON" :value="JSON.stringify(config)"/>
	
	<div class="config-section" v-if="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon sliders horizontal"></i>
			<span>{{$t('http-web-root-box@独立配置')}}</span>
		</div>
		<prior-checkbox :v-config="config"></prior-checkbox>
	</div>
	
	<div class="config-section" v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-web-root-box@基本设置')}}</span>
		</div>
		<div class="config-item" v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
			<div class="item-label">{{$t('http-web-root-box@启用静态资源分发')}}</div>
			<div class="item-content">
				<p-switch :v-value="1" v-model="config.isOn"></p-switch>
			</div>
		</div>
		
		<div v-show="isOn()">
			<div class="config-item">
				<div class="item-label">{{$t('http-web-root-box@静态资源根目录')}}</div>
				<div class="item-content">
					<input type="text" name="root" v-model="config.dir" ref="focus" :placeholder="$t('http-web-root-box@类似于_home_www')"/>
					<p class="comment">{{$t('http-web-root-box@可以访问此根目录下的静态资源')}}</p>
				</div>
			</div>
			
			<div v-show="advancedVisible">
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@首页文件')}}</div>
					<div class="item-content">
						<div v-if="config.indexes.length > 0" class="ui labels">
							<div v-for="(index, i) in config.indexes" class="ui label small basic">
								{{index}} <a href="" :title="$t('http-web-root-box@删除')" @click.prevent="removeIndex(i)"><i class="icon remove"></i></a>
							</div>
						</div>
						<div v-if="config.indexes.length > 0" class="ui divider"></div>
						<button class="ui button small" type="button" @click.prevent="addIndex()">{{$t('http-web-root-box@添加首页文件')}}</button>
						<p class="comment">{{$t('http-web-root-box@在URL中只有目录没有文件名时默认查找的首页文件')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@例外URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.exceptURLPatterns"></url-patterns-box>
						<p class="comment">{{$t('http-web-root-box@如果填写了例外URL_表示不支持通过这些URL访问')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@限制URL')}}</div>
					<div class="item-content">
						<url-patterns-box v-model="config.onlyURLPatterns"></url-patterns-box>
						<p class="comment">{{$t('http-web-root-box@如果填写了限制URL_表示仅支持通过这些URL访问')}}</p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@排除隐藏文件')}}</div>
					<div class="item-content">
						<checkbox :v-value="1" v-model="config.exceptHiddenFiles"></checkbox>
						<p class="comment">{{$t('http-web-root-box@排除以点_符号开头的隐藏目录或文件_比如')}}<code-label>git/logs/HEAD</code-label></p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@去除URL前缀')}}</div>
					<div class="item-content">
						<input type="text" v-model="config.stripPrefix" placeholder="/PREFIX"/>
						<p class="comment" v-html="$t('http-web-root-box@可以把请求的路径部分前缀去除后再查找文件_比如把_span_class_ui_label_tiny_web_app_index_html_span_去除前缀_span_class_ui_label_tiny_web_span_后就变成_span_class_ui_label_tiny_app_index_html_span')"></p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@路径解码')}}</div>
					<div class="item-content">
						<checkbox :v-value="1" v-model="config.decodePath"></checkbox>
						<p class="comment" v-html="$t('http-web-root-box@是否对请求路径进行URL解码_比如把_span_class_ui_label_tiny_Web_App_Browser_html_span_解码成_span_class_ui_label_tiny_Web_App_Browser_html_span_再查找文件')"></p>
					</div>
				</div>
				
				<div class="config-item">
					<div class="item-label">{{$t('http-web-root-box@终止请求')}}</div>
					<div class="item-content">
						<checkbox :v-value="1" v-model="config.isBreak"></checkbox>
						<p class="comment">{{$t('http-web-root-box@在找不到要访问的文件的情况下是否终止请求并返回404_如果选择终止请求_则不再尝试反向代理等设置')}}</p>
					</div>
				</div>
			</div>
		</div>
	</div>


	
</div>`
})

// 访问日志搜索框
Vue.component("http-access-log-search-box", {
	props: ["v-ip", "v-domain", "v-keyword", "v-cluster-id", "v-node-id"],
	data: function () {
		let ip = this.vIp
		if (ip == null) {
			ip = ""
		}

		let domain = this.vDomain
		if (domain == null) {
			domain = ""
		}

		let keyword = this.vKeyword
		if (keyword == null) {
			keyword = ""
		}

		return {
			ip: ip,
			domain: domain,
			keyword: keyword,
			clusterId: this.vClusterId
		}
	},
	methods: {
		cleanIP: function () {
			this.ip = ""
			this.submit()
		},
		cleanDomain: function () {
			this.domain = ""
			this.submit()
		},
		cleanKeyword: function () {
			this.keyword = ""
			this.submit()
		},
		submit: function () {
			let parent = this.$el.parentNode
			while (true) {
				if (parent == null) {
					break
				}
				if (parent.tagName == "FORM") {
					break
				}
				parent = parent.parentNode
			}
			if (parent != null) {
				setTimeout(function () {
					parent.submit()
				}, 500)
			}
		},
		changeCluster: function (clusterId) {
			this.clusterId = clusterId
		}
	},
	template: `<div style="z-index: 10">
	<div class="margin"></div>
	<div class="ui fields inline">
		<div class="ui field">
			<div class="ui input left right labeled small">
				<span class="ui label basic" style="font-weight: normal">IP</span>
				<input type="text" name="ip" placeholder="x.x.x.x" size="15" v-model="ip"/>
				<a class="ui label basic" :class="{disabled: ip.length == 0}" @click.prevent="cleanIP"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<div class="ui field">
			<div class="ui input left right labeled small" >
				<span class="ui label basic" style="font-weight: normal">{{$t('index_域名_0101')}}</span>
				<input type="text" name="domain" placeholder="example.com" size="15" v-model="domain"/>
				<a class="ui label basic" :class="{disabled: domain.length == 0}" @click.prevent="cleanDomain"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<div class="ui field">
			<div class="ui input left right labeled small">
				<span class="ui label basic" style="font-weight: normal">{{$t('index_关键词_0101')}}</span>
				<input type="text" name="keyword" v-model="keyword" :placeholder="$t('index_路径、UserAgent、请求ID等_0101')" size="30"/>
				<a class="ui label basic" :class="{disabled: keyword.length == 0}" @click.prevent="cleanKeyword"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<div class="ui field"><tip-icon :content="$t('index_一些特殊的关键词：_0101') + '<br/>' + $t('index_单个状态码：status:200_0101') + '<br/>' + $t('index_状态码范围：status:500-504_0101') + '<br/>' + $t('index_查询IP') + '<br/>' + $t('index_查询URL') + '<br/>' + $t('index_查询路径部分') + '<br/>' + $t('index_查询协议版本') + '<br/>' + $t('index_协议：scheme:http_0101') + '<br/>' + $t('index_请求方法：method:POST_0101') + '<br/>' + $t('index_请求来源referer')"></tip-icon></div>
	</div>
	<div class="ui fields inline" style="margin-top: 0.5em">
		<div class="ui field">
			<node-cluster-combo-box :v-cluster-id="clusterId" @change="changeCluster"></node-cluster-combo-box>
		</div>
		<div class="ui field" v-if="clusterId > 0">
			<node-combo-box :v-cluster-id="clusterId" :v-node-id="vNodeId"></node-combo-box>
		</div>
		<slot></slot>
		<div class="ui field">
			<button class="ui button small" type="submit">{{$t('index_搜索日志_0101')}}</button>
		</div>
	</div>
</div>`
})

Vue.component("http-host-redirect-box", {
	props: ["v-redirects"],
	mounted: function () {
		let that = this
		sortTable(function (ids) {
			let newRedirects = []
			ids.forEach(function (id) {
				that.redirects.forEach(function (redirect) {
					if (redirect.id == id) {
						newRedirects.push(redirect)
					}
				})
			})
			that.updateRedirects(newRedirects)
		})
	},
	data: function () {
		let redirects = this.vRedirects
		if (redirects == null) {
			redirects = []
		}

		let id = 0
		redirects.forEach(function (v) {
			id++
			v.id = id
		})

		const columns = [
			{
				title: '',
				key: 'handle',
				scopedSlots: { customRender: 'handleSlot' },
				width: '50px',
				align: 'center'
			},
			{
				title: this.$t('http-host-redirect-box@跳转前'),
				key: 'before',
				scopedSlots: { customRender: 'beforeSlot' },
				width: '300px'
			},
			{
				title: '',
				key: 'arrow',
				scopedSlots: { customRender: 'arrowSlot' },
				width: '50px',
				align: 'center'
			},
			{
				title: this.$t('http-host-redirect-box@跳转后'),
				key: 'after',
				scopedSlots: { customRender: 'afterSlot' },
				width: '200px'
			},
			{
				title: this.$t('http-host-redirect-box@HTTP状态码'),
				key: 'status',
				scopedSlots: { customRender: 'statusSlot' },
				width: '100px'
			},
			{
				title: this.$t('http-host-redirect-box@状态'),
				key: 'isOn',
				scopedSlots: { customRender: 'isOnSlot' },
				width: '100px',
				align: 'center'
			},
			{
				title: this.$t('http-host-redirect-box@操作'),
				key: 'operation',
				scopedSlots: { customRender: 'operationSlot' },
				width: '180px',
				align: 'center',
			}
		]

		return {
			redirects: redirects,
			statusOptions: [
				{ "code": 301, "text": "Moved Permanently" },
				{ "code": 308, "text": "Permanent Redirect" },
				{ "code": 302, "text": "Found" },
				{ "code": 303, "text": "See Other" },
				{ "code": 307, "text": "Temporary Redirect" }
			],
			id: id,
			columns: columns
		}
	},
	methods: {
		add: function () {
			let that = this
			window.UPDATING_REDIRECT = null

			teaweb.popup("/servers/server/settings/redirects/createPopup", {
				width: "50em",
				height: "36em",
				title: this.$t('http-host-redirect-box@创建跳转规则'),
				callback: function (resp) {
					that.id++
					resp.data.redirect.id = that.id
					that.redirects.push(resp.data.redirect)
					that.change()
				}
			})
		},
		update: function (index, redirect) {
			let that = this
			window.UPDATING_REDIRECT = redirect

			teaweb.popup("/servers/server/settings/redirects/createPopup", {
				width: "50em",
				height: "36em",
				title: this.$t('http-host-redirect-box@修改跳转规则'),
				callback: function (resp) {
					resp.data.redirect.id = redirect.id
					Vue.set(that.redirects, index, resp.data.redirect)
					that.change()
				}
			})
		},
		remove: function (index) {
			let that = this
			teaweb.confirm(this.$t('http-host-redirect-box@确定要删除这条跳转规则吗'), function () {
				that.redirects.$remove(index)
				that.change()
			})
		},
		change: function () {
			let that = this
			setTimeout(function () {
				that.$emit("change", that.redirects)
			}, 100)
		},
		updateRedirects: function (newRedirects) {
			this.redirects = newRedirects
			this.change()
		},
		handleSort: function (ids) {
			let newRedirects = []
			ids.forEach(function (id) {
				this.redirects.forEach(function (redirect) {
					if (redirect.id == id) {
						newRedirects.push(redirect)
					}
				})
			}, this)
			this.updateRedirects(newRedirects)
		}
	},
	template: `<div>
	<div class="margin"></div>
	<input type="hidden" name="hostRedirectsJSON" :value="JSON.stringify(redirects)"/>
	<button class="ui button primary" @click.prevent="add()">
			<i class="pi pi-plus"></i>
			{{$t('http-host-redirect-box@创建')}}
	</button>
	<div class="margin"></div>

	<p class="comment" v-if="redirects.length == 0">{{$t('http-host-redirect-box@暂时还没有URL跳转规则')}}</p>
	<div v-show="redirects.length > 0">
		<b-sortable-table
			:columns="columns"
			:data-source="redirects"
			:row-key="'id'"
			:scroll="{ x: 1200 }"
			:on-sort="handleSort"
		>
			<template slot="handleSlot" slot-scope="{ text, record }">
        <i class="icon handle bars"></i>
      </template>
			
			<template slot="beforeSlot" slot-scope="{ text, record }">
				<div v-if="record.type == '' || record.type == 'url'">
					{{record.beforeURL}}
					<div style="margin-top: 0.4em">
						<grey-label><strong>{{$t('http-host-redirect-box@URL跳转')}}</strong></grey-label>
						<grey-label v-if="record.matchPrefix">{{$t('http-host-redirect-box@匹配前缀')}}</grey-label>
						<grey-label v-if="record.matchRegexp">{{$t('http-host-redirect-box@正则匹配')}}</grey-label>
						<grey-label v-if="!record.matchPrefix && !record.matchRegexp">{{$t('http-host-redirect-box@精准匹配')}}</grey-label>
						<grey-label v-if="record.exceptDomains != null && record.exceptDomains.length > 0" v-for="domain in record.exceptDomains">{{$t('http-host-redirect-box@排除')}}:{{domain}}</grey-label>
						<grey-label v-if="record.onlyDomains != null && record.onlyDomains.length > 0" v-for="domain in record.onlyDomains">{{$t('http-host-redirect-box@仅限')}}:{{domain}}</grey-label>
					</div>
				</div>
				<div v-if="record.type == 'domain'">
					<span v-if="record.domainsAll">{{$t('http-host-redirect-box@所有域名')}}</span>
					<span v-if="!record.domainsAll && record.domainsBefore != null">
						<span v-if="record.domainsBefore.length == 1">{{record.domainsBefore[0]}}</span>
						<span v-if="record.domainsBefore.length > 1" v-html="$t('http-host-redirect-box@等N个域名', [record.domainsBefore[0], record.domainsBefore.length])"></span>
					</span>
					<div style="margin-top: 0.4em">
						<grey-label><strong>{{$t('createPopup@域名跳转')}}</strong></grey-label>
						<grey-label v-if="record.domainAfterScheme != null && record.domainAfterScheme.length > 0">{{record.domainAfterScheme}}</grey-label>
						<grey-label v-if="record.domainBeforeIgnorePorts">{{$t('http-host-redirect-box@忽略端口')}}</grey-label>
					</div>
				</div>
				<div v-if="record.type == 'port'">
					<span v-if="record.portsAll">{{$t('http-host-redirect-box@所有端口')}}</span>
					<span v-if="!record.portsAll && record.portsBefore != null">
						<span v-if="record.portsBefore.length <= 5">{{record.portsBefore.join(", ")}}</span>
						<span v-if="record.portsBefore.length > 5" v-html="$t('http-host-redirect-box@等N个端口', [record.portsBefore.slice(0, 5).join(', '), record.portsBefore.length])"></span>
					</span>
					<div style="margin-top: 0.4em">
						<grey-label><strong>{{$t('http-host-redirect-box@端口跳转')}}</strong></grey-label>
						<grey-label v-if="record.portAfterScheme != null && record.portAfterScheme.length > 0">{{record.portAfterScheme}}</grey-label>
					</div>
				</div>
				
				<div style="margin-top: 0.5em" v-if="record.conds != null && record.conds.groups != null && record.conds.groups.length > 0">
					<grey-label>{{$t('http-host-redirect-box@匹配条件')}}</grey-label>
				</div>
			</template>

			<template slot="arrowSlot" slot-scope="{ text, record }">
				-&gt;
			</template>

			<template slot="afterSlot" slot-scope="{ text, record }">
				<span v-if="record.type == '' || record.type == 'url'">{{record.afterURL}}</span>
				<span v-if="record.type == 'domain'">{{record.domainAfter}}</span>
				<span v-if="record.type == 'port'">{{record.portAfter}}</span>
			</template>

			<template slot="statusSlot" slot-scope="{ text, record }">
				<span v-if="record.status > 0">{{record.status}}</span>
				<span v-else class="disabled">{{$t('http-host-redirect-box@默认')}}</span>
			</template>

			<template slot="isOnSlot" slot-scope="{ text, record }">
				<label-on :v-is-on="record.isOn"></label-on>
			</template>

			<template slot="operationSlot" slot-scope="{ text, record, index }">
				<a-button type="link" @click.prevent="update(index, record)">
					<i class="pi pi-pen-to-square" style="font-size: 12px; padding: 4px;"></i>
					{{$t('http-host-redirect-box@修改')}}
				</a-button>
				<a-button type="link" @click.prevent="remove(index)">
					<i class="pi pi-trash" style="font-size: 12px; padding: 4px;"></i>
					{{$t('http-host-redirect-box@删除')}}
				</a-button>
			</template>
		</b-sortable-table>
		<p class="comment" v-if="redirects.length > 1" v-html="$t('http-host-redirect-box@排序提示')"></p>
	</div>
	<div class="margin"></div>
</div>`
})

// 单个缓存条件设置
Vue.component("http-cache-ref-box", {
	props: ["v-cache-ref", "v-is-reverse"],
	mounted: function () {
		this.$refs.variablesDescriber.update(this.ref.key)
		if (this.ref.simpleCond != null) {
			this.condType = this.ref.simpleCond.type
			this.changeCondType(this.ref.simpleCond.type, true)
			this.condCategory = "simple"
		} else if (this.ref.conds != null && this.ref.conds.groups != null) {
			this.condCategory = "complex"
		}
		this.changeCondCategory(this.condCategory)
	},
	data: function () {
		let ref = this.vCacheRef
		if (ref == null) {
			ref = {
				isOn: true,
				cachePolicyId: 0,
				key: "${scheme}://${host}${requestPath}${isArgs}${args}",
				life: {count: 1, unit: "day"},
				status: [200],
				maxSize: {count: 128, unit: "mb"},
				minSize: {count: 0, unit: "kb"},
				skipCacheControlValues: ["private", "no-cache", "no-store"],
				skipSetCookie: true,
				enableRequestCachePragma: false,
				conds: null, // 复杂条件
				simpleCond: null, // 简单条件
				allowChunkedEncoding: true,
				allowPartialContent: true,
				forcePartialContent: false,
				enableIfNoneMatch: false,
				enableIfModifiedSince: false,
				enableReadingOriginAsync: false,
				isReverse: this.vIsReverse,
				methods: [],
				expiresTime: {
					isPrior: false,
					isOn: false,
					overwrite: true,
					autoCalculate: true,
					duration: {count: -1, "unit": "hour"}
				}
			}
		}
		if (ref.key == null) {
			ref.key = ""
		}
		if (ref.methods == null) {
			ref.methods = []
		}

		if (ref.life == null) {
			ref.life = {count: 2, unit: "hour"}
		}
		if (ref.maxSize == null) {
			ref.maxSize = {count: 32, unit: "mb"}
		}
		if (ref.minSize == null) {
			ref.minSize = {count: 0, unit: "kb"}
		}

		let condType = "url-extension"
		let condComponent = window.REQUEST_COND_COMPONENTS.$find(function (k, v) {
			return v.type == "url-extension"
		})

		return {
			ref: ref,

			keyIgnoreArgs: typeof ref.key == "string" && ref.key.indexOf("${args}") < 0,

			moreOptionsVisible: false,

			condCategory: "simple", // 条件分类：simple|complex
			condType: condType,
			condComponent: condComponent,
			condIsCaseInsensitive: (ref.simpleCond != null) ? ref.simpleCond.isCaseInsensitive : true,

			components: window.REQUEST_COND_COMPONENTS
		}
	},
	watch: {
		keyIgnoreArgs: function (b) {
			if (typeof this.ref.key != "string") {
				return
			}
			if (b) {
				this.ref.key = this.ref.key.replace("${isArgs}${args}", "")
				return;
			}
			if (this.ref.key.indexOf("${isArgs}") < 0) {
				this.ref.key = this.ref.key + "${isArgs}"
			}
			if (this.ref.key.indexOf("${args}") < 0) {
				this.ref.key = this.ref.key + "${args}"
			}
		}
	},
	methods: {
		changeOptionsVisible: function (v) {
			this.moreOptionsVisible = v
		},
		changeLife: function (v) {
			this.ref.life = v
		},
		changeMaxSize: function (v) {
			this.ref.maxSize = v
		},
		changeMinSize: function (v) {
			this.ref.minSize = v
		},
		changeConds: function (v) {
			this.ref.conds = v
			this.ref.simpleCond = null
		},
		changeStatusList: function (list) {
			let result = []
			list.forEach(function (status) {
				let statusNumber = parseInt(status)
				if (isNaN(statusNumber) || statusNumber < 100 || statusNumber > 999) {
					return
				}
				result.push(statusNumber)
			})
			this.ref.status = result
		},
		changeMethods: function (methods) {
			this.ref.methods = methods.map(function (v) {
				return v.toUpperCase()
			})
		},
		changeKey: function (key) {
			this.$refs.variablesDescriber.update(key)
		},
		changeExpiresTime: function (expiresTime) {
			this.ref.expiresTime = expiresTime
		},

		// 切换条件类型
		changeCondCategory: function (condCategory) {
			this.condCategory = condCategory

			// resize window
			let dialog = window.parent.document.querySelector("*[role='dialog']")
			if (dialog == null) {
				return
			}
			switch (condCategory) {
				case "simple":
					dialog.style.width = "45em"
					break
				case "complex":
					let width = window.parent.innerWidth
					if (width > 1024) {
						width = 1024
					}

					dialog.style.width = width + "px"
					if (this.ref.conds != null) {
						this.ref.conds.isOn = true
					}
					break
			}
		},
		changeCondType: function (condType, isInit) {
			if (!isInit && this.ref.simpleCond != null) {
				this.ref.simpleCond.value = null
			}
			let def = this.components.$find(function (k, component) {
				return component.type == condType
			})
			if (def != null) {
				this.condComponent = def
			}
		}
	},
	template: `<tbody>
	<tr v-if="condCategory == 'simple'">
		<td class="title">缓存对象 *</td>
		<td>
			<b-select
				id="adminId"
				name="condType"
				v-model="condType"
				@change="changeCondType(condType, false)"
				auto-width
				:options="[
					{label: $t('http-cache-ref-box@文件扩展名'), value: 'url-extension'},
					{label: $t('http-cache-ref-box@首页'), value: 'url-eq-index'},
					{label: $t('http-cache-ref-box@全站'), value: 'url-all'},
					{label: $t('http-cache-ref-box@URL目录前缀'), value: 'url-prefix'},
					{label: $t('http-cache-ref-box@URL完整路径'), value: 'url-eq'},
					{label: $t('http-cache-ref-box@URL通配符'), value: 'url-wildcard-match'},
					{label: $t('http-cache-ref-box@URL正则匹配'), value: 'url-regexp'},
					{label: $t('http-cache-ref-box@参数匹配'), value: 'params'},
				]"
			></b-select>

			<p class="comment"><a href="" @click.prevent="changeCondCategory('complex')">{{$t("http-cache-ref-box@切换到复杂条件")}} &raquo;</a></p>
		</td>
	</tr>
	<tr v-if="condCategory == 'simple'">
		<td>{{condComponent.paramsTitle}} *</td>
		<td>
			<component :is="condComponent.component" :v-cond="ref.simpleCond" v-if="condComponent.type != 'params'"></component>
			<table class="ui table" v-if="condComponent.type == 'params'">
				<component :is="condComponent.component" :v-cond="ref.simpleCond"></component>
			</table>
		</td>
	</tr>
	<tr v-if="condCategory == 'simple' && condComponent.caseInsensitive">
		<td>{{$t("http-cache-ref-box@不区分大小写")}}</td>
		<td>
			<checkbox v-model="condIsCaseInsensitive" :v-value="1" name="condIsCaseInsensitive"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@选中后忽略参数值大小写")}}</p>
		</td>
	</tr>
	<tr v-if="condCategory == 'complex'">
		<td class="title">{{$t("http-cache-ref-box@匹配条件分组")}} *</td>
		<td>
			<http-request-conds-box :v-conds="ref.conds" @change="changeConds"></http-request-conds-box>
			<p class="comment"><a href="" @click.prevent="changeCondCategory('simple')">&laquo; {{$t("http-cache-ref-box@切换到简单条件")}}</a></p>
		</td>
	</tr>
	<tr v-show="!vIsReverse">
		<td>{{$t("http-cache-ref-box@缓存有效期")}} *</td>
		<td>
			<time-duration-box :v-value="ref.life" @change="changeLife" :v-min-unit="'minute'" maxlength="4"></time-duration-box>
		</td>
	</tr>
	<tr v-show="!vIsReverse">
		<td>{{$t("http-cache-ref-box@忽略URI参数")}}</td>
		<td>
			<checkbox :v-value="1" v-model="keyIgnoreArgs"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@选中后Key不含URI参数")}}</p>
		</td>
	</tr>
	<tr v-show="!vIsReverse">
		<td colspan="2"><more-options-indicator @change="changeOptionsVisible"></more-options-indicator></td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@缓存Key")}} *</td>
		<td>
			<input type="text" v-model="ref.key" @input="changeKey(ref.key)"/>
			<p class="comment">{{$t("http-cache-ref-box@区分不同缓存内容的唯一Key")}}<request-variables-describer ref="variablesDescriber"></request-variables-describer>。</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@请求方法限制")}}</td>
		<td>
			<values-box size="5" maxlength="10" :values="ref.methods" @change="changeMethods"></values-box>
			<p class="comment">{{$t("http-cache-ref-box@允许请求的缓存方法说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@客户端过期时间Expires")}}<em>（Expires）</em></td>
		<td>
			<http-expires-time-config-box :v-expires-time="ref.expiresTime" @change="changeExpiresTime"></http-expires-time-config-box>		
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@可缓存的最大内容尺寸")}}</td>
		<td>
			<size-capacity-box :v-value="ref.maxSize" @change="changeMaxSize"></size-capacity-box>
			<p class="comment">{{$t("http-cache-ref-box@内容尺寸高于此值不缓存")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@可缓存的最小内容尺寸")}}</td>
		<td>
			<size-capacity-box :v-value="ref.minSize" @change="changeMinSize"></size-capacity-box>
			<p class="comment">{{$t("http-cache-ref-box@内容尺寸低于此值不缓存")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@支持缓存分片内容")}}</td>
		<td>
			<checkbox name="allowPartialContent" :v-value="1" v-model="ref.allowPartialContent"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@选中后支持缓存源站分片内容")}}<code-label>206 Partial Content</code-label>{{$t("http-cache-ref-box@状态码返回")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse && ref.allowPartialContent && !ref.alwaysForwardRangeReques">
		<td>{{$t("http-cache-ref-box@强制返回分片内容")}}</td>
		<td>
			<checkbox name="forcePartialContent" :v-value="1" v-model="ref.forcePartialContent"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@强制返回分片内容说明1")}}<code-label>Range</code-label>{{$t("http-cache-ref-box@强制返回分片内容说明2")}}<code-label>206 Partial Content</code-label>{{$t("http-cache-ref-box@强制返回分片内容说明3")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@强制Range回源")}}</td>
		<td>
			<checkbox :v-value="1" v-model="ref.alwaysForwardRangeRequest"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@强制Range回源说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@状态码列表")}}</td>
		<td>
			<values-box name="statusList" size="3" maxlength="3" :values="ref.status" @change="changeStatusList"></values-box>
			<p class="comment">{{$t("http-cache-ref-box@允许缓存的HTTP状态码列表")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@跳过的CacheControl值")}}</td>
		<td>
			<values-box name="skipResponseCacheControlValues" size="10" maxlength="100" :values="ref.skipCacheControlValues"></values-box>
			<p class="comment">{{$t("http-cache-ref-box@跳过的CacheControl值说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@跳过SetCookie")}}</td>
		<td>
			<checkbox :v-value="1" v-model="ref.skipSetCookie"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@跳过SetCookie说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@支持请求no-cache刷新")}}</td>
		<td>
			<checkbox v-model="ref.enableRequestCachePragma" name="enableRequestCachePragma" :v-value="1"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@支持请求no-cache刷新说明")}}</p>
		</td>
	</tr>	
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@允许IfNoneMatch回源")}}</td>
		<td>
			<checkbox :v-value="1" v-model="ref.enableIfNoneMatch"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@允许IfNoneMatch回源说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@允许IfModifiedSince回源")}}</td>
		<td>
			<checkbox :v-value="1" v-model="ref.enableIfModifiedSince"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@允许IfModifiedSince回源说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@允许异步读取源站")}}</td>
		<td>
			<checkbox :v-value="1" v-model="ref.enableReadingOriginAsync"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@允许异步读取源站说明")}}</p>
		</td>
	</tr>
	<tr v-show="moreOptionsVisible && !vIsReverse">
		<td>{{$t("http-cache-ref-box@支持分段内容")}}</td>
		<td>
			<checkbox name="allowChunkedEncoding" :v-value="1" v-model="ref.allowChunkedEncoding"></checkbox>
			<p class="comment">{{$t("http-cache-ref-box@支持分段内容说明")}}</p>
		</td>
	</tr>
	<tr v-show="false">
		<td colspan="2"><input type="hidden" name="cacheRefJSON" :value="JSON.stringify(ref)"/></td>
	</tr>
</tbody>`
})

Vue.component("http-firewall-region-selector", {
	props: ["v-type", "v-countries"],
	data: function () {
		let countries = this.vCountries
		if (countries == null) {
			countries = []
		}

		return {
			listType: this.vType,
			countries: countries
		}
	},
	methods: {
		addCountry: function () {
			let selectedCountryIds = this.countries.map(function (country) {
				return country.id
			})
			let that = this
			teaweb.popup("/servers/server/settings/waf/ipadmin/selectCountriesPopup?type=" + this.listType + "&selectedCountryIds=" + selectedCountryIds.join(","), {
				title: this.$t("server_http-firewall-region-selector@选择区域"),
				width: "52em",
				height: "30em",
				callback: function (resp) {
					that.countries = resp.data.selectedCountries
					that.$forceUpdate()
					that.notifyChange()
				}
			})
		},
		removeCountry: function (index) {
			this.countries.$remove(index)
			this.notifyChange()
		},
		resetCountries: function () {
			this.countries = []
			this.notifyChange()
		},
		notifyChange: function () {
			this.$emit("change", {
				"countries": this.countries
			})
		}
	},
	template: `<div>
	<span v-if="countries.length == 0" class="disabled">{{$t("server_http-firewall-region-selector@暂时没有选择")}}<span v-if="listType =='allow'">{{$t("server_http-firewall-region-selector@允许")}}</span><span v-else>{{$t("server_http-firewall-region-selector@封禁")}}</span>{{$t("server_http-firewall-region-selector@的区域")}}</span>
	<div v-show="countries.length > 0">
		<div class="ui label tiny basic" v-for="(country, index) in countries" style="margin-bottom: 0.5em">
			<input type="hidden" :name="listType + 'CountryIds'" :value="country.id"/>
			({{country.letter}}){{country.name}} <a href="" @click.prevent="removeCountry(index)" :title="$t('server_http-firewall-region-selector@删除')"><i class="icon remove"></i></a>
		</div>
	</div>
	<div class="ui divider"></div>
	<button type="button" class="ui button tiny" @click.prevent="addCountry">{{$t("server_http-firewall-region-selector@修改")}}</button> &nbsp; <button type="button" class="ui button tiny" v-show="countries.length > 0" @click.prevent="resetCountries">{{$t("server_http-firewall-region-selector@清空")}}</button>
</div>`
})

Vue.component("script-config-box", {
	props: ["id", "v-script-config", "comment", "v-auditing-status"],
	mounted: function () {
		let that = this
		setTimeout(function () {
			that.$forceUpdate()
		}, 100)
	},
	data: function () {
		let config = this.vScriptConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				code: "",
				auditingCode: ""
			}
		}

		let auditingStatus = null
		if (config.auditingCodeMD5 != null && config.auditingCodeMD5.length > 0 && config.auditingCode != null && config.auditingCode.length > 0) {
			config.code = config.auditingCode

			if (this.vAuditingStatus != null) {
				for (let i = 0; i < this.vAuditingStatus.length; i++) {
					let status = this.vAuditingStatus[i]
					if (status.md5 == config.auditingCodeMD5) {
						auditingStatus = status
						break
					}
				}
			}
		}

		if (config.code.length == 0) {
			config.code = "\n\n\n\n"
		}

		return {
			config: config,
			auditingStatus: auditingStatus
		}
	},
	watch: {
		"config.isOn": function () {
			this.change()
		}
	},
	methods: {
		change: function () {
			this.$emit("change", this.config)
		},
		changeCode: function (code) {
			this.config.code = code
			this.change()
		},
		isPlus: function () {
			if (Tea == null || Tea.Vue == null) {
				return false
			}
			return Tea.Vue.teaIsPlus
		}
	},
	template: `<div>
	<table class="ui table definition selectable">
		<tbody>
			<tr>
				<td class="title">{{$t("script-config-box@启用脚本设置")}}</td>
				<td><checkbox :v-value="1" v-model="config.isOn"></checkbox></td>
			</tr>
		</tbody>
		<tbody>
			<tr :style="{opacity: !config.isOn ? 0.5 : 1}">
				<td>{{$t("script-config-box@脚本代码")}}</td>	
				<td>
					<p class="comment" v-if="auditingStatus != null">
						<span class="green" v-if="auditingStatus.isPassed">{{$t("script-config-box@管理员审核结果审核通过")}}</span>
						<span class="red" v-else-if="auditingStatus.isRejected">{{$t("script-config-box@管理员审核结果驳回驳回理由")}}{{auditingStatus.rejectedReason}}</span>
						<span class="red" v-else>{{$t("script-config-box@当前脚本将在审核后生效请耐心等待审核结果")}} <a href="/servers/user-scripts" target="_blank" v-if="isPlus()">{{$t("script-config-box@去审核")}}</a></span>
					</p>
					<p class="comment" v-if="auditingStatus == null"><span class="green">{{$t("script-config-box@管理员审核结果审核通过")}}</span></p>
					<source-code-box :id="id" type="text/javascript" :read-only="false" @change="changeCode">{{config.code}}</source-code-box>
					<p class="comment">{{comment}}</p>
				</td>
			</tr>
		</tbody>
	</table>
</div>`
})

Vue.component("http-firewall-js-cookie-options-viewer", {
	props: ["v-js-cookie-options"],
	mounted: function () {
		this.updateSummary()
	},
	data: function () {
		let options = this.vJsCookieOptions
		if (options == null) {
			options = {
				life: 0,
				maxFails: 0,
				failBlockTimeout: 0,
				failBlockScopeAll: false,
				scope: ""
			}
		}
		return {
			options: options,
			summary: ""
		}
	},
	methods: {
		updateSummary: function () {
			let summaryList = []
			if (this.options.life > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@有效时间") + this.options.life + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.maxFails > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@最多失败") + this.options.maxFails + this.$t("http-firewall-captcha-options-viewer@次"))
			}
			if (this.options.failBlockTimeout > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@失败拦截") + this.options.failBlockTimeout + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.failBlockScopeAll) {
				summaryList.push(this.$t("http-firewall-block-options-viewer@尝试全局封禁"))
			}

			if (summaryList.length == 0) {
				this.summary = this.$t("http-firewall-captcha-options-viewer@默认配置")
			} else {
				this.summary = summaryList.join(" / ")
			}
		}
	},
	template: `<div>{{summary}}</div>
`
})

Vue.component("http-firewall-captcha-options-viewer", {
	props: ["v-captcha-options"],
	mounted: function () {
		this.updateSummary()
	},
	data: function () {
		let options = this.vCaptchaOptions
		if (options == null) {
			options = {
				life: 0,
				maxFails: 0,
				failBlockTimeout: 0,
				failBlockScopeAll: false,
				uiIsOn: false,
				uiTitle: "",
				uiPrompt: "",
				uiButtonTitle: "",
				uiShowRequestId: false,
				uiCss: "",
				uiFooter: "",
				uiBody: "",
				cookieId: "",
				lang: ""
			}
		}
		return {
			options: options,
			summary: "",
			captchaTypes: window.WAF_CAPTCHA_TYPES
		}
	},
	methods: {
		updateSummary: function () {
			let summaryList = []
			if (this.options.life > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@有效时间") + this.options.life + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.maxFails > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@最多失败") + this.options.maxFails + this.$t("http-firewall-captcha-options-viewer@次"))
			}
			if (this.options.failBlockTimeout > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@失败拦截") + this.options.failBlockTimeout + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.failBlockScopeAll) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@全局封禁"))
			}
			let that = this
			let typeDef = this.captchaTypes.$find(function (k, v) {
				return v.code == that.options.captchaType
			})
			if (typeDef != null) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@默认验证方式") + "：" + typeDef.name)
			}

			if (this.options.captchaType == "default") {
				if (this.options.uiIsOn) {
					summaryList.push(this.$t("http-firewall-captcha-options-viewer@定制UI"))
				}
			}

			if (this.options.geeTestConfig != null && this.options.geeTestConfig.isOn) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@已配置极验"))
			}

			if (summaryList.length == 0) {
				this.summary = this.$t("http-firewall-captcha-options-viewer@默认配置")
			} else {
				this.summary = summaryList.join(" / ")
			}
		}
	},
	template: `<div>{{summary}}</div>
`
})

// 请求限制
Vue.component("http-request-limit-config-box", {
	props: ["v-request-limit-config", "v-is-group", "v-is-location"],
	data: function () {
		let config = this.vRequestLimitConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				maxConns: 0,
				maxConnsPerIP: 0,
				maxBodySize: {
					count: -1,
					unit: "kb"
				},
				outBandwidthPerConn: {
					count: -1,
					unit: "kb"
				}
			}
		}
		return {
			config: config,
			maxConns: config.maxConns,
			maxConnsPerIP: config.maxConnsPerIP
		}
	},
	watch: {
		maxConns: function (v) {
			let conns = parseInt(v, 10)
			if (isNaN(conns)) {
				this.config.maxConns = 0
				return
			}
			if (conns < 0) {
				this.config.maxConns = 0
			} else {
				this.config.maxConns = conns
			}
		},
		maxConnsPerIP: function (v) {
			let conns = parseInt(v, 10)
			if (isNaN(conns)) {
				this.config.maxConnsPerIP = 0
				return
			}
			if (conns < 0) {
				this.config.maxConnsPerIP = 0
			} else {
				this.config.maxConnsPerIP = conns
			}
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="request-limit-box">
	<input type="hidden" name="requestLimitJSON" :value="JSON.stringify(config)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-if="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t("http-request-limit-config-box@基本设置")}}</span>
		</div>
		
		<prior-checkbox :v-config="config" class="config-item"></prior-checkbox>
	</div>
	
	<!-- 请求限制设置 -->
	<div class="config-section" v-show="(!vIsLocation && !vIsGroup) || config.isPrior">
		<div class="section-title">
			<i class="icon shield"></i>
			<span>{{$t("http-request-limit-config-box@请求限制设置")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-request-limit-config-box@启用请求限制")}}</div>
			<div class="item-content">
				<p-switch v-model="config.isOn" binary @change="submit"></p-switch>
			</div>
		</div>
	</div>
	
	<!-- 连接限制 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon plug"></i>
			<span>{{$t("http-request-limit-config-box@连接限制")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-request-limit-config-box@最大并发连接数")}}</div>
			<div class="item-content">
				<input type="text" maxlength="6" v-model="maxConns" @blur="submit"/>
				<p class="comment">{{$t('http-request-limit-config-box@当前网站最大并发连接数_超出此限制则响应用户')}}<code-label>429</code-label>{{$t('http-request-limit-config-box@代码_为0表示不限制')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-request-limit-config-box@单IP最大并发连接数")}}</div>
			<div class="item-content">
				<input type="text" maxlength="6" v-model="maxConnsPerIP" @blur="submit"/>
				<p class="comment">{{$t('http-request-limit-config-box@单IP最大连接数_统计单个IP总连接数时不区分服务_超出此限制则响应用户')}}<code-label>429</code-label>{{$t('http-request-limit-config-box@代码_为0表示不限制')}}<span v-if="maxConnsPerIP <= 3" class="red">{{$t('http-request-limit-config-box@当前设置的并发连接数过低_可能会影响正常用户访问_建议不小于3')}}</span></p>
			</div>
		</div>
	</div>
	
	<!-- 带宽和内容限制 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon exchange"></i>
			<span>{{$t("http-request-limit-config-box@带宽和内容限制")}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-request-limit-config-box@单连接带宽限制")}}</div>
			<div class="item-content">
				<size-capacity-box :v-value="config.outBandwidthPerConn" :v-supported-units="['byte', 'kb', 'mb']" @change="submit"></size-capacity-box>
				<p class="comment">{{$t("http-request-limit-config-box@客户端单个请求每秒可以读取的下行流量")}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t("http-request-limit-config-box@单请求最大尺寸")}}</div>
			<div class="item-content">
				<size-capacity-box :v-value="config.maxBodySize" :v-supported-units="['byte', 'kb', 'mb', 'gb']" @change="submit"></size-capacity-box>
				<p class="comment">{{$t("http-request-limit-config-box@单个请求能发送的最大内容尺寸")}}</p>
			</div>
		</div>
	</div>
</div>`
})

// 指标对象
Vue.component("metric-keys-config-box", {
	props: ["v-keys"],
	data: function () {
		let keys = this.vKeys
		if (keys == null) {
			keys = []
		}
		return {
			keys: keys,
			isAdding: false,
			key: "",
			subKey: "",
			keyDescription: "",

			keyDefs: window.METRIC_HTTP_KEYS
		}
	},
	watch: {
		keys: function () {
			this.$emit("change", this.keys)
		}
	},
	methods: {
		cancel: function () {
			this.key = ""
			this.subKey = ""
			this.keyDescription = ""
			this.isAdding = false
		},
		confirm: function () {
			if (this.key.length == 0) {
				return
			}

			if (this.key.indexOf(".NAME") > 0) {
				if (this.subKey.length == 0) {
					teaweb.warn("请输入参数值")
					return
				}
				this.key = this.key.replace(".NAME", "." + this.subKey)
			}
			this.keys.push(this.key)
			this.cancel()
		},
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				if (that.$refs.key != null) {
					that.$refs.key.focus()
				}
			}, 100)
		},
		remove: function (index) {
			this.keys.$remove(index)
		},
		changeKey: function () {
			if (this.key.length == 0) {
				return
			}
			let that = this
			let def = this.keyDefs.$find(function (k, v) {
				return v.code == that.key
			})
			if (def != null) {
				this.keyDescription = def.description
			}
		},
		keyName: function (key) {
			let that = this
			let subKey = ""
			let def = this.keyDefs.$find(function (k, v) {
				if (v.code == key) {
					return true
				}
				if (key.startsWith("${arg.") && v.code.startsWith("${arg.")) {
					subKey = that.getSubKey("arg.", key)
					return true
				}
				if (key.startsWith("${header.") && v.code.startsWith("${header.")) {
					subKey = that.getSubKey("header.", key)
					return true
				}
				if (key.startsWith("${cookie.") && v.code.startsWith("${cookie.")) {
					subKey = that.getSubKey("cookie.", key)
					return true
				}
				return false
			})
			if (def != null) {
				if (subKey.length > 0) {
					return def.name + ": " + subKey
				}
				return def.name
			}
			return key
		},
		getSubKey: function (prefix, key) {
			prefix = "${" + prefix
			let index = key.indexOf(prefix)
			if (index >= 0) {
				key = key.substring(index + prefix.length)
				key = key.substring(0, key.length - 1)
				return key
			}
			return ""
		}
	},
	template: `<div>
	<input type="hidden" name="keysJSON" :value="JSON.stringify(keys)"/>
	<div>
		<div v-for="(key, index) in keys" class="ui label small basic">
			{{keyName(key)}} &nbsp; <a href="" :title="$t('删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</div>
	</div>
	<div v-if="isAdding" style="margin-top: 1em">
		<div class="ui fields inline">
			<div class="ui field">
				<b-select
					v-model="key"
					@change="changeKey"
					auto-width
					:options="[
						{label: $t('metric-keys-config-box@选择对象'), value: ''},
						...keyDefs.map(def => ({
							label: def.name??'',
							value: def.code??'',
						}))
					]"
				></b-select>
			</div>
			<div class="ui field" v-if="key == '\${arg.NAME}'">
				<input type="text" v-model="subKey" :placeholder="$t('参数名')" size="15"/>
			</div>
			<div class="ui field" v-if="key == '\${header.NAME}'">
				<input type="text" v-model="subKey" :placeholder="$t('Header名')" size="15">
			</div>
			<div class="ui field" v-if="key == '\${cookie.NAME}'">
				<input type="text" v-model="subKey" :placeholder="$t('Cookie名')" size="15">
			</div>
			<div class="ui field">
				<button type="button" class="ui button tiny" @click.prevent="confirm">{{$t('确定')}}</button>
				<a href="" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<p class="comment" v-if="keyDescription.length > 0">{{keyDescription}}</p>
	</div>
	<div style="margin-top: 1em" v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("http-expires-time-config-box", {
	props: ["v-expires-time"],
	data: function () {
		let expiresTime = this.vExpiresTime
		if (expiresTime == null) {
			expiresTime = {
				isPrior: false,
				isOn: false,
				overwrite: true,
				autoCalculate: true,
				duration: {count: -1, "unit": "hour"}
			}
		}
		return {
			expiresTime: expiresTime
		}
	},
	watch: {
		"expiresTime.isPrior": function () {
			this.notifyChange()
		},
		"expiresTime.isOn": function () {
			this.notifyChange()
		},
		"expiresTime.overwrite": function () {
			this.notifyChange()
		},
		"expiresTime.autoCalculate": function () {
			this.notifyChange()
		}
	},
	methods: {
		notifyChange: function () {
			this.$emit("change", this.expiresTime)
		}
	},
	template: `<div>
	<table class="ui table">
		<prior-checkbox :v-config="expiresTime"></prior-checkbox>
		<tbody v-show="expiresTime.isPrior">
			<tr>
				<td class="title">{{$t("http-expires-time-config-box@启用")}}</td>
				<td><checkbox :v-value="1" v-model="expiresTime.isOn"></checkbox>
					<p class="comment">{{$t("http-expires-time-config-box@启用后将会在响应的Header中添加")}}<code-label>Expires</code-label>{{$t("http-expires-time-config-box@字段浏览器据此会将内容缓存在客户端同时在管理后台执行清理缓存时也将无法清理客户端已有的缓存")}}</p>
				</td>
			</tr>
			<tr v-show="expiresTime.isPrior && expiresTime.isOn">
				<td>{{$t("http-expires-time-config-box@覆盖源站设置")}}</td>
				<td>
					<checkbox :v-value="1" v-model="expiresTime.overwrite"></checkbox>
					<p class="comment">{{$t("http-expires-time-config-box@选中后会覆盖源站Header中已有的")}}<code-label>Expires</code-label>{{$t("http-expires-time-config-box@字段")}}</p>
				</td>
			</tr>
			<tr v-show="expiresTime.isPrior && expiresTime.isOn">
				<td>{{$t("http-expires-time-config-box@自动计算时间")}}</td>
				<td><checkbox :v-value="1" v-model="expiresTime.autoCalculate"></checkbox>
					<p class="comment">{{$t("http-expires-time-config-box@根据已设置的缓存有效期进行计算")}}</p>
				</td>
			</tr>
			<tr v-show="expiresTime.isPrior && expiresTime.isOn && !expiresTime.autoCalculate">
				<td>{{$t("http-expires-time-config-box@强制缓存时间")}}</td>
				<td>
					<time-duration-box :v-value="expiresTime.duration" @change="notifyChange"></time-duration-box>
					<p class="comment">{{$t("http-expires-time-config-box@从客户端访问的时间开始要缓存的时长")}}</p>
				</td>
			</tr>
		</tbody>
	</table>
</div>`
})

Vue.component("reverse-proxy-box", {
	props: ["v-reverse-proxy-ref", "v-reverse-proxy-config", "v-is-location", "v-family"],
	data: function () {
		let reverseProxyRef = this.vReverseProxyRef
		if (reverseProxyRef == null) {
			reverseProxyRef = {
				isPrior: false,
				isOn: false,
				reverseProxyId: 0
			}
		}

		let reverseProxyConfig = this.vReverseProxyConfig
		if (reverseProxyConfig == null) {
			reverseProxyConfig = {
				requestPath: "",
				stripPrefix: "",
				requestURI: "",
				requestHost: "",
				requestHostType: 0,
				addHeaders: [],
				requestHostExcludingPort: false,
				retry50X: false
			}
		} else if (reverseProxyConfig.addHeaders == null) {
			reverseProxyConfig.addHeaders = []
		}

		if (reverseProxyConfig.proxyProtocol == null) {
			// 如果直接赋值Vue将不会触发变更通知
			Vue.set(reverseProxyConfig, "proxyProtocol", {
				isOn: false,
				version: 1
			})
		}

		let forwardHeaders = [
			{
				name: "X-Real-IP",
				isChecked: false
			},
			{
				name: "X-Forwarded-For",
				isChecked: false
			},
			{
				name: "X-Forwarded-By",
				isChecked: false
			},
			{
				name: "X-Forwarded-Host",
				isChecked: false
			},
			{
				name: "X-Forwarded-Proto",
				isChecked: false
			}
		]
		forwardHeaders.forEach(function (v) {
			v.isChecked = reverseProxyConfig.addHeaders.$contains(v.name)
		})

		return {
			reverseProxyRef: reverseProxyRef,
			reverseProxyConfig: reverseProxyConfig,
			advancedVisible: true,
			forwardHeaders: forwardHeaders,
			family: this.vFamily
		}
	},
	watch: {
		"reverseProxyConfig.requestHostType": function (v) {
			let requestHostType = parseInt(v)
			if (isNaN(requestHostType)) {
				requestHostType = 0
			}
			this.reverseProxyConfig.requestHostType = requestHostType
		}
	},
	methods: {
		isOn: function () {
			return (!this.vIsLocation || this.reverseProxyRef.isPrior) && this.reverseProxyRef.isOn
		},
		changeAdvancedVisible: function (v) {
			this.advancedVisible = v
		},
		changeAddHeader: function () {
			this.reverseProxyConfig.addHeaders = this.forwardHeaders.filter(function (v) {
				return v.isChecked
			}).map(function (v) {
				return v.name
			})
			this.updateData()
		},
		updateData: function () {
			this.$emit("change",{
				reverseProxyRef: this.reverseProxyRef,
				reverseProxyConfig: this.reverseProxyConfig
			})
		}
	},
	template: `<div class="http-config-container">
	<input type="hidden" name="reverseProxyRefJSON" :value="JSON.stringify(reverseProxyRef)"/>
	<input type="hidden" name="reverseProxyJSON" :value="JSON.stringify(reverseProxyConfig)"/>
	
	<prior-checkbox :v-config="reverseProxyRef" v-if="vIsLocation"></prior-checkbox>
	
	<div class="config-item" v-show="!vIsLocation || reverseProxyRef.isPrior">
		<div class="item-label">{{$t('reverse-proxy-box@启用源站')}}</div>
		<div class="item-content">
			<div class="ui checkbox"> 
				<p-switch v-model="reverseProxyRef.isOn" binary @change="updateData"></p-switch>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()">
		<div class="config-item" v-show="family == null || family == 'http'">
			<div class="item-label" v-html="$t('reverse-proxy-box@回源主机名_Host')"></div>
			<div class="item-content">
				<radio :v-value="0" v-model="reverseProxyConfig.requestHostType" @change="updateData">{{$t('reverse-proxy-box@跟随CDN域名')}}</radio> &nbsp;
				<radio :v-value="1" v-model="reverseProxyConfig.requestHostType" @change="updateData">{{$t('reverse-proxy-box@跟随源站')}}</radio> &nbsp;
				<radio :v-value="2" v-model="reverseProxyConfig.requestHostType" @change="updateData">{{$t('reverse-proxy-box@自定义')}}</radio>
				<div v-show="reverseProxyConfig.requestHostType == 2" style="margin-top: 0.8em">
					<input type="text" :placeholder="$t('reverse-proxy-box@比如_example_com')" v-model="reverseProxyConfig.requestHost" @blur="updateData"/>
				</div>
				<p class="comment" v-html="$t('reverse-proxy-box@回源主机名提示', [ 
					reverseProxyConfig.requestHostType == 0 ? $t('reverse-proxy-box@跟随CDN域名提示') : '',
					reverseProxyConfig.requestHostType == 1 ? $t('reverse-proxy-box@跟随源站提示') : '',
					reverseProxyConfig.requestHostType == 2 ? $t('reverse-proxy-box@自定义提示') : ''
				])"></p>
			</div>
		</div>
		
		<div class="config-item" v-show="family == null || family == 'http'">
			<div class="item-label">{{$t('reverse-proxy-box@回源主机名移除端口')}}</div>
			<div class="item-content">
				<p-checkbox v-model="reverseProxyConfig.requestHostExcludingPort" binary @change="updateData"></p-checkbox> 
				<p class="comment">{{$t('reverse-proxy-box@回源主机名移除端口提示')}}</p>
			</div>
		</div>
		
		<div v-show="advancedVisible">
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label">{{$t('reverse-proxy-box@回源跟随')}}</div>
				<div class="item-content">
					<p-checkbox v-model="reverseProxyConfig.followRedirects" binary @change="updateData"></p-checkbox>
					<p class="comment">{{$t('reverse-proxy-box@回源跟随提示')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label">{{$t('reverse-proxy-box@自动添加的报头')}}</div>
				<div class="item-content">
					<div>
						<div style="width: 14em; float: left; margin-bottom: 1em" v-for="header in forwardHeaders" :key="header.name">
							<p-checkbox :id="header.name" v-model="header.isChecked" @change="changeAddHeader" binary></p-checkbox>
							<label :for="header.name">{{header.name}}</label>
						</div>
						<div style="clear: both;"></div>
					</div>
					<p class="comment">{{$t('reverse-proxy-box@自动添加报头提示')}}</p>
				</div> 
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label" v-html="$t('reverse-proxy-box@请求URI_RequestURI')"></div>
				<div class="item-content">
					<input type="text" placeholder="\${requestURI}" v-model="reverseProxyConfig.requestURI" @blur="updateData"/>
					<p class="comment" v-html="$t('reverse-proxy-box@请求URI提示')"></p>
				</div>
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label" v-html="$t('reverse-proxy-box@去除URL前缀_StripPrefix')"></div>
				<div class="item-content">
					<input type="text" v-model="reverseProxyConfig.stripPrefix" placeholder="/PREFIX" @blur="updateData"/>
					<p class="comment" v-html="$t('reverse-proxy-box@去除URL前缀提示')"></p>
				</div>
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label" v-html="$t('reverse-proxy-box@自动刷新缓存区_AutoFlush')"></div>
				<div class="item-content">
					<p-checkbox v-model="reverseProxyConfig.autoFlush" binary @change="updateData"></p-checkbox> 
					<p class="comment">{{$t('reverse-proxy-box@自动刷新缓存区提示')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label">{{$t('reverse-proxy-box@自动重试50X')}}</div>
				<div class="item-content">
					<p-checkbox v-model="reverseProxyConfig.retry50X" binary @change="updateData"></p-checkbox>
					<p class="comment">{{$t('reverse-proxy-box@自动重试50X提示')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="family == null || family == 'http'">
				<div class="item-label">{{$t('reverse-proxy-box@自动重试40X')}}</div>
				<div class="item-content">
					<p-checkbox v-model="reverseProxyConfig.retry40X" binary @change="updateData"></p-checkbox>
					<p class="comment">{{$t('reverse-proxy-box@自动重试40X提示')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="family != 'unix'">
				<div class="item-label">PROXY Protocol</div>
				<div class="item-content">
					<p-checkbox name="proxyProtocolIsOn" v-model="reverseProxyConfig.proxyProtocol.isOn" binary @change="updateData"></p-checkbox>
					<p class="comment">{{$t('reverse-proxy-box@PROXYProtocol提示')}}</p>
				</div>
			</div>
			
			<div class="config-item" v-show="family != 'unix' && reverseProxyConfig.proxyProtocol.isOn">
				<div class="item-label">{{$t('reverse-proxy-box@PROXYProtocol版本')}}</div>
				<div class="item-content">
					<b-select v-model="reverseProxyConfig.proxyProtocol.version" @change="updateData" :options="[
						{label:'1', value: 1},
						{label:'2', value: 2},
					]"></b-select>
					<p class="comment" v-if="reverseProxyConfig.proxyProtocol.version == 1">{{$t('reverse-proxy-box@PROXYProtocol版本1提示')}} <code-label>PROXY TCP4 192.168.1.1 192.168.1.10 32567 443</code-label> {{$t('reverse-proxy-box@PROXYProtocol版本1提示2')}}</p>
					<p class="comment" v-if="reverseProxyConfig.proxyProtocol.version == 2">{{$t('reverse-proxy-box@PROXYProtocol版本2提示')}}</p>
				</div>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("http-oss-bucket-params", {
	props: ["v-oss-config", "v-params", "name"],
	data: function () {
		let params = this.vParams
		if (params == null) {
			params = []
		}

		let ossConfig = this.vOssConfig
		if (ossConfig == null) {
			ossConfig = {
				bucketParam: "input",
				bucketName: "",
				bucketArgName: ""
			}
		} else {
			// 兼容以往
			if (ossConfig.bucketParam != null && ossConfig.bucketParam.length == 0) {
				ossConfig.bucketParam = "input"
			}
			if (ossConfig.options != null && ossConfig.options.bucketName != null && ossConfig.options.bucketName.length > 0) {
				ossConfig.bucketName = ossConfig.options.bucketName
			}
		}

		return {
			params: params,
			ossConfig: ossConfig
		}
	},
	template: `<tbody>
	<tr>
		<td>{{$t("server_http-oss-bucket-params-plus@s名称获取方式*", [name])}}</td>
		<td>
			<b-select
				name="bucketParam"
				v-model="ossConfig.bucketParam"
				auto-width
				:options="[
					...param.example.length == 0 ? [
						...params.map(param => ({
							label: param.name.replace(optionName, name),
							value: param.code??'',
						}))
					] : [
						...params.map(param => ({
							label: (param.name??'') + ' - ' + (param.example??''),
							value: param.code??'',
						}))
					],
				]"
			></b-select>

			<!--<select class="ui dropdown auto-width" name="bucketParam" v-model="ossConfig.bucketParam">
				<option v-for="param in params" :value="param.code" v-if="param.example.length == 0">{{param.name.replace("\${optionName}", name)}}</option>
				<option v-for="param in params" :value="param.code" v-if="param.example.length > 0">{{param.name}} - {{param.example}}</option>
			</select>-->
			<p class="comment" v-for="param in params" v-if="param.code == ossConfig.bucketParam">{{param.description.replace("\${optionName}", name)}}</p>
		</td>
	</tr>
    <tr v-if="ossConfig.bucketParam == 'input'">
        <td>{{$t("server_http-oss-bucket-params-plus@s名称*", [name])}}</td>
        <td>
            <input type="text" name="bucketName" maxlength="100" v-model="ossConfig.bucketName"/>
            <p class="comment">{{$t("server_http-oss-bucket-params-plus@s名称类似于", [name])}}<code-label>bucket-12345678</code-label>。</p>
        </td>
    </tr>
    <tr v-if="ossConfig.bucketParam == 'arg'">
    	<td>{{$t("server_http-oss-bucket-params-plus@s参数名称*", [name])}}</td>
        <td>
            <input type="text" name="bucketArgName" maxlength="100" v-model="ossConfig.bucketArgName"/>
            <p class="comment">{{$t("server_http-oss-bucket-params-plus@s参数名称比如", [name])}}<code-label>?myBucketName=BUCKET-NAME</code-label>{{$t("server_http-oss-bucket-params-plus@中的")}}<code-label>myBucketName</code-label>。</p>
        </td>
	</tr>
</tbody>`
})

Vue.component("http-firewall-js-cookie-options", {
	props: ["v-js-cookie-options"],
	mounted: function () {
		this.updateSummary()
	},
	data: function () {
		let options = this.vJsCookieOptions
		if (options == null) {
			options = {
				life: 0,
				maxFails: 0,
				failBlockTimeout: 0,
				failBlockScopeAll: false,
				scope: "service"
			}
		}

		return {
			options: options,
			isEditing: false,
			summary: ""
		}
	},
	watch: {
		"options.life": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.life = i
			this.updateSummary()
		},
		"options.maxFails": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.maxFails = i
			this.updateSummary()
		},
		"options.failBlockTimeout": function (v) {
			let i = parseInt(v, 10)
			if (isNaN(i)) {
				i = 0
			}
			this.options.failBlockTimeout = i
			this.updateSummary()
		},
		"options.failBlockScopeAll": function (v) {
			this.updateSummary()
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		},
		updateSummary: function () {
			let summaryList = []
			if (this.options.life > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@有效时间") + this.options.life + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.maxFails > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@最多失败") + this.options.maxFails + this.$t("http-firewall-captcha-options-viewer@次"))
			}
			if (this.options.failBlockTimeout > 0) {
				summaryList.push(this.$t("http-firewall-captcha-options-viewer@失败拦截") + this.options.failBlockTimeout + this.$t("http-firewall-captcha-options-viewer@秒"))
			}
			if (this.options.failBlockScopeAll) {
				summaryList.push(this.$t("http-firewall-block-options-viewer@尝试全局封禁"))
			}

			if (summaryList.length == 0) {
				this.summary = this.$t("http-firewall-captcha-options-viewer@默认配置")
			} else {
				this.summary = summaryList.join(" / ")
			}
		},
		confirm: function () {
			this.isEditing = false
		}
	},
	template: `<div>
	<input type="hidden" name="jsCookieOptionsJSON" :value="JSON.stringify(options)"/>
	<a href="" @click.prevent="edit">{{summary}} <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
	<div v-show="isEditing" style="margin-top: 0.5em">
		<table class="ui table definition selectable">
			<tbody>
				<tr>
					<td class="title">{{$t("http-firewall-captcha-options-viewer@有效时间")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.life" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("http-firewall-captcha-options-viewer@秒")}}</span>
						</div>
						<p class="comment">{{$t("http-firewall-js-cookie-options@验证通过后在这个时间内不再验证默认3600秒")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("http-firewall-js-cookie-options@最多失败次数")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.maxFails" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("http-firewall-captcha-options-viewer@次")}}</span>
						</div>
						<p class="comment"><span v-if="options.maxFails > 0 && options.maxFails < 5" class="red">{{$t("http-firewall-js-cookie-options@建议填入一个不小于5的数字以减少误判几率")}}</span>{{$t("http-firewall-js-cookie-options@允许用户失败尝试的最多次数超过这个次数将被自动加入黑名单如果为空或者为0表示不限制")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("http-firewall-js-cookie-options@失败拦截时间")}}</td>
					<td>
						<div class="ui input right labeled">
							<input type="text" style="width: 5em" maxlength="9" v-model="options.failBlockTimeout" @keyup.enter="confirm()" @keypress.enter.prevent="1"/>
							<span class="ui label">{{$t("http-firewall-captcha-options-viewer@秒")}}</span>
						</div>
						<p class="comment">{{$t("http-firewall-js-cookie-options@在达到最多失败次数大于0时自动拦截的时长如果为0表示不自动拦截")}}</p>
					</td>
				</tr>
				<tr>
					<td>{{$t("http-firewall-js-cookie-options@失败全局封禁")}}</td>
					<td>
						<checkbox :v-value="1" v-model="options.failBlockScopeAll"></checkbox>
						<p class="comment">{{$t("http-firewall-js-cookie-options@选中后表示允许系统尝试全局封禁某个IP以提升封禁性能")}}</p>
					</td>
				</tr>
			</tbody>
		</table>
	</div>
</div>
`
})

Vue.component("http-referers-config-box", {
	props: ["v-referers-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vReferersConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				allowEmpty: true,
				allowSameDomain: true,
				allowDomains: [],
				denyDomains: [],
				checkOrigin: true
			}
		}
		if (config.allowDomains == null) {
			config.allowDomains = []
		}
		if (config.denyDomains == null) {
			config.denyDomains = []
		}
		return {
			config: config,
			moreOptionsVisible: true
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		changeAllowDomains: function (domains) {
			if (typeof (domains) == "object") {
				this.config.allowDomains = domains
				this.$forceUpdate()
				this.submit()
			}
		},
		changeDenyDomains: function (domains) {
			if (typeof (domains) == "object") {
				this.config.denyDomains = domains
				this.$forceUpdate()
				this.submit()
			}
		},
		showMoreOptions: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="referers-box">
<input type="hidden" name="referersJSON" :value="JSON.stringify(config)"/>

<div class="config-section">
	<div class="section-title">
		<i class="icon shield alternate"></i>
		<span>{{$t('http-referers-config-box@防盗链设置')}}</span>
	</div>
	
	<div v-if="vIsLocation || vIsGroup" class="config-item">
		<prior-checkbox :v-config="config"></prior-checkbox>
	</div>
	
	<div v-show="(!vIsLocation && !vIsGroup) || config.isPrior" class="config-item">
		<div class="item-content">
			<checkbox value="1" v-model="config.isOn" binary @change="submit">{{$t('http-referers-config-box@启用防盗链')}}</checkbox> 
			<p class="comment">{{$t('http-referers-config-box@选中后表示开启防盗链')}}</p>
		</div>
	</div>
</div>

<div v-show="isOn()" class="config-section">
	<div class="section-title">
		<i class="icon globe"></i>
		<span>{{$t('http-referers-config-box@来源域名设置')}}</span>
	</div>
	
	<div class="config-item">
		<div class="item-content">
			<checkbox v-model="config.allowEmpty" binary @change="submit">{{$t('http-referers-config-box@允许直接访问网站')}}</checkbox>
			<p class="comment">{{$t('http-referers-config-box@允许用户直接访问网站用户第一次访问网站时来源域名通常为空')}}</p>
		</div>
	</div>
	
	<div class="config-item">
		<div class="item-content">
			<checkbox v-model="config.allowSameDomain" binary @change="submit">{{$t('http-referers-config-box@来源域名允许一致')}}</checkbox>
			<p class="comment">{{$t('http-referers-config-box@允许来源域名和当前访问的域名一致相当于在站内访问')}}</p>
		</div>
	</div>
	
	<div class="config-item">
		<div class="item-label">{{$t('http-referers-config-box@允许的来源域名')}}</div>
		<div class="item-content">
			<domains-box :v-domains="config.allowDomains" @change="changeAllowDomains"></domains-box>
			<p class="comment">{{$t('http-referers-config-box@允许的来源域名列表比如_example_com_example_com_单个星号_表示允许所有域名')}}<code-label>example.com</code-label>、<code-label>*.example.com</code-label>。{{$t('http-referers-config-box@单个星号')}}<code-label>*</code-label>{{$t('http-referers-config-box@表示允许所有域名')}}。</p>
		</div>
	</div>
	
	<div class="config-item">
		<div class="item-label">{{$t('http-referers-config-box@禁止的来源域名')}}</div>
		<div class="item-content">
			<domains-box :v-domains="config.denyDomains" @change="changeDenyDomains"></domains-box>
			<p class="comment">{{$t('http-referers-config-box@禁止的来源域名列表比如_example_org_example_org_除了这些禁止的来源域名外其他域名都会被允许除非限定了允许的来源域名')}}<code-label>example.org</code-label>、<code-label>*.example.org</code-label>；{{$t('http-referers-config-box@除了这些禁止的来源域名外其他域名都会被允许除非限定了允许的来源域名')}}。</p>
		</div>
	</div>
</div>

<div v-show="moreOptionsVisible && isOn()" class="config-section">
	<div class="section-title">
		<i class="icon cog"></i>
		<span>{{$t('http-referers-config-box@高级选项')}}</span>
	</div>
	
	<div class="config-item">
		<div class="item-content">
			<checkbox v-model="config.checkOrigin" binary @change="submit">{{$t('http-referers-config-box@同时检查OriginHeader')}}</checkbox>
			<p class="comment">{{$t('http-referers-config-box@如果请求没有指定RefererHeader则尝试检查OriginHeader多用于跨站调用')}}</p>
		</div>
	</div>
	
	<div class="config-item">
		<div class="item-label">{{$t('http-referers-config-box@例外URL')}}</div>
		<div class="item-content">
			<url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
			<p class="comment">{{$t('http-referers-config-box@如果填写了例外URL表示这些URL不做处理')}}</p>
		</div>
	</div>
	
	<div class="config-item">
		<div class="item-label">{{$t('http-referers-config-box@限制URL')}}</div>
		<div class="item-content">
			<url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
			<p class="comment">{{$t('http-referers-config-box@如果填写了限制URL表示只对这些URL进行处理如果不填则表示支持所有的URL')}}</p>
		</div>
	</div>
</div>

<div class="ui margin"></div>
</div>`
})

Vue.component("http-pages-box", {
	props: ["v-pages"],
	data: function () {
		let pages = []
		if (this.vPages != null) {
			pages = this.vPages
		}

		return {
			pages: pages
		}
	},
	methods: {
		addPage: function () {
			let that = this
			teaweb.popup("/servers/server/settings/pages/createPopup", {
				title: this.$t("http-pages-box@添加自定义页面"),
				height: "26em",
				callback: function (resp) {
					that.pages.push(resp.data.page)
					that.notifyChange()
				}
			})
		},
		updatePage: function (pageIndex, pageId) {
			let that = this
			teaweb.popup("/servers/server/settings/pages/updatePopup?pageId=" + pageId, {
				title: this.$t("http-pages-box@修改自定义页面"),
				height: "26em",
				callback: function (resp) {
					Vue.set(that.pages, pageIndex, resp.data.page)
					that.notifyChange()
				}
			})
		},
		removePage: function (pageIndex) {
			let that = this
			teaweb.confirm(this.$t("http-pages-box@确定要移除此页面吗"), function () {
				that.pages.$remove(pageIndex)
				that.notifyChange()
			})
		},
		notifyChange: function () {
			let parent = this.$el.parentNode
			while (true) {
				if (parent == null) {
					break
				}
				if (parent.tagName == "FORM") {
					break
				}
				parent = parent.parentNode
			}
			if (parent != null) {
				setTimeout(function () {
					Tea.runActionOn(parent)
				}, 100)
			}
		}
	},
	template: `<div>
<input type="hidden" name="pagesJSON" :value="JSON.stringify(pages)"/>

<div v-if="pages.length > 0">
    <b-table
         :columns="[
            { title: $t('http-pages-box@响应状态码'), key: 'status', width: '10em', scopedSlots: { customRender: 'statusSlot' } },
            { title: $t('http-pages-box@页面类型'), key: 'bodyType', width: '20em', scopedSlots: { customRender: 'bodyTypeSlot' } },
            { title: $t('http-pages-box@新状态码'), key: 'newStatus', width: '8em', scopedSlots: { customRender: 'newStatusSlot' } },
            { title: $t('http-pages-box@例外URL'), key: 'exceptURLPatterns', scopedSlots: { customRender: 'exceptUrlSlot' } },
            { title: $t('http-pages-box@限制URL'), key: 'onlyURLPatterns', scopedSlots: { customRender: 'onlyUrlSlot' } },
            { title: $t('http-pages-box@操作'), key: 'action', width: '10em', scopedSlots: { customRender: 'actionSlot' } }
         ]"
        :data-source="pages"
        :row-key="'id'"
        :pagination="false"
    >
        <template slot="statusSlot" slot-scope="{ text, record, index }">
            <a href="" @click.prevent="updatePage(index, record.id)">
                <span v-if="record.status != null && record.status.length == 1">{{record.status[0]}}</span>
                <span v-else>{{record.status}}</span>
                <i class="icon expand small"></i>
            </a>
        </template>
        <template slot="bodyTypeSlot" slot-scope="{ text, record }">
             <div v-if="record.bodyType == 'url'">
                {{record.url}}
                <div>
                    <grey-label>{{$t("http-pages-box@读取URL")}}</grey-label>
                </div>
            </div>
            <div v-if="record.bodyType == 'redirectURL'">
                {{record.url}}
                <div>
                    <grey-label>{{$t("http-pages-box@跳转URL")}}</grey-label>    
                    <grey-label v-if="record.newStatus > 0">{{record.newStatus}}</grey-label>
                </div>
            </div>
            <div v-if="record.bodyType == 'html'">
                {{$t("http-pages-box@HTML内容")}}
                <div>
                    <grey-label v-if="record.newStatus > 0">{{record.newStatus}}</grey-label>
                </div>
            </div>
        </template>
        <template slot="newStatusSlot" slot-scope="{ text, record }">
             <span v-if="record.newStatus > 0">{{record.newStatus}}</span>
            <span v-else class="disabled">{{$t("http-pages-box@保持")}}</span> 
        </template>
        <template slot="exceptUrlSlot" slot-scope="{ text, record }">
            <div v-if="record.exceptURLPatterns != null && record.exceptURLPatterns.length > 0">
                <span v-for="urlPattern in record.exceptURLPatterns" class="ui basic label small" :key="urlPattern.pattern">{{urlPattern.pattern}}</span>
            </div>
            <span v-else class="disabled">-</span>
        </template>
        <template slot="onlyUrlSlot" slot-scope="{ text, record }">
            <div v-if="record.onlyURLPatterns != null && record.onlyURLPatterns.length > 0">
                <span v-for="urlPattern in record.onlyURLPatterns" class="ui basic label small" :key="urlPattern.pattern">{{urlPattern.pattern}}</span>
            </div>
            <span v-else class="disabled">-</span>
        </template>
         <template slot="actionSlot" slot-scope="{ text, record, index }">
            <a-button type="link" @click.prevent="updatePage(index, record.id)">{{$t("http-firewall-rules-box@修改")}}</a-button>
            <a-button type="link" danger @click.prevent="removePage(index)">{{$t("http-firewall-rules-box@删除")}}</a-button>
         </template>
    </b-table>
</div>
<div style="margin-top: 1em">
	<button class="ui button small" type="button" @click.prevent="addPage()">{{$t("http-pages-box@添加自定义页面Plus")}}</button>
</div>
<div class="ui margin"></div>
</div>`
})

Vue.component("http-firewall-page-options", {
	props: ["v-page-options"],
	data: function () {
		var defaultPageBody = `<!DOCTYPE html>
<html lang="en">
<head>
	<title>403 Forbidden</title>
	<style>
		address { line-height: 1.8; }
	</style>
</head>
<body>
<h1>403 Forbidden By WAF</h1>
<address>Connection: \${remoteAddr} (Client) -&gt; \${serverAddr} (Server)</address>
<address>Request ID: \${requestId}</address>
</body>
</html>`

		return {
			pageOptions: this.vPageOptions,
			status: this.vPageOptions.status,
			body: this.vPageOptions.body,
			defaultPageBody: defaultPageBody,
			isEditing: false
		}
	},
	watch: {
		status: function (v) {
			if (typeof v === "string" && v.length != 3) {
				return
			}
			let statusCode = parseInt(v)
			if (isNaN(statusCode)) {
				this.pageOptions.status = 403
			} else {
				this.pageOptions.status = statusCode
			}
		},
		body: function (v) {
			this.pageOptions.body = v
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		}
	},
	template: `<div>
	<input type="hidden" name="pageOptionsJSON" :value="JSON.stringify(pageOptions)"/>
	<a href="" @click.prevent="edit">{{$t("http-firewall-block-options-viewer@状态码")}}：{{status}} / {{$t("http-firewall-block-options-viewer@提示内容")}}：<span v-if="pageOptions.body != null && pageOptions.body.length > 0">[{{pageOptions.body.length}}{{$t("http-firewall-block-options-viewer@字符")}}]</span><span v-else class="disabled">[{{$t("http-firewall-block-options-viewer@无")}}]</span>
	 <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
	<table class="ui table" v-show="isEditing">
		<tr>
			<td class="title">{{$t("http-firewall-page-options@状态码星号")}}</td>
			<td><input type="text" style="width: 4em" maxlength="3" v-model="status"/></td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-page-options@网页内容")}}</td>
			<td>
				<textarea v-model="body"></textarea>
				<p class="comment"><a href="" @click.prevent="body = defaultPageBody">{{$t("http-firewall-page-options@使用模板")}}</a> </p>
			</td>
		</tr>
	</table>
</div>	
`
})

Vue.component("http-charsets-box", {
	props: ["v-usual-charsets", "v-all-charsets", "v-charset-config", "v-is-location", "v-is-group"],
	data: function () {
		let charsetConfig = this.vCharsetConfig
		if (charsetConfig == null) {
			charsetConfig = {
				isPrior: false,
				isOn: false,
				charset: "",
				isUpper: false,
				force: false
			}
		}
		return {
			charsetConfig: charsetConfig,
			advancedVisible: true
		}
	},
	methods: {
		changeAdvancedVisible: function (v) {
			this.advancedVisible = v
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.charsetConfig)
			}, 100)
		}
	},
	template: `<div class="charset-box">
	<input type="hidden" name="charsetJSON" :value="JSON.stringify(charsetConfig)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-if="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-charsets-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="charsetConfig" class="config-item"></prior-checkbox>
	</div>
	
	<!-- 字符编码设置 -->
	<div class="config-section" v-show="(!vIsLocation && !vIsGroup) || charsetConfig.isPrior">
		<div class="section-title">
			<i class="icon font"></i>
			<span>{{$t('http-charsets-box@字符编码设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-charsets-box@启用字符编码')}}</div>
			<div class="item-content">
				<p-switch v-model="charsetConfig.isOn" binary @change="submit"></p-switch>
				<p class="comment">{{$t('http-charsets-box@启用后_系统将按照设置的字符编码处理网站内容')}}</p>
			</div>
		</div>
		
		<div class="config-item" v-show="charsetConfig.isOn">
			<div class="item-label">{{$t('http-charsets-box@选择字符编码')}}</div>
			<div class="item-content">
				<b-select v-model="charsetConfig.charset" @change="submit" style="width:20em" name="charset" :options="[
					{label:$t('http-charsets-box@未选择'), value:''},
					...vUsualCharsets.map(charset => ({label: charset.charset + '（' + charset.name + '）', value: charset.charset})),
					...vAllCharsets.map(charset => ({label: charset.charset + '（' + charset.name + '）', value: charset.charset})),
				]"></b-select>
			</div>
		</div>
	</div>
	
	<!-- 高级选项 -->
	<div class="config-section" v-show="((!vIsLocation && !vIsGroup) || charsetConfig.isPrior) && charsetConfig.isOn && advancedVisible">
		<div class="section-title">
			<i class="icon sliders"></i>
			<span>{{$t('http-charsets-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-charsets-box@强制替换')}}</div>
			<div class="item-content">
				<p-checkbox v-model="charsetConfig.force" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-charsets-box@选中后_表示强制覆盖已经设置的字符集_不选中_表示如果源站已经设置了字符集_则保留不修改')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-charsets-box@字符编码大写')}}</div>
			<div class="item-content">
				<p-checkbox v-model="charsetConfig.isUpper" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-charsets-box@选中后将指定的字符编码转换为大写_比如默认为')}}<code-label>utf-8</code-label>{{$t('http-charsets-box@选中后将改为')}}<code-label>UTF-8</code-label></p>
			</div>
		</div>
	</div>
</div>`
})

// 压缩配置
Vue.component("http-compression-config-box", {
	props: ["v-compression-config", "v-is-location", "v-is-group"],
	mounted: function () {
		let that = this
		sortLoad(function () {
			that.initSortableTypes()
		})
	},
	data: function () {
		let config = this.vCompressionConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				useDefaultTypes: true,
				types: ["brotli", "gzip", "zstd", "deflate"],
				level: 0,
				decompressData: false,
				gzipRef: null,
				deflateRef: null,
				brotliRef: null,
				minLength: {count: 1, "unit": "kb"},
				maxLength: {count: 32, "unit": "mb"},
				mimeTypes: ["text/*", "application/javascript", "application/json", "application/atom+xml", "application/rss+xml", "application/xhtml+xml", "image/svg+xml"],
				extensions: [".js", ".json", ".html", ".htm", ".xml", ".css", ".woff2", ".txt"],
				exceptExtensions: [".apk", ".ipa"],
				conds: null,
				enablePartialContent: false,
				onlyURLPatterns: [],
				exceptURLPatterns: []
			}
		}

		if (config.types == null) {
			config.types = []
		}
		if (config.mimeTypes == null) {
			config.mimeTypes = []
		}
		if (config.extensions == null) {
			config.extensions = []
		}

		let allTypes = [
			{
				name: "Gzip",
				code: "gzip",
				isOn: true
			},
			{
				name: "Deflate",
				code: "deflate",
				isOn: true
			},
			{
				name: "Brotli",
				code: "brotli",
				isOn: true
			},
			{
				name: "ZSTD",
				code: "zstd",
				isOn: true
			}
		]

		let configTypes = []
		config.types.forEach(function (typeCode) {
			allTypes.forEach(function (t) {
				if (typeCode == t.code) {
					t.isOn = true
					configTypes.push(t)
				}
			})
		})
		allTypes.forEach(function (t) {
			if (!config.types.$contains(t.code)) {
				t.isOn = false
				configTypes.push(t)
			}
		})

		return {
			config: config,
			moreOptionsVisible: false,
			allTypes: configTypes
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior) && this.config.isOn
		},
		changeExtensions: function (values) {
			values.forEach(function (v, k) {
				if (v.length > 0 && v[0] != ".") {
					values[k] = "." + v
				}
			})
			this.config.extensions = values
		},
		changeExceptExtensions: function (values) {
			values.forEach(function (v, k) {
				if (v.length > 0 && v[0] != ".") {
					values[k] = "." + v
				}
			})
			this.config.exceptExtensions = values
			this.submit()
		},
		changeMimeTypes: function (values) {
			this.config.mimeTypes = values
			this.submit()
		},
		changeAdvancedVisible: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		changeConds: function (conds) {
			this.config.conds = conds
		},
		changeType: function () {
			this.config.types = []
			let that = this
			this.allTypes.forEach(function (v) {
				if (v.isOn) {
					that.config.types.push(v.code)
				}
			})
			this.submit()
		},
		initSortableTypes: function () {
			let box = document.querySelector("#compression-types-box")
			let that = this
			Sortable.create(box, {
				draggable: ".checkbox",
				handle: ".icon.handle",
				onStart: function () {

				},
				onUpdate: function (event) {
					let checkboxes = box.querySelectorAll(".checkbox")
					let codes = []
					checkboxes.forEach(function (checkbox) {
						let code = checkbox.getAttribute("data-code")
						codes.push(code)
					})
					that.config.types = codes
				}
			})
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="compression-box">
	<input type="hidden" name="compressionJSON" :value="JSON.stringify(config)"/>
	
	<div class="config-section">
		<div class="section-title">
			<i class="icon compress"></i>
			<span>{{$t('http-compression-config-box@压缩基本设置')}}</span>
		</div>
		
		<div v-if="vIsLocation || vIsGroup" class="config-item">
			<prior-checkbox :v-config="config"></prior-checkbox>
		</div>
		
		<div v-show="(!vIsLocation && !vIsGroup) || config.isPrior" class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@启用内容压缩')}}</div>
			<div class="item-content">
				<p-switch value="1" v-model="config.isOn" binary @change="submit"></p-switch>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon file"></i>
			<span>{{$t('http-compression-config-box@文件类型设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@支持的扩展名')}}</div>
			<div class="item-content">
				<values-box :values="config.extensions" @change="changeExtensions" :placeholder="$t('http-compression-config-box@比如_html')"></values-box>
				<p class="comment">{{$t('http-compression-config-box@含有这些扩展名的URL将会被压缩不区分大小写')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@例外扩展名')}}</div>
			<div class="item-content">
				<values-box :values="config.exceptExtensions" @change="changeExceptExtensions" :placeholder="$t('http-compression-config-box@比如_html')"></values-box>
				<p class="comment" v-html="$t('http-compression-config-box@含有这些扩展名的URL将不会被压缩不区分大小写')"></p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@支持的MimeType')}}</div>
			<div class="item-content">
				<values-box :values="config.mimeTypes" @change="changeMimeTypes" :placeholder="$t('http-compression-config-box@比如_text_')"></values-box>
				<p class="comment">{{$t('http-compression-config-box@响应的ContentType里包含这些MimeType的内容将会被压缩')}}</p>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon cog"></i>
			<span>{{$t('http-compression-config-box@压缩算法设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@压缩算法')}}</div>
			<div class="item-content">
				<div class="ui checkbox">
					<p-checkbox v-model="config.useDefaultTypes" id="compression-use-default" binary @change="submit"/>
					<label v-if="config.useDefaultTypes" for="compression-use-default">{{$t('http-compression-config-box@使用默认顺序')}}<span class="grey small">{{$t('http-compression-config-box@brotli_gzip_zstd_deflate')}}</span></label>
					<label v-if="!config.useDefaultTypes" for="compression-use-default">{{$t('http-compression-config-box@使用默认顺序')}}</label>
				</div>
				
				<div v-show="!config.useDefaultTypes" class="compression-types-container">
					<div class="ui divider"></div>
					<div id="compression-types-box" class="compression-types-box">
						<div class="ui checkbox" v-for="t in allTypes" :data-code="t.code">
							<p-checkbox v-model="t.isOn" :id="'compression-type-' + t.code" @change="changeType" binary/>
							<label :for="'compression-type-' + t.code">{{t.name}} &nbsp; <i class="icon list small grey handle"></i></label>
						</div>
					</div>
					
					<p class="comment" v-html="$t('http-compression-config-box@选择支持的压缩算法和优先顺序拖动_i_class_icon_list_small_grey_i_图表排序')"></p>
				</div>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@支持已压缩内容')}}</div>
			<div class="item-content">
				<p-checkbox v-model="config.decompressData" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-compression-config-box@支持对已压缩内容尝试重新使用新的算法压缩不选中表示保留当前的压缩格式')}}</p>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon sliders horizontal"></i>
			<span>{{$t('http-compression-config-box@内容长度设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@内容最小长度')}}</div>
			<div class="item-content">
				<size-capacity-box :v-name="'minLength'" :v-value="config.minLength" :v-unit="'kb'" @change="(v) => { config.minLength = v }"></size-capacity-box>
				<p class="comment">{{$t('http-compression-config-box@0表示不限制内容长度从文件尺寸或ContentLength中获取')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@内容最大长度')}}</div>
			<div class="item-content">
				<size-capacity-box :v-name="'maxLength'" :v-value="config.maxLength" :v-unit="'mb'" @change="(v) => { config.maxLength = v }"></size-capacity-box>
				<p class="comment">{{$t('http-compression-config-box@0表示不限制内容长度从文件尺寸或ContentLength中获取')}}</p>
			</div>
		</div>
	</div>
	
	<div v-show="isOn()" class="config-section">
		<div class="section-title">
			<i class="icon cog"></i>
			<span>{{$t('http-compression-config-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label" v-html="$t('http-compression-config-box@支持Partial_br_Content')"></div>
			<div class="item-content">
				<p-checkbox v-model="config.enablePartialContent" binary @change="submit"></p-checkbox>
				<p class="comment">{{$t('http-compression-config-box@支持对分片内容PartialContent的压缩除非客户端有特殊要求一般不需要启用')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@例外URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('http-compression-config-box@如果填写了例外URL表示这些URL跳过不做处理')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@限制URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('http-compression-config-box@如果填写了限制URL表示只对这些URL进行压缩处理如果不填则表示支持所有的URL')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-compression-config-box@匹配条件')}}</div>
			<div class="item-content">
				<http-request-conds-box :v-conds="config.conds" @change="changeConds" @submit="submit"></http-request-conds-box>
			</div>
		</div>
	</div>
	
	<div class="margin"></div>
</div>`
})

Vue.component("http-cache-refs-config-box", {
	props: ["v-cache-refs", "v-cache-config", "v-cache-policy-id", "v-web-id", "v-max-bytes"],
	mounted: function () {
		let that = this
		sortTable(function (ids) {
			let newRefs = []
			ids.forEach(function (id) {
				that.refs.forEach(function (ref) {
					if (ref.id == id) {
						newRefs.push(ref)
					}
				})
			})
			that.updateRefs(newRefs)
			that.change()
		})
	},
	data: function () {
		let refs = this.vCacheRefs
		if (refs == null) {
			refs = []
		}

		let maxBytes = this.vMaxBytes

		let id = 0
		refs.forEach(function (ref) {
			id++
			ref.id = id

			// check max size
			if (ref.maxSize != null && maxBytes != null && maxBytes.count > 0 && teaweb.compareSizeCapacity(ref.maxSize, maxBytes) > 0) {
				ref.overMaxSize = maxBytes
			}
		})
		return {
			refs: refs,
			id: id // 用来对条件进行排序
		}
	},
	methods: {
		addRef: function (isReverse) {
			window.UPDATING_CACHE_REF = null

			let height = window.innerHeight
			if (height > 500) {
				height = 500
			}
			let that = this
			teaweb.popup("/servers/server/settings/cache/createPopup?isReverse=" + (isReverse ? 1 : 0), {
				title: this.$t('server_http-cache-refs-config-box@创建缓存条件'),
				height: height + "px",
				callback: function (resp) {
					let newRef = resp.data.cacheRef
					if (newRef.conds == null) {
						return
					}

					that.id++
					newRef.id = that.id

					if (newRef.isReverse) {
						let newRefs = []
						let isAdded = false
						that.refs.forEach(function (v) {
							if (!v.isReverse && !isAdded) {
								newRefs.push(newRef)
								isAdded = true
							}
							newRefs.push(v)
						})
						if (!isAdded) {
							newRefs.push(newRef)
						}

						that.updateRefs(newRefs)
					} else {
						that.refs.push(newRef)
					}

					// move to bottom
					var afterChangeCallback = function () {
						setTimeout(function () {
							let rightBox = document.querySelector(".right-box")
							if (rightBox != null) {
								rightBox.scrollTo(0, isReverse ? 0 : 100000)
							}
						}, 100)
					}

					that.change(afterChangeCallback)
				}
			})
		},
		updateRef: function (index, cacheRef) {
			window.UPDATING_CACHE_REF = teaweb.clone(cacheRef)

			let height = window.innerHeight
			if (height > 500) {
				height = 500
			}
			let that = this
			teaweb.popup("/servers/server/settings/cache/createPopup", {
				title: this.$t('server_http-cache-refs-config-box@修改缓存条件'),
				height: height + "px",
				callback: function (resp) {
					resp.data.cacheRef.id = that.refs[index].id
					Vue.set(that.refs, index, resp.data.cacheRef)
					that.change()
					that.$refs.cacheRef[index].updateConds(resp.data.cacheRef.conds, resp.data.cacheRef.simpleCond)
					that.$refs.cacheRef[index].notifyChange()
				}
			})
		},
		disableRef: function (ref) {
			ref.isOn = false
			this.change()
		},
		enableRef: function (ref) {
			ref.isOn = true
			this.change()
		},
		removeRef: function (index) {
			let that = this
			teaweb.confirm(this.$t('server_http-cache-refs-config-box@确定要删除此缓存设置吗'), function () {
				that.refs.$remove(index)
				that.change()
			})
		},
		updateRefs: function (newRefs) {
			this.refs = newRefs
			if (this.vCacheConfig != null) {
				this.vCacheConfig.cacheRefs = newRefs
			}
		},
		timeUnitName: function (unit) {
			switch (unit) {
				case "ms":
					return this.$t('server_http-cache-refs-config-box@毫秒')
				case "second":
					return this.$t('server_http-cache-refs-config-box@秒')
				case "minute":
					return this.$t('server_http-cache-refs-config-box@分钟')
				case "hour":
					return this.$t('server_http-cache-refs-config-box@小时')
				case "day":
					return this.$t('server_http-cache-refs-config-box@天')
				case "week":
					return this.$t('server_http-cache-refs-config-box@周')
			}
			return unit
		},
		change: function (callback) {
			this.$forceUpdate()

			// 自动保存
			if (this.vCachePolicyId != null && this.vCachePolicyId > 0) { // 缓存策略
				Tea.action("/servers/components/cache/updateRefs")
					.params({
						cachePolicyId: this.vCachePolicyId,
						refsJSON: JSON.stringify(this.refs)
					})
					.post()
			} else if (this.vWebId != null && this.vWebId > 0) { // Server Web or Group Web
				Tea.action("/servers/server/settings/cache/updateRefs")
					.params({
						webId: this.vWebId,
						refsJSON: JSON.stringify(this.refs)
					})
					.success(function (resp) {
						if (resp.data.isUpdated) {
							teaweb.successToast(this.$t('server_http-cache-refs-config-box@保存成功'), null, function () {
								if (typeof callback == "function") {
									callback()
								}
							})
						}
					})
					.post()
			}
		},
		search: function (keyword) {
			if (typeof keyword != "string") {
				keyword = ""
			}

			this.refs.forEach(function (ref) {
				if (keyword.length == 0) {
					ref.visible = true
					return
				}
				ref.visible = false

				// simple cond
				if (ref.simpleCond != null && typeof ref.simpleCond.value == "string" && teaweb.match(ref.simpleCond.value, keyword)) {
					ref.visible = true
					return
				}

				// composed conds
				if (ref.conds == null || ref.conds.groups == null || ref.conds.groups.length == 0) {
					return
				}

				ref.conds.groups.forEach(function (group) {
					if (group.conds != null) {
						group.conds.forEach(function (cond) {
							if (typeof cond.value == "string" && teaweb.match(cond.value, keyword)) {
								ref.visible = true
							}
						})
					}
				})
			})
			this.$forceUpdate()
		}
	},
	template: `<div style="padding: 1em;">
	<input type="hidden" name="refsJSON" :value="JSON.stringify(refs)"/>
	
	<div class="cache-refs-box">
		<p class="comment" v-if="refs.length == 0">{{$t('server_http-cache-refs-config-box@暂时还没有缓存条件')}}</p>
		
		<div v-show="refs.length > 0" class="cache-refs-table-box">
			<table class="ui table selectable celled" id="sortable-table">
				<thead>
					<tr>
						<th style="width:1em"></th>
						<th>{{$t('server_http-cache-refs-config-box@缓存条件')}}</th>
						<th style="width: 7em">{{$t('server_http-cache-refs-config-box@缓存时间')}}</th>
						<th class="three op">{{$t('server_http-cache-refs-config-box@操作')}}</th>
					</tr>
				</thead>	
				<tbody v-for="(cacheRef, index) in refs" :key="cacheRef.id" :v-id="cacheRef.id" v-show="cacheRef.visible !== false">
					<tr>
						<td style="text-align: center;"><i class="icon bars handle grey"></i> </td>
						<td :class="{'color-border': cacheRef.conds != null && cacheRef.conds.connector == 'and', disabled: !cacheRef.isOn}" :style="{'border-left':cacheRef.isReverse ? '1px #db2828 solid' : ''}">
							<http-request-conds-view :v-conds="cacheRef.conds" ref="cacheRef" :class="{disabled: !cacheRef.isOn}" v-if="cacheRef.conds != null && cacheRef.conds.groups != null"></http-request-conds-view>
							<http-request-cond-view :v-cond="cacheRef.simpleCond" ref="cacheRef" v-if="cacheRef.simpleCond != null"></http-request-cond-view>
							
							<div class="cache-ref-labels">
								<!-- {{$t('server_http-cache-refs-config-box@特殊参数')}} -->
								<grey-label v-if="cacheRef.key != null && cacheRef.key.indexOf('\${args}') < 0">{{$t('server_http-cache-refs-config-box@忽略URI参数')}}</grey-label>
								
								<grey-label v-if="cacheRef.minSize != null && cacheRef.minSize.count > 0">
									{{cacheRef.minSize.count}}{{cacheRef.minSize.unit}}
									<span v-if="cacheRef.maxSize != null && cacheRef.maxSize.count > 0">- {{cacheRef.maxSize.count}}{{cacheRef.maxSize.unit.toUpperCase()}}</span>
								</grey-label>
								<grey-label v-else-if="cacheRef.maxSize != null && cacheRef.maxSize.count > 0">0 - {{cacheRef.maxSize.count}}{{cacheRef.maxSize.unit.toUpperCase()}}</grey-label>
								
								<grey-label v-if="cacheRef.overMaxSize != null"><span class="red">{{$t('server_http-cache-refs-config-box@系统限制N', [cacheRef.overMaxSize.count, cacheRef.overMaxSize.unit.toUpperCase()])}}</span> </grey-label>
								
								<grey-label v-if="cacheRef.methods != null && cacheRef.methods.length > 0">{{cacheRef.methods.join(", ")}}</grey-label>
								<grey-label v-if="cacheRef.expiresTime != null && cacheRef.expiresTime.isPrior && cacheRef.expiresTime.isOn">Expires</grey-label>
								<grey-label v-if="cacheRef.status != null && cacheRef.status.length > 0 && (cacheRef.status.length > 1 || cacheRef.status[0] != 200)">{{$t('server_http-cache-refs-config-box@状态码')}}{{cacheRef.status.map(function(v) {return v.toString()}).join(", ")}}</grey-label>
								<grey-label v-if="cacheRef.allowPartialContent">{{$t('server_http-cache-refs-config-box@分片缓存')}}</grey-label>
								<grey-label v-if="cacheRef.alwaysForwardRangeRequest">{{$t('server_http-cache-refs-config-box@Range回源')}}</grey-label>
								<grey-label v-if="cacheRef.enableIfNoneMatch">If-None-Match</grey-label>
								<grey-label v-if="cacheRef.enableIfModifiedSince">If-Modified-Since</grey-label>
								<grey-label v-if="cacheRef.enableReadingOriginAsync">{{$t('server_http-cache-refs-config-box@支持异步')}}</grey-label>
							</div>
						</td>
						<td :class="{disabled: !cacheRef.isOn}">
							<span v-if="!cacheRef.isReverse" class="cache-time">{{cacheRef.life.count}} {{timeUnitName(cacheRef.life.unit)}}</span>
							<span v-else class="cache-time red">{{$t('server_http-cache-refs-config-box@不缓存')}}</span>
						</td>
						<td>
							<div class="cache-ref-actions">
								<a href="" @click.prevent="updateRef(index, cacheRef)" class="ui button tiny">{{$t('server_http-cache-refs-config-box@修改')}}</a>
								<a href="" v-if="cacheRef.isOn" @click.prevent="disableRef(cacheRef)" class="ui button tiny">{{$t('server_http-cache-refs-config-box@暂停')}}</a>
								<a href="" v-if="!cacheRef.isOn" @click.prevent="enableRef(cacheRef)" class="ui button tiny red">{{$t('server_http-cache-refs-config-box@恢复')}}</a>
								<a href="" @click.prevent="removeRef(index)" class="ui button tiny">{{$t('server_http-cache-refs-config-box@删除')}}</a>
							</div>
						</td>
					</tr>
				</tbody>
			</table>
		</div>
		
		<p class="comment" v-if="refs.length > 1" v-html="$t('server_http-cache-refs-config-box@排序提示')"></p>
		
		<div class="cache-ref-actions-box">
			<button class="ui button tiny primary" @click.prevent="addRef(false)" type="button">{{$t('server_http-cache-refs-config-box@添加缓存条件')}}</button>
			<a href="" @click.prevent="addRef(true)" class="ui button tiny">{{$t('server_http-cache-refs-config-box@添加不缓存条件')}}</a>
		</div>
	</div>
</div>`
})

// 显示指标对象名
Vue.component("metric-key-label", {
	props: ["v-key"],
	data: function () {
		return {
			keyDefs: window.METRIC_HTTP_KEYS
		}
	},
	methods: {
		keyName: function (key) {
			let that = this
			let subKey = ""
			let def = this.keyDefs.$find(function (k, v) {
				if (v.code == key) {
					return true
				}
				if (key.startsWith("${arg.") && v.code.startsWith("${arg.")) {
					subKey = that.getSubKey("arg.", key)
					return true
				}
				if (key.startsWith("${header.") && v.code.startsWith("${header.")) {
					subKey = that.getSubKey("header.", key)
					return true
				}
				if (key.startsWith("${cookie.") && v.code.startsWith("${cookie.")) {
					subKey = that.getSubKey("cookie.", key)
					return true
				}
				return false
			})
			if (def != null) {
				if (subKey.length > 0) {
					return def.name + ": " + subKey
				}
				return def.name
			}
			return key
		},
		getSubKey: function (prefix, key) {
			prefix = "${" + prefix
			let index = key.indexOf(prefix)
			if (index >= 0) {
				key = key.substring(index + prefix.length)
				key = key.substring(0, key.length - 1)
				return key
			}
			return ""
		}
	},
	template: `<div class="ui label basic small">
	{{keyName(this.vKey)}}
</div>`
})

// 通用Header长度
let defaultGeneralHeaders = ["Cache-Control", "Connection", "Date", "Pragma", "Trailer", "Transfer-Encoding", "Upgrade", "Via", "Warning"]
Vue.component("http-cond-general-header-length", {
	props: ["v-checkpoint"],
	data: function () {
		let headers = null
		let length = null

		if (window.parent.UPDATING_RULE != null) {
			let options = window.parent.UPDATING_RULE.checkpointOptions
			if (options.headers != null && Array.$isArray(options.headers)) {
				headers = options.headers
			}
			if (options.length != null) {
				length = options.length
			}
		}


		if (headers == null) {
			headers = defaultGeneralHeaders
		}

		if (length == null) {
			length = 128
		}

		let that = this
		setTimeout(function () {
			that.change()
		}, 100)

		return {
			headers: headers,
			length: length
		}
	},
	watch: {
		length: function (v) {
			let len = parseInt(v)
			if (isNaN(len)) {
				len = 0
			}
			if (len < 0) {
				len = 0
			}
			this.length = len
			this.change()
		}
	},
	methods: {
		change: function () {
			this.vCheckpoint.options = [
				{
					code: "headers",
					value: this.headers
				},
				{
					code: "length",
					value: this.length
				}
			]
		}
	},
	template: `<div>
	<table class="ui table">
		<tr>
			<td class="title">{{$t("http-firewall-rules@通用Header列表")}}</td>
			<td>
				<values-box :values="headers" :placeholder="'Header'" @change="change"></values-box>
				<p class="comment">{{$t("http-firewall-rules@需要检查的Header列表")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@Header值超出长度")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" name="" style="width: 5em" v-model="length" maxlength="6"/>
					<span class="ui label">{{$t("http-firewall-rules@字节")}}</span>
				</div>
				<p class="comment">{{$t("http-firewall-rules@超出此长度认为匹配成功0表示不限制")}}</p>
			</td>
		</tr>
	</table>
</div>`
})

// CC
Vue.component("http-firewall-checkpoint-cc", {
	props: ["v-checkpoint"],
	data: function () {
		let keys = []
		let period = 60
		let threshold = 1000
		let ignoreCommonFiles = true
		let enableFingerprint = true

		let options = {}
		if (window.parent.UPDATING_RULE != null) {
			options = window.parent.UPDATING_RULE.checkpointOptions
		}

		if (options == null) {
			options = {}
		}
		if (options.keys != null) {
			keys = options.keys
		}
		if (keys.length == 0) {
			keys = ["${remoteAddr}", "${requestPath}"]
		}
		if (options.period != null) {
			period = options.period
		}
		if (options.threshold != null) {
			threshold = options.threshold
		}
		if (options.ignoreCommonFiles != null && typeof (options.ignoreCommonFiles) == "boolean") {
			ignoreCommonFiles = options.ignoreCommonFiles
		}
		if (options.enableFingerprint != null && typeof (options.enableFingerprint) == "boolean") {
			enableFingerprint = options.enableFingerprint
		}

		let that = this
		setTimeout(function () {
			that.change()
		}, 100)

		return {
			keys: keys,
			period: period,
			threshold: threshold,
			ignoreCommonFiles: ignoreCommonFiles,
			enableFingerprint: enableFingerprint,
			options: {},
			value: threshold
		}
	},
	watch: {
		period: function () {
			this.change()
		},
		threshold: function () {
			this.change()
		},
		ignoreCommonFiles: function () {
			this.change()
		},
		enableFingerprint: function () {
			this.change()
		}
	},
	methods: {
		changeKeys: function (keys) {
			this.keys = keys
			this.change()
		},
		change: function () {
			let period = parseInt(this.period.toString())
			if (isNaN(period) || period <= 0) {
				period = 60
			}

			let threshold = parseInt(this.threshold.toString())
			if (isNaN(threshold) || threshold <= 0) {
				threshold = 1000
			}
			this.value = threshold

			let ignoreCommonFiles = this.ignoreCommonFiles
			if (typeof ignoreCommonFiles != "boolean") {
				ignoreCommonFiles = false
			}

			let enableFingerprint = this.enableFingerprint
			if (typeof enableFingerprint != "boolean") {
				enableFingerprint = true
			}

			this.vCheckpoint.options = [
				{
					code: "keys",
					value: this.keys
				},
				{
					code: "period",
					value: period,
				},
				{
					code: "threshold",
					value: threshold
				},
				{
					code: "ignoreCommonFiles",
					value: ignoreCommonFiles
				},
				{
					code: "enableFingerprint",
					value: enableFingerprint
				}
			]
		},
		thresholdTooLow: function () {
			let threshold = parseInt(this.threshold.toString())
			if (isNaN(threshold) || threshold <= 0) {
				threshold = 1000
			}
			return threshold > 0 && threshold < 5
		}
	},
	template: `<div>
	<input type="hidden" name="operator" value="gt"/>
	<input type="hidden" name="value" :value="value"/>
	<table class="ui table">
		<tr>
			<td class="title">{{$t("http-firewall-rules@统计对象组合星号")}}</td>
			<td>
				<metric-keys-config-box :v-keys="keys" @change="changeKeys"></metric-keys-config-box>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@统计周期星号")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="period" style="width: 6em" maxlength="8"/>
					<span class="ui label">{{$t("http-firewall-captcha-options-viewer@秒")}}</span>
				</div>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@阈值星号")}}</td>
			<td>
				<input type="text" v-model="threshold" style="width: 6em" maxlength="8"/>
				<p class="comment" v-if="thresholdTooLow()"><span class="red">{{$t("http-firewall-rules@对于网站类应用来说当前阈值设置的太低有可能会影响用户正常访问")}}</span></p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@检查请求来源指纹")}}</td>
			<td>
				<checkbox :v-value="1" v-model="enableFingerprint"></checkbox>
				<p class="comment">{{$t("http-firewall-rules@在接收到HTTPS请求时尝试检查请求来源的指纹用来检测代理服务和爬虫攻击如果你在网站前面放置了别的反向代理服务请取消此选项")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@忽略常用文件")}}</td>
			<td>
				<checkbox :v-value="1" v-model="ignoreCommonFiles"></checkbox>
				<p class="comment">{{$t("http-firewall-rules@忽略jscssjpg等常在网页里被引用的文件名即对这些文件的访问不加入计数可以减少误判几率")}}</p>
			</td>
		</tr>
	</table>
</div>`
})

// 防盗链
Vue.component("http-firewall-checkpoint-referer-block", {
	props: ["v-checkpoint"],
	data: function () {
		let allowEmpty = true
		let allowSameDomain = true
		let allowDomains = []
		let denyDomains = []
		let checkOrigin = true

		let options = {}
		if (window.parent.UPDATING_RULE != null) {
			options = window.parent.UPDATING_RULE.checkpointOptions
		}

		if (options == null) {
			options = {}
		}
		if (typeof (options.allowEmpty) == "boolean") {
			allowEmpty = options.allowEmpty
		}
		if (typeof (options.allowSameDomain) == "boolean") {
			allowSameDomain = options.allowSameDomain
		}
		if (options.allowDomains != null && typeof (options.allowDomains) == "object") {
			allowDomains = options.allowDomains
		}
		if (options.denyDomains != null && typeof (options.denyDomains) == "object") {
			denyDomains = options.denyDomains
		}
		if (typeof options.checkOrigin == "boolean") {
			checkOrigin = options.checkOrigin
		}

		let that = this
		setTimeout(function () {
			that.change()
		}, 100)

		return {
			allowEmpty: allowEmpty,
			allowSameDomain: allowSameDomain,
			allowDomains: allowDomains,
			denyDomains: denyDomains,
			checkOrigin: checkOrigin,
			options: {},
			value: 0
		}
	},
	watch: {
		allowEmpty: function () {
			this.change()
		},
		allowSameDomain: function () {
			this.change()
		},
		checkOrigin: function () {
			this.change()
		}
	},
	methods: {
		changeAllowDomains: function (values) {
			this.allowDomains = values
			this.change()
		},
		changeDenyDomains: function (values) {
			this.denyDomains = values
			this.change()
		},
		change: function () {
			this.vCheckpoint.options = [
				{
					code: "allowEmpty",
					value: this.allowEmpty
				},
				{
					code: "allowSameDomain",
					value: this.allowSameDomain,
				},
				{
					code: "allowDomains",
					value: this.allowDomains
				},
				{
					code: "denyDomains",
					value: this.denyDomains
				},
				{
					code: "checkOrigin",
					value: this.checkOrigin
				}
			]
		}
	},
	template: `<div>
	<input type="hidden" name="operator" value="eq"/>
	<input type="hidden" name="value" :value="value"/>
	<table class="ui table">
		<tr>
			<td class="title">{{$t("http-firewall-rules@来源域名允许为空")}}</td>
			<td>
				<checkbox :v-value="1" v-model="allowEmpty"></checkbox>
				<p class="comment">{{$t("http-firewall-rules@允许不带来源的访问")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@来源域名允许一致")}}</td>
			<td>
				<checkbox :v-value="1" v-model="allowSameDomain"></checkbox>
				<p class="comment">{{$t("http-firewall-rules@允许来源域名和当前访问的域名一致相当于在站内访问")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@允许的来源域名")}}</td>
			<td>
				<values-box :values="allowDomains" @change="changeAllowDomains"></values-box>
				<p class="comment">{{$t("http-firewall-rules@允许的来源域名列表比如examplecom顶级域名examplecom的所有二级域名单个星号表示允许所有域名")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@禁止的来源域名")}}</td>
			<td>
				<values-box :values="denyDomains" @change="changeDenyDomains"></values-box>
				<p class="comment">{{$t("http-firewall-rules@禁止的来源域名列表比如exampleorg顶级域名exampleorg的所有二级域名除了这些禁止的来源域名外其他域名都会被允许除非限定了允许的来源域名")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("http-firewall-rules@同时检查Origin")}}</td>
			<td>
				<checkbox :v-value="1" v-model="checkOrigin"></checkbox>
				<p class="comment">{{$t("http-firewall-rules@如果请求没有指定RefererHeader则尝试检查OriginHeader多用于跨站调用")}}</p>
			</td>
		</tr>
	</table>
</div>`
})

Vue.component("ssl-certs-box", {
	props: [
		"v-certs", // 证书列表
		"v-cert", // 单个证书
		"v-protocol", // 协议：https|tls
		"v-view-size", // 弹窗尺寸：normal, mini
		"v-single-mode", // 单证书模式
		"v-description", // 描述文字
		"v-domains", // 搜索的域名列表或者函数
		"v-user-id" // 用户ID
	],
	data: function () {
		let certs = this.vCerts
		if (certs == null) {
			certs = []
		}
		if (this.vCert != null) {
			certs.push(this.vCert)
		}

		let description = this.vDescription
		if (description == null || typeof (description) != "string") {
			description = ""
		}

		return {
			certs: certs,
			description: description
		}
	},
	methods: {
		certIds: function () {
			return this.certs.map(function (v) {
				return v.id
			})
		},
		// 删除证书
		removeCert: function (index) {
			let that = this
			teaweb.confirm(this.$t("index_确定删除此证书吗？证书数据仍然保留，只是当前网站不再使用此证书。"), function () {
				that.certs.$remove(index)
			})
		},

		// 选择证书
		selectCert: function () {
			let that = this
			let width = "54em"
			let height = "32em"
			let viewSize = this.vViewSize
			if (viewSize == null) {
				viewSize = "normal"
			}
			if (viewSize == "mini") {
				width = "35em"
				height = "20em"
			}

			let searchingDomains = []
			if (this.vDomains != null) {
				if (typeof this.vDomains == "function") {
					let resultDomains = this.vDomains()
					if (resultDomains != null && typeof resultDomains == "object" && (resultDomains instanceof Array)) {
						searchingDomains = resultDomains
					}
				} else if (typeof this.vDomains == "object" && (this.vDomains instanceof Array)) {
					searchingDomains = this.vDomains
				}
				if (searchingDomains.length > 10000) {
					searchingDomains = searchingDomains.slice(0, 10000)
				}
			}

			let selectedCertIds = this.certs.map(function (cert) {
				return cert.id
			})
			let userId = this.vUserId
			if (userId == null) {
				userId = 0
			}

			teaweb.popup("/servers/certs/selectPopup?viewSize=" + viewSize + "&searchingDomains=" + window.encodeURIComponent(searchingDomains.join(",")) + "&selectedCertIds=" + selectedCertIds.join(",") + "&userId=" + userId, {
				title: this.$t('index_选择证书_0101'),
				width: width,
				height: height,
				callback: function (resp) {
					if (resp.data.cert != null) {
						that.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null) {
						that.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 上传证书
		uploadCert: function () {
			let that = this
			let userId = this.vUserId
			if (typeof userId != "number" && typeof userId != "string") {
				userId = 0
			}
			teaweb.popup("/servers/certs/uploadPopup?userId=" + userId, {
				title: this.$t('index_上传证书_0101'),
				height: "28em",
				callback: function (resp) {
					teaweb.success("上传成功", function () {
						if (resp.data.cert != null) {
							that.certs.push(resp.data.cert)
						}
						if (resp.data.certs != null) {
							that.certs.$pushAll(resp.data.certs)
						}
						that.$forceUpdate()
					})
				}
			})
		},

		// 批量上传
		uploadBatch: function () {
			let that = this
			let userId = this.vUserId
			if (typeof userId != "number" && typeof userId != "string") {
				userId = 0
			}
			teaweb.popup("/servers/certs/uploadBatchPopup?userId=" + userId, {
				title: this.$t('index_批量上传证书_0101'),
				callback: function (resp) {
					if (resp.data.cert != null) {
						that.certs.push(resp.data.cert)
					}
					if (resp.data.certs != null) {
						that.certs.$pushAll(resp.data.certs)
					}
					that.$forceUpdate()
				}
			})
		},

		// 格式化时间
		formatTime: function (timestamp) {
			return new Date(timestamp * 1000).format("Y-m-d")
		},

		// 判断是否显示选择｜上传按钮
		buttonsVisible: function () {
			return this.vSingleMode == null || !this.vSingleMode || this.certs == null || this.certs.length == 0
		}
	},
	template: `<div>
	<input type="hidden" name="certIdsJSON" :value="JSON.stringify(certIds())"/>
	<div v-if="certs != null && certs.length > 0">
		<div class="ui label small basic" v-for="(cert, index) in certs">
			{{cert.name}} / {{cert.dnsNames}} / {{$t('index_有效至_0101')}} {{formatTime(cert.timeEndAt)}} &nbsp; <a href="" :title="$t('index_删除_0101')" @click.prevent="removeCert(index)"><i class="icon remove"></i></a>
		</div>
		<div class="ui divider" v-if="buttonsVisible()"></div>
	</div>
	<div v-else>
		<span class="red" v-if="description.length == 0">{{$t('index_选择或上传证书后_0101')}}<span v-if="vProtocol == 'https'">HTTPS</span><span v-if="vProtocol == 'tls'">TLS</span>{{$t('index_服务才能生效_0101')}}。</span>
		<span class="grey" v-if="description.length > 0">{{description}}</span>
		<div class="ui divider" v-if="buttonsVisible()"></div>
	</div>
	<div v-if="buttonsVisible()">
		<button class="ui button tiny" type="button" @click.prevent="selectCert()">{{$t('index_选择已有证书_0101')}}</button> &nbsp;
		<span class="disabled">|</span> &nbsp;
		<button class="ui button tiny" type="button" @click.prevent="uploadCert()">{{$t('index_上传新证书_0101')}}</button> &nbsp;
		<button class="ui button tiny" type="button" @click.prevent="uploadBatch()">{{$t('index_批量上传证书_0101')}}</button> &nbsp;
	</div>
</div>`
})

// HTTP CC防护配置
Vue.component("http-cc-config-box", {
	props: ["v-cc-config", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.vCcConfig
		if (config == null) {
			config = {
				isPrior: false,
				isOn: false,
				enableFingerprint: true,
				enableGET302: true,
				onlyURLPatterns: [],
				exceptURLPatterns: [],
				useDefaultThresholds: true,
				ignoreCommonFiles: true
			}
		}

		if (config.thresholds == null || config.thresholds.length == 0) {
			config.thresholds = [
				{
					maxRequests: 0
				},
				{
					maxRequests: 0
				},
				{
					maxRequests: 0
				}
			]
		}

		if (typeof config.enableFingerprint != "boolean") {
			config.enableFingerprint = true
		}
		if (typeof config.enableGET302 != "boolean") {
			config.enableGET302 = true
		}

		if (config.onlyURLPatterns == null) {
			config.onlyURLPatterns = []
		}
		if (config.exceptURLPatterns == null) {
			config.exceptURLPatterns = []
		}
		return {
			config: config,
			moreOptionsVisible: true,
			minQPSPerIP: config.minQPSPerIP,
			useCustomThresholds: !config.useDefaultThresholds,

			thresholdMaxRequests0: this.maxRequestsStringAtThresholdIndex(config, 0),
			thresholdMaxRequests1: this.maxRequestsStringAtThresholdIndex(config, 1),
			thresholdMaxRequests2: this.maxRequestsStringAtThresholdIndex(config, 2)
		}
	},
	watch: {
		minQPSPerIP: function (v) {
			let qps = parseInt(v.toString())
			if (isNaN(qps) || qps < 0) {
				qps = 0
			}
			this.config.minQPSPerIP = qps
		},
		thresholdMaxRequests0: function (v) {
			this.setThresholdMaxRequests(0, v)
		},
		thresholdMaxRequests1: function (v) {
			this.setThresholdMaxRequests(1, v)
		},
		thresholdMaxRequests2: function (v) {
			this.setThresholdMaxRequests(2, v)
		},
		useCustomThresholds: function (b) {
			this.config.useDefaultThresholds = !b
		}
	},
	methods: {
		maxRequestsStringAtThresholdIndex: function (config, index) {
			if (config.thresholds == null) {
				return ""
			}
			if (index < config.thresholds.length) {
				let s = config.thresholds[index].maxRequests.toString()
				if (s == "0") {
					s = ""
				}
				return s
			}
			return ""
		},
		setThresholdMaxRequests: function (index, v) {
			let maxRequests = parseInt(v)
			if (isNaN(maxRequests) || maxRequests < 0) {
				maxRequests = 0
			}
			if (index < this.config.thresholds.length) {
				this.config.thresholds[index].maxRequests = maxRequests
			}
		},
		showMoreOptions: function () {
			this.moreOptionsVisible = !this.moreOptionsVisible
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div>
<input type="hidden" name="ccJSON" :value="JSON.stringify(config)"/>

<div class="config-section">
    <div class="section-title">
        <i class="icon power"></i>
        <span>{{$t('http-cc-config-box@基本设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@启用CC无感防护')}}</div>
        <div class="item-content">
            <p-switch v-model="config.isOn" binary @change="submit"></p-switch>
            <p class="comment"><plus-label></plus-label>{{$t('http-cc-config-box@启用CC无感防护提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon filter"></i>
        <span>{{$t('http-cc-config-box@URL过滤设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@例外URL')}}</div>
        <div class="item-content">
            <url-patterns-box v-model="config.exceptURLPatterns" @input="submit"></url-patterns-box>
            <p class="comment">{{$t('http-cc-config-box@例外URL提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@限制URL')}}</div>
        <div class="item-content">
            <url-patterns-box v-model="config.onlyURLPatterns" @input="submit"></url-patterns-box>
            <p class="comment">{{$t('http-cc-config-box@限制URL提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@忽略常用文件')}}</div>
        <div class="item-content">
            <p-checkbox v-model="config.ignoreCommonFiles" binary @change="submit"></p-checkbox> 
            <p class="comment">{{$t('http-cc-config-box@忽略常用文件提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon shield alternate"></i>
        <span>{{$t('http-cc-config-box@防护设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@检查请求来源指纹')}}</div>
        <div class="item-content">
            <p-checkbox v-model="config.enableFingerprint" binary @change="submit"></p-checkbox>
            <p class="comment">{{$t('http-cc-config-box@检查请求来源指纹提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@启用GET302校验')}}</div>
        <div class="item-content">
            <p-checkbox v-model="config.enableGET302" binary @change="submit"></p-checkbox>
            <p class="comment">{{$t('http-cc-config-box@启用GET302校验提示')}}</p>
        </div>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@单IP最低QPS')}}</div>
        <div class="item-content">
            <div class="ui input right labeled">
                <input type="text" name="minQPSPerIP" maxlength="6" style="width: 6em" v-model="minQPSPerIP" @blur="submit"/>
                <span class="ui label">{{$t('http-cc-config-box@请求数每秒')}}</span>
            </div>
            <p class="comment">{{$t('http-cc-config-box@单IP最低QPS提示')}}</p>
        </div>
    </div>
</div>

<div class="config-section" v-show="moreOptionsVisible && config.isOn">
    <div class="section-title">
        <i class="icon sliders horizontal"></i>
        <span>{{$t('http-cc-config-box@拦截阈值设置')}}</span>
    </div>
    
    <div class="config-item">
        <div class="item-label">{{$t('http-cc-config-box@使用自定义拦截阈值')}}</div>
        <div class="item-content">
            <p-switch v-model="useCustomThresholds" binary @change="submit"></p-switch>
        </div>
    </div>
    
    <div class="config-item" v-show="!config.useDefaultThresholds">
        <div class="item-label">{{$t('http-cc-config-box@自定义拦截阈值')}}</div>
        <div class="item-content">
            <div class="threshold-item">
                <div class="ui input left right labeled">
                    <span class="ui label basic">{{$t('http-cc-config-box@单IP每5秒最多')}}</span>
                    <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests0" @blur="submit"/>
                    <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
            </div>
            
            <div class="threshold-item">
                <div class="ui input left right labeled">
                    <span class="ui label basic">{{$t('http-cc-config-box@单IP每60秒最多')}}</span>
                    <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests1" @blur="submit"/>
                    <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
            </div>
            
            <div class="threshold-item">
                <div class="ui input left right labeled">
                    <span class="ui label basic">{{$t('http-cc-config-box@单IP每300秒最多')}}</span>
                    <input type="text" style="width: 6em" maxlength="6" v-model="thresholdMaxRequests2" @blur="submit"/>
                    <span class="ui label basic">{{$t('http-cc-config-box@请求')}}</span>
                </div>
            </div>
        </div>
    </div>
</div>

<div class="config-section" v-if="vIsLocation || vIsGroup">
	<div class="section-title">
		<i class="icon sliders horizontal"></i>
		<span>{{$t('http-cc-config-box@独立配置')}}</span>
	</div>
	<prior-checkbox :v-config="config"></prior-checkbox>
</div>

<div class="margin"></div>
</div>`
})

Vue.component("http-hls-config-box", {
	props: ["value", "v-is-location", "v-is-group"],
	data: function () {
		let config = this.value
		if (config == null) {
			config = {
				isPrior: false
			}
		}

		let encryptingConfig = config.encrypting
		if (encryptingConfig == null) {
			encryptingConfig = {
				isOn: false,
				onlyURLPatterns: [],
				exceptURLPatterns: []
			}
			config.encrypting = encryptingConfig
		}

		return {
			config: config,

			encryptingConfig: encryptingConfig,
			encryptingMoreOptionsVisible: true
		}
	},
	methods: {
		isOn: function () {
			return ((!this.vIsLocation && !this.vIsGroup) || this.config.isPrior)
		},

		showEncryptingMoreOptions: function () {
			this.encryptingMoreOptionsVisible = !this.encryptingMoreOptionsVisible
		},
		submit: function () {
			setTimeout(() => {
				this.$emit("submit", this.config)
			}, 100)
		}
	},
	template: `<div class="hls-box">
	<input type="hidden" name="hlsJSON" :value="JSON.stringify(config)"/>
	
	<!-- 基本设置 -->
	<div class="config-section" v-show="vIsLocation || vIsGroup">
		<div class="section-title">
			<i class="icon setting"></i>
			<span>{{$t('http-hls-config-box@基本设置')}}</span>
		</div>
		
		<prior-checkbox :v-config="config" v-if="vIsLocation || vIsGroup" class="config-item"></prior-checkbox>
	</div>
	
	<!-- HLS加密设置 -->
	<div class="config-section" v-show="isOn()">
		<div class="section-title">
			<i class="icon lock"></i>
			<span>{{$t('http-hls-config-box@HLS加密设置')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-hls-config-box@启用HLS加密')}}</div>
			<div class="item-content">
				<p-switch v-model="encryptingConfig.isOn" binary @change="submit"></p-switch>
				<p class="comment">{{$t('http-hls-config-box@启用后_系统会自动在')}}<code-label>.m3u8</code-label>{{$t('http-hls-config-box@文件中加入')}}<code-label>#EXT-X-KEY:METHOD=AES-128...</code-label>{{$t('http-hls-config-box@并将其中的')}}<code-label>.ts</code-label>{{$t('http-hls-config-box@文件内容进行加密')}}</p>
			</div>
		</div>
		
	</div>
	
	<!-- 高级选项 -->
	<div class="config-section" v-show="encryptingConfig.isOn && encryptingMoreOptionsVisible">
		<div class="section-title">
			<i class="icon sliders"></i>
			<span>{{$t('http-hls-config-box@高级选项')}}</span>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-hls-config-box@例外URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="encryptingConfig.exceptURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('http-hls-config-box@如果填写了例外URL_表示这些URL跳过不做处理')}}</p>
			</div>
		</div>
		
		<div class="config-item">
			<div class="item-label">{{$t('http-hls-config-box@限制URL')}}</div>
			<div class="item-content">
				<url-patterns-box v-model="encryptingConfig.onlyURLPatterns" @input="submit"></url-patterns-box>
				<p class="comment">{{$t('http-hls-config-box@如果填写了限制URL_表示只对这些URL进行加密处理_如果不填则表示支持所有的URL')}}</p>
			</div>
		</div>
	</div>
</div>`
})


// 请求方法列表
Vue.component("http-status-box", {
	props: ["v-status-list"],
	data: function () {
		let statusList = this.vStatusList
		if (statusList == null) {
			statusList = []
		}
		return {
			statusList: statusList,
			isAdding: false,
			addingStatus: ""
		}
	},
	methods: {
		add: function () {
			this.isAdding = true
			let that = this
			setTimeout(function () {
				that.$refs.addingStatus.focus()
			}, 100)
		},
		confirm: function () {
			let that = this

			// 删除其中的空格
			this.addingStatus = this.addingStatus.replace(/\s/g, "").toUpperCase()

			if (this.addingStatus.length == 0) {
				teaweb.warn(this.$t("server_http-status-box@请输入要添加的状态码"), function () {
					that.$refs.addingStatus.focus()
				})
				return
			}

			// 是否已经存在
			if (this.statusList.$contains(this.addingStatus)) {
				teaweb.warn(this.$t("server_http-status-box@此状态码已经存在无需重复添加"), function () {
					that.$refs.addingStatus.focus()
				})
				return
			}

			// 格式
			if (!this.addingStatus.match(/^\d{3}$/)) {
				teaweb.warn(this.$t("server_http-status-box@请输入正确的状态码"), function () {
					that.$refs.addingStatus.focus()
				})
				return
			}

			this.statusList.push(parseInt(this.addingStatus, 10))
			this.cancel()
		},
		remove: function (index) {
			this.statusList.$remove(index)
		},
		cancel: function () {
			this.isAdding = false
			this.addingStatus = ""
		}
	},
	template: `<div>
	<input type="hidden" name="statusListJSON" :value="JSON.stringify(statusList)"/>
	<div v-if="statusList.length > 0">
		<span class="ui label small basic" v-for="(status, index) in statusList">
			{{status}}
			&nbsp; <a href="" :title="$t('server_http-status-box@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</span>
		<div class="ui divider"></div>
	</div>
	<div v-if="isAdding">
		<div class="ui fields">
			<div class="ui field">
				<input type="text" v-model="addingStatus" @keyup.enter="confirm()" @keypress.enter.prevent="1" ref="addingStatus" :placeholder="$t('server_http-status-box@如200')" size="3" maxlength="3" style="width: 5em"/>
			</div>
			<div class="ui field">
				<button class="ui button tiny" type="button" @click.prevent="confirm">{{ $t("server_http-status-box@确定") }}</button>
				&nbsp; <a href="" :title="$t('server_http-status-box@取消')" @click.prevent="cancel"><i class="pi pi-times"></i></a>
			</div>
		</div>
		<p class="comment">{{ $t("server_http-status-box@格式为三位数字") }}<code-label>200</code-label>、<code-label>404</code-label>{{ $t("server_http-status-box@等") }}</p>
		<div class="ui divider"></div>
	</div>
	<div style="margin-top: 0.5em" v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("http-firewall-rules-box", {
	props: ["v-rules", "v-type"],
	data: function () {
		let rules = this.vRules
		if (rules == null) {
			rules = []
		}
		return {
			rules: rules
		}
	},
	methods: {
		addRule: function () {
			window.UPDATING_RULE = null
			let that = this
			teaweb.popup("/servers/components/waf/createRulePopup?type=" + this.vType, {
				title: this.$t("http-firewall-rules-box@添加规则"),
				height: "30em",
				callback: function (resp) {
					that.rules.push(resp.data.rule)
				}
			})
		},
		updateRule: function (index, rule) {
			window.UPDATING_RULE = teaweb.clone(rule)
			let that = this
			teaweb.popup("/servers/components/waf/createRulePopup?type=" + this.vType, {
				title: this.$t("http-firewall-rules-box@修改规则"),
				height: "30em",
				callback: function (resp) {
					Vue.set(that.rules, index, resp.data.rule)
				}
			})
		},
		removeRule: function (index) {
			let that = this
			teaweb.confirm(this.$t("http-firewall-rules-box@确定要删除此规则吗"), function () {
				that.rules.$remove(index)
			})
		},
		operatorName: function (operatorCode) {
			let operatorName = operatorCode
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorName = v.name
					}
				})
			}

			return operatorName
		},
		operatorDescription: function (operatorCode) {
			let operatorName = operatorCode
			let operatorDescription = ""
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorName = v.name
						operatorDescription = v.description
					}
				})
			}

			return operatorName + ": " + operatorDescription
		},
		operatorDataType: function (operatorCode) {
			let operatorDataType = "none"
			if (typeof (window.WAF_RULE_OPERATORS) != null) {
				window.WAF_RULE_OPERATORS.forEach(function (v) {
					if (v.code == operatorCode) {
						operatorDataType = v.dataType
					}
				})
			}

			return operatorDataType
		},
		calculateParamName: function (param) {
			let paramName = ""
			if (param != null) {
				window.WAF_RULE_CHECKPOINTS.forEach(function (checkpoint) {
					if (param == "${" + checkpoint.prefix + "}" || param.startsWith("${" + checkpoint.prefix + ".")) {
						paramName = checkpoint.name
					}
				})
			}
			return paramName
		},
		calculateParamDescription: function (param) {
			let paramName = ""
			let paramDescription = ""
			if (param != null) {
				window.WAF_RULE_CHECKPOINTS.forEach(function (checkpoint) {
					if (param == "${" + checkpoint.prefix + "}" || param.startsWith("${" + checkpoint.prefix + ".")) {
						paramName = checkpoint.name
						paramDescription = checkpoint.description
					}
				})
			}
			return paramName + ": " + paramDescription
		},
		isEmptyString: function (v) {
			return typeof v == "string" && v.length == 0
		}
	},
	template: `<div>
		<input type="hidden" name="rulesJSON" :value="JSON.stringify(rules)"/>
		<div v-if="rules.length > 0">
			<div v-for="(rule, index) in rules" class="ui label small basic" style="margin-bottom: 0.5em; line-height: 1.5">
				{{rule.name}} <span :title="calculateParamDescription(rule.param)" class="hover">{{calculateParamName(rule.param)}}<span class="small grey"> {{rule.param}}</span></span>
				
				<!-- cc2 -->
				<span v-if="rule.param == '\${cc2}'">
					{{rule.checkpointOptions.period}}{{$t("http-firewall-rules-box@秒内请求数")}}
				</span>	
				
				<!-- refererBlock -->
				<span v-if="rule.param == '\${refererBlock}'">
					<span v-if="rule.checkpointOptions.allowDomains != null && rule.checkpointOptions.allowDomains.length > 0">{{$t("http-firewall-rules-box@允许")}} {{rule.checkpointOptions.allowDomains}}</span>
					<span v-if="rule.checkpointOptions.denyDomains != null && rule.checkpointOptions.denyDomains.length > 0">{{$t("http-firewall-rules-box@禁止")}} {{rule.checkpointOptions.denyDomains}}</span>
				</span>
				
				<span v-else>
					<span v-if="rule.paramFilters != null && rule.paramFilters.length > 0" v-for="paramFilter in rule.paramFilters"> | {{paramFilter.code}}</span> <span class="hover" :title="operatorDescription(rule.operator) + ((!rule.isComposed && rule.isCaseInsensitive) ? '\n[' + $t("http-firewall-rules-box@大小写不敏感") + '] ' :'')">&lt;{{operatorName(rule.operator)}}&gt;</span> 
						<span v-if="!isEmptyString(rule.value)" class="hover">{{rule.value}}</span>
						<span v-else-if="operatorDataType(rule.operator) != 'none'" class="disabled" style="font-weight: normal" :title="$t('http-firewall-rules-box@空字符串')">[{{$t("http-firewall-block-options-viewer@无")}}]</span>
				</span>
				
				<!-- description -->
				<span v-if="rule.description != null && rule.description.length > 0" class="grey small">（{{rule.description}}）</span>
				
				<a href="" :title="$t('http-firewall-rules-box@修改')" @click.prevent="updateRule(index, rule)"><i class="icon pencil small"></i></a>
				<a href="" :title="$t('http-firewall-rules-box@删除')" @click.prevent="removeRule(index)"><i class="icon remove"></i></a>
			</div>
			<div class="ui divider"></div>
		</div>
		<b-add-button @click="addRule()"></b-add-button>
</div>`
})

Vue.component("http-firewall-block-options", {
	props: ["v-block-options"],
	data: function () {
		return {
			options: this.vBlockOptions,
			statusCode: this.vBlockOptions.statusCode,
			timeout: this.vBlockOptions.timeout,
			timeoutMax: this.vBlockOptions.timeoutMax,
			isEditing: false
		}
	},
	watch: {
		statusCode: function (v) {
			let statusCode = parseInt(v)
			if (isNaN(statusCode)) {
				this.options.statusCode = 403
			} else {
				this.options.statusCode = statusCode
			}
		},
		timeout: function (v) {
			let timeout = parseInt(v)
			if (isNaN(timeout)) {
				this.options.timeout = 0
			} else {
				this.options.timeout = timeout
			}
		},
		timeoutMax: function (v) {
			let timeoutMax = parseInt(v)
			if (isNaN(timeoutMax)) {
				this.options.timeoutMax = 0
			} else {
				this.options.timeoutMax = timeoutMax
			}
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		}
	},
	template: `<div>
	<input type="hidden" name="blockOptionsJSON" :value="JSON.stringify(options)"/>
	<a href="" @click.prevent="edit">{{$t("server_http-firewall-block-options@状态码Colon")}} {{statusCode}} / {{$t("server_http-firewall-block-options@提示内容Colon")}}<span v-if="options.body != null && options.body.length > 0">{{$t("server_http-firewall-block-options@字符", [options.body.length])}}</span><span v-else class="disabled">{{$t("server_http-firewall-block-options@无")}}</span> <span v-if="timeout > 0">{{$t("server_http-firewall-block-options@slash封禁时长Colon")}} {{timeout}} {{$t("server_http-firewall-block-options@秒")}}</span>
	 <span v-if="timeoutMax > timeout">{{$t("server_http-firewall-block-options@slash最大封禁时长Colon")}} {{timeoutMax}} {{$t("server_http-firewall-block-options@秒")}}</span>
	 <span v-if="options.failBlockScopeAll">{{$t("server_http-firewall-block-options@slash尝试全局封禁")}}</span>
	 <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
	<table class="ui table" v-show="isEditing">
		<tr>
			<td class="title">{{$t("server_http-firewall-block-options@状态码")}}</td>
			<td>
				<input type="text" v-model="statusCode" style="width:4.5em" maxlength="3"/>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-firewall-block-options@提示内容")}}</td>
			<td>
				<textarea rows="3" v-model="options.body"></textarea>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-firewall-block-options@封禁时长")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="timeout" style="width: 5em" maxlength="6"/>
					<span class="ui label">{{$t("server_http-firewall-block-options@秒")}}</span>
				</div>
				<p class="comment">{{$t("server_http-firewall-block-options@封禁时长Help")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-firewall-block-options@最大封禁时长")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="timeoutMax" style="width: 5em" maxlength="6"/>
					<span class="ui label">{{$t("server_http-firewall-block-options@秒")}}</span>
				</div>
				<p class="comment">{{$t("server_http-firewall-block-options@最大封禁时长Help", [timeout])}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("server_http-firewall-block-options@失败全局封禁")}}</td>
			<td>
				<checkbox :v-value="1" v-model="options.failBlockScopeAll"></checkbox>
				<p class="comment">{{$t("server_http-firewall-block-options@失败全局封禁Help")}}</p>
			</td>
		</tr>
	</table>
</div>	
`
})

// 缓存条件列表
Vue.component("http-cache-refs-box", {
	props: ["v-cache-refs"],
	data: function () {
		let refs = this.vCacheRefs
		if (refs == null) {
			refs = []
		}
		return {
			refs: refs
		}
	},
	methods: {
		timeUnitName: function (unit) {
			switch (unit) {
				case "ms":
					return this.$t("http-cache-refs-box@毫秒")
				case "second":
					return this.$t("http-cache-refs-box@秒")
				case "minute":
					return this.$t("http-cache-refs-box@分钟")
				case "hour":
					return this.$t("http-cache-refs-box@小时")
				case "day":
					return this.$t("http-cache-refs-box@天")
				case "week":
					return this.$t("http-cache-refs-box@周")
			}
			return unit
		}
	},
	template: `<div>
	<input type="hidden" name="refsJSON" :value="JSON.stringify(refs)"/>
	
	<b-empty v-if="refs.length == 0">{{$t("http-cache-refs-box@暂时还没有缓存条件")}}</b-empty>
	<div v-show="refs.length > 0">
		<table class="ui table selectable celled">
			<thead>
				<tr>
					<th>{{$t("http-cache-refs-box@缓存条件")}}</th>
					<th class="width6">{{$t("http-cache-refs-box@缓存时间")}}</th>
				</tr>
				<tr v-for="(cacheRef, index) in refs">
					<td :class="{'color-border': cacheRef.conds != null && cacheRef.conds.connector == 'and', disabled: !cacheRef.isOn}" :style="{'border-left':cacheRef.isReverse ? '1px #db2828 solid' : ''}">
						<http-request-conds-view :v-conds="cacheRef.conds" :class="{disabled: !cacheRef.isOn}" v-if="cacheRef.conds != null && cacheRef.conds.groups != null"></http-request-conds-view>
							<http-request-cond-view :v-cond="cacheRef.simpleCond" v-if="cacheRef.simpleCond != null"></http-request-cond-view>
						
						<!-- 特殊参数 -->
						<grey-label v-if="cacheRef.key != null && cacheRef.key.indexOf('\${args}') < 0">{{$t("http-cache-refs-box@忽略URI参数")}}</grey-label>
						<grey-label v-if="cacheRef.minSize != null && cacheRef.minSize.count > 0">
							{{cacheRef.minSize.count}}{{cacheRef.minSize.unit}}
							<span v-if="cacheRef.maxSize != null && cacheRef.maxSize.count > 0">- {{cacheRef.maxSize.count}}{{cacheRef.maxSize.unit}}</span>
						</grey-label>
						<grey-label v-else-if="cacheRef.maxSize != null && cacheRef.maxSize.count > 0">0 - {{cacheRef.maxSize.count}}{{cacheRef.maxSize.unit}}</grey-label>
						<grey-label v-if="cacheRef.methods != null && cacheRef.methods.length > 0">{{cacheRef.methods.join(", ")}}</grey-label>
						<grey-label v-if="cacheRef.expiresTime != null && cacheRef.expiresTime.isPrior && cacheRef.expiresTime.isOn">Expires</grey-label>
						<grey-label v-if="cacheRef.status != null && cacheRef.status.length > 0 && (cacheRef.status.length > 1 || cacheRef.status[0] != 200)">{{$t("http-cache-refs-box@状态码")}}：{{cacheRef.status.map(function(v) {return v.toString()}).join(", ")}}</grey-label>
						<grey-label v-if="cacheRef.allowPartialContent">{{$t("http-cache-refs-box@分片缓存")}}</grey-label>
						<grey-label v-if="cacheRef.alwaysForwardRangeRequest">{{$t("http-cache-refs-box@Range回源")}}</grey-label>
						<grey-label v-if="cacheRef.enableIfNoneMatch">If-None-Match</grey-label>
						<grey-label v-if="cacheRef.enableIfModifiedSince">If-Modified-Since</grey-label>
						<grey-label v-if="cacheRef.enableReadingOriginAsync">{{$t("http-cache-refs-box@支持异步")}}</grey-label>
					</td>
					<td :class="{disabled: !cacheRef.isOn}">
						<span v-if="!cacheRef.isReverse">{{cacheRef.life.count}} {{timeUnitName(cacheRef.life.unit)}}</span>
						<span v-else class="red">{{$t("http-cache-refs-box@不缓存")}}</span>
					</td>
				</tr>
			</thead>
		</table>
	</div>
	<div class="margin"></div>
</div>`
})

Vue.component("sms-sender", {
	props: ["value", "name"],
	mounted: function () {
		this.initType(this.config.type)
	},
	data: function () {
		let config = this.value
		if (config == null) {
			config = {
				isOn: false,
				type: "webHook",
				webHookParams: {
					url: "",
					method: "POST"
				},
				aliyunSMSParams: {
					sign: "",
					templateCode: "",
					codeVarName: "code",
					accessKeyId: "",
					accessKeySecret: ""
				},
				tencentSMSParams: {
					sdkAppId: "",
					sign: "",
					templateId: "",
					accessKeyId: "",
					accessKeySecret: ""
				}
			}
		}

		if (config.aliyunSMSParams == null) {
			Vue.set(config, "aliyunSMSParams", {
				sign: "",
				templateCode: "",
				codeVarName: "code",
				accessKeyId: "",
				accessKeySecret: ""
			})
		}
		if (config.tencentSMSParams == null) {
			Vue.set(config, "tencentSMSParams",  {
				sdkAppId: "",
				sign: "",
				templateId: "",
				accessKeyId: "",
				accessKeySecret: ""
			})
		}

		return {
			config: config
		}
	},
	watch: {
		"config.type": function (v) {
			this.initType(v)
		}
	},
	methods: {
		initType: function (v) {
			// initialize params
			switch (v) {
				case "webHook":
					if (this.config.webHookParams == null) {
						this.config.webHookParams = {
							url: "",
							method: "POST"
						}
					}
					break
			}
		},
		test: function () {
			window.TESTING_SMS_CONFIG = this.config
			teaweb.popup("/users/setting/smsTest", {
				title: this.$t("sms-sender-plus@短信发送测试"),
				height: "22em"
			})
		}
	},
	template: `<div>
	<input type="hidden" :name="name" :value="JSON.stringify(config)"/>
	<div class="config-item">
		<div class="item-label">{{$t("sms-sender-plus@启用")}}</div>
		<div class="item-content"><checkbox :v-value="1" v-model="config.isOn"></checkbox></div>
	</div>

	<div v-show="config.isOn">
		<div class="config-item">
			<div class="item-label">{{$t("sms-sender-plus@发送渠道")}}</div>
			<div class="item-content">
				<b-select
					v-model="config.type"
					auto-width
					:options="[
						{label: $t('sms-sender-plus@自定义HTTP接口'), value: 'webHook'},
						{label: $t('sms-sender-plus@阿里云短信'), value: 'aliyunSMS'},
						{label: $t('sms-sender-plus@腾讯云短信'), value: 'tencentSMS'},
					]"
				></b-select>
				<p class="comment" v-if="config.type == 'webHook'">{{$t("sms-sender-plus@通过HTTP接口调用自定义短信")}}</p>
				<p class="comment" v-if="config.type == 'aliyunSMS'">{{$t("sms-sender-plus@通过阿里云短信服务发送短信")}}<strong>{{$t("sms-sender-plus@目前仅支持发送验证码")}}</strong>。</p>
				<p class="comment" v-if="config.type == 'tencentSMS'">{{$t("sms-sender-plus@通过腾讯云短信服务发送短信")}}<strong>{{$t("sms-sender-plus@目前仅支持发送验证码")}}</strong>。</p>
			</div>
		</div>

		<!-- webhook -->
		<div v-if="config.type == 'webHook' && config.webHookParams != null">
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@HTTP接口URL地址")}} *</div>
				<div class="item-content">
					<input type="text" maxlength="100" placeholder="https://..." v-model="config.webHookParams.url"/>
					<p class="comment">{{$t("sms-sender-plus@接收短信请求URL说明")}}<code-label>http://</code-label>{{$t("sms-sender-plus@或")}}<code-label>https://</code-label>{{$t("sms-sender-plus@开头")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@HTTP接口请求方法")}}</div>
				<div class="item-content">
					<b-select
						v-model="config.webHookParams.method"
						auto-width
						:options="[
							{label: 'GET', value: 'GET'},
							{label: 'POST', value: 'POST'},
						]"
					></b-select>
					<p class="comment" v-if="config.webHookParams.method == 'GET'">{{$t("sms-sender-plus@GET方法说明")}}（<code-label>YOUR_API_URL?mobile=手机号&amp;body=短信内容&code=验证码</code-label>)）{{$t("sms-sender-plus@调用HTTP接口状态码200成功")}}</p>
					<p class="comment" v-if="config.webHookParams.method == 'POST'">{{$t("sms-sender-plus@POST方法说明")}}（<code-label>mobile=手机号&amp;body=短信内容&code=验证码</code-label>）{{$t("sms-sender-plus@调用HTTP接口状态码200成功")}}</p>
				</div>
			</div>
		</div>

		<!-- aliyun sms -->
		<div v-if="config.type == 'aliyunSMS'">
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@签名名称")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.aliyunSMSParams.sign" maxlength="12"/>
					<p class="comment">{{$t("sms-sender-plus@阿里云签名管理说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@模板CODE")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.aliyunSMSParams.templateCode" maxlength="30"/>
					<p class="comment">{{$t("sms-sender-plus@阿里云模板管理说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@模板中验证码变量名")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.aliyunSMSParams.codeVarName" maxlength="30"/>
					<p class="comment">{{$t("sms-sender-plus@默认为")}}<code-label>code</code-label>{{$t("sms-sender-plus@无需带符号说明")}}<code-label>\${<span>{{ config.aliyunSMSParams.codeVarName }}</span>}</code-label>{{$t("sms-sender-plus@代表要发送的验证码")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@AccessKeyIDLabel")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.aliyunSMSParams.accessKeyId" maxlength="100"/>
					<p class="comment">{{$t("sms-sender-plus@阿里云RAMAccessKey说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label color-border">{{$t("sms-sender-plus@AccessKeySecretLabel")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.aliyunSMSParams.accessKeySecret" maxlength="100"/>
					<p class="comment">{{$t("sms-sender-plus@和AccessKeyID对应说明")}}</p>
				</div>
			</div>
		</div>

		<!-- tencent sms -->
		<div v-if="config.type == 'tencentSMS'">
			<div class="config-item">
				<div class="item-label">{{$t("sms-sender-plus@SDK应用ID")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.tencentSMSParams.sdkAppId" maxlength="30"/>
					<p class="comment">{{$t("sms-sender-plus@腾讯云SDK应用ID说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label">{{$t("sms-sender-plus@签名内容")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.tencentSMSParams.sign" maxlength="12"/>
					<p class="comment">{{$t("sms-sender-plus@腾讯云签名内容说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label">{{$t("sms-sender-plus@正文模板ID")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.tencentSMSParams.templateId" maxlength="50"/>
					<p class="comment">{{$t("sms-sender-plus@腾讯云正文模板ID说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label">{{$t("sms-sender-plus@密钥SecretId")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.tencentSMSParams.accessKeyId"/>
					<p class="comment">{{$t("sms-sender-plus@腾讯云SecretId说明")}}</p>
				</div>
			</div>
			<div class="config-item">
				<div class="item-label">{{$t("sms-sender-plus@密钥SecretKey")}} *</div>
				<div class="item-content">
					<input type="text" v-model="config.tencentSMSParams.accessKeySecret"/>
					<p class="comment">{{$t("sms-sender-plus@腾讯云SecretKey说明")}}</p>
				</div>
			</div>
		</div>

		<div class="config-item">
			<div class="item-label">{{$t("sms-sender-plus@发送测试")}}</div>
			<div class="item-content"><a href="" @click.prevent="test">{{$t("sms-sender-plus@点此测试")}}</a></div>
		</div>
	</div>
	<div class="margin"></div>
</div>`
})

Vue.component("email-sender", {
	props: ["value", "name"],
	data: function () {
		let value = this.value
		if (value == null) {
			value = {
				isOn: false,
				smtpHost: "",
				smtpPort: 0,
				username: "",
				password: "",
				fromEmail: "",
				fromName: ""
			}
		}
		let smtpPortString = value.smtpPort.toString()
		if (smtpPortString == "0") {
			smtpPortString = ""
		}

		return {
			config: value,
			smtpPortString: smtpPortString
		}
	},
	watch: {
		smtpPortString: function (v) {
			let port = parseInt(v)
			if (!isNaN(port)) {
				this.config.smtpPort = port
			}
		}
	},
	methods: {
		test: function () {
			window.TESTING_EMAIL_CONFIG = this.config
			teaweb.popup("/users/setting/emailTest", {
				title: this.$t("email-sender@邮件发送测试"),
				height: "36em"
			})
		}
	},
	template: `<div>
	<input type="hidden" :name="name" :value="JSON.stringify(config)"/>
	<div class="config-item">
		<div class="item-label">{{$t("email-sender@启用")}}</div>
		<div class="item-content"><checkbox :v-value="1" v-model="config.isOn"></checkbox></div>
	</div>

	<div v-show="config.isOn">
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@SMTP地址")}} *</div>
			<div class="item-content">
				<input type="text" :name="name + 'SmtpHost'" v-model="config.smtpHost"/>
				<p class="comment">{{$t("email-sender@SMTP主机地址说明")}}<code-label>smtp.qq.com</code-label>{{$t("email-sender@目前仅支持TLS")}}</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@SMTP端口")}} *</div>
			<div class="item-content">
				<input type="text" :name="name + 'SmtpPort'" v-model="smtpPortString" style="width: 5em" maxlength="5"/>
				<p class="comment">{{$t("email-sender@SMTP主机端口说明")}}<code-label>587</code-label>{{$t("email-sender@端口号示例2")}}<code-label>465</code-label>{{$t("email-sender@端口查询说明")}}</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@用户名")}} *</div>
			<div class="item-content">
				<input type="text" :name="name + 'Username'" v-model="config.username"/>
				<p class="comment">{{$t("email-sender@通常为发件人邮箱地址")}}</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@密码")}} *</div>
			<div class="item-content">
				<input type="password" :name="name + 'Password'" v-model="config.password"/>
				<p class="comment">{{$t("email-sender@邮箱登录密码或授权码说明")}}</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@发件人Email")}} *</div>
			<div class="item-content">
				<input type="text" :name="name + 'FromEmail'" v-model="config.fromEmail" maxlength="128"/>
				<p class="comment">{{$t("email-sender@发件人邮箱地址说明")}}</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@发件人名称")}}</div>
			<div class="item-content">
				<input type="text" :name="name + 'FromName'" v-model="config.fromName" maxlength="30"/>
				<p class="comment">{{$t("email-sender@发件人名称说明")}}<a href="/settings/ui" target="_blank">{{$t("email-sender@产品名称")}}</a>。</p>
			</div>
		</div>
		<div class="config-item">
			<div class="item-label">{{$t("email-sender@发送测试")}}</div>
			<div class="item-content"><a href="" @click.prevent="test">{{$t("email-sender@点此测试")}}</a></div>
		</div>
	</div>
	<div class="margin"></div>
</div>`
})

Vue.component("message-row", {
	props: ["v-message", "v-can-close"],
	data: function () {
		let paramsJSON = this.vMessage.params
		let params = null
		if (paramsJSON != null && paramsJSON.length > 0) {
			params = JSON.parse(paramsJSON)
		}

		return {
			message: this.vMessage,
			params: params,
			isClosing: false
		}
	},
	methods: {
		viewCert: function (certId) {
			teaweb.popup("/servers/certs/certPopup?certId=" + certId, {
				title: this.$t('messages_message-row@证书详情'),
				height: "28em",
				width: "48em"
			})
		},
		readMessage: function (messageId) {
			let that = this

			Tea.action("/messages/readPage")
				.params({"messageIds": [messageId]})
				.post()
				.success(function () {
					// 刷新父级页面Badge
					if (window.parent.Tea != null && window.parent.Tea.Vue != null) {
						window.parent.Tea.Vue.checkMessagesOnce()
					}

					// 刷新当前页面
					if (that.vCanClose && typeof (NotifyPopup) != "undefined") {
						that.isClosing = true
						setTimeout(function () {
							NotifyPopup({})
						}, 1000)
					} else {
						teaweb.reload()
					}
				})
		}
	},
	template: `<div class="b-site-message-container">
<table class="ui table selectable" v-if="!isClosing">
	<tr class="title-row" :class="{error: message.level == 'error', positive: message.level == 'success', warning: message.level == 'warning'}">
		<td style="position: relative">
			<strong>{{message.datetime}}</strong>
			<span v-if="message.cluster != null && message.cluster.id != null">
				<span> | </span>
				<a :href="'/clusters/cluster?clusterId=' + message.cluster.id" target="_top" v-if="message.role == 'node'">{{$t('messages_message-row@集群Prefix')}}{{message.cluster.name}}</a>
				<a :href="'/ns/clusters/cluster?clusterId=' + message.cluster.id" target="_top" v-if="message.role == 'dns'">{{$t('messages_message-row@DNS集群Prefix')}}{{message.cluster.name}}</a>
			</span>
			<span v-if="message.node != null && message.node.id != null">
				<span> | </span>
				<a :href="'/clusters/cluster/node?clusterId=' + message.cluster.id + '&nodeId=' + message.node.id" target="_top" v-if="message.role == 'node'">{{$t('messages_message-row@节点Prefix')}}{{message.node.name}}</a>
				<a :href="'/ns/clusters/cluster/node?clusterId=' + message.cluster.id + '&nodeId=' + message.node.id" target="_top" v-if="message.role == 'dns'">{{$t('messages_message-row@DNS节点Prefix')}}{{message.node.name}}</a>
			</span>
			<a href=""  style="position: absolute; right: 1em" @click.prevent="readMessage(message.id)" :title="$t('messages_message-row@标为已读Title')"><i class="icon check"></i></a>
		</td>
	</tr>
	<tr class="content-row" :class="{error: message.level == 'error', positive: message.level == 'success', warning: message.level == 'warning'}">
		<td>
			<pre style="padding: 0; margin:0; word-break: break-all;">{{message.body}}</pre>
			
			<!-- 健康检查 -->
			<div v-if="message.type == 'HealthCheckFailed'" style="margin-top: 0.8em">
				<a :href="'/clusters/cluster/node?clusterId=' + message.cluster.id + '&nodeId=' + param.node.id" v-for="param in params" class="ui label small basic" style="margin-bottom: 0.5em" target="_top">{{param.node.name}}: {{param.error}}</a>
			</div>
			
			<!-- 集群DNS设置 -->
			<div v-if="message.type == 'ClusterDNSSyncFailed'" style="margin-top: 0.8em">
				<a :href="'/dns/clusters/cluster?clusterId=' + message.cluster.id" target="_top">{{$t('messages_message-row@查看问题Link')}} &raquo;</a>
			</div>
			
			<!-- 证书即将过期 -->
			<div v-if="message.type == 'SSLCertExpiring'" style="margin-top: 0.8em">
				<a href="" @click.prevent="viewCert(params.certId)" target="_top">{{$t('messages_message-row@查看证书Link')}}</a><span v-if="params != null && params.acmeTaskId > 0"> &nbsp;|&nbsp; <a :href="'/servers/certs/acme'" target="_top">{{$t('messages_message-row@查看任务Link')}}&raquo;</a></span>
			</div>
			
			<!-- 证书续期成功 -->
			<div v-if="message.type == 'SSLCertACMETaskSuccess'" style="margin-top: 0.8em">
				<a href="" @click.prevent="viewCert(params.certId)" target="_top">{{$t('messages_message-row@查看证书Link')}}</a> &nbsp;|&nbsp; <a :href="'/servers/certs/acme'" v-if="params != null && params.acmeTaskId > 0" target="_top">{{$t('messages_message-row@查看任务Link')}}&raquo;</a>
			</div>
			
			<!-- 证书续期失败 -->
			<div v-if="message.type == 'SSLCertACMETaskFailed'" style="margin-top: 0.8em">
				<a href="" @click.prevent="viewCert(params.certId)" target="_top">{{$t('messages_message-row@查看证书Link')}}</a> &nbsp;|&nbsp; <a :href="'/servers/certs/acme'" v-if="params != null && params.acmeTaskId > 0" target="_top">{{$t('messages_message-row@查看任务Link')}}&raquo;</a>
			</div>
			
			<!-- 网站域名审核 -->
			<div v-if="message.type == 'serverNamesRequireAuditing'" style="margin-top: 0.8em">
				<a :href="'/servers/server/settings/serverNames?serverId=' + params.serverId" target="_top">{{$t('messages_message-row@去审核Link')}}</a></a>
			</div>

			<!-- 节点调度 -->
			<div v-if="message.type == 'NodeSchedule'" style="margin-top: 0.8em">
				<a :href="'/clusters/cluster/node/settings/schedule?clusterId=' + message.cluster.id + '&nodeId=' + message.node.id" target="_top">{{$t('messages_message-row@查看调度状态Link')}}&raquo;</a>
			</div>
			
			<!-- 节点租期结束 -->
			<div v-if="message.type == 'NodeOfflineDay'" style="margin-top: 0.8em">
				<a :href="'/clusters/cluster/node/detail?clusterId=' + message.cluster.id + '&nodeId=' + message.node.id" target="_top">{{$t('messages_message-row@查看详情Link')}}&raquo;</a>
			</div>
		</td>
	</tr>
</table>
<div class="margin"></div>
</div>`
})

Vue.component("message-media-selector", {
    props: ["v-media-type"],
    mounted: function () {
        let that = this
        Tea.action("/admins/recipients/mediaOptions")
            .post()
            .success(function (resp) {
                that.medias = resp.data.medias

                // 初始化简介
                if (that.mediaType.length > 0) {
                    let media = that.medias.$find(function (_, media) {
                        return media.type == that.mediaType
                    })
                    if (media != null) {
                        that.description = media.description
                    }
                }
            })
    },
    data: function () {
        let mediaType = this.vMediaType
        if (mediaType == null) {
            mediaType = ""
        }
        return {
            medias: [],
            description: "",
            mediaType: mediaType
        }
    },
    watch: {
        mediaType: function (v) {
            let media = this.medias.$find(function (_, media) {
                return media.type == v
            })
            if (media == null) {
                this.description = ""
            } else {
                this.description = media.description
            }
            this.$emit("change", media)
        },
    },
    template: `<div>
    <b-select
        name="mediaType"
        v-model="mediaType"
        auto-width
        :options="[
            {label: $t('选择媒介类型'), value: ''},
            ...medias.map(media => ({
            label: media.name??'',
            value: media.type??'',
            }))
        ]"
    ></b-select>
    <p class="comment" v-html="description"></p>
</div>`
})

Vue.component("message-recipient-group-selector", {
    props: ["v-groups"],
    data: function () {
        let groups = this.vGroups
        if (groups == null) {
            groups = []
        }
        let groupIds = []
        if (groups.length > 0) {
            groupIds = groups.map(function (v) {
                return v.id.toString()
            }).join(",")
        }

        return {
            groups: groups,
            groupIds: groupIds
        }
    },
    methods: {
        addGroup: function () {
            let that = this
            teaweb.popup("/admins/recipients/groups/selectPopup?groupIds=" + this.groupIds, {
                title: '选择分组',
                callback: function (resp) {
                    that.groups.push(resp.data.group)
                    that.update()
                }
            })
        },
        removeGroup: function (index) {
            this.groups.$remove(index)
            this.update()
        },
        update: function () {
            let groupIds = []
            if (this.groups.length > 0) {
                this.groups.forEach(function (v) {
                    groupIds.push(v.id)
                })
            }
            this.groupIds = groupIds.join(",")
        }
    },
    template: `<div>
    <input type="hidden" name="groupIds" :value="groupIds"/>
    <div v-if="groups.length > 0">
        <div>
            <div v-for="(group, index) in groups" class="ui label small basic">
                {{group.name}} &nbsp; <a href="" title="删除" @click.prevent="removeGroup(index)"><i class="icon remove"></i></a>
            </div>
        </div>
        <div class="ui divider"></div>
    </div>
    <b-add-button @click="addGroup()"></b-add-button>
</div>`
})

// 消息接收人设置
Vue.component("message-receivers-box", {
	props: ["v-node-cluster-id"],
	mounted: function () {
		let that = this
		Tea.action("/clusters/cluster/settings/message/selectedReceivers")
			.params({
				clusterId: this.clusterId
			})
			.post()
			.success(function (resp) {
				that.receivers = resp.data.receivers
			})
	},
	data: function () {
		let clusterId = this.vNodeClusterId
		if (clusterId == null) {
			clusterId = 0
		}
		return {
			clusterId: clusterId,
			receivers: []
		}
	},
	methods: {
		addReceiver: function () {
			let that = this
			let recipientIdStrings = []
			let groupIdStrings = []
			this.receivers.forEach(function (v) {
				if (v.type == "recipient") {
					recipientIdStrings.push(v.id.toString())
				} else if (v.type == "group") {
					groupIdStrings.push(v.id.toString())
				}
			})

			teaweb.popup("/clusters/cluster/settings/message/selectReceiverPopup?recipientIds=" + recipientIdStrings.join(",") + "&groupIds=" + groupIdStrings.join(","), {
				title: this.$t('选择接收人'),
				callback: function (resp) {
					that.receivers.push(resp.data)
				}
			})
		},
		removeReceiver: function (index) {
			this.receivers.$remove(index)
		}
	},
	template: `<div>
        <input type="hidden" name="receiversJSON" :value="JSON.stringify(receivers)"/>           
        <div v-if="receivers.length > 0">
            <div v-for="(receiver, index) in receivers" class="ui label basic small">
               <span v-if="receiver.type == 'group'">{{$t('分组')}}：</span>{{receiver.name}} <span class="grey small" v-if="receiver.subName != null && receiver.subName.length > 0">({{receiver.subName}})</span> &nbsp; <a href="" @click.prevent="removeReceiver(index)"><i class="icon remove"></i></a>
            </div>
             <div class="ui divider"></div>
        </div>
				<b-add-button @click="addReceiver"></b-add-button>
</div>`
})

Vue.component("message-media-instance-selector", {
    props: ["v-instance-id"],
    mounted: function () {
        let that = this
        Tea.action("/admins/recipients/instances/options")
            .post()
            .success(function (resp) {
                that.instances = resp.data.instances

                // 初始化简介
                if (that.instanceId > 0) {
                    let instance = that.instances.$find(function (_, instance) {
                        return instance.id == that.instanceId
                    })
                    if (instance != null) {
                        that.description = instance.description
                        that.update(instance.id)
                    }
                }
            })
    },
    data: function () {
        let instanceId = this.vInstanceId
        if (instanceId == null) {
            instanceId = 0
        }
        return {
            instances: [],
            description: "",
            instanceId: instanceId
        }
    },
    watch: {
        instanceId: function (v) {
            this.update(v)
        }
    },
    methods: {
        update: function (v) {
            let instance = this.instances.$find(function (_, instance) {
                return instance.id == v
            })
            if (instance == null) {
                this.description = ""
            } else {
                this.description = instance.description
            }
            this.$emit("change", instance)
        }
    },
    template: `<div>
    <b-select
        name="instanceId"
        v-model="instanceId"
        auto-width
        :options="[
            {label: $t('选择媒介'), value: '0'},
            ...instances.map(instance => ({
            label: (instance.name??'') + '（' + (instance.media.name??'') + '）',
            value: (instance.id??''),
            }))
        ]"
    ></b-select>
    <p class="comment" v-html="description"></p>
</div>`
})

Vue.component("plan-price-bandwidth-config-box", {
	props: ["v-plan-price-bandwidth-config"],
	data: function () {
		let config = this.vPlanPriceBandwidthConfig
		if (config == null) {
			config = {
				percentile: 95,
				base: 0,
				ranges: [],
				supportRegions: false
			}
		}

		if (config.ranges == null) {
			config.ranges = []
		}

		return {
			config: config,
			bandwidthPercentile: config.percentile,
			priceBase: config.base,
			isEditing: false
		}
	},
	watch: {
		priceBase: function (v) {
			let f = parseFloat(v)
			if (isNaN(f) || f < 0) {
				this.config.base = 0
			} else {
				this.config.base = f
			}
		},
		bandwidthPercentile: function (v) {
			let i = parseInt(v)
			if (isNaN(i) || i < 0) {
				this.config.percentile = 0
			} else {
				this.config.percentile = i
			}
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		}
	},
	template: `<div>
<input type="hidden" name="bandwidthPriceJSON" :value="JSON.stringify(config)"/>
<div>
	{{$t("plan-price-bandwidth-config-box-plus@带宽百分位")}}：<span v-if="config.percentile > 0">{{config.percentile}}th</span><span v-else class="disabled">{{$t("plan-price-bandwidth-config-box-plus@没有设置")}}</span> &nbsp; | &nbsp;
	{{$t("plan-price-bandwidth-config-box-plus@基础带宽价格")}}：<span v-if="config.base > 0">{{config.base}}{{$t("plan-price-bandwidth-config-box-plus@元PerMbps")}}</span><span v-else class="disabled">{{$t("plan-price-bandwidth-config-box-plus@没有设置")}}</span> &nbsp; | &nbsp; 
	{{$t("plan-price-bandwidth-config-box-plus@阶梯价格")}}：<span v-if="config.ranges.length > 0">{{config.ranges.length}}{{$t("plan-price-bandwidth-config-box-plus@段")}}</span><span v-else class="disabled">{{$t("plan-price-bandwidth-config-box-plus@没有设置")}}</span>  &nbsp; <span v-if="config.supportRegions">| &nbsp;{{$t("plan-price-bandwidth-config-box-plus@支持区域带宽计费")}}</span>
	<span v-if="config.bandwidthAlgo == 'avg'"> &nbsp;| &nbsp;{{$t("plan-price-bandwidth-config-box-plus@使用平均带宽算法")}}</span>
	<div style="margin-top: 0.5em">
		<a href="" @click.prevent="edit">{{$t("plan-price-bandwidth-config-box-plus@修改")}} <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
	</div>		
</div>
<div v-show="isEditing" style="margin-top: 0.5em">
	<table class="ui table definition selectable" style="margin-top: 0">
		<tr>
			<td class="title">{{$t("plan-price-bandwidth-config-box-plus@带宽百分位Label")}} *</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" style="width: 4em" maxlength="3" v-model="bandwidthPercentile"/>
					<span class="ui label">th</span>
				</div>
				<p class="comment">{{$t("plan-price-bandwidth-config-box-plus@带宽计费位置1到100")}}</p>
			</td>
		</tr>
		<tr>
			<td class="title">{{$t("plan-price-bandwidth-config-box-plus@基础带宽费用Label")}}</td>
			<td>
				<div class="ui input right labeled">
					<input type="text" v-model="priceBase" maxlength="10" style="width: 7em"/>
					<span class="ui label">{{$t("plan-price-bandwidth-config-box-plus@元PerMbps")}}</span>
				</div>
				<p class="comment">{{$t("plan-price-bandwidth-config-box-plus@无阶梯价格时使用此价格")}}</p>
			</td>
		</tr>	
		<tr>
			<td>{{$t("plan-price-bandwidth-config-box-plus@带宽阶梯价格Label")}}</td>
			<td>
				<plan-bandwidth-ranges v-model="config.ranges"></plan-bandwidth-ranges>
			</td>
		</tr>
		<tr>
			<td>{{$t("plan-price-bandwidth-config-box-plus@支持按区域带宽计费Label")}}</td>
			<td>
				<checkbox :v-value="1" v-model="config.supportRegions"></checkbox>
				<p class="comment">{{$t("plan-price-bandwidth-config-box-plus@选中后可根据区域设价格")}}</p>
			</td>
		</tr>
		<tr>
			<td>{{$t("plan-price-bandwidth-config-box-plus@带宽算法Label")}}</td>
			<td>
				<b-select
					v-model="config.bandwidthAlgo"
					auto-width
					:options="[
						{label: $t('plan-price-bandwidth-config-box-plus@峰值带宽'), value: 'secondly'},
						{label: $t('plan-price-bandwidth-config-box-plus@平均带宽'), value: 'avg'},
					]"
				></b-select>
				<p class="comment" v-if="config.bandwidthAlgo == 'secondly'">{{$t("plan-price-bandwidth-config-box-plus@峰值带宽说明")}}</p>
				<p class="comment" v-if="config.bandwidthAlgo == 'avg'">{{$t("plan-price-bandwidth-config-box-plus@平均带宽说明")}}<code-label>600MiB * 8bit/300s = 16Mbps</code-label>{{$t("plan-price-bandwidth-config-box-plus@平均带宽通常少很多")}}</p>
			</td>
		</tr>
	</table>
</div>	
</div>`
})

Vue.component("plan-bandwidth-ranges", {
	props: ["value"],
	data: function () {
		let ranges = this.value
		if (ranges == null) {
			ranges = []
		}
		return {
			ranges: ranges,
			isAdding: false,

			minMB: "",
			minMBUnit: "mb",

			maxMB: "",
			maxMBUnit: "mb",

			pricePerMB: "",
			totalPrice: "",
			addingRange: {
				minMB: 0,
				maxMB: 0,
				pricePerMB: 0,
				totalPrice: 0
			}
		}
	},
	methods: {
		add: function () {
			this.isAdding = !this.isAdding
			let that = this
			setTimeout(function () {
				that.$refs.minMB.focus()
			})
		},
		cancelAdding: function () {
			this.isAdding = false
		},
		confirm: function () {
			if (this.addingRange.minMB < 0) {
				teaweb.warn(this.$t("plan-bandwidth-ranges-plus@带宽下限需大于0"))
				return
			}
			if (this.addingRange.maxMB < 0) {
				teaweb.warn(this.$t("plan-bandwidth-ranges-plus@带宽上限需大于0"))
				return
			}
			if (this.addingRange.pricePerMB <= 0 && this.addingRange.totalPrice <= 0) {
				teaweb.warn(this.$t("plan-bandwidth-ranges-plus@请设单位价格或总价格"))
				return
			}

			this.isAdding = false
			this.minMB = ""
			this.maxMB = ""
			this.pricePerMB = ""
			this.totalPrice = ""
			this.ranges.push(this.addingRange)
			this.ranges.$sort(function (v1, v2) {
				if (v1.minMB < v2.minMB) {
					return -1
				}
				if (v1.minMB == v2.minMB) {
					if (v2.maxMB == 0 || v1.maxMB < v2.maxMB) {
						return -1
					}
					return 0
				}
				return 1
			})
			this.change()
			this.addingRange = {
				minMB: 0,
				maxMB: 0,
				pricePerMB: 0,
				totalPrice: 0
			}
		},
		remove: function (index) {
			this.ranges.$remove(index)
			this.change()
		},
		change: function () {
			this.$emit("change", this.ranges)
		},
		formatMB: function (mb) {
			return teaweb.formatBits(mb * 1024 * 1024)
		},
		changeMinMB: function (v) {
			let minMB = parseFloat(v.toString())
			if (isNaN(minMB) || minMB < 0) {
				minMB = 0
			}
			switch (this.minMBUnit) {
				case "gb":
					minMB *= 1024
					break
				case "tb":
					minMB *= 1024 * 1024
					break
			}
			this.addingRange.minMB = minMB
		},
		changeMaxMB: function (v) {
			let maxMB = parseFloat(v.toString())
			if (isNaN(maxMB) || maxMB < 0) {
				maxMB = 0
			}
			switch (this.maxMBUnit) {
				case "gb":
					maxMB *= 1024
					break
				case "tb":
					maxMB *= 1024 * 1024
					break
			}
			this.addingRange.maxMB = maxMB
		}
	},
	watch: {
		minMB: function (v) {
			this.changeMinMB(v)
		},
		minMBUnit: function () {
			this.changeMinMB(this.minMB)
		},
		maxMB: function (v) {
			this.changeMaxMB(v)
		},
		maxMBUnit: function () {
			this.changeMaxMB(this.maxMB)
		},
		pricePerMB: function (v) {
			let pricePerMB = parseFloat(v.toString())
			if (isNaN(pricePerMB) || pricePerMB < 0) {
				pricePerMB = 0
			}
			this.addingRange.pricePerMB = pricePerMB
		},
		totalPrice: function (v) {
			let totalPrice = parseFloat(v.toString())
			if (isNaN(totalPrice) || totalPrice < 0) {
				totalPrice = 0
			}
			this.addingRange.totalPrice = totalPrice
		}
	},
	template: `<div>
	<!-- 已有价格 -->
	<div v-if="ranges.length > 0">
		<div class="ui label basic small" v-for="(range, index) in ranges" style="margin-bottom: 0.5em">
			{{formatMB(range.minMB)}} - <span v-if="range.maxMB > 0">{{formatMB(range.maxMB)}}</span><span v-else>&infin;</span> &nbsp;  {{$t("plan-bandwidth-ranges-plus@价格Label")}}<span v-if="range.totalPrice > 0">{{range.totalPrice}}{{$t("plan-bandwidth-ranges-plus@元")}}</span><span v-else="">{{range.pricePerMB}}{{$t("plan-bandwidth-ranges-plus@元PerMbps")}}</span>
			&nbsp; <a href="" :title="$t('plan-bandwidth-ranges-plus@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	
	<!-- 添加 -->
	<div v-if="isAdding">
		<table class="ui table">
			<tr>
				<td class="title">{{$t("plan-bandwidth-ranges-plus@带宽下限Label")}} *</td>
				<td>
					<div class="ui fields inline">
						<div class="ui field">
							<input type="text" :placeholder="$t('plan-bandwidth-ranges-plus@最小带宽Placeholder')" style="width: 7em" maxlength="10" ref="minMB" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="minMB"/>
						</div>
						<div class="ui field">
							<b-select
								v-model="minMBUnit"
								:options="[
									{label: 'Mbps', value: 'mb'},
									{label: 'Gbps', value: 'gb'},
									{label: 'Tbps', value: 'tb'},
								]"
							></b-select>
						</div>
					</div>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-bandwidth-ranges-plus@带宽上限Label")}} *</td>
				<td>
					<div class="ui fields inline">
						<div class="ui field">
							<input type="text" :placeholder="$t('plan-bandwidth-ranges-plus@最大带宽Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="maxMB"/>
						</div>
						<div class="ui field">
							<b-select
								v-model="maxMBUnit"
								:options="[
									{label: 'Mbps', value: 'mb'},
									{label: 'Gbps', value: 'gb'},
									{label: 'Tbps', value: 'tb'},
								]"
							></b-select>
						</div>
					</div>
					<p class="comment">{{$t("plan-bandwidth-ranges-plus@填0表示上不封顶")}}</p>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-bandwidth-ranges-plus@单位价格Label")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" :placeholder="$t('plan-bandwidth-ranges-plus@单位价格Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="pricePerMB"/>
						<span class="ui label">{{$t("plan-bandwidth-ranges-plus@元PerMbps")}}</span>
					</div>
					<p class="comment">{{$t("plan-bandwidth-ranges-plus@和总价格二选一单位价格")}}</p>
				</td>
			</tr>
			<tr>
				<td>{{$t("plan-bandwidth-ranges-plus@总价格Label")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" :placeholder="$t('plan-bandwidth-ranges-plus@总价格Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="totalPrice"/>
						<span class="ui label">{{$t("plan-bandwidth-ranges-plus@元")}}</span>
					</div>
					<p class="comment">{{$t("plan-bandwidth-ranges-plus@固定总价格和单位价格二选一")}}</p>
				</td>
			</tr>
		</table>
		<button class="ui button small" type="button" @click.prevent="confirm">{{$t("plan-bandwidth-ranges-plus@确定")}}</button> &nbsp;
		<a href="" :title="$t('plan-bandwidth-ranges-plus@取消')" @click.prevent="cancelAdding"><i class="pi pi-times"></i></a>
	</div>
	
	<!-- 按钮 -->
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("plan-traffic-ranges", {
	props: ["value"],
	data: function () {
		let ranges = this.value
		if (ranges == null) {
			ranges = []
		}
		return {
			ranges: ranges,
			isAdding: false,

			minGB: "",
			minGBUnit: "gb",

			maxGB: "",
			maxGBUnit: "gb",

			pricePerGB: "",
			totalPrice: "",
			addingRange: {
				minGB: 0,
				maxGB: 0,
				pricePerGB: 0,
				totalPrice: 0
			}
		}
	},
	methods: {
		add: function () {
			this.isAdding = !this.isAdding
			let that = this
			setTimeout(function () {
				that.$refs.minGB.focus()
			})
		},
		cancelAdding: function () {
			this.isAdding = false
		},
		confirm: function () {
			if (this.addingRange.minGB < 0) {
				teaweb.warn(this.$t("plan-traffic-ranges-plus@流量下限需大于0"))
				return
			}
			if (this.addingRange.maxGB < 0) {
				teaweb.warn(this.$t("plan-traffic-ranges-plus@流量上限需大于0"))
				return
			}
			if (this.addingRange.pricePerGB <= 0 && this.addingRange.totalPrice <= 0) {
				teaweb.warn(this.$t("plan-traffic-ranges-plus@请设置单位价格或总价格"))
				return;
			}

			this.isAdding = false
			this.minGB = ""
			this.maxGB = ""
			this.pricePerGB = ""
			this.totalPrice = ""
			this.ranges.push(this.addingRange)
			this.ranges.$sort(function (v1, v2) {
				if (v1.minGB < v2.minGB) {
					return -1
				}
				if (v1.minGB == v2.minGB) {
					if (v2.maxGB == 0 || v1.maxGB < v2.maxGB) {
						return -1
					}
					return 0
				}
				return 1
			})
			this.change()
			this.addingRange = {
				minGB: 0,
				maxGB: 0,
				pricePerGB: 0,
				totalPrice: 0
			}
		},
		remove: function (index) {
			this.ranges.$remove(index)
			this.change()
		},
		change: function () {
			this.$emit("change", this.ranges)
		},
		formatGB: function (gb) {
			return teaweb.formatBytes(gb * 1024 * 1024 * 1024)
		},
		changeMinGB: function (v) {
			let minGB = parseFloat(v.toString())
			if (isNaN(minGB) || minGB < 0) {
				minGB = 0
			}
			switch (this.minGBUnit) {
				case "tb":
					minGB *= 1024
					break
				case "pb":
					minGB *= 1024 * 1024
					break
				case "eb":
					minGB *= 1024 * 1024 * 1024
					break
			}
			this.addingRange.minGB = minGB
		},
		changeMaxGB: function (v) {
			let maxGB = parseFloat(v.toString())
			if (isNaN(maxGB) || maxGB < 0) {
				maxGB = 0
			}
			switch (this.maxGBUnit) {
				case "tb":
					maxGB *= 1024
					break
				case "pb":
					maxGB *= 1024 * 1024
					break
				case "eb":
					maxGB *= 1024 * 1024 * 1024
					break
			}
			this.addingRange.maxGB = maxGB
		}
	},
	watch: {
		minGB: function (v) {
			this.changeMinGB(v)
		},
		minGBUnit: function (v) {
			this.changeMinGB(this.minGB)
		},
		maxGB: function (v) {
			this.changeMaxGB(v)
		},
		maxGBUnit: function (v) {
			this.changeMaxGB(this.maxGB)
		},
		pricePerGB: function (v) {
			let pricePerGB = parseFloat(v.toString())
			if (isNaN(pricePerGB) || pricePerGB < 0) {
				pricePerGB = 0
			}
			this.addingRange.pricePerGB = pricePerGB
		},
		totalPrice: function (v) {
			let totalPrice = parseFloat(v.toString())
			if (isNaN(totalPrice) || totalPrice < 0) {
				totalPrice = 0
			}
			this.addingRange.totalPrice = totalPrice
		}
	},
	template: `<div>
	<!-- 已有价格 -->
	<div v-if="ranges.length > 0">
		<div class="ui label basic small" v-for="(range, index) in ranges" style="margin-bottom: 0.5em">
			{{formatGB(range.minGB)}} - <span v-if="range.maxGB > 0">{{formatGB(range.maxGB)}}</span><span v-else>&infin;</span> &nbsp;  {{$t("plan-traffic-ranges-plus@价格Label")}}<span v-if="range.totalPrice > 0">{{range.totalPrice}}{{$t("plan-traffic-ranges-plus@元")}}</span><span v-else="">{{range.pricePerGB}}{{$t("plan-traffic-ranges-plus@元PerGB")}}</span>
			&nbsp; <a href="" :title="$t('plan-traffic-ranges-plus@删除')" @click.prevent="remove(index)"><i class="pi pi-times"></i></a>
		</div>
		<div class="ui divider"></div>
	</div>
	
	<!-- 添加 -->
	<div v-if="isAdding">
		<table class="ui table">
			<tr>
				<td class="title">{{$t("plan-traffic-ranges-plus@流量下限Label")}} *</td>
				<td>
					<div class="ui fields inline">
						<div class="ui field">
							<input type="text" :placeholder="$t('plan-traffic-ranges-plus@最小流量Placeholder')" style="width: 7em" maxlength="10" ref="minGB" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="minGB"/>
						</div>
						<div class="ui field">
							<b-select
								v-model="minGBUnit"
								:options="[
									{label: 'GB', value: 'gb'},
									{label: 'TB', value: 'tb'},
									{label: 'PB', value: 'pb'},
									{label: 'EB', value: 'eb'},
								]"
							></b-select>

						</div>
					</div>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-traffic-ranges-plus@流量上限Label")}} *</td>
				<td>
					<div class="ui fields inline">
						<div class="ui field">
							<input type="text" :placeholder="$t('plan-traffic-ranges-plus@最大流量Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="maxGB"/>
						</div>
						<div class="ui field">
							<b-select
								v-model="maxGBUnit"
								:options="[
									{label: 'GB', value: 'gb'},
									{label: 'TB', value: 'tb'},
									{label: 'PB', value: 'pb'},
									{label: 'EB', value: 'eb'},
								]"
							></b-select>

						</div>
					</div>
					<p class="comment">{{$t("plan-traffic-ranges-plus@如果填0表示上不封顶")}}</p>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-traffic-ranges-plus@单位价格Label")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" :placeholder="$t('plan-traffic-ranges-plus@单位价格Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="pricePerGB"/>
						<span class="ui label">{{$t("plan-traffic-ranges-plus@元PerGB")}}</span>
					</div>
					<p class="comment">{{$t("plan-traffic-ranges-plus@和总价格二选一单位价格说明")}}</p>
				</td>
			</tr>
			<tr>
				<td>{{$t("plan-traffic-ranges-plus@总价格Label")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" :placeholder="$t('plan-traffic-ranges-plus@总价格Placeholder')" style="width: 7em" maxlength="10" @keyup.enter="confirm()" @keypress.enter.prevent="1" v-model="totalPrice"/>
						<span class="ui label">{{$t("plan-traffic-ranges-plus@元")}}</span>
					</div>
					<p class="comment">{{$t("plan-traffic-ranges-plus@固定总价格和单位价格二选一")}}</p>
				</td>
			</tr>
		</table>
		<button class="ui button small" type="button" @click.prevent="confirm">{{$t("plan-traffic-ranges-plus@确定")}}</button> &nbsp;
		<a href="" :title="$t('plan-traffic-ranges-plus@取消')" @click.prevent="cancelAdding"><i class="pi pi-times"></i></a>
	</div>
	
	<!-- 按钮 -->
	<div v-if="!isAdding">
		<b-add-button @click="add"></b-add-button>
	</div>
</div>`
})

Vue.component("plan-bandwidth-limit-view", {
	props: ["value"],
	template: `<div style="font-size: 0.8em; color: grey" v-if="value != null && value.bandwidthLimitPerNode != null && value.bandwidthLimitPerNode.count > 0">
	带宽限制：<bandwidth-size-capacity-view :v-value="value.bandwidthLimitPerNode"></bandwidth-size-capacity-view>
</div>`
})

// 套餐价格配置
Vue.component("plan-price-config-box", {
	props: ["v-price-type", "v-monthly-price", "v-seasonally-price", "v-yearly-price", "v-traffic-price", "v-bandwidth-price", "v-disable-period"],
	data: function () {
		let priceType = this.vPriceType
		if (priceType == null) {
			priceType = "bandwidth"
		}

		// 按时间周期计费
		let monthlyPriceNumber = 0
		let monthlyPrice = this.vMonthlyPrice
		if (monthlyPrice == null || monthlyPrice <= 0) {
			monthlyPrice = ""
		} else {
			monthlyPrice = monthlyPrice.toString()
			monthlyPriceNumber = parseFloat(monthlyPrice)
			if (isNaN(monthlyPriceNumber)) {
				monthlyPriceNumber = 0
			}
		}

		let seasonallyPriceNumber = 0
		let seasonallyPrice = this.vSeasonallyPrice
		if (seasonallyPrice == null || seasonallyPrice <= 0) {
			seasonallyPrice = ""
		} else {
			seasonallyPrice = seasonallyPrice.toString()
			seasonallyPriceNumber = parseFloat(seasonallyPrice)
			if (isNaN(seasonallyPriceNumber)) {
				seasonallyPriceNumber = 0
			}
		}

		let yearlyPriceNumber = 0
		let yearlyPrice = this.vYearlyPrice
		if (yearlyPrice == null || yearlyPrice <= 0) {
			yearlyPrice = ""
		} else {
			yearlyPrice = yearlyPrice.toString()
			yearlyPriceNumber = parseFloat(yearlyPrice)
			if (isNaN(yearlyPriceNumber)) {
				yearlyPriceNumber = 0
			}
		}

		// 按流量计费
		let trafficPrice = this.vTrafficPrice
		let trafficPriceBaseNumber = 0
		if (trafficPrice != null) {
			trafficPriceBaseNumber = trafficPrice.base
		} else {
			trafficPrice = {
				base: 0
			}
		}
		let trafficPriceBase = ""
		if (trafficPriceBaseNumber > 0) {
			trafficPriceBase = trafficPriceBaseNumber.toString()
		}

		// 按带宽计费
		let bandwidthPrice = this.vBandwidthPrice
		if (bandwidthPrice == null) {
			bandwidthPrice = {
				percentile: 95,
				ranges: []
			}
		} else if (bandwidthPrice.ranges == null) {
			bandwidthPrice.ranges = []
		}

		return {
			priceType: priceType,
			monthlyPrice: monthlyPrice,
			seasonallyPrice: seasonallyPrice,
			yearlyPrice: yearlyPrice,

			monthlyPriceNumber: monthlyPriceNumber,
			seasonallyPriceNumber: seasonallyPriceNumber,
			yearlyPriceNumber: yearlyPriceNumber,

			trafficPriceBase: trafficPriceBase,
			trafficPrice: trafficPrice,

			bandwidthPrice: bandwidthPrice,
			bandwidthPercentile: bandwidthPrice.percentile
		}
	},
	methods: {
		changeBandwidthPriceRanges: function (ranges) {
			this.bandwidthPrice.ranges = ranges
		}
	},
	watch: {
		monthlyPrice: function (v) {
			let price = parseFloat(v)
			if (isNaN(price)) {
				price = 0
			}
			this.monthlyPriceNumber = price
		},
		seasonallyPrice: function (v) {
			let price = parseFloat(v)
			if (isNaN(price)) {
				price = 0
			}
			this.seasonallyPriceNumber = price
		},
		yearlyPrice: function (v) {
			let price = parseFloat(v)
			if (isNaN(price)) {
				price = 0
			}
			this.yearlyPriceNumber = price
		},
		trafficPriceBase: function (v) {
			let price = parseFloat(v)
			if (isNaN(price)) {
				price = 0
			}
			this.trafficPrice.base = price
		},
		bandwidthPercentile: function (v) {
			let percentile = parseInt(v)
			if (isNaN(percentile) || percentile <= 0) {
				percentile = 95
			} else if (percentile > 100) {
				percentile = 100
			}
			this.bandwidthPrice.percentile = percentile
		}
	},
	template: `<div>
	<input type="hidden" name="priceType" :value="priceType"/>
	<input type="hidden" name="monthlyPrice" :value="monthlyPriceNumber"/>
	<input type="hidden" name="seasonallyPrice" :value="seasonallyPriceNumber"/>
	<input type="hidden" name="yearlyPrice" :value="yearlyPriceNumber"/>
	<input type="hidden" name="trafficPriceJSON" :value="JSON.stringify(trafficPrice)"/>
	<input type="hidden" name="bandwidthPriceJSON" :value="JSON.stringify(bandwidthPrice)"/>
	
	<div>
		<radio :v-value="'bandwidth'" :value="priceType" v-model="priceType">&nbsp;{{$t("plan-price-config-box-plus@按带宽")}}</radio> &nbsp;
		<radio :v-value="'traffic'" :value="priceType" v-model="priceType">&nbsp;{{$t("plan-price-config-box-plus@按流量")}}</radio> &nbsp;
		<radio :v-value="'period'" :value="priceType" v-model="priceType" v-show="typeof(vDisablePeriod) != 'boolean' || !vDisablePeriod">&nbsp;{{$t("plan-price-config-box-plus@按时间周期")}}</radio>
	</div>
	
	<!-- 按时间周期 -->
	<div v-show="priceType == 'period'">
		<div class="ui divider"></div>
		<table class="ui table">
			<tr>
				<td class="title">{{$t("plan-price-config-box-plus@月度价格")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 7em" maxlength="10" v-model="monthlyPrice"/>
						<span class="ui label">{{$t("plan-price-config-box-plus@元")}}</span>
					</div>
					<p class="comment">{{$t("plan-price-config-box-plus@如果为0表示免费")}}</p>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-price-config-box-plus@季度价格")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 7em" maxlength="10" v-model="seasonallyPrice"/>
						<span class="ui label">{{$t("plan-price-config-box-plus@元")}}</span>
					</div>
					<p class="comment">{{$t("plan-price-config-box-plus@如果为0表示免费")}}</p>
				</td>
			</tr>
			<tr>
				<td class="title">{{$t("plan-price-config-box-plus@年度价格")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 7em" maxlength="10" v-model="yearlyPrice"/>
						<span class="ui label">{{$t("plan-price-config-box-plus@元")}}</span>
					</div>
					<p class="comment">{{$t("plan-price-config-box-plus@如果为0表示免费")}}</p>
				</td>
			</tr>
		</table>
	</div>
	
	<!-- 按流量 -->
	<div v-show="priceType =='traffic'">
		<div class="ui divider"></div>
		<table class="ui table">
			<tr>
				<td class="title">{{$t("plan-price-config-box-plus@基础流量费用Label")}} *</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" v-model="trafficPriceBase" maxlength="10" style="width: 7em"/>
						<span class="ui label">{{$t("plan-price-config-box-plus@元PerGB")}}</span>
					</div>
				</td>
			</tr>
		</table>
	</div>
	
	<!-- 按带宽 -->
	<div v-show="priceType == 'bandwidth'">
		<div class="ui divider"></div>
		<table class="ui table">
			<tr>
				<td class="title">{{$t("plan-price-config-box-plus@带宽百分位Label")}} *</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" style="width: 4em" maxlength="3" v-model="bandwidthPercentile"/>
						<span class="ui label">th</span>
					</div>
				</td>
			</tr>
			<tr>
				<td>{{$t("plan-price-config-box-plus@带宽价格Label")}}</td>
				<td>
					<plan-bandwidth-ranges v-model="bandwidthPrice.ranges" @change="changeBandwidthPriceRanges"></plan-bandwidth-ranges>
				</td>
			</tr>
		</table>
	</div>
</div>`
})

// 显示流量限制说明
Vue.component("plan-limit-view", {
	props: ["value", "v-single-mode"],
	data: function () {
		let config = this.value

		let hasLimit = false
		if (!this.vSingleMode) {
			if (config.trafficLimit != null && config.trafficLimit.isOn && ((config.trafficLimit.dailySize != null && config.trafficLimit.dailySize.count > 0) || (config.trafficLimit.monthlySize != null && config.trafficLimit.monthlySize.count > 0))) {
				hasLimit = true
			} else if (config.dailyRequests > 0 || config.monthlyRequests > 0) {
				hasLimit = true
			}
		}

		return {
			config: config,
			hasLimit: hasLimit
		}
	},
	methods: {
		formatNumber: function (n) {
			return teaweb.formatNumber(n)
		},
		composeCapacity: function (capacity) {
			return teaweb.convertSizeCapacityToString(capacity)
		}
	},
	template: `<div style="font-size: 0.8em; color: grey">
	<div class="ui divider" v-if="hasLimit"></div>
	<div v-if="config.trafficLimit != null && config.trafficLimit.isOn">
		<span v-if="config.trafficLimit.dailySize != null && config.trafficLimit.dailySize.count > 0">{{$t("plan-limit-view-plus@日流量限制")}}：{{composeCapacity(config.trafficLimit.dailySize)}}<br/></span>
		<span v-if="config.trafficLimit.monthlySize != null && config.trafficLimit.monthlySize.count > 0">{{$t("plan-limit-view-plus@月流量限制")}}：{{composeCapacity(config.trafficLimit.monthlySize)}}<br/></span>
	</div>
	<div v-if="config.dailyRequests > 0">{{$t("plan-limit-view-plus@单日请求数限制")}}：{{formatNumber(config.dailyRequests)}}</div>
	<div v-if="config.monthlyRequests > 0">{{$t("plan-limit-view-plus@单月请求数限制")}}：{{formatNumber(config.monthlyRequests)}}</div>
	<div v-if="config.dailyWebsocketConnections > 0">{{$t("plan-limit-view-plus@单日Websocket限制")}}：{{formatNumber(config.dailyWebsocketConnections)}}</div>
	<div v-if="config.monthlyWebsocketConnections > 0">{{$t("plan-limit-view-plus@单月Websocket限制")}}：{{formatNumber(config.monthlyWebsocketConnections)}}</div>
	<div v-if="config.maxUploadSize != null && config.maxUploadSize.count > 0">{{$t("plan-limit-view-plus@文件上传限制")}}：{{composeCapacity(config.maxUploadSize)}}</div>
</div>`
})

Vue.component("plan-price-traffic-config-box", {
	props: ["v-plan-price-traffic-config"],
	data: function () {
		let config = this.vPlanPriceTrafficConfig
		if (config == null) {
			config = {
				base: 0,
				ranges: [],
				supportRegions: false
			}
		}

		if (config.ranges == null) {
			config.ranges = []
		}

		return {
			config: config,
			priceBase: config.base,
			isEditing: false
		}
	},
	watch: {
		priceBase: function (v) {
			let f = parseFloat(v)
			if (isNaN(f) || f < 0) {
				this.config.base = 0
			} else {
				this.config.base = f
			}
		}
	},
	methods: {
		edit: function () {
			this.isEditing = !this.isEditing
		}
	},
	template: `<div>
	<input type="hidden" name="trafficPriceJSON" :value="JSON.stringify(config)"/>
	<div>
		{{$t("plan-price-traffic-config-box-plus@基础流量价格")}}：<span v-if="config.base > 0">{{config.base}}{{$t("plan-price-traffic-config-box-plus@元PerGB")}}</span><span v-else class="disabled">{{$t("plan-price-traffic-config-box-plus@没有设置")}}</span> &nbsp; | &nbsp; 
		{{$t("plan-price-traffic-config-box-plus@阶梯价格")}}：<span v-if="config.ranges.length > 0">{{config.ranges.length}}{{$t("plan-price-traffic-config-box-plus@段")}}</span><span v-else class="disabled">{{$t("plan-price-traffic-config-box-plus@没有设置")}}</span>  &nbsp; <span v-if="config.supportRegions">| &nbsp;{{$t("plan-price-traffic-config-box-plus@支持区域流量计费")}}</span>
		<div style="margin-top: 0.5em">
			<a href="" @click.prevent="edit">{{$t("plan-price-traffic-config-box-plus@修改")}} <i class="icon angle" :class="{up: isEditing, down: !isEditing}"></i></a>
		</div>		
	</div>
	<div v-show="isEditing" style="margin-top: 0.5em">
		<table class="ui table definition selectable" style="margin-top: 0">
			<tr>
				<td class="title">{{$t("plan-price-traffic-config-box-plus@基础流量费用Label")}}</td>
				<td>
					<div class="ui input right labeled">
						<input type="text" v-model="priceBase" maxlength="10" style="width: 7em"/>
						<span class="ui label">{{$t("plan-price-traffic-config-box-plus@元PerGB")}}</span>
					</div>
					<p class="comment">{{$t("plan-price-traffic-config-box-plus@无阶梯价格时使用此价格")}}</p>
				</td>
			</tr>
			<tr>
				<td>{{$t("plan-price-traffic-config-box-plus@流量阶梯价格Label")}}</td>
				<td>
					<plan-traffic-ranges v-model="config.ranges"></plan-traffic-ranges>
				</td>
			</tr>
			<tr>
				<td>{{$t("plan-price-traffic-config-box-plus@支持按区域流量计费Label")}}</td>
				<td>
					<checkbox :v-value="1" v-model="config.supportRegions"></checkbox>
					<p class="comment">{{$t("plan-price-traffic-config-box-plus@选中后可设区域价格并用流量包")}}</p>
				</td>
			</tr>
		</table>
	</div>
</div>`
})

Vue.component("plan-price-view", {
	props: ["v-plan"],
	data: function () {
		return {
			plan: this.vPlan
		}
	},
	template: `<div>
	 <span v-if="plan.priceType == 'period'">
	 	{{$t("plan-price-view@按时间周期计费")}} 
	 	<div>
	 		<span class="grey small">
				<span v-if="plan.monthlyPrice > 0">{{$t("plan-price-view@月度")}}：￥{{plan.monthlyPrice}}{{$t("plan-price-view@元")}}<br/></span>
				<span v-if="plan.seasonallyPrice > 0">{{$t("plan-price-view@季度")}}：￥{{plan.seasonallyPrice}}{{$t("plan-price-view@元")}}<br/></span>
				<span v-if="plan.yearlyPrice > 0">{{$t("plan-price-view@年度")}}：￥{{plan.yearlyPrice}}{{$t("plan-price-view@元")}}</span>
			</span>
		</div>
	</span>
	<span v-if="plan.priceType == 'traffic'">
		{{$t("plan-price-view@按流量计费")}} 
		<div>
			<span class="grey small">{{$t("plan-price-view@基础价格")}}：￥{{plan.trafficPrice.base}}{{$t("plan-price-view@元PerGiB")}}</span>
		</div>
	</span>
	<div v-if="plan.priceType == 'bandwidth' && plan.bandwidthPrice != null && plan.bandwidthPrice.percentile > 0">
		{{$t("plan-price-view@按Nth带宽计费",[plan.bandwidthPrice.percentile])}}
		<div>
			<div v-for="range in plan.bandwidthPrice.ranges">
				<span class="small grey">{{range.minMB}} - <span v-if="range.maxMB > 0">{{range.maxMB}}MiB</span><span v-else>&infin;</span>： <span v-if="range.totalPrice > 0">{{range.totalPrice}}{{$t("plan-price-view@元")}}</span><span v-else="">{{range.pricePerMB}}{{$t("plan-price-view@元PerMiB")}}</span></span>
			</div>
		</div>
	</div>
</div>`
})

Vue.component("plan-user-selector", {
	props: ["v-user-id"],
	data: function () {
		return {}
	},
	methods: {
		change: function (userId) {
			this.$emit("change", userId)
		}
	},
	template: `<div>
	<user-selector :v-user-id="vUserId" data-url="/plans/users/options" @change="change"></user-selector>
</div>`
})

Vue.component("admin-selector", {
    props: ["v-admin-id"],
    mounted: function () {
        let that = this
        Tea.action("/admins/options")
            .post()
            .success(function (resp) {
                that.admins = resp.data.admins
            })
    },
    data: function () {
        let adminId = this.vAdminId
        if (adminId == null) {
            adminId = 0
        }
        return {
            admins: [],
            adminId: adminId
        }
    },
    template: `
    <div>
        <b-select
            id="adminId"
            name="adminId"
            v-model="adminId"
            auto-width
            :options="[
                {label: $t('admins_admin-selector@选择系统用户'), value: '0'},
                ...admins.map(admin => ({
                    label: admin.name + '（' + (admin.username??'') + '）',
                    value: admin.id??'',
                }))
            ]"
        ></b-select>
    </div>`
})

Vue.component("api-node-selector", {
	props: [],
	data: function () {
		return {}
	},
	template: `<div>
	{{$t('api-node_api-node-selector@暂未实现')}}
</div>`
})

Vue.component("api-node-addresses-box", {
	props: ["v-addrs", "v-name"],
	data: function () {
		let addrs = this.vAddrs
		if (addrs == null) {
			addrs = []
		}
		return {
			addrs: addrs
		}
	},
	methods: {
		// 添加IP地址
		addAddr: function () {
			let that = this;
			teaweb.popup("/settings/api/node/createAddrPopup", {
				title: this.$t('api-node_api-node-addresses-box@添加访问地址'),
				height: "16em",
				callback: function (resp) {
					that.addrs.push(resp.data.addr);
				}
			})
		},

		// 修改地址
		updateAddr: function (index, addr) {
			let that = this;
			window.UPDATING_ADDR = addr
			teaweb.popup("/settings/api/node/updateAddrPopup?addressId=", {
				title: this.$t('api-node_api-node-addresses-box@修改访问地址'),
				callback: function (resp) {
					Vue.set(that.addrs, index, resp.data.addr);
				}
			})
		},

		// 删除IP地址
		removeAddr: function (index) {
			this.addrs.$remove(index);
		}
	},
	template: `<div>
	<input type="hidden" :name="vName" :value="JSON.stringify(addrs)"/>
	<div v-if="addrs.length > 0">
		<div>
			<div v-for="(addr, index) in addrs" class="ui label small basic">
				{{addr.protocol}}://{{addr.host.quoteIP()}}:{{addr.portRange}}</span>
				<a href="" :title="$t('api-node_api-node-addresses-box@修改Title')" @click.prevent="updateAddr(index, addr)"><i class="icon pencil small"></i></a>
				<a href="" :title="$t('api-node_api-node-addresses-box@删除Title')" @click.prevent="removeAddr(index)"><i class="icon remove"></i></a>
			</div>
		</div>
		<div class="ui divider"></div>
	</div>
	<div>
		<b-add-button @click="addAddr"></b-add-button>
	</div>
</div>`
})

Vue.component("traffic-map-box", {
	props: ["v-stats", "v-is-attack"],
	mounted: function () {
		this.render()
	},
	data: function () {
		let maxPercent = 0
		let isAttack = this.vIsAttack
		this.vStats.forEach((v) => {
			let percent = parseFloat(v.percent)
			if (percent > maxPercent) {
				maxPercent = percent
			}

			v.formattedCountRequests = teaweb.formatCount(v.countRequests) + this.$t('maps_traffic-map-box@次Postfix')
			v.formattedCountAttackRequests = teaweb.formatCount(v.countAttackRequests) + this.$t('maps_traffic-map-box@次Postfix')
		})

		if (maxPercent < 100) {
			maxPercent *= 1.2 // 不要让某一项100%
		}

		let screenIsNarrow = window.innerWidth < 512

		return {
			isAttack: isAttack,
			stats: this.vStats,
			chart: null,
			minOpacity: 0.2,
			maxPercent: maxPercent,
			selectedCountryName: "",
			screenIsNarrow: screenIsNarrow
		}
	},
	methods: {
		render: function () {
			if (this.$el.offsetWidth < 300) {
				let that = this
				setTimeout(function () {
					that.render()
				}, 100)
				return
			}

			this.chart = teaweb.initChart(document.getElementById("traffic-map-box"));
			let that = this
			this.chart.setOption({
				// backgroundColor: "white",
				grid: {
					top: 0,
					bottom: 0,
					left: 0,
					right: 0
				},
				roam: false,
				tooltip: {
					backgroundColor: getCssVariable('--color-bg', '#app'),
					borderColor: getCssVariable('--color-border', '#app'),
					textStyle: {
						color: getCssVariable('--color-text-active', '#app'),
					},
					padding: [10, 15],
					trigger: "item",
				},
				series: [{
					type: "map",
					map: "world",
					zoom: 1.3,
					selectedMode: false,
					itemStyle: {
						areaColor: "#E9F0F9",
						borderColor: "#DDD"
					},
					label: {
						show: false,
						fontSize: "10px",
						color: "#fff",
						backgroundColor: "#8B9BD3",
						padding: [2, 2, 2, 2]
					},
					emphasis: {
						itemStyle: {
							areaColor: "#8B9BD3",
							opacity: 1.0
						},
						label: {
							show: true,
							fontSize: "10px",
							color: "#fff",
							backgroundColor: "#8B9BD3",
							padding: [2, 2, 2, 2]
						}
					},
					//select: {itemStyle:{ areaColor: "#8B9BD3", opacity: 0.8 }},
					tooltip: {
						backgroundColor: getCssVariable('--color-bg', '#app'),
						borderColor: getCssVariable('--color-border', '#app'),
						textStyle: {
							color: getCssVariable('--color-text-active', '#app'),
						},
						formatter: function (args) {
							let name = args.name
							let stat = null
							th