Tea.context(function () {
  this.csrftoken = "";

  const axiosApi = axios.create({
    baseURL: "/",
    headers: {
      "Content-Type": "application/json",
      "Authorization": this.csrftoken,
      "Accept": "application/json",
    },
  })

  // 获取csrf token
  const getCsrftoken = function () {
    return new Promise((resolve, reject) => {
      Tea.action("/csrf/token")
        .get()
        .success(function (resp) {
          resolve(resp.data.token)
        })
    })
  }

  // 获取网站详情 /servers/server/settings
  const getServerSettings = function (serverId) {
    return new Promise((resolve, reject) => {
      axiosApi.get("/servers/server/settings?serverId=" + serverId)
        .then(function (resp) {
          resolve(resp.data)
        })
        .catch(function (error) {
          reject(error)
        })
    })
  }

  const api = {
    getCsrftoken: getCsrftoken,
    getServerSettings: getServerSettings,
  }



  getCsrftoken().then((token) => {
    console.log("csrftoken", token);
    console.log("getServerSettings -> this.serverId", this.serverId)
    getServerSettings(this.serverId).then((data) => {
      console.log("serverSettings", data);
    })
  })


});